/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Expressions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.CustomFieldPrincipalType;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.QPin;
import org.cyclos.entities.access.QToken;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QBasicUser;
import org.cyclos.entities.users.QMobilePhone;
import org.cyclos.entities.users.QProductMyTokenType;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.QProductUserTokenType;
import org.cyclos.entities.users.QUserCustomFieldValue;
import org.cyclos.entities.users.QUserImage;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.UserPrincipals;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.GuestSessionData;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ImageVOConverter;
import org.cyclos.impl.users.LocateUserOption;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.conversion.VOFiller;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.validations.PropertyValidations;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.UserStatusException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.PrincipalVO;
import org.cyclos.model.access.tokens.TokenStatus;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.LocateUserException;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorDetailedVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UserLocatorHandlerImpl
extends BaseNetworkedHandlerImpl
implements UserLocatorHandler {
    private static final QBasicUser bu = QBasicUser.basicUser;
    private static final QUserCustomFieldValue fv = QUserCustomFieldValue.userCustomFieldValue;
    private static final QMobilePhone mp = QMobilePhone.mobilePhone;
    private static final QPin pin = QPin.pin;
    private static final QToken t = QToken.token;
    private static final Pattern INVALID_USERNAME = Pattern.compile("\\s|\\:");
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    @Lazy
    private UserServiceLocal userService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public LocateUserResult locate(Network network, UserLocatorVO userLocatorVO) throws FrameworkException {
        return this.locate(network, userLocatorVO, null, null, null);
    }

    public LocateUserResult locate(Network network, UserLocatorVO userLocatorVO, Set<LocateUserOption> set) throws FrameworkException {
        return this.locate(network, userLocatorVO, set, null, null);
    }

    public LocateUserResult locate(Network network, UserLocatorVO userLocatorVO, Set<LocateUserOption> set, Collection<PrincipalType> collection, PrincipalType principalType) throws FrameworkException {
        return this.doLocate(network, userLocatorVO, false, set, collection, principalType);
    }

    public LocateUserResult locate(UserLocatorVO userLocatorVO) throws FrameworkException {
        return this.locate(userLocatorVO, null, null, null);
    }

    public LocateUserResult locate(UserLocatorVO userLocatorVO, Set<LocateUserOption> set) throws FrameworkException {
        return this.locate(userLocatorVO, set, null, null);
    }

    public LocateUserResult locate(UserLocatorVO userLocatorVO, Set<LocateUserOption> set, Collection<PrincipalType> collection, PrincipalType principalType) {
        return this.doLocate(this.getSessionData().getNetwork(), userLocatorVO, true, set, collection, principalType);
    }

    public VOFiller<BasicUserVO> newVOFiller() {
        return new VOFiller<BasicUserVO>(BasicUserVO.class){

            public BasicUserVO add(Long l) {
                throw new IllegalActionException();
            }

            protected List<BasicUserVO> fetch(Set<Long> set) {
                QBasicUser qBasicUser = QBasicUser.basicUser;
                QUserImage qUserImage = QUserImage.userImage;
                SessionData sessionData = UserLocatorHandlerImpl.this.getSessionData();
                MutableBoolean mutableBoolean = new MutableBoolean();
                List<BasicUserVO> list = ((DBQuery)((DBQuery)UserLocatorHandlerImpl.this.from(new EntityPath[]{qBasicUser}).leftJoin((EntityPath)qBasicUser.image(), (Path)qUserImage)).where((Predicate)qBasicUser.id.in(set))).stream(new Expression[]{qBasicUser.id, qBasicUser.displayForManagers, qBasicUser.displayForOthers, qBasicUser.operatorUserId, qBasicUser.brokerIds, qUserImage.id, qUserImage.name, qUserImage.convertedToJpeg, qUserImage.contentType, qUserImage.width, qUserImage.height, qUserImage.length, qUserImage.key, qUserImage.lastModified}).map(tuple -> {
                    Long l;
                    Long l2 = (Long)tuple.get((Expression)qBasicUser.id);
                    String string = StringHelper.trimToNull((Object)QueryHelper.getUserDisplay((SessionData)sessionData, (Long)l2, (String)((String)tuple.get((Expression)qBasicUser.brokerIds)), (String)((String)tuple.get((Expression)qBasicUser.displayForManagers)), (String)((String)tuple.get((Expression)qBasicUser.displayForOthers))));
                    if (string == null) {
                        string = UserLocatorHandlerImpl.this.message(GeneralKeys.Ui.USER, new Object[0]);
                    }
                    UserVO userVO = (l = (Long)tuple.get((Expression)qBasicUser.operatorUserId)) == null ? new UserVO() : new OperatorVO();
                    userVO.setId(l2);
                    userVO.setDisplay(string);
                    if (userVO instanceof UserVO) {
                        if (UserLocatorHandlerImpl.this.profileFieldHandler.isVisible((ProfileField)BasicProfileField.IMAGE, (String)tuple.get((Expression)qBasicUser.brokerIds))) {
                            userVO.setImage(UserLocatorHandlerImpl.this.toImageVO(qUserImage, (Tuple)tuple));
                        }
                    } else if (userVO instanceof OperatorVO) {
                        ((OperatorVO)userVO).setUser((UserVO)this.add(l, UserVO.class));
                        mutableBoolean.setTrue();
                    }
                    return userVO;
                }).collect(Collectors.toList());
                if (mutableBoolean.booleanValue()) {
                    this.fill();
                }
                return list;
            }
        };
    }

    public BasicUser toBasicUserOrCurrent(BasicUserVO basicUserVO) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)basicUserVO);
        if (basicUser == null) {
            basicUser = this.getLoggedBasicUser();
        }
        if (basicUser == null) {
            throw new LocateUserException();
        }
        return basicUser;
    }

    public User toUserOrCurrent(BasicUserVO basicUserVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)basicUserVO);
        if (user == null) {
            user = this.getLoggedUser();
        }
        if (user == null) {
            throw new LocateUserException();
        }
        return user;
    }

    private Predicate addUserStatusCondition(EnumPath<UserStatus> enumPath, Set<UserStatus> set) {
        return set != null ? enumPath.in(set) : Expressions.TRUE.isTrue();
    }

    private LocateUserResult doLocate(Network network, UserLocatorVO userLocatorVO, boolean bl, Set<LocateUserOption> set, Collection<PrincipalType> collection, PrincipalType principalType) throws ValidationException, LocateUserException {
        PrincipalType principalType2;
        LocateUserResult locateUserResult;
        boolean bl2;
        SessionData sessionData = this.getSessionData();
        boolean bl3 = set != null && set.contains(LocateUserOption.FOR_ACCESS);
        boolean bl4 = set != null && set.contains(LocateUserOption.IGNORE_HIDDEN);
        boolean bl5 = set != null && set.contains(LocateUserOption.ACTIVE_ONLY);
        boolean bl6 = set != null && set.contains(LocateUserOption.ACCOUNT_OWNER_ONLY);
        boolean bl7 = set != null && set.contains(LocateUserOption.STATUS_EXCEPTION);
        boolean bl8 = set != null && set.contains(LocateUserOption.RECORD_FAILURE);
        boolean bl9 = set != null && set.contains(LocateUserOption.INVERSE_RELATION);
        boolean bl10 = bl2 = set != null && set.contains(LocateUserOption.ENFORCE_CHANNEL);
        PrincipalType principalType3 = bl5 ? EnumSet.of(UserStatus.ACTIVE) : (bl6 ? EnumSet.copyOf(AccountServiceLocal.POSSIBLE_STATUSES_TO_OWN_ACCOUNTS) : null);
        String string = "locate:" + (principalType3 != null ? principalType3.stream().map(Enum::name).collect(Collectors.joining("_")) : "") + UserLocatorHandler.asString((UserLocatorVO)userLocatorVO);
        try {
            locateUserResult = (LocateUserResult)InvocationContext.ensure().getAttribute((Object)string, () -> this.performLocate(sessionData, network, userLocatorVO, collection, principalType, (Set<UserStatus>)principalType3));
            locateUserResult.reAttach(this.rawEntityManagerHandler.getEntityManager());
            BasicUser basicUser = locateUserResult.getBasicUser();
            if (sessionData.isLoggedIn() && sessionData.getLoggedBasicUser().equals((Object)basicUser) || sessionData.unwrap() instanceof GuestSessionData && basicUser.getId().equals(((GuestSessionData)sessionData.unwrap()).getPublicRegisteredUserId()) || sessionData.isLoggedIn() && sessionData.getLoggedBasicUser().equals((Object)basicUser.getRegisteredBy())) {
                return locateUserResult;
            }
            Object object = principalType2 = principalType3 == null ? EnumSet.of(UserStatus.ACTIVE) : principalType3;
            if (bl3) {
                principalType2.add((UserStatus)UserStatus.BLOCKED);
                principalType2.add((UserStatus)UserStatus.DISABLED);
                principalType2.add((UserStatus)UserStatus.PENDING);
            } else if (principalType3 == null) {
                principalType2.add((UserStatus)UserStatus.BLOCKED);
                boolean bl11 = false;
                boolean bl12 = false;
                boolean bl13 = false;
                boolean bl14 = false;
                if (basicUser instanceof Operator) {
                    bl13 = bl14 = sessionData.manages(basicUser);
                    bl12 = bl14;
                    bl11 = bl14;
                } else {
                    bl11 = sessionData.hasPermission(Permission.DISABLED_USERS_VIEW);
                    bl12 = sessionData.hasPermission(Permission.PENDING_USERS_VIEW);
                    bl13 = sessionData.hasPermission(Permission.REMOVED_USERS_VIEW);
                    bl14 = sessionData.hasPermission(Permission.PURGED_USERS_VIEW);
                }
                if (bl11) {
                    principalType2.add(UserStatus.DISABLED);
                }
                if (bl12) {
                    principalType2.add(UserStatus.PENDING);
                }
                if (bl13) {
                    principalType2.add(UserStatus.REMOVED);
                }
                if (bl14) {
                    principalType2.add(UserStatus.PURGED);
                }
            }
            if (!principalType2.contains(basicUser.getStatus())) {
                if (bl7) {
                    throw new UserStatusException(basicUser.getStatus());
                }
                this.throwNotFoundException(userLocatorVO);
            }
            if (!bl3) {
                if (bl && (bl9 && !this.authHandler.relatesTo(basicUser, sessionData.getLoggedBasicUser()) || !bl9 && !sessionData.relatesTo(basicUser))) {
                    this.throwNotFoundException(userLocatorVO);
                }
                PrincipalType principalType4 = locateUserResult.getPrincipalType();
                if (!bl4) {
                    ProfileField profileField = this.profileFieldHandler.getProfileFieldFor(principalType4);
                    if (profileField != null) {
                        if (!this.profileFieldHandler.isAllowed(basicUser, profileField, ProfileFieldAction.VIEW)) {
                            this.throwNotFoundException(userLocatorVO);
                        }
                    } else if (principalType4 instanceof TokenPrincipalType) {
                        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)principalType4;
                        if (!sessionData.getProducts().userManagement().getUserTokenTypes().containsKey((Object)tokenPrincipalType)) {
                            this.throwNotFoundException(userLocatorVO);
                        }
                    }
                }
                if (bl && !bl4 && principalType4 != null) {
                    ExistingBuiltInPrincipalType existingBuiltInPrincipalType = ExistingBuiltInPrincipalType.getByInternalName((String)principalType4.getInternalName());
                    boolean bl15 = false;
                    if (existingBuiltInPrincipalType == ExistingBuiltInPrincipalType.EMAIL) {
                        bl15 = this.profileFieldHandler.isHidden(basicUser, (ProfileField)BasicProfileField.EMAIL, null);
                    } else if (existingBuiltInPrincipalType == ExistingBuiltInPrincipalType.MOBILE_PHONE) {
                        bl15 = this.profileFieldHandler.isHidden(basicUser, (ProfileField)BasicProfileField.PHONE, (Object)locateUserResult.getMobilePhone());
                    } else if (principalType4 instanceof CustomFieldPrincipalType) {
                        bl15 = this.profileFieldHandler.isHidden(basicUser, (ProfileField)locateUserResult.getCustomFieldValue().getField(), (Object)locateUserResult.getCustomFieldValue());
                    }
                    if (bl15 && !this.profileFieldHandler.canViewHidden(basicUser)) {
                        this.throwNotFoundException(userLocatorVO);
                    }
                }
            }
            if (bl8) {
                this.failedActionHandler.clearUserFailures(FailedAction.FAILED_USER_LOCATION, sessionData.getLoggedBasicUser());
            }
        }
        catch (LocateUserException locateUserException) {
            if (bl8) {
                this.failedActionHandler.recordAndBlockUserIfMaxReached(FailedAction.FAILED_USER_LOCATION, sessionData.getLoggedBasicUser(), sessionData.getConfiguration().getInvalidPosPayerAttempts(), UserAlertType.MAX_USER_LOCALIZATION_ATTEMPTS_REACHED);
            }
            throw locateUserException;
        }
        if (!bl3) {
            boolean bl16 = true;
            principalType2 = locateUserResult.getPrincipalType();
            ProductsAccessor productsAccessor = bl2 ? this.productsHandler.getAccessor(locateUserResult.getBasicUser(), sessionData.getChannel(), principalType2) : this.productsHandler.getAccessor(locateUserResult.getBasicUser());
            ProfileField profileField = this.profileFieldHandler.getProfileFieldFor(principalType2);
            if (profileField != null) {
                bl16 = this.profileFieldHandler.isEnabled(locateUserResult.getBasicUser(), profileField);
            } else if (principalType2 instanceof TokenPrincipalType) {
                TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)principalType2;
                QProductMyTokenType qProductMyTokenType = QProductMyTokenType.productMyTokenType;
                bl16 = productsAccessor.member().getMyTokenTypes().isSet((Object)tokenPrincipalType, (Path)qProductMyTokenType.enable);
            }
            if (!bl16) {
                this.throwNotFoundException(userLocatorVO, principalType2);
            }
        }
        return locateUserResult;
    }

    private LocateUserResult doLocateByAccountNumber(SessionData sessionData, PrincipalType principalType, Network network, String string, Set<UserStatus> set) {
        Account account = this.accountService.findByNumber(string);
        if (!(account instanceof UserAccount)) {
            this.throwNotFoundException(string);
        }
        UserAccount userAccount = (UserAccount)account;
        this.ensureUserStatus(set, userAccount.getUser().getStatus(), () -> this.throwNotFoundException(string));
        return this.getLocateUserResult((UserPrincipal)userAccount, string);
    }

    private LocateUserResult doLocateByEmail(SessionData sessionData, BuiltInPrincipalType builtInPrincipalType, Network network, String string, Set<UserStatus> set) {
        if (PropertyValidations.email().validate(null, null, (Object)string) != null) {
            this.throwNotFoundException(string);
        }
        if (!sessionData.getConfiguration().isEmailUnique()) {
            this.throwNotFoundException(string, (PrincipalType)builtInPrincipalType);
        }
        BasicUser basicUser = (BasicUser)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{bu}).leftFetchHint(new Path[]{bu, bu.image()}).where(new Predicate[]{network == null ? bu.network().isNull() : bu.network().eq((Object)network), UserLocatorHandlerImpl.bu.email.equalsIgnoreCase(string), this.addUserStatusCondition((EnumPath<UserStatus>)UserLocatorHandlerImpl.bu.status, set)})).orderBy(UserLocatorHandlerImpl.bu.status.asc())).singleResult((Expression)bu);
        return this.getLocateUserResult(basicUser == null ? null : UserPrincipals.email((BasicUser)basicUser), string);
    }

    private LocateUserResult doLocateByFieldValue(SessionData sessionData, CustomFieldPrincipalType customFieldPrincipalType, Network network, String string, Set<UserStatus> set) {
        String string2;
        UserCustomField userCustomField = customFieldPrincipalType.getCustomField();
        Integer n = null;
        if (userCustomField.getType() == CustomFieldType.INTEGER) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwNotFoundException(string);
            }
        } else {
            string2 = userCustomField.getPattern();
            if (userCustomField.getType() == CustomFieldType.STRING && StringHelper.isNotBlank((Object)string2)) {
                string = MaskHelper.removeMask((String)string2, (String)string);
            }
        }
        string2 = (UserCustomFieldValue)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{fv}).leftFetchHint(new Path[]{fv, fv.owner(), fv.owner().image()}).where(new Predicate[]{network == null ? fv.owner().network().isNull() : fv.owner().network().eq((Object)network), fv.field().eq((Object)userCustomField), n == null ? UserLocatorHandlerImpl.fv.stringValue.equalsIgnoreCase(string) : UserLocatorHandlerImpl.fv.integerValue.eq((Object)n), this.addUserStatusCondition((EnumPath<UserStatus>)UserLocatorHandlerImpl.fv.owner().status, set)})).orderBy(UserLocatorHandlerImpl.fv.owner().status.asc())).singleResult((Expression)fv);
        return this.getLocateUserResult((UserPrincipal)string2, string);
    }

    private LocateUserResult doLocateById(SessionData sessionData, Network network, Long l, Set<UserStatus> set) {
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser != null && basicUser.getId().equals(l)) {
            return new LocateUserResult(basicUser);
        }
        BasicUser basicUser2 = (BasicUser)this.rawEntityManagerHandler.find(BasicUser.class, l);
        if (!(sessionData.isSystem() || basicUser2.isAdmin() && this.groupsHandler.getAccessibleGlobalGroups().contains(((User)basicUser2).getGroup()) || Objects.equals(network, basicUser2.getNetwork()))) {
            this.throwNotFoundException(l);
        }
        this.ensureUserStatus(set, basicUser2.getStatus(), () -> this.throwNotFoundException(l));
        return new LocateUserResult(basicUser2);
    }

    private LocateUserResult doLocateByMobilePhone(SessionData sessionData, PrincipalType principalType, Network network, String string, Set<UserStatus> set) {
        PhoneNumberDescriptor phoneNumberDescriptor;
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        if (!configurationAccessor.isMobileUnique()) {
            this.throwNotFoundException(string, principalType);
        }
        if ((phoneNumberDescriptor = this.phoneNumberHandler.parse(string, configurationAccessor)) == null) {
            this.throwNotFoundException(string);
        }
        MobilePhone mobilePhone = (MobilePhone)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{mp}).leftFetchHint(new Path[]{mp, mp.user(), mp.user().image()}).where(new Predicate[]{network == null ? mp.user().network().isNull() : mp.user().network().eq((Object)network), UserLocatorHandlerImpl.mp.normalizedNumber.eq((Object)phoneNumberDescriptor.toE164()), this.addUserStatusCondition((EnumPath<UserStatus>)UserLocatorHandlerImpl.mp.user().status, set)})).orderBy(UserLocatorHandlerImpl.mp.user().status.asc())).singleResult((Expression)mp);
        return this.getLocateUserResult((UserPrincipal)mobilePhone, string);
    }

    private LocateUserResult doLocateByPin(SessionData sessionData, Network network, String string, Collection<PrincipalType> collection, Set<UserStatus> set) {
        try {
            Pin pin = (Pin)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{UserLocatorHandlerImpl.pin}).leftFetchHint(new Path[]{UserLocatorHandlerImpl.pin, UserLocatorHandlerImpl.pin.user(), UserLocatorHandlerImpl.pin.user().image()}).where(new Predicate[]{network == null ? UserLocatorHandlerImpl.pin.user().network().isNull() : UserLocatorHandlerImpl.pin.user().network().eq((Object)network), UserLocatorHandlerImpl.pin.pinPrincipal.eq((Object)string), UserLocatorHandlerImpl.pin.channel().eq((Object)sessionData.getChannel()), collection == null ? UserLocatorHandlerImpl.pin.id.isNull() : UserLocatorHandlerImpl.pin.principalType().in(collection)})).singleResult((Expression)UserLocatorHandlerImpl.pin);
            if (pin != null) {
                this.ensureUserStatus(set, pin.getUser().getStatus(), this::throwEntityNotFoundException);
            }
            return this.getLocateUserResult((UserPrincipal)pin, string);
        }
        catch (NonUniqueResultException | EntityNotFoundException throwable) {
            this.throwNotFoundException("#");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private LocateUserResult doLocateByPrincipal(SessionData sessionData, Network network, String string, String string2, Collection<PrincipalType> collection, PrincipalType principalType, Set<UserStatus> set) {
        Object object2;
        string = StringHelper.trimToNull((Object)string);
        List<PrincipalType> list = new ArrayList<PrincipalType>();
        if (collection == null) {
            if (sessionData.isSystem()) {
                list = this.principalTypeService.listAll();
            } else {
                object2 = sessionData.getProducts();
                BooleanPropertiesHolder object4 = object2.product().getUserProfileFields();
                HashSet hashSet = new HashSet(this.profileFieldHandler.getMatchingFields(object4, QProductUserProfileField.productUserProfileField.userFilter));
                hashSet.addAll(this.profileFieldHandler.getMatchingFields(object4, QProductUserProfileField.productUserProfileField.userKeywords));
                if (sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_USER)) {
                    list.addAll(sessionData.getChannelSettingsAccessor().getPayment().getPrincipalTypes());
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ProfileField profileField = (ProfileField)iterator.next();
                    PrincipalType principalType2 = this.profileFieldHandler.principalTypeFor(profileField);
                    if (principalType2 == null) continue;
                    list.add(principalType2);
                }
                Set set2 = object2.userManagement().getUserTokenTypes().keysSet((Path)QProductUserTokenType.productUserTokenType.view);
                list.addAll(set2);
            }
        } else {
            list.addAll(collection);
        }
        if ("*".equals(string)) {
            string = null;
            principalType = null;
        } else if (StringHelper.isBlank((Object)string)) {
            String string3 = string = principalType == null ? null : principalType.getInternalName();
        }
        if (StringHelper.isNotBlank((Object)string)) {
            void var10_13;
            object2 = null;
            Object var10_11 = null;
            try {
                object2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                object2 = null;
            }
            for (PrincipalType principalType3 : list) {
                if (!principalType3.getInternalName().equals(string) && (object2 == null || !principalType3.getId().equals(this.applicationHandler.getIdMask().remove((Long)object2)))) continue;
                PrincipalType principalType4 = principalType3;
                break;
            }
            if (var10_13 == null) {
                this.throwNotFoundException(string2);
            }
            list.retainAll(Collections.singleton(var10_13));
        }
        this.principalTypeService.sort(list);
        for (PrincipalType principalType5 : list) {
            try {
                switch (principalType5.getNature()) {
                    case BUILT_IN: {
                        switch (ExistingBuiltInPrincipalType.getByInternalName((String)principalType5.getInternalName())) {
                            case USERNAME: {
                                return this.doLocateByUsername(sessionData, (BuiltInPrincipalType)principalType5, network, string2, set);
                            }
                            case EMAIL: {
                                return this.doLocateByEmail(sessionData, (BuiltInPrincipalType)principalType5, network, string2, set);
                            }
                            case MOBILE_PHONE: {
                                return this.doLocateByMobilePhone(sessionData, principalType5, network, string2, set);
                            }
                            case ACCOUNT_NUMBER: {
                                return this.doLocateByAccountNumber(sessionData, principalType5, network, string2, set);
                            }
                        }
                        break;
                    }
                    case CUSTOM_FIELD: {
                        return this.doLocateByFieldValue(sessionData, (CustomFieldPrincipalType)principalType5, network, string2, set);
                    }
                    case TOKEN: 
                    case NFC_TOKEN: {
                        return this.doLocateByToken(sessionData, (TokenPrincipalType)principalType5, network, string2, set);
                    }
                }
            }
            catch (NonUniqueResultException | EntityNotFoundException throwable) {}
        }
        this.throwNotFoundException(string2);
        return null;
    }

    private LocateUserResult doLocateByToken(SessionData sessionData, TokenPrincipalType tokenPrincipalType, Network network, String string, Set<UserStatus> set) {
        String string2;
        if (!tokenPrincipalType.getTokenType().isNFC()) {
            string2 = tokenPrincipalType.getTokenMask();
            string = MaskHelper.removeMask((String)string2, (String)string);
        }
        string2 = (Token)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{t}).leftFetchHint(new Path[]{t, t.user(), t.user().image()}).where(new Predicate[]{network == null ? t.type().network().isNull() : t.type().network().eq((Object)network), t.type().eq((Object)tokenPrincipalType), UserLocatorHandlerImpl.t.value.eq((Object)string), this.addUserStatusCondition((EnumPath<UserStatus>)UserLocatorHandlerImpl.t.user().status, set)})).orderBy(UserLocatorHandlerImpl.t.user().status.asc())).singleResult((Expression)t);
        return this.getLocateUserResult((UserPrincipal)string2, string);
    }

    private LocateUserResult doLocateByUsername(SessionData sessionData, BuiltInPrincipalType builtInPrincipalType, Network network, String string, Set<UserStatus> set) {
        if (StringHelper.isBlank((Object)string) || INVALID_USERNAME.matcher(string).find()) {
            this.throwNotFoundException(string);
        }
        BasicUser basicUser = (BasicUser)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{bu}).leftFetchHint(new Path[]{bu, bu.image()}).where(new Predicate[]{network == null ? bu.network().isNull() : bu.network().eq((Object)network), UserLocatorHandlerImpl.bu.username.equalsIgnoreCase(string), this.addUserStatusCondition((EnumPath<UserStatus>)UserLocatorHandlerImpl.bu.status, set)})).orderBy(UserLocatorHandlerImpl.bu.status.asc())).singleResult((Expression)bu);
        return this.getLocateUserResult(basicUser == null ? null : UserPrincipals.username((BasicUser)basicUser), string);
    }

    private void ensureUserStatus(Set<UserStatus> set, UserStatus userStatus, Runnable runnable) throws LocateUserException {
        if (set != null && !set.contains(userStatus)) {
            runnable.run();
        }
    }

    private LocateUserResult getLocateUserResult(UserPrincipal userPrincipal, String string) {
        if (userPrincipal == null) {
            this.throwNotFoundException(string);
        }
        Pin pin = (Pin)ObjectHelper.ifType((Object)userPrincipal, Pin.class);
        PrincipalType principalType = userPrincipal.getPrincipalType();
        if (string == null) {
            string = userPrincipal.getPrincipal();
        }
        if (StringHelper.isBlank((Object)string)) {
            this.throwNotFoundException(string, principalType);
        }
        switch (principalType.getNature()) {
            case ACCESS_CLIENT: {
                this.throwNotFoundException(string, principalType);
                break;
            }
            case BUILT_IN: {
                switch (((BuiltInPrincipalType)principalType).getBuiltInType()) {
                    case ACCOUNT_NUMBER: {
                        Account account = this.accountService.load((InternalAccountOwner)userPrincipal.getBasicUser().getUser(), (AccountType)userPrincipal.getAccountType());
                        userPrincipal = (UserAccount)account;
                        if (this.accountService.isActive((IAccount)account)) break;
                        this.throwNotFoundException(string, principalType);
                        break;
                    }
                    case EMAIL: {
                        if (this.configurationHandler.getAccessor(userPrincipal.getBasicUser()).isEmailUnique()) break;
                        this.throwNotFoundException(string, principalType);
                        break;
                    }
                    case MOBILE_PHONE: {
                        if (this.configurationHandler.getAccessor(userPrincipal.getBasicUser()).isMobileUnique()) break;
                        this.throwNotFoundException(string, principalType);
                        break;
                    }
                    case USERNAME: {
                        break;
                    }
                    case TRUSTED_DEVICE: {
                        if (userPrincipal instanceof Pin) break;
                        this.throwNotFoundException(string, principalType);
                    }
                }
                break;
            }
            case CUSTOM_FIELD: {
                break;
            }
            case TOKEN: 
            case NFC_TOKEN: {
                Token token = userPrincipal.getToken();
                if (token.getUser() != null && token.getStatus() == TokenStatus.ACTIVE) break;
                this.throwNotFoundException(string, principalType);
            }
        }
        return new LocateUserResult(userPrincipal, pin, this.getLocator(userPrincipal, string));
    }

    private UserLocatorDetailedVO getLocator(UserPrincipal userPrincipal, String string) {
        String string2;
        PrincipalType principalType = userPrincipal.getPrincipalType();
        String string3 = principalType.getInternalName() == null ? this.applicationHandler.getIdMask().apply(principalType.getId()).toString() : principalType.getInternalName();
        PrincipalVO principalVO = new PrincipalVO();
        principalVO.setType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)principalType));
        principalVO.setValue((String)ObjectHelper.defaultValue((Object)userPrincipal.getPrincipal(), (Object)string));
        if (principalType instanceof TokenPrincipalType && (string2 = ((TokenPrincipalType)principalType).getTokenMask()) != null && !MaskHelper.isValidMaskedValue((String)string2, (String)principalVO.getValue())) {
            principalVO.setValue(MaskHelper.applyMask((String)string2, (String)principalVO.getValue()));
        }
        string2 = new UserLocatorDetailedVO();
        string2.setPrincipalType(string3);
        string2.setPrincipal(string);
        string2.setUserPrincipal(principalVO);
        return string2;
    }

    private LocateUserResult performLocate(SessionData sessionData, Network network, UserLocatorVO userLocatorVO, Collection<PrincipalType> collection, PrincipalType principalType, Set<UserStatus> set) {
        if (!ModelHelper.isValid((UserLocatorVO)userLocatorVO)) {
            throw new ValidationException();
        }
        if (userLocatorVO.getId() != null) {
            return this.doLocateById(sessionData, network, userLocatorVO.getId(), set);
        }
        if ("#".equals(userLocatorVO.getPrincipalType())) {
            return this.doLocateByPin(sessionData, network, userLocatorVO.getPrincipal(), collection, set);
        }
        if (StringHelper.isNotBlank((Object)userLocatorVO.getUsername())) {
            userLocatorVO.setPrincipalType(ExistingBuiltInPrincipalType.USERNAME.getInternalName());
            userLocatorVO.setPrincipal(userLocatorVO.getUsername());
            userLocatorVO.setUsername(null);
        }
        try {
            String string = userLocatorVO.getPrincipal();
            if ("self".equals(string)) {
                if (sessionData.isLoggedIn()) {
                    return new LocateUserResult(sessionData.getLoggedBasicUser());
                }
                this.throwNotFoundException(userLocatorVO);
            }
            if (StringHelper.isNotBlank((Object)string)) {
                return this.doLocateByPrincipal(sessionData, network, userLocatorVO.getPrincipalType(), string, collection, principalType, set);
            }
            this.throwNotFoundException(userLocatorVO);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            this.throwNotFoundException(userLocatorVO);
        }
        return null;
    }

    private void throwEntityNotFoundException() throws EntityNotFoundException {
        throw new EntityNotFoundException();
    }

    private void throwNotFoundException(Long l) throws LocateUserException {
        throw new LocateUserException(new UserLocatorVO(l), null);
    }

    private void throwNotFoundException(String string) throws LocateUserException {
        throw new LocateUserException(new UserLocatorVO((Property)UserLocatorVO.PRINCIPAL, (Object)string), null);
    }

    private void throwNotFoundException(String string, PrincipalType principalType) throws LocateUserException {
        throw new LocateUserException(new UserLocatorVO((Property)UserLocatorVO.PRINCIPAL, (Object)string), (PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)principalType));
    }

    private void throwNotFoundException(UserLocatorVO userLocatorVO) throws LocateUserException {
        throw new LocateUserException(userLocatorVO, null);
    }

    private void throwNotFoundException(UserLocatorVO userLocatorVO, PrincipalType principalType) throws LocateUserException {
        throw new LocateUserException(userLocatorVO, (PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)principalType));
    }

    private ImageVO toImageVO(QUserImage qUserImage, Tuple tuple) {
        Long l = (Long)tuple.get((Expression)qUserImage.id);
        if (l == null) {
            return null;
        }
        ImageVO imageVO = new ImageVO();
        imageVO.setId(l);
        imageVO.setName((String)tuple.get((Expression)qUserImage.name));
        imageVO.setConvertedToJpeg(((Boolean)tuple.get((Expression)qUserImage.convertedToJpeg)).booleanValue());
        imageVO.setContentType((String)tuple.get((Expression)qUserImage.contentType));
        imageVO.setWidth(((Integer)tuple.get((Expression)qUserImage.width)).intValue());
        imageVO.setHeight(((Integer)tuple.get((Expression)qUserImage.height)).intValue());
        imageVO.setLength(((Integer)tuple.get((Expression)qUserImage.length)).intValue());
        imageVO.setKey(ImageVOConverter.getKey((String)tuple.get((Expression)qUserImage.key), imageVO.getWidth(), imageVO.getHeight(), imageVO.getContentType()));
        Date date = (Date)tuple.get((Expression)qUserImage.lastModified);
        imageVO.setLastModified(this.conversionHandler.toDateTime(date));
        imageVO.setLastModifiedInMillis(String.valueOf(date.getTime()));
        return imageVO;
    }
}

