/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.CustomFieldPrincipalType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.IUserAccount;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ConfigurationGuestProfileField;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.ProfileFieldComparator;
import org.cyclos.entities.users.QProductMyProfileField;
import org.cyclos.entities.users.QProductOperatorProfileField;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.UserPrincipals;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.GuestSessionData;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.FieldsContext;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.PrivacySettingsServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.ProfileOrAddressFieldComparator;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.users.UserImageServiceLocal;
import org.cyclos.impl.users.UserVariable;
import org.cyclos.impl.users.UserVariablesFunction;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.fields.BaseValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.AddressQueryField;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.fields.UserCustomFieldDetailedVO;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.products.ProductUserProfileFieldDTO;
import org.cyclos.model.users.products.UserBasicFieldActions;
import org.cyclos.model.users.products.UserCustomFieldActions;
import org.cyclos.model.users.products.UserProfileFieldActions;
import org.cyclos.model.users.users.AddressFieldValueForSearchDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicProfileFieldValueForSearchDTO;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserRegistration;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.model.utils.ParameterVO;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ProfileFieldHandlerImpl
extends BaseNetworkedHandlerImpl
implements ProfileFieldHandler {
    private static final QProductMyProfileField mpf = QProductMyProfileField.productMyProfileField;
    private static final QProductUserProfileField upf = QProductUserProfileField.productUserProfileField;
    private static final Map<ProfileFieldAction, Property<Boolean, UserProfileFieldActions>> ACTIONS_PROPERTY = new HashMap<ProfileFieldAction, Property<Boolean, UserProfileFieldActions>>();
    private static final Map<ProfileFieldAction, BooleanPath> MY_PROFILE_FIELD_PATHS = new HashMap<ProfileFieldAction, BooleanPath>();
    private static final Map<ProfileFieldAction, BooleanPath> MY_PROFILE_FIELD_REGISTRATION_PATHS = new HashMap<ProfileFieldAction, BooleanPath>();
    private static final Map<ProfileFieldAction, BooleanPath> USER_PROFILE_FIELD_PATHS = new HashMap<ProfileFieldAction, BooleanPath>();
    private static final Map<ProfileFieldSearchContext, BooleanPath> SEARCH_PATHS;
    @Autowired
    @Lazy
    private UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    @Lazy
    private UserAddressServiceLocal addressService;
    @Autowired
    @Lazy
    private UserImageServiceLocal userImageService;
    @Autowired
    @Lazy
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    @Lazy
    private TokenServiceLocal tokenService;
    @Autowired
    @Lazy
    private PhoneServiceLocal phoneService;
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    @Lazy
    private PrivacySettingsServiceLocal privacySettingsService;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    @Lazy
    private AccountServiceLocal accountService;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public boolean canEditProfile(BasicUser basicUser) {
        return CollectionHelper.isNotEmpty(this.getFieldsByAction(basicUser, ProfileFieldAction.EDIT)) || CollectionHelper.isNotEmpty(this.getFieldsByAction(basicUser, ProfileFieldAction.MANAGE_PRIVACY));
    }

    public boolean canViewHidden(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData().unwrap();
        if (sessionData instanceof GuestSessionData && (basicUser.isTransient() || ((GuestSessionData)sessionData).getPublicRegisteredUserId() == basicUser.getId())) {
            return true;
        }
        if (basicUser instanceof Operator) {
            return this.permission(basicUser).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).my(new Permission[0]).granted();
        }
        return this.permission(basicUser).user(new Permission[]{Permission.USERS_VIEW_HIDDEN_FIELDS}).my(new Permission[0]).granted();
    }

    public boolean enablePrivacy(BasicUser basicUser) {
        return !basicUser.isGlobal() && !basicUser.isOperator();
    }

    public void fill(DataWithBasicProfileFields dataWithBasicProfileFields) {
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        AccountNumberConfiguration accountNumberConfiguration = configurationAccessor.getAccountNumberConfiguration();
        if (accountNumberConfiguration != null && accountNumberConfiguration.isEnabled()) {
            dataWithBasicProfileFields.setAccountNumberMask(accountNumberConfiguration.getMask());
        }
        dataWithBasicProfileFields.setMobilePhoneExample(this.phoneNumberHandler.getExampleNumber(PhoneNature.MOBILE, configurationAccessor));
    }

    public void filterEnabledForUser(BasicUser basicUser, BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder2 = this.getMyProfileFields(basicUser, productsAccessor);
        booleanPropertiesHolder.entries().removeIf(entry -> {
            ProfileField profileField = (ProfileField)entry.getKey();
            BooleanProperties booleanProperties = booleanPropertiesHolder2.get((Object)profileField);
            return booleanProperties == null || !booleanProperties.isSet((Path)ProfileFieldHandlerImpl.mpf.enabled);
        });
    }

    public List<AddressQueryField> getAddressQueryFields() {
        EnumSet<AddressQueryField> enumSet = EnumSet.noneOf(AddressQueryField.class);
        for (AddressFields addressFields : this.getConfiguration().getAddressConfiguration().getEnabledAddressFields()) {
            enumSet.add(addressFields.queryField());
        }
        return new ArrayList<AddressQueryField>(enumSet);
    }

    public List<ProfileField> getAllProfileFields() {
        ArrayList<ProfileField> arrayList = new ArrayList<ProfileField>();
        arrayList.addAll(EnumSet.allOf(BasicProfileField.class));
        arrayList.addAll(this.userCustomFieldService.listAll());
        return arrayList;
    }

    public List<ProfileField> getAllProfileFieldsForOperators() {
        List<ProfileField> list = this.getAllProfileFields();
        list.removeIf(profileField -> !this.isAllowedForOperator((ProfileField)profileField));
        return list;
    }

    public List<UserCustomField> getCustomFields(Collection<? extends ProfileField> collection) {
        ArrayList<UserCustomField> arrayList = new ArrayList<UserCustomField>();
        for (ProfileField profileField : collection) {
            if (!(profileField instanceof UserCustomField)) continue;
            arrayList.add((UserCustomField)profileField);
        }
        return arrayList;
    }

    public List<ProfileField> getEnabledProfileFields(BasicUser basicUser) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        Set set = this.getMyProfileFields(basicUser, productsAccessor).keysSet((Path)ProfileFieldHandlerImpl.mpf.enabled);
        return set.stream().filter(profileField -> this.isPossible(basicUser, productsAccessor, (ProfileField)profileField)).sorted((Comparator<ProfileField>)ProfileFieldComparator.getInstance()).collect(Collectors.toList());
    }

    /*
     * Could not resolve type clashes
     */
    public List<UserProfileFieldActions> getFieldActions(BasicUser basicUser) {
        Collection<Object> collection;
        SessionData sessionData = this.getSessionData();
        FieldsContext fieldsContext = this.getFieldsContext(basicUser);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        HashSet<ProfileField> hashSet = new HashSet<ProfileField>();
        HashMap<ProfileFieldAction, List<ProfileField>> hashMap = new HashMap<ProfileFieldAction, List<ProfileField>>();
        for (ProfileFieldAction profileFieldAction : ProfileFieldAction.values()) {
            collection = this.doGetFieldsByAction(basicUser, profileFieldAction, sessionData, fieldsContext, productsAccessor);
            hashMap.put(profileFieldAction, (List<ProfileField>)collection);
            hashSet.addAll(collection);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, ProfileFieldComparator.getInstance());
        ArrayList<UserProfileFieldActions> arrayList2 = new ArrayList<UserProfileFieldActions>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            UserBasicFieldActions userBasicFieldActions;
            ProfileFieldAction profileFieldAction;
            profileFieldAction = (ProfileField)iterator.next();
            collection = EnumSet.noneOf(ProfileFieldAction.class);
            for (Property<Boolean, UserProfileFieldActions> property : ProfileFieldAction.values()) {
                List list = (List)hashMap.get(property);
                if (list == null || !list.contains(profileFieldAction)) continue;
                collection.add((ProfileFieldAction)property);
            }
            if (!collection.contains(ProfileFieldAction.VIEW)) continue;
            if (profileFieldAction instanceof BasicProfileField) {
                userBasicFieldActions = new UserBasicFieldActions();
                userBasicFieldActions.setBasicField((BasicProfileField)profileFieldAction);
            } else if (profileFieldAction instanceof UserCustomField) {
                userBasicFieldActions = new UserCustomFieldActions();
                UserCustomFieldDetailedVO userCustomFieldDetailedVO = (UserCustomFieldDetailedVO)this.conversionHandler.convert(UserCustomFieldDetailedVO.class, (Object)profileFieldAction);
                ((UserCustomFieldActions)userBasicFieldActions).setCustomField(userCustomFieldDetailedVO);
            } else {
                throw new IllegalStateException();
            }
            for (ProfileFieldAction profileFieldAction2 : collection) {
                Property<Boolean, UserProfileFieldActions> property;
                property = ACTIONS_PROPERTY.get(profileFieldAction2);
                userBasicFieldActions.set(property, (Object)true);
            }
            arrayList2.add((UserProfileFieldActions)userBasicFieldActions);
        }
        return arrayList2;
    }

    public Set<ProfileFieldAction> getFieldActions(BasicUser basicUser, ProfileField profileField) {
        SessionData sessionData = this.getSessionData();
        FieldsContext fieldsContext = this.getFieldsContext(basicUser);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        return this.doGetActions(basicUser, profileField, sessionData, fieldsContext, productsAccessor);
    }

    public Map<ProfileField, Set<ProfileFieldAction>> getFieldActionsMap(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        FieldsContext fieldsContext = this.getFieldsContext(basicUser);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        List<ProfileField> list = this.getEnabledProfileFields(basicUser);
        HashMap<ProfileField, Set<ProfileFieldAction>> hashMap = new HashMap<ProfileField, Set<ProfileFieldAction>>();
        for (ProfileField profileField : list) {
            hashMap.put(profileField, this.doGetActions(basicUser, profileField, sessionData, fieldsContext, productsAccessor));
        }
        return hashMap;
    }

    public List<ProfileField> getFieldsByAction(BasicUser basicUser, ProfileFieldAction profileFieldAction) {
        SessionData sessionData = this.getSessionData();
        FieldsContext fieldsContext = this.getFieldsContext(basicUser);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        return this.doGetFieldsByAction(basicUser, profileFieldAction, sessionData, fieldsContext, productsAccessor);
    }

    public FieldsContext getFieldsContext(BasicUser basicUser) {
        if (basicUser == null) {
            throw new NullPointerException();
        }
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser2 = sessionData.getLoggedBasicUser();
        if (basicUser instanceof Operator) {
            if (basicUser2 != null && basicUser2.getUser().equals((Object)basicUser.getUser())) {
                if (basicUser.isTransient()) {
                    return FieldsContext.PUBLIC_REGISTRATION;
                }
                return FieldsContext.MY_PROFILE;
            }
            if (basicUser.isTransient()) {
                return FieldsContext.INTERNAL_REGISTRATION;
            }
            return FieldsContext.USER_PROFILE;
        }
        if (basicUser2 != null && basicUser2.equals((Object)basicUser) || sessionData.unwrap() instanceof GuestSessionData && basicUser.getId() != null && basicUser.getId().equals(((GuestSessionData)sessionData.unwrap()).getPublicRegisteredUserId())) {
            return FieldsContext.MY_PROFILE;
        }
        if (basicUser.isTransient()) {
            if (ObjectHelper.isOneOf((Object)basicUser.getRegistrationType(), (Object[])new Object[]{UserRegistration.MEMBER, UserRegistration.PUBLIC})) {
                return FieldsContext.PUBLIC_REGISTRATION;
            }
            return FieldsContext.INTERNAL_REGISTRATION;
        }
        return FieldsContext.USER_PROFILE;
    }

    public List<ProfileField> getFieldsInMapResult(boolean bl) {
        return this.doGetFieldsForList(bl, QProductUserProfileField.productUserProfileField.mapResult, ConfigurationGuestProfileField::isMapResult);
    }

    public List<ProfileField> getFieldsInUserList(boolean bl) {
        return this.doGetFieldsForList(bl, QProductUserProfileField.productUserProfileField.userList, ConfigurationGuestProfileField::isUserList);
    }

    public Object getFieldValue(BasicUser basicUser, ProfileField profileField) throws FrameworkException {
        if (profileField instanceof BasicProfileField) {
            switch ((BasicProfileField)profileField) {
                case LOGIN_NAME: {
                    return basicUser.getUsername();
                }
                case FULL_NAME: {
                    return basicUser.getName();
                }
                case EMAIL: {
                    return basicUser.getEmail();
                }
                case PHONE: {
                    return basicUser.getPhones();
                }
                case ACCOUNT_NUMBER: {
                    if (basicUser instanceof User) {
                        User user = (User)basicUser;
                        List list = this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
                        return this.nativeQueryHandler.userAccounts((User)basicUser, (Collection)list, true, null).values().stream().filter(iUserAccount -> StringHelper.isNotBlank((Object)iUserAccount.getNumber())).sorted(Comparator.comparing(IUserAccount::getType)).map(arg_0 -> ((AccountHandler)this.accountHandler).getAccountNumber(arg_0)).collect(Collectors.toList());
                    }
                    return null;
                }
                case ADDRESS: {
                    return basicUser instanceof User ? ((User)basicUser).getAddresses() : null;
                }
                case IMAGE: {
                    return basicUser instanceof User ? ((User)basicUser).getImages() : null;
                }
            }
        } else if (profileField instanceof UserCustomField) {
            return CustomFieldHelper.findValue((ICustomField)((UserCustomField)profileField), (Collection)basicUser.getCustomValues());
        }
        throw new IllegalStateException("Unhandled profile field: " + String.valueOf(profileField));
    }

    public List<ProfileField> getMatchingFields(BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder, BooleanPath booleanPath) {
        return this.getMatchingFields(booleanPropertiesHolder, booleanPath, true);
    }

    public List<ProfileField> getMatchingFields(BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder, BooleanPath booleanPath, Boolean bl) {
        return this.getMatchingFields(booleanPropertiesHolder, Collections.singletonMap(booleanPath, bl));
    }

    public List<ProfileField> getMatchingFields(BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder, Map<BooleanPath, Boolean> map) {
        ArrayList<ProfileField> arrayList = new ArrayList<ProfileField>();
        for (Map.Entry entry : booleanPropertiesHolder.entries()) {
            BooleanProperties booleanProperties = (BooleanProperties)entry.getValue();
            boolean bl = true;
            if (map != null) {
                for (Map.Entry<BooleanPath, Boolean> entry2 : map.entrySet()) {
                    Boolean bl2 = entry2.getValue();
                    if (bl2 == null || bl2.booleanValue() == booleanProperties.isSet((Path)entry2.getKey())) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            arrayList.add((ProfileField)entry.getKey());
        }
        return arrayList;
    }

    public UserPrincipal getPrincipal(BasicUser basicUser, ChannelAccessAccessor channelAccessAccessor) {
        UserPrincipal userPrincipal;
        block2: {
            PrincipalType principalType;
            PrincipalType principalType2 = channelAccessAccessor.getDefaultPrincipalType();
            userPrincipal = null;
            if (principalType2 != null) {
                userPrincipal = this.getPrincipal(basicUser, principalType2);
            }
            if (userPrincipal != null) break block2;
            ArrayList arrayList = new ArrayList(channelAccessAccessor.getPrincipalTypes());
            this.principalTypeService.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && (userPrincipal = this.getPrincipal(basicUser, principalType = (PrincipalType)iterator.next())) == null) {
            }
        }
        return userPrincipal;
    }

    public UserPrincipal getPrincipal(BasicUser basicUser, PrincipalType principalType) {
        return this.doGetPrincipal(basicUser, principalType);
    }

    public ProfileField getProfileFieldFor(PrincipalType principalType) {
        if (principalType instanceof BuiltInPrincipalType) {
            BuiltInPrincipalType builtInPrincipalType = (BuiltInPrincipalType)principalType;
            switch (builtInPrincipalType.getBuiltInType()) {
                case USERNAME: {
                    return BasicProfileField.LOGIN_NAME;
                }
                case EMAIL: {
                    return BasicProfileField.EMAIL;
                }
                case MOBILE_PHONE: {
                    return BasicProfileField.PHONE;
                }
                case ACCOUNT_NUMBER: {
                    return BasicProfileField.ACCOUNT_NUMBER;
                }
                case TRUSTED_DEVICE: {
                    return null;
                }
            }
        } else if (principalType instanceof CustomFieldPrincipalType) {
            CustomFieldPrincipalType customFieldPrincipalType = (CustomFieldPrincipalType)principalType;
            return customFieldPrincipalType.getCustomField();
        }
        return null;
    }

    public List<ProfileField> getProfileFieldsForExport() {
        List list = this.profileFieldHandler.getMatchingFields(this.getSessionData().getProducts().product().getUserProfileFields(), QProductUserProfileField.productUserProfileField.visible);
        list.removeIf(profileField -> {
            if (profileField instanceof UserCustomField) {
                return !((UserCustomField)profileField).isIncludeInExport();
            }
            return !Arrays.asList(BasicProfileField.FULL_NAME, BasicProfileField.LOGIN_NAME, BasicProfileField.EMAIL, BasicProfileField.PHONE).contains(profileField);
        });
        list.add(BasicProfileField.ACCOUNT_NUMBER);
        list.sort(ProfileFieldComparator.getInstance());
        return list;
    }

    public List<ProfileField> getProfileFieldsInOperatorsList(User user) {
        SessionData sessionData = this.getSessionData();
        if (user == null && sessionData.isMember() && sessionData.hasPermission(Permission.MY_OPERATORS_ENABLE)) {
            user = sessionData.getLoggedUser();
        }
        if (user == null) {
            return Collections.emptyList();
        }
        QProductOperatorProfileField qProductOperatorProfileField = QProductOperatorProfileField.productOperatorProfileField;
        Set set = this.productsHandler.getAccessor((BasicUser)user).memberOrBroker().getOperatorProfileFields().keysSet((Path)qProductOperatorProfileField.operatorList);
        if (!user.equals((Object)sessionData.getLoggedUser()) && !sessionData.hasPermission(Permission.USER_OPERATORS_MANAGE)) {
            set.removeIf(profileField -> !(profileField instanceof BasicProfileField) || ((BasicProfileField)profileField).canHide());
        }
        return CollectionHelper.sort((Collection)set, (Comparator)ProfileFieldComparator.getInstance());
    }

    public List<ProfileField> getSearchFilters(ProfileFieldSearchContext profileFieldSearchContext, boolean bl, Map<String, Object> map) {
        List<ProfileField> list = this.doGetSearchFilters(profileFieldSearchContext, bl);
        list = this.toVOsWithPossibleValuesLoaded(profileFieldSearchContext, bl, map, list);
        return list;
    }

    public Set<SendMedium> getSendMediums(BasicUser basicUser) {
        EnumSet<SendMedium> enumSet = EnumSet.noneOf(SendMedium.class);
        if (this.isEnabled(basicUser, (ProfileField)BasicProfileField.EMAIL) && basicUser.getEmail() != null) {
            enumSet.add(SendMedium.EMAIL);
        }
        if (this.isEnabled(basicUser, (ProfileField)BasicProfileField.PHONE) && basicUser.hasMobileEnabledForSMS()) {
            enumSet.add(SendMedium.SMS);
        }
        return enumSet;
    }

    public Pair<List<ProfileField>, List<ProfileField>> getSimpleAndAdvancedSearchFilters(ProfileFieldSearchContext profileFieldSearchContext, boolean bl, Map<String, Object> map) {
        List<ProfileField> list = this.doGetSearchFilters(profileFieldSearchContext, bl);
        SessionData sessionData = this.getSessionData();
        List<ProfileField> list2 = new ArrayList<ProfileField>();
        List<ProfileField> list3 = new ArrayList<ProfileField>();
        if (sessionData.isGuest()) {
            list2.addAll(list);
        } else {
            ProductsAccessor productsAccessor = sessionData.getProducts();
            List list4 = sessionData.isAdmin() ? productsAccessor.product().getSimpleUserSearchProfileFields() : (sessionData.isBroker() && bl ? productsAccessor.broker().getSimpleUserSearchProfileFields() : productsAccessor.member().getSimpleUserSearchProfileFields());
            for (ProfileField profileField : list) {
                if (list4.contains(profileField)) {
                    list2.add(profileField);
                    continue;
                }
                list3.add(profileField);
            }
        }
        list2 = this.toVOsWithPossibleValuesLoaded(profileFieldSearchContext, bl, map, list2);
        list3 = this.toVOsWithPossibleValuesLoaded(profileFieldSearchContext, bl, map, list3);
        return new Pair(list2, list3);
    }

    public Object getSingleFieldValue(BasicUser basicUser, ProfileField profileField) {
        if (profileField == BasicProfileField.ACCOUNT_NUMBER) {
            if (basicUser instanceof User) {
                return this.accountHandler.getAccountNumber((IAccount)this.getAccount((User)basicUser));
            }
            return null;
        }
        if (profileField == BasicProfileField.ADDRESS) {
            return basicUser instanceof User ? ((User)basicUser).getDefaultAddress() : null;
        }
        if (profileField == BasicProfileField.PHONE) {
            return basicUser.getPreferredPhone();
        }
        if (profileField == BasicProfileField.IMAGE) {
            return basicUser instanceof User ? ((User)basicUser).getImage() : null;
        }
        return this.getFieldValue(basicUser, profileField);
    }

    public List<ProductUserProfileFieldDTO> getUserProfileFields(ProductAccessor productAccessor) {
        BooleanPropertiesHolder booleanPropertiesHolder = productAccessor.getUserProfileFields();
        return this.getProfileFields(ProductUserProfileFieldDTO.class, (BooleanPropertiesHolder<ProfileField>)booleanPropertiesHolder);
    }

    public List<ParameterVO> getUserVariables() {
        ArrayList<ParameterVO> arrayList = new ArrayList<ParameterVO>();
        UserVariable.addProfileParameters(arrayList, (TranslationHandler)this.translationHandler);
        UserVariable.addOtherProfileParameters(arrayList, (TranslationHandler)this.translationHandler);
        for (UserCustomField userCustomField : this.userCustomFieldService.listAll()) {
            arrayList.add(new ParameterVO(userCustomField.getInternalName(), this.getTranslatedName((NamedEntity)userCustomField)));
        }
        UserVariable.addAddressParameters(arrayList, (TranslationHandler)this.translationHandler);
        UserVariable.addAccountParameters(arrayList, (TranslationHandler)this.translationHandler);
        UserVariable.addGeneralParameters(arrayList, (TranslationHandler)this.translationHandler);
        return arrayList;
    }

    public Function<String, String> getUserVariablesFunction(BasicUser basicUser) {
        return (Function)InvocationContext.ensure().getAttribute((Object)("profileVariablesFunction_" + SimpleEntity.id((SimpleEntity)basicUser)), () -> (UserVariablesFunction)this.beanHandler.autowireWithArgs(UserVariablesFunction.class, new Object[]{basicUser}));
    }

    public List<ProfileField> getVisibleProfileFields(BasicUser basicUser) {
        ArrayList<ProfileField> arrayList = new ArrayList<ProfileField>();
        for (ProfileField profileField : this.getAllProfileFields()) {
            if (!this.isAllowed(basicUser, profileField, ProfileFieldAction.VIEW)) continue;
            arrayList.add(profileField);
        }
        return arrayList;
    }

    public boolean isAllowed(BasicUser basicUser, ProfileField profileField, ProfileFieldAction profileFieldAction) {
        SessionData sessionData = this.getSessionData();
        FieldsContext fieldsContext = this.getFieldsContext(basicUser);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        return this.doGetActions(basicUser, profileField, sessionData, fieldsContext, productsAccessor).contains(profileFieldAction);
    }

    public boolean isAllowedForOperator(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            return ((BasicProfileField)profileField).isAllowedForOperator();
        }
        return profileField instanceof UserCustomField;
    }

    public boolean isDefaultHidden(Group group, ProfileField profileField) throws FrameworkException {
        return this.isDefaultHidden(this.configurationHandler.getAccessor((BasicGroup)group), profileField);
    }

    public boolean isEnabled(BasicUser basicUser, ProfileField profileField) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        return this.isPossible(basicUser, productsAccessor, profileField) && this.getMyProfileFields(basicUser, productsAccessor).isSet((Object)profileField, (Path)ProfileFieldHandlerImpl.mpf.enabled);
    }

    public boolean isHidden(BasicUser basicUser, ProfileField profileField, Object object) throws FrameworkException {
        if (profileField instanceof BasicProfileField) {
            BasicProfileField basicProfileField = (BasicProfileField)profileField;
            if (!basicProfileField.canHide()) {
                return false;
            }
            if (basicUser instanceof Operator) {
                return true;
            }
            switch ((BasicProfileField)profileField) {
                case EMAIL: {
                    return ((User)basicUser).isHideEmail();
                }
                case PHONE: {
                    if (object instanceof Phone) {
                        Phone phone = (Phone)object;
                        if (!basicUser.equals((Object)phone.getUser())) {
                            throw new IllegalStateException("Received a phone of an unexpected user. Got: " + String.valueOf(phone.getUser()) + ", expected " + String.valueOf(basicUser));
                        }
                        return phone.isHidden();
                    }
                    if (object == null) break;
                    throw new IllegalStateException("In a check for hidden phone, received an unexpected object: " + String.valueOf(object));
                }
                case ADDRESS: {
                    if (object instanceof UserAddress) {
                        UserAddress userAddress = (UserAddress)object;
                        if (!basicUser.equals((Object)userAddress.getUser())) {
                            throw new IllegalStateException("Received an address of an unexpected user. Got: " + String.valueOf(userAddress.getUser()) + ", expected " + String.valueOf(basicUser));
                        }
                        return userAddress.isHidden();
                    }
                    if (object == null) break;
                    throw new IllegalStateException("In a check for hidden address, received an unexpected object: " + String.valueOf(object));
                }
            }
        } else if (profileField instanceof UserCustomField) {
            if (basicUser instanceof Operator) {
                return true;
            }
            UserCustomFieldValue userCustomFieldValue = (UserCustomFieldValue)ObjectHelper.ifType((Object)object, UserCustomFieldValue.class);
            if (userCustomFieldValue == null) {
                userCustomFieldValue = (UserCustomFieldValue)CustomFieldHelper.findValue((ICustomField)((UserCustomField)profileField), (Collection)basicUser.getCustomValues());
            } else {
                if (!profileField.equals((Object)userCustomFieldValue.getField())) {
                    throw new IllegalStateException("Received a custom field value which is not of the expected field. Got: " + String.valueOf(userCustomFieldValue.getField()) + ", expected " + String.valueOf(profileField));
                }
                if (!basicUser.equals((Object)userCustomFieldValue.getOwner())) {
                    throw new IllegalStateException("Received a custom field of an unexpected user. Got: " + String.valueOf(userCustomFieldValue.getOwner()) + ", expected " + String.valueOf(basicUser));
                }
            }
            return userCustomFieldValue == null ? this.isDefaultHidden(this.configurationHandler.getAccessor(basicUser), profileField) : userCustomFieldValue.isHidden();
        }
        return false;
    }

    public boolean isVisible(ProfileField profileField, boolean bl) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            return this.isVisibleByGuest(sessionData, profileField);
        }
        Object object = sessionData.isBroker() ? (bl ? sessionData.getProducts().broker() : sessionData.getProducts().member()) : sessionData.getProducts().product();
        return object.getUserProfileFields().isSet((Object)profileField, (Path)QProductUserProfileField.productUserProfileField.visible);
    }

    public boolean isVisible(ProfileField profileField, String string) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return true;
        }
        if (sessionData.isLoggedIn()) {
            String string2 = sessionData.getLoggedUser().getId().toString();
            boolean bl = sessionData.isBroker() && StringHelper.splitTrimming((String)string, (String)",").contains(string2);
            BooleanPropertiesHolder booleanPropertiesHolder = sessionData.isMember() && !bl ? sessionData.getProducts().member().getUserProfileFields() : sessionData.getProducts().product().getUserProfileFields();
            return booleanPropertiesHolder.isSet((Object)profileField, (Path)QProductUserProfileField.productUserProfileField.visible);
        }
        return this.isVisibleByGuest(sessionData, profileField);
    }

    public PrincipalType principalTypeFor(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            switch ((BasicProfileField)profileField) {
                case LOGIN_NAME: {
                    return this.principalTypeService.getUsername();
                }
                case EMAIL: {
                    return this.principalTypeService.getEmail();
                }
                case ACCOUNT_NUMBER: {
                    return this.principalTypeService.getAccountNumber();
                }
                case PHONE: {
                    return this.principalTypeService.getMobilePhone();
                }
            }
        } else if (profileField instanceof UserCustomField) {
            UserCustomField userCustomField = (UserCustomField)profileField;
            try {
                return this.principalTypeService.getCustomField(userCustomField);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public void purgeDisabled(BasicUser basicUser) {
        Set<UserCustomFieldValue> set;
        Set set2;
        List<ProfileField> list = this.getEnabledProfileFields(basicUser);
        if (!list.contains(BasicProfileField.FULL_NAME)) {
            basicUser.setName(null);
        }
        if (!list.contains(BasicProfileField.EMAIL)) {
            basicUser.setEmail(null);
        }
        if (!list.contains(BasicProfileField.PHONE) && CollectionHelper.isNotEmpty((Iterable)(set2 = basicUser.getPhones()))) {
            new LinkedList(set2).forEach(arg_0 -> ((PhoneServiceLocal)this.phoneService).remove(arg_0));
        }
        if (basicUser instanceof User) {
            set2 = (User)basicUser;
            set = set2.getAddresses();
            if (CollectionHelper.isNotEmpty((Iterable)set)) {
                if (list.contains(BasicProfileField.ADDRESS)) {
                    ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)set2);
                    Set set3 = configurationAccessor.getAddressConfiguration().getEnabledAddressFields();
                    for (UserAddress userAddress : set) {
                        for (AddressFields addressFields : AddressFields.values()) {
                            if (set3.contains(addressFields)) continue;
                            AddressHelper.setValue((AddressFields)addressFields, (IAddress)userAddress, null);
                        }
                    }
                } else {
                    new LinkedList<UserAddress>(set).forEach(arg_0 -> ((UserAddressServiceLocal)this.addressService).remove(arg_0));
                }
            }
            if (!list.contains(BasicProfileField.IMAGE)) {
                this.userImageService.removeAll((BaseEntity)set2);
            }
        }
        if (!(set = (set2 = CollectionHelper.orEmpty((Set)basicUser.getCustomValues())).stream().filter(userCustomFieldValue -> !list.contains(userCustomFieldValue.getField())).collect(Collectors.toSet())).isEmpty()) {
            set.forEach(arg_0 -> ((CustomFieldValueHandler)this.customFieldValueHandler).remove(arg_0));
            set2.removeAll(set);
        }
    }

    public ProfileField toBasicVO(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            return profileField;
        }
        return (ProfileField)this.conversionHandler.convert(CustomFieldVO.class, (Object)profileField);
    }

    public List<ProfileField> toBasicVOs(Collection<ProfileField> collection) {
        ArrayList<ProfileField> arrayList = new ArrayList<ProfileField>(collection.size());
        for (ProfileField profileField : collection) {
            arrayList.add(this.toBasicVO(profileField));
        }
        return arrayList;
    }

    public List<ProfileField> toEntities(Collection<ProfileField> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return new ArrayList<ProfileField>();
        }
        ArrayList<ProfileField> arrayList = new ArrayList<ProfileField>(collection.size());
        for (ProfileField profileField : collection) {
            arrayList.add(this.toEntity(profileField));
        }
        return arrayList;
    }

    public ProfileField toEntity(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            return profileField;
        }
        return (ProfileField)this.conversionHandler.convert(UserCustomField.class, (Object)profileField);
    }

    public SortedMap<Object, Object> toSearchFiltersMap(List<ProfileField> list, Collection<? extends BaseValueForSearchDTO> collection, boolean bl) {
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(ProfileOrAddressFieldComparator.getInstance());
        for (BaseValueForSearchDTO baseValueForSearchDTO : CollectionHelper.orEmpty(collection)) {
            BasicProfileFieldValueForSearchDTO basicProfileFieldValueForSearchDTO;
            BasicProfileField basicProfileField = null;
            Object object = null;
            if (baseValueForSearchDTO instanceof BasicProfileFieldValueForSearchDTO) {
                basicProfileFieldValueForSearchDTO = (BasicProfileFieldValueForSearchDTO)baseValueForSearchDTO;
                basicProfileField = basicProfileFieldValueForSearchDTO.getField();
                object = basicProfileField == BasicProfileField.IMAGE ? baseValueForSearchDTO.getBooleanValue() : baseValueForSearchDTO.getStringValue();
            } else if (baseValueForSearchDTO instanceof AddressFieldValueForSearchDTO) {
                basicProfileFieldValueForSearchDTO = (AddressFieldValueForSearchDTO)baseValueForSearchDTO;
                basicProfileField = basicProfileFieldValueForSearchDTO.getAddressField();
                object = baseValueForSearchDTO.getStringValue();
            } else if (baseValueForSearchDTO instanceof CustomFieldValueForSearchDTO) {
                basicProfileFieldValueForSearchDTO = (CustomFieldValueForSearchDTO)baseValueForSearchDTO;
                UserCustomField userCustomField = (UserCustomField)this.conversionHandler.convert(UserCustomField.class, (Object)basicProfileFieldValueForSearchDTO.getField());
                object = this.customFieldValueHandler.getValueForSearch((CustomField)userCustomField, (Object)basicProfileFieldValueForSearchDTO, true);
            }
            if (basicProfileField == null || object == null) continue;
            treeMap.put(basicProfileField, object);
        }
        return treeMap;
    }

    public ProfileField toVO(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            return profileField;
        }
        return (ProfileField)this.conversionHandler.convert(UserCustomFieldDetailedVO.class, (Object)profileField);
    }

    public List<ProfileField> toVOs(Collection<ProfileField> collection) {
        ArrayList<ProfileField> arrayList = new ArrayList<ProfileField>(collection.size());
        for (ProfileField profileField : collection) {
            arrayList.add(this.toVO(profileField));
        }
        return arrayList;
    }

    private Set<ProfileFieldAction> doGetActions(BasicUser basicUser, ProfileField profileField, SessionData sessionData, FieldsContext fieldsContext, ProductsAccessor productsAccessor) {
        Object object;
        if (!this.isEnabled(basicUser, profileField) || this.getPrivacyHiddenFields(sessionData, basicUser).contains(profileField)) {
            return Collections.emptySet();
        }
        if (sessionData.isSystem()) {
            return EnumSet.allOf(ProfileFieldAction.class);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (fieldsContext) {
            case MY_PROFILE: {
                object = this.getMyProfileFields(basicUser, productsAccessor).get((Object)profileField);
                bl = object.isSet((Path)ProfileFieldHandlerImpl.mpf.visible);
                bl2 = object.isSet((Path)ProfileFieldHandlerImpl.mpf.editable);
                bl3 = object.isSet((Path)ProfileFieldHandlerImpl.mpf.managePrivacy);
                break;
            }
            case USER_PROFILE: {
                if (sessionData.isGuest()) {
                    bl = sessionData.getConfiguration().getGuestProfileFields().stream().anyMatch(configurationGuestProfileField -> profileField.equals((Object)configurationGuestProfileField.getProfileField()) && configurationGuestProfileField.isVisible());
                    break;
                }
                BooleanPropertiesHolder booleanPropertiesHolder = sessionData.isManagerOf(basicUser) ? sessionData.getProducts().product().getUserProfileFields() : sessionData.getProducts().member().getUserProfileFields();
                boolean bl4 = this.canViewHidden(basicUser);
                boolean bl5 = !bl4 && this.isHidden(basicUser, profileField, null);
                BooleanProperties booleanProperties = booleanPropertiesHolder.get((Object)profileField);
                bl = !bl5 && booleanProperties.isSet((Path)ProfileFieldHandlerImpl.upf.visible);
                bl2 = !bl5 && booleanProperties.isSet((Path)ProfileFieldHandlerImpl.upf.editable);
                bl3 = bl2 && bl4;
                break;
            }
            case INTERNAL_REGISTRATION: 
            case PUBLIC_REGISTRATION: {
                BooleanProperties booleanProperties = this.getMyProfileFields(basicUser, productsAccessor).get((Object)profileField);
                bl = bl2 = booleanProperties.isSet((Path)ProfileFieldHandlerImpl.mpf.editableAtRegistration);
                if (fieldsContext == FieldsContext.INTERNAL_REGISTRATION) {
                    if (!bl2) {
                        bl = bl2 = sessionData.getProducts().product().getUserProfileFields().isSet((Object)profileField, (Path)ProfileFieldHandlerImpl.upf.editable);
                    }
                    bl3 = bl2 && this.canViewHidden(basicUser);
                    break;
                }
                bl3 = booleanProperties.isSet((Path)ProfileFieldHandlerImpl.mpf.managePrivacy);
            }
        }
        if (!this.isEditProfileAllowed(sessionData.getLoggedBasicUser(), basicUser)) {
            bl3 = false;
            bl2 = false;
        }
        object = EnumSet.noneOf(ProfileFieldAction.class);
        CollectionHelper.addOrRemove((Collection)object, (Object)ProfileFieldAction.VIEW, (boolean)bl);
        CollectionHelper.addOrRemove((Collection)object, (Object)ProfileFieldAction.EDIT, (boolean)bl2);
        CollectionHelper.addOrRemove((Collection)object, (Object)ProfileFieldAction.MANAGE_PRIVACY, (boolean)bl3);
        return object;
    }

    private List<ProfileField> doGetFieldsByAction(BasicUser basicUser, ProfileFieldAction profileFieldAction, SessionData sessionData, FieldsContext fieldsContext, ProductsAccessor productsAccessor) {
        List<Object> list;
        if (!this.isEditProfileAllowed(sessionData.getLoggedBasicUser(), basicUser) && ObjectHelper.isOneOf((Object)profileFieldAction, (Object[])new Object[]{ProfileFieldAction.EDIT, ProfileFieldAction.MANAGE_PRIVACY})) {
            return Collections.emptyList();
        }
        List<ProfileField> list2 = this.getEnabledProfileFields(basicUser);
        boolean bl = this.canViewHidden(basicUser);
        this.getPrivacyHiddenFields(sessionData, basicUser).forEach(list2::remove);
        if (sessionData.isSystem()) {
            list = list2;
        } else if (ProfileFieldAction.MANAGE_PRIVACY == profileFieldAction && !bl) {
            list = Collections.emptyList();
        } else {
            BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder = this.getMyProfileFields(basicUser, productsAccessor);
            switch (fieldsContext) {
                case MY_PROFILE: {
                    list = this.getMatchingFields(booleanPropertiesHolder, MY_PROFILE_FIELD_PATHS.get(profileFieldAction));
                    break;
                }
                case INTERNAL_REGISTRATION: 
                case PUBLIC_REGISTRATION: {
                    list = this.getMatchingFields(booleanPropertiesHolder, MY_PROFILE_FIELD_REGISTRATION_PATHS.get(profileFieldAction));
                    if (fieldsContext != FieldsContext.INTERNAL_REGISTRATION) break;
                    list.addAll(sessionData.getProducts().product().getUserProfileFields().keysSet((Path)ProfileFieldHandlerImpl.upf.editable));
                    break;
                }
                case USER_PROFILE: {
                    if (sessionData.isGuest()) {
                        list = new ArrayList<ProfileField>();
                        if (profileFieldAction == ProfileFieldAction.VIEW) {
                            this.configurationHandler.getAccessor(basicUser).getGuestProfileFields().stream().filter(ConfigurationGuestProfileField::isVisible).map(ConfigurationGuestProfileField::getProfileField).forEach(list::add);
                        }
                    } else {
                        BooleanPropertiesHolder booleanPropertiesHolder2 = sessionData.isManagerOf(basicUser) ? sessionData.getProducts().product().getUserProfileFields() : sessionData.getProducts().member().getUserProfileFields();
                        list = this.getMatchingFields((BooleanPropertiesHolder<ProfileField>)booleanPropertiesHolder2, USER_PROFILE_FIELD_PATHS.get(profileFieldAction));
                    }
                    if (bl) break;
                    list.removeIf(profileField -> this.isHidden(basicUser, (ProfileField)profileField, null));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled context: " + String.valueOf(fieldsContext));
                }
            }
        }
        list2.retainAll(list);
        return list2;
    }

    private List<ProfileField> doGetFieldsForList(boolean bl, BooleanPath booleanPath, Predicate<ConfigurationGuestProfileField> predicate) {
        List<ProfileField> list;
        SessionData sessionData = this.getSessionData();
        if (sessionData.isLoggedIn()) {
            ProductsAccessor productsAccessor = sessionData.getProducts();
            Object object = sessionData.isBroker() ? (bl ? productsAccessor.broker() : productsAccessor.member()) : productsAccessor.product();
            list = new ArrayList(object.getUserProfileFields().keysSet((Path)booleanPath));
        } else {
            list = sessionData.getConfiguration().getGuestProfileFields().stream().filter(predicate).map(ConfigurationGuestProfileField::getProfileField).collect(Collectors.toList());
        }
        list.removeIf(profileField -> {
            if (profileField instanceof UserCustomField) {
                UserCustomField userCustomField = (UserCustomField)profileField;
                return userCustomField.getType().isBinary();
            }
            return profileField == BasicProfileField.IMAGE || profileField == BasicProfileField.ADDRESS;
        });
        Collections.sort(list, ProfileFieldComparator.getInstance());
        return list;
    }

    private UserPrincipal doGetPrincipal(BasicUser basicUser, PrincipalType principalType) {
        User user = (User)ObjectHelper.ifType((Object)basicUser, User.class);
        switch (principalType.getNature()) {
            case BUILT_IN: {
                switch (((BuiltInPrincipalType)principalType).getBuiltInType()) {
                    case ACCOUNT_NUMBER: {
                        return this.getAccount(user);
                    }
                    case EMAIL: {
                        return UserPrincipals.email((BasicUser)basicUser);
                    }
                    case MOBILE_PHONE: {
                        return basicUser.getPreferredMobilePhone();
                    }
                    case USERNAME: {
                        return UserPrincipals.username((BasicUser)basicUser);
                    }
                    case TRUSTED_DEVICE: {
                        return null;
                    }
                }
            }
            case CUSTOM_FIELD: {
                UserCustomField userCustomField = ((CustomFieldPrincipalType)principalType).getCustomField();
                return basicUser.getCustomValues().stream().filter(userCustomFieldValue -> userCustomFieldValue.getField().equals((Object)userCustomField)).findFirst().orElse(null);
            }
            case ACCESS_CLIENT: {
                return null;
            }
            case TOKEN: 
            case NFC_TOKEN: {
                TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)principalType;
                return this.tokenService.firstActive(basicUser, tokenPrincipalType);
            }
        }
        return null;
    }

    private List<ProfileField> doGetSearchFilters(ProfileFieldSearchContext profileFieldSearchContext, boolean bl) {
        BooleanPropertiesHolder booleanPropertiesHolder;
        List<ProfileField> list;
        boolean bl2;
        SessionData sessionData = this.getSessionData();
        boolean bl3 = bl2 = profileFieldSearchContext == ProfileFieldSearchContext.MAP_DIRECTORY_FILTER;
        if (sessionData.isGuest()) {
            list = sessionData.getConfiguration().getGuestProfileFields().stream().filter(configurationGuestProfileField -> {
                switch (profileFieldSearchContext) {
                    case USER_FILTER: {
                        return configurationGuestProfileField.isUserFilter();
                    }
                    case MAP_DIRECTORY_FILTER: {
                        return configurationGuestProfileField.isMapFilter();
                    }
                    case USER_KEYWORDS: 
                    case MAP_DIRECTORY_KEYWORDS: {
                        return configurationGuestProfileField.isUserKeywords();
                    }
                    case AD_FILTER: {
                        return configurationGuestProfileField.isAdFilter();
                    }
                    case AD_KEYWORDS: {
                        return configurationGuestProfileField.isAdKeywords();
                    }
                }
                return false;
            }).map(ConfigurationGuestProfileField::getProfileField).collect(Collectors.toList());
        } else {
            booleanPropertiesHolder = sessionData.isBroker() ? (bl ? sessionData.getProducts().broker().getUserProfileFields() : sessionData.getProducts().member().getUserProfileFields()) : sessionData.getProducts().product().getUserProfileFields();
            list = this.getMatchingFields((BooleanPropertiesHolder<ProfileField>)booleanPropertiesHolder, SEARCH_PATHS.get(profileFieldSearchContext));
        }
        if (bl2 && (booleanPropertiesHolder = sessionData.getConfiguration().getMapDirectoryField()) != null) {
            list.remove(booleanPropertiesHolder);
            list.add(0, (ProfileField)booleanPropertiesHolder);
        }
        return list;
    }

    private IUserAccount getAccount(User user) {
        AccountNumberConfiguration accountNumberConfiguration;
        AccountNumberConfiguration accountNumberConfiguration2 = accountNumberConfiguration = user == null ? null : this.configurationHandler.getAccessor((BasicUser)user).getAccountNumberConfiguration();
        if (accountNumberConfiguration == null || !accountNumberConfiguration.isEnabled()) {
            return null;
        }
        List list = this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
        return (IUserAccount)CollectionHelper.first(this.nativeQueryHandler.userAccounts(user, (Collection)list, true, Integer.valueOf(1)).values());
    }

    private BooleanPropertiesHolder<ProfileField> getMyProfileFields(BasicUser basicUser, ProductsAccessor productsAccessor) {
        BooleanPropertiesHolder booleanPropertiesHolder = basicUser.isOperator() ? productsAccessor.memberOrBroker().getOperatorProfileFields() : productsAccessor.product().getMyProfileFields();
        return booleanPropertiesHolder;
    }

    private Set<ProfileField> getPrivacyHiddenFields(SessionData sessionData, BasicUser basicUser) {
        Set set;
        User user = basicUser.getUser();
        if (sessionData.isSystem() || user.equals((Object)sessionData.getLoggedUser())) {
            return Collections.emptySet();
        }
        Set set2 = this.privacySettingsService.getControls(user);
        if (set2 != null && !(set = this.configurationHandler.getAccessor((BasicUser)user).getPrivacyControlledProfileFields()).isEmpty() && sessionData.isManagerOf((BasicUser)user)) {
            boolean bl;
            List list = sessionData.getProducts().userManagement().getPrivacyControls();
            boolean bl2 = bl = list.stream().anyMatch(privacyControl -> privacyControl.isEnabled() && privacyControl.isFieldsAlwaysVisible()) || CollectionUtils.containsAny((Collection)set2, (Collection)list);
            if (!bl) {
                return set;
            }
        }
        return Collections.emptySet();
    }

    private <T> List<T> getProfileFields(Class<T> clazz, BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ProfileField profileField : this.getAllProfileFields()) {
            BooleanProperties booleanProperties = booleanPropertiesHolder.get((Object)profileField);
            Object object = booleanProperties.instantiate(clazz);
            BeanWrapper beanWrapper = InvocationContext.wrap((Object)object);
            beanWrapper.setPropertyValue("profileField", (Object)this.toVO(profileField));
            arrayList.add(object);
        }
        return arrayList;
    }

    private boolean isDefaultHidden(ConfigurationAccessor configurationAccessor, ProfileField profileField) throws FrameworkException {
        if (profileField instanceof UserCustomField) {
            return ((UserCustomField)profileField).getDefaultVisibility() == FieldVisibility.HIDDEN;
        }
        FieldVisibility fieldVisibility = FieldVisibility.HIDDEN;
        if (profileField == BasicProfileField.EMAIL) {
            fieldVisibility = configurationAccessor.getDefaultEmailPrivacy();
        } else if (profileField == BasicProfileField.ADDRESS) {
            fieldVisibility = configurationAccessor.getDefaultAddressPrivacy();
        } else if (profileField == BasicProfileField.PHONE) {
            fieldVisibility = configurationAccessor.getDefaultPhonePrivacy();
        }
        return fieldVisibility == FieldVisibility.HIDDEN;
    }

    private boolean isEditProfileAllowed(BasicUser basicUser, BasicUser basicUser2) {
        if (basicUser2.equals((Object)basicUser) && this.getSessionData().isGlobalAdminInNetwork() || basicUser2.isRemoved()) {
            return false;
        }
        if (basicUser2.isRestrictedOperator() && basicUser != null && basicUser.equals((Object)basicUser2)) {
            return ((Operator)basicUser2).getGroup().isEditOwnProfile();
        }
        return true;
    }

    private boolean isPossible(BasicUser basicUser, ProductsAccessor productsAccessor, ProfileField profileField) {
        ProductAccessor productAccessor = productsAccessor.product();
        return !(basicUser.isOperator() && !this.isAllowedForOperator(profileField) || profileField == BasicProfileField.PHONE && productAccessor.getMaxMobilePhones() <= 0 && productAccessor.getMaxLandlinePhones() <= 0 || profileField == BasicProfileField.IMAGE && productAccessor.getMaxProfileImages() <= 0 || profileField == BasicProfileField.ADDRESS && productAccessor.getMaxAddresses() <= 0);
    }

    private boolean isVisibleByGuest(SessionData sessionData, ProfileField profileField) {
        return sessionData.getConfiguration().getGuestProfileFields().stream().anyMatch(configurationGuestProfileField -> profileField.equals((Object)configurationGuestProfileField.getProfileField()) && configurationGuestProfileField.isVisible());
    }

    private List<ProfileField> toVOsWithPossibleValuesLoaded(ProfileFieldSearchContext profileFieldSearchContext, boolean bl, Map<String, Object> map, List<ProfileField> list) {
        if (map != null) {
            list = this.toVOs(list);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("searchContext", profileFieldSearchContext);
            hashMap.put("overBrokeredUsers", bl);
            hashMap.putAll(map);
            List list2 = list.stream().filter(CustomFieldDetailedVO.class::isInstance).map(CustomFieldDetailedVO.class::cast).collect(Collectors.toList());
            this.customFieldValueHandler.fillValuesFromScript(UserCustomField.class, LoadValuesScriptFunction.FILTER, hashMap, list2);
        }
        return list;
    }

    static {
        block14: for (ProfileFieldAction profileFieldAction : ProfileFieldAction.values()) {
            switch (profileFieldAction) {
                case VIEW: {
                    ACTIONS_PROPERTY.put(profileFieldAction, (Property<Boolean, UserProfileFieldActions>)UserProfileFieldActions.VIEW);
                    MY_PROFILE_FIELD_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.mpf.visible);
                    MY_PROFILE_FIELD_REGISTRATION_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.mpf.editableAtRegistration);
                    USER_PROFILE_FIELD_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.upf.visible);
                    continue block14;
                }
                case EDIT: {
                    ACTIONS_PROPERTY.put(profileFieldAction, (Property<Boolean, UserProfileFieldActions>)UserProfileFieldActions.EDIT);
                    MY_PROFILE_FIELD_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.mpf.editable);
                    MY_PROFILE_FIELD_REGISTRATION_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.mpf.editableAtRegistration);
                    USER_PROFILE_FIELD_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.upf.editable);
                    continue block14;
                }
                case MANAGE_PRIVACY: {
                    ACTIONS_PROPERTY.put(profileFieldAction, (Property<Boolean, UserProfileFieldActions>)UserProfileFieldActions.MANAGE_PRIVACY);
                    MY_PROFILE_FIELD_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.mpf.managePrivacy);
                    MY_PROFILE_FIELD_REGISTRATION_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.mpf.managePrivacy);
                    USER_PROFILE_FIELD_PATHS.put(profileFieldAction, ProfileFieldHandlerImpl.upf.editable);
                }
            }
        }
        SEARCH_PATHS = new HashMap<ProfileFieldSearchContext, BooleanPath>();
        block15: for (ProfileFieldAction profileFieldAction : ProfileFieldSearchContext.values()) {
            switch (1.$SwitchMap$org$cyclos$impl$users$ProfileFieldSearchContext[profileFieldAction.ordinal()]) {
                case 1: {
                    SEARCH_PATHS.put((ProfileFieldSearchContext)profileFieldAction, ProfileFieldHandlerImpl.upf.userFilter);
                    continue block15;
                }
                case 2: {
                    SEARCH_PATHS.put((ProfileFieldSearchContext)profileFieldAction, ProfileFieldHandlerImpl.upf.mapFilter);
                    continue block15;
                }
                case 3: 
                case 4: {
                    SEARCH_PATHS.put((ProfileFieldSearchContext)profileFieldAction, ProfileFieldHandlerImpl.upf.userKeywords);
                    continue block15;
                }
                case 5: {
                    SEARCH_PATHS.put((ProfileFieldSearchContext)profileFieldAction, ProfileFieldHandlerImpl.upf.adFilter);
                    continue block15;
                }
                case 6: {
                    SEARCH_PATHS.put((ProfileFieldSearchContext)profileFieldAction, ProfileFieldHandlerImpl.upf.adKeywords);
                    continue block15;
                }
                case 7: {
                    SEARCH_PATHS.put((ProfileFieldSearchContext)profileFieldAction, ProfileFieldHandlerImpl.upf.recordFilter);
                    continue block15;
                }
                case 8: {
                    SEARCH_PATHS.put((ProfileFieldSearchContext)profileFieldAction, ProfileFieldHandlerImpl.upf.recordKeywords);
                }
            }
        }
    }
}

