/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.AdminProductAuthorizationRole;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.IMemberOrBrokerProduct;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.MyProductPasswordAction;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductMyProfileField;
import org.cyclos.entities.users.ProductMyRecordType;
import org.cyclos.entities.users.ProductPasswordAction;
import org.cyclos.entities.users.ProductSystemRecordType;
import org.cyclos.entities.users.ProductUserProfileField;
import org.cyclos.entities.users.ProductUserRecordType;
import org.cyclos.entities.users.ProductUserTokenType;
import org.cyclos.entities.users.QAdminGroup;
import org.cyclos.entities.users.QBasicGroup;
import org.cyclos.entities.users.QMemberProduct;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QProductManagement;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.entities.users.UserProductNotification;
import org.cyclos.entities.users.UserProductPasswordAction;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.AgreementServiceLocal;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountFeeServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.AuthorizationRoleServiceLocal;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransferFilterServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.contentmanagement.DocumentCategoryServiceLocal;
import org.cyclos.impl.contentmanagement.SystemImageCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.messaging.MessageCategoryServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWebServiceServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.GroupListViewFactory;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.users.GroupsCacheKey;
import org.cyclos.impl.users.GroupsHandlerInternal;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.PrivacyControlServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductConversionHandler;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.users.UserProductsQueryResult;
import org.cyclos.impl.utils.PasswordActionHelper;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.ConfigurationEntityVO;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenType;
import org.cyclos.model.banking.accountfees.AccountFeeQuery;
import org.cyclos.model.banking.accountfees.AccountFeeWithTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeQuery;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.accounttypes.UserAccountTypeVO;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transferfilters.TransferFilterQuery;
import org.cyclos.model.banking.transferfilters.TransferFilterWithAccountTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.messaging.notifications.AccountNotificationType;
import org.cyclos.model.messaging.notifications.PersonalNotificationType;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.system.configurations.ConfigurationDetailedVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.webservices.CustomWebServiceVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.dashboard.QuickAccessType;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.AdminGroupVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.UserGroupVO;
import org.cyclos.model.users.privacycontrols.PrivacyControlVO;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.products.ActiveAdminProductsData;
import org.cyclos.model.users.products.ActiveProductsData;
import org.cyclos.model.users.products.ActiveUserAccountData;
import org.cyclos.model.users.products.ActiveUserProductsData;
import org.cyclos.model.users.products.AdminGroupAccessibility;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.model.users.products.AdminProductData;
import org.cyclos.model.users.products.BrokerMessagesOperation;
import org.cyclos.model.users.products.BrokerProductDTO;
import org.cyclos.model.users.products.BrokerProductData;
import org.cyclos.model.users.products.ImportOperation;
import org.cyclos.model.users.products.MemberProductDTO;
import org.cyclos.model.users.products.MemberProductData;
import org.cyclos.model.users.products.MyMessagesOperation;
import org.cyclos.model.users.products.MyOperatorsOperation;
import org.cyclos.model.users.products.MyProductPasswordActionDTO;
import org.cyclos.model.users.products.ProductAdminVoucherDTO;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.ProductData;
import org.cyclos.model.users.products.ProductMyProfileFieldDTO;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.ProductQuery;
import org.cyclos.model.users.products.ProductSearchData;
import org.cyclos.model.users.products.ProductUserProfileFieldDTO;
import org.cyclos.model.users.products.ProductUserVoucherDTO;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.products.ProductVoucherDTO;
import org.cyclos.model.users.products.ProductWithUserAccountVO;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserManagementProductDTO;
import org.cyclos.model.users.products.UserManagementProductData;
import org.cyclos.model.users.products.UserProductPasswordActionDTO;
import org.cyclos.model.users.products.ViewManageOperation;
import org.cyclos.model.users.recordtypes.RecordTypeNature;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.GroupFilterDefault;
import org.cyclos.model.users.users.GroupVisibility;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.QuickAccessDTO;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductServiceImpl
extends CRUDServiceImpl<Product, QProduct, ProductDTO, ProductData, ProductNature>
implements ProductServiceLocal {
    private static final BidiMap<Class<? extends Product>, Class<? extends ProductDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private Collection<ProductConversionHandler<?, ?, ?>> productConverters;
    @Autowired
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    private UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    protected GroupsHandlerInternal groupsHandlerInternal;
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private AccountFeeServiceLocal accountFeeService;
    @Autowired
    private TransferFilterServiceLocal transferFilterService;
    @Autowired
    private MessageCategoryServiceLocal messageCategoryService;
    @Autowired
    private AgreementServiceLocal agreementServiceLocal;
    @Autowired
    private CurrencyServiceLocal currencyServiceLocal;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private SystemImageCategoryServiceLocal systemImageCategoryService;
    @Autowired
    private DocumentCategoryServiceLocal documentCategoryService;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private AuthorizationRoleServiceLocal authorizationRoleService;
    @Autowired
    private LanguageServiceLocal languageService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private VoucherCustomFieldServiceLocal voucherCustomFieldService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    private BaseEntityValidation<BasicGroup> inSpecificUserGroupValidation = new BaseEntityValidation<BasicGroup>(){

        protected boolean isValid(Object object, Object object2, BasicGroup basicGroup) {
            ProductDTO productDTO = (ProductDTO)object;
            if (productDTO.getUserGroupAccessibility() == UserGroupAccessibility.ALL) {
                return true;
            }
            if (productDTO.getUserGroupAccessibility() == UserGroupAccessibility.NONE) {
                return false;
            }
            Set set = ProductServiceImpl.this.conversionHandler.convertSet(BasicGroup.class, (Iterable)productDTO.getAccessibleUserGroups());
            GroupSet groupSet = basicGroup instanceof UserGroup ? ((UserGroup)basicGroup).getGroupSet() : null;
            return set.contains(basicGroup) || set.contains(groupSet);
        }
    };
    @Autowired
    private ContactInfoFieldServiceLocal contactInfoFieldService;
    @Autowired
    private PrivacyControlServiceLocal privacyControlService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private CustomWebServiceServiceLocal customWebServiceService;
    @Autowired
    private ApplicationHandler applicationHandler;

    public ProductServiceImpl() {
        super(Product.class, QProduct.product, ProductDTO.class);
    }

    public boolean canViewProducts() {
        return this.hasPermission(Permission.USER_CONFIGURATION_VIEW) || this.getProducts().admin().getManagedProducts().isAnyKeySet((Path)QProductManagement.productManagement.view);
    }

    public AdminProduct createAdminProduct(AdminGroup adminGroup, boolean bl) {
        if (adminGroup.isPersistent()) {
            throw new IllegalStateException("Can only create an admin product to a transient group");
        }
        AdminProductDTO adminProductDTO = (AdminProductDTO)this.toDTO(this.newEntity(ProductNature.ADMIN));
        adminProductDTO.setName(adminGroup.getName());
        AdminGroupType adminGroupType = adminGroup.getAdminType();
        if (adminGroupType != null || adminGroup.isGlobal()) {
            boolean bl2 = adminGroupType == null;
            Channel channel = this.getSessionData().getChannel();
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)adminGroup);
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            PasswordActionHelper.setMyPasswordActions((ProductDTO)adminProductDTO, (PasswordType)channelConfiguration.getAccessPassword());
            PasswordActionHelper.setUserPasswordActions((UserManagementProductDTO)adminProductDTO);
            adminProductDTO.setMyChannelsAccessEnable(true);
            adminProductDTO.setMaxAddresses(Integer.valueOf(1));
            adminProductDTO.setMaxMobilePhones(Integer.valueOf(1));
            adminProductDTO.setMaxSmsPerMonth(Integer.valueOf(100));
            adminProductDTO.setMaxLandlinePhones(Integer.valueOf(1));
            adminProductDTO.setMaxProfileImages(Integer.valueOf(1));
            this.addProfilesFieldsAdminProduct(adminProductDTO, adminGroup);
            adminProductDTO.setNotifications(true);
            adminProductDTO.setMyNotificationSettingsEnable(true);
            adminProductDTO.setUserGroupAccessibility(bl2 ? UserGroupAccessibility.NONE : UserGroupAccessibility.ALL);
            adminProductDTO.setAdminGroupAccessibility(AdminGroupAccessibility.ALL);
            adminProductDTO.setErrorLog(ViewManageOperation.MANAGE);
            adminProductDTO.setAccessLog(true);
            adminProductDTO.setConfigurationEntityLog(true);
            adminProductDTO.setUserEntityLog(true);
        } else if (bl) {
            ProductDTO productDTO = this.toDTO((Product)adminGroup.getNetwork().getAdministrators().getAdminProduct());
            List list = productDTO.getMyProfileFields();
            ModelHelper.clearIds((Iterable)list);
            adminProductDTO.setMyProfileFields(list);
            List list2 = productDTO.getUserProfileFields();
            ModelHelper.clearIds((Iterable)list2);
            adminProductDTO.setUserProfileFields(list2);
        }
        if (adminGroup.isGlobal()) {
            adminProductDTO.setMyIdentityProvidersEnable(true);
        }
        if (adminGroupType != null) {
            adminProductDTO.setSystemConfiguration(ViewManageOperation.MANAGE);
            adminProductDTO.setUserConfiguration(ViewManageOperation.MANAGE);
            adminProductDTO.setBulkActions(ViewManageOperation.MANAGE);
            adminProductDTO.setSystemAlerts(true);
            adminProductDTO.setSystemImageCategories(ViewManageOperation.MANAGE);
            adminProductDTO.setSystemImageCategoriesView(CollectionHelper.asSet((Iterable)this.systemImageCategoryService.list()));
            adminProductDTO.setVoucherTemplates(ViewManageOperation.MANAGE);
            adminProductDTO.setUserGroup(ViewManageOperation.MANAGE);
            adminProductDTO.setViewHiddenProfileFields(true);
            adminProductDTO.setBlockedUsersManage(true);
            adminProductDTO.setPendingUsers(ViewManageOperation.MANAGE);
            adminProductDTO.setDisabledUsers(ViewManageOperation.MANAGE);
            adminProductDTO.setRemovedUsers(ViewManageOperation.MANAGE);
            adminProductDTO.setPurgedUsers(ViewManageOperation.MANAGE);
            adminProductDTO.setUserRegistration(true);
            adminProductDTO.setConnectedUsers(ViewManageOperation.MANAGE);
            if (adminGroupType == AdminGroupType.GLOBAL) {
                adminProductDTO.setGlobalConfiguration(ViewManageOperation.MANAGE);
                adminProductDTO.setApplicationTranslation(this.conversionHandler.convertSet(LanguageVO.class, (Iterable)this.languageService.listAll()));
                adminProductDTO.setSystemImageCategoriesManage(adminProductDTO.getSystemImageCategoriesView());
            } else {
                adminProductDTO.setApplicationTranslation(this.conversionHandler.convertSet(LanguageVO.class, (Iterable)this.languageService.list()));
                adminProductDTO.setSystemImageCategoriesManage(adminProductDTO.getSystemImageCategoriesView().stream().filter(systemImageCategoryVO -> !systemImageCategoryVO.isGlobal()).collect(Collectors.toSet()));
                adminProductDTO.setMailingLists(ViewManageOperation.MANAGE);
                adminProductDTO.setAccountConfiguration(ViewManageOperation.MANAGE);
                adminProductDTO.setDocumentCategoryView(CollectionHelper.asSet((Iterable)this.documentCategoryService.list()));
                adminProductDTO.setDocumentCategoryManage(adminProductDTO.getDocumentCategoryView());
                this.setMessageCategories(adminProductDTO);
                adminProductDTO.setViewMessagesSentToSysWithCat(adminProductDTO.getSendMessagesFromSysWithCat());
                adminProductDTO.setManageMessagesSentToSysWithCat(adminProductDTO.getSendMessagesFromSysWithCat());
                adminProductDTO.setAccountFeeCharges(ViewManageOperation.MANAGE);
                adminProductDTO.setAdConfiguration(ViewManageOperation.MANAGE);
                adminProductDTO.setUserAuthorizedPaymentsCancel(true);
                adminProductDTO.setDocumentCategories(ViewManageOperation.MANAGE);
                adminProductDTO.setMessageCategories(ViewManageOperation.MANAGE);
                adminProductDTO.setSendMessagesToGroups(true);
                adminProductDTO.setImports(CollectionHelper.asSet(Arrays.asList(ImportOperation.IMPORT_USERS, ImportOperation.IMPORT_ADS, ImportOperation.IMPORT_GENERAL_REFERENCES, ImportOperation.IMPORT_RECORDS, ImportOperation.IMPORT_TRANSFERS, ImportOperation.IMPORT_PAYMENTS, ImportOperation.IMPORT_TOKENS)));
                adminProductDTO.setSystemReports(ViewManageOperation.MANAGE);
                adminProductDTO.setUserAgreementLog(true);
                adminProductDTO.setUserBalanceLimit(ViewManageOperation.MANAGE);
                adminProductDTO.setUserPaymentLimit(ViewManageOperation.MANAGE);
                PasswordActionHelper.setUserPasswordActions((UserManagementProductDTO)adminProductDTO);
                adminProductDTO.setPendingUsers(ViewManageOperation.MANAGE);
                adminProductDTO.setUserBrokers(ViewManageOperation.MANAGE);
                adminProductDTO.setUserDocuments(ViewManageOperation.MANAGE);
                adminProductDTO.setManageTransactionFeedbacks(true);
                adminProductDTO.setManageReferences(true);
                adminProductDTO.setUserAdvertisements(ViewManageOperation.MANAGE);
                adminProductDTO.setUserWebShop(ViewManageOperation.MANAGE);
                adminProductDTO.setUserWebShopPurchases(ViewManageOperation.VIEW);
                adminProductDTO.setUserWebShopSales(ViewManageOperation.VIEW);
                adminProductDTO.setUserWebShopSettings(ViewManageOperation.MANAGE);
                adminProductDTO.setUserNotificationSettings(ViewManageOperation.MANAGE);
                adminProductDTO.setUserAlerts(true);
                adminProductDTO.setDefaultQuickAccess(QuickAccessType.getByRole((Role)Role.ADMIN).stream().filter(quickAccessType -> !quickAccessType.hasEntity()).map(quickAccessType -> new QuickAccessDTO((org.cyclos.model.Property)QuickAccessDTO.TYPE, quickAccessType)).collect(Collectors.toSet()));
            }
        }
        Long l = this.save(adminProductDTO);
        return this.find(AdminProduct.class, l);
    }

    public void createRelationship(Product product, org.cyclos.model.Property<?, ?> property, SimpleEntity simpleEntity) {
        ProductConversionHandler productConversionHandler = this.getProductConverter(product);
        String string = productConversionHandler.getProductPropertyForDtoProperty(property);
        Collection collection = (Collection)InvocationContext.wrap((Object)product).getPropertyValue(string);
        if (collection.add(simpleEntity)) {
            Collection collection2 = productConversionHandler.getPermissionsForProperty(property);
            product.getPermissions().addAll(collection2);
            this.evictAccessorCache(product);
        }
    }

    public <DTO extends ProductDTO> ProductConversionHandler<? extends Product, DTO, ? extends ActiveProductsData> getProductConverter(DTO DTO) {
        for (ProductConversionHandler<?, ?, ?> productConversionHandler : this.productConverters) {
            if (!productConversionHandler.getDTOType().isInstance(DTO)) continue;
            return productConversionHandler;
        }
        throw new IllegalStateException("No product converter for " + String.valueOf(DTO.getClass()));
    }

    public <P extends Product, DTO extends ProductDTO, AD extends ActiveProductsData> ProductConversionHandler<P, DTO, AD> getProductConverter(P p) {
        for (ProductConversionHandler<?, ?, ?> productConversionHandler : this.productConverters) {
            if (!productConversionHandler.getEntityType().isInstance(p)) continue;
            return productConversionHandler;
        }
        throw new IllegalStateException("No product converter for " + String.valueOf(p.getClass()));
    }

    public ProductSearchData getSearchData() {
        SessionData sessionData = this.getSessionData();
        ProductSearchData productSearchData = new ProductSearchData();
        productSearchData.setSkipView(sessionData.getConfiguration().isSkipProductsView());
        productSearchData.setCanManage(sessionData.hasPermission(Permission.USER_CONFIGURATION_MANAGE));
        productSearchData.setGroups(this.groupsHandler.visibles().accessibles().basic().sorted());
        productSearchData.setUserAccountTypes(this.listUserAccountTypes(UserAccountTypeVO.class));
        ProductQuery productQuery = (ProductQuery)QueryHelper.newQuery(ProductQuery.class);
        productSearchData.setQuery((QueryParameters)productQuery);
        return productSearchData;
    }

    public List<MemberProduct> listByAccount(UserAccountType userAccountType) {
        QMemberProduct qMemberProduct = QMemberProduct.memberProduct;
        return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qMemberProduct}).where((Predicate)qMemberProduct.userAccount().eq((Object)userAccountType))).list((Expression)qMemberProduct);
    }

    public List<Product> listByRoles(Collection<Role> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptyList();
        }
        QProduct qProduct = QProduct.product;
        ArrayList<ProductNature> arrayList = new ArrayList<ProductNature>();
        for (Role role : collection) {
            arrayList.add(ProductNature.fromRole((Role)role));
        }
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qProduct}).where((Predicate)qProduct.nature.in(arrayList));
        this.filterByVisibleProducts(qProduct, dBQuery);
        return dBQuery.list((Expression)qProduct);
    }

    public List<Product> listEntities() {
        QProduct qProduct = QProduct.product;
        return ((DBQuery)this.from(new EntityPath[]{qProduct}).orderBy(new OrderSpecifier[]{qProduct.nature.asc(), qProduct.name.asc()})).list((Expression)qProduct);
    }

    @Override
    public Product newEntity(ProductNature productNature) {
        AdminProduct adminProduct = null;
        switch (productNature) {
            case ADMIN: {
                adminProduct = new AdminProduct();
                break;
            }
            case BROKER: {
                adminProduct = new BrokerProduct();
                break;
            }
            case MEMBER: {
                adminProduct = new MemberProduct();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled product type: " + String.valueOf(productNature));
            }
        }
        this.setFixedSMSNotificationSettings((Product)adminProduct);
        return adminProduct;
    }

    public UserProductsQueryResult permissionQuery(Permission ... permissionArray) {
        List list = CollectionHelper.isEmpty((Object[])permissionArray) ? Collections.emptyList() : ((DBQuery)this.selectFrom(this.$).where((Predicate)((EnumPath)((QProduct)this.$).permissions.any()).in((Object[])permissionArray))).fetch();
        return this.doPermissionQuery(list);
    }

    public UserProductsQueryResult productQuery(Collection<? extends Product> collection) {
        return this.doPermissionQuery(collection);
    }

    public void removeAllRelationships(org.cyclos.model.Property<?, ?> property, SimpleEntity simpleEntity) {
        Set<ProductNature> set = this.naturesForDTOProperty(property);
        this.listByNatures(set).forEach(product -> this.removeRelationship((Product)product, property, simpleEntity));
    }

    public Page<ProductWithUserAccountVO> search(ProductQuery productQuery) {
        QUser qUser;
        QProduct qProduct = QProduct.product;
        QAdminGroup qAdminGroup = QAdminGroup.adminGroup;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qProduct});
        dBQuery.where((Predicate)qProduct.instanceOfAny(new Class[]{MemberProduct.class, BrokerProduct.class}).or((Predicate)((JPAQuery)((JPAQuery)new JPAQuery().from((EntityPath)qAdminGroup)).where((Predicate)qAdminGroup.adminProduct().eq((Expression)qProduct))).notExists()));
        Set set = this.groupsHandler.flattenVOs((Collection)productQuery.getGroups());
        if (QueryHelper.useParameter((Object)productQuery.getName())) {
            dBQuery.where((Predicate)qProduct.name.containsIgnoreCase(productQuery.getName()));
        }
        if (QueryHelper.useParameter((Object)productQuery.getNatures())) {
            dBQuery.where((Predicate)qProduct.nature.in((Collection)productQuery.getNatures()));
        }
        if (QueryHelper.useParameter((Object)productQuery.getUserAccountType())) {
            qUser = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)productQuery.getUserAccountType());
            dBQuery.where((Predicate)qProduct.userAccount().eq((Object)qUser));
        }
        if (productQuery.isIndividualAssignedOnly()) {
            qUser = QUser.user;
            DBQuery<?> dBQuery2 = this.subQuery(new EntityPath[]{qUser});
            dBQuery2.where((Predicate)qProduct.users.contains((Expression)qUser._super));
            if (QueryHelper.useParameter((Object)productQuery.getGroups())) {
                dBQuery2.where((Predicate)qUser.group().in((Collection)set));
            }
            dBQuery.where((Predicate)dBQuery2.exists());
        } else if (QueryHelper.useParameter((Object)productQuery.getGroups())) {
            qUser = QBasicGroup.basicGroup;
            DBQuery<?> dBQuery3 = this.subQuery(new EntityPath[]{qUser});
            dBQuery3.where((Predicate)qUser.in((CollectionExpression)qProduct.groups).and((Predicate)qUser.in((Collection)set)));
            dBQuery.where((Predicate)dBQuery3.exists());
        }
        dBQuery.orderBy(new OrderSpecifier[]{qProduct.nature.asc(), qProduct.name.asc()});
        this.filterByVisibleProducts(qProduct, dBQuery);
        return dBQuery.page(ProductWithUserAccountVO.class, (QueryParameters)productQuery, (Expression)qProduct);
    }

    public ActiveProductsData toActiveProduct(ProductsAccessor productsAccessor) {
        Object object2;
        Class<ActiveAdminProductsData> clazz;
        boolean bl = false;
        List list = productsAccessor.product().getRoles();
        if (list.contains(Role.ADMIN)) {
            clazz = ActiveAdminProductsData.class;
        } else {
            clazz = ActiveUserProductsData.class;
            bl = list.contains(Role.BROKER);
        }
        ActiveProductsData activeProductsData = (ActiveProductsData)this.conversionHandler.convert(clazz, (Object)productsAccessor.product());
        List list2 = productsAccessor.product().getPermissions();
        Collection<ProductConversionHandler<?, ?, ?>> collection = this.getProductConvertersForActiveData(activeProductsData);
        for (Object object2 : collection) {
            object2.fill((Collection)list2, activeProductsData);
        }
        List list3 = this.profileFieldHandler.getAllProfileFields();
        object2 = abstractProductProfileFieldDTO -> {
            ProfileField profileField = abstractProductProfileFieldDTO.getProfileField();
            if (profileField instanceof BasicProfileField) {
                return list3.indexOf(profileField);
            }
            String string = ((IInternalNamedEntity)profileField).getInternalName();
            for (int i = 0; i < list3.size(); ++i) {
                UserCustomField userCustomField = (UserCustomField)ObjectHelper.ifType(list3.get(i), UserCustomField.class);
                if (userCustomField == null || !userCustomField.getInternalName().equals(string)) continue;
                return i;
            }
            return Integer.MAX_VALUE;
        };
        Comparator comparator = (abstractProductProfileFieldDTO, abstractProductProfileFieldDTO2) -> {
            int n = object2.applyAsInt(abstractProductProfileFieldDTO);
            int n2 = object2.applyAsInt(abstractProductProfileFieldDTO2);
            return Integer.compare(n, n2);
        };
        activeProductsData.getMyProfileFields().sort(comparator);
        activeProductsData.getUserProfileFields().sort(comparator);
        List list4 = this.recordFieldHandler.getProductRecordFields(productsAccessor, ProductMyRecordType.class);
        activeProductsData.setMyRecordTypeFields(list4);
        if (activeProductsData instanceof ActiveUserProductsData) {
            ActiveUserProductsData activeUserProductsData = (ActiveUserProductsData)activeProductsData;
            List list5 = activeUserProductsData.getOperatorProfileFields();
            if (list5 != null) {
                list5.sort(comparator);
            }
            activeUserProductsData.setChannels(this.channelService.list());
            activeUserProductsData.setPrincipalTypes(this.principalTypeService.list());
            ArrayList<ActiveUserAccountData> arrayList = new ArrayList<ActiveUserAccountData>();
            List list6 = productsAccessor.member().getUserAccounts();
            for (Object object3 : list6) {
                MemberProductAccessor memberProductAccessor = productsAccessor.member(object3);
                ActiveUserAccountData activeUserAccountData = (ActiveUserAccountData)this.conversionHandler.convert(ActiveUserAccountData.class, (Object)memberProductAccessor);
                activeUserAccountData.setUserAccount((AccountTypeWithCurrencyVO)this.conversionHandler.convert(AccountTypeWithCurrencyVO.class, object3));
                arrayList.add(activeUserAccountData);
            }
            activeUserProductsData.setAccounts(arrayList);
            activeUserProductsData.setUserRegistrationGroups(this.conversionHandler.convertList(UserGroupVO.class, (Iterable)productsAccessor.member().getUserRegistrationGroups()));
            if (bl) {
                Object object3;
                ArrayList arrayList2 = new ArrayList();
                arrayList2.addAll(EnumSet.allOf(BasicProfileField.class));
                arrayList2.addAll(this.userCustomFieldService.listAll());
                activeUserProductsData.setUserProfileFieldsAsBroker(this.profileFieldHandler.getUserProfileFields((ProductAccessor)productsAccessor.broker()));
                activeUserProductsData.getUserProfileFieldsAsBroker().sort(comparator);
                activeUserProductsData.setUserProfileFields(this.profileFieldHandler.getUserProfileFields((ProductAccessor)productsAccessor.member()));
                activeUserProductsData.getUserProfileFields().sort(comparator);
                activeUserProductsData.setSimpleUserSearchProfileFieldsAsBroker(this.profileFieldHandler.toBasicVOs((Collection)productsAccessor.broker().getSimpleUserSearchProfileFields()));
                activeUserProductsData.setSimpleUserSearchProfileFields(CollectionHelper.asSet((Iterable)this.profileFieldHandler.toBasicVOs((Collection)productsAccessor.member().getSimpleUserSearchProfileFields())));
                activeUserProductsData.setGroupVisibilityAsBroker(this.groupsHandlerInternal.getGroupVisibility(productsAccessor, true));
                activeUserProductsData.setGroupVisibility(this.groupsHandlerInternal.getGroupVisibility(productsAccessor, false));
                activeUserProductsData.setVisibleTransactionFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)productsAccessor.member().getVisibleTransactionFields()));
                activeUserProductsData.setVisibleTransactionFieldsAsBroker(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)productsAccessor.broker().getVisibleTransactionFields()));
                activeUserProductsData.setVisibleVoucherFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)productsAccessor.member().getVisibleVoucherFields()));
                activeUserProductsData.setVisibleVoucherFieldsAsBroker(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)productsAccessor.broker().getVisibleVoucherFields()));
                object3 = this.recordFieldHandler.getProductRecordFields(productsAccessor, ProductUserRecordType.class);
                activeUserProductsData.setUserRecordTypeFields((List)object3);
                activeUserProductsData.setUserRegistrationGroupsAsBroker(this.conversionHandler.convertList(UserGroupVO.class, (Iterable)productsAccessor.broker().getUserRegistrationGroups()));
            } else {
                activeUserProductsData.setSimpleUserSearchProfileFields(CollectionHelper.asSet((Iterable)this.profileFieldHandler.toBasicVOs((Collection)productsAccessor.member().getSimpleUserSearchProfileFields())));
            }
            if (activeUserProductsData.getGroupVisibility() == null) {
                activeUserProductsData.setGroupVisibility(GroupVisibility.NONE);
            }
        } else {
            ActiveAdminProductsData activeAdminProductsData = (ActiveAdminProductsData)activeProductsData;
            List list7 = this.recordFieldHandler.getProductRecordFields(productsAccessor, ProductUserRecordType.class);
            activeAdminProductsData.setUserRecordTypeFields(list7);
            List list8 = this.recordFieldHandler.getProductRecordFields(productsAccessor, ProductSystemRecordType.class);
            activeAdminProductsData.setSystemRecordTypeFields(list8);
            activeAdminProductsData.setSimpleUserSearchProfileFields(CollectionHelper.asSet((Iterable)this.profileFieldHandler.toBasicVOs((Collection)productsAccessor.admin().getSimpleUserSearchProfileFields())));
            activeAdminProductsData.setArchivingEnabled(this.applicationHandler.isArchivingEnabled());
        }
        return activeProductsData;
    }

    @Override
    public ProductDTO toDTO(Product product) {
        return this.getProductConverter(product).toDTO(product);
    }

    @Override
    public Product toEntity(ProductDTO productDTO) {
        return (Product)this.invokerHandler.runAs(SessionDataFactory.system(), () -> this.getProductConverter((Product)productDTO).toEntity(productDTO));
    }

    public void updateProductPasswordActions(PasswordType passwordType) {
        if (passwordType.getNetwork() == null) {
            PasswordTypeVO passwordTypeVO = (PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType);
            PasswordMode passwordMode = passwordType.getPasswordMode();
            if (!passwordMode.allowActions()) {
                return;
            }
            List<AdminProduct> list = this.listAdminProducts();
            for (AdminProduct adminProduct : list) {
                UserProductPasswordActionDTO userProductPasswordActionDTO = new UserProductPasswordActionDTO();
                userProductPasswordActionDTO.setPasswordType(passwordTypeVO);
                userProductPasswordActionDTO.setEnable(true);
                userProductPasswordActionDTO.setChange(passwordMode == PasswordMode.MANUAL);
                userProductPasswordActionDTO.setReset(true);
                userProductPasswordActionDTO.setUnblock(true);
                MyProductPasswordActionDTO myProductPasswordActionDTO = new MyProductPasswordActionDTO();
                myProductPasswordActionDTO.setPasswordType(passwordTypeVO);
                myProductPasswordActionDTO.setChange(passwordMode == PasswordMode.MANUAL);
                ProductVO productVO = new ProductVO(adminProduct.getId());
                myProductPasswordActionDTO.setProduct(productVO);
                userProductPasswordActionDTO.setProduct(productVO);
                adminProduct.getUserPasswordActions().add((UserProductPasswordAction)this.conversionHandler.convert(UserProductPasswordAction.class, (Object)userProductPasswordActionDTO));
                adminProduct.getPasswordActions().add((MyProductPasswordAction)this.conversionHandler.convert(MyProductPasswordAction.class, (Object)myProductPasswordActionDTO));
                this.persist((IEntity)adminProduct);
            }
        }
    }

    protected void fixPasswordActions(Set<? extends ProductPasswordAction> set) {
        Set<ProductPasswordAction> set2 = set.stream().filter(productPasswordAction -> !productPasswordAction.getPasswordType().getPasswordMode().allowActions()).collect(Collectors.toSet());
        set.removeAll(set2);
        set2.forEach(productPasswordAction -> {
            if (productPasswordAction.isTransient()) {
                this.remove(productPasswordAction);
            }
        });
    }

    @Override
    protected ProductData getData(Product product) {
        AdminProductData adminProductData;
        if (product instanceof AdminProduct) {
            adminProductData = this.getAdminData((AdminProduct)product);
        } else if (product instanceof MemberProduct) {
            adminProductData = this.getMemberData((MemberProduct)product);
        } else if (product instanceof BrokerProduct) {
            adminProductData = this.getBrokerData((BrokerProduct)product);
        } else {
            throw new IllegalStateException("Unhandled product data");
        }
        adminProductData.setDto((EntityDTO)this.toDTO(product));
        return adminProductData;
    }

    @Override
    protected void onAfterRemove(Product product) {
        Long l = SimpleEntity.id((SimpleEntity)product.getNetwork());
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetwork(l));
        this.cacheHandler.schedulePartialEvict(CacheType.GROUPS, (SerializablePredicate & Serializable)groupsCacheKey -> groupsCacheKey.matchesNetwork(l));
    }

    @Override
    protected void onBeforeRemove(Product product) {
        if (product instanceof AdminProduct && ((AdminProduct)product).getAdminGroup() != null) {
            throw new IllegalActionException();
        }
        if (!this.canRemove(product)) {
            throw new ValidationException(this.message(UsersKeys.Products.CANNOT_REMOVE, new Object[0]));
        }
    }

    @Override
    protected Object onBeforeSave(Product product, Product product2) {
        Set set;
        Object object;
        Object object2;
        Object object32;
        BigDecimal bigDecimal;
        Object object4;
        Object object5;
        Object object6;
        product.setChannelIds(StringHelper.trimToNull((Object)product.getChannels().stream().map(SimpleEntity::id).sorted().map(l -> l.toString()).collect(Collectors.joining(","))));
        product.setPrincipalTypeIds(StringHelper.trimToNull((Object)product.getPrincipalTypes().stream().map(SimpleEntity::id).sorted().map(l -> l.toString()).collect(Collectors.joining(","))));
        this.fixPasswordActions(product.getPasswordActions());
        this.setFixedSMSNotificationSettings(product);
        if (product instanceof IMemberOrBrokerProduct) {
            this.ensureNotificationType((IMemberOrBrokerProduct)product);
        }
        CollectionHelper.orEmpty((Set)product.getMyAccessClients()).stream().filter(productMyAccessClient -> !productMyAccessClient.getAccessClientType().isAllowManualCreation()).forEach(productMyAccessClient -> productMyAccessClient.setUnassign(false));
        if (product instanceof MemberProduct) {
            object6 = (MemberProduct)product;
            if (object6.getUserAccount() == null) {
                this.resetAccountSettings((MemberProduct)object6);
            } else {
                if (!BigDecimalHelper.isPositive((BigDecimal)object6.getInitialCredit())) {
                    object6.setInitialCreditType(null);
                }
                if ((object5 = object6.getDefaultCreditLimit()) != null) {
                    object6.setDefaultCreditLimit(((BigDecimal)object5).abs());
                }
                if ((object4 = object6.getIndividualCreditLimit()) != null) {
                    object6.setIndividualCreditLimit(((BigDecimal)object4).abs());
                }
                if ((bigDecimal = object6.getDefaultUpperCreditLimit()) != null) {
                    object6.setDefaultUpperCreditLimit(bigDecimal.abs());
                }
            }
            if (object6.getGroupFilterDefault() == null) {
                object6.setGroupFilterDefault(GroupFilterDefault.NONE);
            }
            if (object6.getGroupFilterDefault() != GroupFilterDefault.SPECIFIC) {
                object6.setDefaultFilterGroups(null);
            }
            if (object6.getSearchUsersOnGroups() == null) {
                object6.setSearchUsersOnGroups(UserGroupAccessibility.NONE);
            }
            if (object6.getSearchUsersOnGroups() != UserGroupAccessibility.SPECIFIC) {
                object6.setGroupsForUserSearch(null);
            }
            if (object6.getViewProfileOnGroups() == null) {
                object6.setViewProfileOnGroups(UserGroupAccessibility.NONE);
            }
            if (object6.getViewProfileOnGroups() != UserGroupAccessibility.SPECIFIC) {
                object6.setGroupsForViewProfile(null);
            }
            if ((object5 = object6.getGroupVisibility()) == null) {
                object5 = GroupVisibility.NONE;
                object6.setGroupVisibility((GroupVisibility)object5);
            }
            if (!(object4 = object6.getPermissions()).contains(Permission.MY_OPERATORS_ENABLE)) {
                object6.setMaxOperators(null);
                object6.getOperatorProfileFields().clear();
            }
            if (!(object4.contains(Permission.MY_ADS_ENABLE) || object4.contains(Permission.MY_WEB_SHOP_ENABLE) || object4.contains(Permission.USER_ADS_VIEW) || object4.contains(Permission.USER_WEB_SHOP_VIEW))) {
                object6.getMyAdFields().clear();
            }
            if (object5 == GroupVisibility.NONE) {
                object6.setGroupFilterDefault(GroupFilterDefault.NONE);
            }
            if ((bigDecimal = object6.getGroupFilterDefault()) == null) {
                object6.setGroupFilterDefault(GroupFilterDefault.NONE);
            }
            if (bigDecimal == GroupFilterDefault.OWN_GROUP && ObjectHelper.isOneOf((Object)object5, (Object[])new Object[]{GroupVisibility.GROUP_SET, GroupVisibility.NONE}) || bigDecimal == GroupFilterDefault.OWN_GROUP_SET && object5 == GroupVisibility.NONE) {
                throw new IllegalArgumentException();
            }
            CollectionHelper.orEmpty((Set)object6.getMyTokenTypes()).stream().forEach(productMyTokenType -> {
                if (productMyTokenType.getTokenType().getTokenType().isNFCDevice()) {
                    productMyTokenType.setActivate(false);
                }
                if (!productMyTokenType.getTokenType().getTokenType().isNFCTag()) {
                    productMyTokenType.setPersonalize(false);
                }
            });
            object6.getVouchers().stream().filter(productMemberVoucher -> !productMemberVoucher.isBuy()).forEach(productMemberVoucher -> productMemberVoucher.setRefund(false));
            if (object6.getAccountAccessibility() == AccountAccessibility.NEVER) {
                object6.setAccountVisibility(null);
                object6.setMyTransferFilters(null);
                object6.setMyPaymentTypes(null);
                object6.setMyExternalPaymentTypes(null);
                object6.setMakePosPaymentTypes(null);
                object6.setReceivePosPaymentTypes(null);
                object6.setMyCreateTicketPaymentTypes(null);
                object6.setMyApproveTicketPaymentTypes(null);
                object6.setChargebackPaymentTypes(null);
                object6.setMyPaymentRequestTypes(null);
            } else if (object6.getAccountVisibility() == null) {
                object6.setAccountVisibility(AccountVisibility.ALWAYS_VISIBLE);
            }
        }
        if (product2 != null) {
            this.evictAccessorCache(product);
            object6 = SimpleEntity.id((SimpleEntity)product.getNetwork());
            this.cacheHandler.schedulePartialEvict(CacheType.GROUPS, arg_0 -> ProductServiceImpl.lambda$onBeforeSave$be06aa22$1((Long)object6, arg_0));
        }
        if ((object6 = product.getMyProfileFields()) != null) {
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = (ProductMyProfileField)object5.next();
                if (!object4.isEnabled()) {
                    object4.setVisible(false);
                    object4.setEditable(false);
                    object4.setEditableAtRegistration(false);
                    object4.setManagePrivacy(false);
                } else if (!object4.isVisible()) {
                    object4.setEditable(false);
                    object4.setManagePrivacy(false);
                }
                if (!((bigDecimal = object4.getProfileField()) instanceof BasicProfileField)) continue;
                object32 = (BasicProfileField)bigDecimal;
                if (!object32.allowManagePrivacy()) {
                    object4.setManagePrivacy(false);
                }
                if (!object32.readOnly()) continue;
                object4.setEditable(false);
                object4.setEditableAtRegistration(false);
            }
        }
        if ((object5 = product.getUserProfileFields()) != null) {
            boolean bl = product.getNature() == ProductNature.BROKER;
            boolean bl2 = bl || product.getNature() == ProductNature.ADMIN;
            object32 = object5.iterator();
            while (object32.hasNext()) {
                object2 = (ProductUserProfileField)object32.next();
                if (!object2.isVisible()) {
                    object2.setEditable(false);
                    object2.setUserFilter(false);
                    object2.setUserKeywords(false);
                    object2.setAdFilter(false);
                    object2.setAdKeywords(false);
                    object2.setRecordFilter(false);
                    object2.setRecordKeywords(false);
                }
                object = object2.getProfileField();
                boolean bl3 = false;
                if (object instanceof BasicProfileField) {
                    bl3 = ((BasicProfileField)object).readOnly();
                }
                if (bl2 && !bl3) continue;
                object2.setEditable(false);
            }
        }
        if ((set = product.getTransferStatusFlows()) != null) {
            for (Object object32 : set) {
                if (object32.isVisible()) continue;
                object32.setEditable(false);
            }
        }
        if (product instanceof AdminProduct) {
            AdminProduct adminProduct = (AdminProduct)product;
            if (adminProduct.getAdminGroup() != null) {
                if (adminProduct.getAdminGroup().getAdminType() != null) {
                    adminProduct.setUserGroupAccessibility(UserGroupAccessibility.ALL);
                    adminProduct.setAdminGroupAccessibility(AdminGroupAccessibility.ALL);
                } else if (adminProduct.getAdminGroupAccessibility() != AdminGroupAccessibility.SPECIFIC) {
                    adminProduct.setAccessibleAdminGroups(null);
                }
            }
            if ((object32 = adminProduct.getAuthorizationRoles()) != null) {
                object2 = object32.iterator();
                while (object2.hasNext()) {
                    object = (AdminProductAuthorizationRole)object2.next();
                    if (object.isView()) continue;
                    object.setManage(false);
                }
            }
            adminProduct.setChannels(Collections.emptySet());
            if (product.getPermissions().contains(Permission.USER_CONFIGURATION_MANAGE)) {
                adminProduct.getManagedProducts().clear();
            }
            if (!product.getPermissions().contains(Permission.MY_NOTIFICATIONS_ENABLE)) {
                adminProduct.getDefaultNotifications().clear();
                adminProduct.getAuthorizablePaymentsToNotify().clear();
                adminProduct.getExternalPaymentsExpiredToNotify().clear();
                adminProduct.getExternalPaymentsFailedToNotify().clear();
                adminProduct.getFwdMessageCategoriesToEmailToNotify().clear();
                adminProduct.getPaymentsToNotify().clear();
                adminProduct.getSystemAlertsToNotify().clear();
                adminProduct.getUserAlertsToNotify().clear();
                adminProduct.getUserGroupsToNotify().clear();
                adminProduct.getVoucherConfigurationsBuyingToNotify().clear();
                adminProduct.getVoucherConfigurationsToNotify().clear();
            }
            if (product.getPermissions().contains(Permission.SYSTEM_CONFIGURATION_MANAGE)) {
                adminProduct.getManageContentSpecificConfigurations().clear();
                adminProduct.getManageSpecificConfigurations().clear();
                product.getPermissions().remove(Permission.SPECIFIC_CONFIGURATION_MANAGE);
                product.getPermissions().remove(Permission.SPECIFIC_CONFIGURATION_MANAGE_CONTENT);
            } else {
                adminProduct.getManageContentSpecificConfigurations().removeAll(adminProduct.getManageSpecificConfigurations());
                if (adminProduct.getManageContentSpecificConfigurations().isEmpty()) {
                    product.getPermissions().remove(Permission.SPECIFIC_CONFIGURATION_MANAGE_CONTENT);
                }
            }
            if (CollectionHelper.isEmpty((Iterable)adminProduct.getSendMessagesFromSysWithCat())) {
                adminProduct.setSysMsgSendToGroupsEnabled(false);
                adminProduct.setMaxMessageRecipients(Integer.valueOf(0));
            }
        }
        if (product instanceof UserManagementProduct) {
            UserManagementProduct userManagementProduct;
            if (!product.getPermissions().contains(Permission.USER_ADS_VIEW) && !product.getPermissions().contains(Permission.USER_ADS_MANAGE)) {
                product.getPermissions().remove(Permission.USER_PENDING_ADS_VIEW);
                product.getPermissions().remove(Permission.USER_PENDING_ADS_MANAGE);
            }
            if (!product.getPermissions().contains(Permission.USER_WEB_SHOP_VIEW) && !product.getPermissions().contains(Permission.USER_WEB_SHOP_MANAGE)) {
                product.getPermissions().remove(Permission.USER_PENDING_WEB_SHOP_VIEW);
                product.getPermissions().remove(Permission.USER_PENDING_WEB_SHOP_MANAGE);
            }
            if ((object32 = (userManagementProduct = (UserManagementProduct)product).getUserRecordTypes()) != null) {
                object2 = object32.iterator();
                while (object2.hasNext()) {
                    object = (ProductUserRecordType)object2.next();
                    if (object.isView()) continue;
                    object.setEdit(false);
                }
            }
            if ((object2 = userManagementProduct.getUserTokenTypes()) != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    ProductUserTokenType productUserTokenType = (ProductUserTokenType)object.next();
                    if (!productUserTokenType.getTokenType().getTokenType().isNFCTag()) {
                        productUserTokenType.setPersonalize(false);
                        productUserTokenType.setInitialize(false);
                    } else if (productUserTokenType.isInitialize()) {
                        productUserTokenType.setCancel(true);
                    }
                    if (!productUserTokenType.getTokenType().getTokenType().isNFC()) continue;
                    productUserTokenType.setCreate(false);
                    productUserTokenType.setActivate(false);
                }
            }
            this.fixPasswordActions(userManagementProduct.getUserPasswordActions());
        }
        if (product instanceof BrokerProduct) {
            product.setUserGroupAccessibility(null);
            product.setAccessibleUserGroups(null);
            product.setUserDirectoryOnGroups(null);
            product.setGroupsForUserDirectory(null);
        }
        if (product.getUserGroupAccessibility() != UserGroupAccessibility.SPECIFIC) {
            product.setAccessibleUserGroups(null);
        }
        if (product.getUserDirectoryOnGroups() == null) {
            product.setUserDirectoryOnGroups(UserGroupAccessibility.NONE);
        }
        if (product.getUserDirectoryOnGroups() != UserGroupAccessibility.SPECIFIC) {
            product.setGroupsForUserDirectory(null);
        }
        if (!product.getPermissions().contains(Permission.USER_INVITE)) {
            product.setMaxInvitationRecipients(null);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(ProductDTO productDTO, Product product) {
        product.getUserProfileFields().size();
        product.getSimpleUserSearchProfileFields().size();
        product.getMyRecordTypes().stream().forEach(productMyRecordType -> productMyRecordType.getProductRecordCustomFields().size());
        product.getAccessibleUserGroups().size();
        product.getAgreements().size();
        product.getChannels().size();
        product.getDefaultQuickAccess().size();
        product.getDocumentCategoryView().size();
        product.getGroupsForUserDirectory().size();
        product.getMyAccessClients().size();
        product.getMyContactFields().size();
        product.getMyProfileFields().size();
        product.getPasswordActions().size();
        product.getPrincipalTypes().size();
        product.getRunTransferCustomOperations().size();
        product.getTransferStatusFlows().size();
        product.getVisibleTransactionFields().size();
        product.getVisibleVoucherFields().size();
        product.getPermissions().size();
        if (product instanceof MemberProduct) {
            MemberProduct memberProduct = (MemberProduct)product;
            memberProduct.getUserRegistrationGroups().size();
            memberProduct.getActivateUserTokenTypes().size();
            memberProduct.getAccountFees().size();
            memberProduct.getChargebackPaymentTypes().size();
            memberProduct.getContactInfoFields().size();
            memberProduct.getCustomOperations().size();
            memberProduct.getDefaultFilterGroups().size();
            memberProduct.getGroupsForUserSearch().size();
            memberProduct.getGroupsForViewProfile().size();
            memberProduct.getMyAdFields().size();
            memberProduct.getMyApproveTicketPaymentTypes().size();
            memberProduct.getMyCreateTicketPaymentTypes().size();
            memberProduct.getMyExternalPaymentTypes().size();
            memberProduct.getMyPaymentRequestsSendToSystem().size();
            memberProduct.getMyPaymentRequestsSendToUser().size();
            memberProduct.getMyTokenTypes().size();
            memberProduct.getMyTransferFilters().size();
            memberProduct.getNotifications().size();
            memberProduct.getOperatorProfileFields().size();
            memberProduct.getReceivePaymentRequestTypes().size();
            memberProduct.getMakePosPaymentTypes().size();
            memberProduct.getReceivePosPaymentTypes().size();
            memberProduct.getSelfPayments().size();
            memberProduct.getSendMessagesToAdmin().size();
            memberProduct.getSystemPayments().size();
            memberProduct.getUserPayments().size();
            memberProduct.getViewAdsInOtherCurrencies().size();
            memberProduct.getVouchers().size();
        } else if (product instanceof UserManagementProduct) {
            UserManagementProduct userManagementProduct = (UserManagementProduct)product;
            userManagementProduct.getChargebackPaymentsToUser().size();
            userManagementProduct.getExternalPaymentsAsUser().size();
            userManagementProduct.getPrivacyControls().size();
            userManagementProduct.getSelfPaymentsAsUser().size();
            userManagementProduct.getSystemPaymentsAsUser().size();
            userManagementProduct.getUserAccessClients().size();
            userManagementProduct.getUserAccountsAccess().size();
            userManagementProduct.getUserAdFields().size();
            userManagementProduct.getUserContactFields().size();
            userManagementProduct.getUserCustomOperationsRun().size();
            userManagementProduct.getExternalPaymentsAsUser().size();
            userManagementProduct.getUserPasswordActions().size();
            userManagementProduct.getUserPaymentRequestsSendToSystem().size();
            userManagementProduct.getUserPaymentRequestsSendToUser().size();
            userManagementProduct.getUserPaymentsAsUser().size();
            userManagementProduct.getUserRecordTypes().stream().forEach(productUserRecordType -> productUserRecordType.getProductRecordCustomFields().size());
            userManagementProduct.getUserTokenTypes().size();
            userManagementProduct.getUserTransferFilters().size();
            if (product instanceof BrokerProduct) {
                BrokerProduct brokerProduct = (BrokerProduct)product;
                brokerProduct.getNotifications().size();
                brokerProduct.getOperatorProfileFields().size();
                brokerProduct.getUserRegistrationGroups().size();
                brokerProduct.getUserVouchers().size();
            } else {
                userManagementProduct.getDocumentCategoryManage().size();
                AdminProduct adminProduct = (AdminProduct)product;
                adminProduct.getAccessibleAdminGroups().size();
                adminProduct.getAccessibleVoucherConfigurations().size();
                adminProduct.getApplicationTranslation().size();
                adminProduct.getAuthorizationRoles().size();
                adminProduct.getChargebackPaymentsToSystem().size();
                adminProduct.getManageSpecificConfigurations().size();
                adminProduct.getManageContentSpecificConfigurations().size();
                adminProduct.getManageIndividualProducts().size();
                adminProduct.getManageMessagesSentToSysWithCat().size();
                adminProduct.getManagedProducts().size();
                adminProduct.getSendMessagesFromSysWithCat().size();
                adminProduct.getSystemAccounts().size();
                adminProduct.getSystemCustomOperationsRun().size();
                adminProduct.getSystemImageCategoriesManage().size();
                adminProduct.getSystemImageCategoriesView().size();
                adminProduct.getSystemPaymentRequestsSendToUser().size();
                adminProduct.getSystemRecordTypes().stream().forEach(productSystemRecordType -> productSystemRecordType.getProductRecordCustomFields().size());
                adminProduct.getSystemToSystemPayments().size();
                adminProduct.getSystemToUserExternalPayments().size();
                adminProduct.getSystemToUserPayments().size();
                adminProduct.getSystemTransferFilters().size();
                adminProduct.getViewMessagesSentToSysWithCat().size();
                adminProduct.getVouchers().size();
                adminProduct.getAuthorizablePaymentsToNotify().size();
                adminProduct.getDefaultNotifications().size();
                adminProduct.getExternalPaymentsExpiredToNotify().size();
                adminProduct.getExternalPaymentsFailedToNotify().size();
                adminProduct.getFwdMessageCategoriesToEmailToNotify().size();
                adminProduct.getPaymentsToNotify().size();
                adminProduct.getSystemAlertsToNotify().size();
                adminProduct.getUserAlertsToNotify().size();
                adminProduct.getUserGroupsToNotify().size();
                adminProduct.getVoucherConfigurationsBuyingToNotify().size();
                adminProduct.getVoucherConfigurationsToNotify().size();
            }
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QProduct.product.network());
    }

    @Override
    protected Validator resolveValidator(ProductDTO productDTO) {
        AdminProductDTO adminProductDTO;
        Validator validator = new Validator();
        if (productDTO instanceof AdminProductDTO) {
            adminProductDTO = (AdminProductDTO)productDTO;
            this.appendAdminValidations(validator, adminProductDTO);
        }
        if (productDTO instanceof BrokerProductDTO) {
            adminProductDTO = (BrokerProductDTO)productDTO;
            this.appendBrokerValidations(validator, (BrokerProductDTO)adminProductDTO);
        }
        if (productDTO instanceof MemberProductDTO) {
            adminProductDTO = (MemberProductDTO)productDTO;
            this.appendMemberValidations(validator, (MemberProductDTO)adminProductDTO);
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends Product>, Class<? extends ProductDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private void addProfilesFieldsAdminProduct(AdminProductDTO adminProductDTO, AdminGroup adminGroup) {
        EnumSet<BasicProfileField> enumSet = EnumSet.of(BasicProfileField.LOGIN_NAME, BasicProfileField.FULL_NAME, BasicProfileField.EMAIL);
        EnumSet<BasicProfileField[]> enumSet2 = EnumSet.of(BasicProfileField.LOGIN_NAME, new BasicProfileField[]{BasicProfileField.FULL_NAME, BasicProfileField.EMAIL, BasicProfileField.ADDRESS, BasicProfileField.PHONE, BasicProfileField.IMAGE});
        EnumSet<BasicProfileField> enumSet3 = EnumSet.allOf(BasicProfileField.class);
        ArrayList<ProductMyProfileFieldDTO> arrayList = new ArrayList<ProductMyProfileFieldDTO>();
        ArrayList<ProductUserProfileFieldDTO> arrayList2 = new ArrayList<ProductUserProfileFieldDTO>();
        for (BasicProfileField basicProfileField : BasicProfileField.values()) {
            boolean bl = enumSet2.contains(basicProfileField);
            ProductMyProfileFieldDTO productMyProfileFieldDTO = new ProductMyProfileFieldDTO();
            productMyProfileFieldDTO.setProfileField((ProfileField)basicProfileField);
            productMyProfileFieldDTO.setEnabled(bl);
            productMyProfileFieldDTO.setVisible(bl);
            productMyProfileFieldDTO.setEditable(bl);
            productMyProfileFieldDTO.setEditableAtRegistration(bl);
            productMyProfileFieldDTO.setManagePrivacy(false);
            arrayList.add(productMyProfileFieldDTO);
            boolean bl2 = enumSet3.contains(basicProfileField);
            ProductUserProfileFieldDTO productUserProfileFieldDTO = new ProductUserProfileFieldDTO();
            productUserProfileFieldDTO.setProfileField((ProfileField)basicProfileField);
            productUserProfileFieldDTO.setVisible(bl2);
            productUserProfileFieldDTO.setEditable(bl2);
            boolean bl3 = enumSet.contains(basicProfileField);
            productUserProfileFieldDTO.setUserKeywords(bl3);
            productUserProfileFieldDTO.setAdKeywords(bl3);
            productUserProfileFieldDTO.setRecordKeywords(bl3);
            arrayList2.add(productUserProfileFieldDTO);
        }
        adminProductDTO.setMyProfileFields(arrayList);
        adminProductDTO.setUserProfileFields(arrayList2);
    }

    private void appendAdminValidations(Validator validator, AdminProductDTO adminProductDTO) {
        this.appendUserManagementValidations(validator, (UserManagementProductDTO)adminProductDTO, this.hasConfigurations(adminProductDTO.getVouchers(), ProductAdminVoucherDTO::isView), this.hasConfigurations(adminProductDTO.getVouchers(), ProductVoucherDTO::isSend));
        validator.property((org.cyclos.model.Property)AdminProductDTO.MANAGE_INDIVIDUAL_PRODUCTS, UsersKeys.Products.MANAGE_INDIVIDUAL_PRODUCTS).anyOf(this.listMemberOrBrokerVOs());
        Set set = adminProductDTO.getSendMessagesFromSysWithCat();
        Property property = validator.property((org.cyclos.model.Property)AdminProductDTO.MAX_MESSAGE_RECIPIENTS, UsersKeys.Products.MAX_MESSAGE_RECIPIENTS);
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            property.required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(999));
        } else {
            property.anyOf(new Object[]{0});
        }
        ViewManageOperation viewManageOperation = adminProductDTO.getVoucherTypes();
        if (viewManageOperation == ViewManageOperation.VIEW || viewManageOperation == ViewManageOperation.MANAGE) {
            validator.property((org.cyclos.model.Property)AdminProductDTO.ACCESSIBLE_VOUCHER_CONFIGURATIONS, UsersKeys.Products.ACCESSIBLE_VOUCHER_CONFIGURATIONS).required();
        }
        if (adminProductDTO.getAdminGroupAccessibility() == AdminGroupAccessibility.SPECIFIC) {
            validator.property((org.cyclos.model.Property)AdminProductDTO.ACCESSIBLE_ADMIN_GROUPS, UsersKeys.Products.ACCESSIBLE_ADMIN_GROUPS).required();
        }
        validator.property((org.cyclos.model.Property)AdminProductDTO.SYSTEM_TO_SYSTEM_PAYMENTS, UsersKeys.Products.SYSTEM_TO_SYSTEM_PAYMENTS).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.SYSTEM_TO_SYSTEM));
        validator.property((org.cyclos.model.Property)AdminProductDTO.SYSTEM_TO_USER_PAYMENTS, UsersKeys.Products.SYSTEM_TO_USER_PAYMENTS).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.SYSTEM_TO_USER));
        validator.property((org.cyclos.model.Property)AdminProductDTO.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER, UsersKeys.Products.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_SYSTEM));
        validator.property((org.cyclos.model.Property)AdminProductDTO.CHARGEBACK_PAYMENTS_TO_SYSTEM, UsersKeys.Products.CHARGEBACK_PAYMENTS_TO_SYSTEM).entity(TransferType.class, this.isValid(TransferType::isToSystem));
        validator.property((org.cyclos.model.Property)AdminProductDTO.SYSTEM_TO_USER_EXTERNAL_PAYMENTS, UsersKeys.Products.SYSTEM_TO_USER_EXTERNAL_PAYMENTS).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.SYSTEM_TO_USER));
    }

    private void appendBrokerValidations(Validator validator, BrokerProductDTO brokerProductDTO) {
        this.appendUserManagementValidations(validator, (UserManagementProductDTO)brokerProductDTO, this.hasConfigurations(brokerProductDTO.getUserVouchers(), ProductUserVoucherDTO::isViewVouchers), this.hasConfigurations(brokerProductDTO.getUserVouchers(), ProductVoucherDTO::isSend));
        Set set = brokerProductDTO.getBrokerMessages();
        Property property = validator.property((org.cyclos.model.Property)BrokerProductDTO.MAX_MESSAGE_RECIPIENTS, UsersKeys.Products.MAX_MESSAGE_RECIPIENTS);
        if (set != null && set.contains(BrokerMessagesOperation.SEND_TO_BROKERED)) {
            property.required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(999));
        } else {
            property.anyOf(new Object[]{0});
        }
    }

    private void appendGeneralValidations(Validator validator, ProductDTO productDTO) {
        validator.property((org.cyclos.model.Property)ProductDTO.MAX_ADDRESSES, UsersKeys.Products.MAX_ADDRESSES).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(999));
        validator.property((org.cyclos.model.Property)ProductDTO.MAX_CUSTOM_IMAGES, UsersKeys.Products.MAX_CUSTOM_IMAGES).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(999));
        validator.property((org.cyclos.model.Property)ProductDTO.MAX_LANDLINE_PHONES, UsersKeys.Products.MAX_LANDLINE_PHONES).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(999));
        validator.property((org.cyclos.model.Property)ProductDTO.MAX_MOBILE_PHONES, UsersKeys.Products.MAX_MOBILE_PHONES).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(999));
        validator.property((org.cyclos.model.Property)ProductDTO.MAX_SMS_PER_MONTH, UsersKeys.Products.MAX_SMS_PER_MONTH).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(99999));
        validator.property((org.cyclos.model.Property)ProductDTO.MAX_PROFILE_IMAGES, UsersKeys.Products.MAX_PROFILE_IMAGES).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(999));
        UserGroupAccessibility userGroupAccessibility = (UserGroupAccessibility)ObjectHelper.defaultValue((Object)productDTO.getUserGroupAccessibility(), (Object)UserGroupAccessibility.NONE);
        if (userGroupAccessibility == UserGroupAccessibility.NONE) {
            validator.property((org.cyclos.model.Property)ProductDTO.USER_DIRECTORY_ON_GROUPS, UsersKeys.Products.USER_DIRECTORY_ON_GROUPS).anyOf(new Object[]{UserGroupAccessibility.NONE});
        }
        if (!(productDTO instanceof BrokerProductDTO)) {
            if (userGroupAccessibility == UserGroupAccessibility.SPECIFIC) {
                validator.property((org.cyclos.model.Property)ProductDTO.ACCESSIBLE_USER_GROUPS, UsersKeys.Products.ACCESSIBLE_USER_GROUPS).required();
            }
            if (productDTO.getUserDirectoryOnGroups() == UserGroupAccessibility.SPECIFIC) {
                validator.property((org.cyclos.model.Property)ProductDTO.GROUPS_FOR_USER_DIRECTORY, UsersKeys.Products.GROUPS_FOR_USER_DIRECTORY).required().entity(BasicGroup.class, this.inSpecificUserGroupValidation);
            }
        }
        validator.property((org.cyclos.model.Property)ProductDTO.RUN_TRANSFER_CUSTOM_OPERATIONS, UsersKeys.Products.RUN_TRANSFER_CUSTOM_OPERATIONS).entity(CustomOperation.class, (EntityValidation)new BaseEntityValidation<CustomOperation>(){

            protected boolean isValid(Object object, Object object2, CustomOperation customOperation) {
                return customOperation.getScope() == CustomOperationScope.TRANSFER;
            }
        });
        if (productDTO.isUserInvite()) {
            validator.property((org.cyclos.model.Property)ProductDTO.MAX_INVITATION_RECIPIENTS, UsersKeys.Products.MAX_INVITATION_RECIPIENTS).required().positiveIntegerNonZero();
        }
    }

    private void appendMemberValidations(Validator validator, MemberProductDTO memberProductDTO) {
        this.appendGeneralValidations(validator, (ProductDTO)memberProductDTO);
        validator.general(object -> {
            if (memberProductDTO.getDefaultAdPublicationTime() != null && memberProductDTO.getDefaultAdPublicationTime().getField() != null && memberProductDTO.getMaxAdPublicationTime() != null && memberProductDTO.getMaxAdPublicationTime().getField() != null && DateHelper.getTime((TimeIntervalDTO)memberProductDTO.getDefaultAdPublicationTime()) > DateHelper.getTime((TimeIntervalDTO)memberProductDTO.getMaxAdPublicationTime())) {
                return new ValidationError(UsersKeys.Products.ERROR_PUBLICATION_DATES, new Object[]{this.message(UsersKeys.Products.DEFAULT_AD_PUBLICATION_TIME, new Object[0]), this.message(UsersKeys.Products.MAX_AD_PUBLICATION_TIME, new Object[0])});
            }
            return null;
        });
        validator.property((org.cyclos.model.Property)MemberProductDTO.DEFAULT_AD_PUBLICATION_TIME, UsersKeys.Products.DEFAULT_AD_PUBLICATION_TIME).timeInterval();
        validator.property((org.cyclos.model.Property)MemberProductDTO.MAX_AD_PUBLICATION_TIME, UsersKeys.Products.MAX_AD_PUBLICATION_TIME).timeInterval();
        validator.general(object -> {
            if (memberProductDTO.getInitialCredit() != null && memberProductDTO.getInitialCreditType() == null) {
                return new ValidationError(UsersKeys.Products.ERROR_INITIAL_CREDIT_TRANSFER_TYPE_MISSING);
            }
            return null;
        });
        UserGroupAccessibility userGroupAccessibility = (UserGroupAccessibility)ObjectHelper.defaultValue((Object)memberProductDTO.getUserGroupAccessibility(), (Object)UserGroupAccessibility.NONE);
        if (userGroupAccessibility == UserGroupAccessibility.NONE) {
            validator.property((org.cyclos.model.Property)MemberProductDTO.SEARCH_USERS_ON_GROUPS, UsersKeys.Products.SEARCH_USERS_ON_GROUPS).anyOf(new Object[]{UserGroupAccessibility.NONE});
            validator.property((org.cyclos.model.Property)MemberProductDTO.VIEW_PROFILE_ON_GROUPS, UsersKeys.Products.VIEW_PROFILE_ON_GROUPS).anyOf(new Object[]{UserGroupAccessibility.NONE});
            validator.property((org.cyclos.model.Property)MemberProductDTO.GROUP_VISIBILITY, UsersKeys.Products.GROUP_VISIBILITY).anyOf(new Object[]{GroupVisibility.NONE});
        }
        if (CollectionHelper.isNotEmpty((Iterable)memberProductDTO.getSendMessagesToAdmin()) && (memberProductDTO.getMyMessages() == null || !memberProductDTO.getMyMessages().contains(MyMessagesOperation.VIEW))) {
            validator.property((org.cyclos.model.Property)MemberProductDTO.SEND_MESSAGES_TO_ADMIN, UsersKeys.Products.SEND_MESSAGES_TO_ADMIN).invalid();
        }
        validator.property((org.cyclos.model.Property)MemberProductDTO.MAX_AD_DESCRIPTION_SIZE, UsersKeys.Products.MAX_AD_DESCRIPTION_SIZE).between((Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(0x100000));
        if (memberProductDTO.getMyMessages() != null && memberProductDTO.getMyMessages().contains(MyMessagesOperation.SEND_TO_USER)) {
            validator.property((org.cyclos.model.Property)MemberProductDTO.MAX_MESSAGE_RECIPIENTS, UsersKeys.Products.MAX_MESSAGE_RECIPIENTS).required().positiveIntegerNonZero();
        }
        if (memberProductDTO.getMyOperators() != null && memberProductDTO.getMyOperators().contains(MyOperatorsOperation.ENABLE)) {
            validator.property((org.cyclos.model.Property)MemberProductDTO.MAX_OPERATORS, UsersKeys.Products.MAX_OPERATORS).required().positiveIntegerNonZero();
        }
        if (memberProductDTO.getMaxCategoriesPerAd() != null) {
            validator.property((org.cyclos.model.Property)MemberProductDTO.MAX_CATEGORIES_PER_AD, UsersKeys.Products.MAX_CATEGORIES_PER_AD).required().positiveIntegerNonZero();
        }
        if (memberProductDTO.getSearchUsersOnGroups() == UserGroupAccessibility.SPECIFIC) {
            validator.property((org.cyclos.model.Property)MemberProductDTO.GROUPS_FOR_USER_SEARCH, UsersKeys.Products.GROUPS_FOR_USER_SEARCH).required().entity(BasicGroup.class, this.inSpecificUserGroupValidation);
        }
        if (memberProductDTO.getViewProfileOnGroups() == UserGroupAccessibility.SPECIFIC) {
            validator.property((org.cyclos.model.Property)MemberProductDTO.GROUPS_FOR_VIEW_PROFILE, UsersKeys.Products.GROUPS_FOR_VIEW_PROFILE).required().entity(BasicGroup.class, this.inSpecificUserGroupValidation);
        }
        if (memberProductDTO.getGroupFilterDefault() == GroupFilterDefault.SPECIFIC) {
            validator.property((org.cyclos.model.Property)MemberProductDTO.DEFAULT_FILTER_GROUPS, UsersKeys.Products.DEFAULT_FILTER_GROUPS).required().entity(BasicGroup.class, this.inSpecificUserGroupValidation);
        }
        validator.property((org.cyclos.model.Property)MemberProductDTO.MY_APPROVE_TICKET_PAYMENT_TYPES, UsersKeys.Products.MY_APPROVE_TICKET_PAYMENT_TYPES).entity(PaymentTransferType.class, this.isValid(paymentTransferType -> paymentTransferType.getChannels().stream().filter(Channel::isTicket).findFirst().isPresent() && paymentTransferType.getDirection() == TransferTypeDirection.USER_TO_USER));
        validator.property((org.cyclos.model.Property)MemberProductDTO.MY_CREATE_TICKET_PAYMENT_TYPES, UsersKeys.Products.MY_CREATE_TICKET_PAYMENT_TYPES).entity(PaymentTransferType.class, this.isValid(paymentTransferType -> paymentTransferType.getChannels().stream().filter(Channel::isTicket).findFirst().isPresent() && paymentTransferType.getDirection() == TransferTypeDirection.USER_TO_USER));
        validator.property((org.cyclos.model.Property)MemberProductDTO.MAKE_POS_PAYMENT_TYPES, UsersKeys.Products.MAKE_POS_PAYMENT_TYPES).entity(PaymentTransferType.class, this.isValid(paymentTransferType -> paymentTransferType.getChannels().stream().anyMatch(Channel::isPos) && paymentTransferType.getDirection() == TransferTypeDirection.USER_TO_USER));
        validator.property((org.cyclos.model.Property)MemberProductDTO.RECEIVE_POS_PAYMENT_TYPES, UsersKeys.Products.RECEIVE_POS_PAYMENT_TYPES).entity(PaymentTransferType.class, this.isValid(paymentTransferType -> paymentTransferType.getChannels().stream().anyMatch(Channel::isPos) && paymentTransferType.getDirection() == TransferTypeDirection.USER_TO_USER));
        validator.property((org.cyclos.model.Property)MemberProductDTO.SYSTEM_PAYMENTS, UsersKeys.Products.SYSTEM_PAYMENTS).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_SYSTEM));
        validator.property((org.cyclos.model.Property)MemberProductDTO.USER_PAYMENTS, UsersKeys.Products.USER_PAYMENTS).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_USER));
        validator.property((org.cyclos.model.Property)MemberProductDTO.SELF_PAYMENTS, UsersKeys.Products.SELF_PAYMENTS).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_SELF));
        validator.property((org.cyclos.model.Property)MemberProductDTO.CHARGEBACK_PAYMENT_TYPES, UsersKeys.Products.CHARGEBACK_PAYMENT_TYPES).entity(TransferType.class, this.isValid(TransferType::isToUser));
        validator.property((org.cyclos.model.Property)MemberProductDTO.RECEIVE_PAYMENT_REQUEST_TYPES, UsersKeys.Products.RECEIVE_PAYMENT_REQUEST_TYPES).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_SYSTEM || transferType.getDirection() == TransferTypeDirection.USER_TO_USER));
    }

    private void appendUserManagementValidations(Validator validator, UserManagementProductDTO userManagementProductDTO, boolean bl, boolean bl2) {
        this.appendGeneralValidations(validator, (ProductDTO)userManagementProductDTO);
        validator.property((org.cyclos.model.Property)UserManagementProductDTO.CHARGEBACK_PAYMENTS_TO_USER, UsersKeys.Products.CHARGEBACK_PAYMENTS_TO_USER).entity(TransferType.class, this.isValid(TransferType::isToUser));
        validator.property((org.cyclos.model.Property)UserManagementProductDTO.SYSTEM_PAYMENTS_AS_USER, UsersKeys.Products.SYSTEM_PAYMENTS_AS_USER).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_SYSTEM));
        validator.property((org.cyclos.model.Property)UserManagementProductDTO.SELF_PAYMENTS_AS_USER, UsersKeys.Products.SELF_PAYMENTS_AS_USER).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_SELF));
        validator.property((org.cyclos.model.Property)UserManagementProductDTO.USER_PAYMENTS_AS_USER, UsersKeys.Products.USER_PAYMENTS_AS_USER).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_USER));
        validator.property((org.cyclos.model.Property)UserManagementProductDTO.USER_PAYMENT_REQUESTS_SEND_TO_USER, UsersKeys.Products.USER_PAYMENT_REQUESTS_SEND_TO_USER).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_USER));
        validator.property((org.cyclos.model.Property)UserManagementProductDTO.USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM, UsersKeys.Products.USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.SYSTEM_TO_USER));
        validator.property((org.cyclos.model.Property)UserManagementProductDTO.EXTERNAL_PAYMENTS_AS_USER, UsersKeys.Products.EXTERNAL_PAYMENTS_AS_USER).entity(TransferType.class, this.isValid(transferType -> transferType.getDirection() == TransferTypeDirection.USER_TO_USER));
        ViewManageOperation viewManageOperation = userManagementProductDTO.getUserVouchersBatchSend();
        Property property = validator.property((org.cyclos.model.Property)UserManagementProductDTO.USER_VOUCHERS_BATCH_SEND, UsersKeys.Products.USER_VOUCHERS_BATCH_SEND);
        if (viewManageOperation == ViewManageOperation.VIEW && !bl) {
            property.invalid(UsersKeys.Products.ERROR_VIEW_USER_SEND_VOUCHERS_IMPORT, new Object[]{UsersKeys.Products.GENERAL_VIEW});
        } else if (viewManageOperation == ViewManageOperation.MANAGE && !bl2) {
            property.invalid(UsersKeys.Products.ERROR_MANAGE_USER_SEND_VOUCHERS_IMPORT, new Object[]{UsersKeys.Products.GENERAL_MANAGE});
        }
    }

    private boolean canRemove(Product product) {
        if (product instanceof AdminProduct && ((AdminProduct)product).getAdminGroup() != null) {
            return false;
        }
        return ((DBQuery)this.from(this.$).where((Predicate)((QProduct)this.$).eq((Object)product).and((Predicate)((QProduct)this.$).groups.isEmpty()).and((Predicate)((QProduct)this.$).users.isEmpty()))).hasResults();
    }

    private UserProductsQueryResult doPermissionQuery(Collection<? extends Product> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return new UserProductsQueryResult(Collections.emptySet(), Collections.emptySet());
        }
        HashSet hashSet = new HashSet();
        collection.forEach(product -> hashSet.addAll(product.getGroups()));
        return new UserProductsQueryResult((Collection)this.groupsHandler.flatten(hashSet), collection);
    }

    private UserProductNotification ensureNotification(UserNotificationType userNotificationType, Product product, Set<UserProductNotification> set) {
        for (UserProductNotification userProductNotification : set) {
            if (!userProductNotification.getType().equals((Object)userNotificationType)) continue;
            return userProductNotification;
        }
        UserProductNotification userProductNotification = new UserProductNotification();
        userProductNotification.setProduct(product);
        userProductNotification.setType(userNotificationType);
        set.add(userProductNotification);
        return userProductNotification;
    }

    private Set<UserProductNotification> ensureNotificationsIfNeeded(Product product) {
        switch (product.getNature()) {
            case MEMBER: {
                HashSet hashSet = ((MemberProduct)product).getNotifications();
                if (hashSet == null) {
                    hashSet = new HashSet();
                    ((MemberProduct)product).setNotifications(hashSet);
                }
                return hashSet;
            }
            case BROKER: {
                HashSet hashSet = ((BrokerProduct)product).getNotifications();
                if (hashSet == null) {
                    hashSet = new HashSet();
                    ((BrokerProduct)product).setNotifications(hashSet);
                }
                return hashSet;
            }
        }
        return null;
    }

    private void ensureNotificationType(IMemberOrBrokerProduct iMemberOrBrokerProduct) {
        Set set = iMemberOrBrokerProduct.getNotifications();
        set.removeIf(userProductNotification -> userProductNotification.getType().getRole() != iMemberOrBrokerProduct.getRole());
    }

    private void evictAccessorCache(Product product) {
        Long l = SimpleEntity.id((SimpleEntity)product);
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesProduct(l));
    }

    private void fillProductData(ProductData productData, Product product) {
        productData.setSkipView(this.getSessionData().getConfiguration().isSkipProductsView());
        if (product.isPersistent()) {
            productData.setUsedByGroups(this.conversionHandler.convertList(BasicGroupVO.class, (Iterable)this.groupService.getGroupsUsingProduct(product)));
        }
        productData.setUserGroups(this.groupsHandler.viewFactory((Collection)this.groupService.getBasicUserGroups()).basic().sorted());
        productData.setAgreements(this.agreementServiceLocal.list());
        productData.setUserCustomFields(this.userCustomFieldService.list());
        productData.setTransactionCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)this.transactionCustomFieldService.listAll()));
        productData.setVoucherCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)this.voucherCustomFieldService.listAll()));
        productData.setDocumentCategories(this.documentCategoryService.list());
        productData.setChannels(this.channelService.list());
        productData.setPrincipalTypes(this.principalTypeService.list());
        productData.setTransferCustomOperations(this.conversionHandler.convertList(CustomOperationVO.class, (Iterable)this.customOperationService.listByScope(new CustomOperationScope[]{CustomOperationScope.TRANSFER})));
        productData.setUserWizards(this.conversionHandler.convertList(CustomWizardVO.class, (Iterable)this.customWizardService.listUserWizards()));
        productData.setCustomWebServices(this.conversionHandler.convertList(CustomWebServiceVO.class, (Iterable)this.customWebServiceService.listUser()));
        productData.setQuickAccess(this.listAllQuickAccess(product.getRole()));
    }

    private void fillUserManagementProductData(UserManagementProductData userManagementProductData, UserManagementProduct userManagementProduct) {
        this.fillProductData((ProductData)userManagementProductData, (Product)userManagementProduct);
        userManagementProductData.setUserAccounts(this.listUserAccountTypes(AccountTypeWithCurrencyVO.class));
        userManagementProductData.setPaymentsAsUserToUser(this.listPaymentTypes(null, TransferTypeDirection.USER_TO_USER));
        userManagementProductData.setExternalPaymentsAsUser(this.listPaymentTypes(null, TransferTypeDirection.USER_TO_USER));
        userManagementProductData.setPaymentsAsUserToSystem(this.listPaymentTypes(null, TransferTypeDirection.USER_TO_SYSTEM));
        userManagementProductData.setPaymentsAsUserToSelf(this.listPaymentTypes(null, TransferTypeDirection.USER_TO_SELF));
        userManagementProductData.setPaymentsFromSystemToUser(this.listPaymentTypes(null, TransferTypeDirection.SYSTEM_TO_USER));
        userManagementProductData.setChargebackPaymentsToUser(this.listTransferTypesTo(null, AccountTypeNature.USER));
        userManagementProductData.setTicketPayments(this.listPaymentTypes(null, TransferTypeDirection.USER_TO_USER, BuiltInChannel.TICKET));
        userManagementProductData.setUserTransferFilters(this.listTransferFilters(null, AccountTypeNature.USER));
        userManagementProductData.setRecordTypes(this.recordTypeService.list());
        List list = this.customOperationService.listByScope(new CustomOperationScope[]{CustomOperationScope.USER, CustomOperationScope.CONTACT, CustomOperationScope.CONTACT_INFO, CustomOperationScope.BULK_ACTION, CustomOperationScope.ADVERTISEMENT});
        list.addAll(this.customOperationService.listWithRecordScope(new RecordTypeNature[]{RecordTypeNature.USER}));
        userManagementProductData.setUserCustomOperations(this.conversionHandler.convertList(CustomOperationVO.class, (Iterable)list));
        userManagementProductData.setPrivacyControls(this.conversionHandler.convertList(PrivacyControlVO.class, (Iterable)this.privacyControlService.listAll()));
    }

    private void filterByVisibleProducts(QProduct qProduct, DBQuery<?> dBQuery) {
        QProductManagement qProductManagement = QProductManagement.productManagement;
        List list = this.getSessionData().getProducts().admin().getManagedProducts().keysSet((Path)qProductManagement.view).stream().map(SimpleEntity::getId).collect(Collectors.toList());
        if (!this.hasPermission(Permission.USER_CONFIGURATION_VIEW) && list.isEmpty()) {
            dBQuery.where((Predicate)qProduct.id.isNull());
        } else if (!this.hasPermission(Permission.USER_CONFIGURATION_VIEW)) {
            dBQuery.where((Predicate)qProduct.id.in(list));
        }
    }

    private AdminProductData getAdminData(AdminProduct adminProduct) {
        AdminProductData adminProductData = new AdminProductData();
        adminProductData.setAdminGroup((AdminGroupVO)this.conversionHandler.convert(AdminGroupVO.class, (Object)adminProduct.getAdminGroup()));
        this.fillUserManagementProductData((UserManagementProductData)adminProductData, (UserManagementProduct)adminProduct);
        adminProductData.setAdminGroups(this.conversionHandler.convertList(GroupVO.class, (Iterable)this.groupService.getAdminGroups()));
        AccountTypeQuery accountTypeQuery = new AccountTypeQuery();
        accountTypeQuery.setNature(AccountTypeNature.SYSTEM);
        adminProductData.setSystemAccounts(this.listSystemAccountTypes());
        adminProductData.setSystemTransferFilters(this.listTransferFilters(null, AccountTypeNature.SYSTEM));
        adminProductData.setSystemToSystemPayments(this.listPaymentTypes(null, TransferTypeDirection.SYSTEM_TO_SYSTEM));
        adminProductData.setSystemToUserPayments(this.listPaymentTypes(null, TransferTypeDirection.SYSTEM_TO_USER));
        adminProductData.setSystemToUserExternalPayments(this.listPaymentTypes(null, TransferTypeDirection.SYSTEM_TO_USER));
        adminProductData.setChargebackPaymentsToSystem(this.listTransferTypesTo(null, AccountTypeNature.SYSTEM));
        adminProductData.setUserToSystemPayments(this.listPaymentTypes(null, TransferTypeDirection.USER_TO_SYSTEM));
        adminProductData.setAuthorizationRoles(this.conversionHandler.convertList(AuthorizationRoleVO.class, (Iterable)this.authorizationRoleService.listAll()));
        adminProductData.setPossibleIndividualProducts(this.listMemberOrBrokerVOs());
        List list = this.systemImageCategoryService.list();
        adminProductData.setSystemImageCategoriesToView(list);
        adminProductData.setSystemImageCategoriesToManage(list.stream().filter(systemImageCategoryVO -> this.getSessionData().getNetwork() == null || !systemImageCategoryVO.isGlobal()).collect(Collectors.toList()));
        adminProductData.setAppTranslationLanguages(this.conversionHandler.convertList(LanguageVO.class, (Iterable)this.languageService.list()));
        adminProductData.setConfigurations(this.conversionHandler.convertList(ConfigurationDetailedVO.class, (Iterable)this.configurationService.listAll()));
        adminProductData.setVoucherConfigurations(this.conversionHandler.convertList(VoucherConfigurationVO.class, (Iterable)this.voucherConfigurationService.listAll()));
        adminProductData.setLoginUsersPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listForLogin()));
        adminProductData.setMessageCategories(this.messageCategoryService.list());
        List list2 = this.customOperationService.listByScope(new CustomOperationScope[]{CustomOperationScope.SYSTEM});
        list2.addAll(this.customOperationService.listWithRecordScope(new RecordTypeNature[]{RecordTypeNature.SYSTEM}));
        adminProductData.setSystemCustomOperations(this.conversionHandler.convertList(CustomOperationVO.class, (Iterable)list2));
        adminProductData.setSystemWizards(this.conversionHandler.convertList(CustomWizardVO.class, (Iterable)this.customWizardService.listSystemWizards()));
        adminProductData.setArchivingEnabled(this.applicationHandler.isArchivingEnabled());
        return adminProductData;
    }

    private BrokerProductData getBrokerData(BrokerProduct brokerProduct) {
        BrokerProductData brokerProductData = new BrokerProductData();
        this.fillUserManagementProductData((UserManagementProductData)brokerProductData, (UserManagementProduct)brokerProduct);
        brokerProductData.setUserRegistrationGroups(this.getUserRegistrationGroups(true));
        return brokerProductData;
    }

    private MemberProductData getMemberData(MemberProduct memberProduct) {
        MemberProductData memberProductData = new MemberProductData();
        this.fillProductData((ProductData)memberProductData, (Product)memberProduct);
        UserAccountType userAccountType = memberProduct.getUserAccount();
        if (memberProduct.isTransient() || userAccountType != null) {
            AccountFeeQuery accountFeeQuery = new AccountFeeQuery();
            accountFeeQuery.setUnlimited();
            accountFeeQuery.setReturnDisabled(true);
            memberProductData.setAccountFees(this.accountFeeService.search(AccountFeeWithTypeVO.class, accountFeeQuery).getPageItems());
            memberProductData.setUserAccounts(userAccountType == null ? this.listUserAccountTypes(AccountTypeWithCurrencyVO.class) : Collections.singletonList((AccountTypeWithCurrencyVO)this.conversionHandler.convert(AccountTypeWithCurrencyVO.class, (Object)userAccountType)));
            memberProductData.setSelfPayments(this.listPaymentTypes((AccountType)userAccountType, TransferTypeDirection.USER_TO_SELF));
            memberProductData.setSystemPayments(this.listPaymentTypes((AccountType)userAccountType, TransferTypeDirection.USER_TO_SYSTEM));
            memberProductData.setUserPayments(this.listPaymentTypes((AccountType)userAccountType, TransferTypeDirection.USER_TO_USER));
            memberProductData.setMyExternalPayments(this.listPaymentTypes((AccountType)userAccountType, TransferTypeDirection.USER_TO_USER));
            memberProductData.setChargebackPayments(this.listTransferTypesTo((AccountType)userAccountType, AccountTypeNature.USER));
            memberProductData.setPosPayments(this.listPaymentTypes((AccountType)userAccountType, TransferTypeDirection.USER_TO_USER, BuiltInChannel.POS));
            memberProductData.setTicketPayments(this.listPaymentTypes((AccountType)userAccountType, TransferTypeDirection.USER_TO_USER, BuiltInChannel.TICKET));
            memberProductData.setSystemToUserPayments(this.listPaymentTypes((AccountType)userAccountType, TransferTypeDirection.SYSTEM_TO_USER));
            memberProductData.setSystemToUserGeneratedTypes(this.listGeneratedTypes((AccountType)userAccountType, AccountTypeNature.SYSTEM, AccountTypeNature.USER));
            memberProductData.setTransferFilters(this.listTransferFilters((AccountType)userAccountType, AccountTypeNature.USER));
        }
        memberProductData.setSendAdminMessages(this.messageCategoryService.list());
        memberProductData.setDocumentCategories(this.documentCategoryService.list());
        memberProductData.setAdCustomFields(this.adCustomFieldService.list());
        memberProductData.setAccessClientTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listAccessClients()));
        memberProductData.setActivateUserTokenTypes(this.conversionHandler.convertList(TokenPrincipalTypeVO.class, (Iterable)this.principalTypeService.listByType(TokenType.NFC_TAG)));
        memberProductData.setUserRegistrationGroups(this.getUserRegistrationGroups(false));
        memberProductData.setContactInfoFields(this.contactInfoFieldService.list());
        memberProductData.setViewAdsInOtherCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)this.currencyServiceLocal.listAll()));
        return memberProductData;
    }

    private Collection<ProductConversionHandler<?, ?, ?>> getProductConvertersForActiveData(ActiveProductsData activeProductsData) {
        HashSet hashSet = new HashSet();
        for (ProductConversionHandler<?, ?, ?> productConversionHandler : this.productConverters) {
            if (!productConversionHandler.getActiveDataType().isInstance(activeProductsData)) continue;
            hashSet.add(productConversionHandler);
        }
        return hashSet;
    }

    private List<? extends BasicGroupVO> getUserRegistrationGroups(boolean bl) {
        GroupListViewFactory groupListViewFactory = this.groupsHandler.viewFactory((Collection)this.groupService.getBasicUserGroups());
        return bl ? groupListViewFactory.basicUsers().sorted() : groupListViewFactory.users().sorted();
    }

    private <DTO extends ProductVoucherDTO> boolean hasConfigurations(List<DTO> list, java.util.function.Predicate<DTO> predicate) {
        return CollectionHelper.orEmpty(list).stream().anyMatch(predicate);
    }

    private <TT extends TransferType> EntityValidation<TT> isValid(java.util.function.Predicate<TT> predicate) {
        return (object, object2, transferType) -> predicate.test(transferType) ? null : ValidationErrors.invalid();
    }

    private List<AdminProduct> listAdminProducts() {
        QProduct qProduct = QProduct.product;
        return ((DBQuery)this.from(new EntityPath[]{qProduct}).where((Predicate)qProduct.nature.eq((Object)ProductNature.ADMIN))).list(AdminProduct.class, (Expression)qProduct);
    }

    private List<QuickAccessDTO> listAllQuickAccess(Role role) {
        Function<QuickAccessType, Stream> function = quickAccessType -> {
            switch (quickAccessType) {
                case OPERATION: {
                    return this.customOperationService.listByScope(new CustomOperationScope[]{role == Role.ADMIN ? CustomOperationScope.SYSTEM : CustomOperationScope.USER}).stream().map(customOperation -> {
                        QuickAccessDTO quickAccessDTO = new QuickAccessDTO();
                        quickAccessDTO.setType(quickAccessType);
                        quickAccessDTO.setEntity((ConfigurationEntityVO)this.conversionHandler.convert(CustomOperationVO.class, customOperation));
                        return quickAccessDTO;
                    });
                }
                case WIZARD: {
                    return (role == Role.ADMIN ? this.customWizardService.listSystemWizards() : this.customWizardService.listUserWizards()).stream().map(directWizard -> {
                        QuickAccessDTO quickAccessDTO = new QuickAccessDTO();
                        quickAccessDTO.setType(quickAccessType);
                        quickAccessDTO.setEntity((ConfigurationEntityVO)this.conversionHandler.convert(CustomWizardVO.class, directWizard));
                        return quickAccessDTO;
                    });
                }
                case RECORD: {
                    return this.recordTypeService.listRecordTypes().stream().filter(recordType -> role == Role.ADMIN ? recordType instanceof SystemRecordType : recordType instanceof UserRecordType).map(recordType -> {
                        QuickAccessDTO quickAccessDTO = new QuickAccessDTO();
                        quickAccessDTO.setType(quickAccessType);
                        quickAccessDTO.setEntity((ConfigurationEntityVO)this.conversionHandler.convert(RecordTypeVO.class, recordType));
                        return quickAccessDTO;
                    });
                }
            }
            return Stream.of(new QuickAccessDTO((org.cyclos.model.Property)QuickAccessDTO.TYPE, quickAccessType));
        };
        return QuickAccessType.getByRole((Role)role).stream().flatMap(function).collect(Collectors.toList());
    }

    private List<Product> listByNatures(Set<ProductNature> set) {
        if (CollectionHelper.isEmpty(set)) {
            return Collections.emptyList();
        }
        return ((DBQuery)this.from().where((Predicate)((QProduct)this.$).nature.in(set))).list((Expression)this.$);
    }

    private List<TransferTypeVO> listGeneratedTypes(AccountType accountType, AccountTypeNature accountTypeNature, AccountTypeNature accountTypeNature2) {
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setUnlimited();
        transferTypeQuery.setNatures(Collections.singleton(TransferTypeNature.GENERATED));
        transferTypeQuery.setFromNature(accountTypeNature);
        transferTypeQuery.setToNature(accountTypeNature2);
        if (accountType != null) {
            transferTypeQuery.setFromOrToAccountTypes(Collections.singleton(new AccountTypeVO(accountType.getId())));
        }
        return this.transferTypeService.search(transferTypeQuery).getPageItems();
    }

    private List<ProductVO> listMemberOrBrokerVOs() {
        List<Product> list = this.listByRoles(Arrays.asList(Role.MEMBER, Role.BROKER));
        List list2 = this.conversionHandler.convertList(ProductVO.class, list);
        return CollectionHelper.sort((Collection)list2);
    }

    private List<TransferTypeVO> listPaymentTypes(AccountType accountType, TransferTypeDirection transferTypeDirection) {
        return this.listPaymentTypes(accountType, transferTypeDirection, null);
    }

    private List<TransferTypeVO> listPaymentTypes(AccountType accountType, TransferTypeDirection transferTypeDirection, BuiltInChannel builtInChannel) {
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setUnlimited();
        transferTypeQuery.setDirection(transferTypeDirection);
        transferTypeQuery.setIncludeDisabled(true);
        if (accountType != null) {
            transferTypeQuery.setFromOrToAccountTypes(Collections.singleton(new AccountTypeVO(accountType.getId())));
        }
        transferTypeQuery.setNatures(Collections.singleton(TransferTypeNature.PAYMENT));
        transferTypeQuery.setChannel(builtInChannel == null ? null : ModelHelper.channel((String)builtInChannel.getInternalName()));
        return this.transferTypeService.search(PaymentTransferType.class, transferTypeQuery).getPageItems().stream().filter(paymentTransferType -> builtInChannel == BuiltInChannel.POS ? true : paymentTransferType.getChannels().size() > 1 || paymentTransferType.getChannels().stream().anyMatch(channel -> !channel.isPos())).map(this.conversionHandler.convertingFunction(TransferTypeVO.class, new Object[0])).collect(Collectors.toList());
    }

    private List<AccountTypeWithCurrencyVO> listSystemAccountTypes() {
        AccountTypeQuery accountTypeQuery = new AccountTypeQuery();
        accountTypeQuery.setUnlimited();
        accountTypeQuery.setNature(AccountTypeNature.SYSTEM);
        return this.accountTypeService.search(AccountTypeWithCurrencyVO.class, accountTypeQuery).getPageItems();
    }

    private List<TransferFilterWithAccountTypeVO> listTransferFilters(AccountType accountType, AccountTypeNature accountTypeNature) {
        TransferFilterQuery transferFilterQuery = new TransferFilterQuery();
        transferFilterQuery.setOwnerAccountTypeNature(accountTypeNature);
        if (accountType != null) {
            transferFilterQuery.setOwnerAccountType(new AccountTypeVO(accountType.getId()));
        }
        transferFilterQuery.setUnlimited();
        return this.transferFilterService.search(TransferFilterWithAccountTypeVO.class, transferFilterQuery).getPageItems();
    }

    private List<TransferTypeVO> listTransferTypesTo(AccountType accountType, AccountTypeNature accountTypeNature) {
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setUnlimited();
        transferTypeQuery.setToNature(accountTypeNature);
        transferTypeQuery.setIncludeDisabled(true);
        return this.transferTypeService.search(transferTypeQuery).getPageItems();
    }

    private <T extends AccountTypeVO> List<T> listUserAccountTypes(Class<T> clazz) {
        AccountTypeQuery accountTypeQuery = new AccountTypeQuery();
        accountTypeQuery.setUnlimited();
        accountTypeQuery.setNature(AccountTypeNature.USER);
        return this.accountTypeService.search(clazz, accountTypeQuery).getPageItems();
    }

    private Set<ProductNature> naturesForDTOProperty(org.cyclos.model.Property<?, ?> property) {
        EnumSet<ProductNature> enumSet = EnumSet.noneOf(ProductNature.class);
        Class clazz = property.getBeanType();
        if (AdminProductDTO.class.isAssignableFrom(clazz)) {
            enumSet.add(ProductNature.ADMIN);
        } else if (BrokerProductDTO.class.isAssignableFrom(clazz)) {
            enumSet.add(ProductNature.BROKER);
        } else if (MemberProductDTO.class.isAssignableFrom(clazz)) {
            enumSet.add(ProductNature.MEMBER);
        } else if (UserManagementProductDTO.class.isAssignableFrom(clazz)) {
            enumSet.add(ProductNature.ADMIN);
            enumSet.add(ProductNature.BROKER);
        } else if (ProductDTO.class.isAssignableFrom(clazz)) {
            enumSet.add(ProductNature.ADMIN);
            enumSet.add(ProductNature.BROKER);
            enumSet.add(ProductNature.MEMBER);
        }
        return enumSet;
    }

    private void removeRelationship(Product product, org.cyclos.model.Property<?, ?> property, SimpleEntity simpleEntity) {
        ProductConversionHandler productConversionHandler = this.getProductConverter(product);
        String string = productConversionHandler.getProductPropertyForDtoProperty(property);
        Collection collection = (Collection)InvocationContext.wrap((Object)product).getPropertyValue(string);
        if (collection.remove(simpleEntity)) {
            if (collection.isEmpty()) {
                Collection collection2 = productConversionHandler.getPermissionsForProperty(property);
                product.getPermissions().removeAll(collection2);
            }
            this.evictAccessorCache(product);
        }
    }

    private void resetAccountSettings(MemberProduct memberProduct) {
        memberProduct.setAccountAccessibility(null);
        memberProduct.setAccountVisibility(null);
        memberProduct.setShowAccountInProfile(null);
        memberProduct.setMyTransferFilters(Collections.EMPTY_SET);
        memberProduct.setInitialCredit(null);
        memberProduct.setInitialCreditType(null);
        memberProduct.setDefaultCreditLimit(null);
        memberProduct.setDefaultUpperCreditLimit(null);
        memberProduct.setIndividualCreditLimit(null);
        memberProduct.setDefaultPaymentAmountLimit(null);
        memberProduct.setDefaultPaymentAmountPerDayLimit(null);
        memberProduct.setDefaultPaymentAmountPerWeekLimit(null);
        memberProduct.setDefaultPaymentAmountPerMonthLimit(null);
        memberProduct.setChargebackPaymentTypes(Collections.EMPTY_SET);
        memberProduct.setMyApproveTicketPaymentTypes(Collections.EMPTY_SET);
        memberProduct.setMyCreateTicketPaymentTypes(Collections.EMPTY_SET);
        memberProduct.setMyExternalPaymentTypes(Collections.EMPTY_SET);
        memberProduct.setMyPaymentRequestTypes(Collections.EMPTY_SET);
        memberProduct.setMyPaymentTypes(Collections.EMPTY_SET);
        memberProduct.setAccountFees(Collections.EMPTY_SET);
        memberProduct.setReceivePaymentRequestTypes(Collections.EMPTY_SET);
        memberProduct.setReceivePosPaymentTypes(Collections.EMPTY_SET);
        memberProduct.setMakePosPaymentTypes(Collections.EMPTY_SET);
    }

    private void setFixedSMSNotificationSettings(Product product) {
        Set<UserProductNotification> set = this.ensureNotificationsIfNeeded(product);
        if (set != null) {
            UserProductNotification userProductNotification = this.ensureNotification((UserNotificationType)PersonalNotificationType.MAX_SMS_PER_MONTH_REACHED, product, set);
            userProductNotification.setEnabled(true);
            userProductNotification.setAllowSms(true);
            userProductNotification.setDefaultSms(true);
            userProductNotification = this.ensureNotification((UserNotificationType)AccountNotificationType.SMS_PERFORMED_PAYMENT, product, set);
            userProductNotification.setAllowSms(false);
            userProductNotification.setDefaultSms(false);
        }
    }

    private void setMessageCategories(AdminProductDTO adminProductDTO) {
        Set set = CollectionHelper.asSet((Iterable)this.messageCategoryService.list());
        adminProductDTO.setSendMessagesFromSysWithCat(set);
        if (CollectionHelper.isEmpty((Iterable)set)) {
            adminProductDTO.setMaxMessageRecipients(Integer.valueOf(0));
        } else {
            adminProductDTO.setMaxMessageRecipients(Integer.valueOf(10));
        }
    }

    private static /* synthetic */ boolean lambda$onBeforeSave$be06aa22$1(Long l, GroupsCacheKey groupsCacheKey) {
        return groupsCacheKey.matchesNetwork(l);
    }

    static {
        SUBCLASS_MAPPINGS.put(AdminProduct.class, AdminProductDTO.class);
        SUBCLASS_MAPPINGS.put(MemberProduct.class, MemberProductDTO.class);
        SUBCLASS_MAPPINGS.put(BrokerProduct.class, BrokerProductDTO.class);
    }
}

