/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.messaging.QUserNotificationSettings;
import org.cyclos.entities.messaging.QUserNotificationTypeSettings;
import org.cyclos.entities.messaging.UserNotificationSettings;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.OperatorGroupAccountType;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.QOperator;
import org.cyclos.entities.users.QOperatorGroupLog;
import org.cyclos.entities.users.QOperatorGroupPaymentType;
import org.cyclos.entities.users.QProductOperatorProfileField;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.UserNotificationSettingsDTO;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.OperatorExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.operatorgroups.OperatorGroupVO;
import org.cyclos.model.users.operators.EditOperatorProfileData;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.operators.OperatorData;
import org.cyclos.model.users.operators.OperatorDataParams;
import org.cyclos.model.users.operators.OperatorProfileActionsData;
import org.cyclos.model.users.operators.OperatorQuery;
import org.cyclos.model.users.operators.OperatorRegistrationDTO;
import org.cyclos.model.users.operators.OperatorRegistrationData;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.operators.OperatorWithFieldsVO;
import org.cyclos.model.users.operators.OperatorsSearchData;
import org.cyclos.model.users.operators.ViewOperatorProfileData;
import org.cyclos.model.users.products.AccountProfileVisibility;
import org.cyclos.model.users.products.UserBasicFieldActions;
import org.cyclos.model.users.products.UserCustomFieldActions;
import org.cyclos.model.users.products.UserProfileFieldActions;
import org.cyclos.model.users.users.AbstractUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractViewProfileData;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ChangeUserStatusParams;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.EditProfileConfirmationField;
import org.cyclos.model.users.users.EmailValidation;
import org.cyclos.model.users.users.OperatorGroupAccountAccess;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationDTO;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserRegistration;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.CloseableIteratorAdapter;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperatorServiceImpl
extends CRUDServiceImpl<Operator, QOperator, OperatorDTO, OperatorData, OperatorDataParams>
implements OperatorServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES_TO_ENTITY = new Object[]{AbstractUserRegistrationDTO.LAND_LINE_PHONES, AbstractUserRegistrationDTO.MOBILE_PHONES, AbstractUserRegistrationDTO.PASSWORDS};
    @Autowired
    private OperatorGroupServiceLocal operatorGroupService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private UserStatusServiceLocal userStatusService;
    @Autowired
    private BasicUserServiceLocal basicUserService;
    @Autowired
    private TokenServiceLocal tokenService;
    @Autowired
    private ConnectedUserServiceLocal connectedUserService;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private NotificationSettingsServiceLocal notificationSettingsService;

    public OperatorServiceImpl() {
        super(Operator.class, op, OperatorDTO.class);
    }

    public OperatorGroupAccountAccess accountAccess(Account account) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem() || !sessionData.isRestrictedOperator()) {
            return null;
        }
        if (!(account instanceof UserAccount)) {
            return OperatorGroupAccountAccess.NONE;
        }
        UserAccount userAccount = (UserAccount)account;
        User user = userAccount.getUser();
        Operator operator = sessionData.getLoggedOperator();
        if (operator.getUser().equals((Object)user)) {
            OperatorGroup operatorGroup = operator.getGroup();
            OperatorGroupAccountType operatorGroupAccountType = operatorGroup.getAccountType(userAccount.getType());
            OperatorGroupAccountAccess operatorGroupAccountAccess = operatorGroupAccountType == null ? null : operatorGroupAccountType.getAccess();
            return (OperatorGroupAccountAccess)ObjectHelper.defaultValue((Object)operatorGroupAccountAccess, (Object)OperatorGroupAccountAccess.NONE);
        }
        if (sessionData.isBrokerOf((BasicUser)user)) {
            return OperatorGroupAccountAccess.ALL_PAYMENTS;
        }
        AccountProfileVisibility accountProfileVisibility = this.productsHandler.getAccessor((BasicUser)user).member(userAccount.getType()).getShowAccountInProfile();
        return accountProfileVisibility != AccountProfileVisibility.HIDDEN ? OperatorGroupAccountAccess.ALL_PAYMENTS : OperatorGroupAccountAccess.NONE;
    }

    public boolean canEditProfile(Operator operator) {
        if (this.getSessionData().manages((BasicUser)operator) && !operator.isRemoved()) {
            List list = this.profileFieldHandler.getFieldActions((BasicUser)operator);
            for (UserProfileFieldActions userProfileFieldActions : list) {
                if (!userProfileFieldActions.isEdit()) continue;
                return true;
            }
        }
        return false;
    }

    public Object[] getExcludedPropertiesToEntity() {
        return EXCLUDED_PROPERTIES_TO_ENTITY;
    }

    public OperatorsSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = userLocatorVO == null ? null : this.userLocatorHandler.locate(userLocatorVO).getUser();
        OperatorsSearchData operatorsSearchData = new OperatorsSearchData();
        List list = user == null ? Collections.emptyList() : this.profileFieldHandler.getProfileFieldsInOperatorsList(user);
        operatorsSearchData.setProfileFieldsInList(this.profileFieldHandler.toVOs((Collection)list));
        this.profileFieldHandler.fill((DataWithBasicProfileFields)operatorsSearchData);
        if (user != null) {
            operatorsSearchData.setRemovedUser(user.isRemoved());
            operatorsSearchData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
            operatorsSearchData.setOperatorGroups(this.conversionHandler.convertList(OperatorGroupVO.class, (Iterable)this.operatorGroupService.list(user)));
        } else {
            operatorsSearchData.setUserGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
        }
        OperatorQuery operatorQuery = (OperatorQuery)QueryHelper.newQuery(OperatorQuery.class);
        operatorQuery.setUser((UserVO)userLocatorVO);
        if (!operatorsSearchData.isRemovedUser()) {
            operatorQuery.setUserStatus(EnumSet.of(UserStatus.ACTIVE, UserStatus.BLOCKED));
        }
        if (user == null) {
            operatorQuery.setIgnoreProfileFieldsInList(true);
            operatorQuery.setReturnUser(true);
        }
        operatorsSearchData.setQuery((QueryParameters)operatorQuery);
        return operatorsSearchData;
    }

    public ViewOperatorProfileData getViewProfileData(UserLocatorVO userLocatorVO) throws FrameworkException {
        boolean bl;
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (!(basicUser instanceof Operator)) {
            throw new EntityNotFoundException();
        }
        SessionData sessionData = this.getSessionData();
        Operator operator = (Operator)basicUser;
        OperatorGroup operatorGroup = operator.getGroup();
        boolean bl2 = bl = sessionData.manages((BasicUser)operator);
        if (sessionData.getLoggedBasicUser().equals((Object)operator)) {
            bl2 = operatorGroup == null || operatorGroup.isEditOwnProfile();
        }
        ViewOperatorProfileData viewOperatorProfileData = new ViewOperatorProfileData();
        viewOperatorProfileData.setDisplay(this.getFormatter().format((BasicUser)operator));
        viewOperatorProfileData.setCanEditProfile(bl2);
        viewOperatorProfileData.setCanManage(bl);
        viewOperatorProfileData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)operator.getUser()));
        viewOperatorProfileData.setOwnOperator(operator.getUser().equals((Object)sessionData.getLoggedUser()));
        viewOperatorProfileData.setGroup((OperatorGroupVO)this.conversionHandler.convert(OperatorGroupVO.class, (Object)operatorGroup));
        viewOperatorProfileData.setEnabledProfileFields(this.profileFieldHandler.toBasicVOs((Collection)this.profileFieldHandler.getEnabledProfileFields((BasicUser)operator)));
        if (sessionData.isLoggedIn()) {
            viewOperatorProfileData.setRelationship(this.authHandler.getRelationship(sessionData.getLoggedBasicUser(), (BasicUser)operator));
        }
        viewOperatorProfileData.setId(operator.getId());
        this.basicUserService.fillProfileFields((BasicUser)operator, (AbstractViewProfileData)viewOperatorProfileData);
        viewOperatorProfileData.setStatus(operator.getStatus());
        viewOperatorProfileData.setActions(this.getProfileActions(viewOperatorProfileData, operator));
        if (bl) {
            viewOperatorProfileData.setUserCreationDate(this.toDateTime(operator.getCreationDate()));
            viewOperatorProfileData.setEmailPendingValidation(operator.getNewEmail());
        }
        viewOperatorProfileData.setCanPhysicallyRemove(this.canRemovePendingOperator(operator));
        return viewOperatorProfileData;
    }

    public boolean hasOperators(User user) {
        return ((DBQuery)this.from(this.$).where((Predicate)((QOperator)this.$).user().eq((Object)user))).hasResults();
    }

    public CloseableIterator<Operator> iterateOperatorsToNotify(BasicUser basicUser, UserNotificationType userNotificationType, boolean bl, boolean bl2) {
        QUserNotificationSettings qUserNotificationSettings = QUserNotificationSettings.userNotificationSettings;
        QUserNotificationTypeSettings qUserNotificationTypeSettings = QUserNotificationTypeSettings.userNotificationTypeSettings;
        DBQuery dBQuery = (DBQuery)this.entityManagerHandler.subQuery(new EntityPath[]{qUserNotificationTypeSettings}).select((Expression)qUserNotificationTypeSettings.notifyByInternal).where(new Predicate[]{qUserNotificationTypeSettings.notificationSettings().eq((Expression)qUserNotificationSettings), qUserNotificationTypeSettings.type.eq((Object)userNotificationType)});
        return ((DBQuery)((DBQuery)((DBQuery)this.from(this.$).leftJoin((EntityPath)qUserNotificationSettings)).on((Predicate)qUserNotificationSettings.user().eq((Expression)((QOperator)this.$)._super))).where(new Predicate[]{((QOperator)this.$).user().eq((Object)basicUser.getUser()), bl ? ((QOperator)this.$).group().isNull() : ((QOperator)this.$).id.isNotNull(), basicUser.isOperator() ? ((QOperator)this.$)._super.ne((Object)basicUser) : ((QOperator)this.$).id.isNotNull(), Expressions.asBoolean((Expression)dBQuery).isTrue().or((Predicate)dBQuery.notExists().and((Predicate)Expressions.asBoolean((boolean)bl2).isTrue()))})).iterate((Expression)this.$);
    }

    public CloseableIterator<BasicUser> iteratePossibleAuthorizers(Operator operator, PaymentTransferType paymentTransferType) {
        User user = operator.getUser();
        CloseableIterator closeableIterator = CloseableIteratorHelper.singleton((Object)user);
        CloseableIteratorAdapter closeableIteratorAdapter = new CloseableIteratorAdapter(this.listAliases(user).iterator());
        CloseableIterator<Operator> closeableIterator2 = this.iterateRestrictedAuthorizers(operator, paymentTransferType);
        return CloseableIteratorHelper.chained((CloseableIterator[])new CloseableIterator[]{closeableIterator, closeableIteratorAdapter, closeableIterator2});
    }

    public List<Operator> list(User user) throws FrameworkException {
        return ((DBQuery)((DBQuery)this.from(this.$).where(new Predicate[]{((QOperator)this.$).user().eq((Object)user), ((QOperator)this.$).status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).orderBy(((QOperator)this.$).displayForManagers.asc())).list((Expression)this.$);
    }

    public List<Operator> listAliases(User user) throws FrameworkException {
        return ((DBQuery)((DBQuery)this.from(this.$).where(new Predicate[]{((QOperator)this.$).user().eq((Object)user), ((QOperator)this.$).group().isNull(), ((QOperator)this.$).status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).orderBy(((QOperator)this.$).displayForManagers.asc())).list((Expression)this.$);
    }

    @Override
    public Operator newEntity(OperatorDataParams operatorDataParams) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)operatorDataParams.getUser());
        OperatorGroup operatorGroup = operatorDataParams.getGroupId() == null ? null : this.find(OperatorGroup.class, operatorDataParams.getGroupId());
        Operator operator = new Operator();
        operator.setUser(user);
        operator.setGroup(operatorGroup);
        return operator;
    }

    public void onRegistrationValidation(Operator operator) {
        this.tokenService.generateOnRegistrationTokens((BasicUser)operator);
    }

    public UserRegistrationResult register(OperatorRegistrationDTO operatorRegistrationDTO) throws FrameworkException {
        Object object;
        User user = this.resolveUser((OperatorDTO)operatorRegistrationDTO);
        UserRegistration userRegistration = this.resolveUserRegistration(user);
        Validator validator = this.resolveValidator((OperatorDTO)operatorRegistrationDTO, userRegistration);
        this.validate(validator, operatorRegistrationDTO, "register");
        int n = this.productsHandler.getAccessor((BasicUser)user).memberOrBroker().getMaxOperators();
        if (this.count(user) >= n) {
            throw new MaxItemsException(n);
        }
        Operator operator = (Operator)this.basicUserService.preProcessRegistration((SimpleBasicUserRegistrationDTO)operatorRegistrationDTO, userRegistration);
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)OperatorExtensionPointEvent.CREATE, new ExtensionPointFilter(user.getGroup())).attribute("operator", (Object)operator);
        extensionPointAccessor.fireValidated();
        List list = this.profileFieldHandler.getFieldsByAction((BasicUser)operator, ProfileFieldAction.EDIT);
        this.persist((IEntity)operator);
        if (operator.isAliasOperator() && (object = (UserNotificationSettings)this.notificationSettingsService.findNotificationSettings((BasicUser)user, false)) != null) {
            UserNotificationSettingsDTO userNotificationSettingsDTO = this.notificationSettingsService.resolveUserNotificationSettingsDTO((BasicUser)user, null, (UserNotificationSettings)object);
            userNotificationSettingsDTO.setUser((BasicUserVO)new OperatorVO(operator.getId()));
            userNotificationSettingsDTO.setId(null);
            ModelHelper.clearIds((Iterable)userNotificationSettingsDTO.getNotificationTypeSettings());
            ModelHelper.clearIds((Iterable)userNotificationSettingsDTO.getAccountNotificationSettings());
            this.notificationSettingsService.save((NotificationSettingsDTO)userNotificationSettingsDTO);
        }
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)operator);
        this.basicUserService.persistAdditionalRegistrationData((BasicUser)operator, (SimpleBasicUserRegistrationDTO)operatorRegistrationDTO, list);
        this.persistAdditionalRegistrationData(operator);
        object = this.basicUserService.processRegistration((BasicUser)operator, (SimpleBasicUserRegistrationDTO)operatorRegistrationDTO);
        extensionPointAccessor.fireSaved();
        return this.basicUserService.buildRegistrationResult((BasicUser)operator, object.keySet());
    }

    public void removeAll(User user, boolean bl) {
        CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where(new Predicate[]{((QOperator)this.$).user().eq((Object)user), ((QOperator)this.$).status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).iterate((Expression)((QOperator)this.$).id);
        this.processBatch(closeableIterator, (T l) -> {
            ChangeUserStatusParams changeUserStatusParams = new ChangeUserStatusParams();
            changeUserStatusParams.setUser((BasicUserVO)new OperatorVO(l));
            changeUserStatusParams.setStatus(bl ? UserStatus.PURGED : UserStatus.REMOVED);
            this.userStatusService.changeStatus(changeUserStatusParams);
        });
    }

    public Page<OperatorWithFieldsVO> search(OperatorQuery operatorQuery) throws FrameworkException {
        QProductOperatorProfileField qProductOperatorProfileField;
        Set set;
        DatePeriod datePeriod;
        Set set2;
        Set set3;
        Set set4;
        User user;
        ProductsAccessor productsAccessor;
        DBQuery<?> dBQuery = this.from();
        String string = operatorQuery.getKeywords();
        if (QueryHelper.useParameter((Object)string)) {
            dBQuery.where((Predicate)((QOperator)this.$).name.containsIgnoreCase(string).or((Predicate)((QOperator)this.$).username.eq((Object)string)));
        }
        ProductsAccessor productsAccessor2 = productsAccessor = (user = (User)this.conversionHandler.convert(User.class, (Object)operatorQuery.getUser())) == null ? null : this.productsHandler.getAccessor((BasicUser)user);
        if (user != null) {
            if (!productsAccessor.memberOrBroker().hasPermission(Permission.MY_OPERATORS_ENABLE)) {
                return PageImpl.empty();
            }
            dBQuery.where((Predicate)((QOperator)this.$).user().eq((Object)user));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set4 = this.groupsHandler.flattenVOs((Collection)operatorQuery.getUserGroups())))) {
            dBQuery.where((Predicate)((QOperator)this.$).user().group().in((Collection)set4));
        }
        this.visibility(dBQuery, ((QOperator)this.$).user()).onlySelf();
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)operatorQuery.getBroker());
        if (user2 != null) {
            dBQuery.where((Predicate)((QOperator)this.$).user().brokers.contains((Object)user2));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set3 = this.conversionHandler.convertSet(OperatorGroup.class, (Iterable)operatorQuery.getOperatorGroups())))) {
            dBQuery.where((Predicate)((QOperator)this.$).group().in((Collection)set3));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set2 = operatorQuery.getUserStatus()))) {
            dBQuery.where((Predicate)((QOperator)this.$).status.in((Collection)set2));
        }
        if ((datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)operatorQuery.getCreated())) != null) {
            dBQuery.where(((QOperator)this.$).creationDate.period(datePeriod));
        }
        Page page = ((DBQuery)dBQuery.orderBy(((QOperator)this.$).name.asc())).page((QueryParameters)operatorQuery, (Expression)this.$);
        if (operatorQuery.isIgnoreProfileFieldsInList() || user == null) {
            set = Collections.emptySet();
        } else {
            qProductOperatorProfileField = QProductOperatorProfileField.productOperatorProfileField;
            set = productsAccessor.memberOrBroker().getOperatorProfileFields().keysSet((Path)qProductOperatorProfileField.operatorList);
        }
        qProductOperatorProfileField = this.getFormatter();
        return PageImpl.transformed((Page)page, arg_0 -> this.lambda$search$1(operatorQuery, set, (FormatterImpl)qProductOperatorProfileField, arg_0));
    }

    @Override
    public OperatorDTO toDTO(Operator operator) {
        Class clazz = operator.isTransient() ? OperatorRegistrationDTO.class : OperatorDTO.class;
        return (OperatorDTO)this.conversionHandler.convert(clazz, (Object)operator);
    }

    @Override
    protected void addCustomNameValidations(org.cyclos.impl.utils.validation.Property property, OperatorDTO operatorDTO) {
        this.basicUserService.addNameValidations(property, (BasicUserDTO)operatorDTO);
    }

    @Override
    protected void doRemove(Operator operator, boolean bl) {
        this.customFieldValueHandler.removeAll((EntityWithCustomValues)operator);
        super.doRemove(operator, bl);
    }

    @Override
    protected OperatorData getData(Operator operator) {
        EditOperatorProfileData editOperatorProfileData;
        if (operator.getUser().isRemoved()) {
            throw new IllegalActionException();
        }
        OperatorDTO operatorDTO = this.toDTO(operator);
        SessionData sessionData = this.getSessionData();
        List list = this.profileFieldHandler.getFieldActions((BasicUser)operator);
        Set set = CollectionHelper.filterByType(list.stream(), UserBasicFieldActions.class).filter(UserProfileFieldActions::isView).map(UserBasicFieldActions::getBasicField).collect(Collectors.toSet());
        List list2 = CollectionHelper.filterByType(list.stream(), UserCustomFieldActions.class).map(UserCustomFieldActions::getCustomField).collect(Collectors.toList());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("user", operator.getUser());
        hashMap.put("operator", operator);
        this.customFieldValueHandler.fillValuesFromScript(UserCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, list2);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)operator);
        if (operator.isTransient()) {
            OperatorRegistrationData operatorRegistrationData = new OperatorRegistrationData();
            OperatorRegistrationDTO operatorRegistrationDTO = (OperatorRegistrationDTO)operatorDTO;
            operatorRegistrationData.setProfileFieldActions(list);
            this.basicUserService.fillRegistrationData((SimpleBasicUserRegistrationData)operatorRegistrationData, this.resolveUserRegistration(operator.getUser()), (BasicUser)operator);
            if (set.contains(BasicProfileField.PHONE)) {
                operatorRegistrationData.setPhoneConfiguration(this.configurationService.toPhoneConfiguration(configurationAccessor));
            }
            List list3 = operator.getGroup() == null ? this.operatorGroupService.list(operator.getUser()) : Collections.singletonList(operator.getGroup());
            operatorRegistrationData.setGroups(list3.stream().map(this.conversionHandler.convertingFunction(OperatorGroupVO.class, new Object[]{OperatorGroupVO.USER})).collect(Collectors.toList()));
            boolean bl = sessionData.isAdmin();
            boolean bl2 = sessionData.isBrokerOf((BasicUser)operator.getUser());
            boolean bl3 = operator.getUser().equals((Object)sessionData.getLoggedUser());
            Set set2 = sessionData.getConfiguration().getEmailValidation();
            boolean bl4 = bl && set2.contains(EmailValidation.REGISTRATION_BY_ADMIN) || bl2 && set2.contains(EmailValidation.REGISTRATION_BY_BROKER) || bl3 && set2.contains(EmailValidation.OPERATOR_REGISTRATION_BY_MEMBER);
            operatorRegistrationData.setAllowSetSendActivationEmail(!bl4);
            operatorRegistrationDTO.setPasswords(operatorRegistrationData.getPasswordsData().stream().map(passwordRegistrationData -> {
                PasswordRegistrationDTO passwordRegistrationDTO = new PasswordRegistrationDTO();
                passwordRegistrationDTO.setType((PasswordTypeVO)passwordRegistrationData.getType());
                return passwordRegistrationDTO;
            }).collect(Collectors.toList()));
            editOperatorProfileData = operatorRegistrationData;
        } else {
            EditOperatorProfileData editOperatorProfileData2 = new EditOperatorProfileData();
            FormatterImpl formatterImpl = this.getFormatter();
            editOperatorProfileData2.setDisplay(formatterImpl.format((BasicUser)operator));
            editOperatorProfileData2.setProfileFieldActions(list);
            editOperatorProfileData2.setEmailPendingValidation(operator.getNewEmail());
            if (set.contains(BasicProfileField.PHONE)) {
                editOperatorProfileData2.setPhoneListData(this.phoneService.getPhoneListData(new UserLocatorVO(operator.getId())));
            }
            editOperatorProfileData = editOperatorProfileData2;
        }
        this.customFieldValueHandler.setDefaultValues(list2, (ModelWithCustomValues)operatorDTO);
        editOperatorProfileData.setDto((EntityDTO)operatorDTO);
        editOperatorProfileData.setEnablePrivacy(this.profileFieldHandler.enablePrivacy((BasicUser)operator));
        editOperatorProfileData.setEmailRequired(configurationAccessor.isEmailRequired());
        return editOperatorProfileData;
    }

    @Override
    protected CreateDeviceConfirmationParams getDeviceConfirmationParams(OperatorDTO operatorDTO, Operator operator, CRUDOperation cRUDOperation) {
        return EditProfileConfirmationField.confirmation();
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(OperatorDTO operatorDTO) {
        return this.getExcludedPropertiesToEntity();
    }

    @Override
    protected Pair<DBQuery<?>, String> getUniqueNameQuery(OperatorDTO operatorDTO) {
        return null;
    }

    @Override
    protected boolean isNameRequired(OperatorDTO operatorDTO) {
        return this.basicUserService.isNameRequired((BasicUserDTO)operatorDTO);
    }

    @Override
    protected void onAfterSave(Operator operator, Operator operator2, Object object) {
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)operator);
    }

    @Override
    protected void onBeforeRemove(Operator operator) {
        if (!operator.isPendingValidation()) {
            throw new IllegalActionException();
        }
    }

    @Override
    protected Object onBeforeSave(Operator operator, Operator operator2) {
        if (operator.isTransient()) {
            throw new IllegalActionException("This method only supports updating an operator. For new operators, use the register() method");
        }
        this.basicUserService.updateDisplay((BasicUser)operator);
        if (!operator.isPendingValidation() && !Objects.equals(operator.getEmail(), operator2.getEmail())) {
            if (this.basicUserService.requiresEmailChangeValidation((BasicUser)operator)) {
                this.basicUserService.setEmailChangeValidation((BasicUser)operator, operator2.getEmail());
            } else {
                operator.setEmailVerified(false);
            }
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(OperatorDTO operatorDTO, Operator operator) {
        operator.getCustomValues().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QOperatorGroupLog.operatorGroupLog.operator().network());
    }

    @Override
    protected ExtensionPointAccessor resolveExtensionPointAccessor(CRUDOperation cRUDOperation, Operator operator) {
        if (cRUDOperation != CRUDOperation.CREATE && cRUDOperation != CRUDOperation.UPDATE) {
            return null;
        }
        OperatorExtensionPointEvent operatorExtensionPointEvent = cRUDOperation == CRUDOperation.CREATE ? OperatorExtensionPointEvent.CREATE : OperatorExtensionPointEvent.UPDATE;
        return this.extensionPointService.newAccessor((ExtensionPointEvent)operatorExtensionPointEvent, new ExtensionPointFilter(operator.getUser().getGroup())).attribute("operator", (Object)operator).attribute("user", null);
    }

    @Override
    protected Validator resolveValidator(OperatorDTO operatorDTO) {
        if (operatorDTO.isTransient()) {
            throw new IllegalActionException("This method only supports updating an operator. For new operators, use the register() method");
        }
        return this.resolveValidator(operatorDTO, null);
    }

    @Override
    protected boolean shouldCheckConfirmationPassword(Operator operator, CRUDOperation cRUDOperation) {
        return this.basicUserService.shouldCheckConfirmationPassword((BasicUser)operator, cRUDOperation);
    }

    private boolean canRemovePendingOperator(Operator operator) {
        return this.getSessionData().manages((BasicUser)operator) && operator.isPendingValidation();
    }

    private int count(User user) {
        return ((DBQuery)this.from(this.$).where(new Predicate[]{((QOperator)this.$).user().eq((Object)user), ((QOperator)this.$).status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).count(((QOperator)this.$).id);
    }

    private OperatorProfileActionsData getProfileActions(ViewOperatorProfileData viewOperatorProfileData, Operator operator) {
        boolean bl;
        OperatorProfileActionsData operatorProfileActionsData = new OperatorProfileActionsData();
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        boolean bl2 = this.permission((BasicUser)operator.getUser()).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_OPERATORS}).granted();
        if (operator.equals((Object)basicUser) || !bl2) {
            return operatorProfileActionsData;
        }
        operatorProfileActionsData.setTokens(this.principalTypeService.listUserTokenPermissions((BasicUser)operator));
        ProductAccessor productAccessor = this.productsHandler.getAccessor((BasicUser)operator).product();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)operator);
        boolean bl3 = sessionData.isAdminOf((BasicUser)operator.getUser());
        boolean bl4 = sessionData.isBrokerOf((BasicUser)operator.getUser());
        boolean bl5 = bl = !bl3 && !bl4;
        if (!operator.isRemoved() && bl2) {
            operatorProfileActionsData.setManagePhones(this.profileFieldHandler.isAllowed((BasicUser)operator, (ProfileField)BasicProfileField.PHONE, ProfileFieldAction.EDIT));
        }
        if (operator.isPendingValidation()) {
            operatorProfileActionsData.setResendRegistrationValidationEmail(true);
            operatorProfileActionsData.setManuallyValidateRegistration(bl3 || bl4);
        } else if (!operator.isRemoved()) {
            OperatorGroup operatorGroup = operator.getGroup();
            operatorProfileActionsData.setManagePasswords(bl2);
            operatorProfileActionsData.setViewTrustedDevices(bl2 && (bl || sessionData.hasPermission(Permission.USER_TRUSTED_DEVICES_VIEW)));
            operatorProfileActionsData.setDisconnect(bl2 && this.connectedUserService.isOnline((BasicUser)operator));
            operatorProfileActionsData.setResetSecurityQuestion(configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION);
            operatorProfileActionsData.setViewNotificationSettings(!(!bl2 || operatorGroup != null && !operatorGroup.isNotifications() || !productAccessor.hasPermission(Permission.MY_NOTIFICATIONS_ENABLE) && !productAccessor.hasPermission(Permission.MY_MESSAGES_FORWARD_TO_EMAIL)));
            if (operator.isPendingNewEmailValidation()) {
                operatorProfileActionsData.setResendEmailChangeEmail(true);
                operatorProfileActionsData.setManuallyValidateEmail(bl3 || bl4);
            }
        }
        operatorProfileActionsData.setViewGroupHistory(bl2);
        operatorProfileActionsData.setViewOidcAuthorizations(bl2 && this.permission((BasicUser)operator).my(new Permission[]{Permission.MY_OIDC_AUTHORIZATIONS_ENABLE}).user(new Permission[]{Permission.USER_OIDC_AUTHORIZATIONS_VIEW}).granted());
        operatorProfileActionsData.setViewIdentityProviders(bl2 && this.permission((BasicUser)operator).my(new Permission[]{Permission.MY_IDENTITY_PROVIDERS_ENABLE}).user(new Permission[]{Permission.USER_IDENTITY_PROVIDERS_VIEW}).granted());
        operatorProfileActionsData.setViewStatusHistory(bl2);
        operatorProfileActionsData.setPossibleNewStatuses(this.userStatusService.getPossibleNewStatuses((BasicUser)operator));
        return operatorProfileActionsData;
    }

    private CloseableIterator<Operator> iterateRestrictedAuthorizers(Operator operator, PaymentTransferType paymentTransferType) {
        QOperatorGroupPaymentType qOperatorGroupPaymentType = QOperatorGroupPaymentType.operatorGroupPaymentType;
        return ((DBQuery)this.from(this.$).where(new Predicate[]{((QOperator)this.$).ne((Object)operator), ((QOperator)this.$).group().id.in((SubQueryExpression)((DBQuery)this.from(new EntityPath[]{qOperatorGroupPaymentType}).where(new Predicate[]{qOperatorGroupPaymentType.group().user().eq((Object)operator.getUser()), qOperatorGroupPaymentType.paymentType().eq((Object)paymentTransferType), qOperatorGroupPaymentType.authorize.isTrue()})).select((Expression)qOperatorGroupPaymentType.group().id))})).iterate((Expression)this.$);
    }

    private void persistAdditionalRegistrationData(Operator operator) {
        this.logEntity(null, operator);
        this.userStatusService.createStatusLog((BasicUser)operator);
        this.operatorGroupService.createInitialGroupHistoryLog(operator);
    }

    private User resolveUser(OperatorDTO operatorDTO) {
        User user;
        if (operatorDTO.isPersistent()) {
            Operator operator = (Operator)this.find(operatorDTO.getId());
            user = operator.getUser();
        } else {
            user = (User)this.conversionHandler.convert(User.class, (Object)operatorDTO.getUser());
        }
        if (user.isRemoved()) {
            throw new IllegalActionException();
        }
        return user;
    }

    private UserRegistration resolveUserRegistration(User user) {
        SessionData sessionData = this.getSessionData();
        if (user == null) {
            return null;
        }
        if (sessionData.isSystem()) {
            return UserRegistration.POPULATOR;
        }
        if (user.equals((Object)sessionData.getLoggedUser())) {
            return UserRegistration.USER;
        }
        if (sessionData.isAdminOf((BasicUser)user)) {
            return UserRegistration.ADMIN;
        }
        if (sessionData.isBrokerOf((BasicUser)user)) {
            return UserRegistration.BROKER;
        }
        throw new IllegalActionException();
    }

    private Validator resolveValidator(OperatorDTO operatorDTO, UserRegistration userRegistration) {
        Operator operator;
        User user = this.resolveUser(operatorDTO);
        if (user == null) {
            Validator validator = new Validator();
            validator.property((Property)OperatorDTO.USER, UsersKeys.Users.USER).required();
            return validator;
        }
        if (operatorDTO.isPersistent()) {
            operator = (Operator)this.find(operatorDTO.getId());
        } else {
            operator = new Operator(user);
            operator.setEmail(operatorDTO.getEmail());
            operator.setUsername(operatorDTO.getUsername());
            operator.setRegistrationType(userRegistration);
        }
        Validator validator = new Validator();
        this.basicUserService.addValidations(validator, (BasicUserDTO)operatorDTO, (BasicUser)operator, null);
        if (operatorDTO instanceof OperatorRegistrationDTO) {
            OperatorRegistrationDTO operatorRegistrationDTO = (OperatorRegistrationDTO)operatorDTO;
            this.basicUserService.addRegistrationValidations(validator, (SimpleBasicUserRegistrationDTO)operatorRegistrationDTO, userRegistration, (BasicUser)operator, null);
        }
        return validator;
    }

    private OperatorWithFieldsVO toOperatorWithFieldsVO(Operator operator, boolean bl, Set<ProfileField> set, FormatterImpl formatterImpl) {
        OperatorWithFieldsVO operatorWithFieldsVO = new OperatorWithFieldsVO();
        operatorWithFieldsVO.setId(operator.getId());
        operatorWithFieldsVO.setGroup((OperatorGroupVO)this.conversionHandler.convert(OperatorGroupVO.class, (Object)operator.getGroup()));
        if (bl) {
            operatorWithFieldsVO.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)operator.getUser()));
        }
        if (CollectionHelper.isEmpty(set)) {
            operatorWithFieldsVO.setDisplay(formatterImpl.format((BasicUser)operator));
        } else {
            for (ProfileField profileField : set) {
                Object object;
                if (profileField instanceof BasicProfileField) {
                    switch ((BasicProfileField)profileField) {
                        case EMAIL: {
                            operatorWithFieldsVO.setEmail(operator.getEmail());
                            break;
                        }
                        case FULL_NAME: {
                            operatorWithFieldsVO.setName(operator.getName());
                            break;
                        }
                        case LOGIN_NAME: {
                            operatorWithFieldsVO.setUsername(operator.getUsername());
                            break;
                        }
                        case PHONE: {
                            object = this.phoneService.getDefaultPhone((BasicUser)operator);
                            if (object == null) break;
                            operatorWithFieldsVO.setPhone(formatterImpl.format((Phone)object));
                            break;
                        }
                    }
                    continue;
                }
                object = this.profileFieldHandler.getFieldValue((BasicUser)operator, profileField);
                if (object == null) continue;
                if (operatorWithFieldsVO.getCustomValues() == null) {
                    operatorWithFieldsVO.setCustomValues(new ArrayList());
                }
                operatorWithFieldsVO.getCustomValues().add((CustomFieldValueVO)this.conversionHandler.convert(CustomFieldValueVO.class, object));
            }
        }
        return operatorWithFieldsVO;
    }

    private /* synthetic */ OperatorWithFieldsVO lambda$search$1(OperatorQuery operatorQuery, Set set, FormatterImpl formatterImpl, Operator operator) {
        return this.toOperatorWithFieldsVO(operator, operatorQuery.isReturnUser(), set, formatterImpl);
    }
}

