/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.BrokerGroup;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.QAdminGroup;
import org.cyclos.entities.users.QBasicGroup;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.GroupList;
import org.cyclos.impl.users.GroupListView;
import org.cyclos.impl.users.GroupListViewFactory;
import org.cyclos.impl.users.GroupListViewFactoryAccessor;
import org.cyclos.impl.users.GroupListViewFactoryImpl;
import org.cyclos.impl.users.GroupsCacheKey;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.GroupsHandlerInternal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.cache.CollectionAccessorCacheValue;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.configurations.UserSearchInMenuMode;
import org.cyclos.model.users.groups.AdminGroupVO;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupSetVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.InitialGroupVO;
import org.cyclos.model.users.groups.UserGroupDTO;
import org.cyclos.model.users.groups.UserGroupVO;
import org.cyclos.model.users.products.AdminGroupAccessibility;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.users.GroupFilterDefault;
import org.cyclos.model.users.users.GroupVisibility;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupsHandlerImpl
extends BaseNetworkedHandlerImpl
implements GroupsHandlerInternal {
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<GroupsCacheKey, CollectionAccessorCacheValue> cache;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    private static Set<BasicGroup> applyVisibility(GroupVisibility groupVisibility, Set<? extends BasicGroup> set) {
        if (groupVisibility == null || groupVisibility == GroupVisibility.NONE) {
            return Collections.emptySet();
        }
        if (groupVisibility == GroupVisibility.GROUP_SET) {
            TreeSet<BasicGroup> treeSet = new TreeSet<BasicGroup>();
            for (BasicGroup basicGroup : set) {
                GroupSet groupSet;
                if (basicGroup instanceof GroupSet) {
                    treeSet.add(basicGroup);
                    continue;
                }
                if (!(basicGroup instanceof UserGroup) || (groupSet = ((UserGroup)basicGroup).getGroupSet()) == null) continue;
                treeSet.add((BasicGroup)groupSet);
            }
            return treeSet;
        }
        return set;
    }

    public GroupListViewFactoryImpl accessibles() {
        return this.getBasicGroups(GroupList.ACCESSIBLE, false);
    }

    public GroupListViewFactoryImpl ads() {
        return this.getBasicGroups(GroupList.ADS, true);
    }

    public GroupListViewFactory all() {
        return GroupListViewFactoryImpl.of(this, false, this.getSessionData().isAdmin() || this.getSessionData().isSystem(), this.getAllAccessibleBasicGroups());
    }

    public GroupListViewFactoryImpl directory() {
        return this.getBasicGroups(GroupList.DIRECTORY, false);
    }

    public Set<Group> flatten(Collection<? extends BasicGroup> collection) {
        return GroupsHandler.doFlattenGroups(collection, (boolean)false);
    }

    public Set<Group> flattenVOs(Collection<? extends BasicGroupVO> collection) {
        Set set = collection == null ? null : this.conversionHandler.convertSet(BasicGroup.class, collection);
        return this.flatten(set);
    }

    public Set<Group> flattenVOs(Collection<? extends BasicGroupVO> collection, boolean bl) {
        Set set = collection == null ? null : this.conversionHandler.convertSet(BasicGroup.class, collection);
        return GroupsHandler.doFlattenGroups((Collection)set, (boolean)bl);
    }

    public Set<BasicGroup> getAccessibleBasicGroups(boolean bl, BasicGroup basicGroup, ProductsAccessor productsAccessor) {
        Set<BasicGroup> set = this.doGetAccessibleBasicGroups(true, false, basicGroup, productsAccessor);
        if (bl) {
            if (CollectionHelper.isEmpty(set)) {
                set = new HashSet<BasicGroup>();
            }
            set.addAll(productsAccessor.broker().getUserRegistrationGroups());
        }
        return set;
    }

    public Set<AdminGroup> getAccessibleGlobalGroups() {
        User user = this.getLoggedUser();
        if (user != null) {
            if (user.isGlobalAdmin()) {
                QAdminGroup qAdminGroup = QAdminGroup.adminGroup;
                return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qAdminGroup}).where((Predicate)qAdminGroup.network().isNull())).set((Expression)qAdminGroup);
            }
            if (user.isAdmin() && user.isGlobal()) {
                return Collections.singleton((AdminGroup)user.getGroup());
            }
        }
        return Collections.emptySet();
    }

    public Set<UserGroup> getAccessibleUserGroups(User user) {
        Set<Group> set = this.doGetAccessibleGroups(false, (BasicGroup)user.getGroup(), this.productsHandler.getAccessor((BasicUser)user));
        this.filterOutAdminGroups(set);
        return set;
    }

    public ConversionHandler getConversionHandler() {
        return this.conversionHandler;
    }

    public Set<BasicGroup> getDefaultGroupFilter(Set<? extends BasicGroup> set, BasicGroup basicGroup, ProductsAccessor productsAccessor) {
        return this.doGetDefaultGroupFilter(set, basicGroup, productsAccessor, true);
    }

    public Set<BasicGroupVO> getDefaultGroupFilter(Set<? extends BasicGroup> set, Collection<? extends BasicGroupVO> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptySet();
        }
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem() || sessionData.isGuest()) {
            return Collections.emptySet();
        }
        Set<BasicGroup> set2 = this.doGetDefaultGroupFilter(set, (BasicGroup)sessionData.getGroup(), sessionData.getProducts(), false);
        Set set3 = this.conversionHandler.convertSet(BasicGroupVO.class, set2);
        set3.retainAll(collection);
        return this.normalizeBasicGroups(set3);
    }

    public GroupVisibility getGroupVisibility(boolean bl) {
        return this.getGroupVisibility(null, bl);
    }

    public GroupVisibility getGroupVisibility(ProductsAccessor productsAccessor, boolean bl) {
        GroupVisibility groupVisibility;
        SessionData sessionData;
        if (productsAccessor == null) {
            sessionData = this.getSessionData();
            if (sessionData.isAdmin() || sessionData.isSystem()) {
                return GroupVisibility.GROUP;
            }
            if (sessionData.isGuest()) {
                return GroupVisibility.NONE;
            }
            productsAccessor = sessionData.getProducts();
        }
        sessionData = (GroupVisibility)ObjectHelper.defaultValue((Object)productsAccessor.member().getGroupVisibility(), (Object)GroupVisibility.NONE);
        if (bl && (groupVisibility = (GroupVisibility)ObjectHelper.defaultValue((Object)productsAccessor.broker().getGroupVisibility(), (Object)GroupVisibility.NONE)).compareTo((Enum)sessionData) > 0) {
            sessionData = groupVisibility;
        }
        return sessionData;
    }

    public List<InitialGroupVO> getPossiblePublicInitialGroups() {
        return this.getSessionData().getConfiguration().getPossibleInitialGroups().stream().filter(Group::isEnabled).sorted().map(this::toInitialGroupVO).collect(Collectors.toList());
    }

    public Set<Group> getPossibleRegistrationGroups(boolean bl, boolean bl2) {
        SessionData sessionData = this.getSessionData();
        Collection<Object> collection = null;
        if (sessionData.isSystem()) {
            collection = GroupsHandler.doFlattenGroups((Collection)sessionData.getAccessibleBasicGroups(), (boolean)false);
        } else if (sessionData.isAdmin()) {
            collection = sessionData.hasPermission(Permission.USERS_REGISTER) ? this.getAccessibleGroups() : null;
        } else if (sessionData.isBroker()) {
            ProductsAccessor productsAccessor = sessionData.getProducts();
            Collection<Object> collection2 = collection = bl2 ? productsAccessor.member().getUserRegistrationGroups() : GroupsHandler.doFlattenGroups((Collection)productsAccessor.broker().getUserRegistrationGroups(), (boolean)false);
            if (bl2) {
                collection.retainAll(this.getAccessibleGroups());
            }
        } else if (sessionData.isMember()) {
            collection = sessionData.getProducts().member().getUserRegistrationGroups();
            collection.retainAll(this.getAccessibleGroups());
        }
        if (collection != null) {
            collection.removeIf(group -> !group.isEnabled() || bl && !(group instanceof UserGroup));
        }
        return CollectionHelper.isEmpty(collection) ? Collections.emptySet() : new HashSet<Group>(collection);
    }

    public List<InitialGroupVO> getPossibleRegistrationInitialGroups(boolean bl) {
        return this.getPossibleRegistrationGroups(false, bl).stream().map(this::toInitialGroupVO).collect(Collectors.toList());
    }

    public Set<BasicGroup> getSearchOnGroups(boolean bl, BasicGroup basicGroup, ProductsAccessor productsAccessor) {
        boolean bl2 = basicGroup instanceof UserGroup;
        if (bl2) {
            Set<BasicGroup> set = this.resolveGroupsForMember(basicGroup, productsAccessor, productsAccessor.member().getSearchUsersOnGroups(), productsAccessor.member().getGroupsForUserSearch());
            if (bl) {
                set.addAll(productsAccessor.broker().getUserRegistrationGroups());
            }
            return set;
        }
        Set<BasicGroup> set = this.doGetAccessibleBasicGroups(true, false, basicGroup, productsAccessor);
        if (bl) {
            this.filterOutAdminGroups(set);
        }
        return set;
    }

    public Set<BasicGroup> getUserDirectoryOnGroups(BasicGroup basicGroup, ProductsAccessor productsAccessor) {
        Set<BasicGroup> set = this.resolveGroupsForMember(basicGroup, productsAccessor, productsAccessor.product().getUserDirectoryOnGroups(), productsAccessor.product().getGroupsForUserDirectory());
        return set;
    }

    public Set<BasicGroup> getViewProfileOnGroups() {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            return sessionData.getConfiguration().getGroupsForViewProfile();
        }
        if (sessionData.isSystem()) {
            return new HashSet<BasicGroup>(sessionData.getAccessibleBasicGroups());
        }
        return this.getViewProfileOnGroups((BasicGroup)sessionData.getGroup(), sessionData.getProducts());
    }

    public Set<BasicGroup> getViewProfileOnGroups(BasicGroup basicGroup, ProductsAccessor productsAccessor) {
        boolean bl = basicGroup instanceof UserGroup;
        if (bl) {
            return this.resolveGroupsForMember(basicGroup, productsAccessor, productsAccessor.member().getViewProfileOnGroups(), productsAccessor.member().getGroupsForViewProfile());
        }
        return new HashSet<BasicGroup>(this.getAccessibleBasicGroups(false, basicGroup, productsAccessor));
    }

    @PostConstruct
    public void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.GROUPS);
    }

    public GroupListViewFactory menu() {
        return this.getBasicGroups(GroupList.MENU, false);
    }

    public List<BasicGroupVO> sortHierarchy(Collection<? extends BasicGroup> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptyList();
        }
        List list = this.conversionHandler.convertList((Map)VO_MAPPINGS, collection);
        Collections.sort(list, GroupComparator.INSTANCE);
        return list;
    }

    public InitialGroupVO toInitialGroupVO(Group group) {
        InitialGroupVO initialGroupVO = new InitialGroupVO(group.getId());
        if (group instanceof UserGroup) {
            String string = this.dataTranslationHandler.getName((NamedEntity)group);
            String string2 = this.dataTranslationHandler.getValue((BaseEntity)group, UserGroupDTO.INITIAL_GROUP_DISPLAY_NAME.getName(), true);
            String string3 = this.dataTranslationHandler.getValue((BaseEntity)group, UserGroupDTO.INITIAL_GROUP_DESCRIPTION.getName(), true);
            initialGroupVO.setName(StringHelper.isBlank((Object)string2) ? string : string2);
            initialGroupVO.setInternalName(group.getInternalName());
            initialGroupVO.setDescription(string3);
        } else {
            initialGroupVO.setName(group.getName());
            initialGroupVO.setInternalName(group.getInternalName());
        }
        return initialGroupVO;
    }

    public GroupListViewFactoryImpl users() {
        return this.getBasicGroups(GroupList.USERS, false);
    }

    public GroupListViewFactory viewFactory(Collection<? extends BasicGroup> collection) {
        return new CustomGroupListViewFactoryImpl(collection);
    }

    public GroupListViewFactory viewFactory(GroupList groupList) {
        switch (groupList) {
            case ACCESSIBLE: {
                return this.accessibles();
            }
            case ADS: {
                return this.getBasicGroups(GroupList.ADS, false);
            }
            case DIRECTORY: {
                return this.directory();
            }
            case USERS: {
                return this.users();
            }
            case MENU: {
                return this.menu();
            }
        }
        throw new IllegalArgumentException("Unknown group list: " + String.valueOf(this));
    }

    public GroupListViewFactoryAccessor visibles() {
        return new VisibleGroupListViewFactoryAccessorImpl();
    }

    private Set<BasicGroup> doGetAccessibleBasicGroups(boolean bl, boolean bl2, BasicGroup basicGroup, ProductsAccessor productsAccessor) {
        Set<? extends BasicGroup> set = this.rawGetAccessibleBasicGroups(basicGroup, productsAccessor);
        return GroupsHandler.doFlatten(set, (boolean)bl2, (boolean)bl);
    }

    private Set<Group> doGetAccessibleGroups(boolean bl, BasicGroup basicGroup, ProductsAccessor productsAccessor) {
        Set<? extends BasicGroup> set = this.rawGetAccessibleBasicGroups(basicGroup, productsAccessor);
        return GroupsHandler.doFlatten(set, (boolean)bl, (boolean)false);
    }

    private Set<BasicGroup> doGetBasicGroups(GroupList groupList, boolean bl) {
        Set<BasicGroup> set = null;
        SessionData sessionData = this.getSessionData();
        if (sessionData.isAdmin() && groupList != GroupList.DIRECTORY) {
            groupList = GroupList.ACCESSIBLE;
        }
        switch (groupList) {
            case ACCESSIBLE: {
                set = this.getAccessibleBasicGroups(bl);
                break;
            }
            case ADS: {
                set = sessionData.isGuest() ? sessionData.getConfiguration().getVisibleAdGroups() : this.getAccessibleBasicGroups(bl);
                break;
            }
            case USERS: {
                set = this.getSearchOnGroups(bl);
                break;
            }
            case DIRECTORY: {
                set = this.getUserDirectoryOnGroups();
                break;
            }
            case MENU: {
                Set<BasicGroup> set2 = set = sessionData.isGuest() ? this.getSearchOnGroups(bl) : this.getSearchMenuOnGroups(bl);
            }
        }
        if (set == null) {
            throw new IllegalArgumentException("Unknown group list: " + String.valueOf(groupList));
        }
        return set;
    }

    private Set<BasicGroup> doGetDefaultGroupFilter(Set<? extends BasicGroup> set, BasicGroup basicGroup, ProductsAccessor productsAccessor, boolean bl) {
        boolean bl2 = basicGroup instanceof AdminGroup;
        if (bl2) {
            Set<BasicGroup> set2 = set != null ? set : this.getAccessibleBasicGroups(false);
            this.filterOutAdminGroups(set2);
            return bl ? this.normalizeBasicGroups(set2) : set2;
        }
        List list = productsAccessor.member().getGroupFilterDefault();
        if (CollectionHelper.isEmpty((Iterable)list) || list.contains(GroupFilterDefault.ALL)) {
            Set<BasicGroup> set3 = set != null ? set : this.getAccessibleBasicGroups(false);
            return bl ? this.normalizeBasicGroups(set3) : set3;
        }
        HashSet<BasicGroup> hashSet = new HashSet<BasicGroup>();
        if (!(basicGroup instanceof GroupSet) && list.contains(GroupFilterDefault.OWN_GROUP)) {
            hashSet.add(basicGroup);
        }
        if (list.contains(GroupFilterDefault.OWN_GROUP_SET)) {
            GroupSet groupSet = basicGroup instanceof UserGroup ? ((UserGroup)basicGroup).getGroupSet() : null;
            hashSet.add((BasicGroup)(groupSet == null ? basicGroup : groupSet));
        }
        if (list.contains(GroupFilterDefault.SPECIFIC)) {
            hashSet.addAll(productsAccessor.member().getDefaultFilterGroups());
        }
        return bl ? this.normalizeBasicGroups(hashSet) : hashSet;
    }

    private void filterOutAdminGroups(Collection<? extends BasicGroup> collection) {
        collection.removeIf(AdminGroup.class::isInstance);
    }

    private Set<BasicGroup> getAccessibleBasicGroups(boolean bl) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            HashSet<BasicGroup> hashSet = new HashSet<BasicGroup>();
            for (BasicGroup basicGroup : sessionData.getAccessibleBasicGroups()) {
                if (basicGroup instanceof Group) {
                    Group group = (Group)basicGroup;
                    if (!group.isEnabled()) continue;
                    hashSet.add((BasicGroup)group);
                    continue;
                }
                hashSet.add(basicGroup);
            }
            return hashSet;
        }
        return this.getAccessibleBasicGroups(bl, (BasicGroup)sessionData.getGroup(), sessionData.getProducts());
    }

    private Set<Group> getAccessibleGroups() {
        return this.doGetAccessibleGroups(false, null, null);
    }

    private Set<BasicGroup> getAllAccessibleBasicGroups() {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return sessionData.getAccessibleBasicGroups();
        }
        return this.doGetAccessibleBasicGroups(true, sessionData.isAdmin(), (BasicGroup)sessionData.getGroup(), sessionData.getProducts());
    }

    private GroupListViewFactoryImpl getBasicGroups(GroupList groupList, boolean bl) {
        Set<BasicGroup> set = this.doGetBasicGroups(groupList, bl);
        return GroupListViewFactoryImpl.of(this, bl, false, set);
    }

    private Set<BasicGroup> getSearchMenuOnGroups(boolean bl) {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        if (sessionData.isSystem()) {
            return new HashSet<BasicGroup>(sessionData.getAccessibleBasicGroups());
        }
        UserSearchInMenuMode userSearchInMenuMode = configurationAccessor.getUserSearchInMenuMode();
        switch (userSearchInMenuMode) {
            case ALL_IN_USER_SEARCH: 
            case SPECIFIC_GROUPS: {
                Set set;
                Set set2 = set = this.getSearchOnGroups(bl);
                if (userSearchInMenuMode == UserSearchInMenuMode.SPECIFIC_GROUPS) {
                    set2 = configurationAccessor.getGroupsForUserSearchInMenu();
                    set2.retainAll(set);
                }
                return set2;
            }
            case NONE: {
                return Collections.emptySet();
            }
        }
        throw new IllegalArgumentException("Unknow user search in menu mode: " + String.valueOf(userSearchInMenuMode));
    }

    private Set<BasicGroup> getSearchOnGroups(boolean bl) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            return sessionData.getConfiguration().getGroupsForUserSearch();
        }
        if (sessionData.isSystem()) {
            return new HashSet<BasicGroup>(sessionData.getAccessibleBasicGroups());
        }
        return this.getSearchOnGroups(bl, (BasicGroup)sessionData.getGroup(), sessionData.getProducts());
    }

    private Set<BasicGroup> getUserDirectoryOnGroups() {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            return sessionData.getConfiguration().getGroupsForUserDirectory();
        }
        if (sessionData.isSystem()) {
            return new HashSet<BasicGroup>(sessionData.getAccessibleBasicGroups());
        }
        return this.getUserDirectoryOnGroups((BasicGroup)sessionData.getGroup(), sessionData.getProducts());
    }

    private GroupListViewFactoryImpl getVisible(GroupList groupList, boolean bl) {
        GroupVisibility groupVisibility = this.getGroupVisibility(bl);
        if (groupVisibility == GroupVisibility.NONE) {
            return GroupListViewFactoryImpl.empty(this);
        }
        Set<BasicGroup> set = this.doGetBasicGroups(groupList, bl);
        return GroupListViewFactoryImpl.of(this, bl, false, GroupsHandlerImpl.applyVisibility(groupVisibility, set), groupVisibility);
    }

    private <T> Set<T> normalizeBasicGroups(Collection<T> collection) {
        HashSet hashSet = new HashSet();
        Function<Object, Object> function = object -> {
            if (object instanceof UserGroup) {
                return ((UserGroup)object).getGroupSet();
            }
            if (object instanceof UserGroupVO) {
                return ((UserGroupVO)object).getGroupSet();
            }
            return null;
        };
        collection.stream().filter(object -> object instanceof GroupSetVO || object instanceof GroupSet).forEach(hashSet::add);
        collection.stream().filter(object -> {
            Object r = function.apply(object);
            return r == null || !hashSet.contains(r);
        }).forEach(hashSet::add);
        return hashSet;
    }

    private Set<? extends BasicGroup> rawGetAccessibleBasicGroups(BasicGroup basicGroup, ProductsAccessor productsAccessor) {
        Long l = SimpleEntity.id((SimpleEntity)basicGroup);
        if (l == null) {
            return this.getSessionData().getAccessibleBasicGroups();
        }
        Long l2 = SimpleEntity.id((SimpleEntity)basicGroup.getNetwork());
        Set set = SimpleEntity.uniqueIds((Collection)productsAccessor.getProducts());
        GroupsCacheKey groupsCacheKey = new GroupsCacheKey(l2, l, set);
        CollectionAccessorCacheValue collectionAccessorCacheValue = (CollectionAccessorCacheValue)this.cache.get((Serializable)groupsCacheKey, () -> {
            Object object;
            AdminGroupAccessibility adminGroupAccessibility = (AdminGroupAccessibility)ObjectHelper.defaultValue((Object)productsAccessor.admin().getAdminGroupAccessibility(), (Object)AdminGroupAccessibility.NONE);
            HashSet<Object> hashSet = new HashSet<Object>();
            switch (adminGroupAccessibility) {
                case NONE: {
                    break;
                }
                case ALL: {
                    object = QAdminGroup.adminGroup;
                    hashSet.addAll(this.entityManagerHandler.selectFrom((EntityPath)object).fetch());
                    break;
                }
                case SPECIFIC: {
                    hashSet.addAll(productsAccessor.admin().getAccessibleAdminGroups());
                }
            }
            object = productsAccessor.product().getUserGroupAccessibility();
            if (object.contains(UserGroupAccessibility.ALL)) {
                QBasicGroup qBasicGroup = QBasicGroup.basicGroup;
                hashSet.addAll(((DBQuery)this.entityManagerHandler.selectFrom((EntityPath)qBasicGroup).where((Predicate)qBasicGroup.nature.ne((Object)BasicGroupNature.ADMIN_GROUP))).fetch());
            } else {
                if (basicGroup instanceof Group && (object.contains(UserGroupAccessibility.OWN_GROUP) || object.contains(UserGroupAccessibility.OWN_GROUP_SET)) || basicGroup instanceof GroupSet && object.contains(UserGroupAccessibility.OWN_GROUP_SET)) {
                    hashSet.add(basicGroup);
                }
                if (object.contains(UserGroupAccessibility.OWN_GROUP_SET)) {
                    if (basicGroup instanceof UserGroup) {
                        GroupSet groupSet = ((UserGroup)basicGroup).getGroupSet();
                        if (groupSet != null) {
                            hashSet.add(groupSet);
                        }
                    } else if (basicGroup instanceof GroupSet) {
                        hashSet.add(basicGroup);
                    }
                }
                if (object.contains(UserGroupAccessibility.SPECIFIC)) {
                    hashSet.addAll(productsAccessor.product().getAccessibleUserGroups());
                }
            }
            return AccessorCacheValue.create(hashSet);
        });
        return (Set)collectionAccessorCacheValue.unwrap(this.getApplicationContext());
    }

    private Set<BasicGroup> resolveGroupsForMember(BasicGroup basicGroup, ProductsAccessor productsAccessor, Collection<UserGroupAccessibility> collection, Collection<BasicGroup> collection2) {
        Set set;
        Set set2 = this.doGetAccessibleBasicGroups(true, false, basicGroup, productsAccessor);
        if (collection.contains(UserGroupAccessibility.ALL)) {
            set = set2;
        } else {
            HashSet<Object> hashSet = new HashSet<Object>();
            if (basicGroup instanceof Group && (collection.contains(UserGroupAccessibility.OWN_GROUP) || collection.contains(UserGroupAccessibility.OWN_GROUP_SET)) || basicGroup instanceof GroupSet && collection.contains(UserGroupAccessibility.OWN_GROUP_SET)) {
                hashSet.add(basicGroup);
            }
            if (collection.contains(UserGroupAccessibility.OWN_GROUP_SET)) {
                GroupSet groupSet;
                GroupSet groupSet2 = groupSet = basicGroup instanceof UserGroup ? ((UserGroup)basicGroup).getGroupSet() : null;
                if (groupSet != null) {
                    hashSet.add(groupSet);
                }
            }
            if (collection.contains(UserGroupAccessibility.SPECIFIC)) {
                hashSet.addAll(collection2);
            }
            set = GroupsHandler.doFlatten(hashSet, (boolean)false, (boolean)true);
            set.retainAll(set2);
        }
        this.filterOutAdminGroups(set);
        return set;
    }

    static {
        VO_MAPPINGS.put(GroupSet.class, GroupSetVO.class);
        VO_MAPPINGS.put(AdminGroup.class, AdminGroupVO.class);
        VO_MAPPINGS.put(UserGroup.class, UserGroupVO.class);
        VO_MAPPINGS.put(BrokerGroup.class, GroupVO.class);
    }

    private static class GroupComparator
    implements Comparator<BasicGroupVO> {
        private static final GroupComparator INSTANCE = new GroupComparator();

        private GroupComparator() {
        }

        @Override
        public int compare(BasicGroupVO basicGroupVO, BasicGroupVO basicGroupVO2) {
            boolean bl;
            if (basicGroupVO.equals((Object)basicGroupVO2)) {
                return 0;
            }
            boolean bl2 = basicGroupVO instanceof GroupVO;
            boolean bl3 = basicGroupVO2 instanceof GroupVO;
            GroupSetVO groupSetVO = basicGroupVO instanceof UserGroupVO ? ((UserGroupVO)basicGroupVO).getGroupSet() : null;
            GroupSetVO groupSetVO2 = basicGroupVO2 instanceof UserGroupVO ? ((UserGroupVO)basicGroupVO2).getGroupSet() : null;
            boolean bl4 = bl2 && groupSetVO == null;
            boolean bl5 = bl = bl3 && groupSetVO2 == null;
            if (bl4 && !bl) {
                return -1;
            }
            if (bl && !bl4) {
                return 1;
            }
            if (bl4 && bl) {
                return this.compareNames(basicGroupVO, basicGroupVO2);
            }
            if (!bl2 && !bl3 || groupSetVO != null && groupSetVO.equals((Object)groupSetVO2)) {
                return this.compareNames(basicGroupVO, basicGroupVO2);
            }
            if (basicGroupVO.equals((Object)groupSetVO2)) {
                return -1;
            }
            if (basicGroupVO2.equals((Object)groupSetVO)) {
                return 1;
            }
            if (bl2 && bl3) {
                return this.compareNames((BasicGroupVO)groupSetVO, (BasicGroupVO)groupSetVO2);
            }
            if (!bl2) {
                return this.compareNames(basicGroupVO, (BasicGroupVO)groupSetVO2);
            }
            return this.compareNames((BasicGroupVO)groupSetVO, basicGroupVO2);
        }

        private int compareNames(BasicGroupVO basicGroupVO, BasicGroupVO basicGroupVO2) {
            String string = basicGroupVO == null ? null : basicGroupVO.getName();
            String string2 = basicGroupVO2 == null ? null : basicGroupVO2.getName();
            return string == null ? 0 : string.compareTo(string2);
        }
    }

    private class CustomGroupListViewFactoryImpl
    implements GroupListViewFactory {
        private Collection<? extends BasicGroup> basicGroups;

        private CustomGroupListViewFactoryImpl(Collection<? extends BasicGroup> collection) {
            this.basicGroups = collection;
        }

        public GroupListView<AdminGroup, AdminGroupVO> admins() {
            return GroupListView.of((GroupsHandlerInternal)GroupsHandlerImpl.this, this.basicGroups.stream().filter(AdminGroup.class::isInstance).collect(Collectors.toSet()));
        }

        public GroupListView<BasicGroup, BasicGroupVO> basic() {
            return GroupListView.of((GroupsHandlerInternal)GroupsHandlerImpl.this, (Set)((Set)this.basicGroups));
        }

        public GroupListView<BasicGroup, BasicGroupVO> basicUsers() {
            return GroupListView.of((GroupsHandlerInternal)GroupsHandlerImpl.this, this.basicGroups.stream().filter(basicGroup -> !(basicGroup instanceof AdminGroup)).collect(Collectors.toSet()));
        }

        public GroupListView<BrokerGroup, GroupVO> brokers() {
            return GroupListView.of((GroupsHandlerInternal)GroupsHandlerImpl.this, this.basicGroups.stream().filter(BrokerGroup.class::isInstance).collect(Collectors.toSet()));
        }

        public GroupListView<Group, GroupVO> groups() {
            return GroupListView.of((GroupsHandlerInternal)GroupsHandlerImpl.this, this.basicGroups.stream().filter(basicGroup -> !(basicGroup instanceof GroupSet)).collect(Collectors.toSet()));
        }

        public GroupListView<GroupSet, GroupSetVO> groupSets() {
            return GroupListView.of((GroupsHandlerInternal)GroupsHandlerImpl.this, this.basicGroups.stream().filter(GroupSet.class::isInstance).collect(Collectors.toSet()));
        }

        public GroupListViewFactory includeGlobals() {
            return this;
        }

        public boolean isEmpty() {
            return this.basicGroups.isEmpty();
        }

        public GroupListView<UserGroup, UserGroupVO> users() {
            return GroupListView.of((GroupsHandlerInternal)GroupsHandlerImpl.this, this.basicGroups.stream().filter(UserGroup.class::isInstance).collect(Collectors.toSet()));
        }
    }

    private class VisibleGroupListViewFactoryAccessorImpl
    implements GroupListViewFactoryAccessor {
        private VisibleGroupListViewFactoryAccessorImpl() {
        }

        public GroupListViewFactory accessibles() {
            return GroupsHandlerImpl.this.getVisible(GroupList.ACCESSIBLE, true);
        }

        public GroupListViewFactory ads() {
            return GroupsHandlerImpl.this.getVisible(GroupList.ADS, true);
        }

        public GroupListViewFactory directory() {
            return GroupsHandlerImpl.this.getVisible(GroupList.DIRECTORY, false);
        }

        public GroupListViewFactory menu() {
            return GroupsHandlerImpl.this.getVisible(GroupList.MENU, true);
        }

        public GroupListViewFactory users() {
            return GroupsHandlerImpl.this.getVisible(GroupList.USERS, true);
        }
    }
}

