/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import org.cyclos.entities.users.BulkAction;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.users.BulkActionServiceLocal;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BulkActionProcessingBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private BulkActionServiceLocal bulkActionService;

    public static BackgroundTaskScheduling scheduling(BulkAction bulkAction) {
        return new BackgroundTaskScheduling(BulkActionProcessingBackgroundTask.class, (Object)bulkAction.getId(), "Process bulk action " + String.valueOf(bulkAction.getNature()) + " with id " + bulkAction.getId());
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.PROCESS_BULK_ACTION;
    }

    public BackgroundTaskPriority getPriority() {
        return BackgroundTaskPriority.LOW;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        boolean bl;
        long l = Long.parseLong(string);
        long l2 = 0L;
        do {
            if (bl = this.bulkActionService.processNext(Long.valueOf(l))) continue;
            ++l2;
        } while (bl);
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            BulkAction bulkAction = (BulkAction)this.rawEntityManagerHandler.find(BulkAction.class, Long.valueOf(l));
            this.bulkActionService.markFinished(bulkAction);
            return null;
        });
        return l2;
    }
}

