/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.marketplace.QAdAddress;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.QGeoLocatedAddress;
import org.cyclos.entities.users.QUserAddress;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.users.GoogleMapsGeocoder;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddressLocatingRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private GoogleMapsGeocoder geocoder;
    @Autowired
    private ConfigurationHandler configurationHandler;

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.ADDRESS_LOCATING;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        List<Long> list;
        List<Long> list2 = this.findMapEnabledConfigurations();
        if (list2.isEmpty()) {
            return 0L;
        }
        long l = 0L;
        while (!(list = this.nextBatch(list2)).isEmpty()) {
            for (Long l2 : list) {
                try {
                    GoogleMapsGeocoder.LocalizationStatus localizationStatus = this.geocode(l2);
                    switch (localizationStatus) {
                        case SUCCESS: {
                            ++l;
                            break;
                        }
                        case FAILED: {
                            this.markAsGeocodeFailed(l2);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    this.logTaskError(null, exception);
                }
            }
        }
        return l;
    }

    protected List<Long> findMapEnabledConfigurations() {
        return (List)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> this.selectFrom(QConfiguration.configuration).stream().map(arg_0 -> ((ConfigurationHandler)this.configurationHandler).getAccessor(arg_0)).filter(configurationAccessor -> configurationAccessor.getMapServerApiKey() != null && configurationAccessor.isUseMap()).map(configurationAccessor -> configurationAccessor.getConfiguration().getId()).collect(Collectors.toList()));
    }

    protected GoogleMapsGeocoder.LocalizationStatus geocode(Long l) {
        return (GoogleMapsGeocoder.LocalizationStatus)((Object)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.geocoder.geocode(this.find(GeoLocatedAddress.class, l))));
    }

    @Override
    protected boolean isRunInTransaction() {
        return false;
    }

    protected void markAsGeocodeFailed(Long l) {
        SessionData sessionData = SessionDataFactory.system();
        this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
            QGeoLocatedAddress qGeoLocatedAddress = QGeoLocatedAddress.geoLocatedAddress;
            return this.rawEntityManagerHandler.update((EntityPath)qGeoLocatedAddress).set((Path)qGeoLocatedAddress.geocodeFailed, (Object)true).where(new Predicate[]{qGeoLocatedAddress.id.eq((Object)l)}).execute();
        });
    }

    protected List<Long> nextBatch(List<Long> list) {
        SessionData sessionData = SessionDataFactory.system();
        return (List)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_ONLY, transactionStatus -> {
            QUserAddress qUserAddress = QUserAddress.userAddress;
            List list2 = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserAddress}).where(new Predicate[]{qUserAddress.user().group().configurationId.in((Collection)list), qUserAddress.location().latitude.isNull().or((Predicate)qUserAddress.location().longitude.isNull()), qUserAddress.geocodeFailed.isNull().or((Predicate)qUserAddress.geocodeFailed.isFalse()), qUserAddress.addressLine1.isNotNull().or((Predicate)qUserAddress.street.isNotNull()).and((Predicate)qUserAddress.city.isNotNull().or((Predicate)qUserAddress.zip.isNotNull()))})).limit(500L)).list((Expression)qUserAddress.id);
            if (list2.isEmpty()) {
                QAdAddress qAdAddress = QAdAddress.adAddress;
                list2 = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qAdAddress}).where(new Predicate[]{qAdAddress.ad().owner().group().configurationId.in((Collection)list), qAdAddress.location().latitude.isNull().or((Predicate)qAdAddress.location().longitude.isNull()), qAdAddress.geocodeFailed.isNull().or((Predicate)qAdAddress.geocodeFailed.isFalse()), qAdAddress.addressLine1.isNotNull().or((Predicate)qAdAddress.street.isNotNull()).and((Predicate)qAdAddress.city.isNotNull().or((Predicate)qAdAddress.zip.isNotNull()))})).limit(500L)).list((Expression)qAdAddress.id);
            }
            return list2;
        });
    }
}

