/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrencyAmount;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.banking.VoucherTypeImage;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.banking.VoucherTransactionsVisibility;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.vouchers.VoucherCreationType;
import org.cyclos.model.banking.vouchers.VoucherPinStatusForRedeem;
import org.cyclos.security.banking.VoucherServiceSecurity;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.cyclos.utils.WeekDay;

public class VoucherReportEntry
implements HasCurrencyAmount,
ProcessableForProxying {
    private Voucher voucher;
    private VoucherPack pack;
    private VoucherConfiguration configuration;
    private Map<VoucherCustomField, Object> packCustomValues;
    private Map<VoucherCustomField, Object> voucherCustomValues;
    private VoucherServiceLocal voucherService;
    private VoucherServiceSecurity voucherServiceSecurity;
    private String plainToken;

    public VoucherReportEntry() {
    }

    public VoucherReportEntry(Voucher voucher, Map<VoucherCustomField, Object> map, Map<VoucherCustomField, Object> map2) {
        this.voucher = voucher;
        this.pack = voucher.getPack();
        this.configuration = voucher.getConfiguration();
        this.packCustomValues = map;
        this.voucherCustomValues = map2;
        this.voucherService = (VoucherServiceLocal)InvocationContext.bean(VoucherServiceLocal.class);
        this.voucherServiceSecurity = (VoucherServiceSecurity)InvocationContext.bean(VoucherServiceSecurity.class);
        if (this.configuration.isShowPlainToken()) {
            this.plainToken = MaskHelper.applyMask((String)this.configuration.getMask(), (String)voucher.getToken());
        }
    }

    public BigDecimal getAmount() {
        return (BigDecimal)ObjectHelper.defaultValue((Object)this.voucher.getAmount(), (Object)this.voucher.getPack().getAmount());
    }

    public BigDecimal getBalance() {
        if (this.getTransactionsVisibility() == VoucherTransactionsVisibility.NONE) {
            return null;
        }
        return this.voucher.getBalance();
    }

    public CurrencyAmount getBalanceCurrencyAmount() {
        return this.voucher.getBalanceCurrencyAmount();
    }

    public User getBuyer() {
        return this.voucher.getPack().getBuyer();
    }

    public VoucherConfiguration getConfiguration() {
        return this.getType().getConfiguration();
    }

    public Date getCreationDate() {
        return this.pack.getCreationDate();
    }

    public Currency getCurrency() {
        return this.voucher.getCurrency();
    }

    public CurrencyAmount getCurrencyAmount() {
        return super.getCurrencyAmount();
    }

    public String getDescription() {
        return StringHelper.convertNewLineToBr((String)this.voucher.getType().getDescription());
    }

    public String getEmail() {
        return this.voucher.getEmail();
    }

    public Date getExpirationDate() {
        return (Date)ObjectHelper.defaultValue((Object)this.voucher.getExpirationDate(), (Object)this.pack.getExpirationDate());
    }

    public VoucherTypeImage getImage() {
        return this.getType().getImage();
    }

    public User getIssuer() {
        if (this.pack.isSent()) {
            return this.pack.getBuyer();
        }
        return null;
    }

    public String getMobilePhone() {
        if (this.voucher.getMobilePhone() == null) {
            return null;
        }
        return this.voucherService.formatMobilePhone(this.voucher);
    }

    public User getOwner() {
        return this.voucher.getOwner();
    }

    public VoucherPack getPack() {
        return this.pack;
    }

    public Map<VoucherCustomField, Object> getPackCustomValues() {
        return this.packCustomValues;
    }

    public String getPin() {
        return this.getPack().isSent() ? null : this.voucher.getPin();
    }

    public VoucherPinStatusForRedeem getPinStatus() {
        VoucherPinStatusForRedeem voucherPinStatusForRedeem = this.voucher.getPinStatusForRedeem();
        return voucherPinStatusForRedeem == VoucherPinStatusForRedeem.NOT_USED ? null : voucherPinStatusForRedeem;
    }

    public String getPlainToken() {
        return this.plainToken;
    }

    public String getPrintMessage() {
        InvocationContext invocationContext = InvocationContext.get();
        FormatterImpl formatterImpl = invocationContext.formatter(null);
        LinkGeneratorHandler linkGeneratorHandler = (LinkGeneratorHandler)invocationContext.applicationContext().getBean(LinkGeneratorHandler.class);
        Object object = "";
        String string = StringHelper.trimToNull((Object)this.getType().getDescription());
        if (string != null) {
            object = string + "<br><br><br>";
        }
        if (this.plainToken != null) {
            object = (String)object + formatterImpl.format(new TranslationMessageSpecification(MessageFormat.HTML, this.voucher.isBlockedGift() ? BankingKeys.Vouchers.PRINT_MESSAGE_ACTIVATE_GIFT : BankingKeys.Vouchers.PRINT_MESSAGE_CHECK_BALANCE, new Object[]{linkGeneratorHandler.voucherInfo(), this.plainToken})) + "<br><br>";
        }
        object = (String)object + formatterImpl.format(new TranslationMessageSpecification(BankingKeys.Vouchers.PRINT_MESSAGE_FOOTER));
        return object;
    }

    public Date getRedeemAfterDate() {
        if (this.pack.getRedeemAfterDate() != null && this.pack.getRedeemAfterDate().after(new Date())) {
            return this.pack.getRedeemAfterDate();
        }
        return null;
    }

    public Object getRedeemOnWeekDays() {
        EnumSet<WeekDay> enumSet = EnumSet.noneOf(WeekDay.class);
        enumSet.addAll(this.pack.getRedeemOnWeekDays());
        if (enumSet.isEmpty() || enumSet.size() == 7) {
            return BankingKeys.Vouchers.REDEEM_ON_WEEK_DAYS_ANY;
        }
        return enumSet;
    }

    public String getSendMessage() {
        return this.getPack().getSendMessage();
    }

    public String getTitle() {
        return this.getType().getVoucherTitle();
    }

    public String getToken() {
        return this.voucher.getToken();
    }

    public VoucherTransactionsVisibility getTransactionsVisibility() {
        return this.voucherServiceSecurity.getTransactionVisibility(this.voucher);
    }

    public VoucherType getType() {
        return this.getPack().getType();
    }

    public Voucher getVoucher() {
        return this.voucher;
    }

    public Map<VoucherCustomField, Object> getVoucherCustomValues() {
        return this.voucherCustomValues;
    }

    public boolean isPersonal() {
        return this.getPack().getCreationType() == VoucherCreationType.BOUGHT && !Boolean.TRUE.equals(this.getPack().getGift());
    }

    public boolean isShowQrCode() {
        return this.voucherService.showQrCode(this.voucher);
    }

    public void setConfiguration(VoucherConfiguration voucherConfiguration) {
        this.configuration = voucherConfiguration;
    }

    public void setPack(VoucherPack voucherPack) {
        this.pack = voucherPack;
    }

    public void setPackCustomValues(Map<VoucherCustomField, Object> map) {
        this.packCustomValues = map;
    }

    public void setVoucher(Voucher voucher) {
        this.voucher = voucher;
    }

    public void setVoucherCustomValues(Map<VoucherCustomField, Object> map) {
        this.voucherCustomValues = map;
    }
}

