/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.QVoucherType;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.VoucherRedeem;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DateRange;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHistoryEntry;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.system.ExportHandler;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.utils.BeanAccessor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.formatting.DataTranslationProxy;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.Property;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.tokens.TokenQuery;
import org.cyclos.model.access.tokens.TokenVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransSearchContext;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceVO;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.BaseInstallmentQuery;
import org.cyclos.model.banking.transactions.BaseTransactionQuery;
import org.cyclos.model.banking.transactions.ExternalPaymentVO;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentResultVO;
import org.cyclos.model.banking.transactions.InstallmentVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentVO;
import org.cyclos.model.banking.transactions.TransOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.vouchers.VoucherData;
import org.cyclos.model.banking.vouchers.VoucherPackVO;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogVO;
import org.cyclos.model.system.entitylogs.EntityPropertyLogFieldQualifier;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.model.system.entitylogs.EntityPropertyLogVO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.imports.UserImportField;
import org.cyclos.model.system.operations.PageResultColumn;
import org.cyclos.model.system.operations.PageResultColumnType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.UserRecordVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.GroupVisibility;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.WeekDay;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class TabularExportHandlerImpl
extends BaseNetworkedHandlerImpl
implements ExportHandler {
    @Autowired
    @Lazy
    private VoucherServiceLocal voucherService;
    @Autowired
    @Lazy
    protected TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    @Lazy
    private VoucherCustomFieldServiceLocal voucherCustomFieldService;
    @Autowired
    @Lazy
    protected AccountServiceLocal accountService;
    @Autowired
    @Lazy
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    @Lazy
    private LoginServiceLocal loginService;

    private static String columnName(CustomField<?, ?, ?> customField) {
        return "field." + customField.getInternalName();
    }

    private static String columnName(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            return ((BasicProfileField)profileField).getAlias();
        }
        return TabularExportHandlerImpl.columnName((CustomField)profileField);
    }

    public SerializableInputStream export(ExportHandler.ExportParameters exportParameters) {
        List<Column> list;
        switch (exportParameters.getContext()) {
            case ACCOUNT_HISTORY: {
                list = this.accountHistory(exportParameters);
                break;
            }
            case TRANSFERS_OVERVIEW: {
                list = this.transfersOverview(exportParameters);
                break;
            }
            case BALANCE_LIMITS_OVERVIEW: {
                list = this.balanceLimits(exportParameters);
                break;
            }
            case PAYMENT_AMOUNT_LIMITS_OVERVIEW: {
                list = this.paymentAmountLimits(exportParameters);
                break;
            }
            case RECORDS_OVERVIEW: 
            case RECORDS_SEARCH: 
            case SHARED_FIELDS_RECORDS_SEARCH: {
                list = this.records(exportParameters);
                break;
            }
            case TRANSACTIONS_OVERVIEW: 
            case TRANSACTIONS_SEARCH: {
                list = this.transactions(exportParameters);
                break;
            }
            case INSTALLMENTS_OVERVIEW: 
            case INSTALLMENTS_SEARCH: {
                list = this.installments(exportParameters);
                break;
            }
            case USERS_SEARCH: {
                list = this.users(exportParameters);
                break;
            }
            case USERS_WITH_BALANCES: {
                list = this.usersWithBalances(exportParameters);
                break;
            }
            case VOUCHERS_SEARCH: {
                list = this.vouchers(exportParameters);
                break;
            }
            case TOKENS_SEARCH: {
                list = this.tokens(exportParameters);
                break;
            }
            case CUSTOM_OPERATION: {
                list = this.customOperation(exportParameters);
                break;
            }
            case ENTITY_LOGS: {
                list = this.entityLogs(exportParameters);
                break;
            }
            default: {
                list = null;
            }
        }
        if (list == null) {
            throw new IllegalStateException("Unsupported " + String.valueOf(this.getBuiltInFormat()) + " export: " + String.valueOf(exportParameters.getContext()));
        }
        exportParameters.setEntities(this.dataTranslationProxy(exportParameters.getEntities()));
        return this.build(exportParameters, list);
    }

    protected abstract SerializableInputStream build(ExportHandler.ExportParameters var1, List<Column> var2);

    private Object accountData(Account account) {
        if (account instanceof SystemAccount) {
            return account.getType();
        }
        if (account instanceof UserAccount) {
            return ((UserAccount)account).getUser();
        }
        return null;
    }

    private List<Column> accountHistory(ExportHandler.ExportParameters exportParameters) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        AccountHistoryQuery accountHistoryQuery = (AccountHistoryQuery)exportParameters.getQueryParameters();
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        List list = this.accountService.getVisibleFlows(account);
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.DATE, (Property<?, ?>)AccountHistoryEntryVO.DATE));
        if (account.getCurrency().isTransactionNumberEnabled()) {
            arrayList.add(new PropertyColumn(BankingKeys.Transactions.TRANSACTION_NUMBER, (Property<?, ?>)AccountHistoryEntryVO.TRANSACTION_NUMBER));
        }
        arrayList.add(this.custom(ColumnType.STRING, "owner", BankingKeys.Accounts.FROM_OR_TO, (? accountHistoryEntry) -> {
            Account account = accountHistoryEntry.getRelatedAccount();
            if (account instanceof SystemAccount) {
                return account.getType();
            }
            return account.getOwner();
        }));
        if (this.getSessionData().isAdmin()) {
            arrayList.add(this.custom(ColumnType.STRING, "ownerGroup", BankingKeys.Accounts.FROM_OR_TO_GROUP, (? accountHistoryEntry) -> this.userGroupData(accountHistoryEntry.getRelatedAccount())));
        }
        arrayList.add(this.custom(ColumnType.STRING, "by", BankingKeys.Transactions.BY, (? accountHistoryEntry) -> accountHistoryEntry.getTransaction() == null ? null : accountHistoryEntry.getTransaction().getBy()));
        arrayList.add(this.custom(ColumnType.STRING, "receivedBy", BankingKeys.Transactions.RECEIVED_BY, (? accountHistoryEntry) -> accountHistoryEntry.getTransaction() instanceof BasePayment ? ((BasePayment)accountHistoryEntry.getTransaction()).getReceivedBy() : null));
        if (account.getNumber() != null) {
            arrayList.add(this.custom(ColumnType.STRING, "account", BankingKeys.Accounts.ACCOUNT_NUMBER, (? accountHistoryEntry) -> this.accountHandler.getAccountNumber((IAccount)accountHistoryEntry.getRelatedAccount())));
        }
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.TYPE, (Property<?, ?>)TransferVO.TYPE));
        arrayList.add(new PropertyColumn(GeneralKeys.Ui.DESCRIPTION, (Property<?, ?>)AccountHistoryEntryVO.DESCRIPTION));
        this.transactionCustomFieldService.listVisibleForList((AbstractTransQuery)accountHistoryQuery).stream().map(customField -> new CustomFieldColumn((CustomField<?, ?, ?>)customField)).forEach(arrayList::add);
        list.stream().map(transferStatusFlow -> new TransferStatusColumn((TransferStatusFlow)transferStatusFlow)).forEach(arrayList::add);
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, AccountHistoryEntryVO.AMOUNT.getName(), BankingKeys.Transactions.AMOUNT, (? accountHistoryEntry) -> accountHistoryEntry.getCurrencyAmount()));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.CURRENCY, (Property<?, ?>)AccountWithCurrencyVO.CURRENCY));
        return arrayList;
    }

    private List<Column> balanceLimits(ExportHandler.ExportParameters exportParameters) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.LIMIT_OVERVIEW_OWNER, (Property<?, ?>)AccountVO.OWNER));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.LIMIT_OVERVIEW_ACCOUNT_TYPE, (Property<?, ?>)AccountVO.TYPE));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.CURRENCY, (Property<?, ?>)AccountWithCurrencyVO.CURRENCY));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "lowerLimit", BankingKeys.Accounts.ACCOUNT_BALANCE_LIMITS_OVERVIEW_MAX_NEGATIVE, (? userAccount) -> {
            if (userAccount.isCreditLimitFromProduct()) {
                return BankingKeys.Accounts.LIMIT_OVERVIEW_FROM_PRODUCTS;
            }
            return new CurrencyAmount(userAccount.getCurrency(), userAccount.getCreditLimit().negate());
        }));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "upperLimit", BankingKeys.Accounts.ACCOUNT_BALANCE_LIMITS_OVERVIEW_MAX_POSITIVE, (? userAccount) -> {
            if (userAccount.isUpperCreditLimitFromProduct()) {
                return BankingKeys.Accounts.LIMIT_OVERVIEW_FROM_PRODUCTS;
            }
            if (userAccount.getUpperCreditLimit() == null) {
                return BankingKeys.Accounts.LIMIT_MODE_UNLIMITED;
            }
            return new CurrencyAmount(userAccount.getCurrency(), userAccount.getUpperCreditLimit());
        }));
        return arrayList;
    }

    private String columnHeading(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            return this.message(((BasicProfileField)profileField).getMessageKey(), new Object[0]);
        }
        return this.getTranslatedName((NamedEntity)((UserCustomField)profileField));
    }

    private CustomColumn custom(ColumnType columnType, String string, MessageKey messageKey, Function<?, ?> function) {
        return new CustomColumn(columnType, string, messageKey, function);
    }

    private CustomColumn custom(ColumnType columnType, String string, String string2, Function<?, ?> function) {
        return new CustomColumn(columnType, string, string2, function);
    }

    private CustomColumn custom(Property<?, ?> property, MessageKey messageKey, Function<?, ?> function) {
        return new CustomColumn(property, messageKey, function);
    }

    private List<Column> customOperation(ExportHandler.ExportParameters exportParameters) {
        List list = (List)exportParameters.getAdditionalData("columns");
        ArrayList<Column> arrayList = new ArrayList<Column>(list.size() + 1);
        for (PageResultColumn pageResultColumn : list) {
            arrayList.add(new CustomOperationColumn(pageResultColumn));
            if (pageResultColumn.getType() != PageResultColumnType.CURRENCY_AMOUNT) continue;
            String string = this.message(SystemKeys.Operations.CURRENCY_COLUMN, pageResultColumn.getHeader());
            arrayList.add(new CustomColumn(ColumnType.CURRENCY, string, string, object -> {
                Object object2 = this.getCustomOperationValue(object, pageResultColumn);
                CurrencyAmount currencyAmount = this.getCustomOperationCurrencyAmountValue(object2);
                Currency currency = currencyAmount == null ? null : currencyAmount.getCurrency();
                return currency == null ? "" : currency.getSymbol();
            }));
        }
        return arrayList;
    }

    private List<Column> entityLogs(ExportHandler.ExportParameters exportParameters) {
        boolean bl = this.getSessionData().getNetwork() == null && ((EntityPropertyLogQuery)exportParameters.getQueryParameters()).getNetwork() == null;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new PropertyColumn("date", SystemKeys.EntityLogs.DATE, (Property<?, ?>)NestedProperty.nested((Property)EntityPropertyLogVO.ENTITY_LOG, (Property)EntityLogVO.DATE)));
        arrayList.add(new PropertyColumn("by", SystemKeys.EntityLogs.BY, (Property<?, ?>)NestedProperty.nested((Property)EntityPropertyLogVO.ENTITY_LOG, (Property)EntityLogVO.BY)));
        arrayList.add(new PropertyColumn("type", SystemKeys.EntityLogs.TYPE, (Property<?, ?>)NestedProperty.nested((Property)EntityPropertyLogVO.ENTITY_LOG, (Property)EntityLogVO.TYPE)));
        arrayList.add(this.custom(ColumnType.STRING, "field", SystemKeys.EntityLogs.FIELD, (? entityPropertyLog) -> {
            EntityLog entityLog = entityPropertyLog.getEntityLog();
            String string = bl && entityLog.getNetwork() != null ? entityLog.getNetwork().getName() : null;
            return EntityPropertyLogFieldQualifier.NETWORK.qualify(string, entityLog.getNamePrefix(), entityLog.getName(), entityPropertyLog.getName());
        }));
        arrayList.add(this.custom(ColumnType.STRING, "oldValue", SystemKeys.EntityLogs.OLD_VALUE, (? entityPropertyLog) -> {
            if (entityPropertyLog.getEntityLog().getEvent() == EntityLogEvent.CREATE) {
                return this.message(SystemKeys.EntityLogs.NOT_APPLICABLE, new Object[0]);
            }
            return entityPropertyLog.getOldValue();
        }));
        arrayList.add(this.custom(ColumnType.STRING, "newValue", SystemKeys.EntityLogs.NEW_VALUE, (? entityPropertyLog) -> {
            if (entityPropertyLog.getEntityLog().getEvent() == EntityLogEvent.CREATE) {
                return this.message(SystemKeys.EntityLogs.NOT_APPLICABLE, new Object[0]);
            }
            if (entityPropertyLog.getEntityLog().getEvent() == EntityLogEvent.DELETE) {
                return this.message(SystemKeys.EntityLogs.DELETED, new Object[0]);
            }
            return entityPropertyLog.getNewValue();
        }));
        return arrayList;
    }

    private CurrencyAmount getCustomOperationCurrencyAmountValue(Object object) {
        Object object2;
        BigDecimal bigDecimal = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)object);
        if (object instanceof Map) {
            object2 = ((Map)object).get("currency");
        } else {
            try {
                object2 = InvocationContext.wrap((Object)object).getPropertyValue("currency");
            }
            catch (Exception exception) {
                object2 = null;
            }
        }
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, object2);
        if (currency == null) {
            currency = new Currency();
        }
        return new CurrencyAmount(currency, bigDecimal);
    }

    private Object getCustomOperationValue(Object object, PageResultColumn pageResultColumn) {
        if (object instanceof List) {
            return ((List)object).get(pageResultColumn.getIndex());
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[pageResultColumn.getIndex()];
        }
        return BeanAccessor.instance().get(object, pageResultColumn.getProperty());
    }

    private Object getImportFieldValue(User user, UserImportField userImportField) {
        switch (userImportField) {
            case CREATION_DATE: {
                return user.getCreationDate();
            }
            case NAME: {
                return user.getName();
            }
            case USERNAME: {
                return user.getUsername();
            }
            case EMAIL: {
                return user.getEmail();
            }
            case ADDRESS_PRIVATE: 
            case ADDRESS_NAME: 
            case ADDRESS_CITY: 
            case ADDRESS_COUNTRY: 
            case ADDRESS_LINE1: 
            case ADDRESS_LINE2: 
            case ADDRESS_NEIGHBORHOOD: 
            case ADDRESS_POBOX: 
            case ADDRESS_REGION: 
            case ADDRESS_ZIP: 
            case ADDRESS_BUILDING_NUMBER: 
            case ADDRESS_COMPLEMENT: 
            case ADDRESS_STREET: {
                UserAddress userAddress = user.getDefaultAddress();
                if (userAddress == null) {
                    return null;
                }
                if (userImportField == UserImportField.ADDRESS_NAME) {
                    return userAddress.getName();
                }
                if (userImportField == UserImportField.ADDRESS_PRIVATE) {
                    return userAddress.isHidden();
                }
                return AddressHelper.getValue((AddressFields)userImportField.getAddressField(), (IAddress)userAddress);
            }
            case LANDLINE_PRIVATE: 
            case LANDLINE_NAME: 
            case LANDLINE_NUMBER: {
                LandLinePhone landLinePhone = user.getPreferredLandLinePhone();
                if (landLinePhone == null) {
                    return null;
                }
                if (userImportField == UserImportField.LANDLINE_NAME) {
                    return landLinePhone.getName();
                }
                if (userImportField == UserImportField.LANDLINE_NUMBER) {
                    return landLinePhone.getNormalizedNumber();
                }
                if (userImportField == UserImportField.LANDLINE_PRIVATE) {
                    return landLinePhone.isHidden();
                }
            }
            case MOBILE_PRIVATE: 
            case MOBILE_NAME: 
            case MOBILE_NUMBER: {
                MobilePhone mobilePhone = user.getPreferredMobilePhone();
                if (mobilePhone == null) {
                    return null;
                }
                if (userImportField == UserImportField.MOBILE_NAME) {
                    return mobilePhone.getName();
                }
                if (userImportField == UserImportField.MOBILE_NUMBER) {
                    return mobilePhone.getNormalizedNumber();
                }
                if (userImportField == UserImportField.MOBILE_PRIVATE) {
                    return mobilePhone.isHidden();
                }
            }
            case BROKER: {
                return user.getMainBroker();
            }
            case ACCOUNT_NUMBER: {
                return this.profileFieldHandler.getFieldValue((BasicUser)user, (ProfileField)BasicProfileField.ACCOUNT_NUMBER);
            }
        }
        return null;
    }

    private List<Column> installments(ExportHandler.ExportParameters exportParameters) {
        BaseInstallmentQuery baseInstallmentQuery = (BaseInstallmentQuery)exportParameters.getQueryParameters();
        InternalAccountOwner internalAccountOwner = baseInstallmentQuery instanceof InstallmentQuery ? ((InstallmentQuery)baseInstallmentQuery).getOwner() : null;
        TransSearchContext transSearchContext = this.transactionCustomFieldService.resolveTransSearchContext((AbstractTransQuery)baseInstallmentQuery);
        Predicate<Installment> predicate = installment -> installment.getTransaction().isDebit(internalAccountOwner);
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.INSTALLMENT_DATE, (Property<?, ?>)InstallmentVO.DUE_DATE));
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.TRANSACTION_NUMBER, (Property<?, ?>)NestedProperty.nested((Property)InstallmentResultVO.TRANSACTION, (Property)TransactionVO.TRANSACTION_NUMBER)));
        arrayList.add(this.custom(ColumnType.STRING, "scheduling", BankingKeys.Transactions.INSTALLMENT_NUMBER, this::scheduling));
        if (internalAccountOwner == null) {
            arrayList.add(this.custom(ColumnType.STRING, "fromOwner", BankingKeys.Accounts.FROM, (? installment) -> this.accountData(installment.getTransaction().getFrom())));
            if (this.getSessionData().isAdmin()) {
                arrayList.add(this.custom(ColumnType.STRING, "fromOwnerGroup", BankingKeys.Accounts.FROM_GROUP, (? installment) -> this.userGroupData(installment.getTransaction().getFrom())));
            }
            arrayList.add(this.custom(ColumnType.STRING, "fromAccount", BankingKeys.Transactions.FROM_ACCOUNT, (? installment) -> this.accountHandler.getAccountNumber((IAccount)installment.getTransaction().getFrom())));
            if (transSearchContext.isOverview()) {
                arrayList.add(this.custom(ColumnType.STRING, "by", BankingKeys.Transactions.BY, (? installment) -> installment.getTransaction() == null ? null : installment.getTransaction().getBy()));
            }
            arrayList.add(this.custom(ColumnType.STRING, "toOwner", BankingKeys.Accounts.TO, (? installment) -> this.accountData(installment.getTransaction().getTo())));
            if (this.getSessionData().isAdmin()) {
                arrayList.add(this.custom(ColumnType.STRING, "toOwnerGroup", BankingKeys.Accounts.TO_GROUP, (? installment) -> this.userGroupData(installment.getTransaction().getTo())));
            }
            arrayList.add(this.custom(ColumnType.STRING, "toAccount", BankingKeys.Transactions.TO_ACCOUNT, (? installment) -> this.accountHandler.getAccountNumber((IAccount)installment.getTransaction().getTo())));
            if (transSearchContext.isOverview()) {
                arrayList.add(this.custom(ColumnType.STRING, "receivedBy", BankingKeys.Transactions.RECEIVED_BY, (? installment) -> installment.getTransaction() instanceof BasePayment ? ((BasePayment)installment.getTransaction()).getReceivedBy() : null));
            }
        } else {
            arrayList.add(this.custom(ColumnType.STRING, "owner", BankingKeys.Accounts.FROM_OR_TO, (? installment) -> this.accountData(installment.getTransaction().getRelatedAccount(internalAccountOwner))));
            if (this.getSessionData().isAdmin()) {
                arrayList.add(this.custom(ColumnType.STRING, "ownerGroup", BankingKeys.Accounts.FROM_OR_TO_GROUP, (? installment) -> this.userGroupData(installment.getTransaction().getRelatedAccount(internalAccountOwner))));
            }
            if (transSearchContext.isOverview()) {
                arrayList.add(this.custom(ColumnType.STRING, "by", BankingKeys.Transactions.BY, (? installment) -> installment.getTransaction() == null ? null : installment.getTransaction().getBy()));
                arrayList.add(this.custom(ColumnType.STRING, "receivedBy", BankingKeys.Transactions.RECEIVED_BY, (? installment) -> installment.getTransaction() instanceof BasePayment ? ((BasePayment)installment.getTransaction()).getReceivedBy() : null));
            }
            arrayList.add(this.custom(ColumnType.STRING, "account", BankingKeys.Accounts.ACCOUNT_NUMBER, (? installment) -> this.accountHandler.getAccountNumber((IAccount)installment.getTransaction().getRelatedAccount(internalAccountOwner))));
        }
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.STATUS, (Property<?, ?>)ScheduledPaymentVO.STATUS));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, AccountHistoryEntryVO.AMOUNT.getName(), BankingKeys.Transactions.AMOUNT, (? installment) -> {
            BigDecimal bigDecimal = installment.getAmount();
            return new CurrencyAmount(installment.getCurrency(), predicate.test((Installment)installment) ? bigDecimal.negate() : bigDecimal);
        }));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.CURRENCY, (Property<?, ?>)AccountWithCurrencyVO.CURRENCY));
        this.resolveCustomFields((AbstractTransQuery)baseInstallmentQuery, transSearchContext, internalAccountOwner).stream().map(customField -> new TransactionCustomFieldColumn((CustomField<?, ?, ?>)customField)).forEach(arrayList::add);
        return arrayList;
    }

    private List<Column> paymentAmountLimits(ExportHandler.ExportParameters exportParameters) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.LIMIT_OVERVIEW_OWNER, (Property<?, ?>)AccountVO.OWNER));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.LIMIT_OVERVIEW_ACCOUNT_TYPE, (Property<?, ?>)AccountVO.TYPE));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.CURRENCY, (Property<?, ?>)AccountWithCurrencyVO.CURRENCY));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "paymentLimit", BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_OVERVIEW_HEADING_RESULTS, (? userAccount) -> {
            if (userAccount.isPaymentAmountLimitFromProduct()) {
                return BankingKeys.Accounts.LIMIT_OVERVIEW_FROM_PRODUCTS;
            }
            return new CurrencyAmount(userAccount.getCurrency(), userAccount.getPaymentAmountLimit());
        }));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "dailyLimit", BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_OVERVIEW_PER_DAY_HEADING_RESULTS, (? userAccount) -> {
            if (userAccount.isPaymentAmountPerDayLimitFromProduct()) {
                return BankingKeys.Accounts.LIMIT_OVERVIEW_FROM_PRODUCTS;
            }
            return new CurrencyAmount(userAccount.getCurrency(), userAccount.getPaymentAmountPerDayLimit());
        }));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "weeklyLimit", BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_OVERVIEW_PER_WEEK_HEADING_RESULTS, (? userAccount) -> {
            if (userAccount.isPaymentAmountPerWeekLimitFromProduct()) {
                return BankingKeys.Accounts.LIMIT_OVERVIEW_FROM_PRODUCTS;
            }
            return new CurrencyAmount(userAccount.getCurrency(), userAccount.getPaymentAmountPerWeekLimit());
        }));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "monthlyLimit", BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_OVERVIEW_PER_MONTH_HEADING_RESULTS, (? userAccount) -> {
            if (userAccount.isPaymentAmountPerMonthLimitFromProduct()) {
                return BankingKeys.Accounts.LIMIT_OVERVIEW_FROM_PRODUCTS;
            }
            return new CurrencyAmount(userAccount.getCurrency(), userAccount.getPaymentAmountPerMonthLimit());
        }));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "yearlyLimit", BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_OVERVIEW_PER_YEAR_HEADING_RESULTS, (? userAccount) -> {
            if (userAccount.isPaymentAmountPerYearLimitFromProduct()) {
                return BankingKeys.Accounts.LIMIT_OVERVIEW_FROM_PRODUCTS;
            }
            return new CurrencyAmount(userAccount.getCurrency(), userAccount.getPaymentAmountPerYearLimit());
        }));
        return arrayList;
    }

    private List<Column> records(ExportHandler.ExportParameters exportParameters) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        RecordQuery recordQuery = (RecordQuery)exportParameters.getQueryParameters();
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordQuery.getType());
        boolean bl = !(recordType instanceof SystemRecordType);
        arrayList.add(new PropertyColumn(UsersKeys.Records.CREATED_BY, (Property<?, ?>)RecordVO.CREATED_BY));
        arrayList.add(new PropertyColumn(UsersKeys.Records.CREATION_DATE, (Property<?, ?>)RecordVO.CREATION_DATE));
        arrayList.add(new PropertyColumn(UsersKeys.Records.MODIFIED_BY, (Property<?, ?>)RecordVO.MODIFIED_BY));
        arrayList.add(new PropertyColumn(UsersKeys.Records.LAST_MODIFIED_DATE, (Property<?, ?>)RecordVO.LAST_MODIFIED_DATE));
        arrayList.add(new PropertyColumn(UsersKeys.Records.TYPE, (Property<?, ?>)RecordVO.TYPE));
        if (bl) {
            arrayList.add(new PropertyColumn(UsersKeys.Records.USER, (Property<?, ?>)UserRecordVO.USER));
            arrayList.add(this.custom(ColumnType.STRING, TabularExportHandlerImpl.columnName((ProfileField)BasicProfileField.LOGIN_NAME), this.columnHeading((ProfileField)BasicProfileField.LOGIN_NAME), (? object) -> ((UserRecord)object).getUser().getUsername()));
        }
        List list = this.recordFieldHandler.getAllVisibleCustomFieldsForQuery(recordQuery);
        list.stream().map(customField -> new CustomFieldColumn((CustomField<?, ?, ?>)customField)).forEach(arrayList::add);
        return arrayList;
    }

    private List<TransactionCustomField> resolveCustomFields(AbstractTransQuery abstractTransQuery, TransSearchContext transSearchContext, InternalAccountOwner internalAccountOwner) {
        if (transSearchContext.isOverview()) {
            TransOverviewQuery transOverviewQuery = (TransOverviewQuery)abstractTransQuery;
            List list = this.transactionCustomFieldService.listVisible((AccountOwner)internalAccountOwner);
            list.removeIf(transactionCustomField -> transactionCustomField.getType().isBinary());
            if (QueryHelper.useAnyParameter(Arrays.asList(abstractTransQuery.getTransferTypes(), transOverviewQuery.getCurrencies(), transOverviewQuery.getFromAccounts(), transOverviewQuery.getToAccounts(), abstractTransQuery.getTransferFilters()))) {
                Collection<Object> collection;
                QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
                DBQuery<?> dBQuery = this.from(new EntityPath[]{qPaymentTransferType});
                if (QueryHelper.useParameter((Object)abstractTransQuery.getTransferTypes())) {
                    collection = this.conversionHandler.convertList(TransferType.class, (Iterable)abstractTransQuery.getTransferTypes()).stream().filter(PaymentTransferType.class::isInstance).map(transferType -> (PaymentTransferType)transferType).collect(Collectors.toList());
                    dBQuery.where((com.querydsl.core.types.Predicate)qPaymentTransferType.in(collection));
                }
                if (QueryHelper.useParameter((Object)transOverviewQuery.getCurrencies())) {
                    dBQuery.where((com.querydsl.core.types.Predicate)qPaymentTransferType.from().currency().in((Collection)this.conversionHandler.convertList(Currency.class, (Iterable)transOverviewQuery.getCurrencies())));
                }
                if (QueryHelper.useParameter((Object)transOverviewQuery.getFromAccounts())) {
                    dBQuery.where((com.querydsl.core.types.Predicate)qPaymentTransferType.from().in((Collection)this.conversionHandler.convertList(AccountType.class, (Iterable)transOverviewQuery.getFromAccounts())));
                }
                if (QueryHelper.useParameter((Object)transOverviewQuery.getToAccounts())) {
                    dBQuery.where((com.querydsl.core.types.Predicate)qPaymentTransferType.to().in((Collection)this.conversionHandler.convertList(AccountType.class, (Iterable)transOverviewQuery.getToAccounts())));
                }
                if (QueryHelper.useParameter((Object)abstractTransQuery.getTransferFilters())) {
                    collection = new HashSet();
                    this.conversionHandler.convertList(TransferFilter.class, (Iterable)abstractTransQuery.getTransferFilters()).stream().flatMap(transferFilter -> transferFilter.getTransferTypes().stream()).filter(PaymentTransferType.class::isInstance).map(transferType -> (PaymentTransferType)transferType).forEach(paymentTransferType -> collection.add(paymentTransferType));
                    dBQuery.where((com.querydsl.core.types.Predicate)qPaymentTransferType.in(collection));
                }
                collection = new HashSet();
                dBQuery.fetch().stream().forEach(paymentTransferType -> collection.addAll(paymentTransferType.getCustomFields()));
                list.removeIf(transactionCustomField -> !collection.contains(transactionCustomField));
            }
            return list;
        }
        return this.transactionCustomFieldService.listVisibleForList((AccountOwner)internalAccountOwner, transSearchContext);
    }

    private String scheduling(Object object) {
        String string = "";
        if (object instanceof TransactionWithInstallments) {
            TransactionWithInstallments transactionWithInstallments = (TransactionWithInstallments)object;
            return transactionWithInstallments.getScheduling();
        }
        if (object instanceof Installment) {
            Installment installment = (Installment)object;
            TransactionWithInstallments transactionWithInstallments = (TransactionWithInstallments)installment.getTransaction();
            return transactionWithInstallments.getScheduling(installment.getNumber());
        }
        return string;
    }

    private List<Column> tokens(ExportHandler.ExportParameters exportParameters) {
        TokenQuery tokenQuery = (TokenQuery)exportParameters.getQueryParameters();
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenQuery.getType());
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new PropertyColumn(AccessKeys.Tokens.USER, (Property<?, ?>)TokenVO.USER));
        arrayList.add(new PropertyColumn(AccessKeys.Tokens.VALUE, (Property<?, ?>)TokenVO.VALUE));
        arrayList.add(new PropertyColumn(AccessKeys.Tokens.CREATION_DATE, (Property<?, ?>)TokenVO.CREATION_DATE));
        arrayList.add(new PropertyColumn(AccessKeys.Tokens.ACTIVATION_DATE, (Property<?, ?>)TokenVO.ACTIVATION_DATE));
        if (tokenPrincipalType == null || tokenPrincipalType.getActivation() != null) {
            arrayList.add(new PropertyColumn(AccessKeys.Tokens.ACTIVATION_DEADLINE, (Property<?, ?>)TokenVO.ACTIVATION_DEADLINE));
        }
        arrayList.add(new PropertyColumn(AccessKeys.Tokens.EXPIRY_DATE, (Property<?, ?>)TokenVO.EXPIRY_DATE));
        arrayList.add(new PropertyColumn(AccessKeys.Tokens.STATUS, (Property<?, ?>)TokenVO.STATUS));
        return arrayList;
    }

    private List<Column> transactions(ExportHandler.ExportParameters exportParameters) {
        BaseTransactionQuery baseTransactionQuery = (BaseTransactionQuery)exportParameters.getQueryParameters();
        InternalAccountOwner internalAccountOwner = baseTransactionQuery instanceof TransactionQuery ? ((TransactionQuery)baseTransactionQuery).getOwner() : null;
        TransSearchContext transSearchContext = this.transactionCustomFieldService.resolveTransSearchContext((AbstractTransQuery)baseTransactionQuery);
        Predicate<Transaction> predicate = transaction -> transaction.isDebit(internalAccountOwner);
        Set set = CollectionHelper.orEmpty((Set)baseTransactionQuery.getNatures());
        boolean bl = Boolean.TRUE.equals(baseTransactionQuery.getAuthorized());
        boolean bl2 = bl || set.isEmpty() || set.stream().anyMatch(TransactionNature::hasStatus);
        boolean bl3 = set.isEmpty() || set.contains(TransactionNature.SCHEDULED_PAYMENT);
        boolean bl4 = set.isEmpty() || set.contains(TransactionNature.RECURRING_PAYMENT);
        boolean bl5 = set.size() == 1 && set.contains(TransactionNature.EXTERNAL_PAYMENT);
        boolean bl6 = set.size() == 1 && set.contains(TransactionNature.TICKET);
        boolean bl7 = set.size() == 1 && set.contains(TransactionNature.PAYMENT_REQUEST);
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.DATE, (Property<?, ?>)TransactionVO.DATE));
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.TRANSACTION_NUMBER, (Property<?, ?>)TransactionVO.TRANSACTION_NUMBER));
        if (internalAccountOwner == null) {
            arrayList.add(this.custom(ColumnType.STRING, "fromOwner", BankingKeys.Accounts.FROM, (? transaction) -> this.accountData(transaction.getFrom())));
            if (this.getSessionData().isAdmin()) {
                arrayList.add(this.custom(ColumnType.STRING, "fromOwnerGroup", BankingKeys.Accounts.FROM_GROUP, (? transaction) -> this.userGroupData(transaction.getFrom())));
            }
            arrayList.add(this.custom(ColumnType.STRING, "fromAccount", BankingKeys.Transactions.FROM_ACCOUNT, (? transaction) -> this.accountHandler.getAccountNumber((IAccount)transaction.getFrom())));
            if (transSearchContext.isOverview()) {
                arrayList.add(this.custom(ColumnType.STRING, "by", BankingKeys.Transactions.BY, (? transaction) -> transaction.getBy()));
            }
            if (!bl5) {
                arrayList.add(this.custom(ColumnType.STRING, "toOwner", BankingKeys.Accounts.TO, (? transaction) -> this.accountData(transaction.getTo())));
                if (this.getSessionData().isAdmin()) {
                    arrayList.add(this.custom(ColumnType.STRING, "toOwnerGroup", BankingKeys.Accounts.TO_GROUP, (? transaction) -> this.userGroupData(transaction.getTo())));
                }
                arrayList.add(this.custom(ColumnType.STRING, "toAccount", BankingKeys.Transactions.TO_ACCOUNT, (? transaction) -> this.accountHandler.getAccountNumber((IAccount)transaction.getTo())));
                if (transSearchContext.isOverview()) {
                    arrayList.add(this.custom(ColumnType.STRING, "receivedBy", BankingKeys.Transactions.RECEIVED_BY, (? transaction) -> transaction instanceof BasePayment ? ((BasePayment)transaction).getReceivedBy() : null));
                }
            }
        } else if (bl6) {
            arrayList.add(this.custom(ColumnType.STRING, "fromOwner", BankingKeys.Accounts.FROM, (? transaction) -> this.accountData(transaction.getFrom())));
            if (this.getSessionData().isAdmin()) {
                arrayList.add(this.custom(ColumnType.STRING, "fromOwnerGroup", BankingKeys.Accounts.FROM_GROUP, (? transaction) -> this.userGroupData(transaction.getFrom())));
            }
        } else if (bl5) {
            arrayList.add(new PropertyColumn(BankingKeys.Transactions.TO_PRINCIPAL_VALUE, (Property<?, ?>)ExternalPaymentVO.TO_PRINCIPAL_VALUE));
            if (transSearchContext.isOverview()) {
                arrayList.add(this.custom(ColumnType.STRING, "by", BankingKeys.Transactions.BY, (? transaction) -> transaction.getBy()));
            }
        } else {
            arrayList.add(this.custom(ColumnType.STRING, "owner", bl7 ? BankingKeys.Transactions.SENDER_OR_RECEIVER : BankingKeys.Accounts.FROM_OR_TO, (? transaction) -> this.accountData(transaction.getRelatedAccount(internalAccountOwner))));
            if (this.getSessionData().isAdmin()) {
                arrayList.add(this.custom(ColumnType.STRING, "ownerGroup", bl7 ? BankingKeys.Transactions.SENDER_OR_RECEIVER_GROUP : BankingKeys.Accounts.FROM_OR_TO_GROUP, (? transaction) -> this.userGroupData(transaction.getRelatedAccount(internalAccountOwner))));
            }
            if (transSearchContext.isOverview()) {
                arrayList.add(this.custom(ColumnType.STRING, "by", BankingKeys.Transactions.BY, (? transaction) -> transaction.getBy()));
                arrayList.add(this.custom(ColumnType.STRING, "receivedBy", BankingKeys.Transactions.RECEIVED_BY, (? transaction) -> transaction instanceof BasePayment ? ((BasePayment)transaction).getReceivedBy() : null));
            }
            arrayList.add(this.custom(ColumnType.STRING, "account", BankingKeys.Accounts.ACCOUNT_NUMBER, (? transaction) -> this.accountHandler.getAccountNumber((IAccount)transaction.getRelatedAccount(internalAccountOwner))));
        }
        arrayList.add(this.custom((Property<?, ?>)TransactionVO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION, this::transDescription));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.TRANSFER_TYPE, (Property<?, ?>)TransactionVO.TYPE));
        if (bl2) {
            arrayList.add(new PropertyColumn(BankingKeys.Transactions.STATUS, (Property<?, ?>)ScheduledPaymentVO.STATUS));
        }
        if (bl3 || bl4) {
            MessageKey messageKey = !bl4 ? BankingKeys.Transactions.INSTALLMENTS : BankingKeys.Transactions.SCHEDULING;
            arrayList.add(this.custom(ColumnType.STRING, "scheduling", messageKey, this::scheduling));
        }
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, AccountHistoryEntryVO.AMOUNT.getName(), BankingKeys.Transactions.AMOUNT, (? transaction) -> {
            BigDecimal bigDecimal = transaction.getAmount();
            return new CurrencyAmount(transaction.getCurrency(), predicate.test((Transaction)transaction) ? bigDecimal.negate() : bigDecimal);
        }));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.CURRENCY, (Property<?, ?>)AccountWithCurrencyVO.CURRENCY));
        this.resolveCustomFields((AbstractTransQuery)baseTransactionQuery, transSearchContext, internalAccountOwner).stream().map(customField -> new TransactionCustomFieldColumn((CustomField<?, ?, ?>)customField)).forEach(arrayList::add);
        return arrayList;
    }

    private String transDescription(Object object) {
        Object object2;
        Transaction transaction = null;
        TransferType transferType = null;
        if (object instanceof Transaction) {
            transaction = (Transaction)object;
            transferType = transaction.getType();
        } else if (object instanceof Transfer) {
            object2 = (Transfer)object;
            transaction = object2.getTransaction();
            transferType = object2.getType();
        } else if (object instanceof AccountHistoryEntry) {
            object2 = (AccountHistoryEntry)object;
            transaction = object2.getTransaction();
            transferType = object2.getType();
        }
        String string = object2 = transaction == null ? null : transaction.getDescription();
        if (StringHelper.isBlank((Object)object2) && transferType != null) {
            object2 = this.getTranslatedValue((BaseEntity)transferType, QTransferType.transferType.valueForEmptyDescription);
        }
        return object2;
    }

    private List<Column> transfersOverview(ExportHandler.ExportParameters exportParameters) {
        Function<Account, Object> function = account -> account.getNature() == AccountTypeNature.SYSTEM ? account.getType() : account.getOwner();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.DATE, (Property<?, ?>)TransferVO.DATE));
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.TRANSACTION_NUMBER, (Property<?, ?>)TransferVO.TRANSACTION_NUMBER));
        arrayList.add(this.custom(ColumnType.STRING, "fromOwner", BankingKeys.Accounts.FROM, (? transfer) -> function.apply(BigDecimalHelper.isNegative((BigDecimal)transfer.getAmount()) ? transfer.getTo() : transfer.getFrom())));
        if (this.getSessionData().isAdmin()) {
            arrayList.add(this.custom(ColumnType.STRING, "fromOwnerGroup", BankingKeys.Accounts.FROM_GROUP, (? transfer) -> this.userGroupData(BigDecimalHelper.isNegative((BigDecimal)transfer.getAmount()) ? transfer.getTo() : transfer.getFrom())));
        }
        arrayList.add(this.custom(ColumnType.STRING, "fromAccount", BankingKeys.Transactions.FROM_ACCOUNT, (? transfer) -> this.accountHandler.getAccountNumber((IAccount)(BigDecimalHelper.isNegative((BigDecimal)transfer.getAmount()) ? transfer.getTo() : transfer.getFrom()))));
        arrayList.add(this.custom(ColumnType.STRING, "by", BankingKeys.Transactions.BY, (? transfer) -> transfer.getTransaction() == null ? null : transfer.getTransaction().getBy()));
        arrayList.add(this.custom(ColumnType.STRING, "toOwner", BankingKeys.Accounts.TO, (? transfer) -> function.apply(BigDecimalHelper.isNegative((BigDecimal)transfer.getAmount()) ? transfer.getFrom() : transfer.getTo())));
        if (this.getSessionData().isAdmin()) {
            arrayList.add(this.custom(ColumnType.STRING, "toOwnerGroup", BankingKeys.Accounts.TO_GROUP, (? transfer) -> this.userGroupData(BigDecimalHelper.isNegative((BigDecimal)transfer.getAmount()) ? transfer.getFrom() : transfer.getTo())));
        }
        arrayList.add(this.custom(ColumnType.STRING, "toAccount", BankingKeys.Transactions.TO_ACCOUNT, (? transfer) -> this.accountHandler.getAccountNumber((IAccount)(BigDecimalHelper.isNegative((BigDecimal)transfer.getAmount()) ? transfer.getFrom() : transfer.getTo()))));
        arrayList.add(this.custom(ColumnType.STRING, "receivedBy", BankingKeys.Transactions.RECEIVED_BY, (? transfer) -> transfer.getTransaction() instanceof BasePayment ? ((BasePayment)transfer.getTransaction()).getReceivedBy() : null));
        arrayList.add(new PropertyColumn(BankingKeys.Transactions.TYPE, (Property<?, ?>)TransferVO.TYPE));
        arrayList.add(this.custom((Property<?, ?>)AccountHistoryEntryVO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION, this::transDescription));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "amount", BankingKeys.Transactions.AMOUNT, (? transfer) -> new CurrencyAmount(transfer.getCurrency(), transfer.getAmount().abs())));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.CURRENCY, (Property<?, ?>)AccountWithCurrencyVO.CURRENCY));
        this.resolveCustomFields((AbstractTransQuery)exportParameters.getQueryParameters(), TransSearchContext.TRANSFERS_OVERVIEW, null).stream().map(customField -> new TransactionCustomFieldColumn((CustomField<?, ?, ?>)customField)).forEach(arrayList::add);
        return arrayList;
    }

    private UserGroup userGroupData(Account account) {
        return account instanceof UserAccount ? (UserGroup)((UserAccount)account).getUser().getGroup() : null;
    }

    private List<Column> users(ExportHandler.ExportParameters exportParameters) {
        Object object;
        ProductsAccessor productsAccessor = this.getProducts();
        List list = this.profileFieldHandler.getMatchingFields(productsAccessor.product().getUserProfileFields(), QProductUserProfileField.productUserProfileField.visible);
        list.removeIf(profileField -> {
            if (profileField instanceof UserCustomField) {
                return !((UserCustomField)profileField).isIncludeInExport();
            }
            return false;
        });
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (UserImportField userImportField : UserImportField.values()) {
            if (!userImportField.isExported() || (object = userImportField.getProfileField()) != null && !list.contains(object)) continue;
            arrayList.add(this.custom(ColumnType.from(userImportField), userImportField.getName(), userImportField.getMessageKey(), (? user) -> this.getImportFieldValue((User)user, userImportField)));
        }
        this.profileFieldHandler.getCustomFields((Collection)list).stream().map(customField -> new CustomFieldColumn((CustomField<?, ?, ?>)customField)).forEach(arrayList::add);
        if (this.groupsHandler.getGroupVisibility(true) == GroupVisibility.GROUP) {
            arrayList.add(new PropertyColumn(UsersKeys.Users.GROUP, (Property<?, ?>)UserDTO.GROUP));
        }
        arrayList.add(new PropertyColumn(ColumnType.STRING, UsersKeys.Users.STATUS, QUser.user.status));
        AccountNumberConfiguration accountNumberConfiguration = this.getConfiguration().getAccountNumberConfiguration();
        List list2 = productsAccessor.userManagement().isIncludeBalancesInExportUsersCSV() ? productsAccessor.userManagement().getUserAccountsAccess() : Collections.emptyList();
        for (UserImportField userImportField : list2) {
            object = this.getTranslatedName((NamedEntity)userImportField);
            arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, (String)ObjectHelper.defaultValue((Object)userImportField.getInternalName(), (Object)object), (String)object, arg_0 -> this.lambda$users$77((UserAccountType)userImportField, arg_0)));
            if (!accountNumberConfiguration.isEnabled()) continue;
            String string = "." + UserImportField.ACCOUNT_NUMBER.getSimpleName();
            String string2 = "." + this.message(UserImportField.ACCOUNT_NUMBER.getMessageKey(), new Object[0]);
            arrayList.add(this.custom(ColumnType.STRING, (String)ObjectHelper.defaultValue((Object)userImportField.getInternalName(), (Object)object) + string, (String)object + string2, arg_0 -> this.lambda$users$78((UserAccountType)userImportField, accountNumberConfiguration, arg_0)));
        }
        MutableObject mutableObject = new MutableObject();
        arrayList.add(this.custom(ColumnType.DATE, "lastLogin", UsersKeys.Users.USER_LAST_LOGIN, (? user) -> {
            DateRange dateRange = this.loginService.getFirstAndLastLogin((BasicUser)user);
            mutableObject.setValue((Object)dateRange);
            return dateRange == null ? null : dateRange.getMax();
        }));
        arrayList.add(this.custom(ColumnType.DATE, "firstLogin", UsersKeys.Users.USER_FIRST_LOGIN, (? user) -> {
            DateRange dateRange = (DateRange)mutableObject.getValue();
            return dateRange == null ? null : dateRange.getMin();
        }));
        return arrayList;
    }

    private List<Column> usersWithBalances(ExportHandler.ExportParameters exportParameters) {
        UserWithBalanceQuery userWithBalanceQuery = (UserWithBalanceQuery)exportParameters.getQueryParameters();
        AccountType accountType = (AccountType)this.conversionHandler.convert(AccountType.class, (Object)userWithBalanceQuery.getAccountType());
        Currency currency = accountType.getCurrency();
        List list = (List)exportParameters.getAdditionalData("profileFields");
        ArrayList<Column> arrayList = new ArrayList<Column>();
        if (CollectionHelper.isEmpty((Iterable)list)) {
            arrayList.add(new PropertyColumn(UsersKeys.Users.USER, (Property<?, ?>)UserWithBalanceVO.DISPLAY));
            arrayList.add(new PropertyColumn(BankingKeys.Accounts.ACCOUNT_NUMBER, (Property<?, ?>)UserWithBalanceVO.ACCOUNT_NUMBER));
        } else {
            list.stream().map(profileField -> new ProfileFieldColumn((ProfileField)profileField)).forEach(arrayList::add);
        }
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.NEGATIVE_SINCE, (Property<?, ?>)UserWithBalanceVO.NEGATIVE_SINCE));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "balance", BankingKeys.Accounts.BALANCE, (? userWithBalanceVO) -> new CurrencyAmount(currency, userWithBalanceVO.getBalance())));
        arrayList.add(this.custom((Property<?, ?>)AccountWithCurrencyVO.CURRENCY, BankingKeys.Accounts.CURRENCY, userWithBalanceVO -> currency));
        return arrayList;
    }

    private List<Column> vouchers(ExportHandler.ExportParameters exportParameters) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(this.custom((Property<?, ?>)VoucherVO.TOKEN, BankingKeys.Vouchers.TOKEN, voucher -> this.voucherService.formatToken(voucher)));
        arrayList.add(new PropertyColumn(BankingKeys.Vouchers.STATUS, (Property<?, ?>)VoucherVO.STATUS));
        arrayList.add(new PropertyColumn(BankingKeys.Accounts.CURRENCY, (Property<?, ?>)AccountWithCurrencyVO.CURRENCY));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "amount", BankingKeys.Vouchers.AMOUNT, (? voucher) -> voucher.getCurrencyAmount()));
        arrayList.add(this.custom(ColumnType.CURRENCY_AMOUNT, "balance", BankingKeys.Vouchers.BALANCE, (? voucher) -> voucher.getBalanceCurrencyAmount()));
        arrayList.add(this.custom((Property<?, ?>)VoucherPackVO.BUYER, BankingKeys.Vouchers.BUYER, voucher -> voucher.getPack().getBuyer()));
        arrayList.add(new PropertyColumn(BankingKeys.Vouchers.OWNER, (Property<?, ?>)VoucherVO.OWNER));
        arrayList.add(this.custom((Property<?, ?>)VoucherData.PIN, BankingKeys.Vouchers.PIN, voucher -> this.voucherService.showPinOnDetails(voucher) ? voucher.getPin() : null));
        arrayList.add(this.custom(ColumnType.STRING, "sentToEmail", BankingKeys.Vouchers.SENT_TO_EMAIL, (? voucher) -> voucher.getPack().getSentToEmail()));
        arrayList.add(this.custom((Property<?, ?>)VoucherPackVO.CREATION_DATE, BankingKeys.Vouchers.CREATION_DATE, voucher -> voucher.getPack().getCreationDate()));
        arrayList.add(this.custom((Property<?, ?>)VoucherVO.EXPIRATION_DATE, BankingKeys.Vouchers.EXPIRATION_DATE, voucher -> ObjectHelper.defaultValue((Object)voucher.getExpirationDate(), (Object)voucher.getPack().getExpirationDate())));
        arrayList.add(this.custom((Property<?, ?>)VoucherVO.REDEEM_DATE, BankingKeys.Vouchers.REDEEM_DATE, voucher -> {
            VoucherRedeem voucherRedeem = voucher.getSingleRedeem();
            return voucherRedeem == null ? null : voucherRedeem.getDate();
        }));
        arrayList.add(this.custom((Property<?, ?>)VoucherVO.REDEEM_BY, BankingKeys.Vouchers.REDEEM_BY, voucher -> {
            VoucherRedeem voucherRedeem = voucher.getSingleRedeem();
            return voucherRedeem == null ? null : voucherRedeem.getUser();
        }));
        arrayList.add(this.custom((Property<?, ?>)TransactionVO.TRANSACTION_NUMBER, BankingKeys.Transactions.TRANSACTION_NUMBER, voucher -> {
            if (!voucher.getType().isAllowPartialRedeems() && voucher.getStatus() == VoucherStatus.REDEEMED) {
                VoucherTransaction voucherTransaction = (VoucherTransaction)CollectionHelper.first((Iterable)voucher.getTransactions());
                return voucherTransaction.getTransaction().getTransactionNumber();
            }
            return null;
        }));
        arrayList.add(this.custom(ColumnType.STRING, "title", BankingKeys.VoucherTypes.VOUCHER_TITLE, (? voucher) -> this.getTranslatedValue((BaseEntity)voucher.getType(), QVoucherType.voucherType.voucherTitle)));
        arrayList.add(this.custom(ColumnType.STRING, "description", BankingKeys.VoucherTypes.VOUCHER_DESCRIPTION, (? voucher) -> this.getTranslatedValue((BaseEntity)voucher.getType(), QVoucherType.voucherType.voucherDescription)));
        arrayList.add(this.custom((Property<?, ?>)VoucherPackVO.REDEEM_AFTER_DATE, BankingKeys.Vouchers.REDEEM_AFTER_DATE, voucher -> voucher.getPack().getRedeemAfterDate()));
        arrayList.add(this.custom((Property<?, ?>)VoucherPackVO.REDEEM_ON_WEEK_DAYS, BankingKeys.Vouchers.REDEEM_ON_WEEK_DAYS, voucher -> {
            Set set = voucher.getPack().getRedeemOnWeekDays();
            if (CollectionHelper.isEmpty((Iterable)set) || set.size() == 7) {
                return BankingKeys.Vouchers.REDEEM_ON_WEEK_DAYS_ANY;
            }
            EnumSet<WeekDay> enumSet = EnumSet.noneOf(WeekDay.class);
            enumSet.addAll(set);
            return enumSet;
        }));
        this.voucherCustomFieldService.listVisible(null).stream().map(voucherCustomField -> this.custom(ColumnType.from(voucherCustomField), TabularExportHandlerImpl.columnName(voucherCustomField), this.getTranslatedName((NamedEntity)voucherCustomField), (? voucher) -> {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(voucher.getPack().getCustomValues());
            arrayList.addAll(voucher.getCustomValues());
            return this.customFieldValueHandler.getValue((CustomField)voucherCustomField, (Object)CustomFieldHelper.findValue((ICustomField)voucherCustomField, arrayList), false);
        })).forEach(arrayList::add);
        return arrayList;
    }

    private /* synthetic */ Object lambda$users$78(UserAccountType userAccountType, AccountNumberConfiguration accountNumberConfiguration, User user) {
        try {
            UserAccount userAccount = (UserAccount)this.accountService.load((InternalAccountOwner)user, (AccountType)userAccountType);
            if (!this.accountService.isActive((IAccount)userAccount)) {
                return null;
            }
            return MaskHelper.applyMask((String)accountNumberConfiguration.getMask(), (String)userAccount.getNumber());
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return null;
        }
    }

    private /* synthetic */ Object lambda$users$77(UserAccountType userAccountType, User user) {
        try {
            UserAccount userAccount = (UserAccount)this.accountService.load((InternalAccountOwner)user, (AccountType)userAccountType);
            if (!this.accountService.isActive((IAccount)userAccount)) {
                return null;
            }
            return new CurrencyAmount(userAccount.getCurrency(), this.accountService.getBalance((Account)userAccount, null));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return null;
        }
    }

    protected class PropertyColumn
    extends Column {
        private final String property;

        public PropertyColumn(ColumnType columnType, MessageKey messageKey, Object object) {
            super(columnType, PropertyHelper.getPropertyName((Object)object), TabularExportHandlerImpl.this.message(messageKey, new Object[0]));
            this.property = this.getName();
        }

        public PropertyColumn(ColumnType columnType, String string, MessageKey messageKey, Object object) {
            super(columnType, string, TabularExportHandlerImpl.this.message(messageKey, new Object[0]));
            this.property = PropertyHelper.getPropertyName((Object)object);
        }

        public PropertyColumn(MessageKey messageKey, Property<?, ?> property) {
            super(ColumnType.from(property), property.getName(), TabularExportHandlerImpl.this.message(messageKey, new Object[0]));
            this.property = this.getName();
        }

        public PropertyColumn(String string, MessageKey messageKey, Property<?, ?> property) {
            super(ColumnType.from(property), string, TabularExportHandlerImpl.this.message(messageKey, new Object[0]));
            this.property = PropertyHelper.getPropertyName(property);
        }

        @Override
        public Object getValue(Object object) {
            try {
                return InvocationContext.wrap((Object)object).getPropertyValue(this.property);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static enum ColumnType {
        STRING,
        BOOLEAN,
        NUMBER,
        CURRENCY_AMOUNT,
        CURRENCY,
        DATE;


        protected static ColumnType from(CustomField<?, ?, ?> customField) {
            switch (customField.getType()) {
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case DATE: {
                    return DATE;
                }
                case INTEGER: 
                case DECIMAL: {
                    return NUMBER;
                }
            }
            return STRING;
        }

        protected static ColumnType from(PageResultColumn pageResultColumn) {
            PageResultColumnType pageResultColumnType = (PageResultColumnType)ObjectHelper.defaultValue((Object)pageResultColumn.getType(), (Object)PageResultColumnType.STRING);
            switch (pageResultColumnType) {
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case CURRENCY_AMOUNT: {
                    return CURRENCY_AMOUNT;
                }
                case DATE: {
                    return DATE;
                }
                case NUMBER: {
                    return NUMBER;
                }
                case STRING: {
                    return STRING;
                }
            }
            throw new IllegalStateException("Unhandled operation column type " + String.valueOf(pageResultColumnType));
        }

        protected static ColumnType from(ProfileField profileField) {
            if (profileField instanceof UserCustomField) {
                return ColumnType.from((CustomField)profileField);
            }
            return STRING;
        }

        protected static ColumnType from(Property<?, ?> property) {
            if (Boolean.class.isAssignableFrom(property.getType()) || Boolean.TYPE.isAssignableFrom(property.getType())) {
                return BOOLEAN;
            }
            if (Number.class.isAssignableFrom(property.getType()) || property.getType().isPrimitive()) {
                return NUMBER;
            }
            if (CurrencyAmountDTO.class.isAssignableFrom(property.getType())) {
                return CURRENCY_AMOUNT;
            }
            if (CurrencyVO.class.isAssignableFrom(property.getType())) {
                return CURRENCY;
            }
            return STRING;
        }

        protected static ColumnType from(UserImportField userImportField) {
            switch (userImportField) {
                case ACCOUNT_CREDIT_LIMIT: 
                case ACCOUNT_UPPER_CREDIT_LIMIT: {
                    return NUMBER;
                }
                case ADDRESS_PRIVATE: 
                case LANDLINE_PRIVATE: 
                case MOBILE_PRIVATE: {
                    return BOOLEAN;
                }
                case CREATION_DATE: {
                    return DATE;
                }
            }
            return STRING;
        }
    }

    protected class CustomColumn
    extends Column {
        private final Function<?, ?> getter;

        public CustomColumn(ColumnType columnType, String string, MessageKey messageKey, Function<?, ?> function) {
            this(columnType, string, tabularExportHandlerImpl.message(messageKey, new Object[0]), function);
        }

        public CustomColumn(ColumnType columnType, String string, String string2, Function<?, ?> function) {
            super(columnType, string, string2);
            this.getter = function;
        }

        public CustomColumn(Property<?, ?> property, MessageKey messageKey, Function<?, ?> function) {
            this(property, tabularExportHandlerImpl.message(messageKey, new Object[0]), function);
        }

        public CustomColumn(Property<?, ?> property, String string, Function<?, ?> function) {
            super(ColumnType.from(property), property.getName(), string);
            this.getter = function;
        }

        @Override
        public Object getValue(Object object) {
            return this.getter.apply(DataTranslationProxy.unproxy((Object)object));
        }
    }

    protected class CustomOperationColumn
    extends Column {
        private final PageResultColumn column;

        public CustomOperationColumn(PageResultColumn pageResultColumn) {
            super(ColumnType.from(pageResultColumn), pageResultColumn.getHeader(), pageResultColumn.getHeader());
            this.column = pageResultColumn;
        }

        @Override
        public Object getValue(Object object) {
            Object object2 = TabularExportHandlerImpl.this.getCustomOperationValue(object, this.column);
            if (object2 == null) {
                return null;
            }
            switch (this.column.getType()) {
                case BOOLEAN: {
                    return CoercionHelper.coerce(Boolean.TYPE, (Object)object2);
                }
                case CURRENCY_AMOUNT: {
                    return TabularExportHandlerImpl.this.getCustomOperationCurrencyAmountValue(object2);
                }
                case DATE: {
                    if (object2 instanceof Date) {
                        return object2;
                    }
                    if (object2 instanceof Calendar) {
                        return ((Calendar)object2).getTime();
                    }
                    if (object2 instanceof IDate) {
                        return TabularExportHandlerImpl.this.conversionHandler.toDate((IDate)object2);
                    }
                    return DateTime.parse((String)object2.toString());
                }
                case NUMBER: {
                    return object2 instanceof Number ? (Number)object2 : new BigDecimal(object2.toString());
                }
            }
            return TabularExportHandlerImpl.this.getFormatter().format(object2);
        }
    }

    protected class ProfileFieldColumn
    extends Column {
        private final ProfileField profileField;

        public ProfileFieldColumn(ProfileField profileField) {
            super(ColumnType.from(profileField), TabularExportHandlerImpl.columnName(profileField), TabularExportHandlerImpl.this.columnHeading(profileField));
            this.profileField = profileField;
        }

        @Override
        public Object getValue(Object object) {
            if (object instanceof UserWithFieldsVO) {
                UserWithFieldsVO userWithFieldsVO = (UserWithFieldsVO)object;
                if (this.profileField instanceof BasicProfileField) {
                    switch ((BasicProfileField)this.profileField) {
                        case ACCOUNT_NUMBER: {
                            return userWithFieldsVO.getAccountNumber();
                        }
                        case EMAIL: {
                            return userWithFieldsVO.getEmail();
                        }
                        case FULL_NAME: {
                            return userWithFieldsVO.getName();
                        }
                        case LOGIN_NAME: {
                            return userWithFieldsVO.getUsername();
                        }
                        case PHONE: {
                            return userWithFieldsVO.getPhone();
                        }
                    }
                    return null;
                }
                UserCustomField userCustomField = (UserCustomField)this.profileField;
                CustomFieldValueVO customFieldValueVO = (CustomFieldValueVO)CustomFieldHelper.findValue((ICustomField)userCustomField, (Collection)userWithFieldsVO.getCustomValues());
                return customFieldValueVO == null ? null : TabularExportHandlerImpl.this.customFieldValueHandler.getValue((CustomField)userCustomField, (Object)customFieldValueVO, false);
            }
            if (object instanceof BasicUser) {
                return TabularExportHandlerImpl.this.profileFieldHandler.getFieldValue((BasicUser)object, this.profileField);
            }
            return null;
        }
    }

    protected class CustomFieldColumn
    extends Column {
        protected final CustomField<?, ?, ?> customField;

        public CustomFieldColumn(CustomField<?, ?, ?> customField) {
            super(ColumnType.from(customField), TabularExportHandlerImpl.columnName(customField), TabularExportHandlerImpl.this.getTranslatedName(customField));
            this.customField = customField;
        }

        @Override
        public Object getValue(Object object) {
            Collection collection = null;
            if (object instanceof EntityWithCustomValues) {
                collection = ((EntityWithCustomValues)object).getCustomValues();
            } else if (object instanceof ModelWithCustomValues) {
                collection = ((ModelWithCustomValues)object).getCustomValues();
            }
            ICustomFieldValue iCustomFieldValue = CustomFieldHelper.findValue(this.customField, (Collection)collection);
            return TabularExportHandlerImpl.this.customFieldValueHandler.getValue(this.customField, (Object)iCustomFieldValue, false);
        }
    }

    protected class TransactionCustomFieldColumn
    extends CustomFieldColumn {
        public TransactionCustomFieldColumn(CustomField<?, ?, ?> customField) {
            super(customField);
        }

        @Override
        public Object getValue(Object object) {
            Transaction transaction = null;
            Set set = null;
            if (object instanceof Transaction) {
                transaction = (Transaction)object;
            } else if (object instanceof Transfer) {
                set = ((Transfer)object).getCustomValuesForExport();
            } else if (object instanceof Installment) {
                transaction = ((Installment)object).getTransaction();
            }
            if (transaction != null) {
                set = transaction.getCustomValues();
            }
            ICustomFieldValue iCustomFieldValue = CustomFieldHelper.findValue((ICustomField)this.customField, (Collection)set);
            return TabularExportHandlerImpl.this.customFieldValueHandler.getValue(this.customField, (Object)iCustomFieldValue, false);
        }
    }

    protected class TransferStatusColumn
    extends Column {
        private final TransferStatusFlow flow;

        public TransferStatusColumn(TransferStatusFlow transferStatusFlow) {
            super(ColumnType.STRING, transferStatusFlow.getInternalName(), TabularExportHandlerImpl.this.getTranslatedName((NamedEntity)transferStatusFlow));
            this.flow = transferStatusFlow;
        }

        @Override
        public Object getValue(Object object) {
            Transfer transfer = null;
            if (object instanceof Transfer) {
                transfer = (Transfer)object;
            } else if (object instanceof AccountHistoryEntry) {
                transfer = ((AccountHistoryEntry)object).getTransfer();
            }
            return transfer == null ? null : transfer.getStatus(this.flow);
        }
    }

    protected abstract class Column {
        private final ColumnType type;
        private final String name;
        private final String heading;
        protected final SessionData sessionData;
        protected final FormatterImpl formatter;

        public Column(ColumnType columnType, String string, String string2) {
            this.type = columnType;
            this.name = string != null ? string : string2;
            this.heading = string2;
            this.sessionData = TabularExportHandlerImpl.this.getSessionData();
            this.formatter = TabularExportHandlerImpl.this.getFormatter(this.sessionData.getConfiguration());
        }

        public final String getHeading() {
            return this.heading;
        }

        public String getName() {
            return this.name;
        }

        public ColumnType getType() {
            return this.type;
        }

        public abstract Object getValue(Object var1);
    }
}

