/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.system.LabeledData;
import org.cyclos.impl.system.PDFReportHandler;
import org.cyclos.impl.system.ReportParams;
import org.cyclos.impl.system.ReportSection;
import org.cyclos.impl.system.ReportServiceLocal;
import org.cyclos.impl.system.SubReportsHandler;
import org.cyclos.impl.system.SystemReportPreferencesServiceLocal;
import org.cyclos.impl.utils.formatting.PredefinedPeriodDataValueFormatter;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Property;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.reports.SystemReportData;
import org.cyclos.model.system.reports.SystemReportQuery;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.PeriodPreselectorOptionData;
import org.cyclos.model.utils.PeriodPreselectorOptionType;
import org.cyclos.model.utils.PeriodType;
import org.cyclos.model.utils.PredefinedPeriodData;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
extends BaseServiceImpl
implements ReportServiceLocal {
    private static final int QUARTERS_IN_PERIOD_PRESELECTOR = 4;
    private static final int MONTHS_IN_PERIOD_PRESELECTOR = 3;
    private static final int YEARS_IN_PERIOD_PRESELECTOR = 3;
    private static final List<Property<?, ?>> SYSTEM_SELECTORS = Arrays.asList(SystemReportQuery.EXPENDITURE, SystemReportQuery.INCOME, SystemReportQuery.NUMBER_LOGINS, SystemReportQuery.PERCENTAGE_NOT_TRADING, SystemReportQuery.USER_GROUP_INFO, SystemReportQuery.ADS, SystemReportQuery.SYSTEM_ACCOUNTS, SystemReportQuery.USER_ACCOUNTS, SystemReportQuery.REFERENCES);
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private SystemReportPreferencesServiceLocal systemReportPreferencesService;
    @Autowired
    private PDFReportHandler pdfReportHandler;
    private List<SubReportsHandler> subReportsHandlers;

    public SystemReportData getSystemReportData() {
        Page page;
        DateTime dateTime;
        SystemReportData systemReportData = new SystemReportData();
        SessionData sessionData = this.getSessionData();
        TimeZone timeZone = sessionData.getConfiguration().getTimeZone();
        List list = this.systemReportPreferencesService.list();
        systemReportData.setPreferences(list);
        systemReportData.setGroups(this.groupsHandler.all().basicUsers().sorted());
        List list2 = sessionData.getProducts().admin().getUserAccountsAccess();
        List list3 = sessionData.getProducts().admin().getSystemAccounts();
        boolean bl = CollectionHelper.isNotEmpty((Iterable)list2);
        systemReportData.setHasUserAccounts(bl);
        systemReportData.setAllowMultipleReports(sessionData.getConfiguration().isAllowMultipleReports());
        if (bl || CollectionHelper.isNotEmpty((Iterable)list3)) {
            dateTime = new ArrayList();
            dateTime.addAll(list2);
            dateTime.addAll(list3);
            TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
            transferTypeQuery.setFromOrToNature(AccountTypeNature.USER);
            transferTypeQuery.setFromOrToAccountTypes(this.conversionHandler.convertSet(AccountTypeVO.class, (Iterable)dateTime));
            transferTypeQuery.setUnlimited();
            page = this.transferTypeService.search(TransferTypeWithCurrencyVO.class, transferTypeQuery);
            systemReportData.setTransferTypes(page.getPageItems());
        }
        dateTime = this.toDateTime(sessionData.getNetwork().getCreationDate());
        int n = 8;
        page = new ArrayList(n);
        ArrayList arrayList = new ArrayList(n);
        PredefinedPeriodData predefinedPeriodData = DateHelper.getLastCompletedPeriod((PeriodType)PeriodType.QUARTER, (TimeZone)timeZone);
        arrayList.addAll(DateHelper.createPeriodRange((PredefinedPeriodData)predefinedPeriodData, (int)-4));
        PredefinedPeriodData predefinedPeriodData2 = DateHelper.getPresentYear((TimeZone)timeZone);
        arrayList.addAll(DateHelper.createPeriodRange((PredefinedPeriodData)predefinedPeriodData2, (int)-3));
        PredefinedPeriodData predefinedPeriodData3 = DateHelper.getLastCompletedPeriod((PeriodType)PeriodType.MONTH, (TimeZone)timeZone);
        arrayList.addAll(DateHelper.createPeriodRange((PredefinedPeriodData)predefinedPeriodData3, (int)-3));
        for (PredefinedPeriodData predefinedPeriodData4 : arrayList) {
            DatePeriodDTO datePeriodDTO = this.createPeriod(predefinedPeriodData4, dateTime, timeZone);
            if (datePeriodDTO == null) continue;
            PeriodPreselectorOptionData periodPreselectorOptionData = this.createPeriodPreselectorOptionData(predefinedPeriodData4, datePeriodDTO, PeriodPreselectorOptionType.PRESELECTED);
            page.add(periodPreselectorOptionData);
        }
        PeriodPreselectorOptionData periodPreselectorOptionData = this.createPeriodPreselectorOptionData(new PredefinedPeriodData(), null, PeriodPreselectorOptionType.CUSTOM);
        page.add(periodPreselectorOptionData);
        systemReportData.setPeriodPreselectorOptions((List)page);
        systemReportData.setToday(this.toDateTime(DateHelper.now()));
        return systemReportData;
    }

    @PostConstruct
    public void initialize() {
        Collection collection = this.getApplicationContext().getBeansOfType(SubReportsHandler.class).values();
        this.subReportsHandlers = CollectionHelper.sort(collection, Comparator.comparing(SubReportsHandler::order));
    }

    public SerializableInputStream readSystemReport(SystemReportQuery systemReportQuery) {
        this.validate(systemReportQuery);
        DatePeriodDTO datePeriodDTO = systemReportQuery.getPeriod().getPeriod();
        Date date = this.toDate(datePeriodDTO.getBegin());
        Date date2 = this.toDate(datePeriodDTO.getEnd());
        boolean bl = date2.before(DateHelper.now());
        date2 = bl ? DateHelper.add((Date)date2, (TimeField)TimeField.SECONDS, (int)1) : DateHelper.now();
        datePeriodDTO.setEnd(this.toDateTime(date2));
        if (CollectionHelper.isEmpty((Iterable)systemReportQuery.getGroups())) {
            systemReportQuery.setGroups(new HashSet(this.groupsHandler.visibles().accessibles().basicUsers().sorted()));
        }
        ArrayList<ReportSection> arrayList = new ArrayList<ReportSection>();
        arrayList.add(this.getFilters(systemReportQuery));
        this.subReportsHandlers.stream().map(subReportsHandler -> subReportsHandler.data(systemReportQuery)).filter(CollectionHelper::isNotEmpty).forEach(arrayList::addAll);
        ReportParams reportParams = new ReportParams();
        reportParams.setTitle((Object)SystemKeys.Reports.SYSTEM_HEADING);
        reportParams.setBegin(date);
        reportParams.setEnd(date2);
        reportParams.setSections(arrayList);
        return this.pdfReportHandler.systemReport(reportParams);
    }

    public void validate(SystemReportQuery systemReportQuery) {
        this.validate(this.resolveValidator(systemReportQuery), systemReportQuery, "systemReportQuery");
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private DatePeriodDTO createPeriod(PredefinedPeriodData predefinedPeriodData, DateTime dateTime, TimeZone timeZone) {
        Pair pair = DateHelper.createPeriod((PredefinedPeriodData)predefinedPeriodData, (TimeZone)timeZone);
        if (pair == null) {
            return null;
        }
        DateTime dateTime2 = this.toDateTime((Date)pair.getFirst());
        DateTime dateTime3 = this.toDateTime((Date)pair.getSecond());
        boolean bl = dateTime2.getYear() < dateTime.getYear();
        boolean bl2 = dateTime2.getYear() == dateTime.getYear() && dateTime2.getMonth() < dateTime.getMonth();
        switch (predefinedPeriodData.getType()) {
            case YEAR: {
                if (!bl) break;
                return null;
            }
            case MONTH: 
            case QUARTER: {
                if (!bl && !bl2) break;
                return null;
            }
        }
        return DateHelper.period((DateTime)dateTime2, (DateTime)dateTime3);
    }

    private PeriodPreselectorOptionData createPeriodPreselectorOptionData(PredefinedPeriodData predefinedPeriodData, DatePeriodDTO datePeriodDTO, PeriodPreselectorOptionType periodPreselectorOptionType) {
        PeriodPreselectorOptionData periodPreselectorOptionData = new PeriodPreselectorOptionData();
        periodPreselectorOptionData.setName(PredefinedPeriodDataValueFormatter.instance().format(null, predefinedPeriodData, this.getFormatter()));
        periodPreselectorOptionData.setType(periodPreselectorOptionType);
        periodPreselectorOptionData.setPeriod(datePeriodDTO);
        return periodPreselectorOptionData;
    }

    private ReportSection getFilters(SystemReportQuery systemReportQuery) {
        Date date = this.toDate(systemReportQuery.getPeriod().getPeriod().getBegin());
        Date date2 = this.toDate(systemReportQuery.getPeriod().getPeriod().getEnd());
        Date date3 = DateHelper.now();
        boolean bl = DateHelper.sameDay((TimeZone)this.getConfiguration().getTimeZone(), (Date)date2, (Date)date3) || date2.after(date3);
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        ArrayList<LabeledData> arrayList = new ArrayList<LabeledData>();
        arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_PERIOD_NAME, systemReportQuery.getPeriod().getName()));
        arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_PERIOD_BEGIN, date));
        arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_PERIOD_END, bl ? date3 : date2));
        arrayList.add(new LabeledData(SystemKeys.Reports.GROUPS, set));
        boolean bl2 = systemReportQuery.isExpenditure() || systemReportQuery.isIncome() || systemReportQuery.isPercentageNotTrading();
        List list = CollectionHelper.sort((Collection)this.conversionHandler.convertList(TransferType.class, (Iterable)systemReportQuery.getTransferTypes()));
        if (bl2 && CollectionHelper.isNotEmpty((Iterable)list)) {
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_FILTERS_CURRENCY_RESULT, this.conversionHandler.convert(Currency.class, (Object)systemReportQuery.getCurrency())));
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_FILTERS_TRANSFER_TYPE_RESULT, list));
        } else {
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_TRANSFER_TYPES, SystemKeys.Reports.SYSTEM_FILTERS_NO_TRANSFER_TYPES));
        }
        return new ReportSection((Object)SystemKeys.Reports.SYSTEM_FILTERS_INFORMATION, false, arrayList);
    }

    private Validator resolveValidator(SystemReportQuery systemReportQuery) {
        Validator validator = new Validator();
        boolean bl = this.getSessionData().getConfiguration().isAllowMultipleReports();
        validator.property((Property)SystemReportQuery.PERIOD, SystemKeys.Reports.PERIOD).required();
        Validator validator2 = new Validator();
        validator2.property((Property)PeriodPreselectorOptionData.PERIOD, SystemKeys.Reports.PERIOD).required().period().noFuturePeriod();
        validator.nested((PropertyAccess)new BeanPropertyAccess((Property)SystemReportQuery.PERIOD), validator2);
        validator.property((Property)SystemReportQuery.GROUPS, SystemKeys.Reports.GROUPS).add((object, object2, object3) -> {
            if (CollectionHelper.isEmpty((Iterable)systemReportQuery.getGroups())) {
                return new ValidationError(SystemKeys.Reports.GROUPS_REQUIRED);
            }
            return null;
        });
        validator.general(object -> {
            boolean bl2 = false;
            for (Property<?, ?> property : SYSTEM_SELECTORS) {
                boolean bl3 = Boolean.TRUE.equals(systemReportQuery.get(property));
                if (!bl3) continue;
                if (bl2 && !bl) {
                    return new ValidationError(SystemKeys.Reports.SYSTEM_ERROR_MULTIPLE_REPORTS_NOT_ALLOWED);
                }
                bl2 = true;
            }
            return bl2 ? null : new ValidationError(GeneralKeys.Errors.NOTHING_SELECTED);
        });
        if (systemReportQuery.isExpenditure() || systemReportQuery.isIncome() || systemReportQuery.isPercentageNotTrading()) {
            validator.property((Property)SystemReportQuery.TRANSFER_TYPES, SystemKeys.Reports.SYSTEM_TRANSFER_TYPES).required();
        }
        return validator;
    }
}

