/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.cyclos.impl.system.RawFileServiceImpl;
import org.cyclos.impl.system.TempImageServiceLocal;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurgeTempFilesRecurringTask
extends SimpleRecurringTask {
    private static final long DELETE_OLDER_THAN = 86400000L;
    @Autowired
    private TempImageServiceLocal tempImageService;
    @Autowired
    private RawFileServiceImpl tempFileService;
    @Autowired
    private CyclosProperties cyclosProperties;

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.PURGE_TEMP_FILES;
    }

    @Override
    protected long execute() throws Throwable {
        long l = 0L;
        l += this.tempImageService.deleteExpiredImages();
        l += this.tempFileService.deleteExpiredTemp();
        return l += this.deleteTempFiles(this.cyclosProperties.getTempFilesDir(), false);
    }

    private long deleteTempFiles(File file, boolean bl) throws IOException {
        long l = 0L;
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    l += this.deleteTempFiles(file2, true);
                    continue;
                }
                if (file2.lastModified() >= System.currentTimeMillis() - 86400000L) continue;
                FileUtils.forceDelete((File)file2);
                ++l;
            }
            if (bl && file.listFiles().length == 0) {
                FileUtils.deleteDirectory((File)file);
            }
        }
        return l;
    }
}

