/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.QInternetAddressList;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.InternetAddressHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.stereotype.Component;

@Component
public class InternetAddressResolutionRecurringTask
extends EntityBatchRecurringTask<InternetAddressList> {
    private static final int MINUTES = 30;

    public InternetAddressResolutionRecurringTask() {
        super(InternetAddressList.class);
    }

    @Override
    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.NOW;
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.INTERNET_ADDRESS_RESOLUTION;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_HALF_HOUR;
    }

    @Override
    protected void finish(InternetAddressList internetAddressList, Throwable throwable) throws Throwable {
        internetAddressList.setLastResolutionDate(new Date());
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        Date date = DateHelper.subtract((Date)new Date(), (TimeField)TimeField.MINUTES, (int)30);
        QInternetAddressList qInternetAddressList = QInternetAddressList.internetAddressList;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qInternetAddressList}).where((Predicate)qInternetAddressList.lastResolutionDate.isNull().or((Predicate)qInternetAddressList.lastResolutionDate.before((Comparable)date)))).limit(200L)).list((Expression)qInternetAddressList.id);
    }

    @Override
    protected void process(InternetAddressList internetAddressList) throws Throwable {
        String string = internetAddressList.getAddresses();
        Set set = InternetAddressHelper.resolveAll((String)string);
        internetAddressList.setResolvedAddresses(set);
    }
}

