/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.system.TransactionReportEntry;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.utils.ObjectHelper;

public class InstallmentReportEntry {
    private final boolean authorized;
    private final Installment installment;
    private final TransactionReportEntry transaction;
    private final BigDecimal amount;

    public InstallmentReportEntry(boolean bl, AccountOwner accountOwner, Installment installment) {
        this.authorized = bl;
        this.installment = installment;
        this.transaction = new TransactionReportEntry(bl, accountOwner, (Transaction)installment.getTransaction());
        this.amount = this.transaction.isFrom() ? installment.getAmount().negate() : installment.getAmount();
    }

    public CurrencyAmount getAmount() {
        return new CurrencyAmount(this.installment.getCurrency(), this.amount);
    }

    public Set<TransactionCustomFieldValue> getCustomValues() {
        return this.transaction.getCustomValues();
    }

    public Date getDueDate() {
        return this.installment.getDueDate();
    }

    public Object getRelatedOwner() {
        return this.transaction.getRelatedOwner();
    }

    public String getScheduling() {
        int n = (Integer)ObjectHelper.defaultValue((Object)this.installment.getNumber(), (Object)0);
        TransactionWithInstallments transactionWithInstallments = (TransactionWithInstallments)this.installment.getTransaction();
        Integer n2 = transactionWithInstallments.getInstallmentsCount();
        if (n2 == null) {
            return String.valueOf(n);
        }
        return n + " / " + n2;
    }

    public Object getStatus() {
        if (this.authorized) {
            return this.transaction.getStatus();
        }
        return this.installment.getStatus();
    }
}

