/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ExportHandler;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomExportHandlerImpl
implements ExportHandler {
    private static final String ATTR_FORMAT = "format";
    private static final String ATTR_CONTEXT = "context";
    private static final String ATTR_QUERY = "query";
    private static final String ATTR_DATA = "data";
    private static final String ATTR_ADDITIONAL_DATA = "additionalData";
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    public SerializableInputStream export(ExportHandler.ExportParameters exportParameters) {
        byte[] byArray;
        ExportFormat exportFormat = exportParameters.getFormat();
        Object object = this.customScriptService.newAccessor(exportFormat.getScript(), exportFormat.getScriptParameters()).bind(ATTR_FORMAT, (Object)exportFormat).bind(ATTR_CONTEXT, (Object)exportParameters.getContext()).bind(ATTR_QUERY, (Object)exportParameters.getQueryParameters()).bind(ATTR_DATA, ObjectHelper.defaultValue((Object)exportParameters.getEntities(), (Object)exportParameters.getEntity())).bind(ATTR_ADDITIONAL_DATA, (Object)exportParameters.getAdditionalData()).run();
        if (object instanceof SerializableInputStream) {
            return (SerializableInputStream)object;
        }
        if (object instanceof InputStream) {
            return new SerializableInputStream((InputStream)object);
        }
        if (object instanceof File) {
            return new SerializableInputStream((File)object);
        }
        if (object instanceof Reader) {
            try {
                object = IOUtils.toString((Reader)((Reader)object));
            }
            catch (IOException iOException) {
                throw new CustomScriptException("Error reading value returned from script " + exportFormat.getScript().getName(), (Throwable)iOException);
            }
        }
        String string = (String)ObjectHelper.defaultValue((Object)exportFormat.getEncoding(), (Object)"UTF-8");
        try {
            byArray = object.toString().getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ValidationException("Invalid encoding: " + string);
        }
        return new SerializableInputStream(byArray);
    }

    public BuiltInExportFormat getBuiltInFormat() {
        return null;
    }
}

