/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SetPath;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.contentmanagement.QTheme;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.ConfigurationGuestProfileField;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.DefaultUserImage;
import org.cyclos.entities.system.DynamicOidcClientConfiguration;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.system.QChannelConfiguration;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.system.QConfigurationGuestProfileField;
import org.cyclos.entities.system.SmtpConfiguration;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.system.UserFormatConfiguration;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.ProfileFieldComparator;
import org.cyclos.entities.users.QBasicGroup;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.OidcClientServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.DefaultUserImageServiceLocal;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.appnotifications.AppNotificationHandlerImpl;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.impl.utils.validation.validations.UrlValidation;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.oidcclients.OidcClientData;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.contentmanagement.themes.ThemeUsage;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.configurations.AccountNumberConfigurationDTO;
import org.cyclos.model.system.configurations.ActiveChannelConfigurationData;
import org.cyclos.model.system.configurations.ActiveConfigurationData;
import org.cyclos.model.system.configurations.CaptchaConfigurationDTO;
import org.cyclos.model.system.configurations.CaptchaProvider;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.system.configurations.ConfigurationData;
import org.cyclos.model.system.configurations.ConfigurationDetailedVO;
import org.cyclos.model.system.configurations.ConfigurationGuestProfileFieldDTO;
import org.cyclos.model.system.configurations.ConfigurationQuery;
import org.cyclos.model.system.configurations.ConfigurationSearchData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.CustomScriptConfigurationDTO;
import org.cyclos.model.system.configurations.CustomSessionConfigurationDTO;
import org.cyclos.model.system.configurations.DefaultConfigurationType;
import org.cyclos.model.system.configurations.DynamicOidcClientConfigurationDTO;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.system.configurations.OutboundSmsConfigurationDTO;
import org.cyclos.model.system.configurations.ResultType;
import org.cyclos.model.system.configurations.SmtpConfigurationDTO;
import org.cyclos.model.system.configurations.UserFormatConfigurationDTO;
import org.cyclos.model.system.configurations.UserSearchInMenuMode;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.model.system.languages.ListSeparator;
import org.cyclos.model.system.languages.NumberFormat;
import org.cyclos.model.system.languages.TimeFormat;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.addresses.AddressConfigurationData;
import org.cyclos.model.users.fields.UserCustomFieldVO;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.BasicGroupQuery;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.phones.PhoneConfigurationData;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.utils.AppNotificationException;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.UserMainMenu;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.ReservedUris;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationServiceImpl
extends CRUDServiceImpl<Configuration, QConfiguration, ConfigurationDTO, ConfigurationData, ConfigurationVO>
implements ConfigurationServiceLocal {
    private static final Map<Property<?, ?>, MessageKey> REQUIRED_PROPERTIES = new HashMap();
    private static final Object[] EXCLUDED_PROPERTIES_FROM_CONVERSION;
    private static final int MAX_USER_FORMAT_FIELDS = 5;
    private static final int MAX_RESULTS = 99999;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private AdCategoryServiceLocal adCategoryService;
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private LanguageServiceLocal languageService;
    @Autowired
    private NetworkServiceLocal networkService;
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private AppNotificationHandlerImpl appNotificationHandler;
    @Autowired
    private DefaultUserImageServiceLocal defaultUserImageService;
    @Autowired
    private OidcClientServiceLocal oidcClientService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public ConfigurationServiceImpl() {
        super(Configuration.class, QConfiguration.configuration, ConfigurationDTO.class);
    }

    public Configuration createDefaultForNetwork(Network network) throws FrameworkException {
        Configuration configuration = new Configuration();
        Configuration configuration2 = network.getParentConfiguration();
        if (configuration2 == null) {
            configuration2 = this.configurationHandler.getDefault();
        }
        configuration.setParent(configuration2);
        configuration.setNetwork(network);
        configuration.setName(StringHelper.truncate((String)this.message(SystemKeys.Configurations.DEFAULT_FOR_NETWORK, network.getName()), (int)100));
        configuration.setInternalName("networkDefault");
        configuration.setDefaultType(DefaultConfigurationType.NETWORK);
        this.onBeforeSave(configuration, null);
        this.rawEntityManagerHandler.persist((IEntity)configuration);
        return configuration;
    }

    public ActiveConfigurationData getActiveConfiguration(ConfigurationVO configurationVO) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
        return this.toActiveConfiguration(ActiveConfigurationData.class, configurationAccessor);
    }

    public List<Configuration> getConfigurationTreePath(Configuration configuration) {
        List list = this.configurationHandler.getAncestors(configuration);
        if (!this.getLoggedUser().isGlobal()) {
            list.removeIf(NetworkedEntity::isGlobal);
        }
        Collections.reverse(list);
        return list;
    }

    public ConfigurationVO getDefault() throws FrameworkException {
        return (ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)this.configurationHandler.getDefault());
    }

    public ConfigurationSearchData getSearchData() {
        ConfigurationSearchData configurationSearchData = new ConfigurationSearchData();
        configurationSearchData.setGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
        configurationSearchData.setQuery((QueryParameters)((ConfigurationQuery)QueryHelper.newQuery(ConfigurationQuery.class)));
        return configurationSearchData;
    }

    public List<ConfigurationDetailedVO> list() throws FrameworkException {
        return this.conversionHandler.convertList(ConfigurationDetailedVO.class, this.listVisible());
    }

    public List<Configuration> listAll() {
        return ((DBQuery)this.applyNetwork(this.rawEntityManagerHandler.from(new EntityPath[]{this.$})).orderBy(((QConfiguration)this.$).nameHierarchy().asc())).list((Expression)this.$);
    }

    public List<Configuration> listByThemeUsage(Theme theme, ThemeUsage themeUsage) throws FrameworkException {
        QTheme qTheme;
        switch (themeUsage) {
            case LOGGED_USERS: {
                qTheme = ((QConfiguration)this.$).usersTheme();
                break;
            }
            case GUESTS: {
                qTheme = ((QConfiguration)this.$).guestsTheme();
                break;
            }
            case MOBILE: {
                qTheme = ((QConfiguration)this.$).mobileTheme();
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return ((DBQuery)((DBQuery)this.from().where((Predicate)qTheme.eq((Object)theme))).orderBy(((QConfiguration)this.$).nameHierarchy().asc())).list((Expression)this.$);
    }

    public List<Configuration> listVisible() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        if (sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) || sessionData.getNetwork() == null) {
            return this.listAll();
        }
        AdminProductAccessor adminProductAccessor = sessionData.getProducts().admin();
        List list = adminProductAccessor.getManageSpecificConfigurations();
        list.addAll(adminProductAccessor.getManageContentSpecificConfigurations());
        return this.sortByHierarchy(list);
    }

    @Override
    public Configuration newEntity(ConfigurationVO configurationVO) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        Configuration configuration2 = new Configuration();
        configuration2.setParent(configuration);
        return configuration2;
    }

    public void removeGroup(Group group) {
        UserGroup userGroup;
        boolean bl;
        if (group instanceof UserGroup && (bl = this.removeFromGroup(userGroup = (UserGroup)group, (SetPath<BasicGroup, QBasicGroup>)((QConfiguration)this.$).groupsForUserSearch) | this.removeFromGroup(userGroup, (SetPath<BasicGroup, QBasicGroup>)((QConfiguration)this.$).groupsForViewProfile) | this.removeFromGroup(userGroup, (SetPath<BasicGroup, QBasicGroup>)((QConfiguration)this.$).groupsForUserDirectory) | this.removeFromGroup(userGroup, (SetPath<BasicGroup, QBasicGroup>)((QConfiguration)this.$).possibleInitialGroups) | this.removeFromGroup(userGroup, (SetPath<BasicGroup, QBasicGroup>)((QConfiguration)this.$).visibleAdGroups))) {
            Long l = SimpleEntity.id((SimpleEntity)group.getNetwork());
            List list = PropertyHelper.getGetterNames((Path[])new Path[]{((QConfiguration)this.$).groupsForUserSearch, ((QConfiguration)this.$).groupsForViewProfile, ((QConfiguration)this.$).groupsForUserDirectory, ((QConfiguration)this.$).possibleInitialGroups, ((QConfiguration)this.$).visibleAdGroups});
            this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, (SerializablePredicate & Serializable)configurationAccessorCacheKey -> configurationAccessorCacheKey.matchesNetworkAndMethod(l, (Collection)list));
        }
    }

    public Page<ConfigurationDetailedVO> search(ConfigurationQuery configurationQuery) {
        DBQuery dBQuery = this.rawEntityManagerHandler.from(new EntityPath[]{this.$});
        this.applyNetwork(dBQuery);
        Set set = this.groupsHandler.flattenVOs((Collection)configurationQuery.getGroups());
        if (QueryHelper.useParameter((Object)configurationQuery.getName())) {
            dBQuery.where((Predicate)((QConfiguration)this.$).name.containsIgnoreCase(configurationQuery.getName()));
        }
        if (QueryHelper.useParameter((Object)configurationQuery.getUrl())) {
            dBQuery.where((Predicate)((QConfiguration)this.$).rootUrl.containsIgnoreCase(configurationQuery.getUrl()).or((Predicate)((QConfiguration)this.$).path.containsIgnoreCase(configurationQuery.getUrl())));
        }
        if (QueryHelper.useParameter((Object)configurationQuery.getGroups())) {
            QBasicGroup qBasicGroup = QBasicGroup.basicGroup;
            dBQuery.where((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qBasicGroup}).where((Predicate)qBasicGroup.in((Collection)set).and((Predicate)qBasicGroup.configuration().eq((Expression)this.$)))).exists());
        }
        dBQuery.orderBy(((QConfiguration)this.$).nameHierarchy().asc());
        this.filterByVisibleConfigurations((QConfiguration)this.$, dBQuery);
        return dBQuery.page(ConfigurationDetailedVO.class, (QueryParameters)configurationQuery, (Expression)this.$);
    }

    public <T> void setConfiguration(Configuration configuration, Path<T> path, T t) {
        BeanWrapper beanWrapper = InvocationContext.wrap((Object)configuration);
        String string = PropertyHelper.getPropertyName(path);
        beanWrapper.setPropertyValue(string, t);
        configuration.getDefinedProperties().add(string);
    }

    public void setLocalization(Configuration configuration, Language language, String string, String string2) throws FrameworkException {
        BuiltinLanguage builtinLanguage = language.getTemplate();
        Locale locale = new Locale(builtinLanguage.getIsoLanguage(), string);
        this.setConfiguration(configuration, (Path)((QConfiguration)this.$).country, (Object)string);
        this.setConfiguration(configuration, (Path)((QConfiguration)this.$).defaultLanguage(), (Object)language);
        this.setConfiguration(configuration, (Path)((QConfiguration)this.$).timeZoneId, (Object)string2);
        this.setConfiguration(configuration, (Path)((QConfiguration)this.$).numberFormat, (Object)this.resolveNumberFormat(locale));
        this.setConfiguration(configuration, (Path)((QConfiguration)this.$).dateFormat, (Object)this.resolveDateFormat(locale));
        this.setConfiguration(configuration, (Path)((QConfiguration)this.$).timeFormat, (Object)this.resolveTimeFormat(locale));
        this.setConfiguration(configuration, (Path)((QConfiguration)this.$).listSeparator, (Object)(configuration.getNumberFormat() == NumberFormat.COMMA_AS_DECIMAL ? ListSeparator.SEMI_COLON : ListSeparator.COMMA));
    }

    public List<Configuration> sortByHierarchy(Collection<Configuration> collection) throws FrameworkException {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return ((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where((Predicate)((QConfiguration)this.$).in(collection))).orderBy(((QConfiguration)this.$).nameHierarchy().asc())).list((Expression)this.$);
    }

    public <T extends ActiveConfigurationData> T toActiveConfiguration(Class<T> clazz, ConfigurationAccessor configurationAccessor) throws FrameworkException {
        OutboundSmsConfigurationDTO outboundSmsConfigurationDTO;
        Configuration configuration = configurationAccessor.getConfiguration();
        ActiveConfigurationData activeConfigurationData = (ActiveConfigurationData)this.conversionHandler.convertExcluding(clazz, (Object)configurationAccessor, new Object[]{ActiveConfigurationData.MAP_SERVER_API_KEY});
        List<Configuration> list = this.getConfigurationTreePath(configuration);
        activeConfigurationData.setConfigurationTreePath(this.conversionHandler.convertList(ConfigurationVO.class, list));
        activeConfigurationData.setForGuests(configuration.isForGuests());
        activeConfigurationData.setUsedByGroups(this.conversionHandler.convertList(BasicGroupVO.class, (Iterable)this.groupService.getGroupsUsingConfiguration(configuration)));
        SmtpConfigurationDTO smtpConfigurationDTO = activeConfigurationData.getSmtpConfiguration();
        if (smtpConfigurationDTO != null) {
            smtpConfigurationDTO.setPassword(null);
        }
        if ((outboundSmsConfigurationDTO = activeConfigurationData.getOutboundSmsConfiguration()) != null) {
            outboundSmsConfigurationDTO.setPassword(null);
        }
        activeConfigurationData.setMapServerApiKeySet(configurationAccessor.isMapServerApiKeySet());
        List list2 = this.channelService.listAll();
        ArrayList<ActiveChannelConfigurationData> arrayList = new ArrayList<ActiveChannelConfigurationData>();
        for (Channel channel : list2) {
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            if (channelConfiguration == null) continue;
            ActiveChannelConfigurationData activeChannelConfigurationData = (ActiveChannelConfigurationData)this.conversionHandler.convert(ActiveChannelConfigurationData.class, (Object)channelConfiguration);
            activeChannelConfigurationData.setChannel((ChannelVO)this.conversionHandler.convert(ChannelVO.class, (Object)channel));
            arrayList.add(activeChannelConfigurationData);
        }
        activeConfigurationData.setChannelConfigurations(arrayList);
        activeConfigurationData.setGuestProfileFields(this.toGuestProfileFieldsDTOs(configurationAccessor.getGuestProfileFields()));
        activeConfigurationData.setProfileFieldsInAccount(this.profileFieldHandler.toVOs((Collection)activeConfigurationData.getProfileFieldsInAccount()));
        activeConfigurationData.setProfileFieldInAccountTitle(this.profileFieldHandler.toVO(activeConfigurationData.getProfileFieldInAccountTitle()));
        activeConfigurationData.setPrivacyControlledProfileFields(this.profileFieldHandler.toVOs((Collection)CollectionHelper.sort((Collection)activeConfigurationData.getPrivacyControlledProfileFields(), (Comparator)ProfileFieldComparator.getInstance())));
        activeConfigurationData.setCountry(this.localizationService.getCountryName(activeConfigurationData.getCountry()));
        activeConfigurationData.setSupportStorageDirectories(this.storedFileHandler.supportStorageDirectories());
        if (!activeConfigurationData.isSupportStorageDirectories()) {
            activeConfigurationData.setIndividualDocumentDirectory(null);
        }
        return (T)activeConfigurationData;
    }

    public AddressConfigurationData toAddressConfiguration(ConfigurationAccessor configurationAccessor) throws FrameworkException {
        AddressConfigurationData addressConfigurationData = (AddressConfigurationData)this.conversionHandler.convert(AddressConfigurationData.class, (Object)configurationAccessor);
        this.conversionHandler.fill((Object)configurationAccessor.getAddressConfiguration(), (Object)addressConfigurationData);
        CollectionHelper.sort((Collection)addressConfigurationData.getEnabledAddressFields());
        CollectionHelper.sort((Collection)addressConfigurationData.getRequiredAddressFields());
        addressConfigurationData.setDefaultCountry(configurationAccessor.getCountry());
        return addressConfigurationData;
    }

    @Override
    public ConfigurationDTO toDTO(Configuration configuration) {
        return this.anyToDTO(configuration);
    }

    @Override
    public Configuration toEntity(ConfigurationDTO configurationDTO) {
        CaptchaConfiguration captchaConfiguration;
        CaptchaConfigurationDTO captchaConfigurationDTO;
        OutboundSmsConfiguration outboundSmsConfiguration;
        SmtpConfiguration smtpConfiguration;
        Configuration configuration;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (configurationDTO.isPersistent()) {
            configuration = (Configuration)this.find(configurationDTO.getId());
            smtpConfiguration = configuration.getSmtpConfiguration();
            string = smtpConfiguration == null ? null : smtpConfiguration.getPassword();
            outboundSmsConfiguration = configuration.getOutboundSmsConfiguration();
            string2 = outboundSmsConfiguration == null ? null : outboundSmsConfiguration.getPassword();
            captchaConfigurationDTO = configuration.getCaptchaConfiguration();
            string3 = captchaConfigurationDTO == null ? null : captchaConfigurationDTO.getRecaptchaSecret();
        }
        configuration = (Configuration)super.toEntity(configurationDTO);
        if (configurationDTO.isMapServerApiKeySet()) {
            configuration.setMapServerApiKey(configurationDTO.getMapServerApiKey());
        }
        if (configurationDTO.isFirebasePrivateKeySet()) {
            configuration.setFirebasePrivateKey(configurationDTO.getFirebasePrivateKey());
        }
        if ((smtpConfiguration = configurationDTO.getSmtpConfiguration()) != null) {
            outboundSmsConfiguration = (SmtpConfiguration)this.conversionHandler.convertExcluding(SmtpConfiguration.class, (Object)smtpConfiguration, new Object[]{SmtpConfigurationDTO.PASSWORD});
            if (smtpConfiguration.isPasswordSet()) {
                string = smtpConfiguration.getPassword();
            }
            outboundSmsConfiguration.setPassword(string);
            configuration.setSmtpConfiguration((SmtpConfiguration)outboundSmsConfiguration);
        }
        if ((outboundSmsConfiguration = configurationDTO.getOutboundSmsConfiguration()) != null) {
            captchaConfigurationDTO = (OutboundSmsConfiguration)this.conversionHandler.convertExcluding(OutboundSmsConfiguration.class, (Object)outboundSmsConfiguration, new Object[]{OutboundSmsConfigurationDTO.PASSWORD});
            if (outboundSmsConfiguration.isPasswordSet()) {
                string2 = outboundSmsConfiguration.getPassword();
            }
            captchaConfigurationDTO.setPassword(string2);
            if (captchaConfigurationDTO.getScript() == null) {
                captchaConfigurationDTO.setScriptParameters(null);
            }
            if (captchaConfigurationDTO.isAsciiOnly()) {
                captchaConfigurationDTO.setEncoding("UTF-8");
            }
            configuration.setOutboundSmsConfiguration((OutboundSmsConfiguration)captchaConfigurationDTO);
        }
        if ((captchaConfigurationDTO = configurationDTO.getCaptchaConfiguration()) != null) {
            captchaConfiguration = (CaptchaConfiguration)this.conversionHandler.convertExcluding(CaptchaConfiguration.class, (Object)captchaConfigurationDTO, new Object[]{CaptchaConfigurationDTO.RECAPTCHA_SECRET});
            if (captchaConfigurationDTO.isRecaptchaSecretSet()) {
                string3 = captchaConfigurationDTO.getRecaptchaSecret();
            }
            captchaConfiguration.setRecaptchaSecret(string3);
            configuration.setCaptchaConfiguration(captchaConfiguration);
        }
        captchaConfiguration = CollectionHelper.orEmpty((List)configurationDTO.getGuestProfileFields()).stream().map(configurationGuestProfileFieldDTO -> {
            ConfigurationGuestProfileField configurationGuestProfileField = (ConfigurationGuestProfileField)this.conversionHandler.convertExcluding(ConfigurationGuestProfileField.class, configurationGuestProfileFieldDTO, new Object[]{ConfigurationGuestProfileFieldDTO.PROFILE_FIELD});
            configurationGuestProfileField.setConfiguration(configuration);
            configurationGuestProfileField.setProfileField(this.profileFieldHandler.toEntity(configurationGuestProfileFieldDTO.getProfileField()));
            return configurationGuestProfileField;
        }).collect(Collectors.toSet());
        configuration.setGuestProfileFields((Set)captchaConfiguration);
        configuration.setPrivacyControlledProfileFields(new HashSet(this.profileFieldHandler.toEntities((Collection)configurationDTO.getPrivacyControlledProfileFields())));
        configuration.setProfileFieldsInAccount(new HashSet(this.profileFieldHandler.toEntities((Collection)configurationDTO.getProfileFieldsInAccount())));
        configuration.setProfileFieldInAccountTitle(this.profileFieldHandler.toEntity(configurationDTO.getProfileFieldInAccountTitle()));
        UserFormatConfigurationDTO userFormatConfigurationDTO = configurationDTO.getUserFormatForManagers();
        UserFormatConfiguration userFormatConfiguration = new UserFormatConfiguration();
        if (userFormatConfigurationDTO != null) {
            userFormatConfiguration.setSeparator(userFormatConfigurationDTO.getSeparator());
            userFormatConfiguration.setProfileFields(this.profileFieldHandler.toEntities((Collection)userFormatConfigurationDTO.getProfileFields()));
        }
        configuration.setUserFormatForManagers(userFormatConfiguration);
        UserFormatConfigurationDTO userFormatConfigurationDTO2 = configurationDTO.getUserFormatForOthers();
        UserFormatConfiguration userFormatConfiguration2 = new UserFormatConfiguration();
        if (userFormatConfigurationDTO2 != null) {
            userFormatConfiguration2.setSeparator(userFormatConfigurationDTO2.getSeparator());
            userFormatConfiguration2.setProfileFields(this.profileFieldHandler.toEntities((Collection)userFormatConfigurationDTO2.getProfileFields()));
        }
        configuration.setUserFormatForOthers(userFormatConfiguration2);
        Image image = (Image)this.conversionHandler.convert(Image.class, (Object)configurationDTO.getDefaultUserImage());
        if (image instanceof TempImage) {
            configuration.setUploadedDefaultUserImage((TempImage)image);
        } else if (image instanceof DefaultUserImage) {
            configuration.setDefaultUserImage((DefaultUserImage)image);
        } else {
            configuration.setDefaultUserImage(null);
        }
        if (configuration.getDynamicOidcClientConfiguration() == null) {
            configuration.setDynamicOidcClientConfiguration(new DynamicOidcClientConfiguration());
        }
        return configuration;
    }

    public PhoneConfigurationData toPhoneConfiguration(ConfigurationAccessor configurationAccessor) throws FrameworkException {
        PhoneConfigurationData phoneConfigurationData = (PhoneConfigurationData)this.conversionHandler.convert(PhoneConfigurationData.class, (Object)configurationAccessor);
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        phoneConfigurationData.setSmsEnabled(outboundSmsConfiguration != null && outboundSmsConfiguration.isEnabled());
        phoneConfigurationData.setMobileExample(this.phoneNumberHandler.getExampleNumber(PhoneNature.MOBILE, configurationAccessor));
        phoneConfigurationData.setLandLineExample(this.phoneNumberHandler.getExampleNumber(PhoneNature.LANDLINE, configurationAccessor));
        phoneConfigurationData.setExtensionEnabled(configurationAccessor.isLandLineEnableExtension());
        return phoneConfigurationData;
    }

    public void updateSitemapLastModified(Configuration configuration) throws FrameworkException {
        this.setSitemapLastModified(configuration, new Date());
    }

    @Override
    protected ConfigurationData getData(Configuration configuration) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ConfigurationAccessor configurationAccessor;
        ConfigurationData configurationData = new ConfigurationData();
        Configuration configuration2 = configuration.getParent();
        configurationData.setDto((EntityDTO)this.toDTO(configuration));
        Network network = configuration.getNetwork();
        ConfigurationDTO configurationDTO = null;
        if (configuration2 != null) {
            configurationAccessor = this.configurationHandler.getAccessor(configuration2, null, false);
            configurationDTO = this.anyToDTO(configurationAccessor);
            configurationData.setInheritedDTO(configurationDTO);
            object4 = configurationDTO.getRootUrl();
            object3 = this.configurationHandler.getGlobalDefault().getRootUrl();
            if (((String)object3).equals(object4)) {
                object2 = "";
                if (network == null) {
                    boolean bl;
                    boolean bl2 = bl = this.networkService.getDefault() != null;
                    if (bl) {
                        object2 = "/global";
                    }
                } else {
                    object2 = "/" + network.getInternalName();
                }
                object = StringHelper.removeEnd((String)object3, (String)"/") + (String)object2;
            } else {
                object = object4;
            }
            configurationData.setInheritedRootUrl((String)object);
            if (((String)object3 + "/global/api").equals(configurationDTO.getApiUrl()) || ((String)object3 + "/api").equals(configurationDTO.getApiUrl())) {
                configurationDTO.setApiUrl(null);
            }
        }
        if (configuration.isTransient()) {
            configurationData.setParents(this.conversionHandler.convertList(ConfigurationVO.class, this.listAll()));
        }
        configurationData.setVisibleAdCategories(this.conversionHandler.convertList(AdCategoryVO.class, (Iterable)this.adCategoryService.listRoot(true)));
        configurationData.setVisibleAdCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)this.currencyService.listAll()));
        configurationData.setAdFieldsVisibleToGuests(this.adCustomFieldService.list());
        configurationData.setProfileFields(this.profileFieldHandler.toVOs((Collection)this.profileFieldHandler.getAllProfileFields()));
        configurationData.setForGuests(configuration.isForGuests());
        configurationData.setVisibleGroups(this.groupsHandler.visibles().accessibles().basic().sorted());
        configurationAccessor = new BasicGroupQuery();
        configurationAccessor.setUnlimited();
        configurationAccessor.setNatures(CollectionHelper.asSet((Object[])new BasicGroupNature[]{BasicGroupNature.MEMBER_GROUP, BasicGroupNature.BROKER_GROUP}));
        object4 = this.groupService.search((BasicGroupQuery)configurationAccessor).getPageItems();
        object4.retainAll(configurationData.getVisibleGroups());
        configurationData.setPossibleInitialGroups((List)object4);
        configurationData.setRegistrationWizards(this.conversionHandler.convertList(CustomWizardVO.class, (Iterable)this.customWizardService.listRegistrationWizards()));
        object3 = this.languageService.listAll();
        configurationData.setLanguages(this.conversionHandler.convertList(LanguageVO.class, (Iterable)object3));
        object3.removeIf(language -> !Objects.equals(language.getNetwork(), network));
        configurationData.setNetworkLanguages(this.conversionHandler.convertList(LanguageVO.class, (Iterable)object3));
        Object object5 = configuration.getDefinedProperties().contains(ConfigurationDTO.COUNTRY.getName()) ? configuration.getCountry() : (object = configurationDTO == null ? null : configurationDTO.getCountry());
        object2 = configuration.getDefinedProperties().contains(ConfigurationDTO.TIME_ZONE_ID.getName()) ? configuration.getTimeZoneId() : (configurationDTO == null ? null : configurationDTO.getTimeZoneId());
        configurationData.setLocalizationData(this.localizationService.getLocalizationData((String)object, (String)object2));
        configurationData.setSmsScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.OUTBOUND_SMS)));
        configurationData.setLinkGenerationScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.LINK_GENERATION)));
        configurationData.setPhoneNumberHandlingScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.PHONE_NUMBER_HANDLING)));
        configurationData.setNotificationScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.NOTIFICATION)));
        configurationData.setIpGeolocationScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.IP_GEOLOCATION)));
        configurationData.setIndividualDocumentDirectories(this.storedFileHandler.getStorageDirectories().stream().sorted().collect(Collectors.toList()));
        if (configuration.getDefaultType() != null) {
            configurationData.setAccountNumberScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.ACCOUNT_NUMBER_GENERATION)));
            configurationData.setCustomSessionScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.SESSION_HANDLING)));
        }
        if (configuration.isPersistent()) {
            configurationData.setGlobalDefault(configuration.getDefaultType() == DefaultConfigurationType.GLOBAL);
            configurationData.setNetworkDefault(configuration.getDefaultType() == DefaultConfigurationType.NETWORK);
            configurationData.setShowLoggingFields(configurationData.isNetworkDefault() || network == null);
            configurationData.setUsedByGroups(this.conversionHandler.convertList(BasicGroupVO.class, (Iterable)this.groupService.getGroupsUsingConfiguration(configuration)));
        }
        ArrayList<UserCustomField> arrayList = new ArrayList<UserCustomField>();
        for (UserCustomField userCustomField : this.userCustomFieldService.listAll()) {
            if (!userCustomField.getType().isEnumerated()) continue;
            arrayList.add(userCustomField);
        }
        configurationData.setMapDirectoryFields(this.conversionHandler.convertList(UserCustomFieldVO.class, arrayList));
        OidcClientData oidcClientData = (OidcClientData)this.oidcClientService.getDataForNew(null);
        configurationData.setUserAccounts(oidcClientData.getAccounts());
        configurationData.setOidcPayments(oidcClientData.getPayments());
        configurationData.setTicketPayments(oidcClientData.getTickets());
        return configurationData;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(ConfigurationDTO configurationDTO) {
        return EXCLUDED_PROPERTIES_FROM_CONVERSION;
    }

    @Override
    protected void onAfterRemove(Configuration configuration) {
        Long l = SimpleEntity.id((SimpleEntity)configuration);
        this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, (SerializablePredicate & Serializable)configurationAccessorCacheKey -> configurationAccessorCacheKey.matchesConfiguration(l));
        this.cacheHandler.scheduleClear(CacheType.REQUEST_DATA);
        this.cacheHandler.scheduleClear(CacheType.MAIL_SENDERS);
    }

    @Override
    protected void onAfterSave(Configuration configuration, Configuration configuration2, Object object) {
        TempImage tempImage;
        if (configuration2 != null) {
            if (!(Objects.equals(configuration.getRootUrl(), configuration2.getRootUrl()) && Objects.equals(configuration.getPath(), configuration2.getPath()) && configuration.isDefineRootUrl() == configuration2.isDefineRootUrl() && Objects.equals(configuration.getApiUrl(), configuration2.getApiUrl()) && configuration.getDefinedProperties().contains(ConfigurationDTO.API_URL.getName()) == configuration2.getDefinedProperties().contains(ConfigurationDTO.API_URL.getName()))) {
                this.cacheHandler.scheduleClear(CacheType.REQUEST_DATA);
                this.updateRootUrl(configuration);
            }
            if (this.hasChangedSenderSettings(configuration.getSmtpConfiguration(), configuration2.getSmtpConfiguration())) {
                this.cacheHandler.scheduleEvict(CacheType.MAIL_SENDERS, (Serializable)configuration.getId());
            }
        }
        TempImage tempImage2 = tempImage = configuration.getDefinedProperties().contains(ConfigurationDTO.DEFAULT_USER_IMAGE.getName()) ? configuration.getUploadedDefaultUserImage() : null;
        if (tempImage != null) {
            this.defaultUserImageService.importTempImage(configuration, tempImage);
        } else if (configuration2 != null && configuration.getDefaultUserImage() == null && configuration2.getDefaultUserImage() != null) {
            this.storedFileHandler.remove(configuration2.getDefaultUserImage().getId().longValue());
        }
    }

    @Override
    protected Object onBeforeSave(Configuration configuration, Configuration configuration2) {
        ProfileField profileField2;
        Object object;
        Configuration configuration3;
        Object object22;
        Object object3;
        Long l;
        if (configuration.getLockedProperties() == null) {
            configuration.setLockedProperties(new HashSet());
        }
        if (configuration.getDefinedProperties() == null) {
            configuration.setDefinedProperties(new HashSet());
        }
        Set set = configuration.getLockedProperties();
        Set set2 = configuration.getDefinedProperties();
        Set set3 = this.configurationHandler.getConfigurableProperties();
        set2.retainAll(set3);
        set.retainAll(set2);
        if (configuration.getDefaultType() == null) {
            set2.remove(ConfigurationDTO.EMAIL_UNIQUE.getName());
            set.remove(ConfigurationDTO.EMAIL_UNIQUE.getName());
            configuration.setEmailUnique(null);
            set2.remove(ConfigurationDTO.MOBILE_UNIQUE.getName());
            set.remove(ConfigurationDTO.MOBILE_UNIQUE.getName());
            configuration.setMobileUnique(null);
            set2.remove(ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION.getName());
            set.remove(ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION.getName());
            configuration.setAccountNumberConfiguration(null);
            set2.remove(ConfigurationDTO.CUSTOM_SESSION_CONFIGURATION.getName());
            set.remove(ConfigurationDTO.CUSTOM_SESSION_CONFIGURATION.getName());
            configuration.setCustomSessionConfiguration(null);
            set2.remove(ConfigurationDTO.MAX_BLOCKED_USERS.getName());
            set.remove(ConfigurationDTO.MAX_BLOCKED_USERS.getName());
            configuration.setMaxBlockedUsers(null);
            set2.remove(ConfigurationDTO.REMOTE_ADDRESS_BLOCK_TIME_BY_BLOCKED_USERS.getName());
            set.remove(ConfigurationDTO.REMOTE_ADDRESS_BLOCK_TIME_BY_BLOCKED_USERS.getName());
            configuration.setRemoteAddressBlockTimeByBlockedUsers(null);
        }
        Date date = new Date();
        if (configuration2 == null) {
            configuration.setImagesLastModified(date);
        } else {
            l = SimpleEntity.id((SimpleEntity)configuration);
            this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, (SerializablePredicate & Serializable)configurationAccessorCacheKey -> configurationAccessorCacheKey.matchesConfiguration(l));
            object3 = configuration2.getDefaultType();
            if (object3 == DefaultConfigurationType.GLOBAL) {
                set2.addAll(set3);
            }
            object22 = this.groupsHandler.accessibles().basicUsers().items();
            if (set2.contains(ConfigurationDTO.GROUPS_FOR_USER_SEARCH.getName())) {
                configuration3 = new HashSet(configuration2.getGroupsForUserSearch());
                configuration3.removeAll((Collection<?>)object22);
                configuration.getGroupsForUserSearch().addAll(configuration3);
            }
            if (set2.contains(ConfigurationDTO.GROUPS_FOR_USER_SEARCH_IN_MENU.getName())) {
                configuration3 = new HashSet(configuration2.getGroupsForUserSearchInMenu());
                configuration3.removeAll((Collection<?>)object22);
                configuration.getGroupsForUserSearchInMenu().addAll(configuration3);
            }
            if (set2.contains(ConfigurationDTO.GROUPS_FOR_VIEW_PROFILE.getName())) {
                configuration3 = new HashSet(configuration2.getGroupsForViewProfile());
                configuration3.removeAll((Collection<?>)object22);
                configuration.getGroupsForViewProfile().addAll(configuration3);
            }
            if (set2.contains(ConfigurationDTO.GROUPS_FOR_USER_DIRECTORY.getName())) {
                configuration3 = new HashSet(configuration2.getGroupsForUserDirectory());
                configuration3.removeAll((Collection<?>)object22);
                configuration.getGroupsForUserDirectory().addAll(configuration3);
            }
            if (set2.contains(ConfigurationDTO.POSSIBLE_INITIAL_GROUPS.getName())) {
                configuration3 = new HashSet(configuration2.getPossibleInitialGroups());
                configuration3.removeAll(this.groupsHandler.flatten((Collection)object22));
                configuration.getPossibleInitialGroups().addAll(configuration3);
            }
            if (set2.contains(ConfigurationDTO.VISIBLE_AD_GROUPS.getName())) {
                configuration3 = new HashSet(configuration2.getVisibleAdGroups());
                configuration3.removeAll((Collection<?>)object22);
                configuration.getVisibleAdGroups().addAll(configuration3);
            }
            if (object3 == DefaultConfigurationType.GLOBAL) {
                set.add(ConfigurationDTO.ROOT_URL.getName());
                set.add(ConfigurationDTO.TASKS_LOGGING_MODE.getName());
                set.add(ConfigurationDTO.MAX_LOG_ENTRIES.getName());
            }
        }
        if (!set2.contains(ConfigurationDTO.GROUPS_FOR_USER_SEARCH.getName())) {
            set2.remove(ConfigurationDTO.COMMUNITY_MENU_LABEL.getName());
        }
        if (!set2.contains(ConfigurationDTO.VISIBLE_AD_GROUPS.getName())) {
            set2.remove(ConfigurationDTO.ALLOW_VIEW_USER_AD.getName());
            set2.remove(ConfigurationDTO.ALLOW_VIEW_USER_WEB_SHOP.getName());
            set2.remove(ConfigurationDTO.MARKETPLACE_MENU_LABEL.getName());
        }
        if (set2.contains(ConfigurationDTO.USER_SEARCH_IN_MENU_MODE.getName()) && configuration.getUserSearchInMenuMode() != UserSearchInMenuMode.SPECIFIC_GROUPS) {
            set2.remove(ConfigurationDTO.GROUPS_FOR_USER_SEARCH_IN_MENU.getName());
        }
        if (set2.contains(ConfigurationDTO.EMAIL_REQUIRED.getName()) && !Boolean.TRUE.equals(configuration.getEmailRequired())) {
            set2.remove(ConfigurationDTO.EMAIL_VALIDATION.getName());
        }
        if (set2.contains(ConfigurationDTO.ADDRESS_CONFIGURATION.getName())) {
            l = configuration.getAddressConfiguration();
            l.getRequiredAddressFields().retainAll(l.getEnabledAddressFields());
        }
        if (set2.contains(ConfigurationDTO.ADDRESS_CONFIGURATION.getName()) && ObjectHelper.isNotOneOf((Object)configuration.getVoucherBuyingMenu(), (Object[])new Object[]{UserMainMenu.BANKING, UserMainMenu.MARKETPLACE})) {
            configuration.setVoucherBuyingMenu(UserMainMenu.BANKING);
        }
        l = InvocationContext.wrap((Object)configuration);
        for (Object object22 : set3) {
            if (set2.contains(object22) || (configuration3 = l.getPropertyType((String)object22)) == null) continue;
            if (Collection.class.isAssignableFrom((Class<?>)configuration3)) {
                object = (Collection)l.getPropertyValue((String)object22);
                if (object == null) continue;
                object.clear();
                continue;
            }
            if (!l.isWritableProperty((String)object22)) continue;
            if (DynamicOidcClientConfiguration.class.isAssignableFrom((Class<?>)configuration3)) {
                l.setPropertyValue((String)object22, new DynamicOidcClientConfiguration());
                continue;
            }
            if (TempImage.class.isAssignableFrom((Class<?>)configuration3)) continue;
            l.setPropertyValue((String)object22, CoercionHelper.coerce((Class)configuration3, null));
        }
        object3 = configuration.getCaptchaConfiguration();
        if (object3 != null) {
            if (object3.getProvider() == CaptchaProvider.INTERNAL) {
                object3.setRecaptchaKey(null);
                object3.setRecaptchaSecret(null);
            } else if (object3.getProvider() == CaptchaProvider.RECAPTCHA_V2) {
                object3.setTextColor(null);
                object3.setTextLength(null);
                object3.setEffect(null);
            }
        }
        if ((object22 = configuration.getDynamicOidcClientConfiguration()) != null) {
            configuration3 = object22.getScopes();
            if (!object22.isEnabled()) {
                configuration3.clear();
                object22.setAccessTokenExpiration(null);
            }
            if (!configuration3.contains(Scope.ACCOUNT_HISTORY) && !configuration3.contains(Scope.ACCOUNT_STATUS)) {
                object22.getAccounts().clear();
            }
            if (!configuration3.contains(Scope.PAYMENT)) {
                object22.getPayments().clear();
            }
            if (!configuration3.contains(Scope.TICKETS)) {
                object22.getTickets().clear();
            }
        }
        configuration.getGuestProfileFields().removeIf(configurationGuestProfileField -> BasicProfileField.ACCOUNT_NUMBER.equals((Object)configurationGuestProfileField.getProfileField()));
        configuration3 = configuration.getParent();
        object = configuration.getRootUrl();
        if (configuration3 != null && (configuration.isGlobal() || !configuration.isDefineRootUrl())) {
            object = configuration3.getRootUrl();
        }
        while (((String)object).endsWith("/") || ((String)object).endsWith("\\")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        configuration.setRootUrl((String)object);
        if (configuration.getDefaultType() != null) {
            configuration.setPath(null);
        }
        if (this.shouldUpdateSitemapLastModified(configuration, configuration2)) {
            this.setSitemapLastModified(configuration, date);
        }
        if (this.shouldUpdateApiDescriptorLastModified(configuration, configuration2)) {
            this.setApiDescriptorLastModified(configuration, date);
        }
        if ((profileField2 = configuration.getProfileFieldInAccountTitle()) instanceof UserCustomField && ((UserCustomField)profileField2).getType().isBinary()) {
            configuration.setProfileFieldInAccountTitle(null);
        }
        CollectionHelper.orEmpty((Set)configuration.getProfileFieldsInAccount()).removeIf(profileField -> profileField instanceof UserCustomField && ((UserCustomField)profileField).getType().isBinary());
        if (Boolean.TRUE.equals(configuration.getGeneratedUsername())) {
            configuration.setUsernameLength(null);
            configuration.setRegexForUsername(null);
        } else {
            configuration.setGeneratedUsernameLength(null);
        }
        if (configuration.getForgotPasswordMode() != ForgotPasswordMode.SECURITY_QUESTION) {
            configuration.setRequireSecurityQuestionOnRegistration(Boolean.valueOf(false));
        }
        if (configuration.getForgotPasswordMode() == ForgotPasswordMode.DISABLED) {
            configuration.setForgotPasswordSendMedium(null);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(ConfigurationDTO configurationDTO, Configuration configuration) {
        configuration.getAccountStatusIndicators().size();
        configuration.getAdFieldsVisibleToGuests().size();
        configuration.getAllowedLanguages().size();
        configuration.getDefinedProperties().size();
        configuration.getEmailValidation().size();
        configuration.getGroupsForUserDirectory().size();
        configuration.getGroupsForUserSearch().size();
        configuration.getGroupsForUserSearchInMenu().size();
        configuration.getGroupsForViewProfile().size();
        configuration.getGuestProfileFields().size();
        configuration.getLockedProperties().size();
        configuration.getPossibleInitialGroups().size();
        configuration.getPrivacyControlledProfileFields().size();
        configuration.getProfileFieldsInAccount().size();
        configuration.getVisibleAdGroups().size();
        configuration.getVisibleAdCategories().size();
        configuration.getDefaultUserImage();
        if (configuration.getAddressConfiguration() != null) {
            configuration.getAddressConfiguration().getEnabledAddressFields().size();
            configuration.getAddressConfiguration().getRequiredAddressFields().size();
        }
        configuration.getDefinedProperties().size();
        configuration.getLockedProperties().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QConfiguration)this.$).network(), true);
        networkPathRegistry.register(QChannelConfiguration.channelConfiguration.configuration().network(), true);
        networkPathRegistry.register(QConfigurationGuestProfileField.configurationGuestProfileField.configuration().network(), true);
    }

    @Override
    protected Validator resolveValidator(ConfigurationDTO configurationDTO) {
        Object object4;
        DynamicOidcClientConfigurationDTO dynamicOidcClientConfigurationDTO;
        org.cyclos.impl.utils.validation.Property property6;
        Language language;
        org.cyclos.impl.utils.validation.Property property2;
        Object object5;
        org.cyclos.impl.utils.validation.Property property3;
        Validator validator = new Validator();
        validator.property(ConfigurationDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        Configuration configuration = configurationDTO.isTransient() ? null : (Configuration)this.find(configurationDTO.getId());
        Configuration configuration2 = null;
        if (configuration == null) {
            Long l = EntityVO.id((EntityVO)configurationDTO.getParent());
            if (l != null) {
                configuration2 = (Configuration)this.rawEntityManagerHandler.find(Configuration.class, l);
            }
        } else {
            configuration2 = configuration.getParent();
        }
        boolean bl = configuration != null && configuration.getDefaultType() == DefaultConfigurationType.GLOBAL;
        org.cyclos.impl.utils.validation.Property property5 = validator.property((Property)ConfigurationDTO.PARENT, SystemKeys.Configurations.PARENT);
        if (configurationDTO.isTransient()) {
            property5.required();
        }
        validator.property((Property)ConfigurationDTO.APPLICATION_NAME, SystemKeys.Configurations.APPLICATION_NAME).maxLength(100);
        validator.property((Property)ConfigurationDTO.APPLICATION_DESCRIPTION, SystemKeys.Configurations.APPLICATION_DESCRIPTION).maxLength(300);
        validator.property((Property)ConfigurationDTO.APPLICATION_USERNAME, SystemKeys.Configurations.APPLICATION_USERNAME).maxLength(100);
        validator.property((Property)ConfigurationDTO.TIME_ZONE_ID, SystemKeys.Configurations.TIME_ZONE_ID).anyOf((Collection)this.localizationService.listTimeZoneIds());
        Set set = CollectionHelper.orEmpty((Set)configurationDTO.getDefinedProperties());
        for (Map.Entry<Property<?, ?>, MessageKey> property42 : REQUIRED_PROPERTIES.entrySet()) {
            if (!bl && !set.contains(property42.getKey().getName())) continue;
            validator.property(property42.getKey(), property42.getValue()).required();
        }
        Runnable runnable = () -> {
            if (set.contains(ConfigurationDTO.USERNAME_LENGTH.getName())) {
                org.cyclos.impl.utils.validation.Property property = validator.property((Property)ConfigurationDTO.USERNAME_LENGTH, SystemKeys.Configurations.USERNAME_LENGTH);
                property.range(RangeOptionalType.BOTH_OPTIONAL);
                property.nested((Property)IntegerRangeDTO.MIN, GeneralKeys.Ui.RANGE_MIN).greaterEquals((Comparable)Integer.valueOf(2));
                property.nested((Property)IntegerRangeDTO.MAX, GeneralKeys.Ui.RANGE_MAX).lessEquals((Comparable)Integer.valueOf(50));
            }
        };
        if (set.contains(ConfigurationDTO.GENERATED_USERNAME_LENGTH.getName())) {
            if (Boolean.TRUE.equals(configurationDTO.getGeneratedUsername())) {
                validator.property((Property)ConfigurationDTO.GENERATED_USERNAME_LENGTH, SystemKeys.Configurations.GENERATED_USERNAME_LENGTH).between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(50));
            } else {
                runnable.run();
            }
        } else {
            runnable.run();
        }
        validator.property((Property)ConfigurationDTO.REGEX_FOR_USERNAME, SystemKeys.Configurations.REGEX_FOR_USERNAME).maxLength(500);
        validator.property((Property)ConfigurationDTO.COUNTRY, SystemKeys.Configurations.COUNTRY).anyOf((Collection)this.localizationService.listCountryCodes());
        if (set.contains(ConfigurationDTO.MAX_RESULTS.getName())) {
            org.cyclos.impl.utils.validation.Property property4 = validator.property((Property)ConfigurationDTO.MAX_RESULTS, SystemKeys.Configurations.MAX_RESULTS);
            property4.lessEquals((Comparable)Integer.valueOf(99999));
            property4.greaterEquals((Comparable)Integer.valueOf(40));
        }
        if (bl) {
            validator.property((Property)ConfigurationDTO.MAX_LOG_ENTRIES, SystemKeys.Configurations.MAX_LOG_ENTRIES).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1000000)).required();
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration2, null, false);
        if (set.contains(ConfigurationDTO.MAX_RESULTS_ON_MAP.getName())) {
            validator.property((Property)ConfigurationDTO.MAX_RESULTS_ON_MAP, SystemKeys.Configurations.MAX_RESULTS_ON_MAP).lessEquals((Comparable)Integer.valueOf(99999));
        }
        if (set.contains(ConfigurationDTO.DEFAULT_MAP_LOCATION.getName())) {
            validator.property((Property)ConfigurationDTO.DEFAULT_MAP_LOCATION, SystemKeys.Configurations.DEFAULT_MAP_LOCATION).latLong();
        }
        if (set.contains(ConfigurationDTO.DEFAULT_MAP_ZOOM_WEB.getName())) {
            validator.property((Property)ConfigurationDTO.DEFAULT_MAP_ZOOM_WEB, SystemKeys.Configurations.DEFAULT_MAP_ZOOM_WEB).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20));
        }
        if (set.contains(ConfigurationDTO.DEFAULT_MAP_ZOOM_MOBILE.getName())) {
            validator.property((Property)ConfigurationDTO.DEFAULT_MAP_ZOOM_MOBILE, SystemKeys.Configurations.DEFAULT_MAP_ZOOM_MOBILE).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20));
        }
        if (set.contains(ConfigurationDTO.MAP_DIRECTORY_FIELD.getName())) {
            validator.property((Property)ConfigurationDTO.MAP_DIRECTORY_FIELD, SystemKeys.Configurations.MAP_DIRECTORY_FIELD).entity(UserCustomField.class, (EntityValidation)new BaseEntityValidation<UserCustomField>(){

                protected boolean isValid(Object object, Object object2, UserCustomField userCustomField) {
                    return userCustomField.getType().isEnumerated();
                }
            });
        }
        if (set.contains(ConfigurationDTO.ADS_RESULT_TYPE.getName())) {
            validator.property((Property)ConfigurationDTO.ADS_RESULT_TYPE, SystemKeys.Configurations.ADS_RESULT_TYPE).add((object, object2, object3) -> {
                if (configurationDTO.getAdsResultType() == ResultType.MAP && (configurationDTO.getUseMap() != null && !configurationDTO.getUseMap().booleanValue() || !configurationAccessor.isUseMap())) {
                    return new ValidationError(SystemKeys.Configurations.INVALID_AD_MAP_RESULT_TYPE);
                }
                return null;
            });
        }
        if (set.contains(ConfigurationDTO.USERS_RESULT_TYPE.getName())) {
            validator.property((Property)ConfigurationDTO.USERS_RESULT_TYPE, SystemKeys.Configurations.USERS_RESULT_TYPE).add((object, object2, object3) -> {
                if (configurationDTO.getUsersResultType() == ResultType.MAP && (configurationDTO.getUseMap() != null && !configurationDTO.getUseMap().booleanValue() || !configurationAccessor.isUseMap())) {
                    return new ValidationError(SystemKeys.Configurations.INVALID_USER_MAP_RESULT_TYPE);
                }
                return null;
            });
        }
        if (set.contains(ConfigurationDTO.ALLOWED_LANGUAGES.getName())) {
            Object object6;
            property3 = new HashSet();
            object5 = this.conversionHandler.convertSet(Language.class, (Iterable)configurationDTO.getAllowedLanguages());
            property2 = validator.property((Property)ConfigurationDTO.ALLOWED_LANGUAGES, SystemKeys.Configurations.ALLOWED_LANGUAGES);
            Iterator iterator = object5.iterator();
            while (iterator.hasNext()) {
                object6 = (Language)iterator.next();
                if (property3.add(object6.getTemplate())) continue;
                property2.invalid(SystemKeys.Configurations.ERROR_DUPLICATE_LOCALE_IN_ALLOWED_LANGUAGES);
                break;
            }
            Network network = this.getSessionData().getNetwork();
            object6 = object5.iterator();
            while (object6.hasNext()) {
                language = (Language)object6.next();
                if (Objects.equals(language.getNetwork(), network)) continue;
                property2.invalid();
                break;
            }
        }
        property3 = validator.property((Property)ConfigurationDTO.ROOT_URL, SystemKeys.Configurations.ROOT_URL);
        property3.url().maxLength(255);
        if (bl || configurationDTO.isDefineRootUrl()) {
            property3.required();
            object5 = configurationDTO.getRootUrl();
        } else {
            object5 = configuration2.getRootUrl();
        }
        if (object5 != null) {
            try {
                for (org.cyclos.impl.utils.validation.Property property6 : property2 = new URL((String)object5).getPath().split("/")) {
                    if (!ReservedUris.isReserved((String)property6)) continue;
                    property3.invalid(SystemKeys.Configurations.ERROR_ROOT_URL_CONTAINS_RESERVED_WORD);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            property2 = validator.property((Property)ConfigurationDTO.PATH, SystemKeys.Configurations.PATH).regex("^[\\w\\.\\-\\+\\/]+$").noneOf((Collection)ReservedUris.all());
            String string = configurationDTO.getPath();
            if (StringUtils.contains((CharSequence)string, (CharSequence)"/")) {
                property2.invalid(SystemKeys.Configurations.ERROR_INVALID_PATH);
            } else if (!bl && (configurationDTO.isDefineRootUrl() || StringHelper.isNotBlank((Object)string))) {
                DBQuery dBQuery = (DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where(new Predicate[]{((QConfiguration)this.$).rootUrl.eq(object5), string == null ? ((QConfiguration)this.$).path.isNull() : ((QConfiguration)this.$).path.eq((Object)string), ((QConfiguration)this.$).defineRootUrl.isTrue(), configurationDTO.isPersistent() ? ((QConfiguration)this.$).id.ne((Object)configurationDTO.getId()) : ((QConfiguration)this.$).id.isNotNull()});
                if (StringHelper.isBlank((Object)string)) {
                    property3.unique("configurationUrl_" + (String)object5, (AbstractJPAQuery)dBQuery);
                } else {
                    property2.unique("configurationUrl_" + (String)object5 + "/" + string, (AbstractJPAQuery)dBQuery);
                }
            }
        }
        validator.property((Property)ConfigurationDTO.API_URL, SystemKeys.Configurations.API_URL).url();
        validator.property((Property)ConfigurationDTO.JPEG_QUALITY, SystemKeys.Configurations.JPEG_QUALITY).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100));
        if (set.contains(ConfigurationDTO.USER_FORMAT_FOR_MANAGERS.getName())) {
            property2 = validator.property((Property)ConfigurationDTO.USER_FORMAT_FOR_MANAGERS, SystemKeys.Configurations.USER_FORMAT_FOR_MANAGERS);
            property2.nested((Property)UserFormatConfigurationDTO.SEPARATOR, SystemKeys.Configurations.USER_FORMAT_SEPARATOR).required();
            property2.nested((Property)UserFormatConfigurationDTO.PROFILE_FIELDS, SystemKeys.Configurations.USER_FORMAT_FIELDS).required().maxElements(5);
        }
        if (set.contains(ConfigurationDTO.USER_FORMAT_FOR_OTHERS.getName())) {
            property2 = validator.property((Property)ConfigurationDTO.USER_FORMAT_FOR_OTHERS, SystemKeys.Configurations.USER_FORMAT_FOR_OTHERS);
            property2.nested((Property)UserFormatConfigurationDTO.SEPARATOR, SystemKeys.Configurations.USER_FORMAT_SEPARATOR).required();
            property2.nested((Property)UserFormatConfigurationDTO.PROFILE_FIELDS, SystemKeys.Configurations.USER_FORMAT_FIELDS).required().maxElements(5);
        }
        property2 = configurationDTO.getAccountNumberConfiguration();
        if (set.contains(ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION.getName()) && property2 != null && property2.isEnabled()) {
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION, (Property)AccountNumberConfigurationDTO.SCRIPT), SystemKeys.Configurations.ACCOUNT_NUMBER_SCRIPT).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                    return customScript.getType() == ScriptType.ACCOUNT_NUMBER_GENERATION;
                }
            });
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION, (Property)AccountNumberConfigurationDTO.MASK), SystemKeys.Configurations.ACCOUNT_NUMBER_MASK).mask(2);
        }
        CaptchaConfigurationDTO captchaConfigurationDTO = configurationDTO.getCaptchaConfiguration();
        if (set.contains(ConfigurationDTO.CAPTCHA_CONFIGURATION.getName()) && captchaConfigurationDTO != null) {
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.CAPTCHA_CONFIGURATION, (Property)CaptchaConfigurationDTO.PROVIDER), SystemKeys.Configurations.CAPTCHA_PROVIDER).required();
            if (captchaConfigurationDTO.getProvider() == CaptchaProvider.INTERNAL) {
                validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.CAPTCHA_CONFIGURATION, (Property)CaptchaConfigurationDTO.TEXT_LENGTH), SystemKeys.Configurations.CAPTCHA_TEXT_LENGTH).required().between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(12));
                validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.CAPTCHA_CONFIGURATION, (Property)CaptchaConfigurationDTO.TEXT_COLOR), SystemKeys.Configurations.CAPTCHA_TEXT_COLOR).required().color();
                validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.CAPTCHA_CONFIGURATION, (Property)CaptchaConfigurationDTO.EFFECT), SystemKeys.Configurations.CAPTCHA_EFFECT).required();
            } else if (captchaConfigurationDTO.getProvider() == CaptchaProvider.RECAPTCHA_V2) {
                validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.CAPTCHA_CONFIGURATION, (Property)CaptchaConfigurationDTO.RECAPTCHA_KEY), SystemKeys.Configurations.CAPTCHA_RECAPTCHA_KEY).required();
                if (captchaConfigurationDTO.isRecaptchaSecretSet()) {
                    validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.CAPTCHA_CONFIGURATION, (Property)CaptchaConfigurationDTO.RECAPTCHA_SECRET), SystemKeys.Configurations.CAPTCHA_RECAPTCHA_SECRET).required();
                }
            }
        }
        CustomSessionConfigurationDTO customSessionConfigurationDTO = configurationDTO.getCustomSessionConfiguration();
        if (set.contains(ConfigurationDTO.CUSTOM_SESSION_CONFIGURATION.getName()) && customSessionConfigurationDTO != null && customSessionConfigurationDTO.isEnabled()) {
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.CUSTOM_SESSION_CONFIGURATION, (Property)CustomSessionConfigurationDTO.SCRIPT), SystemKeys.Configurations.CUSTOM_SESSION_SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                    return customScript.getType() == ScriptType.SESSION_HANDLING;
                }
            });
        }
        language = configurationDTO.getLinkGenerationConfiguration();
        if (set.contains(ConfigurationDTO.LINK_GENERATION_CONFIGURATION.getName()) && language != null) {
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.LINK_GENERATION_CONFIGURATION, (Property)CustomScriptConfigurationDTO.SCRIPT), SystemKeys.Configurations.LINK_GENERATION_SCRIPT).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                    return customScript.getType() == ScriptType.LINK_GENERATION;
                }
            });
        }
        property6 = configurationDTO.getNotificationConfiguration();
        if (set.contains(ConfigurationDTO.NOTIFICATION_CONFIGURATION.getName()) && property6 != null) {
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.NOTIFICATION_CONFIGURATION, (Property)CustomScriptConfigurationDTO.SCRIPT), SystemKeys.Configurations.NOTIFICATION_SCRIPT).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                    return customScript.getType() == ScriptType.NOTIFICATION;
                }
            });
        }
        if (bl || set.contains(ConfigurationDTO.SMTP_CONFIGURATION.getName())) {
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.SMTP_CONFIGURATION, (Property)SmtpConfigurationDTO.HOST), SystemKeys.Configurations.SMTP_HOST).required().internetAddress();
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.SMTP_CONFIGURATION, (Property)SmtpConfigurationDTO.PORT), SystemKeys.Configurations.SMTP_PORT).required().positiveIntegerNonZero();
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.SMTP_CONFIGURATION, (Property)SmtpConfigurationDTO.FROM_ADDRESS), SystemKeys.Configurations.SMTP_FROM_ADDRESS).required().email();
        }
        OutboundSmsConfigurationDTO outboundSmsConfigurationDTO = configurationDTO.getOutboundSmsConfiguration();
        if (set.contains(ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION.getName()) && outboundSmsConfigurationDTO != null && outboundSmsConfigurationDTO.isEnabled()) {
            Matcher matcher;
            dynamicOidcClientConfigurationDTO = validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION, (Property)OutboundSmsConfigurationDTO.GATEWAY_URL), SystemKeys.Configurations.SMS_GATEWAY_URL).maxLength(255);
            object4 = outboundSmsConfigurationDTO.getGatewayUrl();
            if (StringHelper.isNotBlank((Object)object4)) {
                matcher = StringHelper.VARIABLE_PATTERN.matcher((CharSequence)object4);
                StringBuffer stringBuffer = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(matcher.group(1)));
                }
                matcher.appendTail(stringBuffer);
                if (!UrlValidation.isValid((String)stringBuffer.toString())) {
                    dynamicOidcClientConfigurationDTO.invalid();
                }
            }
            if (outboundSmsConfigurationDTO.getScript() == null) {
                dynamicOidcClientConfigurationDTO.required();
            } else {
                validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION, (Property)OutboundSmsConfigurationDTO.SCRIPT), SystemKeys.Configurations.SMS_SCRIPT).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                    protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                        return customScript.getType() == ScriptType.OUTBOUND_SMS;
                    }
                });
            }
            matcher = validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION, (Property)OutboundSmsConfigurationDTO.ENCODING), SystemKeys.Configurations.SMS_ENCODING).characterEncoding();
            if (!outboundSmsConfigurationDTO.isAsciiOnly()) {
                matcher.required();
            }
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION, (Property)OutboundSmsConfigurationDTO.MAX_MESSAGES_PER_MONTH), SystemKeys.Configurations.SMS_MAX_MESSAGES_PER_MONTH).positiveOrZero();
        }
        dynamicOidcClientConfigurationDTO = configurationDTO.getDynamicOidcClientConfiguration();
        if (set.contains(ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION.getName()) && dynamicOidcClientConfigurationDTO != null && dynamicOidcClientConfigurationDTO.isEnabled()) {
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION, (Property)DynamicOidcClientConfigurationDTO.SCOPES), AccessKeys.OidcClients.SCOPES).required();
            object4 = CollectionHelper.orEmpty((Set)dynamicOidcClientConfigurationDTO.getScopes());
            if (object4.contains(Scope.ACCOUNT_HISTORY) || object4.contains(Scope.ACCOUNT_STATUS)) {
                validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION, (Property)DynamicOidcClientConfigurationDTO.ACCOUNTS), AccessKeys.OidcClients.ACCOUNTS).required();
            }
            if (object4.contains(Scope.PAYMENT)) {
                validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION, (Property)DynamicOidcClientConfigurationDTO.PAYMENTS), AccessKeys.OidcClients.PAYMENTS).required();
            }
            if (object4.contains(Scope.TICKETS)) {
                validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION, (Property)DynamicOidcClientConfigurationDTO.TICKETS), AccessKeys.OidcClients.TICKETS).required();
            }
            validator.property((Property)NestedProperty.nested((Property)ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION, (Property)DynamicOidcClientConfigurationDTO.ACCESS_TOKEN_EXPIRATION), AccessKeys.OidcClients.ACCESS_TOKEN_EXPIRATION).required().positiveIntegerNonZero().timeInterval();
        }
        validator.property((Property)ConfigurationDTO.PROFILE_FIELD_IN_ACCOUNT_TITLE, SystemKeys.Configurations.PROFILE_FIELDS_ACCOUNT_TITLE).noneOf(new Object[]{BasicProfileField.ADDRESS, BasicProfileField.IMAGE});
        validator.property((Property)ConfigurationDTO.PROFILE_FIELDS_IN_ACCOUNT, SystemKeys.Configurations.PROFILE_FIELDS_IN_ACCOUNT).noneOf(new Object[]{BasicProfileField.ADDRESS, BasicProfileField.IMAGE});
        validator.property((Property)ConfigurationDTO.PLAY_STORE_URL_MOBILE, SystemKeys.Configurations.PLAY_STORE_URL_MOBILE).url().maxLength(255);
        validator.property((Property)ConfigurationDTO.APPLE_STORE_URL_MOBILE, SystemKeys.Configurations.APPLE_STORE_URL_MOBILE).url().maxLength(255);
        validator.property((Property)ConfigurationDTO.LOGIN_URL, SystemKeys.Configurations.LOGIN_URL).url().maxLength(255);
        validator.property((Property)ConfigurationDTO.LOGOUT_URL, SystemKeys.Configurations.LOGOUT_URL).url().maxLength(255);
        validator.property((Property)ConfigurationDTO.REMOTE_ADDRESS_BLOCK_TIME, SystemKeys.Configurations.REMOTE_ADDRESS_BLOCK_TIME).timeInterval();
        validator.property((Property)ConfigurationDTO.REMOTE_ADDRESS_BLOCK_TIME_BY_BLOCKED_USERS, SystemKeys.Configurations.REMOTE_ADDRESS_BLOCK_TIME_BY_BLOCKED_USERS).timeInterval();
        if (set.contains(ConfigurationDTO.GROUPS_FOR_USER_SEARCH_IN_MENU.getName()) && set.contains(ConfigurationDTO.GROUPS_FOR_USER_SEARCH.getName()) && !CollectionHelper.containsAll((Collection)this.groupsHandler.flattenVOs((Collection)configurationDTO.getGroupsForUserSearchInMenu()), (Collection)this.groupsHandler.flattenVOs((Collection)configurationDTO.getGroupsForUserSearch()))) {
            validator.property((Property)ConfigurationDTO.GROUPS_FOR_USER_SEARCH, SystemKeys.Configurations.GROUPS_FOR_USER_SEARCH).invalid(SystemKeys.Configurations.ERROR_INVALID_GROUPS_FOR_USER_SEARCH_FOR_GUEST);
        }
        if (configurationDTO.isFirebasePrivateKeySet() && StringHelper.isNotBlank((Object)configurationDTO.getFirebasePrivateKey())) {
            validator.property((Property)ConfigurationDTO.FIREBASE_PRIVATE_KEY, SystemKeys.Configurations.FIREBASE_PRIVATE_KEY).add((object, object2, object3) -> {
                try {
                    this.appNotificationHandler.instantiateApp(configurationDTO.getFirebasePrivateKey());
                    return null;
                }
                catch (Exception exception) {
                    this.getLogger().error("Invalid Firebase JSON private key", (Throwable)exception);
                    AppNotificationException appNotificationException = (AppNotificationException)ExceptionHelper.findCause((Throwable)exception, AppNotificationException.class);
                    if (appNotificationException != null) {
                        return ValidationErrors.invalid();
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new RuntimeException(exception);
                }
            });
        }
        validator.property((Property)ConfigurationDTO.PRIVACY_CONTROLLED_PROFILE_FIELDS, SystemKeys.Configurations.PRIVACY_CONTROLLED_PROFILE_FIELDS).noneOf(new Object[]{BasicProfileField.IMAGE});
        return validator;
    }

    private ConfigurationDTO anyToDTO(Object object) {
        Object object2;
        UserFormatConfigurationDTO userFormatConfigurationDTO;
        Collection collection;
        CaptchaConfiguration captchaConfiguration;
        OutboundSmsConfiguration outboundSmsConfiguration;
        ConfigurationDTO configurationDTO = (ConfigurationDTO)this.conversionHandler.convertExcluding(ConfigurationDTO.class, object, EXCLUDED_PROPERTIES_FROM_CONVERSION);
        BeanWrapper beanWrapper = InvocationContext.wrap((Object)object);
        SmtpConfiguration smtpConfiguration = (SmtpConfiguration)beanWrapper.getPropertyValue(ConfigurationDTO.SMTP_CONFIGURATION.getName());
        if (smtpConfiguration != null) {
            outboundSmsConfiguration = (SmtpConfigurationDTO)this.conversionHandler.convertExcluding(SmtpConfigurationDTO.class, (Object)smtpConfiguration, new Object[]{SmtpConfigurationDTO.PASSWORD});
            configurationDTO.setSmtpConfiguration((SmtpConfigurationDTO)outboundSmsConfiguration);
        }
        if ((outboundSmsConfiguration = (OutboundSmsConfiguration)beanWrapper.getPropertyValue(ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION.getName())) != null) {
            captchaConfiguration = (OutboundSmsConfigurationDTO)this.conversionHandler.convertExcluding(OutboundSmsConfigurationDTO.class, (Object)outboundSmsConfiguration, new Object[]{OutboundSmsConfigurationDTO.PASSWORD});
            configurationDTO.setOutboundSmsConfiguration((OutboundSmsConfigurationDTO)captchaConfiguration);
            if (StringHelper.isBlank((Object)captchaConfiguration.getEncoding())) {
                captchaConfiguration.setEncoding("UTF-8");
            }
        }
        if ((captchaConfiguration = (CaptchaConfiguration)beanWrapper.getPropertyValue(ConfigurationDTO.CAPTCHA_CONFIGURATION.getName())) != null) {
            collection = (CaptchaConfigurationDTO)this.conversionHandler.convertExcluding(CaptchaConfigurationDTO.class, (Object)captchaConfiguration, new Object[]{CaptchaConfigurationDTO.RECAPTCHA_SECRET});
            configurationDTO.setCaptchaConfiguration((CaptchaConfigurationDTO)collection);
        }
        if (configurationDTO.getDefinedProperties().contains(ConfigurationDTO.GUEST_PROFILE_FIELDS.getName())) {
            collection = (Collection)beanWrapper.getPropertyValue(ConfigurationDTO.GUEST_PROFILE_FIELDS.getName());
            userFormatConfigurationDTO = this.toGuestProfileFieldsDTOs(collection);
            configurationDTO.setGuestProfileFields(userFormatConfigurationDTO);
        } else {
            configurationDTO.setGuestProfileFields(null);
        }
        collection = (UserFormatConfiguration)beanWrapper.getPropertyValue(ConfigurationDTO.USER_FORMAT_FOR_MANAGERS.getName());
        if (collection != null) {
            userFormatConfigurationDTO = new UserFormatConfigurationDTO();
            userFormatConfigurationDTO.setSeparator(collection.getSeparator());
            userFormatConfigurationDTO.setProfileFields(this.profileFieldHandler.toVOs((Collection)collection.getProfileFields()));
            configurationDTO.setUserFormatForManagers(userFormatConfigurationDTO);
        }
        if ((userFormatConfigurationDTO = (UserFormatConfiguration)beanWrapper.getPropertyValue(ConfigurationDTO.USER_FORMAT_FOR_OTHERS.getName())) != null) {
            object2 = new UserFormatConfigurationDTO();
            object2.setSeparator(userFormatConfigurationDTO.getSeparator());
            object2.setProfileFields(this.profileFieldHandler.toVOs((Collection)userFormatConfigurationDTO.getProfileFields()));
            configurationDTO.setUserFormatForOthers(object2);
        }
        configurationDTO.setDefaultUserImage((ImageVO)this.conversionHandler.convert(ImageVO.class, beanWrapper.getPropertyValue(ConfigurationDTO.DEFAULT_USER_IMAGE.getName())));
        object2 = (Collection)beanWrapper.getPropertyValue(ConfigurationDTO.PRIVACY_CONTROLLED_PROFILE_FIELDS.getName());
        configurationDTO.setPrivacyControlledProfileFields(new HashSet(this.profileFieldHandler.toVOs((Collection)object2)));
        Collection collection2 = (Collection)beanWrapper.getPropertyValue(ConfigurationDTO.PROFILE_FIELDS_IN_ACCOUNT.getName());
        configurationDTO.setProfileFieldsInAccount(new HashSet(this.profileFieldHandler.toVOs(collection2)));
        configurationDTO.setProfileFieldInAccountTitle(this.profileFieldHandler.toVO((ProfileField)beanWrapper.getPropertyValue(ConfigurationDTO.PROFILE_FIELD_IN_ACCOUNT_TITLE.getName())));
        return configurationDTO;
    }

    private <T> DBQuery<T> applyNetwork(DBQuery<T> dBQuery) {
        SessionData sessionData = this.getSessionData();
        Network network = sessionData.getNetwork();
        dBQuery.where((Predicate)(network == null ? ((QConfiguration)this.$).network().isNull() : ((QConfiguration)this.$).network().eq((Object)network)));
        return dBQuery;
    }

    private void filterByVisibleConfigurations(QConfiguration qConfiguration, DBQuery<?> dBQuery) {
        AdminProductAccessor adminProductAccessor = this.getSessionData().getProducts().admin();
        List list = adminProductAccessor.getManageSpecificConfigurations().stream().map(SimpleEntity::getId).collect(Collectors.toList());
        if (!this.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) && list.isEmpty()) {
            dBQuery.where((Predicate)qConfiguration.id.isNull());
        } else if (!this.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW)) {
            dBQuery.where((Predicate)qConfiguration.id.in(list));
        }
    }

    private ConfigurationGuestProfileFieldDTO getGuestProfileField(ProfileField profileField, Collection<ConfigurationGuestProfileField> collection) {
        return CollectionHelper.orEmpty(collection).stream().filter(configurationGuestProfileField -> profileField.equals((Object)configurationGuestProfileField.getProfileField())).findFirst().map(configurationGuestProfileField -> {
            ConfigurationGuestProfileFieldDTO configurationGuestProfileFieldDTO = (ConfigurationGuestProfileFieldDTO)this.conversionHandler.convertExcluding(ConfigurationGuestProfileFieldDTO.class, configurationGuestProfileField, new Object[]{ConfigurationGuestProfileFieldDTO.PROFILE_FIELD});
            configurationGuestProfileFieldDTO.setProfileField(this.profileFieldHandler.toVO(configurationGuestProfileField.getProfileField()));
            return configurationGuestProfileFieldDTO;
        }).orElseGet(() -> null);
    }

    private boolean hasChangedSenderSettings(SmtpConfiguration smtpConfiguration, SmtpConfiguration smtpConfiguration2) {
        if (smtpConfiguration == null && smtpConfiguration2 == null) {
            return false;
        }
        if (smtpConfiguration == null ^ smtpConfiguration2 == null) {
            return true;
        }
        return !Objects.equals(smtpConfiguration.getHost(), smtpConfiguration2.getHost()) || !Objects.equals(smtpConfiguration.getPassword(), smtpConfiguration2.getPassword()) || !Objects.equals(smtpConfiguration.getPort(), smtpConfiguration2.getPort()) || !Objects.equals(smtpConfiguration.getSecurity(), smtpConfiguration2.getSecurity()) || !Objects.equals(smtpConfiguration.getUser(), smtpConfiguration2.getUser());
    }

    private boolean isDefinedChanged(Configuration configuration, Configuration configuration2, String string) {
        Set set = configuration.getDefinedProperties();
        Set set2 = configuration2.getDefinedProperties();
        return set2.contains(string) && !set.contains(string);
    }

    private boolean isLockedChanged(Configuration configuration, Configuration configuration2, String string) {
        Set set = configuration.getLockedProperties();
        Set set2 = configuration2.getLockedProperties();
        return set2.contains(string) && !set.contains(string);
    }

    private boolean removeFromGroup(UserGroup userGroup, SetPath<BasicGroup, QBasicGroup> setPath) {
        List list = ((DBQuery)this.from().where((Predicate)setPath.contains((Object)userGroup))).list((Expression)this.$);
        String string = PropertyHelper.getPropertyName(setPath);
        for (Configuration configuration : list) {
            Set set = (Set)InvocationContext.wrap((Object)configuration).getPropertyValue(string);
            set.remove(userGroup);
        }
        return !list.isEmpty();
    }

    private org.cyclos.model.system.languages.DateFormat resolveDateFormat(Locale locale) {
        String string = DateFormat.getDateInstance(3, locale).format(new GregorianCalendar(2000, 11, 31).getTime()).replaceAll("\\s+", "");
        Matcher matcher = Pattern.compile("\\w+(^\\w).*").matcher(string);
        char c = matcher.find() ? (char)matcher.group(1).charAt(0) : (char)'-';
        int n = string.indexOf("00");
        int n2 = string.indexOf("12");
        int n3 = string.indexOf("31");
        String string2 = n < 0 || n2 < 0 || n3 < 0 || n < n2 ? "YMD" : (n2 < n3 ? "MDY" : "DMY");
        try {
            return org.cyclos.model.system.languages.DateFormat.forOrderAndSeparator((String)string2, (char)c);
        }
        catch (Exception exception) {
            return org.cyclos.model.system.languages.DateFormat.YMD_DASH;
        }
    }

    private NumberFormat resolveNumberFormat(Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        try {
            return NumberFormat.fromDecimalSeparator((char)decimalFormatSymbols.getDecimalSeparator());
        }
        catch (Exception exception) {
            return NumberFormat.PERIOD_AS_DECIMAL;
        }
    }

    private TimeFormat resolveTimeFormat(Locale locale) {
        String string = DateFormat.getTimeInstance(3, locale).format(new GregorianCalendar(2000, 11, 31, 16, 15).getTime()).replaceAll("\\s+", "");
        boolean bl = string.contains("16");
        return bl ? TimeFormat.H24 : TimeFormat.H12;
    }

    private void setApiDescriptorLastModified(Configuration configuration, Date date) {
        configuration.setApiDescriptorLastModified(date);
        for (Configuration configuration2 : configuration.getChildren()) {
            this.setApiDescriptorLastModified(configuration2, date);
        }
    }

    private void setSitemapLastModified(Configuration configuration, Date date) {
        configuration.setSitemapLastModified(date);
        for (Configuration configuration2 : configuration.getChildren()) {
            this.setSitemapLastModified(configuration2, date);
        }
    }

    private boolean shouldUpdateApiDescriptorLastModified(Configuration configuration, Configuration configuration2) {
        if (configuration2 == null) {
            return true;
        }
        boolean bl = false;
        if (configuration2 != null) {
            String string = ConfigurationDTO.APPLICATION_NAME.getName();
            if (this.isLockedChanged(configuration, configuration2, string) || this.isDefinedChanged(configuration, configuration2, string) || !Objects.equals(configuration.getApplicationName(), configuration2.getApplicationName())) {
                bl = true;
            }
            if (!(bl || !this.isDefinedChanged(configuration, configuration2, ConfigurationDTO.ROOT_URL.getName()) && Objects.equals(configuration.getRootUrl(), configuration2.getRootUrl()))) {
                bl = true;
            }
            if (!bl && !Objects.equals(configuration.getPath(), configuration2.getPath())) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean shouldUpdateSitemapLastModified(Configuration configuration, Configuration configuration2) {
        String string = ConfigurationDTO.APPLICATION_NAME.getName();
        return configuration2 == null || this.isLockedChanged(configuration, configuration2, string) || this.isDefinedChanged(configuration, configuration2, string) || !Objects.equals(configuration.getApplicationName(), configuration2.getApplicationName()) || !Objects.equals(configuration.getApplicationDescription(), configuration2.getApplicationDescription());
    }

    private List<ConfigurationGuestProfileFieldDTO> toGuestProfileFieldsDTOs(Collection<ConfigurationGuestProfileField> collection) {
        ArrayList<ConfigurationGuestProfileFieldDTO> arrayList = new ArrayList<ConfigurationGuestProfileFieldDTO>();
        for (ProfileField profileField : this.profileFieldHandler.getAllProfileFields()) {
            if (BasicProfileField.ACCOUNT_NUMBER.equals((Object)profileField)) continue;
            ConfigurationGuestProfileFieldDTO configurationGuestProfileFieldDTO = this.getGuestProfileField(profileField, collection);
            if (configurationGuestProfileFieldDTO == null) {
                configurationGuestProfileFieldDTO = new ConfigurationGuestProfileFieldDTO();
                configurationGuestProfileFieldDTO.setProfileField(this.profileFieldHandler.toVO(profileField));
            }
            arrayList.add(configurationGuestProfileFieldDTO);
        }
        return arrayList;
    }

    private void updateRootUrl(Configuration configuration) {
        for (Configuration configuration2 : configuration.getChildren()) {
            if (configuration2.isDefineRootUrl()) continue;
            configuration2.setRootUrl(configuration.getRootUrl());
            this.updateRootUrl(configuration2);
        }
    }

    static {
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.APPLICATION_NAME, SystemKeys.Configurations.APPLICATION_NAME);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.APPLICATION_USERNAME, SystemKeys.Configurations.APPLICATION_USERNAME);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.ROOT_URL, SystemKeys.Configurations.ROOT_URL);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.ALLOW_ACCESS_MODE, SystemKeys.Configurations.ALLOW_ACCESS_MODE);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.AUTOCOMPLETE_RESULTS, SystemKeys.Configurations.AUTOCOMPLETE_RESULTS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_RESULTS, SystemKeys.Configurations.MAX_RESULTS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.USER_FORMAT_FOR_MANAGERS, SystemKeys.Configurations.USER_FORMAT_FOR_MANAGERS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.USER_FORMAT_FOR_OTHERS, SystemKeys.Configurations.USER_FORMAT_FOR_OTHERS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.DEFAULT_LANGUAGE, SystemKeys.Configurations.DEFAULT_LANGUAGE);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.COUNTRY, SystemKeys.Configurations.COUNTRY);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.NUMBER_FORMAT, SystemKeys.Configurations.NUMBER_FORMAT);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.DATE_FORMAT, SystemKeys.Configurations.DATE_FORMAT);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.DISTANCE_UNIT, SystemKeys.Configurations.DISTANCE_UNIT);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_RESULTS_ON_MAP, SystemKeys.Configurations.MAX_RESULTS_ON_MAP);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.DEFAULT_MAP_ZOOM_WEB, SystemKeys.Configurations.DEFAULT_MAP_ZOOM_WEB);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.DEFAULT_MAP_ZOOM_MOBILE, SystemKeys.Configurations.DEFAULT_MAP_ZOOM_MOBILE);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.TIME_FORMAT, SystemKeys.Configurations.TIME_FORMAT);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.LIST_SEPARATOR, SystemKeys.Configurations.LIST_SEPARATOR);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.TIME_ZONE_ID, SystemKeys.Configurations.TIME_ZONE_ID);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_UPLOAD_SIZE, SystemKeys.Configurations.MAX_UPLOAD_SIZE);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_USER_TEMP_IMAGES, SystemKeys.Configurations.MAX_USER_TEMP_IMAGES);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_GUEST_TEMP_IMAGES, SystemKeys.Configurations.MAX_GUEST_TEMP_IMAGES);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_IMAGE_DIMENSIONS, SystemKeys.Configurations.MAX_IMAGE_DIMENSIONS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_MEDIUM_THUMB_DIMENSIONS, SystemKeys.Configurations.MAX_MEDIUM_THUMB_DIMENSIONS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_SMALL_THUMB_DIMENSIONS, SystemKeys.Configurations.MAX_SMALL_THUMB_DIMENSIONS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.MAX_PNG_SIZE, SystemKeys.Configurations.MAX_PNG_SIZE);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.JPEG_QUALITY, SystemKeys.Configurations.JPEG_QUALITY);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.USERS_MENU_TYPE, SystemKeys.Configurations.USERS_MENU_TYPE);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.GUESTS_MENU_TYPE, SystemKeys.Configurations.GUESTS_MENU_TYPE);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.FRONTEND, SystemKeys.Configurations.FRONTEND);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.FRONTEND_MENU_BAR, SystemKeys.Configurations.FRONTEND_MENU_BAR);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.FRONTEND_DASHBOARD_ACCOUNTS, SystemKeys.Configurations.FRONTEND_DASHBOARD_ACCOUNTS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.FRONTEND_DASHBOARD_USERS, SystemKeys.Configurations.FRONTEND_DASHBOARD_USERS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.FRONTEND_DASHBOARD_ADS, SystemKeys.Configurations.FRONTEND_DASHBOARD_ADS);
        REQUIRED_PROPERTIES.put((Property<?, ?>)ConfigurationDTO.EMAIL_NAME, SystemKeys.Configurations.EMAIL_NAME);
        EXCLUDED_PROPERTIES_FROM_CONVERSION = new Object[]{ConfigurationDTO.SMTP_CONFIGURATION, ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION, ConfigurationDTO.CAPTCHA_CONFIGURATION, ConfigurationDTO.GUEST_PROFILE_FIELDS, ConfigurationDTO.MAP_SERVER_API_KEY, ConfigurationDTO.PROFILE_FIELDS_IN_ACCOUNT, ConfigurationDTO.PROFILE_FIELD_IN_ACCOUNT_TITLE, ConfigurationDTO.USER_FORMAT_FOR_MANAGERS, ConfigurationDTO.USER_FORMAT_FOR_OTHERS, ConfigurationDTO.DEFAULT_USER_IMAGE, ConfigurationDTO.FIREBASE_PRIVATE_KEY};
    }
}

