/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.system.EntityPropertyLog;
import org.cyclos.entities.system.QEntityLog;
import org.cyclos.entities.system.QEntityPropertyLog;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.EntityLogHandler;
import org.cyclos.impl.system.EntityLogRegistry;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseEntityLogHandlerImpl<E extends BaseEntity, DTO extends EntityDTO>
extends BaseNetworkedHandlerImpl
implements EntityLogHandler<E, DTO> {
    protected static final QEntityPropertyLog $ = QEntityPropertyLog.entityPropertyLog;
    protected static final QEntityLog el = $.entityLog();
    @Autowired
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    protected EntityLogRegistry entityLogRegistry;

    public final void applyLogFilters(DBQuery<?> dBQuery, EntityPropertyLogQuery entityPropertyLogQuery) {
        BooleanExpression booleanExpression;
        Pair<Boolean, Set<EntityLogType>> pair;
        long l = entityPropertyLogQuery.getEntityId();
        if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getPeriod())) {
            dBQuery.where(BaseEntityLogHandlerImpl.el.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)entityPropertyLogQuery.getPeriod())));
        }
        if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getKeywords())) {
            dBQuery.where((Predicate)BaseEntityLogHandlerImpl.$.name.containsIgnoreCase(entityPropertyLogQuery.getKeywords()).or((Predicate)BaseEntityLogHandlerImpl.el.name.containsIgnoreCase(entityPropertyLogQuery.getKeywords())).or((Predicate)BaseEntityLogHandlerImpl.el.namePrefix.containsIgnoreCase(entityPropertyLogQuery.getKeywords())));
        }
        if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getBy())) {
            dBQuery.where((Predicate)el.by().eq((Object)((BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)entityPropertyLogQuery.getBy()))));
        }
        if ((pair = this.doApplyLogFilters(dBQuery, l, entityPropertyLogQuery)) == null || !Boolean.FALSE.equals(pair.getFirst()) || CollectionHelper.isEmpty((Iterable)((Iterable)pair.getSecond()))) {
            booleanExpression = BaseEntityLogHandlerImpl.el.entityId.eq((Object)l).and((Predicate)BaseEntityLogHandlerImpl.el.type.eq((Object)entityPropertyLogQuery.getType()));
            if (pair != null && CollectionHelper.isNotEmpty((Iterable)((Iterable)pair.getSecond()))) {
                booleanExpression = booleanExpression.or((Predicate)BaseEntityLogHandlerImpl.el.ownerEntityId.eq((Object)l).and((Predicate)BaseEntityLogHandlerImpl.el.type.in((Collection)pair.getSecond())));
            }
        } else {
            booleanExpression = BaseEntityLogHandlerImpl.el.ownerEntityId.eq((Object)l).and((Predicate)BaseEntityLogHandlerImpl.el.type.in((Collection)pair.getSecond()));
        }
        dBQuery.where((Predicate)booleanExpression);
        if (Boolean.TRUE.equals(entityPropertyLogQuery.getAsManager())) {
            dBQuery.where((Predicate)BaseEntityLogHandlerImpl.el.asManager.eq(Boolean.valueOf(true)));
        }
        dBQuery.orderBy(new OrderSpecifier[]{BaseEntityLogHandlerImpl.el.date.desc(), BaseEntityLogHandlerImpl.$.order.asc(), BaseEntityLogHandlerImpl.$.name.asc()});
    }

    public boolean areEquals(E e, E e2, PropertyAccess propertyAccess, Object object, Object object2) {
        return Objects.equals(object, object2);
    }

    public boolean canViewEntityLog(long l) {
        E e = this.getEntityToViewLog(l);
        if (e == null) {
            return false;
        }
        BasicUser basicUser = this.getRelatedUser(e);
        SessionData sessionData = this.getSessionData();
        if (basicUser == null) {
            return sessionData.isAdmin();
        }
        return !basicUser.isPurged() && (sessionData.isManagerOf(basicUser) || sessionData.isOwnerOf(basicUser));
    }

    public boolean canViewPropertiesLog(EntityLog entityLog) {
        try {
            this.rawEntityManagerHandler.find(this.getEntityClass(), Long.valueOf(entityLog.getEntityId()));
            return this.canViewEntityLog(entityLog.getEntityId());
        }
        catch (EntityNotFoundException entityNotFoundException) {
            EntityLogHandler entityLogHandler = this.resolveOwnerEntityLogHandler(entityLog);
            if (entityLogHandler == null) {
                return false;
            }
            return entityLogHandler.canViewEntityLog(entityLog.getOwnerEntityId().longValue());
        }
    }

    public String getEntityLogName(E e, E e2, EntityLogEvent entityLogEvent) {
        return this.doGetEntityLogName((BaseEntity)e, (BaseEntity)e2);
    }

    public String getEntityLogNamePrefix(E e, E e2) {
        BaseEntity baseEntity = (BaseEntity)ObjectHelper.defaultValue(e2, e);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (baseEntity != null) {
            Field field = FieldHelper.getAnnotatedField(baseEntity.getClass(), OwnerEntity.class);
            if (field != null) {
                if ((baseEntity = (BaseEntity)new BeanWrapperImpl((Object)baseEntity).getPropertyValue(field.getName())) == null) continue;
                EntityLogHandler entityLogHandler = this.entityLogRegistry.getHandler(baseEntity.getClass());
                if (entityLogHandler == null) {
                    arrayList.add(this.doGetEntityLogName(baseEntity, null));
                    continue;
                }
                arrayList.add(entityLogHandler.getEntityLogName((SimpleEntity)baseEntity, null, null));
                continue;
            }
            baseEntity = null;
        }
        Collections.reverse(arrayList);
        return StringHelper.joinTrimming(arrayList, (String)" - ");
    }

    public Long getRelatedEntityId(E e) {
        return null;
    }

    public BasicUser getRelatedUser(E e) {
        return null;
    }

    public Pair<Object, Object> getValues(E e, E e2, PropertyLogDescriptor<DTO> propertyLogDescriptor) {
        return null;
    }

    public boolean isAsManager(E e) {
        return this.isAdmin() || this.isSystem();
    }

    public boolean isLogEnabled(E e) {
        return true;
    }

    public boolean isPrivateEntity(E e) {
        return true;
    }

    public final List<EntityPropertyLog> onBeforeLog(E e, E e2, List<EntityPropertyLog> list, EntityLogEvent entityLogEvent) {
        if (entityLogEvent != EntityLogEvent.CREATE || this.customLogForCreation()) {
            return this.doOnBeforeLog(e, e2, list, entityLogEvent);
        }
        return list;
    }

    protected EntityPropertyLog createEntityPropertyLog(String string, String string2, String string3, String string4) {
        EntityPropertyLog entityPropertyLog = new EntityPropertyLog();
        entityPropertyLog.setPropertyName(string2);
        entityPropertyLog.setName(string);
        entityPropertyLog.setValues(string3, string4);
        return entityPropertyLog;
    }

    protected boolean customLogForCreation() {
        return false;
    }

    protected Pair<Boolean, Set<EntityLogType>> doApplyLogFilters(DBQuery<?> dBQuery, long l, EntityPropertyLogQuery entityPropertyLogQuery) {
        return null;
    }

    protected List<EntityPropertyLog> doOnBeforeLog(E e, E e2, List<EntityPropertyLog> list, EntityLogEvent entityLogEvent) {
        return list;
    }

    protected abstract E getEntityToViewLog(long var1);

    protected <BE extends BaseEntity, EDTO extends EntityDTO> EntityLogHandler<BE, EDTO> resolveOwnerEntityLogHandler(EntityLog entityLog) {
        Field field = FieldHelper.getAnnotatedField((Class)this.getEntityClass(), OwnerEntity.class);
        if (field == null) {
            return null;
        }
        return this.entityLogRegistry.getHandler(field.getType());
    }

    private <B extends BaseEntity> String doGetEntityLogName(B b, B b2) {
        BaseEntity baseEntity = (BaseEntity)ObjectHelper.defaultValue(b2, b);
        return baseEntity instanceof INamedEntity ? ((INamedEntity)baseEntity).getName() : this.getFormatter().format((Object)baseEntity);
    }
}

