/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.marketplace.QAdHistoryLog;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserGroupLog;
import org.cyclos.impl.system.AdsSubReportsTestableHandler;
import org.cyclos.impl.system.FirstAndLastData;
import org.cyclos.impl.system.ReportSection;
import org.cyclos.impl.system.SubReportsHandler;
import org.cyclos.impl.system.SubReportsHandlerImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.reports.SystemReportQuery;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.MessageKey;
import org.springframework.stereotype.Component;

@Component
public class AdsSubReportsHandlerImpl
extends SubReportsHandlerImpl
implements AdsSubReportsTestableHandler {
    public int countActiveUsersWithAds(SystemReportQuery systemReportQuery, SubReportsHandler.PeriodLimit periodLimit) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        DateTime dateTime = this.getPeriodLimit(systemReportQuery, periodLimit);
        Date date = this.toDate(dateTime);
        QAdHistoryLog qAdHistoryLog = QAdHistoryLog.adHistoryLog;
        Long l = (Long)((DBQuery)this.from(new EntityPath[]{qAdHistoryLog}).where(new Predicate[]{qAdHistoryLog.ad().owner().status.eq((Object)UserStatus.ACTIVE), qAdHistoryLog.ad().creationDate.loe((Comparable)date), qAdHistoryLog.ad().deletedDate.isNull().or((Predicate)qAdHistoryLog.ad().deletedDate.gt((Comparable)date)), this.getGroupHistorySubQueryClause(qAdHistoryLog.ad().owner(), set, dateTime), qAdHistoryLog.publicationPeriod().begin.loe((Comparable)date), qAdHistoryLog.publicationPeriod().end.goe((Comparable)date), qAdHistoryLog.startDate.before((Comparable)date), qAdHistoryLog.endDate.isNull().or((Predicate)qAdHistoryLog.endDate.after((Comparable)date)), qAdHistoryLog.hidden.eq(Boolean.valueOf(false)), qAdHistoryLog.removedFromOwner.eq(Boolean.valueOf(false))})).singleResult((Expression)qAdHistoryLog.ad().owner().countDistinct());
        return l == null ? 0 : l.intValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<AdStatus, Integer> countAds(SystemReportQuery systemReportQuery, SubReportsHandler.PeriodLimit periodLimit) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        DateTime dateTime = this.getPeriodLimit(systemReportQuery, periodLimit);
        Date date = this.toDate(dateTime);
        QAdHistoryLog qAdHistoryLog = QAdHistoryLog.adHistoryLog;
        LinkedHashMap<AdStatus, Integer> linkedHashMap = new LinkedHashMap<AdStatus, Integer>();
        AdStatus[] adStatusArray = AdStatus.values();
        int n = adStatusArray.length;
        int n2 = 0;
        while (true) {
            block11: {
                AdStatus adStatus;
                block10: {
                    if (n2 >= n) {
                        return linkedHashMap;
                    }
                    adStatus = adStatusArray[n2];
                    if (adStatus != AdStatus.DRAFT && adStatus != AdStatus.PENDING) break block10;
                    linkedHashMap.put(adStatus, 0);
                    break block11;
                }
                DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qAdHistoryLog}).where(new Predicate[]{qAdHistoryLog.ad().creationDate.loe((Comparable)date), qAdHistoryLog.ad().deletedDate.isNull().or((Predicate)qAdHistoryLog.ad().deletedDate.gt((Comparable)date)), this.getGroupHistorySubQueryClause(qAdHistoryLog.ad().owner(), set, dateTime), qAdHistoryLog.startDate.before((Comparable)date), qAdHistoryLog.endDate.isNull().or((Predicate)qAdHistoryLog.endDate.after((Comparable)date))});
                switch (adStatus) {
                    case ACTIVE: {
                        dBQuery.where(new Predicate[]{qAdHistoryLog.publicationPeriod().begin.loe((Comparable)date), qAdHistoryLog.publicationPeriod().end.gt((Comparable)date), qAdHistoryLog.hidden.eq(Boolean.valueOf(false)), qAdHistoryLog.removedFromOwner.eq(Boolean.valueOf(false))});
                        break;
                    }
                    case SCHEDULED: {
                        dBQuery.where(new Predicate[]{qAdHistoryLog.publicationPeriod().begin.gt((Comparable)date), qAdHistoryLog.hidden.eq(Boolean.valueOf(false)), qAdHistoryLog.removedFromOwner.eq(Boolean.valueOf(false))});
                        break;
                    }
                    case EXPIRED: {
                        dBQuery.where(new Predicate[]{qAdHistoryLog.publicationPeriod().end.loe((Comparable)date), qAdHistoryLog.hidden.eq(Boolean.valueOf(false)), qAdHistoryLog.removedFromOwner.eq(Boolean.valueOf(false))});
                        break;
                    }
                    case HIDDEN: {
                        dBQuery.where(new Predicate[]{qAdHistoryLog.hidden.eq(Boolean.valueOf(true)), qAdHistoryLog.removedFromOwner.eq(Boolean.valueOf(false))});
                        break;
                    }
                    case DISABLED: {
                        dBQuery.where((Predicate)qAdHistoryLog.removedFromOwner.eq(Boolean.valueOf(true)));
                        break;
                    }
                    case DRAFT: 
                    case PENDING: {
                        break block11;
                    }
                }
                Long l = (Long)dBQuery.singleResult((Expression)qAdHistoryLog.ad().countDistinct());
                linkedHashMap.put(adStatus, l == null ? 0 : l.intValue());
            }
            ++n2;
        }
    }

    public List<ReportSection> data(SystemReportQuery systemReportQuery) {
        if (systemReportQuery.isAds()) {
            ReportSection reportSection = new ReportSection((Object)SystemKeys.Reports.SYSTEM_AD_INFORMATION, true, this.getAdsData(systemReportQuery));
            return Collections.singletonList(reportSection);
        }
        return null;
    }

    public int order() {
        return 2;
    }

    private List<FirstAndLastData> getAdsData(SystemReportQuery systemReportQuery) {
        ArrayList<FirstAndLastData> arrayList = new ArrayList<FirstAndLastData>();
        FirstAndLastData firstAndLastData = new FirstAndLastData();
        firstAndLastData.setLabel(this.message(SystemKeys.Reports.SYSTEM_AD_INFORMATION_ACTIVE_USERS_WITH_ADS, new Object[0]));
        firstAndLastData.setFirst(this.countActiveUsersWithAds(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN));
        firstAndLastData.setLast(this.countActiveUsersWithAds(systemReportQuery, SubReportsHandler.PeriodLimit.END));
        arrayList.add(firstAndLastData);
        Map<AdStatus, Integer> map = this.countAds(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
        Map<AdStatus, Integer> map2 = this.countAds(systemReportQuery, SubReportsHandler.PeriodLimit.END);
        if (CollectionHelper.isNotEmpty(map)) {
            for (Map.Entry<AdStatus, Integer> entry : map.entrySet()) {
                AdStatus adStatus = entry.getKey();
                FirstAndLastData firstAndLastData2 = new FirstAndLastData();
                MessageKey messageKey = AdStatus.resolverForReport().resolveKey((Enum)adStatus);
                firstAndLastData2.setLabel(this.message(messageKey, new Object[0]));
                firstAndLastData2.setFirst(entry.getValue());
                firstAndLastData2.setLast(map2.get(adStatus));
                arrayList.add(firstAndLastData2);
            }
        }
        return arrayList;
    }

    private BooleanExpression getGroupHistorySubQueryClause(QUser qUser, Set<? extends Group> set, DateTime dateTime) {
        QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
        return ((DBQuery)this.getBaseMemberQuery(set, dateTime, SubReportsHandlerImpl.QueryType.DBSUBQUERY).where((Predicate)qUserGroupLog.user().eq((Expression)qUser))).exists();
    }
}

