/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.storage;

import java.util.Iterator;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.storage.NoOpStoredFileContentAction;
import org.cyclos.impl.storage.SaveStoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentAction;
import org.cyclos.impl.storage.StoredFileHandler;

public class StoredFileTransactionEndListener
implements Runnable {
    private boolean commit;
    private LinkedStoredFileContentAction first;
    private LinkedStoredFileContentAction last;
    private LockHandler lockHandler;

    public static void addFor(StoredFileContentAction storedFileContentAction) {
        LinkedStoredFileContentAction linkedStoredFileContentAction;
        if (storedFileContentAction == null || storedFileContentAction instanceof NoOpStoredFileContentAction) {
            return;
        }
        InvocationContext invocationContext = InvocationContext.get();
        if (invocationContext.getLastStoredFileContentAction() == null) {
            StoredFileTransactionEndListener storedFileTransactionEndListener = new StoredFileTransactionEndListener(true);
            StoredFileTransactionEndListener storedFileTransactionEndListener2 = new StoredFileTransactionEndListener(false);
            invocationContext.addCommitListener(false, (Runnable)storedFileTransactionEndListener);
            invocationContext.addRollbackListener(false, (Runnable)storedFileTransactionEndListener2);
            linkedStoredFileContentAction = StoredFileTransactionEndListener.link(storedFileTransactionEndListener, storedFileTransactionEndListener2, storedFileContentAction);
        } else {
            linkedStoredFileContentAction = ((LinkedStoredFileContentAction)invocationContext.getLastStoredFileContentAction()).link(storedFileContentAction);
        }
        invocationContext.setLastStoredFileContentAction((StoredFileContentAction)linkedStoredFileContentAction);
    }

    public static void main(String[] stringArray) {
        StoredFileTransactionEndListener storedFileTransactionEndListener = null;
        StoredFileTransactionEndListener storedFileTransactionEndListener2 = null;
        LinkedStoredFileContentAction linkedStoredFileContentAction = null;
        for (int i = 0; i < 4; ++i) {
            final int n = i;
            StoredFileContentAction storedFileContentAction = new StoredFileContentAction(){

                public void cancel() {
                    System.out.println("cancelling: " + n);
                }

                public void confirm() {
                    System.out.println("confirming: " + n);
                }
            };
            if (linkedStoredFileContentAction == null) {
                storedFileTransactionEndListener = new StoredFileTransactionEndListener(true);
                storedFileTransactionEndListener2 = new StoredFileTransactionEndListener(false);
                linkedStoredFileContentAction = StoredFileTransactionEndListener.link(storedFileTransactionEndListener, storedFileTransactionEndListener2, storedFileContentAction);
                continue;
            }
            linkedStoredFileContentAction = linkedStoredFileContentAction.link(storedFileContentAction);
        }
        storedFileTransactionEndListener.run();
        System.out.println("----");
        storedFileTransactionEndListener2.run();
    }

    private static LinkedStoredFileContentAction link(StoredFileTransactionEndListener storedFileTransactionEndListener, StoredFileTransactionEndListener storedFileTransactionEndListener2, StoredFileContentAction storedFileContentAction) {
        LinkedStoredFileContentAction linkedStoredFileContentAction = new LinkedStoredFileContentAction(storedFileContentAction);
        linkedStoredFileContentAction.commitListener = storedFileTransactionEndListener;
        linkedStoredFileContentAction.rollbackListener = storedFileTransactionEndListener2;
        storedFileTransactionEndListener.first = linkedStoredFileContentAction;
        storedFileTransactionEndListener2.first = linkedStoredFileContentAction;
        storedFileTransactionEndListener.last = linkedStoredFileContentAction;
        storedFileTransactionEndListener2.last = linkedStoredFileContentAction;
        return linkedStoredFileContentAction;
    }

    private StoredFileTransactionEndListener(boolean bl) {
        this.commit = bl;
        this.lockHandler = (LockHandler)InvocationContext.bean(LockHandler.class);
    }

    @Override
    public final void run() {
        Iterator<LinkedStoredFileContentAction> iterator = this.getIterator();
        while (iterator.hasNext()) {
            iterator.next().execute(this.commit, this.lockHandler);
        }
    }

    private Iterator<LinkedStoredFileContentAction> getIterator() {
        return new Iterator<LinkedStoredFileContentAction>(){
            private LinkedStoredFileContentAction cursor = null;

            @Override
            public boolean hasNext() {
                if (this.cursor == null) {
                    return StoredFileTransactionEndListener.this.first != null;
                }
                return StoredFileTransactionEndListener.this.commit ? this.cursor.next != null : this.cursor.prev != null;
            }

            @Override
            public LinkedStoredFileContentAction next() {
                this.cursor = this.cursor == null ? (StoredFileTransactionEndListener.this.commit ? StoredFileTransactionEndListener.this.first : StoredFileTransactionEndListener.this.last) : (StoredFileTransactionEndListener.this.commit ? this.cursor.next : this.cursor.prev);
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("read only iterator!");
            }
        };
    }

    private static class LinkedStoredFileContentAction
    implements StoredFileContentAction {
        private StoredFileContentAction target;
        private LinkedStoredFileContentAction prev;
        private LinkedStoredFileContentAction next;
        private StoredFileTransactionEndListener commitListener;
        private StoredFileTransactionEndListener rollbackListener;

        private LinkedStoredFileContentAction(StoredFileContentAction storedFileContentAction) {
            this.target = storedFileContentAction;
        }

        public void cancel() {
            this.target.cancel();
        }

        public void confirm() {
            this.target.confirm();
        }

        public void execute(boolean bl, LockHandler lockHandler) {
            if (bl) {
                if (!StoredFileHandler.SKIP_LOCK && this.target instanceof SaveStoredFileContentAction) {
                    lockHandler.lock(LockType.STORED_FILE.key(((SaveStoredFileContentAction)this.target).key()), 3600000L);
                }
                this.confirm();
            } else {
                this.cancel();
            }
        }

        private LinkedStoredFileContentAction link(StoredFileContentAction storedFileContentAction) {
            this.next = new LinkedStoredFileContentAction(storedFileContentAction);
            this.next.prev = this;
            this.next.commitListener = this.commitListener;
            this.next.rollbackListener = this.rollbackListener;
            this.commitListener.last = this.next;
            this.rollbackListener.last = this.next;
            return this.next;
        }
    }
}

