/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.QInstallment;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.search.InstallmentSearchHandler;
import org.cyclos.impl.search.opensearch.OpenSearchBaseTransactionSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.ResultsCollector;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.utils.conversion.VOFiller;
import org.cyclos.model.Bean;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.BaseInstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentResultVO;
import org.cyclos.model.banking.transactions.InstallmentVO;
import org.cyclos.model.banking.transactions.TransactionOrderBy;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;

public class OpenSearchInstallmentSearchHandlerImpl
extends OpenSearchBaseTransactionSearchHandlerImpl<Installment, InstallmentOverviewQuery, InstallmentResultVO>
implements InstallmentSearchHandler {
    private static final String INDEX = "installments";
    public static final String VERSION = "4";
    private static final String TRANSACTION = "transaction";
    private static final String INSTALLMENT = "installment";

    public OpenSearchInstallmentSearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl) {
        super(openSearchHandlerImpl, Installment.class, QInstallment.installment);
    }

    public DataIterator<Installment> export(InstallmentQuery installmentQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        QueryAccessor queryAccessor = new QueryAccessor();
        this.appendWhere(sessionData, queryAccessor, (AbstractTransQuery)installmentQuery);
        return this.doExportEntities(installmentQuery, (QueryBuilder)queryAccessor.queryBuilder(), this.toSort((AbstractTransQuery)installmentQuery));
    }

    public String indexName() {
        return INDEX;
    }

    @Override
    public String indexVersion() {
        return VERSION;
    }

    public Page<InstallmentResultVO> searchInstallments(InstallmentQuery installmentQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        QueryAccessor queryAccessor = new QueryAccessor();
        this.appendWhere(sessionData, queryAccessor, (AbstractTransQuery)installmentQuery);
        InstallmentResultVOCollector installmentResultVOCollector = new InstallmentResultVOCollector(installmentQuery.getOwner(), this.transactionCustomFieldService.listVisibleForList((AbstractTransQuery)installmentQuery));
        return this.search(installmentQuery, (QueryBuilder)queryAccessor.queryBuilder(), this.toSort((AbstractTransQuery)installmentQuery), installmentResultVOCollector);
    }

    @Override
    protected void appendWhere(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        BaseInstallmentQuery baseInstallmentQuery;
        Set set;
        super.appendWhere(sessionData, queryAccessor, abstractTransQuery);
        if (abstractTransQuery instanceof BaseInstallmentQuery && CollectionHelper.isNotEmpty((Iterable)(set = (baseInstallmentQuery = (BaseInstallmentQuery)abstractTransQuery).getStatuses()))) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)"installment.status", (Collection)set));
        }
    }

    @Override
    protected String dateField() {
        return "installment." + InstallmentVO.DUE_DATE.getName();
    }

    @Override
    protected void fillSource(Installment installment, SourceAccessor sourceAccessor) {
        InternalTransaction internalTransaction = installment.getTransaction();
        this.doFillSource((Trans)internalTransaction, sourceAccessor);
        sourceAccessor.set(TRANSACTION, (Object)internalTransaction);
        sourceAccessor.set(INSTALLMENT, (Object)this.toInstallment(installment));
    }

    @Override
    protected TransactionOrderBy getDefaultOrder() {
        return TransactionOrderBy.DATE_ASC;
    }

    @Override
    protected ResultsCollector<InstallmentOverviewQuery, InstallmentResultVO> resultsCollector(InstallmentOverviewQuery installmentOverviewQuery) {
        return new InstallmentResultVOCollector<InstallmentOverviewQuery>(null, this.transactionCustomFieldService.listVisibleForList((AbstractTransQuery)installmentOverviewQuery));
    }

    private InstallmentResultVO toInstallmentResultVO(InternalAccountOwner internalAccountOwner, List<TransactionCustomField> list, VOFiller<BasicUserVO> vOFiller, SessionData sessionData, SearchHit searchHit) {
        TransactionResultVO transactionResultVO = this.toTransactionResultVO(internalAccountOwner, vOFiller, list, sessionData, searchHit);
        SourceAccessor sourceAccessor = new SourceAccessor(searchHit);
        transactionResultVO.setId(sourceAccessor.getAsLong(TRANSACTION));
        SourceAccessor sourceAccessor2 = sourceAccessor.getAsSource(INSTALLMENT);
        InstallmentVO installmentVO = this.toInstallmentVO(transactionResultVO.getType().getCurrency().getPrecision(), vOFiller, sourceAccessor2);
        installmentVO.setId(Long.valueOf(Long.parseLong(searchHit.getId())));
        InstallmentResultVO installmentResultVO = new InstallmentResultVO();
        installmentVO.copyPropertiesTo((Bean)installmentResultVO);
        installmentResultVO.setTransaction(transactionResultVO);
        if (BigDecimalHelper.isNegative((BigDecimal)transactionResultVO.getAmount())) {
            installmentResultVO.setAmount(installmentResultVO.getAmount().negate());
        }
        return installmentResultVO;
    }

    private class InstallmentResultVOCollector<Q extends BaseInstallmentQuery>
    implements ResultsCollector<Q, InstallmentResultVO> {
        private InternalAccountOwner owner;
        private SessionData sessionData = InvocationContext.getSessionData();
        private VOFiller<BasicUserVO> userVoFiller;
        private List<TransactionCustomField> customFields;

        public InstallmentResultVOCollector(InternalAccountOwner internalAccountOwner, List<TransactionCustomField> list) {
            this.userVoFiller = OpenSearchInstallmentSearchHandlerImpl.this.userLocatorHandler.newVOFiller();
            this.owner = internalAccountOwner;
            this.customFields = list;
        }

        @Override
        public void collect(Q q, List<InstallmentResultVO> list, SearchHit searchHit) {
            list.add(OpenSearchInstallmentSearchHandlerImpl.this.toInstallmentResultVO(this.owner, this.customFields, this.userVoFiller, this.sessionData, searchHit));
        }

        @Override
        public void postProcess(Q q, List<InstallmentResultVO> list) {
            this.userVoFiller.fill();
        }
    }
}

