/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search;

import java.util.function.Supplier;
import org.cyclos.entities.banking.Installment;
import org.cyclos.impl.search.DelegatingEntitySearchHandlerImpl;
import org.cyclos.impl.search.InstallmentSearchHandler;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentResultVO;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class InstallmentSearchHandlerFactoryBean
extends AbstractFactoryBean<InstallmentSearchHandler> {
    @Autowired
    @Lazy
    private SearchHandler searchHandler;

    public Class<?> getObjectType() {
        return InstallmentSearchHandler.class;
    }

    protected InstallmentSearchHandler createInstance() throws Exception {
        return new DelegatingInstallmentSearchHandlerImpl(() -> ((SearchHandler)this.searchHandler).installment());
    }

    private static class DelegatingInstallmentSearchHandlerImpl
    extends DelegatingEntitySearchHandlerImpl<Installment, InstallmentOverviewQuery, InstallmentResultVO, InstallmentSearchHandler>
    implements InstallmentSearchHandler {
        public DelegatingInstallmentSearchHandlerImpl(Supplier<InstallmentSearchHandler> supplier) {
            super(supplier);
        }

        public DataIterator<Installment> export(InstallmentQuery installmentQuery) {
            return ((InstallmentSearchHandler)this.delegate()).export(installmentQuery);
        }

        public Page<InstallmentResultVO> searchInstallments(InstallmentQuery installmentQuery) {
            return ((InstallmentSearchHandler)this.delegate()).searchInstallments(installmentQuery);
        }
    }
}

