/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndexEntitiesBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private SearchHandler searchHandler;

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.INDEX_ENTITIES;
    }

    public BackgroundTaskPriority getPriority() {
        return BackgroundTaskPriority.HIGH;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        IndexEntitiesContext indexEntitiesContext = new IndexEntitiesContext(string);
        List<Long> list = indexEntitiesContext.getIds();
        this.searchHandler.performIndex(indexEntitiesContext.getIndexName(), list);
        return list.size();
    }

    public static class IndexEntitiesContext {
        private String indexName;
        private List<Long> ids;
        private int attempt;

        public IndexEntitiesContext(String string) {
            try {
                this.indexName = StringUtils.substringBefore((String)string, (String)"|");
                if (this.indexName.contains("@")) {
                    this.attempt = Integer.parseInt(StringUtils.substringAfter((String)this.indexName, (String)"@"));
                    this.indexName = StringUtils.substringBefore((String)this.indexName, (String)"@");
                }
                this.ids = StringHelper.splitTrimming((String)StringUtils.substringAfter((String)string, (String)"|"), (String)",").stream().map(Long::valueOf).collect(Collectors.toUnmodifiableList());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Cannot parse as index entities context: " + string, exception);
            }
        }

        public IndexEntitiesContext(String string, Collection<Long> collection) {
            this(string, collection, 0);
        }

        public IndexEntitiesContext(String string, Collection<Long> collection, int n) {
            this.indexName = string;
            this.ids = collection instanceof List ? (List<Object>)collection : new ArrayList<Long>(collection);
            this.attempt = n;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public BackgroundTaskScheduling scheduling() {
            return new BackgroundTaskScheduling(IndexEntitiesBackgroundTask.class, (Object)this.toString(), "Indexing " + this.indexName + ", attempt " + this.attempt + ". Ids to index: " + CollectionHelper.size(this.ids));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.indexName);
            if (this.attempt > 0) {
                stringBuilder.append('@').append(this.attempt);
            }
            stringBuilder.append('|').append(CollectionHelper.join(this.ids, (String)","));
            return stringBuilder.toString();
        }
    }
}

