/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.messaging.IncomingMessage;
import org.cyclos.entities.messaging.Message;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.messaging.OutgoingMessage;
import org.cyclos.entities.messaging.QIncomingMessage;
import org.cyclos.entities.messaging.QMessage;
import org.cyclos.entities.messaging.QOutgoingMessage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QGroup;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.messaging.MessageCategoryServiceLocal;
import org.cyclos.impl.messaging.MessageServiceLocal;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionRecurringTask;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.Permission;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.messagecategories.MessageCategoryVO;
import org.cyclos.model.messaging.messages.DetailedMessageVO;
import org.cyclos.model.messaging.messages.IncomingMessageVO;
import org.cyclos.model.messaging.messages.MessageBox;
import org.cyclos.model.messaging.messages.MessageData;
import org.cyclos.model.messaging.messages.MessageDestination;
import org.cyclos.model.messaging.messages.MessageOwner;
import org.cyclos.model.messaging.messages.MessageQuery;
import org.cyclos.model.messaging.messages.MessageSearchData;
import org.cyclos.model.messaging.messages.MessageVO;
import org.cyclos.model.messaging.messages.MessagesStatusVO;
import org.cyclos.model.messaging.messages.OutgoingMessageVO;
import org.cyclos.model.messaging.messages.SendMessageDTO;
import org.cyclos.model.messaging.messages.SendMessageData;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.security.messaging.MessageServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
extends BaseServiceImpl
implements MessageServiceLocal {
    private static final Map<Class<? extends Message>, Class<? extends DetailedMessageVO>> VO_TYPE_MAPPING;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private MessageCategoryServiceLocal messageCategoryService;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private MessageServiceSecurity messageServiceSecurity;

    public int countNewMessages() {
        return (Integer)this.doCountNewMessages().getFirst();
    }

    public int countUnreadMessages() {
        MessageQuery messageQuery = new MessageQuery();
        messageQuery.setCountOnly();
        messageQuery.setMessageBox(MessageBox.INBOX);
        messageQuery.setOnlyUnread(Boolean.valueOf(true));
        return this.search(messageQuery).getTotalCount();
    }

    public MessageData getData(Long l) throws FrameworkException {
        Message message = this.find(Message.class, l);
        message.setRead(true);
        Class clazz = message instanceof OutgoingMessage ? OutgoingMessageVO.class : IncomingMessageVO.class;
        DetailedMessageVO detailedMessageVO = (DetailedMessageVO)this.conversionHandler.convert(clazz, (Object)message);
        MessageData messageData = new MessageData();
        messageData.setMessage(detailedMessageVO);
        boolean bl = message.isRemoved();
        messageData.setCanMarkUnread(true);
        messageData.setCanMoveToTrash(!bl);
        messageData.setCanRestore(bl);
        messageData.setCanRemove(bl);
        messageData.setCanReply(message instanceof IncomingMessage);
        List<MessageVO> list = this.getConversationOf(message);
        int n = list.indexOf(detailedMessageVO);
        detailedMessageVO.setReplyPosition(Integer.valueOf(n));
        list.remove(detailedMessageVO);
        messageData.setReplies(list);
        return messageData;
    }

    public MessagesStatusVO getMessagesStatus() {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null) {
            return null;
        }
        int n = this.countUnreadMessages();
        Pair<Integer, Date> pair = this.doCountNewMessages();
        MessagesStatusVO messagesStatusVO = new MessagesStatusVO();
        messagesStatusVO.setUnreadMessages(n);
        messagesStatusVO.setNewMessages(((Integer)pair.getFirst()).intValue());
        messagesStatusVO.setLastViewDate(this.toDateTime((Date)pair.getSecond()));
        return messagesStatusVO;
    }

    public MessageSearchData getSearchData() {
        List list;
        MessageSearchData messageSearchData = new MessageSearchData();
        ProductsAccessor productsAccessor = this.getSessionData().getProducts();
        EnumSet<MessageDestination> enumSet = EnumSet.noneOf(MessageDestination.class);
        enumSet.add(MessageDestination.USER);
        if (this.isAdmin()) {
            list = this.conversionHandler.convertList(MessageCategoryVO.class, (Iterable)productsAccessor.admin().getViewMessagesSentToSysWithCat());
            messageSearchData.setVisibleViewCategories(list);
            List list2 = this.conversionHandler.convertList(MessageCategoryVO.class, (Iterable)productsAccessor.admin().getManageMessagesSentToSysWithCat());
            messageSearchData.setVisibleManageCategories(list2);
            List list3 = this.conversionHandler.convertList(MessageCategoryVO.class, (Iterable)productsAccessor.admin().getSendMessagesFromSysWithCat());
            messageSearchData.setVisibleSendCategories(list3);
            enumSet.add(MessageDestination.GROUP);
        } else {
            list = this.conversionHandler.convertList(MessageCategoryVO.class, (Iterable)productsAccessor.member().getSendMessagesToAdmin());
            messageSearchData.setVisibleSendCategories(list);
            if (CollectionHelper.isNotEmpty((Iterable)list)) {
                enumSet.add(MessageDestination.SYSTEM);
            }
            if (this.isBroker()) {
                enumSet.add(MessageDestination.BROKERED);
            }
        }
        list = (MessageQuery)QueryHelper.newQuery(MessageQuery.class);
        list.setMessageBox(MessageBox.INBOX);
        messageSearchData.setQuery((QueryParameters)list);
        messageSearchData.setSendDestinations(enumSet);
        return messageSearchData;
    }

    public SendMessageData getSendData(Long l, UserLocatorVO userLocatorVO) {
        Object object;
        SendMessageData sendMessageData = new SendMessageData();
        User user = null;
        SendMessageDTO sendMessageDTO = new SendMessageDTO();
        sendMessageData.setDto(sendMessageDTO);
        boolean bl = false;
        if (l != null) {
            UserVO userVO;
            sendMessageDTO.setReplyToId(l);
            object = this.find(IncomingMessage.class, l);
            sendMessageDTO.setSubject(this.message(MessagingKeys.Messages.REPLY_SUBJECT, object.getSubject()));
            if (object.getFromOwner() == MessageOwner.SYSTEM) {
                userVO = new UserVO();
                userVO.setDisplay(this.getConfiguration().getApplicationUsername());
            } else {
                userVO = (UserVO)this.conversionHandler.convert(UserVO.class, (Object)object.getFromUser());
            }
            sendMessageData.setRepliedSubject(object.getSubject());
            sendMessageData.setRepliedBody(this.richTextHandler.replaceTagsByUrls(object.getBody()));
            sendMessageData.setRepliedDate(this.toDateTime(object.getDate()));
            sendMessageData.setRepliedFrom(userVO);
            sendMessageDTO.setCategory((MessageCategoryVO)this.conversionHandler.convert(MessageCategoryVO.class, (Object)object.getCategory()));
            switch (object.getFromOwner()) {
                case SYSTEM: {
                    bl = true;
                    break;
                }
                case USER: {
                    user = object.getFromUser();
                }
            }
        }
        if (user == null) {
            user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        }
        if (user == null) {
            if (bl) {
                sendMessageData.setDestinations(Collections.singletonList(MessageDestination.SYSTEM));
            } else {
                sendMessageData.setDestinations(this.messageServiceSecurity.getAllowedDestinations());
            }
            if (sendMessageData.getDestinations().contains(MessageDestination.GROUP)) {
                sendMessageData.setPossibleGroups(this.conversionHandler.convertList(GroupVO.class, (Iterable)this.groupsHandler.accessibles().users().sorted()));
            }
            if (sendMessageData.getDestinations().contains(MessageDestination.USER)) {
                sendMessageData.setMaxRecipients(this.getMaxMessageRecipients());
            }
        } else {
            object = (UserVO)this.conversionHandler.convert(UserVO.class, (Object)user);
            sendMessageDTO.setToUsers(Collections.singleton(object));
            sendMessageData.setMaxRecipients(1);
            sendMessageData.setDestinations(Collections.singletonList(MessageDestination.USER));
            sendMessageData.setToUser((UserVO)object);
        }
        if (l == null) {
            object = user == null ? null : user.getId();
            sendMessageData.setCategories(this.listCategories((Long)object));
        }
        return sendMessageData;
    }

    public void markAsRead(Set<Long> set, boolean bl) {
        for (Long l : set) {
            Message message = this.find(Message.class, l);
            message.setRead(bl);
        }
    }

    public void moveToTrash(Set<Long> set) {
        Date date = DateHelper.now();
        for (Long l : set) {
            Message message = this.find(Message.class, l);
            message.setRemovedAt(date);
        }
    }

    public void removeAll(Set<Long> set) {
        for (Long l : set) {
            Message message = this.find(Message.class, l);
            try {
                this.entityManagerHandler.remove((IEntity)message, false);
            }
            catch (Exception exception) {
                throw new ConstraintViolatedOnRemoveException((Throwable)exception);
            }
        }
        try {
            this.flush();
        }
        catch (Exception exception) {
            throw new ConstraintViolatedOnRemoveException((Throwable)exception);
        }
    }

    public void removeAll(User user) {
        QMessage qMessage = QMessage.message;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qMessage}).where((Predicate)qMessage.owner().id.eq((Object)user.getId()));
        CloseableIterator closeableIterator = dBQuery.iterate((Expression)qMessage);
        this.processBatch(closeableIterator, (T message) -> this.rawEntityManagerHandler.remove((IEntity)message, false));
    }

    public void restoreAll(Set<Long> set) {
        for (Long l : set) {
            Message message = this.find(Message.class, l);
            message.setRemovedAt(null);
        }
    }

    public Page<MessageVO> search(MessageQuery messageQuery) {
        QOutgoingMessage qOutgoingMessage;
        DBQuery<?> dBQuery;
        QMessage qMessage;
        Object object;
        ProductsAccessor productsAccessor = this.getSessionData().getProducts();
        if (this.getLoggedUser().isAdmin() && CollectionUtils.isEmpty((Collection)productsAccessor.admin().getViewMessagesSentToSysWithCat())) {
            return PageImpl.empty();
        }
        MessageBox messageBox = messageQuery.getMessageBox();
        User user = this.getLoggedUser();
        Set set = this.groupsHandler.all().groups().items();
        if (this.isAdmin() && CollectionHelper.isEmpty((Iterable)set)) {
            return PageImpl.empty();
        }
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)messageQuery.getUser());
        switch (messageBox) {
            case INBOX: {
                object = QIncomingMessage.incomingMessage;
                qMessage = ((QIncomingMessage)object)._super;
                dBQuery = this.from(new EntityPath[]{object});
                if (this.isAdmin()) {
                    dBQuery.where((Predicate)object.owner().isNull());
                    dBQuery.where((Predicate)object.fromUser().group().in((Collection)set));
                } else {
                    dBQuery.where((Predicate)object.owner().eq((Object)user));
                }
                if (messageQuery.getDestination() != null) {
                    this.filterDestination(messageQuery.getDestination(), (QIncomingMessage)object, dBQuery);
                }
                if (user2 != null) {
                    dBQuery.where((Predicate)object.fromUser().eq((Object)user2));
                }
                dBQuery.where((Predicate)qMessage.removedAt.isNull());
                break;
            }
            case SENT_ITEMS: {
                qOutgoingMessage = QOutgoingMessage.outgoingMessage;
                qMessage = qOutgoingMessage._super;
                dBQuery = this.from(new EntityPath[]{qOutgoingMessage});
                dBQuery.where((Predicate)qMessage.removedAt.isNull());
                if (messageQuery.getDestination() != null) {
                    this.filterDestination(messageQuery.getDestination(), qOutgoingMessage, dBQuery);
                }
                if (user2 == null) break;
                dBQuery.where((Predicate)qOutgoingMessage.toUsers.contains((Object)user2));
                break;
            }
            case TRASH: {
                qMessage = QMessage.message;
                dBQuery = this.from(new EntityPath[]{qMessage});
                dBQuery.where((Predicate)qMessage.removedAt.isNotNull());
                if (messageQuery.getDestination() != null) {
                    this.filterDestination(messageQuery.getDestination(), qMessage, dBQuery);
                }
                QIncomingMessage qIncomingMessage = QIncomingMessage.incomingMessage;
                QOutgoingMessage qOutgoingMessage2 = QOutgoingMessage.outgoingMessage;
                QUser qUser = QUser.user;
                if (this.isAdmin()) {
                    DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qIncomingMessage}).where((Predicate)qMessage.eq((Expression)qIncomingMessage._super).and((Predicate)qIncomingMessage.fromUser().group().in((Collection)set)));
                    if (user2 != null) {
                        dBQuery2.where((Predicate)qIncomingMessage.fromUser().eq((Object)user2));
                    }
                    DBQuery dBQuery3 = (DBQuery)this.subQuery(new EntityPath[]{qUser}).where((Predicate)qUser.in((CollectionExpression)qOutgoingMessage2.toUsers).and((Predicate)qUser.group().in((Collection)set)));
                    if (user2 != null) {
                        dBQuery3.where((Predicate)qUser.eq((Object)user2));
                    }
                    QGroup qGroup = QGroup.group;
                    DBQuery dBQuery4 = (DBQuery)this.subQuery(new EntityPath[]{qGroup}).where((Predicate)qGroup.in((CollectionExpression)qOutgoingMessage2.toGroups).and((Predicate)qGroup.in((Collection)set)));
                    BooleanExpression booleanExpression = qOutgoingMessage2.sentBy().eq((Object)user).or((Predicate)qOutgoingMessage2.sentBy().group().in((Collection)set));
                    DBQuery dBQuery5 = (DBQuery)this.subQuery(new EntityPath[]{qOutgoingMessage2}).where((Predicate)qMessage.eq((Expression)qOutgoingMessage2._super).and((Predicate)booleanExpression.and((Predicate)dBQuery3.exists().or((Predicate)dBQuery4.exists()))));
                    dBQuery.where((Predicate)dBQuery2.exists().or((Predicate)dBQuery5.exists()));
                    break;
                }
                if (user2 == null) break;
                BooleanExpression booleanExpression = ((DBQuery)this.subQuery(new EntityPath[]{qIncomingMessage}).where((Predicate)qMessage.eq((Expression)qIncomingMessage._super).and((Predicate)qIncomingMessage.fromUser().eq((Object)user2)))).exists();
                BooleanExpression booleanExpression2 = ((DBQuery)this.subQuery(new EntityPath[]{qOutgoingMessage2}).where((Predicate)qMessage.eq((Expression)qOutgoingMessage2._super).and((Predicate)qOutgoingMessage2.toUsers.contains((Object)user2)))).exists();
                dBQuery.where((Predicate)booleanExpression.or((Predicate)booleanExpression2));
                break;
            }
            default: {
                qMessage = QMessage.message;
                dBQuery = this.from(new EntityPath[]{qMessage});
            }
        }
        object = messageQuery.getKeywords();
        if (object != null && !"".equals(((String)object).trim())) {
            dBQuery.where((Predicate)qMessage.body.containsIgnoreCase((String)object).or((Predicate)qMessage.subject.containsIgnoreCase((String)object)));
        }
        if (this.isAdmin()) {
            dBQuery.where((Predicate)qMessage.owner().isNull());
            this.filterCategories(messageQuery, qMessage, dBQuery);
        } else {
            dBQuery.where((Predicate)qMessage.owner().eq((Object)user));
        }
        if (QueryHelper.useParameter((Object)messageQuery.getConversationId())) {
            dBQuery.where((Predicate)qMessage.conversationId.eq((Object)messageQuery.getConversationId()));
        }
        if (QueryHelper.useParameter((Object)messageQuery.getPeriod())) {
            dBQuery.where(qMessage.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)messageQuery.getPeriod())));
        }
        if (QueryHelper.useParameter((Object)messageQuery.getOnlyUnread()) && messageQuery.getOnlyUnread().booleanValue()) {
            dBQuery.where((Predicate)qMessage.read.eq(Boolean.valueOf(false)));
        }
        dBQuery.orderBy(qMessage.date.desc());
        qOutgoingMessage = dBQuery.page((QueryParameters)messageQuery, (Expression)qMessage);
        return this.conversionHandler.convertPage(VO_TYPE_MAPPING, (Iterable)qOutgoingMessage);
    }

    public long send(SendMessageDTO sendMessageDTO) {
        User user;
        IncomingMessage incomingMessage;
        Set set;
        if (sendMessageDTO.getReplyToId() != null) {
            sendMessageDTO.setCategory(null);
        }
        this.validate(sendMessageDTO);
        Date date = DateHelper.now();
        User user2 = this.getLoggedUser();
        if (sendMessageDTO.getDestination() == MessageDestination.BROKERED && user2.isBroker()) {
            set = this.conversionHandler.convertSet(UserVO.class, this.filterActiveUsers(user2.getBrokeredUsers()));
            sendMessageDTO.setToUsers(set);
        }
        set = (OutgoingMessage)this.conversionHandler.convertExcluding(OutgoingMessage.class, (Object)sendMessageDTO, new Object[]{SendMessageDTO.TO_USERS.getName()});
        MessageCategory messageCategory = null;
        if (sendMessageDTO.getReplyToId() != null) {
            incomingMessage = this.find(IncomingMessage.class, sendMessageDTO.getReplyToId());
            incomingMessage.setRead(true);
            incomingMessage.setReplied(true);
            set.setConversationId(incomingMessage.getConversationId());
            messageCategory = incomingMessage.getCategory();
            set.setCategory(messageCategory);
            if (incomingMessage.getFromOwner() == MessageOwner.USER) {
                HashSet<User> hashSet = new HashSet<User>();
                hashSet.add(incomingMessage.getFromUser());
                set.setToUsers(hashSet);
                set.setDestination(MessageDestination.USER);
                sendMessageDTO.setDestination(MessageDestination.USER);
                HashSet<UserVO> hashSet2 = new HashSet<UserVO>();
                for (User user3 : hashSet) {
                    hashSet2.add(new UserVO(user3.getId()));
                }
                sendMessageDTO.setToUsers(hashSet2);
            } else {
                set.setDestination(MessageDestination.SYSTEM);
                sendMessageDTO.setDestination(MessageDestination.SYSTEM);
            }
            sendMessageDTO.setCategory((MessageCategoryVO)this.conversionHandler.convert(MessageCategoryVO.class, (Object)messageCategory));
        } else {
            set.setToUsers(this.conversionHandler.convertSet(User.class, (Iterable)sendMessageDTO.getToUsers()));
        }
        set.setDate(date);
        if (this.isAdmin()) {
            incomingMessage = MessageOwner.SYSTEM;
            user = null;
        } else {
            incomingMessage = MessageOwner.USER;
            user = user2;
        }
        set.setMessageOwner((MessageOwner)incomingMessage);
        set.setOwner(user);
        set.setRead(true);
        set.setSentBy(user2);
        if (set.getDestination() != MessageDestination.SYSTEM && set.getMessageOwner() != MessageOwner.SYSTEM) {
            set.setCategory(null);
        }
        this.persist((IEntity)set);
        this.refresh(set);
        if (set.getConversationId() == null) {
            set.setConversationId(set.getId());
        }
        if (sendMessageDTO.getDestination() == MessageDestination.SYSTEM) {
            this.createSystemIncoming(sendMessageDTO, user, date, (MessageOwner)incomingMessage, set.getConversationId());
        } else {
            this.nativeQueryHandler.insertUserIncomingMessages(sendMessageDTO, (MessageOwner)incomingMessage, user2, (OutgoingMessage)set);
        }
        this.recurringTaskHandler.scheduleAwake(BackgroundTaskExecutionRecurringTask.class);
        return set.getId();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QMessage.message.network());
    }

    private void createSystemIncoming(SendMessageDTO sendMessageDTO, User user, Date date, MessageOwner messageOwner, Long l) {
        IncomingMessage incomingMessage = this.prepareIncomingMessage(sendMessageDTO, user, date, messageOwner);
        incomingMessage.setOwner(null);
        incomingMessage.setMessageOwner(MessageOwner.SYSTEM);
        incomingMessage.setConversationId(l);
        this.persist((IEntity)incomingMessage);
    }

    private Pair<Integer, Date> doCountNewMessages() {
        MessageQuery messageQuery = new MessageQuery();
        messageQuery.setCountOnly();
        messageQuery.setMessageBox(MessageBox.INBOX);
        User user = this.getLoggedUser();
        Date date = user.getMessagesLastViewDate();
        if (date != null) {
            DatePeriodDTO datePeriodDTO = DateHelper.periodBeginningAt((DateTime)this.toDateTime(date));
            messageQuery.setPeriod(datePeriodDTO);
        }
        return Pair.create((Object)this.search(messageQuery).getTotalCount(), (Object)date);
    }

    private Set<User> filterActiveUsers(Set<User> set) {
        HashSet<User> hashSet = new HashSet<User>();
        if (CollectionHelper.isNotEmpty(set)) {
            for (User user : set) {
                if (!user.isActive()) continue;
                hashSet.add(user);
            }
        }
        return hashSet;
    }

    private void filterCategories(MessageQuery messageQuery, QMessage qMessage, DBQuery<?> dBQuery) {
        if (messageQuery.getCategory() != null) {
            dBQuery.where((Predicate)qMessage.category().eq((Object)((MessageCategory)this.conversionHandler.convert(MessageCategory.class, (Object)messageQuery.getCategory()))));
        } else {
            ProductsAccessor productsAccessor = this.getSessionData().getProducts();
            dBQuery.where((Predicate)qMessage.category().in((Collection)productsAccessor.admin().getViewMessagesSentToSysWithCat()));
        }
    }

    private void filterDestination(MessageDestination messageDestination, QIncomingMessage qIncomingMessage, DBQuery<?> dBQuery) {
        switch (messageDestination) {
            case SYSTEM: {
                dBQuery.where((Predicate)qIncomingMessage.fromOwner.eq((Object)MessageOwner.SYSTEM));
                break;
            }
            case USER: {
                dBQuery.where((Predicate)qIncomingMessage.fromOwner.eq((Object)MessageOwner.USER));
                break;
            }
            case GROUP: {
                break;
            }
            case BROKERED: {
                break;
            }
        }
    }

    private void filterDestination(MessageDestination messageDestination, QMessage qMessage, DBQuery<?> dBQuery) {
        QIncomingMessage qIncomingMessage = QIncomingMessage.incomingMessage;
        QOutgoingMessage qOutgoingMessage = QOutgoingMessage.outgoingMessage;
        switch (messageDestination) {
            case SYSTEM: {
                DBQuery dBQuery2 = (DBQuery)((DBQuery)this.subQuery(new EntityPath[0]).from((EntityPath)qIncomingMessage)).where(new Predicate[]{qIncomingMessage.eq((Expression)qMessage), qIncomingMessage.fromOwner.eq((Object)MessageOwner.SYSTEM)});
                DBQuery dBQuery3 = (DBQuery)((DBQuery)this.subQuery(new EntityPath[0]).from((EntityPath)qOutgoingMessage)).where(new Predicate[]{qOutgoingMessage.eq((Expression)qMessage), qOutgoingMessage.destination.eq((Object)MessageDestination.SYSTEM)});
                dBQuery.where((Predicate)dBQuery2.exists().or((Predicate)dBQuery3.exists()));
                break;
            }
            case USER: {
                DBQuery dBQuery4 = (DBQuery)((DBQuery)this.subQuery(new EntityPath[0]).from((EntityPath)qIncomingMessage)).where(new Predicate[]{qIncomingMessage.eq((Expression)qMessage), qIncomingMessage.fromOwner.eq((Object)MessageOwner.USER)});
                DBQuery dBQuery5 = (DBQuery)((DBQuery)this.subQuery(new EntityPath[0]).from((EntityPath)qOutgoingMessage)).where(new Predicate[]{qOutgoingMessage.eq((Expression)qMessage), qOutgoingMessage.destination.eq((Object)MessageDestination.USER)});
                dBQuery.where((Predicate)dBQuery4.exists().or((Predicate)dBQuery5.exists()));
                break;
            }
            case GROUP: {
                DBQuery dBQuery6 = (DBQuery)((DBQuery)this.subQuery(new EntityPath[0]).from((EntityPath)qOutgoingMessage)).where(new Predicate[]{qOutgoingMessage.eq((Expression)qMessage), qOutgoingMessage.destination.eq((Object)MessageDestination.USER)});
                dBQuery.where((Predicate)dBQuery6.exists());
                break;
            }
            case BROKERED: {
                DBQuery dBQuery7 = (DBQuery)((DBQuery)this.subQuery(new EntityPath[0]).from((EntityPath)qOutgoingMessage)).where(new Predicate[]{qOutgoingMessage.eq((Expression)qMessage), qOutgoingMessage.destination.eq((Object)MessageDestination.BROKERED)});
                dBQuery.where((Predicate)dBQuery7.exists());
                break;
            }
        }
    }

    private void filterDestination(MessageDestination messageDestination, QOutgoingMessage qOutgoingMessage, DBQuery<?> dBQuery) {
        switch (messageDestination) {
            case SYSTEM: {
                dBQuery.where((Predicate)qOutgoingMessage.destination.eq((Object)MessageDestination.SYSTEM));
                break;
            }
            case USER: {
                dBQuery.where((Predicate)qOutgoingMessage.destination.eq((Object)MessageDestination.USER));
                if (!this.isAdmin()) break;
                QUser qUser = QUser.user;
                DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qUser}).where((Predicate)qUser.in((CollectionExpression)qOutgoingMessage.toUsers).and((Predicate)qUser.group().in((Collection)this.groupsHandler.all().groups().items())));
                dBQuery.where((Predicate)dBQuery2.exists());
                break;
            }
            case GROUP: {
                dBQuery.where((Predicate)qOutgoingMessage.destination.eq((Object)MessageDestination.GROUP));
                if (!this.isAdmin()) break;
                QGroup qGroup = QGroup.group;
                DBQuery dBQuery3 = (DBQuery)this.subQuery(new EntityPath[]{qGroup}).where((Predicate)qGroup.in((CollectionExpression)qOutgoingMessage.toGroups).and((Predicate)qGroup.in((Collection)this.groupsHandler.all().groups().items())));
                dBQuery.where((Predicate)dBQuery3.exists());
                break;
            }
            case BROKERED: {
                dBQuery.where((Predicate)qOutgoingMessage.destination.eq((Object)MessageDestination.BROKERED));
                break;
            }
        }
    }

    private List<MessageVO> getConversationOf(Message message) {
        if (message.getConversationId() == null) {
            return new ArrayList<MessageVO>();
        }
        MessageQuery messageQuery = new MessageQuery();
        messageQuery.setConversationId(message.getConversationId());
        messageQuery.setUnlimited();
        messageQuery.setMessageBox(MessageBox.SENT_ITEMS);
        ArrayList<MessageVO> arrayList = new ArrayList<MessageVO>();
        arrayList.addAll(this.conversionHandler.convertList(OutgoingMessageVO.class, (Iterable)this.search(messageQuery).getPageItems()));
        messageQuery.setMessageBox(MessageBox.INBOX);
        arrayList.addAll(this.conversionHandler.convertList(IncomingMessageVO.class, (Iterable)this.search(messageQuery).getPageItems()));
        Collections.sort(arrayList, (messageVO, messageVO2) -> messageVO2.getDate().compareTo(messageVO.getDate()));
        return arrayList;
    }

    private int getMaxMessageRecipients() {
        return this.getSessionData().getProducts().product().getMaxMessageRecipients();
    }

    private List<MessageCategoryVO> listCategories(Long l) {
        if (!this.isAdmin() && l != null) {
            return Collections.emptyList();
        }
        List list = this.messageCategoryService.getAccessible();
        return this.conversionHandler.convertList(MessageCategoryVO.class, (Iterable)list);
    }

    private IncomingMessage prepareIncomingMessage(SendMessageDTO sendMessageDTO, User user, Date date, MessageOwner messageOwner) {
        IncomingMessage incomingMessage = (IncomingMessage)this.conversionHandler.convertExcluding(IncomingMessage.class, (Object)sendMessageDTO, new Object[]{SendMessageDTO.CATEGORY.getName()});
        incomingMessage.setRead(false);
        incomingMessage.setDate(date);
        incomingMessage.setFromUser(user);
        incomingMessage.setFromOwner(messageOwner);
        incomingMessage.setCategory((MessageCategory)this.conversionHandler.convert(MessageCategory.class, (Object)sendMessageDTO.getCategory()));
        return incomingMessage;
    }

    private void validate(SendMessageDTO sendMessageDTO) {
        Validator validator = new Validator();
        validator.property((Property)SendMessageDTO.DESTINATION, MessagingKeys.Messages.SEND_TO).required();
        validator.property((Property)SendMessageDTO.SUBJECT, MessagingKeys.Messages.SUBJECT).required();
        validator.property((Property)SendMessageDTO.BODY, MessagingKeys.Messages.BODY).required();
        if (sendMessageDTO.getDestination() == MessageDestination.GROUP) {
            validator.property((Property)SendMessageDTO.TO_GROUPS, MessagingKeys.Messages.TO_GROUPS).required();
        }
        if (sendMessageDTO.getReplyToId() == null) {
            if (sendMessageDTO.getDestination() == MessageDestination.USER) {
                org.cyclos.impl.utils.validation.Property property = validator.property((Property)SendMessageDTO.TO_USERS, MessagingKeys.Messages.TO_USERS);
                property.required().maxElements(this.getMaxMessageRecipients());
                Set set = this.conversionHandler.convertSet(User.class, (Iterable)sendMessageDTO.getToUsers());
                Set set2 = set.stream().filter(user -> !this.productsHandler.getAccessor((BasicUser)user).product().hasPermission(Permission.MY_MESSAGES_VIEW)).collect(Collectors.toSet());
                if (!set2.isEmpty()) {
                    property.invalid(new ValidationError(MessagingKeys.Messages.CANNOT_SEND_TO_SOME_USER, new Object[]{set2}));
                }
            }
            if (this.isAdmin() || sendMessageDTO.getDestination() == MessageDestination.SYSTEM) {
                validator.property((Property)SendMessageDTO.CATEGORY, MessagingKeys.Messages.CATEGORY).required();
            }
        }
        this.validate(validator, sendMessageDTO, "sendMessageDTO");
    }

    static {
        HashMap<Class, Class> hashMap = new HashMap<Class, Class>();
        hashMap.put(IncomingMessage.class, IncomingMessageVO.class);
        hashMap.put(OutgoingMessage.class, OutgoingMessageVO.class);
        VO_TYPE_MAPPING = Collections.unmodifiableMap(hashMap);
    }
}

