/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.AdCategoryImage;
import org.cyclos.entities.marketplace.QAdCategory;
import org.cyclos.entities.marketplace.QAdCategoryImage;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdCategoryCacheKey;
import org.cyclos.impl.marketplace.AdCategoryImageServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.categories.AdCategoryDTO;
import org.cyclos.model.marketplace.categories.AdCategoryData;
import org.cyclos.model.marketplace.categories.AdCategoryDetailedVO;
import org.cyclos.model.marketplace.categories.AdCategoryNodeType;
import org.cyclos.model.marketplace.categories.AdCategoryQuery;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdCategoryServiceImpl
extends CRUDServiceImpl<AdCategory, QAdCategory, AdCategoryDTO, AdCategoryData, AdCategoryVO>
implements AdCategoryServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{AdCategoryDTO.IMAGE};
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private AdCategoryImageServiceLocal adCategoryImageService;
    private Cache<AdCategoryCacheKey, AccessorCacheValue> adCategoriesCache;

    public AdCategoryServiceImpl() {
        super(AdCategory.class, QAdCategory.adCategory, AdCategoryDTO.class);
    }

    public void clearAdCategoriesCache(Long l) {
        Long l2 = SimpleEntity.id((SimpleEntity)this.getSessionData().getNetwork());
        this.cacheHandler.schedulePartialEvict(CacheType.AD_CATEGORIES, (SerializablePredicate)new CacheEvictNetWorkPredicate(l2, l));
    }

    public AdCategoryVO findByParentAndInternalName(AdCategoryVO adCategoryVO, String string) throws FrameworkException {
        AdCategory adCategory = (AdCategory)((DBQuery)this.from().where(new Predicate[]{adCategoryVO == null ? ((QAdCategory)this.$).parent().isNull() : ((QAdCategory)this.$).parent().id.eq((Object)adCategoryVO.getId()), ((QAdCategory)this.$).internalName.eq((Object)string)})).singleResult((Expression)this.$);
        return (AdCategoryVO)this.conversionHandler.convert(AdCategoryVO.class, (Object)adCategory);
    }

    @PostConstruct
    public void initialize() {
        this.adCategoriesCache = this.cacheHandler.getCache(CacheType.AD_CATEGORIES);
    }

    public List<AdCategory> listRoot(boolean bl) throws FrameworkException {
        return ((DBQuery)((DBQuery)this.from().where(new Predicate[]{bl ? ((QAdCategory)this.$).active.isTrue() : ((QAdCategory)this.$).id.isNotNull(), ((QAdCategory)this.$).parent().isNull()})).orderBy(((QAdCategory)this.$).order.asc())).list((Expression)this.$);
    }

    public List<AdCategoryDetailedVO> listVisible(User user) {
        SessionData sessionData = this.getSessionData();
        AdCategoryQuery adCategoryQuery = new AdCategoryQuery();
        adCategoryQuery.setUnlimited();
        List list = (List)((AccessorCacheValue)this.adCategoriesCache.get((Serializable)new AdCategoryCacheKey(sessionData.getConfiguration().getLanguage().getId(), SimpleEntity.id((SimpleEntity)sessionData.getNetwork())), this.adCategoriesCacheProducer(adCategoryQuery))).unwrap(this.getApplicationContext());
        List list2 = null;
        if (sessionData.isAdmin() && user != null && !sessionData.getLoggedUser().equals((Object)user)) {
            list2 = this.configurationHandler.getAccessAccessor((BasicUser)user).getVisibleAdCategories();
        } else if (!sessionData.isAdmin()) {
            list2 = user == null ? sessionData.getConfiguration().getVisibleAdCategories() : this.configurationHandler.getAccessAccessor((BasicUser)user).getVisibleAdCategories();
        }
        List list3 = list2;
        if (CollectionHelper.isNotEmpty(list3)) {
            list.removeIf(adCategoryDetailedVO -> list3.stream().noneMatch(adCategory -> adCategory.getId().equals(this.findRootCategory((AdCategoryDetailedVO)adCategoryDetailedVO).getId())));
        }
        return list;
    }

    @Override
    public AdCategory newEntity(AdCategoryVO adCategoryVO) {
        AdCategory adCategory = new AdCategory();
        AdCategory adCategory2 = (AdCategory)this.conversionHandler.convert(AdCategory.class, (Object)adCategoryVO);
        adCategory.setParent(adCategory2);
        return adCategory;
    }

    public void saveCategories(List<AdCategoryDTO> list) {
        if (CollectionHelper.isEmpty(list)) {
            throw new IllegalArgumentException("Ad categories cannot be empty");
        }
        for (AdCategoryDTO adCategoryDTO : list) {
            this.save(adCategoryDTO);
        }
    }

    @Override
    public void saveOrder(List<Long> list) {
        super.saveOrder(list);
        this.clearAdCategoriesCache(null);
    }

    public Page<AdCategoryDetailedVO> search(AdCategoryQuery adCategoryQuery) {
        return ((DBQuery)this.createQuery(adCategoryQuery).orderBy(((QAdCategory)this.$).orderHierarchy().asc())).page(AdCategoryDetailedVO.class, (QueryParameters)adCategoryQuery, (Expression)this.$);
    }

    public void sortAlphabetically(AdCategoryVO adCategoryVO) {
        AdCategory adCategory = (AdCategory)this.conversionHandler.convert(AdCategory.class, (Object)adCategoryVO);
        AdCategoryQuery adCategoryQuery = new AdCategoryQuery();
        if (adCategory == null) {
            adCategoryQuery.setNodeType(AdCategoryNodeType.ROOT);
        } else {
            adCategoryQuery.setParent(adCategoryVO);
        }
        adCategoryQuery.setUnlimited();
        List list = ((DBQuery)this.createQuery(adCategoryQuery).orderBy(((QAdCategory)this.$).name.asc())).list((Expression)((QAdCategory)this.$).id);
        this.saveOrder(list);
        this.clearAdCategoriesCache(null);
    }

    @Override
    public AdCategoryDTO toDTO(AdCategory adCategory) {
        AdCategoryDTO adCategoryDTO = (AdCategoryDTO)super.toDTO(adCategory);
        adCategoryDTO.setImage((ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)adCategory.getImage()));
        return adCategoryDTO;
    }

    @Override
    public AdCategory toEntity(AdCategoryDTO adCategoryDTO) {
        Image image;
        if (adCategoryDTO.isPersistent() && adCategoryDTO.getImage() == null) {
            this.adCategoryImageService.removeAll((BaseEntity)((AdCategory)this.find(adCategoryDTO.getId())));
        }
        AdCategory adCategory = (AdCategory)super.toEntity(adCategoryDTO);
        if (adCategoryDTO.getImage() != null && (image = (Image)this.conversionHandler.convert(Image.class, (Object)adCategoryDTO.getImage())) instanceof TempImage) {
            adCategory.setUploadedImage((TempImage)image);
        }
        return adCategory;
    }

    @Override
    protected AdCategoryData getData(AdCategory adCategory) {
        AdCategoryData adCategoryData = new AdCategoryData();
        adCategoryData.setDto((EntityDTO)this.toDTO(adCategory));
        return adCategoryData;
    }

    @Override
    protected Object[] getExcludedPropertiesToDTO(AdCategory adCategory) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(AdCategoryDTO adCategoryDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterRemove(AdCategory adCategory) {
        AdCategoryQuery adCategoryQuery = new AdCategoryQuery();
        if (adCategory.getParent() != null) {
            AdCategoryVO adCategoryVO = new AdCategoryVO();
            adCategoryVO.setId(adCategory.getParent().getId());
            adCategoryQuery.setParent(adCategoryVO);
        }
        this.saveOrder(EntityVO.ids(this.search(adCategoryQuery)));
        this.clearAdCategoriesCache(null);
    }

    @Override
    protected void onAfterSave(AdCategory adCategory, AdCategory adCategory2, Object object) {
        TempImage tempImage;
        if (adCategory2 != null && adCategory.getChildrenCount() > 0 && adCategory2.getActive() != adCategory.getActive()) {
            this.activateSubCategories(adCategory, adCategory.getActive());
        }
        if (!adCategory.getActive().booleanValue()) {
            this.setInactiveCategory(adCategory.getParent());
        }
        if ((tempImage = adCategory.getUploadedImage()) != null) {
            this.adCategoryImageService.importTempImage((BaseEntity)adCategory, tempImage);
        }
        this.clearAdCategoriesCache(null);
    }

    @Override
    protected void onBeforeRemove(AdCategory adCategory) {
        CollectionHelper.orEmpty((List)adCategory.getImages()).stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
    }

    @Override
    protected Object onBeforeSave(AdCategory adCategory, AdCategory adCategory2) {
        if (adCategory.isTransient()) {
            AdCategoryQuery adCategoryQuery = new AdCategoryQuery();
            AdCategory adCategory3 = adCategory.getParent();
            if (adCategory3 == null) {
                adCategoryQuery.setNodeType(AdCategoryNodeType.ROOT);
            } else {
                adCategoryQuery.setParent(new AdCategoryVO(adCategory3.getId()));
            }
            adCategoryQuery.setCountOnly();
            adCategory.setOrder(CollectionHelper.getTotalCount(this.search(adCategoryQuery)));
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAdCategory)this.$).network());
    }

    @Override
    protected Validator resolveValidator(final AdCategoryDTO adCategoryDTO) {
        Validator validator = new Validator();
        validator.property((Property)AdCategoryDTO.IMAGE, MarketplaceKeys.Categories.IMAGE).entity(Image.class, (EntityValidation)new BaseEntityValidation<Image>(){

            protected boolean isValid(Object object, Object object2, Image image) {
                if (image instanceof TempImage) {
                    TempImage tempImage = (TempImage)image;
                    return tempImage.getTarget() == TempImageTarget.AD_CATEGORY;
                }
                if (image instanceof AdCategoryImage) {
                    AdCategoryImage adCategoryImage = (AdCategoryImage)image;
                    return adCategoryImage.getCategory().getId().equals(adCategoryDTO.getId());
                }
                return false;
            }
        });
        return validator;
    }

    private void activateSubCategories(AdCategory adCategory, boolean bl) {
        if (adCategory.getChildrenCount() > 0) {
            for (AdCategory adCategory2 : adCategory.getChildren()) {
                adCategory2.setActive(Boolean.valueOf(bl));
                this.activateSubCategories(adCategory2, bl);
            }
        }
    }

    private Callable<AccessorCacheValue> adCategoriesCacheProducer(AdCategoryQuery adCategoryQuery) {
        return () -> {
            List list = ((DBQuery)this.createQuery(adCategoryQuery).orderBy(((QAdCategory)this.$).orderHierarchy().asc())).list(AdCategoryDetailedVO.class, (Expression)this.$);
            return AccessorCacheValue.create((Collection)list);
        };
    }

    private DBQuery<?> createQuery(AdCategoryQuery adCategoryQuery) {
        QAdCategory qAdCategory = new QAdCategory("c1");
        QAdCategory qAdCategory2 = new QAdCategory("c2");
        QAdCategory qAdCategory3 = new QAdCategory("c3");
        QAdCategoryImage qAdCategoryImage = QAdCategoryImage.adCategoryImage;
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from().leftJoin((CollectionExpression)((QAdCategory)this.$).images, (Path)qAdCategoryImage)).leftJoin((EntityPath)((QAdCategory)this.$).parent(), (Path)qAdCategory)).leftJoin((EntityPath)qAdCategory.parent(), (Path)qAdCategory2)).leftJoin((EntityPath)qAdCategory2.parent(), (Path)qAdCategory3);
        AdCategory adCategory = (AdCategory)this.conversionHandler.convert(AdCategory.class, (Object)adCategoryQuery.getParent());
        if (adCategory != null) {
            dBQuery.where((Predicate)qAdCategory.eq((Object)adCategory));
        }
        if (!adCategoryQuery.isReturnInactive()) {
            dBQuery.where(new Predicate[]{((QAdCategory)this.$).active.isTrue(), qAdCategory.id.isNull().or((Predicate)qAdCategory.active.isTrue()), qAdCategory2.id.isNull().or((Predicate)qAdCategory2.active.isTrue()), qAdCategory3.id.isNull().or((Predicate)qAdCategory3.active.isTrue())});
        }
        if (QueryHelper.useParameter((Object)adCategoryQuery.getNodeType())) {
            switch (adCategoryQuery.getNodeType()) {
                case LEAF: {
                    dBQuery.where((Predicate)((QAdCategory)this.$).children.isEmpty());
                    break;
                }
                case ROOT: {
                    QAdCategory qAdCategory4 = new QAdCategory("p");
                    ((DBQuery)dBQuery.leftJoin((EntityPath)((QAdCategory)this.$).parent(), (Path)qAdCategory4)).where((Predicate)qAdCategory4.id.isNull());
                }
            }
        }
        return dBQuery;
    }

    private AdCategoryDetailedVO findRootCategory(AdCategoryDetailedVO adCategoryDetailedVO) {
        if (adCategoryDetailedVO.getParent() == null) {
            return adCategoryDetailedVO;
        }
        return this.findRootCategory(adCategoryDetailedVO.getParent());
    }

    private void setInactiveCategory(AdCategory adCategory2) {
        if (adCategory2 == null) {
            return;
        }
        List list = adCategory2.getChildren();
        if (CollectionHelper.isNotEmpty((Iterable)list) && list.stream().allMatch(adCategory -> adCategory.getActive() == false)) {
            adCategory2.setActive(Boolean.valueOf(false));
        }
    }

    private static class CacheEvictNetWorkPredicate
    implements SerializablePredicate<AdCategoryCacheKey> {
        private static final long serialVersionUID = 1L;
        private Long networkId;
        private Long languageId;

        CacheEvictNetWorkPredicate(Long l, Long l2) {
            this.networkId = l;
            this.languageId = l2;
        }

        public boolean test(AdCategoryCacheKey adCategoryCacheKey) {
            return Objects.equals(this.networkId, adCategoryCacheKey.getNetworkId()) && (this.languageId == null || this.languageId.equals(adCategoryCacheKey.getLanguageId()));
        }
    }
}

