/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.Expression;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.contentmanagement.QDocumentCategory;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.contentmanagement.DocumentCategoryServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.Property;
import org.cyclos.model.contentmanagement.documentcategories.DocumentCategoryDTO;
import org.cyclos.model.contentmanagement.documentcategories.DocumentCategoryData;
import org.cyclos.model.contentmanagement.documentcategories.DocumentCategoryVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.users.products.AdminProductDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentCategoryServiceImpl
extends CRUDServiceImpl<DocumentCategory, QDocumentCategory, DocumentCategoryDTO, DocumentCategoryData, Void>
implements DocumentCategoryServiceLocal {
    @Autowired
    private ProductServiceLocal productService;

    public DocumentCategoryServiceImpl() {
        super(DocumentCategory.class, QDocumentCategory.documentCategory, DocumentCategoryDTO.class);
    }

    public List<DocumentCategory> getDocumentCategoriesManage() {
        return this.getSessionData().getProducts().userManagement().getDocumentCategoryManage();
    }

    public List<DocumentCategory> getDocumentCategoriesView() {
        return this.getSessionData().getProducts().product().getDocumentCategoryView();
    }

    public List<DocumentCategoryVO> list() {
        return ((DBQuery)this.from().orderBy(((QDocumentCategory)this.$).order.asc())).list(DocumentCategoryVO.class, (Expression)this.$);
    }

    @Override
    public DocumentCategory newEntity(Void void_) {
        return new DocumentCategory();
    }

    @Override
    protected void doRemove(DocumentCategory documentCategory, boolean bl) {
        this.productService.removeAllRelationships((Property)AdminProductDTO.DOCUMENT_CATEGORY_VIEW, (SimpleEntity)documentCategory);
        this.productService.removeAllRelationships((Property)AdminProductDTO.DOCUMENT_CATEGORY_MANAGE, (SimpleEntity)documentCategory);
        super.doRemove(documentCategory, bl);
    }

    @Override
    protected DocumentCategoryData getData(DocumentCategory documentCategory) {
        DocumentCategoryData documentCategoryData = new DocumentCategoryData();
        documentCategoryData.setDto((EntityDTO)((DocumentCategoryDTO)this.toDTO(documentCategory)));
        return documentCategoryData;
    }

    @Override
    protected void onAfterSave(DocumentCategory documentCategory, DocumentCategory documentCategory2, Object object) {
        if (documentCategory2 == null && this.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)this.getSessionData().getGroup();
            AdminProduct adminProduct = adminGroup.getAdminProduct();
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.DOCUMENT_CATEGORY_VIEW, (SimpleEntity)documentCategory);
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.DOCUMENT_CATEGORY_MANAGE, (SimpleEntity)documentCategory);
        }
    }

    @Override
    protected Object onBeforeSave(DocumentCategory documentCategory, DocumentCategory documentCategory2) {
        Integer n = (Integer)this.from().singleResult((Expression)((QDocumentCategory)this.$).order.max());
        documentCategory.setOrder(Integer.valueOf(n != null ? n + 1 : 1));
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QDocumentCategory)this.$).network());
    }

    @Override
    protected Validator resolveValidator(DocumentCategoryDTO documentCategoryDTO) {
        Validator validator = new Validator();
        validator.property(DocumentCategoryDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        return validator;
    }
}

