/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.StringPath;
import java.util.List;
import javax.annotation.PostConstruct;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.contentmanagement.DataTranslation;
import org.cyclos.entities.contentmanagement.QDataTranslation;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.ApplicationInitializationListener;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.DataTranslationEntityMapping;
import org.cyclos.impl.contentmanagement.DataTranslationHandlerImplementor;
import org.cyclos.impl.contentmanagement.DataTranslationMapping;
import org.cyclos.impl.contentmanagement.DataTranslationPropertyMapping;
import org.cyclos.impl.contentmanagement.DataTranslationStorageKey;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.utils.ReplicatedStorage;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.ReplicatedStorageType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.NamedEntityDTO;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataTranslationHandlerImpl
extends BaseNetworkedHandlerImpl
implements DataTranslationHandlerImplementor,
ApplicationInitializationListener {
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private LanguageServiceLocal languageService;
    @Autowired
    private ClusterHandler clusterHandler;
    private ReplicatedStorage<DataTranslationStorageKey, String> dataTranslationStorage;

    public void addToStorage(DataTranslation dataTranslation) {
        DataTranslationStorageKey dataTranslationStorageKey = new DataTranslationStorageKey(dataTranslation.getLanguage().getId(), dataTranslation.getType(), dataTranslation.getEntityId(), dataTranslation.getPropertyName());
        this.dataTranslationStorage.set((Object)dataTranslationStorageKey, (Object)dataTranslation.getValue());
    }

    public String getName(Language language, NamedEntity namedEntity) throws FrameworkException {
        return this.getValue(language, (BaseEntity)namedEntity, NamedEntityDTO.NAME.getName());
    }

    public String getName(NamedEntity namedEntity) throws FrameworkException {
        return this.getName(this.getConfiguration().getLanguage(), namedEntity);
    }

    public String getValue(BaseEntity baseEntity, String string, boolean bl) throws FrameworkException {
        return this.getValue(this.getConfiguration().getLanguage(), baseEntity, string, bl);
    }

    public String getValue(BaseEntity baseEntity, StringPath stringPath) throws FrameworkException {
        return this.getValue(baseEntity, PropertyHelper.getPropertyName((Path)stringPath), true);
    }

    public String getValue(Language language, BaseEntity baseEntity, String string) {
        return this.getValue(language, baseEntity, string, true);
    }

    public String getValue(Language language, BaseEntity baseEntity, String string, boolean bl) throws FrameworkException {
        return this.getValue(language, baseEntity, string, bl, true);
    }

    @Override
    public String getValue(Language language, BaseEntity baseEntity, String string, boolean bl, boolean bl2) throws FrameworkException {
        String string2;
        if (baseEntity == null || baseEntity.isTransient()) {
            return null;
        }
        DataTranslationType dataTranslationType = baseEntity.getDataTranslationType();
        if (dataTranslationType == null) {
            return null;
        }
        DataTranslationEntityMapping dataTranslationEntityMapping = DataTranslationMapping.get(dataTranslationType);
        DataTranslationPropertyMapping dataTranslationPropertyMapping = dataTranslationEntityMapping.getProperty(string);
        if (dataTranslationPropertyMapping == null) {
            return null;
        }
        BeanWrapper beanWrapper = InvocationContext.wrap((Object)baseEntity);
        String string3 = dataTranslationPropertyMapping.getName();
        try {
            string2 = (String)beanWrapper.getPropertyValue(string3);
            if (StringHelper.isBlank((Object)string2)) {
                return null;
            }
        }
        catch (NotReadablePropertyException notReadablePropertyException) {
            return null;
        }
        String string4 = null;
        if (!bl2) {
            DataTranslationStorageKey dataTranslationStorageKey = new DataTranslationStorageKey(language.getId(), dataTranslationType, baseEntity.getId(), string);
            string4 = (String)this.dataTranslationStorage.get((Object)dataTranslationStorageKey);
        } else {
            Language language2;
            DataTranslationStorageKey dataTranslationStorageKey;
            List list = this.languageService.getHierarchy(language);
            for (int i = list.size() - 1; i >= 0 && !StringHelper.isNotBlank((Object)(string4 = (String)this.dataTranslationStorage.get((Object)(dataTranslationStorageKey = new DataTranslationStorageKey((language2 = (Language)list.get(i)).getId(), dataTranslationType, baseEntity.getId(), string))))); --i) {
            }
            if (StringHelper.isBlank(string4) && bl) {
                string4 = string2;
            }
        }
        return this.richTextHandler.applyPropertyMapping(dataTranslationPropertyMapping, string4, false);
    }

    public String getValue(Language language, BaseEntity baseEntity, StringPath stringPath) throws FrameworkException {
        return this.getValue(language, baseEntity, PropertyHelper.getPropertyName((Path)stringPath), true);
    }

    @PostConstruct
    public void initialize() {
        this.dataTranslationStorage = this.clusterHandler.getReplicatedStorage(ReplicatedStorageType.DATA_TRANSLATIONS);
    }

    public void onApplicationInitialization() {
        QDataTranslation qDataTranslation = QDataTranslation.dataTranslation;
        try (CloseableIterator closeableIterator = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qDataTranslation}).where((Predicate)qDataTranslation.value.isNotNull())).iterate((Expression)Projections.list((Expression[])new Expression[]{Projections.constructor(DataTranslationStorageKey.class, (Expression[])new Expression[]{qDataTranslation.language().id, qDataTranslation.type, qDataTranslation.entityId, qDataTranslation.propertyName}), qDataTranslation.value}));){
            while (closeableIterator.hasNext()) {
                List list = (List)closeableIterator.next();
                DataTranslationStorageKey dataTranslationStorageKey = (DataTranslationStorageKey)list.get(0);
                String string = (String)list.get(1);
                this.dataTranslationStorage.set((Object)dataTranslationStorageKey, (Object)string);
            }
        }
    }

    public void removeFromStorage(DataTranslation dataTranslation) {
        DataTranslationStorageKey dataTranslationStorageKey = new DataTranslationStorageKey(dataTranslation.getLanguage().getId(), dataTranslation.getType(), dataTranslation.getEntityId(), dataTranslation.getPropertyName());
        this.dataTranslationStorage.remove((Object)dataTranslationStorageKey);
    }
}

