/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.TimeZone;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.QVoucherCategory;
import org.cyclos.entities.banking.QVoucherConfiguration;
import org.cyclos.entities.banking.QVoucherType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.banking.VoucherTypeImage;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.VoucherCategoryServiceLocal;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherTemplateServiceLocal;
import org.cyclos.impl.banking.VoucherTypeImageServiceLocal;
import org.cyclos.impl.banking.VoucherTypeServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationAmount;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.banking.vouchers.VoucherPaymentDestination;
import org.cyclos.model.banking.vouchertypes.VoucherExpirationType;
import org.cyclos.model.banking.vouchertypes.VoucherRedeemRestrictTo;
import org.cyclos.model.banking.vouchertypes.VoucherTypeDTO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeData;
import org.cyclos.model.banking.vouchertypes.VoucherTypeListData;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.WeekDay;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherTypeServiceImpl
extends CRUDServiceImpl<VoucherType, QVoucherType, VoucherTypeDTO, VoucherTypeData, ConfigurationVO>
implements VoucherTypeServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{VoucherTypeDTO.IMAGE};
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private VoucherTypeImageServiceLocal voucherTypeImageService;
    @Autowired
    private VoucherTemplateServiceLocal voucherTemplateService;
    @Autowired
    private VoucherCategoryServiceLocal voucherCategoryService;
    @Autowired
    private VoucherCustomFieldServiceLocal voucherCustomFieldService;

    public VoucherTypeServiceImpl() {
        super(VoucherType.class, QVoucherType.voucherType, VoucherTypeDTO.class);
    }

    public VoucherType findAny() {
        return (VoucherType)((DBQuery)this.selectFrom(this.$).where((Predicate)((QVoucherType)this.$).configuration().in(this.getAccessibleConfigurations()))).fetchFirst();
    }

    public VoucherTypeListData getListData() throws FrameworkException {
        VoucherTypeListData voucherTypeListData = new VoucherTypeListData();
        List<VoucherConfiguration> list = this.getAccessibleConfigurations();
        voucherTypeListData.setAccessibleConfigurations(this.conversionHandler.convertList(VoucherConfigurationVO.class, list));
        voucherTypeListData.setCategories(this.voucherCategoryService.list());
        voucherTypeListData.setVoucherTypes(this.list());
        return voucherTypeListData;
    }

    public List<VoucherTypeVO> list() throws FrameworkException {
        List<VoucherConfiguration> list = this.getAccessibleConfigurations();
        List<VoucherType> list2 = this.doList(list, false, false, null);
        return this.conversionHandler.convertList(VoucherTypeVO.class, list2);
    }

    public List<VoucherType> listEnabledByConfiguration(Collection<VoucherConfiguration> collection, Boolean bl) throws FrameworkException {
        return this.doList(collection, true, true, bl);
    }

    public List<VoucherType> listForSearchFilterByConfiguration(Collection<VoucherConfiguration> collection) throws FrameworkException {
        return this.doList(collection, !this.getSessionData().isAdmin(), false, null);
    }

    @Override
    public VoucherType newEntity(ConfigurationVO configurationVO) {
        VoucherConfiguration voucherConfiguration = (VoucherConfiguration)this.conversionHandler.convert(VoucherConfiguration.class, (Object)configurationVO);
        VoucherType voucherType = new VoucherType();
        voucherType.setConfiguration(voucherConfiguration);
        voucherType.setEnabled(true);
        voucherType.setExpirationType(VoucherExpirationType.INTERVAL);
        voucherType.setExpirationInterval(TimeInterval.ONE_YEAR);
        voucherType.setRedeemRestrict(VoucherRedeemRestrictTo.ALL);
        voucherType.setRedeemOnWeekDays(EnumSet.allOf(WeekDay.class));
        voucherType.setAllowPartialRedeems(true);
        voucherType.setAllowBuying(voucherConfiguration.getGenerationStatus() == VoucherGenerationStatus.ACTIVE);
        return voucherType;
    }

    @Override
    public VoucherType toEntity(VoucherTypeDTO voucherTypeDTO) {
        Image image;
        if (voucherTypeDTO.getImage() == null && voucherTypeDTO.isPersistent()) {
            this.voucherTypeImageService.removeAll((BaseEntity)((VoucherType)this.find(voucherTypeDTO.getId())));
        }
        VoucherType voucherType = (VoucherType)super.toEntity(voucherTypeDTO);
        if (!voucherTypeDTO.isLimitBuyAmountPerPeriod()) {
            voucherType.setMaxBuyAmountActualPeriod(null);
            voucherType.setMaxBuyAmountPerPeriod(null);
        }
        if (voucherTypeDTO.getImage() != null && (image = (Image)this.conversionHandler.convert(Image.class, (Object)voucherTypeDTO.getImage())) instanceof TempImage) {
            voucherType.setUploadedImage((TempImage)image);
        }
        return voucherType;
    }

    @Override
    protected VoucherTypeData getData(VoucherType voucherType) {
        VoucherConfiguration voucherConfiguration = voucherType.getConfiguration();
        VoucherTypeData voucherTypeData = new VoucherTypeData();
        voucherTypeData.setDto((EntityDTO)((VoucherTypeDTO)this.toDTO(voucherType)));
        List<VoucherConfiguration> list = this.getAccessibleConfigurations();
        voucherTypeData.setHasMultipleAccessibleConfigurations(list.size() > 1);
        voucherTypeData.setGenerationStatus(voucherConfiguration.getGenerationStatus());
        voucherTypeData.setGenerationAmount(voucherConfiguration.getGenerationAmount());
        voucherTypeData.setCategories(this.voucherCategoryService.list());
        voucherTypeData.setTemplates(this.voucherTemplateService.list());
        voucherTypeData.setUserGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
        voucherTypeData.setAccountNameFromConfiguration(this.getTranslatedValue((BaseEntity)voucherConfiguration, QVoucherConfiguration.voucherConfiguration.accountName));
        if (voucherType.isPersistent()) {
            voucherTypeData.setRelatedCustomFields(this.voucherCustomFieldService.listAllRelated(new VoucherTypeVO(voucherType.getId())));
            voucherTypeData.setCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)this.voucherCustomFieldService.listAll()));
        }
        return voucherTypeData;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(VoucherTypeDTO voucherTypeDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterSave(VoucherType voucherType, VoucherType voucherType2, Object object) {
        TempImage tempImage = voucherType.getUploadedImage();
        if (tempImage != null) {
            this.voucherTypeImageService.importTempImage((BaseEntity)voucherType, tempImage);
        }
    }

    @Override
    protected void onBeforeRemove(VoucherType voucherType) {
        CollectionHelper.orEmpty((List)voucherType.getImages()).stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
    }

    @Override
    protected Object onBeforeSave(VoucherType voucherType, VoucherType voucherType2) {
        Object object;
        Object object2;
        VoucherConfiguration voucherConfiguration = voucherType.getConfiguration();
        VoucherGenerationStatus voucherGenerationStatus = voucherConfiguration.getGenerationStatus();
        VoucherGenerationAmount voucherGenerationAmount = voucherConfiguration.getGenerationAmount();
        if (voucherType.getExpirationType() != VoucherExpirationType.FIXED_DATE) {
            voucherType.setExpirationDate(null);
        }
        if (voucherType.getExpirationType() != VoucherExpirationType.INTERVAL) {
            voucherType.setExpirationInterval(null);
        }
        if (voucherType.getRedeemRestrict() != VoucherRedeemRestrictTo.SPECIFIC_USERS) {
            voucherType.setRedeemAllowedUsers(null);
        }
        if (voucherType.getRedeemRestrict() != VoucherRedeemRestrictTo.SPECIFIC_GROUPS) {
            voucherType.setRedeemAllowedGroups(null);
        }
        if (voucherGenerationAmount == VoucherGenerationAmount.DYNAMIC) {
            voucherType.setAllowPartialRedeems(true);
        } else {
            voucherType.setMaxBalance(null);
        }
        if (voucherGenerationAmount == VoucherGenerationAmount.GENERATION) {
            voucherType.setMinTopUpAmount(null);
            voucherType.setMaxTopUpAmount(null);
        }
        if (voucherGenerationStatus != VoucherGenerationStatus.ACTIVE) {
            voucherType.setAllowBuying(false);
        }
        if (!voucherType.isAllowBuying()) {
            voucherType.setBuyAllowedGroups(null);
            voucherType.setMinBuyAmount(null);
            voucherType.setMaxBuyAmount(null);
            voucherType.setMaxOpenAmountPerUser(null);
            voucherType.setBuyUntilDate(null);
            voucherType.setMaxBuyAmountActualPeriod(null);
            voucherType.setMaxBuyAmountActualSum(null);
            voucherType.setGift(null);
        }
        if (voucherType.getPaymentDestination() != VoucherPaymentDestination.FIXED_USER) {
            voucherType.setPaymentDestinationUser(null);
        }
        if (voucherType2 != null && !voucherType.isLimitBuyAmountPerPeriod() && voucherType2.isLimitBuyAmountPerPeriod()) {
            voucherType.setMaxBuyAmountActualPeriod(null);
            voucherType.setMaxBuyAmountActualSum(null);
        } else {
            object2 = voucherType.getMaxBuyAmountPeriod();
            object = voucherType2 == null ? null : voucherType2.getMaxBuyAmountPeriod();
            Date date = new Date();
            TimeZone timeZone = this.getConfiguration().getTimeZone();
            if (voucherType.isLimitBuyAmountPerPeriod() && (voucherType2 == null || !voucherType2.isLimitBuyAmountPerPeriod())) {
                voucherType.setMaxBuyAmountActualPeriod(DatePeriod.periodIncluding((ITimeInterval)object2, (TimeZone)timeZone, (Date)date));
                voucherType.setMaxBuyAmountActualSum(null);
            } else if (voucherType.isLimitBuyAmountPerPeriod() && voucherType2 != null && !object2.equals(object)) {
                voucherType.setMaxBuyAmountActualSum(null);
                voucherType.setMaxBuyAmountActualPeriod(DatePeriod.periodIncluding((ITimeInterval)object2, (TimeZone)timeZone, (Date)date));
            }
        }
        object2 = voucherType.getBuyUntilDate();
        Date date = object = voucherType2 == null ? null : voucherType2.getBuyUntilDate();
        if (object2 != null && (object == null || ((Date)object2).after((Date)object))) {
            voucherType.setBuyUntilDateExpirationNotified(false);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(VoucherTypeDTO voucherTypeDTO, VoucherType voucherType) {
        voucherType.getBuyAllowedGroups().size();
        voucherType.getImages().size();
        voucherType.getRedeemAllowedGroups().size();
        voucherType.getRedeemAllowedUsers().size();
        voucherType.getRedeemOnWeekDays().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QVoucherType)this.$).configuration().currency().network(), true);
    }

    @Override
    protected Validator resolveValidator(final VoucherTypeDTO voucherTypeDTO) {
        DateTime dateTime;
        Validator validator = new Validator();
        validator.property((Property)VoucherTypeDTO.CONFIGURATION, BankingKeys.VoucherTypes.CONFIGURATION).required();
        validator.property((Property)VoucherTypeDTO.EXPIRATION_TYPE, BankingKeys.VoucherTypes.EXPIRATION_TYPE).required();
        validator.property((Property)VoucherTypeDTO.VOUCHER_TITLE, BankingKeys.VoucherTypes.VOUCHER_TITLE).required().maxLength(255);
        validator.property((Property)VoucherTypeDTO.TEMPLATE, BankingKeys.VoucherTypes.TEMPLATE).required();
        VoucherExpirationType voucherExpirationType = voucherTypeDTO.getExpirationType();
        if (voucherExpirationType == VoucherExpirationType.FIXED_DATE) {
            validator.property((Property)VoucherTypeDTO.EXPIRATION_DATE, BankingKeys.VoucherTypes.EXPIRATION_DATE).required();
            dateTime = voucherTypeDTO.getBuyUntilDate();
            if (dateTime != null && dateTime.after(voucherTypeDTO.getExpirationDate())) {
                validator.property((Property)VoucherTypeDTO.BUY_UNTIL_DATE, BankingKeys.VoucherTypes.BUY_UNTIL_DATE).invalid(new ValidationError(BankingKeys.VoucherTypes.ERROR_BUY_UNTIL_DATE, new Object[]{this.message(BankingKeys.VoucherTypes.EXPIRATION_DATE, new Object[0])}));
            }
        } else if (voucherExpirationType == VoucherExpirationType.INTERVAL) {
            validator.property((Property)VoucherTypeDTO.EXPIRATION_INTERVAL, BankingKeys.VoucherTypes.EXPIRATION_INTERVAL).required().positiveIntegerNonZero().timeInterval();
        }
        validator.property((Property)VoucherTypeDTO.REDEEM_RESTRICT, BankingKeys.VoucherTypes.REDEEM_RESTRICT).required();
        dateTime = voucherTypeDTO.getRedeemRestrict();
        if (dateTime == VoucherRedeemRestrictTo.SPECIFIC_USERS) {
            validator.property((Property)VoucherTypeDTO.REDEEM_ALLOWED_USERS, BankingKeys.VoucherTypes.REDEEM_ALLOWED_USERS).required();
        } else if (dateTime == VoucherRedeemRestrictTo.SPECIFIC_GROUPS) {
            validator.property((Property)VoucherTypeDTO.REDEEM_ALLOWED_GROUPS, BankingKeys.VoucherTypes.REDEEM_ALLOWED_GROUPS).required();
        }
        validator.property((Property)VoucherTypeDTO.PAYMENT_DESTINATION, BankingKeys.VoucherTypes.PAYMENT_DESTINATION).required();
        VoucherConfiguration voucherConfiguration = (VoucherConfiguration)this.conversionHandler.convert(VoucherConfiguration.class, (Object)voucherTypeDTO.getConfiguration());
        if (voucherTypeDTO.getPaymentDestination() == VoucherPaymentDestination.FIXED_USER) {
            validator.property((Property)VoucherTypeDTO.PAYMENT_DESTINATION_USER, BankingKeys.VoucherTypes.PAYMENT_DESTINATION_USER).required().entity(User.class, (EntityValidation)new BaseEntityValidation<User>(){

                protected boolean isValid(Object object, Object object2, User user) {
                    if (!user.isActive() || !user.isMember()) {
                        return false;
                    }
                    VoucherConfiguration voucherConfiguration = (VoucherConfiguration)VoucherTypeServiceImpl.this.conversionHandler.convert(VoucherConfiguration.class, (Object)voucherTypeDTO.getConfiguration());
                    if (voucherConfiguration == null) {
                        return true;
                    }
                    List list = VoucherTypeServiceImpl.this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
                    return list.contains(voucherConfiguration.getRedeemType().getTo());
                }
            });
        }
        validator.property((Property)VoucherTypeDTO.MAX_TOTAL_OPEN_AMOUNT, BankingKeys.VoucherTypes.MAX_TOTAL_OPEN_AMOUNT).positiveNonZero((HasCurrency)voucherConfiguration);
        validator.property((Property)VoucherTypeDTO.MINIMUM_TIME_TO_REDEEM, BankingKeys.VoucherTypes.MINIMUM_TIME_TO_REDEEM).timeInterval();
        if (voucherTypeDTO.isLimitBuyAmountPerPeriod()) {
            validator.property((Property)VoucherTypeDTO.MAX_BUY_AMOUNT_PER_PERIOD, BankingKeys.VoucherTypes.MAX_BUY_AMOUNT_PER_PERIOD).required().positiveNonZero((HasCurrency)voucherConfiguration);
            validator.property((Property)VoucherTypeDTO.MAX_BUY_AMOUNT_PERIOD, BankingKeys.VoucherTypes.MAX_BUY_AMOUNT_PERIOD).required().timeInterval();
        }
        if (voucherTypeDTO.isAllowBuying()) {
            validator.property((Property)VoucherTypeDTO.MIN_BUY_AMOUNT, BankingKeys.VoucherTypes.MIN_BUY_AMOUNT).positiveOrZero();
            validator.property((Property)VoucherTypeDTO.MAX_BUY_AMOUNT, BankingKeys.VoucherTypes.MAX_BUY_AMOUNT).positiveNonZero((HasCurrency)voucherConfiguration);
            validator.property((Property)VoucherTypeDTO.MAX_OPEN_AMOUNT_PER_USER, BankingKeys.VoucherTypes.MAX_OPEN_AMOUNT_PER_USER).positiveNonZero((HasCurrency)voucherConfiguration);
            validator.property((Property)VoucherTypeDTO.GIFT, BankingKeys.VoucherTypes.GIFT).required();
            validator.property((Property)VoucherTypeDTO.MAX_TOTAL_BUY, BankingKeys.VoucherTypes.MAX_TOTAL_BUY).positiveNonZero();
            validator.property((Property)VoucherTypeDTO.MAX_VOUCHERS_PER_BUY, BankingKeys.VoucherTypes.MAX_VOUCHERS_PER_BUY).positiveNonZero();
            if (voucherTypeDTO.getMaxTotalBuy() != null && voucherTypeDTO.getMaxVouchersPerBuy() != null) {
                validator.property((Property)VoucherTypeDTO.MAX_VOUCHERS_PER_BUY, BankingKeys.VoucherTypes.MAX_VOUCHERS_PER_BUY).lessEquals((Comparable)voucherTypeDTO.getMaxTotalBuy());
            }
        }
        validator.property((Property)VoucherTypeDTO.IMAGE, BankingKeys.VoucherTypes.IMAGE).entity(Image.class, (EntityValidation)new BaseEntityValidation<Image>(){

            protected boolean isValid(Object object, Object object2, Image image) {
                if (image instanceof TempImage) {
                    TempImage tempImage = (TempImage)image;
                    return tempImage.getTarget() == TempImageTarget.VOUCHER_TYPE;
                }
                if (image instanceof VoucherTypeImage) {
                    VoucherTypeImage voucherTypeImage = (VoucherTypeImage)image;
                    return voucherTypeImage.getCategory().getId().equals(voucherTypeDTO.getId());
                }
                return false;
            }
        });
        return validator;
    }

    private List<VoucherType> doList(Collection<VoucherConfiguration> collection, boolean bl, boolean bl2, Boolean bl3) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        QVoucherCategory qVoucherCategory = QVoucherCategory.voucherCategory;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(this.$).leftJoin((EntityPath)((QVoucherType)this.$).category(), (Path)qVoucherCategory)).where(new Predicate[]{((QVoucherType)this.$).configuration().in(collection), bl ? ((QVoucherType)this.$).enabled.isTrue() : ((QVoucherType)this.$).id.isNotNull(), bl2 ? ((QVoucherType)this.$).expirationDate.isNull().or(((QVoucherType)this.$).expirationDate.future()) : ((QVoucherType)this.$).id.isNotNull(), bl3 == null ? ((QVoucherType)this.$).id.isNotNull() : ((QVoucherType)this.$).allowBuying.eq(bl3)})).orderBy(new OrderSpecifier[]{((QVoucherType)this.$).configuration().name.asc(), qVoucherCategory.order.asc().nullsLast(), ((QVoucherType)this.$).name.asc()})).list((Expression)this.$);
    }

    private List<VoucherConfiguration> getAccessibleConfigurations() {
        SessionData sessionData = this.getSessionData();
        return sessionData.getProducts().admin().getAccessibleVoucherConfigurations();
    }
}

