/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.vouchertypes.VoucherTypeDTO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.springframework.stereotype.Component;

@Component
public class VoucherTypeEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<VoucherType, VoucherTypeDTO> {
    public Class<VoucherType> getEntityClass() {
        return VoucherType.class;
    }

    public EntityLogType getType() {
        return EntityLogType.VOUCHER_TYPE;
    }

    public EntityLogDescriptor<VoucherTypeDTO> resolveLogDescriptor(VoucherType voucherType) {
        return new EntityLogDescriptor(VoucherTypeDTO.class).property(VoucherTypeDTO.NAME, GeneralKeys.Ui.NAME).property(VoucherTypeDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property(VoucherTypeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property((Property)VoucherTypeDTO.CATEGORY, BankingKeys.VoucherTypes.CATEGORY).property((Property)VoucherTypeDTO.TEMPLATE, BankingKeys.VoucherTypes.TEMPLATE).property((Property)VoucherTypeDTO.ALLOW_BUYING, BankingKeys.VoucherTypes.ALLOW_BUYING).property((Property)VoucherTypeDTO.ALLOW_PARTIAL_REDEEMS, BankingKeys.VoucherTypes.ALLOW_PARTIAL_REDEEMS).property((Property)VoucherTypeDTO.HIDE_BALANCE_IN_REDEEM, BankingKeys.VoucherTypes.HIDE_BALANCE_IN_REDEEM).property((Property)VoucherTypeDTO.BUY_ALLOWED_GROUPS, BankingKeys.VoucherTypes.BUY_ALLOWED_GROUPS).property((Property)VoucherTypeDTO.BUY_UNTIL_DATE, BankingKeys.VoucherTypes.BUY_UNTIL_DATE).property((Property)VoucherTypeDTO.CONFIGURATION, BankingKeys.VoucherTypes.CONFIGURATION).property((Property)VoucherTypeDTO.ACCOUNT_NAME, BankingKeys.VoucherConfigurations.ACCOUNT_NAME).property((Property)VoucherTypeDTO.ENABLED, BankingKeys.VoucherTypes.ENABLED).property((Property)VoucherTypeDTO.MIN_TOP_UP_AMOUNT, BankingKeys.VoucherTypes.MIN_TOP_UP_AMOUNT).property((Property)VoucherTypeDTO.MAX_TOP_UP_AMOUNT, BankingKeys.VoucherTypes.MAX_TOP_UP_AMOUNT).property((Property)VoucherTypeDTO.MAX_VOUCHERS_PER_BUY, BankingKeys.VoucherTypes.MAX_VOUCHERS_PER_BUY).property((Property)VoucherTypeDTO.MAX_TOTAL_BUY, BankingKeys.VoucherTypes.MAX_TOTAL_BUY).property((Property)VoucherTypeDTO.MAX_BALANCE, BankingKeys.VoucherTypes.MAX_BALANCE).property((Property)VoucherTypeDTO.EXPIRATION_DATE, BankingKeys.VoucherTypes.EXPIRATION_DATE).property((Property)VoucherTypeDTO.EXPIRATION_INTERVAL, BankingKeys.VoucherTypes.EXPIRATION_INTERVAL).property((Property)VoucherTypeDTO.EXPIRATION_TYPE, BankingKeys.VoucherTypes.EXPIRATION_TYPE).property((Property)VoucherTypeDTO.IMAGE, BankingKeys.VoucherTypes.IMAGE).property((Property)VoucherTypeDTO.LIMIT_BUY_AMOUNT_PER_PERIOD, BankingKeys.VoucherTypes.LIMIT_BUY_AMOUNT_PER_PERIOD).property(this.toAmountAccess((Property<?, VoucherTypeDTO>)VoucherTypeDTO.MAX_BUY_AMOUNT), BankingKeys.VoucherTypes.MAX_BUY_AMOUNT).property(this.toAmountAccess((Property<?, VoucherTypeDTO>)VoucherTypeDTO.MAX_BUY_AMOUNT_PER_PERIOD), BankingKeys.VoucherTypes.MAX_BUY_AMOUNT_PER_PERIOD).property((Property)VoucherTypeDTO.MAX_BUY_AMOUNT_PERIOD, BankingKeys.VoucherTypes.MAX_BUY_AMOUNT_PERIOD).property(this.toAmountAccess((Property<?, VoucherTypeDTO>)VoucherTypeDTO.MAX_OPEN_AMOUNT_PER_USER), BankingKeys.VoucherTypes.MAX_OPEN_AMOUNT_PER_USER).property((Property)VoucherTypeDTO.MAX_TOTAL_OPEN_AMOUNT, BankingKeys.VoucherTypes.MAX_TOTAL_OPEN_AMOUNT).property(this.toAmountAccess((Property<?, VoucherTypeDTO>)VoucherTypeDTO.MIN_BUY_AMOUNT), BankingKeys.VoucherTypes.MIN_BUY_AMOUNT).property((Property)VoucherTypeDTO.MINIMUM_TIME_TO_REDEEM, BankingKeys.VoucherTypes.MINIMUM_TIME_TO_REDEEM).property((Property)VoucherTypeDTO.PAYMENT_DESTINATION, BankingKeys.VoucherTypes.PAYMENT_DESTINATION).property((Property)VoucherTypeDTO.PAYMENT_DESTINATION_USER, BankingKeys.VoucherTypes.PAYMENT_DESTINATION_USER).property((Property)VoucherTypeDTO.REDEEM_ALLOWED_GROUPS, BankingKeys.VoucherTypes.REDEEM_ALLOWED_GROUPS).property((Property)VoucherTypeDTO.REDEEM_ALLOWED_USERS, BankingKeys.VoucherTypes.REDEEM_ALLOWED_USERS).property((Property)VoucherTypeDTO.REDEEM_ON_WEEK_DAYS, BankingKeys.VoucherTypes.REDEEM_ON_WEEK_DAYS).property((Property)VoucherTypeDTO.REDEEM_RESTRICT, BankingKeys.VoucherTypes.REDEEM_RESTRICT).property((Property)VoucherTypeDTO.VOUCHER_DESCRIPTION, BankingKeys.VoucherTypes.VOUCHER_DESCRIPTION).property((Property)VoucherTypeDTO.VOUCHER_TITLE, BankingKeys.VoucherTypes.VOUCHER_TITLE).property((Property)VoucherTypeDTO.GIFT, BankingKeys.VoucherTypes.GIFT);
    }

    @Override
    protected VoucherType getEntityToViewLog(long l) {
        return this.hasPermission(Permission.VOUCHER_TYPES_VIEW) ? this.find(VoucherType.class, l) : null;
    }

    private PropertyAccess toAmountAccess(Property<?, VoucherTypeDTO> property) {
        return new BeanPropertyAccess(property){

            public Object get(Object object) {
                if (super.get(object) == null) {
                    return null;
                }
                VoucherType voucherType = (VoucherType)object;
                BigDecimal bigDecimal = (BigDecimal)super.get(object);
                return VoucherTypeEntityLogHandlerImpl.this.getFormatter().format(bigDecimal, voucherType.getCurrency().getPrecision());
            }
        };
    }
}

