/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.QTransferStatusFlow;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.users.QProduct;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.TransferStatusFlowServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowDTO;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowData;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.server.utils.PropertyHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferStatusFlowServiceImpl
extends CRUDServiceImpl<TransferStatusFlow, QTransferStatusFlow, TransferStatusFlowDTO, TransferStatusFlowData, Void>
implements TransferStatusFlowServiceLocal {
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private CacheHandler cacheHandler;

    public TransferStatusFlowServiceImpl() {
        super(TransferStatusFlow.class, QTransferStatusFlow.transferStatusFlow, TransferStatusFlowDTO.class);
    }

    public List<TransferStatusFlowVO> list() throws FrameworkException {
        return this.conversionHandler.convertList(TransferStatusFlowVO.class, this.listAll());
    }

    public List<TransferStatusFlow> listAll() {
        return ((DBQuery)this.from().orderBy(((QTransferStatusFlow)this.$).name.asc())).list((Expression)this.$);
    }

    public List<TransferStatusFlow> listByAccountType(AccountType accountType) {
        QTransferType qTransferType = QTransferType.transferType;
        return ((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qTransferType}).join((CollectionExpression)qTransferType.statusFlows, (Path)this.$)).where((Predicate)qTransferType.from().eq((Object)accountType).or((Predicate)qTransferType.to().eq((Object)accountType)))).orderBy(((QTransferStatusFlow)this.$).name.asc())).distinct()).list((Expression)this.$);
    }

    @Override
    public TransferStatusFlow newEntity(Void void_) {
        return new TransferStatusFlow();
    }

    @Override
    protected TransferStatusFlowData getData(TransferStatusFlow transferStatusFlow) {
        TransferStatusFlowData transferStatusFlowData = new TransferStatusFlowData();
        transferStatusFlowData.setDto((EntityDTO)((TransferStatusFlowDTO)this.toDTO(transferStatusFlow)));
        transferStatusFlowData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.TRANSFER_STATUS)));
        return transferStatusFlowData;
    }

    @Override
    protected void onAfterRemove(TransferStatusFlow transferStatusFlow) {
        Long l = SimpleEntity.id((SimpleEntity)transferStatusFlow.getNetwork());
        String string = PropertyHelper.getGetterName((Path)QProduct.product.transferStatusFlows);
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, string));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QTransferStatusFlow)this.$).network());
    }

    @Override
    protected Validator resolveValidator(TransferStatusFlowDTO transferStatusFlowDTO) {
        Validator validator = new Validator();
        validator.property((Property)TransferStatusFlowDTO.SCRIPT, BankingKeys.TransferStatus.SCRIPT).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.TRANSFER_STATUS;
            }
        });
        return validator;
    }
}

