/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.QTransferFilter;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.TransferFilterServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.transferfilters.TransferFilterDTO;
import org.cyclos.model.banking.transferfilters.TransferFilterData;
import org.cyclos.model.banking.transferfilters.TransferFilterQuery;
import org.cyclos.model.banking.transferfilters.TransferFilterVO;
import org.cyclos.model.banking.transferfilters.TransferFilterWithAccountTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferFilterServiceImpl
extends CRUDServiceImpl<TransferFilter, QTransferFilter, TransferFilterDTO, TransferFilterData, AccountTypeVO>
implements TransferFilterServiceLocal {
    @Autowired
    private TransferTypeServiceLocal transferTypeService;

    public TransferFilterServiceImpl() {
        super(TransferFilter.class, QTransferFilter.transferFilter, TransferFilterDTO.class);
    }

    public List<TransferFilterWithAccountTypeVO> list(AccountTypeVO accountTypeVO, AccountTypeVO accountTypeVO2) {
        TransferFilterQuery transferFilterQuery = new TransferFilterQuery();
        transferFilterQuery.setUnlimited();
        transferFilterQuery.setFromAccountType(accountTypeVO);
        transferFilterQuery.setToAccountType(accountTypeVO2);
        return this.search(TransferFilterWithAccountTypeVO.class, transferFilterQuery).getPageItems();
    }

    @Override
    public TransferFilter newEntity(AccountTypeVO accountTypeVO) {
        AccountType accountType = (AccountType)this.conversionHandler.convert(AccountType.class, (Object)accountTypeVO);
        TransferFilter transferFilter = new TransferFilter();
        transferFilter.setAccountType(accountType);
        return transferFilter;
    }

    public <T> Page<T> search(Class<T> clazz, TransferFilterQuery transferFilterQuery) {
        DBQuery<?> dBQuery = this.from();
        AccountType accountType = (AccountType)this.conversionHandler.convert(AccountType.class, (Object)transferFilterQuery.getOwnerAccountType());
        if (accountType != null) {
            dBQuery.where((Predicate)((QTransferFilter)this.$).accountType().eq((Object)accountType));
        }
        if (transferFilterQuery.getOwnerAccountTypeNature() != null) {
            dBQuery.where((Predicate)((QTransferFilter)this.$).accountType().nature.eq((Object)transferFilterQuery.getOwnerAccountTypeNature()));
        }
        AccountType accountType2 = (AccountType)this.conversionHandler.convert(AccountType.class, (Object)transferFilterQuery.getFromAccountType());
        AccountType accountType3 = (AccountType)this.conversionHandler.convert(AccountType.class, (Object)transferFilterQuery.getToAccountType());
        if (this.hasPermission(Permission.ACCOUNT_CONFIGURATION_VIEW)) {
            BooleanBuilder booleanBuilder = new BooleanBuilder((Predicate)((QTransferFilter)this.$).id.isNotNull());
            if (accountType2 != null) {
                booleanBuilder.and((Predicate)((QTransferType)((QTransferFilter)this.$).transferTypes.any()).from().eq((Object)accountType2));
            }
            if (accountType3 != null) {
                booleanBuilder.and((Predicate)((QTransferType)((QTransferFilter)this.$).transferTypes.any()).to().eq((Object)accountType3));
            }
            if (transferFilterQuery.isIncludeEmpty()) {
                dBQuery.where((Predicate)((QTransferFilter)this.$).transferTypes.isEmpty().or((Predicate)booleanBuilder));
            } else {
                dBQuery.where((Predicate)booleanBuilder);
            }
        } else {
            List list;
            List list2;
            List list3 = this.getSessionData().getProducts().grantedAccountTypes();
            Collection<Object> collection = accountType2 == null ? list3 : (list2 = list3.contains(accountType2) ? Collections.singleton(accountType2) : Collections.emptySet());
            Collection<Object> collection2 = accountType3 == null ? list3 : (list = list3.contains(accountType3) ? Collections.singleton(accountType3) : Collections.emptySet());
            if (list2.isEmpty() || list.isEmpty()) {
                dBQuery.where((Predicate)((QTransferFilter)this.$).id.isNull());
            } else {
                BooleanExpression booleanExpression = ((QTransferType)((QTransferFilter)this.$).transferTypes.any()).from().in((Collection)list2).and((Predicate)((QTransferType)((QTransferFilter)this.$).transferTypes.any()).to().in((Collection)list));
                if (transferFilterQuery.isIncludeEmpty()) {
                    booleanExpression = ((QTransferFilter)this.$).transferTypes.isEmpty().or((Predicate)booleanExpression);
                }
                dBQuery.where((Predicate)booleanExpression);
            }
        }
        dBQuery.orderBy(((QTransferFilter)this.$).name.asc());
        return dBQuery.page(clazz, (QueryParameters)transferFilterQuery, (Expression)this.$);
    }

    public Page<TransferFilterVO> search(TransferFilterQuery transferFilterQuery) {
        return this.search(TransferFilterVO.class, transferFilterQuery);
    }

    @Override
    protected TransferFilterData getData(TransferFilter transferFilter) throws FrameworkException {
        TransferFilterData transferFilterData = new TransferFilterData();
        transferFilterData.setDto((EntityDTO)((TransferFilterDTO)this.toDTO(transferFilter)));
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setUnlimited();
        transferTypeQuery.setFromOrToAccountTypes(Collections.singleton(new AccountTypeVO(transferFilter.getAccountType().getId())));
        transferFilterData.setTransferTypes(this.transferTypeService.search(transferTypeQuery).getPageItems());
        return transferFilterData;
    }

    @Override
    protected void preProcessCurrentCopy(TransferFilterDTO transferFilterDTO, TransferFilter transferFilter) {
        transferFilter.getTransferTypes().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QTransferFilter)this.$).accountType().currency().network(), true);
    }

    @Override
    protected Validator resolveValidator(TransferFilterDTO transferFilterDTO) {
        Validator validator = new Validator();
        validator.property((Property)TransferFilterDTO.ACCOUNT_TYPE, BankingKeys.TransferFilters.ACCOUNT_TYPE).required();
        validator.property(TransferFilterDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        return validator;
    }
}

