/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountRates;
import org.cyclos.entities.banking.ChargebackTransfer;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QAccountRates;
import org.cyclos.entities.banking.RateParameters;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.RatedAccountEntity;
import org.cyclos.entities.utils.RatedEntity;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.banking.ARateTypeHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.DRateTypeHandler;
import org.cyclos.impl.banking.FromRatesData;
import org.cyclos.impl.banking.RateHandlerTestable;
import org.cyclos.impl.banking.RateTypeHandler;
import org.cyclos.impl.banking.RatesData;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.IEntity;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.currencies.CurrencyDTO;
import org.cyclos.model.banking.rates.HasRates;
import org.cyclos.model.banking.rates.RateParametersDTO;
import org.cyclos.model.banking.rates.RateType;
import org.cyclos.model.banking.rates.RateVisibility;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RateHandlerImpl
extends BaseServiceImpl
implements RateHandlerTestable {
    private static final int RATE_IN_OUT_SCALE = 3;
    @Autowired
    private ARateTypeHandler aRateHandler;
    @Autowired
    private DRateTypeHandler dRateHandler;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private TransferServiceLocal transferService;

    public <T extends Transfer> void applyTransfer(T t) {
        if (this.isAnyRateEnabled(t.getTo().getCurrency(), null)) {
            AccountRates accountRates = this.getCurrent(t.getFrom());
            AccountRates accountRates2 = this.getCurrent(t.getTo());
            Date date = t.getDate();
            if (accountRates != null && accountRates.getTime().after(date) || accountRates2 != null && accountRates2.getTime().after(date)) {
                throw new ValidationException("A rate exists aftet the given transfer date. Cannot create this transfer, as it would invalidate future rates");
            }
            FromRatesData fromRatesData = this.getFromRates(t);
            this.copy((RatedEntity)fromRatesData, (RatedEntity)t);
            if (fromRatesData.isEnforcedZeroDRate()) {
                t.setExpirationDate(fromRatesData.getTransferExpirationDate());
            }
            RatesData ratesData = this.getRates(t.getTo(), null, date, RateVisibility.ALL);
            this.aRateHandler.applyIncomingTransfer(ratesData, t);
            this.dRateHandler.applyIncomingTransfer(ratesData, t);
            if (fromRatesData.isChangedDueToCreation() || fromRatesData.isEnforcedZeroDRate()) {
                this.persist((RatedAccountEntity)fromRatesData, t.getFrom(), date);
            }
            this.persist((RatedAccountEntity)ratesData, t.getTo(), date);
        }
    }

    public void copy(HasRates hasRates, HasRates hasRates2) {
        this.aRateHandler.copy(hasRates, hasRates2);
        this.dRateHandler.copy(hasRates, hasRates2);
    }

    public void copy(RatedEntity ratedEntity, RatedEntity ratedEntity2) {
        if (ratedEntity2 != null && ratedEntity != null) {
            ratedEntity2.setEmissionDate(ratedEntity.getEmissionDate());
            ratedEntity2.setExpirationDate(ratedEntity.getExpirationDate());
        }
    }

    @Override
    public AccountRates getAccountRatesEntity(Account account, Date date) {
        if (date == null) {
            return this.getCurrent(account);
        }
        QAccountRates qAccountRates = QAccountRates.accountRates;
        return (AccountRates)((DBQuery)((DBQuery)this.from(new EntityPath[]{qAccountRates}).where(new Predicate[]{qAccountRates.account().eq((Object)account), qAccountRates.time.loe((Comparable)date)})).orderBy(qAccountRates.time.desc())).singleResult((Expression)qAccountRates);
    }

    public AccountRates getCurrent(Account account) {
        AccountRates accountRates = account.getAccountRates();
        if (accountRates == null && account.getAccountRatesId() != null) {
            accountRates = (AccountRates)this.entityManagerHandler.find(AccountRates.class, account.getAccountRatesId());
        }
        return accountRates;
    }

    @Override
    public Date getEnableDate(Currency currency, Date date) {
        Date[] dateArray = new Date[]{this.aRateHandler.getEnableDate(currency, date), this.dRateHandler.getEnableDate(currency, date)};
        return DateHelper.earliest((Date[])dateArray);
    }

    public FromRatesData getFromRates(Account account, TransferType transferType, BigDecimal bigDecimal, Date date, RateVisibility rateVisibility) {
        RatesData ratesData = this.getRates(account, null, date, rateVisibility);
        FromRatesData fromRatesData = new FromRatesData(ratesData);
        if (this.aRateHandler.isVisible(account, date, rateVisibility)) {
            this.aRateHandler.calculateFromRates(fromRatesData, account, transferType, bigDecimal);
        }
        if (this.dRateHandler.isVisible(account, date, rateVisibility)) {
            this.dRateHandler.calculateFromRates(fromRatesData, account, transferType, bigDecimal);
        }
        if (fromRatesData.isChangedDueToCreation()) {
            BigDecimal bigDecimal2 = fromRatesData.getVirtualRatedBalance();
            BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2).max(BigDecimal.ZERO);
            fromRatesData.setRateBalanceCorrection(fromRatesData.getRateBalanceCorrection().add(bigDecimal3));
            fromRatesData.setVirtualRatedBalance(BigDecimal.ZERO);
        }
        this.dRateHandler.applyMaturityPolicyChangesForFrom(transferType, bigDecimal, ratesData, fromRatesData);
        return fromRatesData;
    }

    public RatesData getRates(Account account, BigDecimal bigDecimal, Date date, RateVisibility rateVisibility) {
        RatesData ratesData = new RatesData();
        Date date2 = date == null ? DateHelper.now() : date;
        ratesData.setDate(date2);
        Set<RateType> set = this.getVisibleRates(account, date, rateVisibility);
        if (set.isEmpty()) {
            return ratesData;
        }
        Currency currency = account.getCurrency();
        BigDecimal bigDecimal2 = null;
        if (account.getType().getLimitType() == AccountTypeLimitType.UNLIMITED) {
            if (set.contains(RateType.A)) {
                ratesData.setARate(this.aRateHandler.getCreationValue(currency, date2));
            }
            if (set.contains(RateType.D)) {
                ratesData.setDRate(this.dRateHandler.getCreationValue(currency, date2));
            }
            ratesData.setRateBalanceCorrection(BigDecimal.ZERO);
            ratesData.setVirtualRatedBalance(BigDecimal.ZERO);
        } else {
            AccountRates accountRates = this.getAccountRatesEntity(account, date);
            bigDecimal2 = bigDecimal;
            if (bigDecimal == null) {
                bigDecimal2 = this.accountService.getBalance(account, new Date(date2.getTime() + 1L));
            }
            boolean bl = false;
            if (accountRates == null || accountRates.getRateBalanceCorrection() == null) {
                ratesData.setRateBalanceCorrection(bigDecimal2.min(BigDecimal.ZERO).abs());
                bl = BigDecimalHelper.isNegativeOrZero((BigDecimal)bigDecimal2);
            } else {
                ratesData.setRateBalanceCorrection(accountRates.getRateBalanceCorrection());
                bl = BigDecimalHelper.isNegativeOrZero((BigDecimal)accountRates.getRateBalanceCorrection().add(bigDecimal2));
            }
            if (bl) {
                if (set.contains(RateType.A)) {
                    ratesData.setARate(this.aRateHandler.getCreationValue(currency, date2));
                }
                if (set.contains(RateType.D)) {
                    ratesData.setDRate(this.dRateHandler.getCreationValue(currency, date2));
                }
                ratesData.setVirtualRatedBalance(BigDecimal.ZERO);
            } else {
                ratesData.setEmissionDate((Date)this.aRateHandler.getNullSafeRawRate((RatedEntity)accountRates, currency, date2));
                ratesData.setExpirationDate((Date)this.dRateHandler.getNullSafeRawRate((RatedEntity)accountRates, currency, date2));
                ratesData.setVirtualRatedBalance(bigDecimal2.add(ratesData.getRateBalanceCorrection()));
            }
        }
        this.complete(ratesData, account, bigDecimal2, rateVisibility);
        this.setScale(ratesData);
        return ratesData;
    }

    public RatesData getRates(Account account, RateVisibility rateVisibility) {
        return this.getRates(account, null, null, rateVisibility);
    }

    @Override
    public Set<RateType> getVisibleRates(Account account, Date date, RateVisibility rateVisibility) {
        EnumSet<RateType> enumSet = EnumSet.noneOf(RateType.class);
        for (RateTypeHandler rateTypeHandler : this.getEnabledRateHandlers(account.getCurrency(), date)) {
            if (!rateTypeHandler.isVisible(account, date, rateVisibility)) continue;
            enumSet.add(rateTypeHandler.getRateType());
        }
        return enumSet;
    }

    public boolean isAnyRateEnabled(Currency currency, Date date) {
        if (date == null) {
            return currency.getaRateParameters() != null || currency.getdRateParameters() != null;
        }
        return !this.getEnabledRateHandlers(currency, date).isEmpty();
    }

    public boolean isVisible(Collection<Currency> collection, Date date) {
        if (CollectionHelper.isEmpty(collection)) {
            return false;
        }
        for (Currency currency : collection) {
            for (RateTypeHandler rateTypeHandler : this.getEnabledRateHandlers(currency, date)) {
                if (!rateTypeHandler.isVisibleToUser(currency, date)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void persist(RatedAccountEntity ratedAccountEntity, Account account, Date date) {
        AccountRates accountRates = new AccountRates();
        this.copy((RatedEntity)ratedAccountEntity, (RatedEntity)accountRates);
        accountRates.setRateBalanceCorrection(ratedAccountEntity.getRateBalanceCorrection());
        accountRates.setAccount(account);
        accountRates.setTime(date);
        this.getBaseEntityManagerHandler().persist((IEntity)accountRates);
        account.setAccountRates(accountRates);
    }

    public void resetCurrency(Currency currency) {
        for (RateTypeHandler rateTypeHandler : this.getEnabledRateHandlers(currency)) {
            RateParameters rateParameters = rateTypeHandler.getRateParameters(currency);
            if (rateParameters.getCurrency() != null) continue;
            rateParameters.setCurrency(currency);
        }
    }

    public void resolveValidator(Validator validator, CurrencyDTO currencyDTO) {
        this.aRateHandler.resolveValidator(validator, currencyDTO);
        this.dRateHandler.resolveValidator(validator, currencyDTO);
    }

    public void setRateParametersToCurrencyDTO(CurrencyDTO currencyDTO) {
        for (RateTypeHandler rateTypeHandler : this.getAllRateHandlers()) {
            RateParametersDTO rateParametersDTO = rateTypeHandler.getRateParametersDTO(currencyDTO);
            if (rateParametersDTO == null) continue;
            rateParametersDTO.setEnabledOnForm(true);
        }
    }

    public void toEntity(Currency currency, CurrencyDTO currencyDTO) {
        for (RateTypeHandler rateTypeHandler : this.getAllRateHandlers()) {
            rateTypeHandler.toEntity(currency, rateTypeHandler.getRateParametersDTO(currencyDTO));
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void complete(RatesData ratesData) {
        this.aRateHandler.complete(ratesData);
        this.dRateHandler.complete(ratesData);
    }

    private void complete(RatesData ratesData, Account account, BigDecimal bigDecimal, RateVisibility rateVisibility) {
        Date date = this.convert(Date.class, ratesData.getDate());
        Set<RateType> set = this.getVisibleRates(account, date, rateVisibility);
        if (!set.isEmpty()) {
            if (set.contains(RateType.A)) {
                this.aRateHandler.complete(ratesData);
            } else {
                ratesData.setARate(null);
                ratesData.setEmissionDate(null);
            }
            if (set.contains(RateType.D)) {
                this.dRateHandler.complete(ratesData);
            } else {
                ratesData.setDRate(null);
                ratesData.setExpirationDate(null);
            }
            if (ratesData.getVirtualRatedBalance() == null) {
                BigDecimal bigDecimal2 = bigDecimal;
                if (bigDecimal == null) {
                    bigDecimal2 = this.accountService.getBalance(account, new Date(date.getTime() + 1L));
                }
                ratesData.setVirtualRatedBalance(bigDecimal2.add(ratesData.getRateBalanceCorrection()));
            }
        } else {
            ratesData.setARate(null);
            ratesData.setDRate(null);
            ratesData.setEmissionDate(null);
            ratesData.setExpirationDate(null);
            ratesData.setRateBalanceCorrection(null);
            ratesData.setVirtualRatedBalance(null);
        }
    }

    private <T> T convert(Class<T> clazz, Object object) {
        return (T)this.conversionHandler.convert(clazz, object);
    }

    private List<RateTypeHandler> getAllRateHandlers() {
        ArrayList<RateTypeHandler> arrayList = new ArrayList<RateTypeHandler>(4);
        arrayList.add((RateTypeHandler)this.aRateHandler);
        arrayList.add((RateTypeHandler)this.dRateHandler);
        return arrayList;
    }

    private List<RateTypeHandler> getEnabledRateHandlers(Currency currency) {
        ArrayList<RateTypeHandler> arrayList = new ArrayList<RateTypeHandler>(4);
        if (currency.getaRateParameters() != null) {
            arrayList.add((RateTypeHandler)this.aRateHandler);
        }
        if (currency.getdRateParameters() != null) {
            arrayList.add((RateTypeHandler)this.dRateHandler);
        }
        return arrayList;
    }

    private List<RateTypeHandler> getEnabledRateHandlers(Currency currency, Date date) {
        ArrayList<RateTypeHandler> arrayList = new ArrayList<RateTypeHandler>(RateType.values().length);
        if (this.aRateHandler.isEnabled(currency, date)) {
            arrayList.add((RateTypeHandler)this.aRateHandler);
        }
        if (this.dRateHandler.isEnabled(currency, date)) {
            arrayList.add((RateTypeHandler)this.dRateHandler);
        }
        return arrayList;
    }

    private FromRatesData getFromRates(Transfer transfer) {
        if (transfer instanceof ChargebackTransfer) {
            ChargebackTransfer chargebackTransfer = (ChargebackTransfer)transfer;
            Transfer transfer2 = chargebackTransfer.getChargebackOf();
            FromRatesData fromRatesData = new FromRatesData();
            this.copy((RatedEntity)transfer2, (RatedEntity)fromRatesData);
            return fromRatesData;
        }
        return this.getFromRates(transfer.getFrom(), transfer.getType(), transfer.getAmount(), transfer.getDate(), RateVisibility.ALL);
    }

    @Deprecated
    private RatesData recalculateRateHistory(Account account, Date date, RateVisibility rateVisibility) {
        RatesData ratesData = new RatesData();
        Date date2 = date == null ? DateHelper.now() : date;
        Currency currency = account.getCurrency();
        Date date3 = this.convert(Date.class, ratesData.getDate());
        Date date4 = DateHelper.latest((Date[])new Date[]{date3, this.getEnableDate(currency, date2)});
        Set<RateType> set = this.getVisibleRates(account, date4, rateVisibility);
        if (!set.isEmpty() && date4.before(date2)) {
            BigDecimal bigDecimal = null;
            if (date3.equals(date4)) {
                bigDecimal = ratesData.getVirtualRatedBalance().subtract(ratesData.getRateBalanceCorrection());
            } else {
                bigDecimal = this.accountService.getBalance(account, new Date(date4.getTime() + 1L));
                ratesData.setRateBalanceCorrection(bigDecimal.min(BigDecimal.ZERO).abs());
                ratesData.setVirtualRatedBalance(bigDecimal.add(ratesData.getRateBalanceCorrection()));
            }
            DatePeriod datePeriod = DatePeriod.between((Date)date4, (Date)date2);
            List list = this.transferService.getTransfers(account, datePeriod, true);
            for (Transfer transfer : list) {
                BigDecimal bigDecimal2 = transfer.getAmount();
                BigDecimal bigDecimal3 = ratesData.getRateBalanceCorrection();
                BigDecimal bigDecimal4 = bigDecimal.add(bigDecimal3);
                if (bigDecimal4.signum() == -1) {
                    if (BigDecimalHelper.isNegative((BigDecimal)bigDecimal4)) {
                        throw new ArithmeticException("negative Virtual Rated Balance");
                    }
                    bigDecimal3 = bigDecimal;
                    ratesData.setRateBalanceCorrection(bigDecimal3);
                }
                Date date5 = transfer.getDate();
                ratesData.setDate(date5);
                if (account.equals((Object)transfer.getFrom())) {
                    BigDecimal bigDecimal5 = bigDecimal2.subtract(bigDecimal4).max(BigDecimal.ZERO);
                    BigDecimal bigDecimal6 = bigDecimal3.add(bigDecimal5);
                    ratesData.setRateBalanceCorrection(bigDecimal6);
                    bigDecimal = bigDecimal.subtract(bigDecimal2);
                    continue;
                }
                ratesData.setVirtualRatedBalance(bigDecimal4);
                if (set.contains(RateType.A)) {
                    this.aRateHandler.applyIncomingTransfer(ratesData, transfer);
                }
                if (set.contains(RateType.D)) {
                    this.dRateHandler.applyIncomingTransfer(ratesData, transfer);
                }
                bigDecimal = bigDecimal.add(bigDecimal2);
            }
            if (ratesData.getEmissionDate() == null && this.aRateHandler.isVisible(account, date, rateVisibility)) {
                ratesData.setEmissionDate(this.aRateHandler.getInitValue(currency, date2));
            }
            if (ratesData.getExpirationDate() == null && this.dRateHandler.isVisible(account, date, rateVisibility)) {
                ratesData.setExpirationDate(this.dRateHandler.getInitValue(currency, date2));
            }
        }
        ratesData.setDate(date2);
        this.complete(ratesData, account, null, rateVisibility);
        return ratesData;
    }

    private void setScale(RatesData ratesData) {
        ratesData.setARate(BigDecimalHelper.round((BigDecimal)ratesData.getARate(), (int)3));
        ratesData.setDRate(BigDecimalHelper.round((BigDecimal)ratesData.getDRate(), (int)3));
        ratesData.setRateBalanceCorrection(BigDecimalHelper.round((BigDecimal)ratesData.getRateBalanceCorrection(), (int)3));
        ratesData.setVirtualRatedBalance(BigDecimalHelper.round((BigDecimal)ratesData.getVirtualRatedBalance(), (int)3));
    }
}

