/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import java.util.Collection;
import org.cyclos.entities.banking.QVoucherType;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.impl.utils.notifications.AdminNotificationsHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyVoucherBuyingAboutToExpireRecurringTask
extends EntityBatchRecurringTask<VoucherType> {
    private static final int DAYS_BEFORE = 7;
    @Autowired
    private AdminNotificationsHandler adminNotificationsHandler;

    public NotifyVoucherBuyingAboutToExpireRecurringTask() {
        super(VoucherType.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.NOTIFY_VOUCHER_BUYING_ABOUT_TO_EXPIRE;
    }

    @Override
    protected void finish(VoucherType voucherType, Throwable throwable) throws Throwable {
        voucherType.setBuyUntilDateExpirationNotified(true);
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QVoucherType qVoucherType = QVoucherType.voucherType;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qVoucherType}).where(new Predicate[]{qVoucherType.buyUntilDateExpirationNotified.isFalse().or((Predicate)qVoucherType.buyUntilDateExpirationNotified.isNull()), qVoucherType.buyUntilDate.addDays(Integer.valueOf(-7)).lt((Expression)Expressions.currentTimestamp())})).select((Expression)qVoucherType.id).limit(200L)).fetch();
    }

    @Override
    protected void process(VoucherType voucherType) throws Throwable {
        this.adminNotificationsHandler.voucherBuyingAboutToExpire(voucherType, voucherType.getBuyUntilDate());
    }
}

