/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QTransactionCustomFieldValue;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.EasyInvoiceServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransactionValidationData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.LocateUserOption;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.utils.BarcodeHandler;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.EasyInvoiceBarcodeParams;
import org.cyclos.model.banking.transactions.EasyInvoiceData;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentToOwnerData;
import org.cyclos.model.banking.transactions.PerformPaymentTypeData;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceData;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceParams;
import org.cyclos.model.banking.transfertypes.PaymentTransferTypeRestrictTo;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EasyInvoiceServiceImpl
extends BaseServiceImpl
implements EasyInvoiceServiceLocal {
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private BarcodeHandler barcodeHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private ChannelServiceLocal channelService;

    public SerializableInputStream barcode(EasyInvoiceBarcodeParams easyInvoiceBarcodeParams) throws FrameworkException {
        ImageSize imageSize = (ImageSize)ObjectHelper.defaultValue((Object)easyInvoiceBarcodeParams.getSize(), (Object)ImageSize.SMALL);
        PerformPaymentDTO performPaymentDTO = easyInvoiceBarcodeParams.getPerformPayment();
        InternalAccountOwner internalAccountOwner = performPaymentDTO.getSubject();
        LocateAccountOwnerResult locateAccountOwnerResult = (LocateAccountOwnerResult)this.invokerHandler.runAs(SessionDataFactory.system(), () -> this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner));
        boolean bl = performPaymentDTO.getAmount() != null;
        PrepareValidationParameter prepareValidationParameter = new PrepareValidationParameter.Builder((PerformTransactionDTO)performPaymentDTO, LocateAccountOwnerResult.empty(), locateAccountOwnerResult, PaymentCreationType.EASY_INVOICE).validateCustomFields(false).validateDescription(false).allowSearchingTTWhenNoneIsGiven(false).validateConfirmationPassword(false).excludeHideInForm(true).validateNFCChallenge(false).validateAmount(bl).fromRequired(false).build();
        TransactionValidationData transactionValidationData = this.transactionService.prepareValidation(prepareValidationParameter);
        Validator validator = transactionValidationData.getValidator();
        PaymentTransferType paymentTransferType = performPaymentDTO.getType() == null ? null : transactionValidationData.getPaymentType();
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)performPaymentDTO.getCurrency());
        this.validate(validator, performPaymentDTO, "barcode");
        HashMap hashMap = new HashMap();
        if (CollectionHelper.isNotEmpty((Iterable)performPaymentDTO.getCustomValues())) {
            performPaymentDTO.getCustomValues().forEach(customFieldValueDTO -> {
                TransactionCustomField transactionCustomField = (TransactionCustomField)this.conversionHandler.convert(TransactionCustomField.class, (Object)customFieldValueDTO.getField());
                Object object = this.customFieldValueHandler.getValue((CustomField)transactionCustomField, customFieldValueDTO, true);
                hashMap.put(transactionCustomField, this.customFieldValueHandler.toReference((CustomField)transactionCustomField, object));
            });
        }
        String string = this.linkGeneratorHandler.easyInvoice(locateAccountOwnerResult.getLocateUserResult(), performPaymentDTO.getAmount(), performPaymentDTO.getDescription(), currency, paymentTransferType, hashMap);
        return this.barcodeHandler.qrcode(string, imageSize);
    }

    public EasyInvoiceData getEasyInvoiceData(PerformPaymentDTO performPaymentDTO) throws FrameworkException {
        Object object;
        Validator validator;
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isMember()) {
            throw new IllegalActionException();
        }
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateReceiver(performPaymentDTO.getSubject());
        if (locateAccountOwnerResult == null) {
            throw new ValidationException(PerformPaymentDTO.SUBJECT.getName(), this.message(GeneralKeys.Errors.REQUIRED, BankingKeys.Transactions.RECEIVER));
        }
        PerformPaymentToOwnerData performPaymentToOwnerData = this.transactionService.getPaymentToOwnerData((InternalAccountOwner)sessionData.getLoggedUser(), (InternalAccountOwner)locateAccountOwnerResult.getUser(), performPaymentDTO.getType());
        if (!(performPaymentToOwnerData.getTo() instanceof UserVO)) {
            throw new EntityNotFoundException(User.class);
        }
        EasyInvoiceData easyInvoiceData = new EasyInvoiceData();
        easyInvoiceData.setTo((UserVO)performPaymentToOwnerData.getTo());
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performPaymentDTO.getType());
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)performPaymentDTO.getCurrency());
        List list = performPaymentToOwnerData.getPaymentTypes();
        CollectionHelper.orEmpty((List)list).removeIf(transferTypeWithCurrencyVO -> {
            if (paymentTransferType != null) {
                return !transferTypeWithCurrencyVO.getId().equals(paymentTransferType.getId());
            }
            if (currency != null) {
                return !transferTypeWithCurrencyVO.getCurrency().getId().equals(currency.getId());
            }
            return false;
        });
        if (CollectionHelper.isEmpty((Iterable)list)) {
            throw new ValidationException(this.message(BankingKeys.Transactions.PAYMENT_NO_PAYMENT_TYPES, new Object[0]));
        }
        PaymentTransferType paymentTransferType2 = paymentTransferType;
        if (paymentTransferType2 != null) {
            if (!list.stream().anyMatch(transferTypeWithCurrencyVO -> transferTypeWithCurrencyVO.getId().equals(paymentTransferType.getId()))) {
                throw new ValidationException(PerformPaymentDTO.TYPE.getName(), this.message(GeneralKeys.Errors.INVALID, BankingKeys.Transactions.TYPE));
            }
        } else {
            paymentTransferType2 = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, CollectionHelper.first((Iterable)list));
        }
        Set set = list.stream().map(TransferTypeWithCurrencyVO::getCurrency).collect(Collectors.toSet());
        if (currency != null && !set.stream().anyMatch(currencyVO -> currencyVO.getId().equals(currency.getId()))) {
            throw new ValidationException(PerformPaymentDTO.CURRENCY.getName(), this.message(GeneralKeys.Errors.INVALID, BankingKeys.AccountTypes.CURRENCY));
        }
        if (performPaymentDTO.getAmount() != null) {
            if (set.size() > 1) {
                throw new ValidationException(this.message(BankingKeys.Transactions.EASY_INVOICE_REQUIRED_CURRENCY_OR_TYPE, new Object[0]));
            }
            easyInvoiceData.setAmount(ModelHelper.currencyAmount((CurrencyVO)((CurrencyVO)CollectionHelper.first(set)), (BigDecimal)performPaymentDTO.getAmount()));
        }
        if (!this.canContinueIfNotTrustedSession(easyInvoiceData.getAmount() != null ? easyInvoiceData.getAmount().getAmount() : null, paymentTransferType, sessionData)) {
            throw new ValidationException(this.message(BankingKeys.Transactions.EASY_INVOICE_ERROR_TRUSTED_DEVICE_REQUIRED, new Object[0]));
        }
        easyInvoiceData.setPaymentTypes(list);
        List list2 = CollectionHelper.orEmpty((List)performPaymentDTO.getCustomValues());
        Set set2 = list2.stream().map(customFieldValueDTO -> (TransactionCustomField)this.conversionHandler.convert(TransactionCustomField.class, (Object)customFieldValueDTO.getField())).collect(Collectors.toSet());
        set2.retainAll(paymentTransferType2.getCustomFields());
        if (!set2.isEmpty()) {
            validator = new Validator();
            object = this.accountHandler.locate((AccountOwner)sessionData.getLoggedUser());
            Map map = this.transactionService.getCustomFieldValidationBindings(object, locateAccountOwnerResult, paymentTransferType2);
            for (TransactionCustomField transactionCustomField : set2) {
                this.customFieldValueHandler.addValueValidation(validator, (CustomField)transactionCustomField, (EntityPathBase)QTransactionCustomFieldValue.transactionCustomFieldValue, map);
            }
            PerformPaymentDTO performPaymentDTO2 = new PerformPaymentDTO();
            performPaymentDTO2.setCustomValues(list2);
            this.validate(validator, performPaymentDTO2, "getEasyInvoiceData");
        }
        validator = new Payment();
        this.customFieldValueHandler.setCustomValues((SimpleEntity)validator, set2, (Collection)sessionData.getProducts().product().getVisibleTransactionFields(), (Collection)list2);
        if (!paymentTransferType2.getId().equals(EntityVO.id((EntityVO)easyInvoiceData.getPaymentTypeData()))) {
            object = this.transactionService.getPaymentTypeData((InternalAccountOwner)sessionData.getLoggedUser(), performPaymentDTO.getSubject(), new TransferTypeVO(paymentTransferType2.getId()));
            easyInvoiceData.setPaymentTypeData((PerformPaymentTypeData)object);
        }
        object = CollectionHelper.sort((Collection)validator.getCustomValues(), (transactionCustomFieldValue, transactionCustomFieldValue2) -> transactionCustomFieldValue.getField().compareTo((NamedEntity)transactionCustomFieldValue2.getField()));
        easyInvoiceData.setCustomValues(this.conversionHandler.convertList(CustomFieldValueVO.class, (Iterable)object));
        return easyInvoiceData;
    }

    public LocateAccountOwnerResult locateReceiver(InternalAccountOwner internalAccountOwner) {
        if (internalAccountOwner == null) {
            return null;
        }
        LocateAccountOwnerResult locateAccountOwnerResult = null;
        if (internalAccountOwner instanceof BasicUser) {
            locateAccountOwnerResult = new LocateAccountOwnerResult(new LocateUserResult((BasicUser)internalAccountOwner));
        } else if (internalAccountOwner instanceof UserLocatorVO) {
            ChannelConfiguration channelConfiguration = this.getSessionData().getConfiguration().getChannelConfiguration(this.channelService.getEasyInvoice());
            LocateUserResult locateUserResult = this.userLocatorHandler.locate((UserLocatorVO)internalAccountOwner, EnumSet.of(LocateUserOption.ACTIVE_ONLY), (Collection)channelConfiguration.getPayment().getPrincipalTypes(), null);
            locateAccountOwnerResult = new LocateAccountOwnerResult(locateUserResult);
        } else if (internalAccountOwner instanceof UserVO) {
            Long l = ((UserVO)internalAccountOwner).getId();
            LocateAccountOwnerResult locateAccountOwnerResult2 = locateAccountOwnerResult = l == null ? null : this.locateReceiver((InternalAccountOwner)this.find(BasicUser.class, l));
        }
        if (locateAccountOwnerResult == null || !locateAccountOwnerResult.isUser()) {
            throw new EntityNotFoundException(User.class);
        }
        return locateAccountOwnerResult;
    }

    public PaymentVO perform(PerformPaymentDTO performPaymentDTO) throws TransferException, ValidationException, PasswordException {
        return this.paymentService.perform(performPaymentDTO);
    }

    public PrepareEasyInvoiceData prepareEasyInvoice(PrepareEasyInvoiceParams prepareEasyInvoiceParams) throws FrameworkException {
        Object object;
        LocateAccountOwnerResult locateAccountOwnerResult;
        SessionData sessionData = this.getSessionData();
        SessionData sessionData2 = SessionDataFactory.system();
        UserLocatorVO userLocatorVO = prepareEasyInvoiceParams.getTo();
        try {
            locateAccountOwnerResult = (LocateAccountOwnerResult)this.invokerHandler.runAs(sessionData2, () -> this.locateReceiver((InternalAccountOwner)userLocatorVO));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            EntityNotFoundException entityNotFoundException2 = new EntityNotFoundException(User.class);
            entityNotFoundException2.setId(userLocatorVO.getId());
            entityNotFoundException2.setKey((String)ObjectHelper.defaultValue((Object)userLocatorVO.getUsername(), (Object)userLocatorVO.getPrincipal()));
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            boolean bl = this.failedActionHandler.recordGuestFailure(FailedAction.FAILED_PRINCIPAL, sessionData.getRemoteAddress(), userLocatorVO, configurationAccessor.getInvalidUsernameAttempts(), configurationAccessor.getRemoteAddressBlockTime());
            throw bl ? new RemoteAddressBlockedException() : entityNotFoundException2;
        }
        User user = locateAccountOwnerResult.getUser();
        Collection<Object> collection = locateAccountOwnerResult.getAccount() != null ? Collections.singleton(locateAccountOwnerResult.getAccount().getType()) : this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
        if (collection.isEmpty()) {
            String string = this.message(GeneralKeys.Errors.INVALID, BankingKeys.Transactions.RECEIVER);
            throw new ValidationException(PrepareEasyInvoiceParams.TO.getName(), string);
        }
        PrepareEasyInvoiceData prepareEasyInvoiceData = new PrepareEasyInvoiceData();
        if (sessionData.relatesTo((BasicUser)user)) {
            prepareEasyInvoiceData.setTo((UserVO)this.conversionHandler.convert(UserVO.class, (Object)locateAccountOwnerResult.getBasicUser()));
        }
        Pair pair = (Pair)this.invokerHandler.runAs(sessionData2, () -> new Pair((Object)((PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)prepareEasyInvoiceParams.getType())), (Object)((Currency)this.conversionHandler.convert(Currency.class, (Object)prepareEasyInvoiceParams.getCurrency()))));
        PaymentTransferType paymentTransferType = (PaymentTransferType)pair.getFirst();
        Currency currency = (Currency)pair.getSecond();
        if (paymentTransferType != null) {
            boolean bl;
            if (currency != null) {
                if (!currency.equals((Object)paymentTransferType.getCurrency())) {
                    throw new ValidationException(PerformPaymentDTO.CURRENCY.getName(), this.message(GeneralKeys.Errors.INVALID, BankingKeys.AccountTypes.CURRENCY));
                }
            } else {
                currency = paymentTransferType.getCurrency();
            }
            if ((bl = collection.contains(paymentTransferType.getTo())) && paymentTransferType.getRestrictTo() == PaymentTransferTypeRestrictTo.SPECIFIC_GROUPS) {
                object = (UserGroup)user.getGroup();
                boolean bl2 = bl = paymentTransferType.getRestrictToGroups().contains(object) || paymentTransferType.getRestrictToGroups().contains(object.getGroupSet());
            }
            if (bl && paymentTransferType.getRestrictTo() == PaymentTransferTypeRestrictTo.SPECIFIC_USERS) {
                bl = paymentTransferType.getRestrictToUsers().contains(user);
            }
            if (!bl) {
                throw new ValidationException(PrepareEasyInvoiceParams.TYPE.getName(), this.message(GeneralKeys.Errors.INVALID, BankingKeys.Transactions.TYPE));
            }
        }
        if (prepareEasyInvoiceParams.getAmount() != null) {
            Set set = collection.stream().map(AccountType::getCurrency).collect(Collectors.toSet());
            if (currency == null && set.size() == 1) {
                currency = (Currency)CollectionHelper.first(set);
            }
            if (currency == null) {
                throw new ValidationException(this.message(BankingKeys.Transactions.EASY_INVOICE_REQUIRED_CURRENCY_OR_TYPE, new Object[0]));
            }
            if (!set.contains(currency)) {
                object = this.message(GeneralKeys.Errors.INVALID, BankingKeys.AccountTypes.CURRENCY);
                throw new ValidationException(PrepareEasyInvoiceParams.CURRENCY.getName(), (String)object);
            }
            prepareEasyInvoiceData.setAmount((CurrencyAmountDTO)this.conversionHandler.convert(CurrencyAmountDTO.class, (Object)new CurrencyAmount(currency, prepareEasyInvoiceParams.getAmount())));
        }
        prepareEasyInvoiceData.setDeviceConfirmationAvailability(sessionData.getChannelAccessAccessor().getConfirmation().getDeviceAvailability());
        return prepareEasyInvoiceData;
    }

    public PaymentPreviewVO preview(PerformPaymentDTO performPaymentDTO) throws ValidationException {
        return this.paymentService.preview(performPaymentDTO);
    }

    public void validate(PerformPaymentDTO performPaymentDTO) throws FrameworkException {
        this.paymentService.validate(performPaymentDTO);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private boolean canContinueIfNotTrustedSession(BigDecimal bigDecimal, PaymentTransferType paymentTransferType, SessionData sessionData) {
        CredentialsConfiguration credentialsConfiguration = sessionData.getChannelAccessAccessor().getConfirmation();
        if (credentialsConfiguration.isDeviceOnly()) {
            return sessionData.isTrusted() || paymentTransferType == null || this.transactionService.isCheckConfirmation(paymentTransferType, null, bigDecimal == null ? BigDecimal.ZERO : bigDecimal, null);
        }
        return true;
    }
}

