/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionRecurringTask;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DispatchArchiveAccountFeesRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private CyclosProperties cyclosProperties;

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.DISPATCH_ARCHIVE_ACCOUNT_FEES;
    }

    @Override
    public String getNotesForLogging() {
        int n = this.cyclosProperties.getArchiveAccountFeesDays();
        return n >= 1 ? String.format("Retention period: %d days", n) : "Disabled";
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        long l = this.nativeQueryHandler.insertArchiveAccountFees();
        if (l > 0L) {
            this.recurringTaskHandler.scheduleAwake(BackgroundTaskExecutionRecurringTask.class);
        }
        return l;
    }
}

