/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.AuthorizationRole;
import org.cyclos.entities.banking.QAuthorizationRole;
import org.cyclos.entities.banking.QTransactionAuthorization;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.BuildTransQueryParams;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.TransQueryHandlerImpl;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounts.TransferDirection;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.transactions.AbstractTransactionQuery;
import org.cyclos.model.banking.transactions.OwnedTransactionQuery;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseTransactionQueryHandlerImpl<Q extends AbstractTransactionQuery, P extends BuildTransQueryParams<Q>>
extends TransQueryHandlerImpl<Q, P> {
    @Autowired
    protected AccountHandler accountHandler;
    @Autowired
    protected OperatorGroupServiceLocal operatorGroupService;
    @Autowired
    protected TransactionServiceLocal transactionService;
    @Autowired
    protected TransactionServiceSecurity transactionServiceSecurity;

    @Override
    public DBQuery<?> build(P p) {
        Object object;
        User user;
        Set set;
        DBQuery<?> dBQuery = super.build(p);
        AbstractTransactionQuery abstractTransactionQuery = (AbstractTransactionQuery)p.getParams();
        if (abstractTransactionQuery.getAuthorized() != null) {
            set = this.tx.authorizationStatus.eq((Object)TransactionAuthorizationStatus.NA);
            dBQuery.where((Predicate)(abstractTransactionQuery.getAuthorized() != false ? set.not() : set));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set = abstractTransactionQuery.getAuthorizationStatuses()))) {
            if (set.contains(TransactionAuthorizationStatus.AUTHORIZED)) {
                user = EnumSet.of(TransactionAuthorizationStatus.NA);
                user.addAll(set);
                set = user;
            }
            dBQuery.where((Predicate)this.tx.authorizationStatus.in((Collection)set));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)abstractTransactionQuery.getAuthorizationPerformedBy())) != null) {
            object = QTransactionAuthorization.transactionAuthorization;
            dBQuery.where((Predicate)((JPAQuery)((JPAQuery)new JPAQuery().from((EntityPath)object)).where(new Predicate[]{object.transaction().eq((Expression)this.tx), object.by().eq((Object)user)})).exists());
        }
        if (CollectionHelper.isNotEmpty((Iterable)(object = this.conversionHandler.convertSet(AuthorizationRole.class, (Iterable)abstractTransactionQuery.getAuthorizationRoles())))) {
            dBQuery.where((Predicate)((QAuthorizationRole)this.tx.nextAuthorizationLevel().roles.any()).in((Collection)object));
        }
        if (CollectionHelper.isNotEmpty((Iterable)abstractTransactionQuery.getNatures())) {
            dBQuery.where((Predicate)this.tx.nature.in((Collection)abstractTransactionQuery.getNatures()));
        }
        if (CollectionHelper.isNotEmpty((Iterable)abstractTransactionQuery.getCreationTypes())) {
            dBQuery.where((Predicate)this.tx.nature.notIn((Collection)TransactionNature.basePayment()).or((Predicate)this.tx.creationType.in((Collection)abstractTransactionQuery.getCreationTypes())));
        }
        return dBQuery;
    }

    @Override
    protected Predicate additionalAdminFilter(SessionData sessionData) {
        Set set = sessionData.getProducts().admin().getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.view);
        Set set2 = set.stream().flatMap(authorizationRole -> authorizationRole.getLevels().stream()).map(AuthorizationLevel::getTransferType).collect(Collectors.toSet());
        return set2.isEmpty() ? this.authorized() : this.authorized().or((Predicate)this.tt.in(set2));
    }

    @Override
    protected Predicate additionalBrokerFilter(SessionData sessionData) {
        if (!sessionData.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_VIEW)) {
            return this.authorized();
        }
        return null;
    }

    @Override
    protected Predicate additionalRestrictedOperatorFilter(SessionData sessionData) {
        Operator operator = sessionData.getLoggedOperator();
        OperatorGroup operatorGroup = operator.getGroup();
        List list = this.operatorGroupService.listPaymentTypesWithAuthorize(operatorGroup);
        BooleanExpression booleanExpression = this.authorized().or((Predicate)this.tx.by().eq((Object)operator)).or((Predicate)this.tx.receivedBy().eq((Object)operator));
        if (!list.isEmpty()) {
            booleanExpression = booleanExpression.or((Predicate)this.tx.authorizationType.eq((Object)TransactionAuthorizationType.OPERATOR).and((Predicate)this.fu.eq((Object)operator.getUser())).and((Predicate)this.tt.in((Collection)list)));
        }
        if (sessionData.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_VIEW)) {
            booleanExpression = booleanExpression.or((Predicate)this.tx.authorizationType.eq((Object)TransactionAuthorizationType.LEVEL).and((Predicate)this.fu.eq((Object)operator.getUser())));
        }
        return booleanExpression;
    }

    @Override
    protected void applyOwned(DBQuery<?> dBQuery, P p) {
        OwnedTransactionQuery ownedTransactionQuery = (OwnedTransactionQuery)p.getParams();
        Set set = this.conversionHandler.convertSet(AccountType.class, (Iterable)ownedTransactionQuery.getAccountTypes());
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            dBQuery.where((Predicate)this.fat.in((Collection)set).or((Predicate)this.tat.in((Collection)set)));
        }
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        BooleanBuilder booleanBuilder2 = new BooleanBuilder();
        InternalAccountOwner internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)ownedTransactionQuery.getOwner(), true).getInternalAccountOwner();
        TransferDirection transferDirection = ownedTransactionQuery.getDirection();
        if (internalAccountOwner instanceof SystemAccountOwner) {
            booleanBuilder.and((Predicate)this.fa.instanceOf(SystemAccount.class));
            booleanBuilder2.and((Predicate)this.ta.instanceOf(SystemAccount.class));
        } else if (internalAccountOwner instanceof User) {
            User user = (User)internalAccountOwner;
            booleanBuilder.and((Predicate)this.fu.eq((Object)user));
            booleanBuilder2.and((Predicate)this.tu.eq((Object)user));
        } else {
            dBQuery.where((Predicate)this.tt.isNull());
        }
        if (transferDirection == TransferDirection.CREDIT) {
            dBQuery.where((Predicate)booleanBuilder2);
        } else if (transferDirection == TransferDirection.DEBIT) {
            dBQuery.where((Predicate)booleanBuilder);
        } else {
            dBQuery.where((Predicate)booleanBuilder.or((Predicate)booleanBuilder2));
        }
    }

    protected BooleanExpression authorized() {
        return this.tx.authorizationStatus.in((Object[])new TransactionAuthorizationStatus[]{TransactionAuthorizationStatus.NA, TransactionAuthorizationStatus.AUTHORIZED});
    }

    @Override
    protected void doApplyVisibility(SessionData sessionData, DBQuery<?> dBQuery, P p) {
        User user;
        super.doApplyVisibility(sessionData, dBQuery, p);
        AbstractTransactionQuery abstractTransactionQuery = (AbstractTransactionQuery)p.getParams();
        LocateAccountOwnerResult locateAccountOwnerResult = abstractTransactionQuery instanceof OwnedTransactionQuery ? this.accountHandler.locateOrCurrent((AccountOwner)((OwnedTransactionQuery)abstractTransactionQuery).getOwner(), true) : LocateAccountOwnerResult.empty();
        Set set = this.transactionServiceSecurity.getVisibleNatures(locateAccountOwnerResult.getInternalAccountOwner());
        dBQuery.where((Predicate)this.tx.nature.in((Collection)set));
        if (sessionData.isAdmin() && locateAccountOwnerResult.isEmpty()) {
            this.applyAdminOverviewRestrictedNatures(sessionData, dBQuery, set);
        }
        if ((user = sessionData.getLoggedUser()) != null) {
            dBQuery.where((Predicate)this.fu.eq((Object)user).or((Predicate)this.tx.authorizationType.ne((Object)TransactionAuthorizationType.OPERATOR)));
            if (user.isMember()) {
                dBQuery.where((Predicate)this.tx.nature.notIn((Object[])new TransactionNature[]{TransactionNature.SCHEDULED_PAYMENT, TransactionNature.RECURRING_PAYMENT}).or((Predicate)this.tx.showToReceiver.isTrue()).or((Predicate)this.tu.isNull()).or((Predicate)this.tu.ne((Object)user)));
            }
        }
    }

    private void applyAdminOverviewRestrictedNatures(SessionData sessionData, DBQuery<?> dBQuery, Set<TransactionNature> set) {
        AdminProductAccessor adminProductAccessor = sessionData.getProducts().admin();
        BooleanExpression booleanExpression = this.fat.nature.eq((Object)AccountTypeNature.SYSTEM);
        BooleanExpression booleanExpression2 = this.fat.nature.eq((Object)AccountTypeNature.USER);
        BooleanExpression booleanExpression3 = this.tat.nature.eq((Object)AccountTypeNature.SYSTEM);
        BooleanExpression booleanExpression4 = this.tat.nature.eq((Object)AccountTypeNature.USER);
        if (set.contains(TransactionNature.SCHEDULED_PAYMENT) && !adminProductAccessor.hasPermission(Permission.SYSTEM_SCHEDULED_PAYMENTS_VIEW)) {
            dBQuery.where((Predicate)this.tx.nature.notIn((Object[])new TransactionNature[]{TransactionNature.SCHEDULED_PAYMENT, TransactionNature.RECURRING_PAYMENT}).or((Predicate)booleanExpression2.or((Predicate)booleanExpression4)));
        }
        if (set.contains(TransactionNature.SCHEDULED_PAYMENT) && !adminProductAccessor.hasPermission(Permission.USER_SCHEDULED_PAYMENTS_VIEW)) {
            dBQuery.where((Predicate)this.tx.nature.notIn((Object[])new TransactionNature[]{TransactionNature.SCHEDULED_PAYMENT, TransactionNature.RECURRING_PAYMENT}).or((Predicate)booleanExpression).or((Predicate)booleanExpression3));
        }
        if (set.contains(TransactionNature.PAYMENT_REQUEST) && !adminProductAccessor.hasPermission(Permission.USER_PAYMENT_REQUESTS_VIEW)) {
            dBQuery.where((Predicate)this.tx.nature.ne((Object)TransactionNature.PAYMENT_REQUEST).or((Predicate)booleanExpression).or((Predicate)booleanExpression3));
        }
        if (set.contains(TransactionNature.EXTERNAL_PAYMENT) && !adminProductAccessor.hasPermission(Permission.USER_EXTERNAL_PAYMENTS_VIEW)) {
            dBQuery.where((Predicate)this.tx.nature.ne((Object)TransactionNature.EXTERNAL_PAYMENT).or((Predicate)booleanExpression));
        }
        if (set.contains(TransactionNature.EXTERNAL_PAYMENT) && !adminProductAccessor.hasPermission(Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW)) {
            dBQuery.where((Predicate)this.tx.nature.ne((Object)TransactionNature.EXTERNAL_PAYMENT).or((Predicate)booleanExpression2));
        }
    }
}

