/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounttypes.AccountTypeDTO;
import org.cyclos.model.banking.accounttypes.SystemAccountTypeDTO;
import org.cyclos.model.banking.accounttypes.UserAccountTypeDTO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.springframework.stereotype.Component;

@Component
public class AccountTypeEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<AccountType, AccountTypeDTO> {
    public Class<AccountType> getEntityClass() {
        return AccountType.class;
    }

    public EntityLogType getType() {
        return EntityLogType.ACCOUNT_TYPE;
    }

    public EntityLogDescriptor<AccountTypeDTO> resolveLogDescriptor(AccountType accountType) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDtoType(accountType)).property(AccountTypeDTO.NAME, GeneralKeys.Ui.NAME).property(AccountTypeDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property(AccountTypeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property((Property)AccountTypeDTO.CURRENCY, BankingKeys.AccountTypes.CURRENCY).property((Property)AccountTypeDTO.SHOW_DESCRIPTION_IN_HISTORY_FILTERS, BankingKeys.AccountTypes.SHOW_DESCRIPTION_IN_HISTORY_FILTERS).property((Property)AccountTypeDTO.SHOW_DESCRIPTION_IN_HISTORY_LIST, BankingKeys.AccountTypes.SHOW_DESCRIPTION_IN_HISTORY_LIST).property((Property)AccountTypeDTO.PRINT_HISTORY_LANDSCAPE, BankingKeys.AccountTypes.PRINT_HISTORY_LANDSCAPE).property((Property)AccountTypeDTO.CUSTOM_FIELDS_FOR_SEARCH, BankingKeys.AccountTypes.CUSTOM_FIELDS_FOR_SEARCH).property((Property)AccountTypeDTO.CUSTOM_FIELDS_FOR_LIST, BankingKeys.AccountTypes.CUSTOM_FIELDS_FOR_LIST).property((Property)AccountTypeDTO.NATURE, BankingKeys.AccountTypes.NATURE).property((Property)AccountTypeDTO.MATURITY_FREEZE, BankingKeys.AccountTypes.FREEZ_MATURITY);
        if (accountType instanceof UserAccountType) {
            entityLogDescriptor.cast().property((Property)UserAccountTypeDTO.DEFAULT_YELLOW_BALANCE_RANGE, BankingKeys.AccountTypes.DEFAULT_YELLOW_BALANCE_RANGE).property((Property)UserAccountTypeDTO.DISPOSE_POSITIVE_TYPE, BankingKeys.AccountTypes.DISPOSE_POSITIVE_TYPE).property((Property)UserAccountTypeDTO.DISPOSE_NEGATIVE_TYPE, BankingKeys.AccountTypes.DISPOSE_NEGATIVE_TYPE);
        } else if (accountType instanceof SystemAccountType) {
            entityLogDescriptor.cast().property((Property)SystemAccountTypeDTO.CREDIT_LIMIT, BankingKeys.AccountTypes.CREDIT_LIMIT).property((Property)SystemAccountTypeDTO.UPPER_CREDIT_LIMIT, BankingKeys.AccountTypes.UPPER_CREDIT_LIMIT).property((Property)SystemAccountTypeDTO.LIMIT_TYPE, BankingKeys.AccountTypes.LIMIT_TYPE);
        }
        return entityLogDescriptor;
    }

    @Override
    protected AccountType getEntityToViewLog(long l) {
        return this.hasPermission(Permission.ACCOUNT_CONFIGURATION_VIEW) ? this.find(AccountType.class, l) : null;
    }

    private Class<? extends AccountTypeDTO> resolveDtoType(AccountType accountType) {
        return accountType instanceof UserAccountType ? UserAccountTypeDTO.class : SystemAccountTypeDTO.class;
    }
}

