/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.apache.commons.lang3.time.StopWatch;
import org.cyclos.entities.utils.EntityBackedParameterStorage;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class AccountBalanceClosingRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private NativeQueryHandler nativeQueryHandler;

    @Override
    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.NEXT;
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.ACCOUNT_BALANCE_CLOSING;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.NEXT_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        SessionData sessionData = SessionDataFactory.system();
        TransactionLevel transactionLevel = TransactionLevel.READ_WRITE;
        this.invokerHandler.runAsInTransaction(sessionData, transactionLevel, this::maybeRebuildAccountBalances);
        return (Long)this.invokerHandler.runAsInTransaction(sessionData, transactionLevel, this::closeAccountBalances);
    }

    @Override
    protected boolean isRunInTransaction() {
        return false;
    }

    private long closeAccountBalances(TransactionStatus transactionStatus) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        long l = this.nativeQueryHandler.closeAccountBalances();
        this.getLogger().info("{} balances were closed in {}", (Object)l, (Object)stopWatch);
        return l;
    }

    private long maybeRebuildAccountBalances(TransactionStatus transactionStatus) {
        EntityBackedParameterStorage entityBackedParameterStorage = this.getStorage();
        boolean bl = entityBackedParameterStorage.getBoolean("balancesRebuilt");
        if (!bl) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            entityBackedParameterStorage.setBoolean("balancesRebuilt", true);
            long l = this.nativeQueryHandler.rebuildClosedAccountBalances(null);
            this.getLogger().info("{} account balances were rebuilt in {}", (Object)l, (Object)stopWatch);
            return l;
        }
        this.getLogger().debug("Not rebuilding closed account balances because this is not the first time");
        return 0L;
    }
}

