/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.mutable.MutableLong;
import org.cyclos.entities.access.Otp;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.QTrustedDevice;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.SessionProperties;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.access.UserAgent;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.InternalAuthServiceLocal;
import org.cyclos.impl.access.OtpHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.DeviceActivationException;
import org.cyclos.model.access.InvalidDeviceConfirmationException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.devices.ActivateTrustedDeviceConfirmationField;
import org.cyclos.model.access.devices.ActivateTrustedDeviceDTO;
import org.cyclos.model.access.devices.ActivateTrustedDeviceData;
import org.cyclos.model.access.devices.DeviceActivationMode;
import org.cyclos.model.access.devices.RequestActivationResult;
import org.cyclos.model.access.devices.RequestDeviceActivationParams;
import org.cyclos.model.access.devices.TrustedDeviceAction;
import org.cyclos.model.access.devices.TrustedDeviceActivationParams;
import org.cyclos.model.access.devices.TrustedDeviceActivationWithoutCodeParams;
import org.cyclos.model.access.devices.TrustedDeviceDTO;
import org.cyclos.model.access.devices.TrustedDeviceData;
import org.cyclos.model.access.devices.TrustedDeviceVO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.OtpType;
import org.cyclos.model.access.passwords.SendOtpData;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrustedDeviceServiceImpl
extends BaseServiceImpl
implements TrustedDeviceServiceLocal {
    private static int MAX_ACTIVATION_ATTEMPTS = 10;
    private static QTrustedDevice $ = QTrustedDevice.trustedDevice;
    @Autowired
    private PinServiceLocal pinService;
    @Autowired
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private OtpHandler otpHandler;
    @Autowired
    private InternalAuthServiceLocal internalAuthService;

    public ActivateTrustedDeviceDTO activate(TrustedDeviceActivationParams trustedDeviceActivationParams) {
        this.validate(trustedDeviceActivationParams);
        BasicUser basicUser = this.getLoggedBasicUser();
        try {
            TrustedDevice trustedDevice;
            if (trustedDeviceActivationParams.getDeviceId() != null) {
                this.deviceConfirmationService.check(trustedDeviceActivationParams.getDeviceConfirmationId(), ActivateTrustedDeviceConfirmationField.confirmation((TrustedDeviceVO)new TrustedDeviceVO(trustedDeviceActivationParams.getDeviceId()), (TrustedDeviceAction)TrustedDeviceAction.ACTIVATE));
                trustedDevice = this.find(TrustedDevice.class, trustedDeviceActivationParams.getDeviceId());
            } else {
                Otp otp = this.otpHandler.verify(OtpType.DEVICE_ACTIVATION, (OtpOwner)basicUser, trustedDeviceActivationParams.getCode());
                trustedDevice = otp.getTrustedDevice();
                if (trustedDevice == null) {
                    throw new ValidationException();
                }
            }
            this.failedActionHandler.clearUserFailures(FailedAction.FAILED_DEVICE_ACTIVATION, basicUser);
            return this.doActivate(trustedDevice);
        }
        catch (EntityNotFoundException | ValidationException | InvalidDeviceConfirmationException throwable) {
            boolean bl = this.failedActionHandler.recordAndBlockUserIfMaxReached(FailedAction.FAILED_DEVICE_ACTIVATION, basicUser, Integer.valueOf(MAX_ACTIVATION_ATTEMPTS), UserAlertType.MAX_DEVICE_ACTIVATION_ATTEMPTS_REACHED);
            throw new DeviceActivationException(bl);
        }
    }

    public ActivateTrustedDeviceData activateIfPossible(TrustedDeviceActivationWithoutCodeParams trustedDeviceActivationWithoutCodeParams) {
        UserAgent userAgent;
        SendOtpData sendOtpData = null;
        ActivateTrustedDeviceDTO activateTrustedDeviceDTO = null;
        this.validate(trustedDeviceActivationWithoutCodeParams);
        BasicUser basicUser = this.getLoggedBasicUser();
        if (!basicUser.isEmailVerified() && !basicUser.hasVerifiedMobilePhone()) {
            sendOtpData = this.getActivationData();
        } else {
            userAgent = this.internalAuthService.findUserAgent(basicUser, trustedDeviceActivationWithoutCodeParams.getUserAgentId());
            if (userAgent == null || !userAgent.isUserRegistration()) {
                sendOtpData = this.getActivationData();
            }
        }
        if (sendOtpData == null) {
            userAgent = this.createTrustedDevice(trustedDeviceActivationWithoutCodeParams.getName(), trustedDeviceActivationWithoutCodeParams.getPindId());
            activateTrustedDeviceDTO = this.doActivate((TrustedDevice)userAgent);
        }
        userAgent = new ActivateTrustedDeviceData();
        userAgent.setActivateTrustedDeviceDto(activateTrustedDeviceDTO);
        userAgent.setSendOtpData(sendOtpData);
        return userAgent;
    }

    public void checkForLogin(String string, String string2, String string3) {
        TrustedDevice trustedDevice = this.getSessionData().getTrustedDevice();
        if (trustedDevice == null) {
            throw new IllegalActionException("The trusted device associated to the session data is null");
        }
        if (ObjectHelper.anyIsNull((Object[])new Object[]{string2, StringHelper.trimToNull((Object)string3)})) {
            throw new IllegalActionException("Both device confirmation id and HMAC are required");
        }
        try {
            this.deviceConfirmationService.validate(string2, trustedDevice.getId().longValue(), string3);
        }
        catch (InvalidDeviceConfirmationException invalidDeviceConfirmationException) {
            ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
            Integer n = configurationAccessor.getInvalidUsernameAttempts();
            TimeInterval timeInterval = configurationAccessor.getRemoteAddressBlockTime();
            UserLocatorVO userLocatorVO = new UserLocatorVO();
            userLocatorVO.setPrincipal(this.getFormatter().format((INamedEntity)trustedDevice));
            userLocatorVO.setPrincipalType(ExistingBuiltInPrincipalType.TRUSTED_DEVICE.getInternalName());
            boolean bl = this.failedActionHandler.recordGuestFailure(FailedAction.FAILED_PRINCIPAL, string, userLocatorVO, n, timeInterval);
            if (bl) {
                throw new RemoteAddressBlockedException();
            }
            throw invalidDeviceConfirmationException;
        }
    }

    public boolean exists(long l) {
        return ((DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{TrustedDeviceServiceImpl.$.id.eq((Object)l), TrustedDeviceServiceImpl.$.key.isNotNull()})).hasResults();
    }

    public SendOtpData getActivationData() {
        return this.otpHandler.getSendOtpData();
    }

    public CredentialInputDTO getConfirmationPasswordInputForRemove(@NotNull Long l) throws FrameworkException {
        this.find(TrustedDevice.class, l);
        return this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput();
    }

    public TrustedDeviceData getData(long l) throws FrameworkException {
        TrustedDevice trustedDevice = this.find(TrustedDevice.class, l);
        TrustedDeviceData trustedDeviceData = new TrustedDeviceData();
        trustedDeviceData.setDevice((TrustedDeviceDTO)this.conversionHandler.convert(TrustedDeviceDTO.class, (Object)trustedDevice));
        trustedDeviceData.setCanManage(true);
        return trustedDeviceData;
    }

    public DeviceActivationMode getDeviceActivationMode() {
        boolean bl = this.hasAvailableSendMediums();
        boolean bl2 = this.isRequireTrustedDeviceForLogin();
        if (bl2) {
            boolean bl3;
            boolean bl4 = bl3 = !this.hasActiveDevices(this.getLoggedBasicUser());
            if (bl3) {
                return bl ? DeviceActivationMode.REQUIRED : DeviceActivationMode.REQUIRED_NO_MEDIUMS;
            }
            return DeviceActivationMode.REQUIRED_WITH_DEVICE;
        }
        return bl ? DeviceActivationMode.OPTIONAL : DeviceActivationMode.DISABLED;
    }

    public boolean hasActiveDevices(BasicUser basicUser) {
        return basicUser == null ? false : ((DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{$.user().eq((Object)basicUser), TrustedDeviceServiceImpl.$.key.isNotNull()})).hasResults();
    }

    public List<TrustedDeviceVO> list(UserLocatorVO userLocatorVO) {
        BasicUser basicUser = userLocatorVO == null ? this.getLoggedBasicUser() : this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).where((com.querydsl.core.types.Predicate)$.user().eq((Object)basicUser))).orderBy(TrustedDeviceServiceImpl.$.name.asc())).list(TrustedDeviceVO.class, (Expression)$);
    }

    public TrustedDevice loadForOperate(long l) {
        return (TrustedDevice)((DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{TrustedDeviceServiceImpl.$.id.eq((Object)l), $.user().eq((Object)this.getLoggedBasicUser()), TrustedDeviceServiceImpl.$.key.isNotNull()})).requiredUniqueResult((Expression)$);
    }

    public long purgePendingActivations(Date date) {
        MutableLong mutableLong = new MutableLong(0L);
        ((DBQuery)this.selectFrom($).where(new com.querydsl.core.types.Predicate[]{TrustedDeviceServiceImpl.$.date.lt((Comparable)date), TrustedDeviceServiceImpl.$.key.isNull()})).fetch().forEach(trustedDevice -> {
            if (trustedDevice.getPin() != null) {
                trustedDevice.getPin().setTrustedDevice(null);
            }
            this.remove((IEntity)trustedDevice);
            mutableLong.increment();
        });
        return mutableLong.getValue();
    }

    public void remove(Long l, String string) {
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(string, ActivateTrustedDeviceConfirmationField.confirmation((TrustedDeviceVO)new TrustedDeviceVO(l), (TrustedDeviceAction)TrustedDeviceAction.REMOVE));
        TrustedDevice trustedDevice = this.find(TrustedDevice.class, l);
        trustedDevice.getSessions().forEach(arg_0 -> ((SessionHandler)this.sessionHandler).remove(arg_0));
        if (trustedDevice.getPin() != null) {
            trustedDevice.getPin().setTrustedDevice(null);
            this.entityManagerHandler.flush();
        }
        this.rawEntityManagerHandler.remove((IEntity)trustedDevice);
    }

    public RequestActivationResult requestActivationCode(RequestDeviceActivationParams requestDeviceActivationParams) {
        boolean bl = this.validate(requestDeviceActivationParams);
        TrustedDevice trustedDevice = null;
        if (requestDeviceActivationParams.getDeviceId() != null) {
            if (bl) {
                throw new IllegalActionException("Retry request an activation code is not allowed");
            }
            trustedDevice = this.find(TrustedDevice.class, requestDeviceActivationParams.getDeviceId());
            if (StringHelper.isNotBlank((Object)trustedDevice.getKey())) {
                throw new IllegalActionException("Device already active");
            }
        } else {
            trustedDevice = this.createTrustedDevice(requestDeviceActivationParams.getName(), requestDeviceActivationParams.getPinId());
        }
        if (bl) {
            RequestActivationResult requestActivationResult = new RequestActivationResult();
            requestActivationResult.setDevice((TrustedDeviceVO)this.conversionHandler.convert(TrustedDeviceVO.class, (Object)trustedDevice));
            return requestActivationResult;
        }
        SendMedium sendMedium = requestDeviceActivationParams.getMedium();
        MobilePhone mobilePhone = sendMedium == SendMedium.SMS ? (MobilePhone)this.conversionHandler.convert(MobilePhone.class, (Object)requestDeviceActivationParams.getMobilePhone()) : null;
        return this.otpHandler.sendForDeviceActivation(trustedDevice, mobilePhone);
    }

    public void save(TrustedDeviceDTO trustedDeviceDTO) {
        if (trustedDeviceDTO.isTransient()) {
            throw new IllegalActionException("This method only supports updating a trusted device. To create a new one, use the requestActivationCode() method");
        }
        this.validate(trustedDeviceDTO);
        TrustedDevice trustedDevice = (TrustedDevice)this.conversionHandler.convert(TrustedDevice.class, (Object)trustedDeviceDTO);
        if (trustedDevice.getPin() != null) {
            trustedDevice.getPin().setName(trustedDevice.getName());
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.user().network(), true);
    }

    private TrustedDevice createTrustedDevice(String string, Long l) {
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        TrustedDevice trustedDevice = new TrustedDevice();
        trustedDevice.setDate(new Date());
        if (sessionData.getPin() != null) {
            trustedDevice.setName(sessionData.getPin().getName());
            sessionData.getPin().setTrustedDevice(trustedDevice);
        } else if (l != null) {
            Pin pin = this.pinService.locatePin(new PinLocatorVO(l), true);
            trustedDevice.setName(pin.getName());
            pin.setTrustedDevice(trustedDevice);
        } else {
            trustedDevice.setName(this.getUniqueDeviceName(basicUser, string));
        }
        trustedDevice.setUser(basicUser);
        this.persist((IEntity)trustedDevice);
        return trustedDevice;
    }

    private ActivateTrustedDeviceDTO doActivate(TrustedDevice trustedDevice) {
        SessionProperties sessionProperties;
        String string = SecureRandomHelper.randomAlphanumeric((int)64);
        trustedDevice.setKey(string);
        trustedDevice.setDate(new Date());
        Session session = this.getSessionData().getSession();
        if (session != null) {
            sessionProperties = new SessionProperties();
            sessionProperties.setTrustedDevice(trustedDevice);
            this.sessionHandler.setProperties(session, sessionProperties);
        }
        sessionProperties = new ActivateTrustedDeviceDTO();
        sessionProperties.setDevice((TrustedDeviceVO)this.conversionHandler.convert(TrustedDeviceVO.class, (Object)trustedDevice));
        sessionProperties.setKey(string);
        return sessionProperties;
    }

    private String getUniqueDeviceName(BasicUser basicUser, String object) {
        Predicate<String> predicate = string -> ((DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{$.user().eq((Object)basicUser), TrustedDeviceServiceImpl.$.name.eq(string)})).hasResults();
        int n = 1;
        while (predicate.test((String)object)) {
            int n2 = ((String)object).lastIndexOf("_");
            if (n2 != -1) {
                object = ((String)object).substring(0, n2 + 1) + n++;
                continue;
            }
            object = (String)object + "_" + n++;
        }
        return object;
    }

    private boolean hasAvailableSendMediums() {
        return this.otpHandler.hasAvailableSendMediums();
    }

    private boolean isRequireTrustedDeviceForActivation() {
        if (!this.hasActiveDevices(this.getLoggedBasicUser())) {
            return false;
        }
        return this.isRequireTrustedDeviceForLogin();
    }

    private boolean isRequireTrustedDeviceForLogin() {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(this.getLoggedBasicUser());
        return configurationAccessor.getChannels().stream().anyMatch(channel -> configurationAccessor.getChannelConfiguration(channel).isRequireTrustedDeviceForLogin());
    }

    private boolean validate(RequestDeviceActivationParams requestDeviceActivationParams) {
        Validator validator = new Validator();
        boolean bl = this.isRequireTrustedDeviceForActivation();
        if (!bl) {
            validator.property((Property)RequestDeviceActivationParams.MEDIUM, AccessKeys.Devices.SEND_MEDIUM).required().add((object, object2, object3) -> {
                SendMedium sendMedium = (SendMedium)object3;
                if (!this.otpHandler.getAvailableSendMediums().contains(sendMedium) || sendMedium == SendMedium.EMAIL && StringHelper.isBlank((Object)this.getLoggedBasicUser().getEmail())) {
                    return ValidationErrors.invalid();
                }
                return null;
            });
            if (requestDeviceActivationParams.getDeviceId() == null) {
                validator.property((Property)RequestDeviceActivationParams.NAME, AccessKeys.Devices.NAME).required();
            }
            if (requestDeviceActivationParams.getMedium() == SendMedium.SMS) {
                validator.property((Property)RequestDeviceActivationParams.MOBILE_PHONE, AccessKeys.Devices.MOBILE_PHONE).required();
            }
            this.validate(validator, requestDeviceActivationParams, "requestDeviceActivationParams");
        } else if (!this.hasActiveDevices(this.getLoggedBasicUser())) {
            throw new ValidationException(this.message(AccessKeys.Devices.ERROR_REQUIRED_DEVICE_FOR_ACTIVATION, new Object[0]));
        }
        return bl;
    }

    private void validate(TrustedDeviceActivationParams trustedDeviceActivationParams) {
        Validator validator = new Validator();
        if (this.isRequireTrustedDeviceForActivation()) {
            validator.property((Property)TrustedDeviceActivationParams.DEVICE_CONFIRMATION_ID, AccessKeys.Devices.CONFIRMATION).required();
            validator.property((Property)TrustedDeviceActivationParams.DEVICE_ID, AccessKeys.Devices.DEVICE_ID).required();
            validator.property((Property)TrustedDeviceActivationParams.CODE, AccessKeys.Devices.ACTIVATION_CODE).invalid();
        } else {
            validator.property((Property)TrustedDeviceActivationParams.CODE, AccessKeys.Devices.ACTIVATION_CODE).required();
            validator.property((Property)TrustedDeviceActivationParams.DEVICE_CONFIRMATION_ID, AccessKeys.Devices.CONFIRMATION).invalid();
            validator.property((Property)TrustedDeviceActivationParams.DEVICE_ID, AccessKeys.Devices.ACTIVATION_CODE).invalid();
        }
        this.validate(validator, trustedDeviceActivationParams, "trustedDeviceActivationParams");
    }

    private void validate(TrustedDeviceActivationWithoutCodeParams trustedDeviceActivationWithoutCodeParams) {
        Validator validator = new Validator();
        validator.property((Property)TrustedDeviceActivationWithoutCodeParams.NAME, AccessKeys.Devices.NAME).required();
        validator.property((Property)TrustedDeviceActivationWithoutCodeParams.USER_AGENT_ID, AccessKeys.Devices.DEVICE_ID).required();
        this.validate(validator, trustedDeviceActivationWithoutCodeParams, "trustedDeviceActivationWithoutCodeParams");
    }

    private void validate(TrustedDeviceDTO trustedDeviceDTO) {
        Validator validator = new Validator();
        BasicUser basicUser = this.getLoggedBasicUser();
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{$.user().eq((Object)basicUser), TrustedDeviceServiceImpl.$.name.eq((Object)trustedDeviceDTO.getName()), TrustedDeviceServiceImpl.$.id.ne((Object)trustedDeviceDTO.getId())});
        String string = "trustedDeviceName_" + basicUser.getId() + "_" + trustedDeviceDTO.getName();
        validator.property(TrustedDeviceDTO.NAME, AccessKeys.Devices.NAME).required().unique(string, (AbstractJPAQuery)dBQuery);
        this.validate(validator, trustedDeviceDTO, "trustedDeviceDTO");
    }
}

