/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.BaseOidcClient;
import org.cyclos.entities.access.DynamicOidcClient;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.access.OidcKeys;
import org.cyclos.entities.access.QOidcAccessToken;
import org.cyclos.entities.access.QOidcAuthorization;
import org.cyclos.entities.access.QOidcKeys;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.DynamicOidcClientConfiguration;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.Address;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.QUserCustomFieldPossibleValue;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldPossibleValue;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.OidcAuthorizationServiceLocal;
import org.cyclos.impl.access.OidcClientServiceLocal;
import org.cyclos.impl.access.OidcServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.system.ImageVOConverter;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.utils.InputOutputProcessingHandler;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.RetryException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InaccessibleChannelException;
import org.cyclos.model.access.InvalidAccessTokenException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.oidcclients.AuthorizationStatus;
import org.cyclos.model.access.oidcclients.BaseOidcClientDTO;
import org.cyclos.model.access.oidcclients.ResponseMode;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.fields.DynamicFieldValueVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.utils.ICurrencyAmount;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.model.access.oidc.AuthorizeRequest;
import org.cyclos.server.model.access.oidc.AuthorizeResponse;
import org.cyclos.server.model.access.oidc.ClientRequest;
import org.cyclos.server.model.access.oidc.ConsentData;
import org.cyclos.server.model.access.oidc.ConsentParams;
import org.cyclos.server.model.access.oidc.OpenidConfiguration;
import org.cyclos.server.model.access.oidc.RegisterRequest;
import org.cyclos.server.model.access.oidc.RegisterResponse;
import org.cyclos.server.model.access.oidc.RevokeRequest;
import org.cyclos.server.model.access.oidc.TokenRequest;
import org.cyclos.server.model.access.oidc.TokenResponse;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.services.access.OidcException;
import org.cyclos.services.access.OidcRegisterException;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class OidcServiceImpl
extends BaseServiceImpl
implements OidcServiceLocal {
    private static final QOidcAuthorization $a = QOidcAuthorization.oidcAuthorization;
    private static final QOidcAccessToken $at = QOidcAccessToken.oidcAccessToken;
    private static final QOidcKeys $k = QOidcKeys.oidcKeys;
    private static final int KEY_SIZE = 2048;
    @Autowired
    private OidcClientServiceLocal oidcClientService;
    @Autowired
    private OidcAuthorizationServiceLocal oidcAuthorizationService;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private ConfigurationImageServiceLocal configurationImageService;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private UserCustomFieldServiceLocal userCustomFieldService;
    private Cache<String, JWKSet> cache;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    @Lazy
    private InputOutputProcessingHandler inputOutputProcessingHandler;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;

    public AuthorizeResponse approve(ConsentParams consentParams) throws FrameworkException {
        Object object;
        Object object2;
        SessionHandler.UserCheckResult userCheckResult;
        OidcAuthorization oidcAuthorization = this.locateForConsent(consentParams.getLocator());
        SessionData sessionData = this.getSessionData();
        try {
            userCheckResult = (SessionHandler.UserCheckResult)this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
                String string = sessionData.getRemoteAddress();
                UserLocatorVO userLocatorVO = new UserLocatorVO();
                userLocatorVO.setPrincipalType("*");
                userLocatorVO.setPrincipal(consentParams.getUser());
                return this.sessionHandler.checkUserAccess(false, false, sessionData.getNetwork(), BuiltInChannel.OIDC.getInternalName(), string, userLocatorVO, consentParams.getPassword(), null);
            });
        }
        catch (LoginException loginException) {
            if (ObjectHelper.isOneOf((Object)loginException.getPasswordStatus(), (Object[])new Object[]{PasswordStatus.EXPIRED, PasswordStatus.RESET, PasswordStatus.PENDING})) {
                throw new ValidationException(this.message(AccessKeys.OidcConsent.ERROR_PASSWORD_STATUS, sessionData.getConfiguration().getApplicationName()));
            }
            throw loginException;
        }
        catch (InaccessibleChannelException inaccessibleChannelException) {
            throw new ValidationException(this.message(AccessKeys.OidcConsent.ERROR_CHANNEL, new Object[0]));
        }
        BasicUser basicUser = userCheckResult.getUser();
        Set set = oidcAuthorization.getScopes();
        if (CollectionHelper.containsAny((Collection)set, (Object[])new Object[]{Scope.ACCOUNT_STATUS, Scope.ACCOUNT_HISTORY}) && (object2 = oidcAuthorization.getGrantedAccountType()) != null) {
            try {
                this.accountService.load((InternalAccountOwner)basicUser, (AccountType)object2);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw new ValidationException(this.message(AccessKeys.OidcConsent.ERROR_NO_ACCOUNT_TYPE, object2));
            }
        }
        if (set.contains(Scope.PAYMENT)) {
            object2 = oidcAuthorization.getPaymentCurrency();
            if (object2 != null && !this.productsHandler.getAccessor(basicUser).member().getMyPaymentTypes().stream().anyMatch(arg_0 -> OidcServiceImpl.lambda$approve$1((Currency)object2, arg_0))) {
                throw new ValidationException(this.message(AccessKeys.OidcConsent.ERROR_NO_PAYMENT_FOR_CURRENCY, object2));
            }
            object = oidcAuthorization.getPaymentTo();
            if (object != null && !this.authHandler.relatesTo(basicUser, (BasicUser)object)) {
                throw new ValidationException(this.message(AccessKeys.OidcConsent.ERROR_PAYEE_NOT_ACCESSIBLE, object));
            }
        }
        object2 = new Date();
        oidcAuthorization.initFrom((UserPrincipal)userCheckResult.getLocateUserResult());
        oidcAuthorization.setConsentDate((Date)object2);
        if (!oidcAuthorization.isOfflineAccess()) {
            object = this.oidcClientService.getAccessor(oidcAuthorization.getClient());
            oidcAuthorization.setExpirationDate(DateHelper.add((Date)object2, (ITimeInterval)object.getAccessTokenExpiration()));
        }
        oidcAuthorization.setConsentRemoteAddress(sessionData.getRequestData().getRemoteAddress());
        if (oidcAuthorization.isCode()) {
            oidcAuthorization.setAuthorizationCode(UUID.randomUUID().toString());
            oidcAuthorization.setAuthorizationCodeExpiration(DateHelper.add((Date)object2, (TimeField)TimeField.HOURS, (int)1));
        }
        object = new HashMap();
        object.put("state", oidcAuthorization.getState());
        if (oidcAuthorization.isCode()) {
            object.put("code", oidcAuthorization.getAuthorizationCode());
        }
        if (oidcAuthorization.isToken()) {
            OidcAccessToken oidcAccessToken = this.createAccessToken(oidcAuthorization, oidcAuthorization.isIdToken());
            object.put("token", oidcAccessToken.getTokenValue());
            if (oidcAuthorization.isIdToken()) {
                object.put("id_token", oidcAccessToken.getIdToken());
            }
        } else if (oidcAuthorization.isIdToken()) {
            object.put("id_token", this.createIdToken(oidcAuthorization, null));
            if (!oidcAuthorization.isCode()) {
                this.rawEntityManagerHandler.remove((IEntity)oidcAuthorization);
            }
        }
        return new AuthorizeResponse(oidcAuthorization.getRedirectUrl(), oidcAuthorization.getResponseMode(), (Map)object);
    }

    public AuthorizeResponse authorize(AuthorizeRequest authorizeRequest) throws FrameworkException, OidcException {
        Object object;
        ResponseMode responseMode;
        UserAccountType userAccountType;
        Map map;
        ErrorBuilder errorBuilder = new ErrorBuilder(authorizeRequest.getState());
        errorBuilder.required("client_id", authorizeRequest.getClientId());
        errorBuilder.required("redirect_uri", authorizeRequest.getRedirectUri());
        errorBuilder.required("response_type", authorizeRequest.getResponseType());
        errorBuilder.required("scope", authorizeRequest.getScope());
        String string = StringHelper.trimToNull((Object)authorizeRequest.getClientId());
        BaseOidcClient baseOidcClient = string == null ? null : this.oidcClientService.getByClientId(string);
        errorBuilder.invalidIf("The given client is invalid", () -> baseOidcClient == null);
        errorBuilder.raiseIf("unauthorized_client", "The given client is disabled", () -> !baseOidcClient.isEnabled());
        OidcClientAccessor oidcClientAccessor = this.oidcClientService.getAccessor(baseOidcClient);
        errorBuilder.invalidIf("The given redirect_uri is not allowed", () -> !StringHelper.anyLineMatches((String)baseOidcClient.getRedirectUris(), (boolean)true, authorizeRequest.getRedirectUri()::equals));
        errorBuilder.redirectUri = authorizeRequest.getRedirectUri();
        try {
            map = Scope.parse((String)authorizeRequest.getScope());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorBuilder.raise("invalid_scope", illegalArgumentException.getMessage());
            throw illegalArgumentException;
        }
        EnumSet enumSet = EnumSet.copyOf(map.keySet());
        enumSet.removeAll(oidcClientAccessor.getScopes());
        errorBuilder.raiseIf("invalid_scope", "The following scopes are not allowed for this client: " + StringHelper.join(enumSet, (String)", "), () -> !enumSet.isEmpty());
        boolean bl = map.containsKey(Scope.OPENID);
        if (!bl) {
            userAccountType = EnumSet.copyOf(map.keySet());
            userAccountType.removeIf(scope -> !scope.dependsOnOpenid());
            errorBuilder.raiseIf("invalid_scope", "The following scopes cannot be granted because the openind scope isn't granted too: " + StringHelper.join((Collection)userAccountType, (String)", "), () -> OidcServiceImpl.lambda$authorize$7((EnumSet)userAccountType));
        }
        userAccountType = this.parseAccountParams(errorBuilder, oidcClientAccessor, map);
        PaymentParameters paymentParameters = this.parsePaymentParams(errorBuilder, oidcClientAccessor, map);
        List list = StringHelper.splitTrimming((String)authorizeRequest.getResponseType(), (String)" ");
        if (bl) {
            errorBuilder.invalidIf("The given response_type parameter is invalid", () -> list.isEmpty() || list.stream().anyMatch(string -> !RESPONSE_TYPES.contains(string)));
        } else {
            errorBuilder.invalidIf("When the openid scope is not requested, cannot request multiple response types", () -> list.size() > 1);
            errorBuilder.invalidIf("The given response_type parameter is invalid", () -> ObjectHelper.isNotOneOf(list.get(0), (Object[])new Object[]{"code", "token"}));
        }
        errorBuilder.raiseIf("invalid_scope", "The offline_access scope can only be requested with response_type code", () -> map.containsKey(Scope.OFFLINE_ACCESS) && !list.contains("code"));
        String string2 = authorizeRequest.getResponseMode();
        if (!RESPONSE_MODES.contains(string2)) {
            string2 = null;
        }
        if ("query".equals(string2) && list.contains("id_token")) {
            string2 = null;
        }
        if (string2 == null) {
            string2 = list.contains("code") ? "query" : "fragment";
        }
        errorBuilder.responseMode = responseMode = ResponseMode.of((String)string2);
        String string3 = StringHelper.trimToNull((Object)authorizeRequest.getDisplay());
        errorBuilder.invalidIf("The display parameter is invalid", () -> string3 != null && !DISPLAYS.contains(string3));
        if (bl) {
            object = StringHelper.splitTrimming((String)authorizeRequest.getPrompt(), (String)" ");
            boolean bl2 = object.contains("none");
            errorBuilder.invalidIf("The prompt parameter cannot include none together with another value", () -> OidcServiceImpl.lambda$authorize$14(bl2, (List)object));
            errorBuilder.raiseIf("login_required", "Login is required", () -> bl2);
        }
        object = new OidcAuthorization();
        object.setCreationDate(new Date());
        object.setLocator(UUID.randomUUID().toString());
        object.setClient(baseOidcClient);
        object.setResponseType(authorizeRequest.getResponseType());
        object.setResponseMode(responseMode);
        object.setScope(authorizeRequest.getScope());
        object.setOidcOnly(Scope.isOidc((String)authorizeRequest.getScope()));
        object.setGrantedAccountType(userAccountType);
        object.setPaymentTo(paymentParameters.to);
        object.setPaymentCurrency(paymentParameters.currency);
        object.setPaymentAmount(paymentParameters.amount);
        object.setRedirectUrl(authorizeRequest.getRedirectUri());
        object.setDisplay(string3);
        object.setLoginHint(authorizeRequest.getLoginHint());
        object.setNonce(authorizeRequest.getNonce());
        object.setState(authorizeRequest.getState());
        object.setLoginHint(authorizeRequest.getLoginHint());
        try {
            this.persist((IEntity)object);
        }
        catch (Exception exception) {
            throw new RetryException();
        }
        String string4 = this.getSessionData().getRequestData().getBaseUrl() + "/consent/" + object.getLocator();
        return new AuthorizeResponse(string4);
    }

    public RSAKey createKey(Date date) {
        return (RSAKey)this.createAndPersistKey(date).getSecond();
    }

    public AuthorizeResponse deny(String string) throws FrameworkException {
        OidcAuthorization oidcAuthorization = this.locateForConsent(string);
        this.remove((IEntity)oidcAuthorization);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("state", oidcAuthorization.getState());
        hashMap.put("error", "access_denied");
        hashMap.put("error_description", "The user has denied the request");
        return new AuthorizeResponse(oidcAuthorization.getRedirectUrl(), oidcAuthorization.getResponseMode(), hashMap);
    }

    public OidcAccessToken findAccessToken(Network network, String string, String string2) {
        Date date = DateHelper.subtract((Date)new Date(), (TimeField)TimeField.MINUTES, (int)3);
        OidcAccessToken oidcAccessToken = (OidcAccessToken)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$at}).where(new Predicate[]{OidcServiceImpl.$at.accessToken.eq((Object)string2), OidcServiceImpl.$at.authorization().client().enabled.isTrue(), OidcServiceImpl.$at.authorization().user().status.eq((Object)UserStatus.ACTIVE), OidcServiceImpl.$at.expirationDate.after((Comparable)date), network == null ? $at.authorization().client().network().isNull() : $at.authorization().client().network().eq((Object)network)})).singleResult((Expression)$at);
        if (oidcAccessToken == null) {
            ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
            Integer n = configurationAccessor.getInvalidUsernameAttempts();
            TimeInterval timeInterval = configurationAccessor.getRemoteAddressBlockTime();
            UserLocatorVO userLocatorVO = new UserLocatorVO();
            userLocatorVO.setPrincipal(string2);
            userLocatorVO.setPrincipalType("oidc");
            boolean bl = this.failedActionHandler.recordGuestFailure(FailedAction.FAILED_PRINCIPAL, string, userLocatorVO, n, timeInterval);
            if (bl) {
                throw new RemoteAddressBlockedException();
            }
            throw new InvalidAccessTokenException();
        }
        return oidcAccessToken;
    }

    public ConsentData getConsentData(String string) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        FormatterImpl formatterImpl = this.getFormatter();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        OidcAuthorization oidcAuthorization = this.locateForConsent(string);
        Set set = oidcAuthorization.getScopes();
        BaseOidcClient baseOidcClient = oidcAuthorization.getClient();
        ConsentData consentData = new ConsentData();
        OidcClientAccessor oidcClientAccessor = this.oidcClientService.getAccessor(baseOidcClient);
        consentData.setClient((BaseOidcClientDTO)this.oidcClientService.toDTO((SimpleEntity)baseOidcClient));
        consentData.setLoginHint(oidcAuthorization.getLoginHint());
        consentData.setScopes(set.stream().sorted().map(scope -> this.oidcAuthorizationService.toScopeVO(scope, oidcAuthorization)).collect(Collectors.toList()));
        consentData.setExpiresAfter(oidcAuthorization.isOfflineAccess() ? null : formatterImpl.format((ITimeInterval)oidcClientAccessor.getAccessTokenExpiration()));
        if (CollectionHelper.containsAny((Collection)set, (Object[])new Object[]{Scope.ACCOUNT_STATUS, Scope.ACCOUNT_HISTORY}) && oidcAuthorization.getGrantedAccountType() != null) {
            consentData.setAccountType(this.getTranslatedName((NamedEntity)oidcAuthorization.getGrantedAccountType()));
        }
        if (set.contains(Scope.PAYMENT) && oidcAuthorization.getPaymentTo() != null) {
            consentData.setPaymentTo(formatterImpl.format((BasicUser)oidcAuthorization.getPaymentTo()));
            consentData.setPaymentAmount(formatterImpl.format((ICurrencyAmount)oidcAuthorization.getCurrencyAmount()));
            consentData.setSinglePayment(true);
        }
        consentData.setResourceCacheKey(this.initializationService.getResourceCacheKey());
        consentData.setCountry(configurationAccessor.getCountry());
        BuiltinLanguage builtinLanguage = configurationAccessor.getLanguage().getTemplate();
        consentData.setLocale(LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage).toString());
        consentData.setApplicationName(configurationAccessor.getApplicationName());
        ConfigurationVO configurationVO = new ConfigurationVO(configurationAccessor.getConfiguration().getId());
        consentData.setShortcutIcon((ImageVO)this.configurationImageService.getImageVO(configurationVO, ConfigurationImageType.SHORTCUT_ICON));
        consentData.setApplicationLogo((ImageVO)this.configurationImageService.getImageVO(configurationVO, ConfigurationImageType.PAY_LOGO));
        consentData.setPasswordInput(this.passwordHandler.getCredentialInput(sessionData.getChannelAccessAccessor(), CredentialUsage.ACCESS, null));
        return consentData;
    }

    public RSAKey getKey(String string) {
        String string2 = (String)((DBQuery)this.from(new EntityPath[]{$k}).where((Predicate)OidcServiceImpl.$k.kid.eq((Object)string))).requiredUniqueResult((Expression)OidcServiceImpl.$k.jwk);
        return this.decryptKey(string2);
    }

    public OpenidConfiguration getOpenidConfiguration() throws FrameworkException {
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        DynamicOidcClientConfiguration dynamicOidcClientConfiguration = configurationAccessor.getDynamicOidcClientConfiguration();
        String string = configurationAccessor.getApiUrl();
        OpenidConfiguration openidConfiguration = new OpenidConfiguration();
        openidConfiguration.setIssuer(this.linkGeneratorHandler.root(null));
        openidConfiguration.setAuthorization_endpoint(string + "/oidc/authorize");
        openidConfiguration.setToken_endpoint(string + "/oidc/token");
        openidConfiguration.setRevocation_endpoint(string + "/oidc/revoke");
        openidConfiguration.setUserinfo_endpoint(string + "/oidc/userinfo");
        openidConfiguration.setJwks_uri(string + "/oidc/jwks");
        openidConfiguration.setRegistration_endpoint(dynamicOidcClientConfiguration != null && dynamicOidcClientConfiguration.isEnabled() ? string + "/oidc/register" : null);
        openidConfiguration.setScopes_supported(Scope.NAMES);
        openidConfiguration.setResponse_types_supported(ALL_RESPONSE_TYPES);
        openidConfiguration.setResponse_modes_supported(RESPONSE_MODES);
        openidConfiguration.setGrant_types_supported(GRANT_TYPES);
        openidConfiguration.setAcr_values_supported(Collections.emptyList());
        openidConfiguration.setSubject_types_supported(SUBJECT_TYPES);
        openidConfiguration.setId_token_signing_alg_values_supported(SIGNING_ALGS);
        openidConfiguration.setId_token_encryption_alg_values_supported(Collections.emptyList());
        openidConfiguration.setId_token_encryption_enc_values_supported(Collections.emptyList());
        openidConfiguration.setUserinfo_signing_alg_values_supported(SIGNING_ALGS);
        openidConfiguration.setUserinfo_encryption_alg_values_supported(Collections.emptyList());
        openidConfiguration.setUserinfo_encryption_enc_values_supported(Collections.emptyList());
        openidConfiguration.setRequest_object_signing_alg_values_supported(Collections.emptyList());
        openidConfiguration.setRequest_object_encryption_alg_values_supported(Collections.emptyList());
        openidConfiguration.setRequest_object_encryption_enc_values_supported(Collections.emptyList());
        openidConfiguration.setToken_endpoint_auth_methods_supported(ENDPOINT_AUTHS);
        openidConfiguration.setToken_endpoint_auth_signing_alg_values_supported(Collections.emptyList());
        openidConfiguration.setDisplay_values_supported(DISPLAYS);
        openidConfiguration.setClaim_types_supported(CLAIM_TYPES);
        ArrayList arrayList = new ArrayList(CLAIMS);
        arrayList.addAll(this.userCustomFieldService.listOidcClaims());
        openidConfiguration.setClaims_supported(arrayList);
        openidConfiguration.setService_documentation(this.cyclosProperties.isRestReference() ? string : null);
        openidConfiguration.setClaims_locales_supported(Collections.emptyList());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(configurationAccessor.getLanguage().getTemplate().getLocale('-'));
        configurationAccessor.getAllowedLanguages().forEach(language -> arrayList2.add(language.getTemplate().getLocale('-')));
        openidConfiguration.setUi_locales_supported(arrayList2);
        openidConfiguration.setClaims_parameter_supported(false);
        openidConfiguration.setRequest_parameter_supported(false);
        openidConfiguration.setRequest_uri_parameter_supported(false);
        openidConfiguration.setRequire_request_uri_registration(false);
        openidConfiguration.setOp_policy_uri(null);
        openidConfiguration.setOp_tos_uri(null);
        return openidConfiguration;
    }

    public Object getPublicKeys() throws FrameworkException {
        return this.cache.get((Serializable)((Object)"JWKS"), () -> {
            QOidcKeys qOidcKeys = QOidcKeys.oidcKeys;
            List list = ((DBQuery)this.from(new EntityPath[]{qOidcKeys}).orderBy(qOidcKeys.date.desc())).stream((Expression)qOidcKeys.jwk).map(string -> this.applicationHandler.decrypt(string, null)).map(string -> {
                try {
                    return JWK.parse((String)string);
                }
                catch (ParseException parseException) {
                    throw new IllegalStateException(parseException);
                }
            }).collect(Collectors.toList());
            return new JWKSet(list).toPublicJWKSet();
        });
    }

    @PostConstruct
    public void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.PUBLIC_JWKS);
    }

    public long purgeAuthorizations() {
        Date date = DateHelper.subtract((Date)new Date(), (TimeField)TimeField.HOURS, (int)1);
        return this.rawEntityManagerHandler.delete((EntityPath)$a).where(new Predicate[]{OidcServiceImpl.$a.creationDate.before((Comparable)date), OidcServiceImpl.$a.refreshToken.isNull(), OidcServiceImpl.$a.accessTokens.isEmpty()}).execute();
    }

    public long purgeExpiredTokens() {
        return this.rawEntityManagerHandler.delete((EntityPath)$at).where(new Predicate[]{OidcServiceImpl.$at.expirationDate.past()}).execute();
    }

    public RegisterResponse register(RegisterRequest registerRequest) throws FrameworkException, OidcRegisterException {
        DynamicOidcClient dynamicOidcClient = this.oidcClientService.registerDynamic(registerRequest);
        RegisterResponse registerResponse = new RegisterResponse();
        registerResponse.setClientId(dynamicOidcClient.getClientId());
        registerResponse.setClientSecret(dynamicOidcClient.getSecret());
        registerResponse.setClientIdIssuedAt(Integer.valueOf((int)(dynamicOidcClient.getCreationDate().getTime() / 1000L)));
        registerResponse.setClientSecretExpiresAt(Integer.valueOf(0));
        return registerResponse;
    }

    public void revoke(RevokeRequest revokeRequest) {
        OidcAuthorization oidcAuthorization;
        ErrorBuilder errorBuilder = new ErrorBuilder();
        errorBuilder.required("token", revokeRequest.getToken());
        BaseOidcClient baseOidcClient = this.validateAndGetClient((ClientRequest)revokeRequest);
        String string = revokeRequest.getToken();
        if (string.contains(".")) {
            this.rawEntityManagerHandler.delete((EntityPath)$at).where(new Predicate[]{OidcServiceImpl.$at.accessToken.eq((Object)string), $at.authorization().client().eq((Object)baseOidcClient)}).execute();
        } else if (string.contains("-") && (oidcAuthorization = this.getAuthByRefreshToken(string)) != null && oidcAuthorization.getClient().equals((Object)baseOidcClient)) {
            this.rawEntityManagerHandler.delete((EntityPath)$at).where(new Predicate[]{$at.authorization().eq((Object)oidcAuthorization)}).execute();
            this.rawEntityManagerHandler.remove((IEntity)oidcAuthorization);
        }
    }

    public TokenResponse token(TokenRequest tokenRequest) throws FrameworkException, OidcException {
        OidcAuthorization oidcAuthorization;
        ErrorBuilder errorBuilder = new ErrorBuilder();
        errorBuilder.required("grant_type", tokenRequest.getGrantType());
        boolean bl = "authorization_code".equals(tokenRequest.getGrantType());
        boolean bl2 = "refresh_token".equals(tokenRequest.getGrantType());
        errorBuilder.invalidIf("Invalid grant_type ", () -> !bl && !bl2);
        BaseOidcClient baseOidcClient = this.validateAndGetClient((ClientRequest)tokenRequest);
        String string = null;
        if (bl) {
            errorBuilder.required("code", tokenRequest.getCode());
            errorBuilder.required("redirect_uri", tokenRequest.getRedirectUri());
            oidcAuthorization = this.getAuthByCode(tokenRequest.getCode());
            errorBuilder.raiseIf("invalid_grant", "Invalid authorization code", () -> oidcAuthorization == null || !oidcAuthorization.getClient().equals((Object)baseOidcClient));
            errorBuilder.raiseIf("invalid_grant", "This authorization code has already been used", () -> oidcAuthorization.getStatus() != AuthorizationStatus.CODE);
            errorBuilder.raiseIf("invalid_grant", "This authorization code has already expired", () -> oidcAuthorization.isAuthorizationCodeExpired());
            errorBuilder.raiseIf("invalid_grant", "Invalid redirect_uri", () -> !oidcAuthorization.getRedirectUrl().equals(tokenRequest.getRedirectUri()));
            oidcAuthorization.setTokenRequestDate(new Date());
            if (oidcAuthorization.isOfflineAccess()) {
                string = UUID.randomUUID().toString();
                oidcAuthorization.setRefreshToken(string);
            }
        } else {
            errorBuilder.required("refresh_token", tokenRequest.getRefreshToken());
            oidcAuthorization = this.getAuthByRefreshToken(tokenRequest.getRefreshToken());
            errorBuilder.raiseIf("invalid_grant", "Invalid refresh token", () -> oidcAuthorization == null || !oidcAuthorization.getClient().equals((Object)baseOidcClient));
        }
        OidcAccessToken oidcAccessToken = this.createAccessToken(oidcAuthorization, oidcAuthorization.isOpenid());
        TokenResponse tokenResponse = new TokenResponse();
        tokenResponse.setAccessToken(oidcAccessToken.getTokenValue());
        tokenResponse.setIdToken(oidcAccessToken.getIdToken());
        tokenResponse.setExpiresIn(Integer.valueOf((int)(oidcAccessToken.getExpirationDate().getTime() - System.currentTimeMillis()) / 1000));
        tokenResponse.setState(oidcAuthorization.getState());
        tokenResponse.setTokenType("Bearer");
        tokenResponse.setRefreshToken(string);
        return tokenResponse;
    }

    public Map<String, Object> userInfo() throws FrameworkException {
        OidcAccessToken oidcAccessToken = this.getSessionData().getAccessToken();
        OidcAuthorization oidcAuthorization = oidcAccessToken.getAuthorization();
        if (oidcAccessToken == null || !oidcAuthorization.getScopes().contains(Scope.OPENID)) {
            throw new IllegalActionException();
        }
        JWTClaimsSet.Builder builder = this.getClaims(oidcAuthorization.getBasicUser(), false, oidcAuthorization.getScopes());
        return builder.build().getClaims();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void appendAddressClaims(boolean bl, BasicUser basicUser, List<ProfileField> list, ConfigurationAccessor configurationAccessor, JWTClaimsSet.Builder builder) {
        UserAddress userAddress;
        if (bl || !list.contains(BasicProfileField.ADDRESS)) {
            return;
        }
        UserAddress userAddress2 = userAddress = basicUser instanceof User ? ((User)basicUser).getDefaultAddress() : null;
        if (userAddress != null) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            String string = this.getFormatter(basicUser).format((Address)userAddress);
            linkedHashMap.put("formatted", string);
            linkedHashMap.put("street_address", string);
            if (StringHelper.isNotBlank((Object)userAddress.getCity())) {
                linkedHashMap.put("locality", userAddress.getCity());
            }
            if (StringHelper.isNotBlank((Object)userAddress.getRegion())) {
                linkedHashMap.put("region", userAddress.getRegion());
            }
            if (StringHelper.isNotBlank((Object)userAddress.getZip())) {
                linkedHashMap.put("postal_code", userAddress.getZip());
            }
            if (StringHelper.isNotBlank((Object)userAddress.getCountry())) {
                linkedHashMap.put("country", this.localizationService.getCountryName(userAddress.getCountry()));
            }
            builder.claim("address", linkedHashMap);
        }
    }

    private void appendEmailClaims(boolean bl, BasicUser basicUser, List<ProfileField> list, ConfigurationAccessor configurationAccessor, JWTClaimsSet.Builder builder) {
        if (!list.contains(BasicProfileField.EMAIL)) {
            return;
        }
        if (basicUser.getEmail() != null) {
            builder.claim("email", (Object)basicUser.getEmail());
            if (!bl) {
                builder.claim("email_verified", (Object)basicUser.isEmailVerified());
            }
        }
    }

    private void appendPhoneClaims(boolean bl, BasicUser basicUser, List<ProfileField> list, ConfigurationAccessor configurationAccessor, JWTClaimsSet.Builder builder) {
        if (!list.contains(BasicProfileField.PHONE)) {
            return;
        }
        Phone phone = basicUser.getPreferredPhone();
        if (phone != null) {
            Object object = phone.getNormalizedNumber();
            boolean bl2 = false;
            if (phone instanceof LandLinePhone) {
                String string = ((LandLinePhone)phone).getExtension();
                if (StringHelper.isNotBlank((Object)string)) {
                    object = (String)object + ";ext=" + string;
                }
            } else if (phone instanceof MobilePhone) {
                bl2 = ((MobilePhone)phone).isVerified();
            }
            builder.claim("phone_number", object);
            if (!bl) {
                builder.claim("phone_number_verified", (Object)bl2);
            }
        }
    }

    private void appendProfileClaims(boolean bl, BasicUser basicUser, List<ProfileField> list, ConfigurationAccessor configurationAccessor, JWTClaimsSet.Builder builder) {
        String string;
        String string2 = list.contains(BasicProfileField.FULL_NAME) ? basicUser.getName() : this.getFormatter().format(basicUser);
        builder.claim("name", (Object)string2);
        UserPrincipal userPrincipal = this.profileFieldHandler.getPrincipal(basicUser, (ChannelAccessAccessor)configurationAccessor.getChannelConfiguration(this.channelService.getMain()));
        if (userPrincipal != null && (string = userPrincipal.getPrincipal()) != null) {
            builder.claim("preferred_username", (Object)string);
        }
        string = null;
        if (basicUser instanceof User) {
            string = ((User)basicUser).getImage();
        }
        if (string != null && list.contains(BasicProfileField.IMAGE)) {
            builder.claim("picture", (Object)(configurationAccessor.getApiUrl() + "/images/content/" + ImageVOConverter.getKey((Image)string)));
        }
        if (bl) {
            return;
        }
        builder.claim("locale", (Object)(configurationAccessor.getLanguage().getTemplate().getIsoLanguage() + "-" + configurationAccessor.getCountry()));
        builder.claim("zoneinfo", (Object)configurationAccessor.getTimeZoneId());
        for (UserCustomField userCustomField : this.profileFieldHandler.getCustomFields(list)) {
            UserCustomFieldValue userCustomFieldValue;
            Object object;
            String string3 = userCustomField.getOidcClaim();
            if (string3 == null || (object = this.claimValue(configurationAccessor, userCustomFieldValue = (UserCustomFieldValue)this.profileFieldHandler.getFieldValue(basicUser, (ProfileField)userCustomField))) == null) continue;
            builder.claim(string3, object);
        }
    }

    private Object claimValue(ConfigurationAccessor configurationAccessor, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setTimeZone(configurationAccessor.getTimeZone());
            return simpleDateFormat.format((Date)object2);
        }
        if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object2;
            return bigDecimal.toPlainString();
        }
        if (object2 instanceof Long) {
            Long l = (Long)object2;
            return this.applicationHandler.getIdMask().apply(l).toString();
        }
        if (object2 instanceof Boolean || object2 instanceof Integer) {
            return object2;
        }
        if (object2 instanceof UserCustomFieldPossibleValue) {
            UserCustomFieldPossibleValue userCustomFieldPossibleValue = (UserCustomFieldPossibleValue)object2;
            if (userCustomFieldPossibleValue.getInternalName() != null) {
                return userCustomFieldPossibleValue.getInternalName();
            }
            return this.getTranslatedValue((BaseEntity)userCustomFieldPossibleValue, QUserCustomFieldPossibleValue.userCustomFieldPossibleValue.value);
        }
        if (object2 instanceof UserCustomFieldValue) {
            UserCustomFieldValue userCustomFieldValue = (UserCustomFieldValue)object2;
            Object object3 = this.customFieldValueHandler.getValue((CustomField)userCustomFieldValue.getField(), (Object)userCustomFieldValue, false);
            if (object3 instanceof Collection) {
                return ((Collection)object3).stream().map(object -> this.claimValue(configurationAccessor, object)).sorted().collect(Collectors.toList());
            }
            return this.claimValue(configurationAccessor, object3);
        }
        if (object2 instanceof DynamicFieldValueVO) {
            return ((DynamicFieldValueVO)object2).getValue();
        }
        if (object2 instanceof SimpleEntity) {
            IInternalNamedEntity iInternalNamedEntity;
            String string;
            SimpleEntity simpleEntity = (SimpleEntity)object2;
            if (simpleEntity instanceof IInternalNamedEntity && (string = (iInternalNamedEntity = (IInternalNamedEntity)simpleEntity).getInternalName()) != null) {
                return string;
            }
            return this.claimValue(configurationAccessor, simpleEntity.getId());
        }
        return this.getFormatter(configurationAccessor).format(object2);
    }

    private OidcAccessToken createAccessToken(OidcAuthorization oidcAuthorization, boolean bl) {
        BasicUser basicUser = oidcAuthorization.getBasicUser();
        if (basicUser == null || oidcAuthorization.getConsentDate() == null) {
            return null;
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getDefaultAccessor();
        OidcClientAccessor oidcClientAccessor = this.oidcClientService.getAccessor(oidcAuthorization.getClient());
        OidcAccessToken oidcAccessToken = new OidcAccessToken();
        oidcAccessToken.setAuthorization(oidcAuthorization);
        oidcAccessToken.setCreationDate(new Date());
        Date date = oidcAuthorization.getExpirationDate();
        if (date == null) {
            date = DateHelper.add((Date)new Date(), (ITimeInterval)oidcClientAccessor.getAccessTokenExpiration());
        }
        oidcAccessToken.setExpirationDate(date);
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().jwtID(UUID.randomUUID().toString()).claim("active", (Object)true).claim("scope", (Object)oidcAuthorization.getScope()).issuer(configurationAccessor.getFullUrl()).audience(oidcAuthorization.getClient().getInternalName()).claim("azp", (Object)oidcAuthorization.getClient().getInternalName()).issueTime(oidcAccessToken.getCreationDate()).claim("auth_time", (Object)oidcAuthorization.getConsentDate()).expirationTime(oidcAccessToken.getExpirationDate()).subject(this.applicationHandler.getIdMask().apply(basicUser.getId()).toString()).claim("nonce", (Object)oidcAuthorization.getNonce()).claim("token_type", (Object)"Bearer");
        oidcAccessToken.setTokenValue(this.signJWT(builder));
        if (bl) {
            oidcAccessToken.setIdToken(this.createIdToken(oidcAuthorization, oidcAccessToken));
        }
        this.persist((IEntity)oidcAccessToken);
        return oidcAccessToken;
    }

    private Pair<OidcKeys, RSAKey> createAndPersistKey(Date date) {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        String string = "rsa." + date.getTime();
        RSAKey rSAKey = new RSAKey.Builder(rSAPublicKey).privateKey(rSAPrivateKey).keyID(string).build();
        OidcKeys oidcKeys = new OidcKeys();
        oidcKeys.setDate(date);
        oidcKeys.setKid(string);
        oidcKeys.setJwk(this.applicationHandler.encryptAsString(rSAKey.toJSONString(), null));
        this.rawEntityManagerHandler.persist((IEntity)oidcKeys);
        return Pair.create((Object)oidcKeys, (Object)rSAKey);
    }

    private String createIdToken(OidcAuthorization oidcAuthorization, OidcAccessToken oidcAccessToken) {
        BasicUser basicUser = oidcAuthorization.getBasicUser();
        if (basicUser == null || oidcAuthorization.getConsentDate() == null) {
            return null;
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getDefaultAccessor();
        OidcClientAccessor oidcClientAccessor = this.oidcClientService.getAccessor(oidcAuthorization.getClient());
        Date date = oidcAccessToken == null ? (Date)ObjectHelper.defaultValue((Object)oidcAuthorization.getTokenRequestDate(), (Object)oidcAuthorization.getConsentDate()) : oidcAccessToken.getCreationDate();
        Date date2 = oidcAccessToken == null ? DateHelper.add((Date)date, (ITimeInterval)oidcClientAccessor.getAccessTokenExpiration()) : oidcAccessToken.getExpirationDate();
        JWTClaimsSet.Builder builder = this.getClaims(basicUser, true, oidcAuthorization.getScopes()).jwtID(UUID.randomUUID().toString()).issuer(configurationAccessor.getFullUrl()).audience(oidcAuthorization.getClient().getInternalName()).claim("azp", (Object)oidcAuthorization.getClient().getInternalName()).claim("auth_time", (Object)oidcAuthorization.getConsentDate()).claim("nonce", (Object)oidcAuthorization.getNonce()).issueTime(date).expirationTime(date2);
        return this.signJWT(builder);
    }

    private RSAKey decryptKey(String string) {
        String string2 = this.applicationHandler.decrypt(string, null);
        try {
            return (RSAKey)JWK.parse((String)string2);
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("Error parsing JWK from the stored JSON", parseException);
        }
    }

    private OidcAuthorization getAuthByCode(String string) {
        if (string == null) {
            return null;
        }
        return (OidcAuthorization)((DBQuery)this.from(new EntityPath[]{$a}).where((Predicate)OidcServiceImpl.$a.authorizationCode.eq((Object)string))).singleResult((Expression)$a);
    }

    private OidcAuthorization getAuthByRefreshToken(String string) {
        if (string == null) {
            return null;
        }
        return (OidcAuthorization)((DBQuery)this.from(new EntityPath[]{$a}).where((Predicate)OidcServiceImpl.$a.refreshToken.eq((Object)string))).singleResult((Expression)$a);
    }

    private JWTClaimsSet.Builder getClaims(BasicUser basicUser, boolean bl, Set<Scope> set) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().subject(this.applicationHandler.getIdMask().apply(basicUser.getId()).toString());
        List list = this.profileFieldHandler.getEnabledProfileFields(basicUser);
        if (set.contains(Scope.PROFILE)) {
            this.appendProfileClaims(bl, basicUser, list, configurationAccessor, builder);
        }
        if (set.contains(Scope.EMAIL)) {
            this.appendEmailClaims(bl, basicUser, list, configurationAccessor, builder);
        }
        if (set.contains(Scope.PHONE)) {
            this.appendPhoneClaims(bl, basicUser, list, configurationAccessor, builder);
        }
        if (set.contains(Scope.ADDRESS)) {
            this.appendAddressClaims(bl, basicUser, list, configurationAccessor, builder);
        }
        return builder;
    }

    private RSAKey getJWK() {
        Date date = new Date();
        Date date2 = DateHelper.subtract((Date)date, (TimeField)TimeField.DAYS, (int)10);
        Supplier<String> supplier = () -> (String)((DBQuery)this.from(new EntityPath[]{$k}).where((Predicate)OidcServiceImpl.$k.date.goe((Comparable)date2))).select((Expression)OidcServiceImpl.$k.jwk).fetchFirst();
        String string = supplier.get();
        if (string == null) {
            string = (String)this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                this.lockHandler.lock(LockType.OIDC_KEYS.nullKey());
                String string = (String)supplier.get();
                if (string != null) {
                    return string;
                }
                string = ((OidcKeys)this.createAndPersistKey(date).getFirst()).getJwk();
                Date date2 = DateHelper.subtract((Date)date, (TimeField)TimeField.DAYS, (int)20);
                this.rawEntityManagerHandler.delete((EntityPath)$k).where(new Predicate[]{OidcServiceImpl.$k.date.lt((Comparable)date2)}).execute();
                this.cacheHandler.scheduleClear(CacheType.PUBLIC_JWKS);
                return string;
            });
        }
        return this.decryptKey(string);
    }

    private OidcAuthorization locateForConsent(String string) {
        if (string == null) {
            throw new EntityNotFoundException(OidcAuthorization.class);
        }
        return (OidcAuthorization)((DBQuery)this.from(new EntityPath[]{$a}).where(new Predicate[]{OidcServiceImpl.$a.locator.eq((Object)string), OidcServiceImpl.$a.consentDate.isNull()})).requiredUniqueResult((Expression)$a);
    }

    private UserAccountType parseAccountParams(ErrorBuilder errorBuilder, OidcClientAccessor oidcClientAccessor, Map<Scope, Map<String, String>> map) {
        Map map2 = CollectionHelper.orEmpty(map.get(Scope.ACCOUNT_STATUS));
        Map map3 = CollectionHelper.orEmpty(map.get(Scope.ACCOUNT_HISTORY));
        errorBuilder.raiseIf("invalid_scope", "Cannot request both account_status and account_history scopes with different 'type' parameter", () -> map2 != null && map2 != null && !Objects.equals(map2.get("type"), map3.get("type")));
        Set set = oidcClientAccessor.getAccounts();
        String string = StringHelper.trimToNull(((Map)ObjectHelper.coalesce((Object[])new Map[]{map2, map3, Collections.emptyMap()})).get("type"));
        if (string == null) {
            if (set.size() == 1) {
                return (UserAccountType)CollectionHelper.first((Iterable)set);
            }
            return null;
        }
        AccountTypeVO accountTypeVO = (AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)string);
        this.inputOutputProcessingHandler.processFromClient((Object)accountTypeVO, false);
        return set.stream().filter(arg_0 -> ((AccountTypeVO)accountTypeVO).matches(arg_0)).findFirst().orElseGet(() -> {
            errorBuilder.raise("invalid_scope", "The requested account type cannot be used " + string);
            return null;
        });
    }

    private PaymentParameters parsePaymentParams(ErrorBuilder errorBuilder, OidcClientAccessor oidcClientAccessor, Map<Scope, Map<String, String>> map) {
        PaymentParameters paymentParameters = new PaymentParameters();
        if (!map.containsKey(Scope.PAYMENT)) {
            return paymentParameters;
        }
        Map map2 = CollectionHelper.orEmpty(map.get(Scope.PAYMENT));
        String string = (String)map2.get("to");
        String string2 = (String)map2.get("amount");
        String string3 = (String)map2.get("currency");
        if (string != null || string2 != null) {
            errorBuilder.raiseIf("invalid_scope", "Either both or none of payment to and amount must be informed", () -> string == null || string2 == null);
            SessionData sessionData = SessionDataFactory.system();
            paymentParameters.to = string == null ? null : ((LocateUserResult)this.invokerHandler.runAs(sessionData, () -> {
                Set set = sessionData.getChannelAccessAccessor().getPrincipalTypes();
                UserLocatorVO userLocatorVO = new UserLocatorVO((Property)UserLocatorVO.PRINCIPAL, (Object)string);
                try {
                    return this.userLocatorHandler.locate(userLocatorVO, Collections.emptySet(), (Collection)set, null);
                }
                catch (Exception exception) {
                    errorBuilder.raise("invalid_scope", "Invalid payment destination");
                    throw exception;
                }
            })).getUser();
            Set set = oidcClientAccessor.getPayments().stream().map(TransferType::getCurrency).collect(Collectors.toSet());
            if (string3 != null) {
                CurrencyVO currencyVO = (CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)string3);
                this.inputOutputProcessingHandler.processFromClient((Object)currencyVO, false);
                paymentParameters.currency = set.stream().filter(arg_0 -> ((CurrencyVO)currencyVO).matches(arg_0)).findFirst().orElseGet(() -> {
                    errorBuilder.raise("invalid_scope", "The requested currency be used: " + string3);
                    return null;
                });
            } else {
                errorBuilder.raiseIf("invalid_scope", "Missing the currency parameter for the payment scope", () -> set.size() > 1);
                paymentParameters.currency = (Currency)CollectionHelper.first(set);
            }
            if (paymentParameters.to != null) {
                errorBuilder.raiseIf("invalid_scope", "The given payment to (" + string + ") cannot receive payments in the given currency (" + paymentParameters.currency.getName() + ")", () -> !this.productsHandler.getAccessor((BasicUser)paymentParameters.to).grantedAccountTypes().stream().anyMatch(accountType -> accountType.getCurrency().equals((Object)paymentParameters.currency)));
            }
            try {
                paymentParameters.amount = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)string2);
                if (paymentParameters.amount == null || BigDecimalHelper.isNegativeOrZero((BigDecimal)paymentParameters.amount)) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                errorBuilder.raise("invalid_scope", "Invalid payment amount");
            }
        } else {
            errorBuilder.raiseIf("invalid_scope", "The payment to and amount parameters are required", () -> oidcClientAccessor.isSinglePaymentPerConsent());
        }
        return paymentParameters;
    }

    private String signJWT(JWTClaimsSet.Builder builder) {
        RSAKey rSAKey = this.getJWK();
        JWSHeader.Builder builder2 = new JWSHeader.Builder(SIGNING_ALG).keyID(rSAKey.getKeyID());
        SignedJWT signedJWT = new SignedJWT(builder2.build(), builder.build());
        try {
            signedJWT.sign((JWSSigner)new RSASSASigner(rSAKey));
        }
        catch (JOSEException jOSEException) {
            throw new IllegalStateException(jOSEException);
        }
        return signedJWT.serialize();
    }

    private BaseOidcClient validateAndGetClient(ClientRequest clientRequest) throws OidcException {
        ErrorBuilder errorBuilder = new ErrorBuilder();
        errorBuilder.required("client_id", clientRequest.getClientId());
        errorBuilder.required("client_secret", clientRequest.getClientSecret());
        String string = clientRequest.getClientId();
        BaseOidcClient baseOidcClient = string == null ? null : this.oidcClientService.getByClientId(string);
        errorBuilder.raiseIf("invalid_client", "The given client is invalid", () -> baseOidcClient == null || !baseOidcClient.isEnabled());
        errorBuilder.raiseIf("invalid_grant", "invalid client_secret", () -> !clientRequest.getClientSecret().equals(baseOidcClient.getSecret()));
        return baseOidcClient;
    }

    private static /* synthetic */ boolean lambda$authorize$14(boolean bl, List list) {
        return bl && list.size() > 1;
    }

    private static /* synthetic */ boolean lambda$authorize$7(EnumSet enumSet) {
        return !enumSet.isEmpty();
    }

    private static /* synthetic */ boolean lambda$approve$1(Currency currency, PaymentTransferType paymentTransferType) {
        return currency.equals((Object)paymentTransferType.getCurrency());
    }

    private static class ErrorBuilder {
        private String state;
        private String redirectUri;
        private ResponseMode responseMode;

        public ErrorBuilder() {
        }

        public ErrorBuilder(String string) {
            this.state = string;
        }

        private void invalid(String string) {
            this.raise("invalid_request", string);
        }

        private void invalidIf(String string, BooleanSupplier booleanSupplier) {
            if (booleanSupplier.getAsBoolean()) {
                this.invalid(string);
            }
        }

        private void raise(String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (StringHelper.isNotBlank((Object)this.state)) {
                hashMap.put("state", this.state);
            }
            hashMap.put("error", string);
            if (StringHelper.isNotBlank((Object)string2)) {
                hashMap.put("error_description", string2);
            }
            AuthorizeResponse authorizeResponse = new AuthorizeResponse(this.redirectUri, this.responseMode, hashMap);
            throw new OidcException(authorizeResponse);
        }

        private void raiseIf(String string, String string2, BooleanSupplier booleanSupplier) {
            if (booleanSupplier.getAsBoolean()) {
                this.raise(string, string2);
            }
        }

        private void required(String string, String string2) {
            this.raiseIf("invalid_request", "Missing required parameter: " + string, () -> StringHelper.isBlank((Object)string2));
        }
    }

    private static class PaymentParameters {
        private User to;
        private BigDecimal amount;
        private Currency currency;

        private PaymentParameters() {
        }
    }
}

