/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.io.File;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.RegistrationWizard;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.IdentityProviderContext;
import org.cyclos.impl.access.IdentityProviderServiceLocal;
import org.cyclos.impl.access.InternalAuthServiceLocal;
import org.cyclos.impl.access.InternalIdentityProviderServiceLocal;
import org.cyclos.impl.access.PerformLoginResult;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.UserIdentityProviderServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomWizardExecutionStorage;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.TempImageServiceLocal;
import org.cyclos.impl.users.IdentityProviderProfile;
import org.cyclos.impl.users.LocateUserOption;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.SimplePropertyAccess;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackStatus;
import org.cyclos.model.access.identityproviders.IdentityProviderNotLinkReason;
import org.cyclos.model.access.identityproviders.IdentityProviderRequestType;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderStatus;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.channelconfigurations.RegistrationWithIdentityProviders;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.NewTempImageParams;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.InitialGroupVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.LocateUserException;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.PublicRegistrationData;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.server.model.access.identityproviders.IdentityProviderRequest;
import org.cyclos.server.model.access.identityproviders.IdentityProviderRequestResult;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.access.CallbackResult;
import org.cyclos.services.access.LoginDTO;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.PublicRegistrationHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.oauth.profile.facebook.FacebookProfile;
import org.pac4j.oidc.profile.OidcProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class InternalIdentityProviderServiceImpl
extends BaseServiceImpl
implements InternalIdentityProviderServiceLocal {
    private static final EnumSet<LocateUserOption> LOCATE_OPTIONS = EnumSet.of(LocateUserOption.ACTIVE_ONLY, LocateUserOption.IGNORE_HIDDEN, LocateUserOption.STATUS_EXCEPTION);
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    @Lazy
    private IdentityProviderServiceLocal identityProviderService;
    @Autowired
    private UserIdentityProviderServiceLocal userIdentityProviderService;
    @Autowired
    private ClusterHandler clusterHandler;
    @Autowired
    private TempImageServiceLocal tempImageService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private PushNotificationHandler pushNotificationHandler;
    private SharedStorage<String, HashMap<String, Object>> requests;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private InternalAuthServiceLocal internalAuthService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public CallbackResult callback(String string) throws FrameworkException {
        IdentityProviderContext identityProviderContext = this.context(string);
        if (!identityProviderContext.valid()) {
            return identityProviderContext.destroyRequest().error(AccessKeys.IdentityProviders.ERROR_INVALID_STATE, new Object[0]);
        }
        RequestData requestData = identityProviderContext.getRequestData();
        RequestInfo requestInfo = this.getSessionData().getRequestData().getRequestInfo();
        SessionData sessionData = identityProviderContext.getSession() == null ? SessionDataFactory.guest((RequestData)requestData, (String)identityProviderContext.getChannel().getInternalName()) : SessionDataFactory.stateful((Session)identityProviderContext.getSession(), (RequestData)requestData);
        return (CallbackResult)this.invokerHandler.runAs(sessionData, () -> {
            SessionStore sessionStore;
            ResponseInfo responseInfo;
            WebContext webContext;
            IndirectClient indirectClient = identityProviderContext.client(requestInfo);
            Credentials credentials = indirectClient.getCredentials(webContext = identityProviderContext.getWebContext(requestData, requestInfo, responseInfo = new ResponseInfo()), sessionStore = identityProviderContext.getSessionStore()).orElse(null);
            if (credentials == null) {
                return identityProviderContext.destroyRequest().result(IdentityProviderCallbackStatus.DENIED);
            }
            CommonProfile commonProfile = null;
            int n = 0;
            while (n < 5 && commonProfile == null) {
                try {
                    commonProfile = (CommonProfile)indirectClient.getUserProfile(credentials, webContext, sessionStore).get();
                }
                catch (TechnicalException technicalException) {
                    if (ExceptionHelper.findCause((Throwable)technicalException, SocketTimeoutException.class) != null) {
                        ++n;
                        continue;
                    }
                    throw technicalException;
                }
            }
            CallbackResult callbackResult = null;
            switch (identityProviderContext.getType()) {
                case LOGIN: {
                    callbackResult = this.handleLogin(identityProviderContext, commonProfile);
                    break;
                }
                case LINK: {
                    callbackResult = this.handleLink(identityProviderContext, commonProfile);
                    break;
                }
                case REGISTER: {
                    callbackResult = this.handleRegister(identityProviderContext, commonProfile);
                    break;
                }
                case WIZARD: {
                    callbackResult = this.handleWizard(identityProviderContext, commonProfile);
                }
            }
            if (callbackResult == null) {
                throw new IllegalStateException("Unhandled request type: " + String.valueOf(identityProviderContext.getType()));
            }
            IdentityProviderCallbackResult identityProviderCallbackResult = callbackResult.getResult();
            Long l = SimpleEntity.id((SimpleEntity)this.getLoggedBasicUser());
            this.pushNotificationHandler.publish(PushNotificationEventContext.identityProviderCallback((Long)l, (String)string), (Object)identityProviderCallbackResult);
            return callbackResult;
        });
    }

    public void checkExists(String string) throws EntityNotFoundException {
        if (this.requests.get((Object)string) == null) {
            throw new EntityNotFoundException(IdentityProviderRequest.class, string);
        }
    }

    public void finishRegistration(User user, PublicRegistrationDTO publicRegistrationDTO) {
        IdentityProviderProfile identityProviderProfile;
        IdentityProvider identityProvider;
        IdentityProviderContext identityProviderContext;
        CommonProfile commonProfile = this.getRegistrationProfile(publicRegistrationDTO);
        boolean bl = commonProfile != null;
        CustomWizardExecutionStorage customWizardExecutionStorage = this.customWizardService.getStorage(publicRegistrationDTO);
        boolean bl2 = false;
        if (!bl && customWizardExecutionStorage != null) {
            boolean bl3 = bl2 = customWizardExecutionStorage.getIdentityProviderId() != null;
        }
        if (!bl && !bl2) {
            return;
        }
        if (bl) {
            identityProviderContext = this.context(publicRegistrationDTO.getIdentityProviderRequestId());
            if (!identityProviderContext.valid() || !user.getGroup().equals((Object)identityProviderContext.getGroup())) {
                throw new ValidationException(this.message(AccessKeys.IdentityProviders.ERROR_INVALID_STATE, new Object[0]));
            }
            identityProvider = identityProviderContext.getIdentityProvider();
            identityProviderProfile = IdentityProviderProfile.fromPac4j((CommonProfile)commonProfile);
            InvocationContext.ensure().addCommitListener(false, identityProviderContext::destroyRequest);
        } else {
            identityProvider = this.find(IdentityProvider.class, customWizardExecutionStorage.getIdentityProviderId());
            identityProviderProfile = customWizardExecutionStorage.getIdentityProviderProfile();
        }
        identityProviderContext = this.profileFieldHandler.getPrincipal((BasicUser)user, this.getSessionData().getChannelAccessAccessor());
        if (identityProviderContext == null) {
            throw new ValidationException("No valid access principal for the registered user");
        }
        this.userIdentityProviderService.link(identityProvider, (UserPrincipal)identityProviderContext, identityProviderProfile, true);
    }

    public CommonProfile getRegistrationProfile(PublicRegistrationDTO publicRegistrationDTO) {
        String string;
        CommonProfile commonProfile = InternalIdentityProviderServiceLocal.getProfile((SimpleBasicUserRegistrationDTO)publicRegistrationDTO);
        if (commonProfile == null && (string = publicRegistrationDTO.getIdentityProviderRequestId()) != null) {
            UserGroup userGroup;
            UserGroup userGroup2 = (UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)publicRegistrationDTO.getGroup());
            HashMap hashMap = (HashMap)this.requests.get((Object)string);
            IdentityProviderRequest identityProviderRequest = hashMap == null ? null : (IdentityProviderRequest)hashMap.get("request");
            UserGroup userGroup3 = userGroup = identityProviderRequest == null ? null : (UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)identityProviderRequest.getGroup());
            if (userGroup2.equals(userGroup)) {
                commonProfile = (CommonProfile)hashMap.get("profile");
            }
        }
        return commonProfile;
    }

    @PostConstruct
    public void initialize() {
        this.requests = this.clusterHandler.getSharedStorage(SharedStorageType.IDP_REQUESTS);
    }

    public IdentityProviderNotLinkReason linkAfterLogin(Session session, String string) {
        IdentityProviderContext identityProviderContext = this.context(string);
        IdentityProvider identityProvider = identityProviderContext.getIdentityProvider();
        CommonProfile commonProfile = identityProviderContext.getProfile();
        if (!identityProviderContext.valid() || commonProfile == null) {
            identityProviderContext.destroyRequest();
            throw new ValidationException(this.message(AccessKeys.IdentityProviders.ERROR_INVALID_STATE, new Object[0]));
        }
        identityProviderContext.destroyRequest();
        if (session.getUser().isGlobal() && !identityProvider.isGlobal()) {
            return IdentityProviderNotLinkReason.GLOBAL_USER_NETWORK_IDP_IGNORED;
        }
        if (session.getTrustedDevice() != null) {
            return IdentityProviderNotLinkReason.UNSUPPORTED_PRINCIPAL_TYPE;
        }
        UserIdentityProvider userIdentityProvider = this.userIdentityProviderService.get(session.getBasicUser(), identityProvider);
        if (userIdentityProvider != null && userIdentityProvider.getStatus() == UserIdentityProviderStatus.DISABLED) {
            return IdentityProviderNotLinkReason.USER_DISABLED;
        }
        InvocationContext.get().addCommitListener(true, () -> {
            try {
                Session session2 = this.find(Session.class, session.getId());
                IdentityProvider identityProvider2 = this.find(IdentityProvider.class, identityProvider.getId());
                this.userIdentityProviderService.link(identityProvider2, (UserPrincipal)session2, IdentityProviderProfile.fromPac4j((CommonProfile)commonProfile), false);
            }
            catch (Exception exception) {
                this.getLogger().warn("Error linking user to identity provider", (Throwable)exception);
            }
        });
        return null;
    }

    public String redirect(String string) {
        IdentityProviderContext identityProviderContext = this.context(string);
        if (!identityProviderContext.valid()) {
            throw new IllegalActionException();
        }
        RequestInfo requestInfo = this.getSessionData().getRequestData().getRequestInfo();
        WebContext webContext = identityProviderContext.getWebContext(identityProviderContext.getRequestData(), requestInfo, new ResponseInfo());
        SessionStore sessionStore = identityProviderContext.getSessionStore();
        for (int i = 0; i < 5; ++i) {
            try {
                IndirectClient indirectClient = identityProviderContext.client(requestInfo);
                Optional optional = indirectClient.getRedirectionAction(webContext, sessionStore);
                RedirectionAction redirectionAction = (RedirectionAction)optional.orElseThrow(() -> new IllegalStateException("No redirect!"));
                if (redirectionAction instanceof WithLocationAction) {
                    return ((WithLocationAction)redirectionAction).getLocation();
                }
                throw new IllegalStateException("Unrecognized action: " + String.valueOf(redirectionAction));
            }
            catch (TechnicalException technicalException) {
                if (ExceptionHelper.findCause((Throwable)technicalException, SocketTimeoutException.class) != null) continue;
                throw technicalException;
            }
        }
        throw new IllegalStateException();
    }

    public IdentityProviderRequestResult request(IdentityProviderRequest identityProviderRequest) {
        this.validate(identityProviderRequest);
        IdentityProvider identityProvider = (IdentityProvider)this.conversionHandler.convert(IdentityProvider.class, (Object)identityProviderRequest.getIdentityProvider());
        SessionData sessionData = this.getSessionData();
        String string = UUID.randomUUID().toString();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request", identityProviderRequest);
        RequestData requestData = sessionData.getRequestData();
        requestData.setRequestInfo(new RequestInfo.RequestInfoBuilder().copy(requestData.getRequestInfo(), true).build());
        hashMap.put("requestData", requestData);
        hashMap.put("channel", sessionData.getChannel().getInternalName());
        if (sessionData.getSession() != null) {
            hashMap.put("sessionToken", sessionData.getSession().getSessionToken());
        }
        this.requests.set((Object)string, hashMap);
        IdentityProviderRequestResult identityProviderRequestResult = new IdentityProviderRequestResult();
        identityProviderRequestResult.setIdentityProvider((IdentityProviderVO)this.conversionHandler.convert(IdentityProviderVO.class, (Object)identityProvider));
        identityProviderRequestResult.setRequestId(string);
        identityProviderRequestResult.setUrl(this.linkGeneratorHandler.identityProviderRedirect(identityProvider, string));
        return identityProviderRequestResult;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private IdentityProviderContext context(String string) {
        return (IdentityProviderContext)this.beanHandler.autowireWithArgs(IdentityProviderContext.class, new Object[]{string});
    }

    private void fillRegistrationData(UserGroup userGroup, CommonProfile commonProfile, IdentityProviderCallbackResult identityProviderCallbackResult) {
        ImageVO imageVO;
        String string;
        Object object;
        Object object22;
        Object object3;
        HashMap<String, Object> hashMap;
        Object object4;
        User user = new User((Group)userGroup);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)userGroup);
        List list = this.profileFieldHandler.getFieldsByAction((BasicUser)user, ProfileFieldAction.EDIT);
        if (list.contains(BasicProfileField.FULL_NAME)) {
            identityProviderCallbackResult.setName(StringHelper.trimToNull((Object)commonProfile.getDisplayName()));
        }
        if (list.contains(BasicProfileField.EMAIL)) {
            identityProviderCallbackResult.setEmail(StringHelper.trimToNull((Object)commonProfile.getEmail()));
        }
        if (list.contains(BasicProfileField.LOGIN_NAME) && !configurationAccessor.isGeneratedUsername()) {
            object4 = StringHelper.trimToNull((Object)commonProfile.getUsername());
            if (object4 == null && identityProviderCallbackResult.getEmail() != null) {
                object4 = identityProviderCallbackResult.getEmail();
            }
            if (object4 != null && ((String)object4).contains("@")) {
                object4 = StringUtils.substringBefore((String)object4, (String)"@");
            }
            identityProviderCallbackResult.setUsername((String)object4);
        }
        if (list.contains(BasicProfileField.IMAGE) && (object4 = StringHelper.trimToNull((Object)commonProfile.getPictureUrl())) != null) {
            try {
                hashMap = new URL((String)object4);
                try {
                    object3 = new SerializableInputStream(((URL)((Object)hashMap)).openStream());
                    try {
                        object22 = object3.forceCopyToFile();
                        object = new NewTempImageParams();
                        object.setGuestKey(commonProfile.getId());
                        object.setTarget(TempImageTarget.USER_REGISTRATION);
                        string = ServerImageHelper.ImageType.getByContent((File)object22);
                        imageVO = this.tempImageService.save(object, "profile", (SerializableInputStream)object3, string.getContentType());
                        identityProviderCallbackResult.setImage(imageVO);
                    }
                    finally {
                        object3.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (commonProfile instanceof OidcProfile && (hashMap = (object4 = (OidcProfile)commonProfile).getPhoneNumber()) != null && (object3 = this.phoneNumberHandler.parse((String)((Object)hashMap), configurationAccessor)) != null) {
            object22 = StringHelper.splitTrimming(hashMap, (String)";ext=");
            object = (String)object22.get(0);
            String string2 = string = object22.size() == 1 ? null : (String)object22.get(1);
            if (object3.isMobile()) {
                identityProviderCallbackResult.setMobilePhone((String)object);
            } else {
                identityProviderCallbackResult.setLandLinePhone((String)object);
                identityProviderCallbackResult.setLandLineExtension(string);
            }
        }
        object4 = new HashMap();
        identityProviderCallbackResult.setCustomValues((Map)object4);
        if (commonProfile instanceof FacebookProfile) {
            hashMap = new HashMap<String, Object>();
            for (Object object22 : this.profileFieldHandler.getCustomFields((Collection)list)) {
                hashMap.put(object22.getInternalName(), object22);
                if (!StringHelper.isNotBlank((Object)object22.getOidcClaim())) continue;
                hashMap.put(object22.getOidcClaim(), object22);
            }
            object3 = (FacebookProfile)commonProfile;
            object22 = object3.getGender();
            if (object22 != null && (object = (UserCustomField)hashMap.get("gender")) != null && object.getType() == CustomFieldType.SINGLE_SELECTION) {
                string = object22.name().toLowerCase();
                imageVO = object.getPossibleValues().stream().filter(userCustomFieldPossibleValue -> string.equals(userCustomFieldPossibleValue.getInternalName())).findFirst().orElse(null);
                if (imageVO != null) {
                    object4.put(object.getInternalName(), imageVO.getInternalName());
                }
            }
            if ((object = object3.getBirthday()) != null && (string = (UserCustomField)ObjectHelper.coalesce((Object[])new UserCustomField[]{(UserCustomField)hashMap.get("birthday"), (UserCustomField)hashMap.get("birthdate"), (UserCustomField)hashMap.get("birthDate")})) != null && string.getType() == CustomFieldType.DATE) {
                imageVO = this.conversionHandler.toDateTime((Date)object);
                object4.put(string.getInternalName(), imageVO.toDateString());
            }
            if ((string = object3.getWebsite()) != null && (imageVO = (UserCustomField)hashMap.get("website")) != null && ObjectHelper.isOneOf((Object)imageVO, (Object[])new Object[]{CustomFieldType.STRING, CustomFieldType.URL})) {
                object4.put(imageVO.getInternalName(), string);
            }
        }
    }

    private CallbackResult handleLink(IdentityProviderContext identityProviderContext, CommonProfile commonProfile) {
        UserIdentityProvider userIdentityProvider;
        Session session = identityProviderContext.getSession();
        if (session == null) {
            return identityProviderContext.destroyRequest().error(AccessKeys.IdentityProviders.ERROR_INVALID_STATE, new Object[0]);
        }
        try {
            userIdentityProvider = this.userIdentityProviderService.link(identityProviderContext.getIdentityProvider(), (UserPrincipal)session, IdentityProviderProfile.fromPac4j((CommonProfile)commonProfile), true);
        }
        catch (Exception exception) {
            return identityProviderContext.error(GeneralKeys.Errors.ILLEGAL_ACTION, identityProviderCallbackResult -> {
                if (exception instanceof ValidationException) {
                    ValidationResult validationResult = ((ValidationException)((Object)((Object)exception))).getValidation();
                    identityProviderCallbackResult.setErrorMessage(validationResult == null ? null : validationResult.getFirstError());
                }
            }, new Object[0]);
        }
        return identityProviderContext.destroyRequest().result(IdentityProviderCallbackStatus.LINKED, identityProviderCallbackResult -> {
            identityProviderCallbackResult.setEmail(userIdentityProvider.getEmail());
            identityProviderCallbackResult.setName(userIdentityProvider.getName());
        });
    }

    private CallbackResult handleLogin(IdentityProviderContext identityProviderContext, CommonProfile commonProfile) {
        BuiltInPrincipalType builtInPrincipalType;
        UserLocatorVO userLocatorVO;
        String string;
        IdentityProvider identityProvider = identityProviderContext.getIdentityProvider();
        IdentityProviderCallbackStatus identityProviderCallbackStatus = null;
        BasicUser basicUser = null;
        UserIdentityProvider userIdentityProvider = this.userIdentityProviderService.get(identityProvider, commonProfile.getId());
        LocateUserResult locateUserResult = null;
        if (userIdentityProvider == null) {
            string = commonProfile.getEmail();
            if (string != null) {
                userLocatorVO = new UserLocatorVO((Property)UserLocatorVO.PRINCIPAL, (Object)string);
                builtInPrincipalType = this.principalTypeService.getEmail();
                try {
                    locateUserResult = this.userLocatorHandler.locate(identityProviderContext.getNetwork(), userLocatorVO, LOCATE_OPTIONS, Collections.singleton(builtInPrincipalType), (PrincipalType)builtInPrincipalType);
                }
                catch (LocateUserException locateUserException) {
                    locateUserResult = null;
                }
            }
            if (locateUserResult != null) {
                basicUser = locateUserResult.getBasicUser();
                identityProviderCallbackStatus = IdentityProviderCallbackStatus.LOGIN_EMAIL;
            }
        } else {
            basicUser = userIdentityProvider.getBasicUser();
            identityProviderCallbackStatus = IdentityProviderCallbackStatus.LOGIN_LINK;
        }
        if (basicUser == null) {
            identityProviderContext.storeProfile(commonProfile);
            string = StringHelper.trimToNull((Object)commonProfile.getEmail());
            identityProviderCallbackStatus = string == null ? IdentityProviderCallbackStatus.LOGIN_NO_EMAIL : IdentityProviderCallbackStatus.LOGIN_NO_MATCH;
            return identityProviderContext.result(identityProviderCallbackStatus, identityProviderCallbackResult -> identityProviderCallbackResult.setEmail(string));
        }
        if (!this.identityProviderService.listEnabled(basicUser).contains(identityProvider)) {
            return identityProviderContext.destroyRequest().error(AccessKeys.IdentityProviders.ERROR_DISABLED_SYSTEM, identityProvider);
        }
        if (userIdentityProvider == null) {
            string = this.userIdentityProviderService.get(basicUser, identityProvider);
            if (string != null && string.getStatus() == UserIdentityProviderStatus.DISABLED) {
                return identityProviderContext.destroyRequest().error(AccessKeys.IdentityProviders.ERROR_DISABLED_USER, identityProvider);
            }
            userIdentityProvider = this.userIdentityProviderService.link(identityProvider, (UserPrincipal)locateUserResult, IdentityProviderProfile.fromPac4j((CommonProfile)commonProfile), false);
        } else if (userIdentityProvider.getStatus() == UserIdentityProviderStatus.DISABLED) {
            return identityProviderContext.destroyRequest().error(AccessKeys.IdentityProviders.ERROR_DISABLED_USER, identityProvider);
        }
        string = identityProviderContext.getRequest();
        userLocatorVO = new LoginDTO();
        userLocatorVO.setUserAgentId(string.getUserAgentId());
        builtInPrincipalType = (PerformLoginResult)this.invokerHandler.runAs(SessionDataFactory.user((UserPrincipal)((UserPrincipal)ObjectHelper.defaultValue((Object)locateUserResult, (Object)userIdentityProvider))), () -> this.lambda$handleLogin$7((LoginDTO)userLocatorVO));
        identityProviderContext.destroyRequest();
        Session session = builtInPrincipalType.getSession();
        return identityProviderContext.result(identityProviderCallbackStatus, identityProviderCallbackResult -> {
            identityProviderCallbackResult.setSessionToken(session.getSessionToken());
            identityProviderCallbackResult.setPinCreationToken(this.sessionHandler.getPinCreationToken(session));
            identityProviderCallbackResult.setName(commonProfile == null ? null : commonProfile.getDisplayName());
            identityProviderCallbackResult.setEmail(commonProfile == null ? null : commonProfile.getEmail());
        });
    }

    private CallbackResult handleRegister(IdentityProviderContext identityProviderContext, CommonProfile commonProfile) {
        Session session;
        UserGroup userGroup = identityProviderContext.getGroup();
        CallbackResult callbackResult = this.validateRegistration(identityProviderContext, commonProfile, userGroup);
        if (callbackResult != null) {
            return callbackResult;
        }
        Session session2 = session = this.resolveRegistration(identityProviderContext, userGroup) == RegistrationWithIdentityProviders.ENABLED_DIRECT ? this.tryDirectRegistration(identityProviderContext, commonProfile) : null;
        if (session != null) {
            return identityProviderContext.destroyRequest().result(IdentityProviderCallbackStatus.REGISTRATION_DONE, identityProviderCallbackResult -> {
                identityProviderCallbackResult.setSessionToken(session.getSessionToken());
                identityProviderCallbackResult.setPinCreationToken(this.sessionHandler.getPinCreationToken(session));
            });
        }
        identityProviderContext.storeProfile(commonProfile);
        return identityProviderContext.result(IdentityProviderCallbackStatus.REGISTRATION_DATA, identityProviderCallbackResult -> this.fillRegistrationData(userGroup, commonProfile, (IdentityProviderCallbackResult)identityProviderCallbackResult));
    }

    private CallbackResult handleWizard(IdentityProviderContext identityProviderContext, CommonProfile commonProfile) {
        CustomWizardExecution customWizardExecution = identityProviderContext.getWizardExecution();
        UserGroup userGroup = this.customWizardService.getGroup(customWizardExecution);
        if (userGroup == null) {
            return identityProviderContext.destroyRequest().error(GeneralKeys.Errors.REQUIRED, UsersKeys.Users.GROUP);
        }
        CallbackResult callbackResult = this.validateRegistration(identityProviderContext, commonProfile, userGroup);
        if (callbackResult != null) {
            return callbackResult;
        }
        return identityProviderContext.destroyRequest().result(IdentityProviderCallbackStatus.WIZARD, identityProviderCallbackResult -> {
            this.fillRegistrationData(userGroup, commonProfile, (IdentityProviderCallbackResult)identityProviderCallbackResult);
            identityProviderCallbackResult.setWizardExecutionData(this.customWizardService.identityProviderCallback(customWizardExecution, commonProfile, identityProviderCallbackResult));
        });
    }

    private RegistrationWithIdentityProviders resolveRegistration(IdentityProviderContext identityProviderContext, UserGroup userGroup) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)userGroup);
        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(identityProviderContext.getChannel());
        RegistrationWithIdentityProviders registrationWithIdentityProviders = channelConfiguration.getRegistrationWithIdentityProviders();
        return registrationWithIdentityProviders;
    }

    private Session tryDirectRegistration(IdentityProviderContext identityProviderContext, CommonProfile commonProfile) {
        User user;
        SessionData sessionData;
        UserGroup userGroup = identityProviderContext.getGroup();
        IdentityProvider identityProvider = identityProviderContext.getIdentityProvider();
        try {
            sessionData = SessionDataFactory.guest((RequestData)identityProviderContext.getRequestData(), (String)identityProviderContext.getChannel().getInternalName());
            user = (User)this.invokerHandler.runAs(sessionData, () -> {
                IdentityProviderCallbackResult identityProviderCallbackResult = new IdentityProviderCallbackResult();
                identityProviderCallbackResult.setRequestId(identityProviderContext.getRequestId());
                this.fillRegistrationData(userGroup, commonProfile, identityProviderCallbackResult);
                PublicRegistrationData publicRegistrationData = this.userService.getPublicRegistrationData(new InitialGroupVO(userGroup.getId()), null, null);
                PublicRegistrationHelper.fillFromIdentityProvider((PublicRegistrationData)publicRegistrationData, (IdentityProviderCallbackResult)identityProviderCallbackResult);
                PublicRegistrationDTO publicRegistrationDTO = (PublicRegistrationDTO)publicRegistrationData.getDto();
                publicRegistrationDTO.setUserAgentId(identityProviderContext.getRequest().getUserAgentId());
                InternalIdentityProviderServiceLocal.setProfile((PublicRegistrationDTO)publicRegistrationDTO, (CommonProfile)commonProfile);
                return (User)this.conversionHandler.convert(User.class, (Object)this.userService.publicRegister(publicRegistrationDTO).getUser());
            });
        }
        catch (Exception exception) {
            return null;
        }
        if (user != null) {
            sessionData = this.userIdentityProviderService.get((BasicUser)user, identityProvider);
            return this.sessionHandler.create(new SessionHandler.CreateSessionParameters(SessionDataFactory.user((UserPrincipal)sessionData)));
        }
        return null;
    }

    private void validate(final IdentityProviderRequest identityProviderRequest) {
        final SessionData sessionData = this.getSessionData();
        Validator validator = new Validator();
        validator.property((PropertyAccess)new SimplePropertyAccess("type"), AccessKeys.IdentityProviders.REQUEST_TYPE).required();
        validator.property((PropertyAccess)new SimplePropertyAccess("identityProvider"), AccessKeys.IdentityProviders.IDENTITY_PROVIDER).required().entity(IdentityProvider.class, (EntityValidation)new BaseEntityValidation<IdentityProvider>(){

            protected boolean isValid(Object object, Object object2, IdentityProvider identityProvider) {
                ChannelAccessAccessor channelAccessAccessor = sessionData.getChannelAccessAccessor();
                if (!identityProvider.isEnabled()) {
                    return false;
                }
                IdentityProviderRequestType identityProviderRequestType = identityProviderRequest.getType();
                if (identityProviderRequestType == null) {
                    return true;
                }
                switch (identityProviderRequestType) {
                    case LOGIN: {
                        return sessionData.isGuest() && channelAccessAccessor.getIdentityProviders().contains(identityProvider);
                    }
                    case REGISTER: {
                        UserGroup userGroup = (UserGroup)InternalIdentityProviderServiceImpl.this.conversionHandler.convert(UserGroup.class, (Object)identityProviderRequest.getGroup());
                        if (userGroup == null) {
                            return true;
                        }
                        ChannelConfiguration channelConfiguration = InternalIdentityProviderServiceImpl.this.configurationHandler.getAccessor((BasicGroup)userGroup).getChannelConfiguration(sessionData.getChannel());
                        return sessionData.isGuest() && channelConfiguration.getIdentityProviders().contains(identityProvider) && channelConfiguration.getRegistrationWithIdentityProviders().enabled();
                    }
                    case WIZARD: {
                        try {
                            CustomWizardExecution customWizardExecution = InternalIdentityProviderServiceImpl.this.customWizardService.findExecution(identityProviderRequest.getWizardExecution());
                            return customWizardExecution.getWizard() instanceof RegistrationWizard;
                        }
                        catch (EntityNotFoundException entityNotFoundException) {
                            return false;
                        }
                    }
                    case LINK: {
                        return sessionData.getSession() != null && InternalIdentityProviderServiceImpl.this.identityProviderService.listEnabled(sessionData.getLoggedBasicUser()).contains(identityProvider);
                    }
                }
                return false;
            }
        });
        if (identityProviderRequest.getType() == IdentityProviderRequestType.REGISTER) {
            validator.property((PropertyAccess)new SimplePropertyAccess("group"), UsersKeys.Users.GROUP).required().entity(UserGroup.class, (EntityValidation)new BaseEntityValidation<UserGroup>(){

                protected boolean isValid(Object object, Object object2, UserGroup userGroup) {
                    return sessionData.getConfiguration().getPossibleInitialGroups().contains(userGroup);
                }
            });
        } else if (identityProviderRequest.getType() == IdentityProviderRequestType.WIZARD) {
            validator.property((PropertyAccess)new SimplePropertyAccess("wizardExecution"), SystemKeys.WizardSteps.WIZARD).required();
        } else if (identityProviderRequest.getType() == IdentityProviderRequestType.LINK) {
            UserIdentityProvider userIdentityProvider;
            IdentityProvider identityProvider = (IdentityProvider)this.conversionHandler.convert(IdentityProvider.class, (Object)identityProviderRequest.getIdentityProvider());
            if (sessionData.isLoggedIn() && identityProvider != null && (userIdentityProvider = this.userIdentityProviderService.get(sessionData.getLoggedBasicUser(), identityProvider)) != null && userIdentityProvider.getStatus() == UserIdentityProviderStatus.LINKED) {
                validator.general(GeneralValidations.invalid((MessageKey)AccessKeys.IdentityProviders.ALREADY_LINKED, (Object[])new Object[]{identityProvider, userIdentityProvider.getName()}));
            }
        }
        this.validate(validator, identityProviderRequest, "identityProviderRequest");
    }

    private CallbackResult validateRegistration(IdentityProviderContext identityProviderContext, CommonProfile commonProfile, UserGroup userGroup) {
        IdentityProvider identityProvider = identityProviderContext.getIdentityProvider();
        UserIdentityProvider userIdentityProvider = this.userIdentityProviderService.get(identityProvider, commonProfile.getId());
        if (userIdentityProvider != null) {
            return identityProviderContext.destroyRequest().error(AccessKeys.UserIdentityProviders.ERROR_LINK_OTHER_USER, identityProvider, commonProfile.getDisplayName(), userIdentityProvider.getBasicUser());
        }
        if (!this.resolveRegistration(identityProviderContext, userGroup).enabled()) {
            return identityProviderContext.destroyRequest().error(AccessKeys.IdentityProviders.ERROR_INVALID_STATE, new Object[0]);
        }
        return null;
    }

    private /* synthetic */ PerformLoginResult lambda$handleLogin$7(LoginDTO loginDTO) throws Exception {
        return this.internalAuthService.performLogin(loginDTO);
    }
}

