/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.ServiceInterceptor;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.ServiceInterceptorsAccessor;
import org.cyclos.impl.ServiceInterceptorsAccessorImpl;
import org.cyclos.impl.ServiceInvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.StatefulUserSessionData;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.impl.logging.LogContext;
import org.cyclos.impl.logging.LoggingHandler;
import org.cyclos.impl.logging.ServiceLogParams;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ServiceInterceptorCacheKey;
import org.cyclos.impl.system.ServiceInterceptorContext;
import org.cyclos.impl.system.ServiceInterceptorContextImpl;
import org.cyclos.impl.system.ServiceInterceptorServiceLocal;
import org.cyclos.impl.system.SetupServiceLocal;
import org.cyclos.impl.utils.InputOutputProcessingHandler;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.CredentialsNotSuppliedException;
import org.cyclos.model.CyclosException;
import org.cyclos.model.IllegalInvocationException;
import org.cyclos.model.RetryException;
import org.cyclos.model.access.InvalidNetworkException;
import org.cyclos.model.access.LoggedOutException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.security.Security;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.Service;
import org.cyclos.services.access.AccessClientInvocationData;
import org.cyclos.services.access.GuestInvocationData;
import org.cyclos.services.access.InternalAuthService;
import org.cyclos.services.access.InvocationData;
import org.cyclos.services.access.InvocationResult;
import org.cyclos.services.access.OidcInvocationData;
import org.cyclos.services.access.OidcService;
import org.cyclos.services.access.PasswordService;
import org.cyclos.services.access.StatefulUserInvocationData;
import org.cyclos.services.access.StatelessUserInvocationData;
import org.cyclos.services.banking.AccountService;
import org.cyclos.services.banking.PaymentService;
import org.cyclos.services.banking.RecurringPaymentService;
import org.cyclos.services.banking.ScheduledPaymentService;
import org.cyclos.services.banking.TicketService;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.services.marketplace.AdService;
import org.cyclos.services.marketplace.OrderService;
import org.cyclos.services.users.InternalBasicUserService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.SkipServiceLog;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class ServiceInvokerHandlerImpl
extends BaseGlobalHandlerImpl
implements ServiceInvokerHandler {
    private static final ServiceInterceptorsAccessor NOOP_ACCESSOR = new ServiceInterceptorsAccessor(){

        public void afterError(Throwable throwable) {
        }

        public void afterSuccess(Object object) {
        }

        public void before() {
        }
    };
    private static final int EXECUTORS_SIZE = 10;
    private static final Set<String> PASSWORD_EXPIRED_WHITELIST = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{ServiceInvokerHandlerImpl.getQualifiedMethodName(PasswordService.class, "getPasswordData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(PasswordService.class, "getChangePasswordData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(PasswordService.class, "change"), ServiceInvokerHandlerImpl.getQualifiedMethodName(PasswordService.class, "activate")}));
    private static final Set<String> OIDC_WHITELIST = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{ServiceInvokerHandlerImpl.getQualifiedMethodName(OidcService.class, "userInfo"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AccountService.class, "getAccountBalanceHistory"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AccountService.class, "getAccountHistoryData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AccountService.class, "getAccountHistoryStatus"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AccountService.class, "getAccountsSummary"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AccountService.class, "getAccountStatus"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AccountService.class, "getAccountWithStatus"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AccountService.class, "searchAccountHistory"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AccountService.class, "load"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TransactionService.class, "getPaymentData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TransactionService.class, "getPaymentToOwnerData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TransactionService.class, "getPaymentTypeData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(PaymentService.class, "perform"), ServiceInvokerHandlerImpl.getQualifiedMethodName(PaymentService.class, "preview"), ServiceInvokerHandlerImpl.getQualifiedMethodName(PaymentService.class, "validate"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TicketService.class, "getCreateData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TicketService.class, "create"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TicketService.class, "getTicketPaymentTypeData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TicketService.class, "process"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TicketService.class, "cancel"), ServiceInvokerHandlerImpl.getQualifiedMethodName(TicketService.class, "barcode"), ServiceInvokerHandlerImpl.getQualifiedMethodName(ScheduledPaymentService.class, "calculateInstallments"), ServiceInvokerHandlerImpl.getQualifiedMethodName(ScheduledPaymentService.class, "perform"), ServiceInvokerHandlerImpl.getQualifiedMethodName(ScheduledPaymentService.class, "preview"), ServiceInvokerHandlerImpl.getQualifiedMethodName(RecurringPaymentService.class, "perform"), ServiceInvokerHandlerImpl.getQualifiedMethodName(RecurringPaymentService.class, "preview"), ServiceInvokerHandlerImpl.getQualifiedMethodName(InternalBasicUserService.class, "getEditData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(InternalBasicUserService.class, "getEditFullProfileData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(InternalBasicUserService.class, "getViewProfileData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(InternalBasicUserService.class, "save"), ServiceInvokerHandlerImpl.getQualifiedMethodName(InternalBasicUserService.class, "saveFullProfile"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AdService.class, "exportAd"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AdService.class, "getAdSearchData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AdService.class, "getUserAdsSearchData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AdService.class, "getViewData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AdService.class, "search"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AdService.class, "setAsDraft"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AdService.class, "setHidden"), ServiceInvokerHandlerImpl.getQualifiedMethodName(AdService.class, "submitForAuthorization"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "accept"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "addToCart"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "adjustAndGetMyCart"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "adjustShoppingCartAndGetData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "checkCartStock"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "checkout"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "countCartItems"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "exportOrder"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "getCheckoutData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "getMyCart"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "getOrderData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "getOrderId"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "getSearchData"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "modifyQuantityOnCart"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "reject"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "removeCart"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "removeCartById"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "removeCartItem"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "search"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "setDeliveryMethod"), ServiceInvokerHandlerImpl.getQualifiedMethodName(OrderService.class, "submitToBuyer")}));
    @Autowired
    private ErrorLogServiceLocal errorLogService;
    @Autowired
    private LoggingHandler loggingHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private ConversionHandler conversionHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<ServiceInterceptorCacheKey, AccessorCacheValue> cache;
    @Autowired
    private SetupServiceLocal setupService;
    @Autowired
    private InputOutputProcessingHandler inputOutputProcessingHandler;
    @Autowired
    private ServiceInterceptorServiceLocal serviceInterceptorService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    private Map<Class<?>, Service> cachedServices = new ConcurrentHashMap();
    private ExecutorService executorService;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private JsonConverter jsonConverter;

    private static String getQualifiedMethodName(Class<? extends Service> clazz, String string) {
        return Stream.of(clazz.getMethods()).filter(method -> method.getName().equals(string)).map(method -> clazz.getName() + "." + method.getName()).findFirst().get();
    }

    public void generateErrorLog(String string, Long l, Long l2, String string2, Long l3, String string3, Supplier<String> supplier, Throwable throwable) {
        boolean bl = true;
        if (throwable instanceof CyclosException) {
            bl = ((CyclosException)throwable).shouldGenerateLog();
        }
        if (bl) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            RequestData requestData = new RequestData();
            requestData.setNetworkId(l);
            requestData.setConfigurationId(l2);
            requestData.setProcessedIds(true);
            requestData.setRemoteAddress(string);
            this.invokerHandler.runAsInTransaction(SessionDataFactory.system((RequestData)requestData), TransactionLevel.READ_WRITE, transactionStatus -> {
                Channel channel = string2 == null ? null : this.channelService.load(string2);
                BasicUser basicUser = l3 == null ? null : this.find(BasicUser.class, l3);
                this.errorLogService.create(string3, (String)supplier.get(), stringWriter.toString(), channel, basicUser);
                return null;
            });
        }
    }

    public LogContext getLogContext(SessionData sessionData, Long l, String string, String string2, Pair<?, JsonNode> pair) {
        boolean bl;
        LogContext logContext = new LogContext(this.loggingHandler, this.jsonConverter);
        LogConfiguration logConfiguration = sessionData.getConfiguration().getLogConfiguration();
        boolean bl2 = logConfiguration.isEnableServicesLog() && (!sessionData.isGuest() || logConfiguration.isLogServicesForGuests());
        boolean bl3 = bl = bl2 && logConfiguration.isLogServicesParameters();
        if (bl2) {
            Group group;
            BasicUser basicUser;
            Session session;
            PrincipalType principalType;
            Configuration configuration;
            Channel channel;
            logContext.setLogConfiguration(logConfiguration);
            ServiceLogParams serviceLogParams = new ServiceLogParams();
            logContext.setServiceLogParams(serviceLogParams);
            serviceLogParams.setCustomWebServiceId(l);
            serviceLogParams.setService(string);
            serviceLogParams.setMethod(string2);
            if (bl && pair != null) {
                serviceLogParams.setParameters(pair.getFirst());
                serviceLogParams.setParametersJson(this.getParametersJson(pair));
            }
            serviceLogParams.setRemoteAddress(sessionData.getRemoteAddress());
            Network network = sessionData.getNetwork();
            if (network != null) {
                serviceLogParams.setNetworkId(network.getId());
                serviceLogParams.setNetwork(network.getInternalName());
            }
            if ((channel = sessionData.getChannel()) != null) {
                serviceLogParams.setChannelId(channel.getId());
                serviceLogParams.setChannel(channel.getName());
            }
            if ((configuration = sessionData.getConfiguration().getConfiguration()) != null) {
                serviceLogParams.setConfigurationId(configuration.getId());
                serviceLogParams.setConfiguration(configuration.getName());
            }
            if ((principalType = sessionData.getPrincipalType()) != null) {
                serviceLogParams.setPrincipalTypeId(principalType.getId());
                serviceLogParams.setPrincipalType(principalType.getName());
                serviceLogParams.setPrincipal(sessionData.getPrincipal());
            }
            if ((session = sessionData.getSession()) != null) {
                serviceLogParams.setSessionToken(session.getSessionToken());
            }
            if ((basicUser = sessionData.getLoggedBasicUser()) != null) {
                serviceLogParams.setUserId(basicUser.getId());
                serviceLogParams.setUser(basicUser.getName());
            }
            if ((group = sessionData.getGroup()) != null) {
                serviceLogParams.setGroupId(group.getId());
                serviceLogParams.setGroup(group.getName());
            }
        }
        return logContext;
    }

    @PostConstruct
    public void initialize() throws IOException {
        this.executorService = Executors.newFixedThreadPool(10);
        this.cache = this.cacheHandler.getCache(CacheType.SERVICE_INTERCEPTORS);
    }

    public InvocationResult invoke(InvocationData invocationData) throws IllegalInvocationException {
        String string;
        InvocationResult invocationResult;
        boolean bl = false;
        ServiceInvocationResult serviceInvocationResult = null;
        try {
            serviceInvocationResult = this.doInvoke(invocationData);
            invocationResult = serviceInvocationResult.getInvocationResult();
            String string2 = string = serviceInvocationResult == null ? null : serviceInvocationResult.getSessionToken();
        }
        catch (LoggedOutException | LoginException throwable) {
            try {
                bl = true;
                throw throwable;
            }
            catch (Throwable throwable2) {
                String string3;
                String string4 = string3 = serviceInvocationResult == null ? null : serviceInvocationResult.getSessionToken();
                if (string3 != null) {
                    String string5;
                    if (bl) {
                        String string6 = serviceInvocationResult.getRemoteAddress();
                        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                            this.sessionHandler.invalidate(string6, string3);
                            return null;
                        });
                    } else if (serviceInvocationResult.getSessionExpiration() != null && ((string5 = invocationData.getRequestData().getRequestInfo().getHeader("Renew-Session-Timeout")) == null || Boolean.parseBoolean(string5))) {
                        this.sessionHandler.updateTimeout(string3, serviceInvocationResult.getSessionExpiration());
                    }
                }
                throw throwable2;
            }
        }
        if (string != null) {
            String string7;
            if (bl) {
                String string8 = serviceInvocationResult.getRemoteAddress();
                this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                    this.sessionHandler.invalidate(string6, string3);
                    return null;
                });
            } else if (serviceInvocationResult.getSessionExpiration() != null && ((string7 = invocationData.getRequestData().getRequestInfo().getHeader("Renew-Session-Timeout")) == null || Boolean.parseBoolean(string7))) {
                this.sessionHandler.updateTimeout(string, serviceInvocationResult.getSessionExpiration());
            }
        }
        return invocationResult;
    }

    public ServiceInterceptorsAccessor resolveInterceptors(Network network, Class<? extends Service> clazz, Method method, ServiceInterceptorContext serviceInterceptorContext) {
        if (network == null) {
            return NOOP_ACCESSOR;
        }
        ServiceInterceptorCacheKey serviceInterceptorCacheKey = new ServiceInterceptorCacheKey(network.getId(), clazz, method.getName());
        AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.cache.get((Serializable)serviceInterceptorCacheKey, () -> {
            List list = this.serviceInterceptorService.resolveInterceptors(network, clazz, method);
            return AccessorCacheValue.create((Collection)list);
        });
        List list = (List)accessorCacheValue.unwrap(this.getApplicationContext());
        if (CollectionHelper.isEmpty((Iterable)list)) {
            return NOOP_ACCESSOR;
        }
        ArrayDeque<CustomScriptAccessor> arrayDeque = new ArrayDeque<CustomScriptAccessor>(list.size());
        for (ServiceInterceptor serviceInterceptor : list) {
            CustomScriptAccessor customScriptAccessor = this.customScriptService.newAccessor(serviceInterceptor.getScript(), serviceInterceptor.getScriptParameters()).bind("interceptor", (Object)serviceInterceptor).bind("service", clazz).bind("operation", (Object)method).bind("context", (Object)serviceInterceptorContext);
            arrayDeque.add(customScriptAccessor);
        }
        return new ServiceInterceptorsAccessorImpl(arrayDeque);
    }

    public SessionData resolveSessionData(InvocationData invocationData) {
        if (!this.setupService.isSetupDone()) {
            if (BuiltInChannel.MAIN.getInternalName().equals(invocationData.getChannel())) {
                return this.toSystemSessionData(invocationData);
            }
            throw new InvalidNetworkException();
        }
        if (invocationData instanceof GuestInvocationData) {
            return this.toGuestSessionData((GuestInvocationData)invocationData);
        }
        if (invocationData instanceof StatelessUserInvocationData) {
            return this.toStatelessUserSessionData((StatelessUserInvocationData)invocationData);
        }
        if (invocationData instanceof StatefulUserInvocationData) {
            return this.toStatefulUserSessionData((StatefulUserInvocationData)invocationData);
        }
        if (invocationData instanceof OidcInvocationData) {
            return this.toOidcSessionData((OidcInvocationData)invocationData);
        }
        if (invocationData instanceof AccessClientInvocationData) {
            return this.toAccessClientSessionData((AccessClientInvocationData)invocationData);
        }
        throw new IllegalArgumentException("Invalid InvocationData received: " + String.valueOf(invocationData));
    }

    @PreDestroy
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected ServiceInvocationResult performInvocation(TransactionLevel transactionLevel, ServiceInvocationTransactionCallback serviceInvocationTransactionCallback) {
        SessionData sessionData = this.toSystemSessionData(serviceInvocationTransactionCallback.invocationData);
        return (ServiceInvocationResult)this.invokerHandler.runAsInCurrentOrNewTransaction(sessionData, transactionLevel, (TransactionCallback)serviceInvocationTransactionCallback);
    }

    protected <T> T resolveService(Class<T> clazz) throws IllegalInvocationException {
        Service service = this.cachedServices.get(clazz);
        if (service == null) {
            Map map = this.getApplicationContext().getBeansOfType(clazz, false, true);
            if (map.isEmpty()) {
                throw new IllegalStateException("Could not find any registered bean for " + String.valueOf(clazz));
            }
            Map map2 = this.getApplicationContext().getBeansWithAnnotation(Security.class);
            for (Object v : map2.values()) {
                if (!clazz.isInstance(v)) continue;
                service = (Service)v;
                break;
            }
            if (service == null) {
                throw new IllegalInvocationException("No service security found for " + clazz.getName());
            }
            this.cachedServices.put(clazz, service);
        }
        return (T)service;
    }

    private ServiceInvocationResult doInvoke(InvocationData invocationData) {
        TransactionLevel transactionLevel;
        Method method;
        invocationData.checkConsistency();
        Class clazz = invocationData.getServiceInterface();
        try {
            method = clazz.getMethod(invocationData.getMethodName(), invocationData.getParameterTypes());
        }
        catch (Exception exception) {
            throw new IllegalInvocationException("Unable to find " + clazz.getSimpleName() + "." + invocationData.getMethodName() + "(" + StringUtils.join((Object[])invocationData.getParameterTypes(), (String)", ") + ")");
        }
        Service service = (Service)this.resolveService(clazz);
        Transaction transaction = method.getAnnotation(Transaction.class);
        if (transaction == null) {
            this.getLogger().warn("No @Transaction annotation for " + String.valueOf(method) + ". Assuming read-write.");
            transactionLevel = TransactionLevel.READ_WRITE;
        } else {
            transactionLevel = transaction.value();
        }
        ServiceInvocationTransactionCallback serviceInvocationTransactionCallback = new ServiceInvocationTransactionCallback(invocationData, method, service);
        long l = System.currentTimeMillis();
        ServiceInvocationResult serviceInvocationResult = this.performInvocation(transactionLevel, serviceInvocationTransactionCallback);
        InvocationResult invocationResult = serviceInvocationResult.getInvocationResult();
        LogContext logContext = serviceInvocationResult.getLogContext();
        logContext.setTimeTaken(System.currentTimeMillis() - l).logService();
        if (!invocationResult.isSuccessful()) {
            String string = invocationData.getServiceInterface().getSimpleName() + "." + invocationData.getMethodName();
            Object[] objectArray = invocationData.getParameters();
            Supplier<String> supplier = () -> {
                JsonNode jsonNode = this.fixInput(this.inputOutputProcessingHandler.processSensitiveMethodParameters(method, this.jsonConverter.toLogNode((Object)objectArray, true)));
                return this.getParametersJson(jsonNode);
            };
            this.generateErrorLog(invocationData.getRequestData().getRemoteAddress(), serviceInvocationResult.getNetworkId(), serviceInvocationResult.getConfigurationId(), invocationData.getChannel(), serviceInvocationResult.getLoggedUserId(), string, supplier, invocationResult.getThrowable());
        }
        return serviceInvocationResult;
    }

    private JsonNode fixInput(JsonNode jsonNode) {
        if (jsonNode instanceof ArrayNode) {
            int n = jsonNode.size();
            if (n == 0) {
                return NullNode.getInstance();
            }
            if (n == 1) {
                return jsonNode.get(0);
            }
        }
        return jsonNode;
    }

    private void fixInput(Pair<Object[], JsonNode> pair) {
        if (pair != null) {
            pair.setSecond((Object)this.fixInput((JsonNode)pair.getSecond()));
        }
    }

    private LogContext getLogContext(SessionData sessionData, Class<? extends Service> clazz, Method method, Pair<?, JsonNode> pair) {
        LogContext logContext = this.getLogContext(sessionData, null, clazz.getSimpleName(), method.getName(), pair);
        logContext.setSkipSuccess(method.isAnnotationPresent(SkipServiceLog.class));
        return logContext;
    }

    private String getParametersJson(JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        try {
            return this.jsonConverter.writeValueAsString((Object)jsonNode);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getParametersJson(Pair<?, JsonNode> pair) {
        if (pair == null) {
            return null;
        }
        return this.getParametersJson((JsonNode)pair.getSecond());
    }

    private boolean isAllowedIfPasswordExpired(InvocationData invocationData) {
        Class clazz = invocationData.getServiceInterface();
        if (clazz == null) {
            return false;
        }
        return PASSWORD_EXPIRED_WHITELIST.contains(clazz.getName() + "." + invocationData.getMethodName());
    }

    private boolean isForLogin(InvocationData invocationData) {
        Class clazz = invocationData.getServiceInterface();
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName() + "." + invocationData.getMethodName();
        return ObjectHelper.isOneOf((Object)string, (Object[])new Object[]{ServiceInvokerHandlerImpl.getQualifiedMethodName(InternalAuthService.class, "login")});
    }

    private SessionData toAccessClientSessionData(AccessClientInvocationData accessClientInvocationData) {
        String string = accessClientInvocationData.getToken();
        if (StringHelper.isBlank((Object)string)) {
            throw new CredentialsNotSuppliedException("Access client token is required");
        }
        return SessionDataFactory.accessClient((boolean)this.isForLogin((InvocationData)accessClientInvocationData), (String)accessClientInvocationData.getChannel(), (String)string, (RequestData)accessClientInvocationData.getRequestData());
    }

    private SessionData toGuestSessionData(GuestInvocationData guestInvocationData) {
        return SessionDataFactory.guest((RequestData)guestInvocationData.getRequestData(), (String)guestInvocationData.getChannel());
    }

    private SessionData toOidcSessionData(OidcInvocationData oidcInvocationData) {
        String string = oidcInvocationData.getAccessToken();
        if (StringHelper.isBlank((Object)string)) {
            throw new CredentialsNotSuppliedException("Access token is required");
        }
        String string2 = oidcInvocationData.getServiceInterface().getName() + "." + oidcInvocationData.getMethodName();
        PermissionHelper.checkContains(OIDC_WHITELIST, (Object)string2);
        return SessionDataFactory.oidc((String)string, (RequestData)oidcInvocationData.getRequestData());
    }

    private SessionData toStatefulUserSessionData(StatefulUserInvocationData statefulUserInvocationData) {
        String string = statefulUserInvocationData.getSessionToken();
        if (StringHelper.isBlank((Object)string)) {
            throw new CredentialsNotSuppliedException("Session token is required");
        }
        RequestData requestData = statefulUserInvocationData.getRequestData();
        String string2 = requestData.getRemoteAddress();
        if (statefulUserInvocationData.getRemoteAddress() != null) {
            string2 = statefulUserInvocationData.getRemoteAddress();
        }
        return SessionDataFactory.stateful((String)string, (String)string2, (RequestData)requestData);
    }

    private SessionData toStatelessUserSessionData(StatelessUserInvocationData statelessUserInvocationData) {
        String string = statelessUserInvocationData.getPrincipalType();
        String string2 = statelessUserInvocationData.getPrincipal();
        String string3 = statelessUserInvocationData.getPassword();
        if (StringHelper.isBlank((Object)string2) || StringHelper.isBlank((Object)string3)) {
            throw new CredentialsNotSuppliedException("Both principal and password are required");
        }
        return SessionDataFactory.stateless((boolean)this.isForLogin((InvocationData)statelessUserInvocationData), (boolean)this.isAllowedIfPasswordExpired((InvocationData)statelessUserInvocationData), (String)statelessUserInvocationData.getChannel(), (String)string, (String)string2, (String)string3, (RequestData)statelessUserInvocationData.getRequestData());
    }

    private SessionData toSystemSessionData(InvocationData invocationData) {
        return SessionDataFactory.system((RequestData)invocationData.getRequestData(), (String)invocationData.getChannel());
    }

    protected class ServiceInvocationResult {
        private final InvocationResult invocationResult;
        private final Long networkId;
        private final Long configurationId;
        private final Long loggedUserId;
        private final String sessionToken;
        private final String remoteAddress;
        private final TimeInterval sessionExpiration;
        private final LogContext logContext;

        public ServiceInvocationResult(InvocationResult invocationResult, SessionData sessionData, Long l, Long l2, Long l3, String string, String string2, TimeInterval timeInterval, LogContext logContext) {
            this.invocationResult = invocationResult;
            this.networkId = l;
            this.configurationId = l2;
            this.loggedUserId = l3;
            this.sessionToken = string;
            this.remoteAddress = string2;
            this.sessionExpiration = timeInterval;
            this.logContext = logContext;
        }

        public Long getConfigurationId() {
            return this.configurationId;
        }

        public InvocationResult getInvocationResult() {
            return this.invocationResult;
        }

        public LogContext getLogContext() {
            return this.logContext;
        }

        public Long getLoggedUserId() {
            return this.loggedUserId;
        }

        public Long getNetworkId() {
            return this.networkId;
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        public TimeInterval getSessionExpiration() {
            return this.sessionExpiration;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }
    }

    protected class ServiceInvocationTransactionCallback
    implements TransactionCallback<ServiceInvocationResult> {
        private final InvocationData invocationData;
        private final Method serviceMethod;
        private final Service service;

        public ServiceInvocationTransactionCallback(InvocationData invocationData, Method method, Service service) {
            this.invocationData = invocationData;
            this.serviceMethod = method;
            this.service = service;
        }

        public ServiceInvocationResult doInTransaction(TransactionStatus transactionStatus) {
            SessionData sessionData = ServiceInvokerHandlerImpl.this.resolveSessionData(this.invocationData);
            return (ServiceInvocationResult)ServiceInvokerHandlerImpl.this.invokerHandler.runAs(sessionData, () -> this.performInvocation(transactionStatus, sessionData));
        }

        public InvocationData getInvocationData() {
            return this.invocationData;
        }

        public Service getService() {
            return this.service;
        }

        public Method getServiceMethod() {
            return this.serviceMethod;
        }

        private ServiceInvocationResult performInvocation(TransactionStatus transactionStatus, SessionData sessionData) {
            InvocationResult invocationResult;
            Throwable throwable;
            RequestContext requestContext;
            Class clazz = this.invocationData.getServiceInterface();
            Object[] objectArray = this.invocationData.getParameters();
            ServiceInterceptorContextImpl serviceInterceptorContextImpl = null;
            ServiceInterceptorsAccessor serviceInterceptorsAccessor = null;
            ConfigurationAccessor configurationAccessor = null;
            BasicUser basicUser = null;
            LogContext logContext = LogContext.empty();
            try {
                try {
                    Object object;
                    Object object2;
                    boolean bl;
                    boolean bl2;
                    sessionData.checkConsistency();
                    configurationAccessor = sessionData.getConfiguration();
                    basicUser = sessionData.getLoggedBasicUser();
                    requestContext = RequestContext.get();
                    throwable = requestContext == null ? null : requestContext.getProfilingEntry();
                    boolean bl3 = bl2 = throwable != null;
                    if (bl2 && basicUser != null) {
                        throwable.setUser(basicUser.getUsername());
                    }
                    boolean bl4 = (bl = this.willGenerateLog(sessionData)) && configurationAccessor.getLogConfiguration().isLogServicesParameters();
                    boolean bl5 = bl && configurationAccessor.getLogConfiguration().isLogServicesResults();
                    Pair pair = ServiceInvokerHandlerImpl.this.inputOutputProcessingHandler.processMethodParameters(this.serviceMethod, objectArray, bl2 || bl4);
                    ServiceInvokerHandlerImpl.this.fixInput((Pair<Object[], JsonNode>)pair);
                    serviceInterceptorContextImpl = new ServiceInterceptorContextImpl(pair == null ? null : (Object[])pair.getFirst());
                    if (bl2 && pair != null) {
                        throwable.setParameters(pair.getSecond());
                        if (!bl4) {
                            pair.setSecond(null);
                        }
                    }
                    serviceInterceptorsAccessor = ServiceInvokerHandlerImpl.this.resolveInterceptors(sessionData.getNetwork(), clazz, this.serviceMethod, serviceInterceptorContextImpl);
                    serviceInterceptorsAccessor.before();
                    logContext = ServiceInvokerHandlerImpl.this.getLogContext(sessionData, clazz, this.serviceMethod, pair);
                    if (serviceInterceptorContextImpl.getError() != null) {
                        throw serviceInterceptorContextImpl.getError();
                    }
                    if (serviceInterceptorContextImpl.isSkipInvocation()) {
                        object2 = serviceInterceptorContextImpl.getResult();
                    } else {
                        object2 = this.serviceMethod.invoke((Object)this.service, serviceInterceptorContextImpl.getParameters());
                        serviceInterceptorContextImpl.setResult(object2);
                    }
                    serviceInterceptorsAccessor.afterSuccess(object2);
                    if (object2 != serviceInterceptorContextImpl.getResult()) {
                        object2 = serviceInterceptorContextImpl.getResult();
                        object = this.serviceMethod.getReturnType();
                        if (!((Class)object).isInstance(object2)) {
                            object2 = ServiceInvokerHandlerImpl.this.conversionHandler.convert((Class)object, object2);
                        }
                    }
                    if ((object = InvocationContext.ensure()).getTransactionLevel() == TransactionLevel.READ_WRITE && !transactionStatus.isRollbackOnly()) {
                        object.getEntityManager().flush();
                    }
                    Pair pair2 = ServiceInvokerHandlerImpl.this.inputOutputProcessingHandler.processMethodResult(this.serviceMethod, object2, bl2 || bl5);
                    if (bl2 && pair2 != null) {
                        throwable.setResult(pair2.getSecond());
                    }
                    logContext.setResult(pair2).setWrite(object.hasWrite());
                    invocationResult = new InvocationResult(pair2 == null ? null : pair2.getFirst());
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (Throwable throwable2) {
                throwable = ServiceInvokerHandlerImpl.this.invokerHandler.translateException(throwable2);
                if (throwable instanceof RetryException) {
                    ServiceInvokerHandlerImpl.this.inputOutputProcessingHandler.restore(serviceInterceptorContextImpl.getParameters());
                    throw (RetryException)throwable;
                }
                transactionStatus.setRollbackOnly();
                if (ServiceInvokerHandlerImpl.this.cyclosProperties.isDumpAllErrors()) {
                    ServiceInvokerHandlerImpl.this.getLogger().error("Error on service method " + String.valueOf(this.serviceMethod), throwable);
                }
                if (serviceInterceptorsAccessor != null) {
                    try {
                        serviceInterceptorsAccessor.afterError(throwable);
                    }
                    catch (Throwable throwable3) {
                        ServiceInvokerHandlerImpl.this.getLogger().error("Error while running interceptors after error", throwable3);
                    }
                }
                if (throwable instanceof PermissionDeniedException) {
                    PermissionDeniedException permissionDeniedException = (PermissionDeniedException)throwable;
                    sessionData.ifWraps(UserSessionData.class, userSessionData -> {
                        permissionDeniedException.setHasExpiredPassword(userSessionData.hasExpiredPassword());
                        permissionDeniedException.setLoginConfirmation(userSessionData.getLoginConfirmation());
                        permissionDeniedException.setHasPendingAgreements(userSessionData.hasPendingAgreements());
                    });
                }
                ServiceInvokerHandlerImpl.this.inputOutputProcessingHandler.processToClient((Object)throwable, false);
                logContext.setError(throwable);
                invocationResult = new InvocationResult(throwable);
            }
            requestContext = new MutableObject();
            throwable = new MutableObject();
            sessionData.ifWraps(StatefulUserSessionData.class, arg_0 -> ServiceInvocationTransactionCallback.lambda$performInvocation$2((MutableObject)requestContext, (MutableObject)throwable, arg_0));
            Long l = configurationAccessor == null ? this.invocationData.getRequestData().getConfigurationId() : SimpleEntity.id((SimpleEntity)configurationAccessor.getConfiguration());
            return new ServiceInvocationResult(invocationResult, sessionData, SimpleEntity.id((SimpleEntity)sessionData.getNetwork()), l, SimpleEntity.id((SimpleEntity)basicUser), (String)requestContext.get(), sessionData.getRemoteAddress(), (TimeInterval)throwable.get(), logContext);
        }

        private boolean willGenerateLog(SessionData sessionData) {
            boolean bl;
            if (this.serviceMethod.isAnnotationPresent(SkipServiceLog.class)) {
                return false;
            }
            LogConfiguration logConfiguration = sessionData.getConfiguration().getLogConfiguration();
            if (!logConfiguration.isEnableServicesLog() || !logConfiguration.isLogServicesForGuests() && !sessionData.isLoggedIn()) {
                return false;
            }
            boolean bl2 = bl = InvocationContext.get().getTransactionLevel() == TransactionLevel.READ_WRITE;
            return !logConfiguration.isLogServicesWritesOnly() || bl;
        }

        private static /* synthetic */ void lambda$performInvocation$2(MutableObject mutableObject, MutableObject mutableObject2, StatefulUserSessionData statefulUserSessionData) {
            mutableObject.set((Object)statefulUserSessionData.getSessionToken());
            mutableObject2.set((Object)statefulUserSessionData.getSessionTimeout());
        }
    }
}

