/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.cyclos.bootstrap.BaseDataSourceProvider;
import org.cyclos.utils.StringHelper;

public class JndiDataSourceProvider
extends BaseDataSourceProvider {
    private static final String JNDI_NAME = "jndiName";

    @Override
    public String getConnectionDetails(Properties properties) {
        return StringHelper.trimToNull((Object)properties.getProperty(JNDI_NAME));
    }

    @Override
    protected void doDestroy(DataSource dataSource) throws Exception {
    }

    @Override
    protected DataSource doInitialize(Properties properties) throws Exception {
        String string = StringHelper.trimToNull((Object)properties.getProperty(JNDI_NAME));
        if (string == null) {
            throw new IllegalStateException("No jndiName property was passed");
        }
        Properties properties2 = new Properties(properties);
        properties2.remove(JNDI_NAME);
        InitialContext initialContext = new InitialContext(properties2);
        Object object = initialContext.lookup(string);
        if (!(object instanceof DataSource)) {
            throw new IllegalStateException("The given JNDI name jndiName didn't resolve to a DataSource, was " + String.valueOf(object));
        }
        return (DataSource)object;
    }
}

