/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.bootstrap.BaseDataSourceProvider;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;

public class C3P0DataSourceProvider
extends BaseDataSourceProvider {
    private static Logger LOG = LogManager.getLogger(C3P0DataSourceProvider.class);

    @Override
    public String getConnectionDetails(Properties properties) {
        return properties.getProperty("jdbcUrl");
    }

    @Override
    protected void doDestroy(DataSource dataSource) throws Exception {
        DataSources.destroy((DataSource)dataSource);
    }

    @Override
    protected DataSource doInitialize(Properties properties) throws Exception {
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
        if (CollectionHelper.isNotEmpty((Map)properties)) {
            BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl((Object)comboPooledDataSource);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                try {
                    beanWrapperImpl.setPropertyValue((String)entry.getKey(), entry.getValue());
                }
                catch (InvalidPropertyException invalidPropertyException) {
                    LOG.warn("Invalid c3p0 connection pool property: " + String.valueOf(entry.getKey()));
                }
            }
        }
        return comboPooledDataSource;
    }
}

