/*
 * Decompiled with CFR 0.152.
 */
package org.stro.dbdiff;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.stro.dbdiff.AbstractDDLGenerator;
import org.stro.dbdiff.AbstractDatabaseMetadataHandler;
import org.stro.dbdiff.DDLGenerator;
import org.stro.dbdiff.LoadFromDatabaseOptions;
import org.stro.dbdiff.model.ColumnMetadata;
import org.stro.dbdiff.model.DatabaseChanges;
import org.stro.dbdiff.model.DatabaseDiffResult;
import org.stro.dbdiff.model.DatabaseMetadata;
import org.stro.dbdiff.model.DefinableMetadata;
import org.stro.dbdiff.model.NamedMetadata;
import org.stro.dbdiff.model.PKConstraintMetadata;
import org.stro.dbdiff.model.TableChanges;
import org.stro.dbdiff.model.TableMetadata;

public class PostgreSQLMetadataHandler
extends AbstractDatabaseMetadataHandler {
    private static final String SEQUENCES_QUERY = "select sequence_name as name, start_value as start, minimum_value as minimum, maximum_value as maximum, increment, cycle_option as cycle from information_schema.sequences where sequence_schema = ? and sequence_name similar to ? and sequence_name not similar to ?";
    private static final String VIEWS_QUERY = "select viewname as name, definition from pg_views where schemaname = ? and viewname similar to ? and viewname not similar to ?";
    private static final String TABLES_QUERY = "select tablename as name from pg_tables where schemaname = ? and tablename similar to ? and tablename not similar to ?";
    private static final String TABLE_TRIGGERS_QUERY = "select pg_get_triggerdef(oid) as definition, tgname as name from pg_trigger where tgisinternal is false and tgrelid = to_regclass(?)";
    private static final String TABLE_INDEXES_QUERY = "select indexdef as definition, indexname as name from pg_indexes where tablename = ?";
    private static final String TABLE_UNIQUE_CONSTRAINTS_QUERY = "select pg_get_constraintdef(oid) as definition, conname as name from pg_constraint con where contype='u' and con.conrelid = to_regclass(?)";
    private static final String TABLE_FK_CONSTRAINTS_QUERY = "select pg_get_constraintdef(oid) as definition, conname as name from pg_constraint con where contype='f' and con.conrelid = to_regclass(?)";
    private static final String TABLE_PK_CONSTRAINT_QUERY = "select pg_get_constraintdef(oid) as definition, conname as name from pg_constraint con where contype='p' and con.conrelid = to_regclass(?)";
    private static final String TABLE_COLUMNS_QUERY = "select quote_ident(attname) as name, format_type(atttypid,atttypmod) as type, not attnotnull as nullable,   case when atthasdef then    (select pg_get_expr(adbin, attrelid)    from pg_attrdef     where adrelid = attrelid and adnum = attnum )::text else null   end as defaultValue from pg_attribute inner join pg_class on oid = attrelid where pg_class.oid = to_regclass(?) and attnum > 0 and not attisdropped order by attrelid, attnum";
    private static final String FUNCTIONS_QUERY_LEGACY = "select pg_get_functiondef(to_regproc(proname)) as definition, proname || '(' || pg_get_function_identity_arguments(to_regproc(proname)) || ')' as name from pg_proc left join pg_aggregate on aggfnoid = to_regproc(proname) where aggfnoid is null and to_regnamespace(?) = pronamespace and proname similar to ? and proname not similar to ? and to_regproc(proname) is not null";
    private static final String FUNCTIONS_QUERY = "select pg_get_functiondef(oid) as definition, proname || '(' || pg_get_function_identity_arguments(oid) || ')' as name from pg_proc left join pg_aggregate on aggfnoid = oid where aggfnoid is null and to_regnamespace(?) = pronamespace and proname similar to ? and proname not similar to ?";
    private static final String SERVER_VERSION_QUERY = "SELECT current_setting('server_version_num')";
    private static final int SERVER_VERSION_12 = 120000;
    private static final int SERVER_VERSION_11 = 110000;
    private static final String TRIGGER_EXECUTE_LEGACY = " PROCEDURE ";
    private static final String TRIGGER_EXECUTE = " FUNCTION ";
    private static final String DECIMAL_TYPE = "decimal";
    private static final String NUMERIC_TYPE = "numeric";
    private static Logger LOG = LogManager.getLogger(PostgreSQLMetadataHandler.class);
    public static final String DEFAULT_SCHEMA = "public";

    public static List<String> getDDL(DatabaseDiffResult diff, boolean includeToAdd, boolean includeToRemove, boolean includeToRevert) {
        ArrayList<String> result = new ArrayList<String>();
        if (includeToAdd) {
            result.addAll(PostgreSQLMetadataHandler.getDDLToAddRemovedObjects(diff));
        }
        if (includeToRemove) {
            result.addAll(PostgreSQLMetadataHandler.getDDLToRemoveAddedObjects(diff));
        }
        if (includeToRevert) {
            result.addAll(PostgreSQLMetadataHandler.getDDLToRevertChangedObjects(diff));
        }
        result.sort(PostgreSQLMetadataHandler::compareDdl);
        return result;
    }

    private static String columnDDLPart(String tableName, ColumnMetadata c) {
        StringBuilder colBuff = new StringBuilder(c.getName());
        if (PostgreSQLMetadataHandler.isBigSerial(tableName, c)) {
            colBuff.append(" ").append(PostgreSQLMetadataHandler.toSerialType(c.getType())).append(" NOT NULL");
        } else {
            colBuff.append(" ").append(c.getType()).append(" ").append(c.getNullable() != false ? "NULL " : "NOT NULL ").append(c.getDefaultValue() == null ? "" : "DEFAULT ").append(c.getDefaultValue() == null ? "" : c.getDefaultValue());
        }
        return colBuff.toString();
    }

    private static int compareDdl(String ddl1, String ddl2) {
        Predicate<String> isCreateTable = ddl -> ddl.toLowerCase().contains("create table");
        Predicate<String> isDrop = ddl -> ddl.toLowerCase().contains("drop ");
        Predicate<String> isAddColumn = ddl -> ddl.toLowerCase().contains(" add column ");
        Predicate<String> isAddConstraint = ddl -> ddl.toLowerCase().contains(" add constraint");
        Predicate<String> isAddUniqueConstraint = ddl -> isAddConstraint.test((String)ddl) && (ddl.toLowerCase().contains(" unique ") || ddl.toLowerCase().contains(" primary key "));
        Predicate<String> isCreateTrigger = ddl -> ddl.toLowerCase().contains(" create trigger");
        boolean isCreateTableDdl1 = isCreateTable.test(ddl1);
        if (isCreateTableDdl1 ^ isCreateTable.test(ddl2)) {
            return isCreateTableDdl1 ? -1 : 1;
        }
        boolean isDropDdl1 = isDrop.test(ddl1);
        if (isDropDdl1 ^ isDrop.test(ddl2)) {
            return isDropDdl1 ? -1 : 1;
        }
        boolean isAddColumnDdl1 = isAddColumn.test(ddl1);
        if (isAddColumnDdl1 ^ isAddColumn.test(ddl2)) {
            return isAddColumnDdl1 ? -1 : 1;
        }
        boolean isAddUniqueConstraintDdl1 = isAddUniqueConstraint.test(ddl1);
        if (isAddUniqueConstraintDdl1 ^ isAddUniqueConstraint.test(ddl2)) {
            return isAddUniqueConstraintDdl1 ? -1 : 1;
        }
        boolean isCreateTriggerDdl1 = isCreateTrigger.test(ddl1);
        if (isCreateTriggerDdl1 ^ isCreateTrigger.test(ddl2)) {
            return isCreateTriggerDdl1 ? 1 : -1;
        }
        boolean isAddConstraintDdl1 = isAddConstraint.test(ddl1);
        if (isAddConstraintDdl1 ^ isAddConstraint.test(ddl2)) {
            return isAddConstraintDdl1 ? 1 : -1;
        }
        return ddl1.compareTo(ddl2);
    }

    private static String ddlAddColumn(String tableName, ColumnMetadata c) {
        return String.format("ALTER TABLE %s ADD COLUMN %s", tableName, PostgreSQLMetadataHandler.columnDDLPart(tableName, c));
    }

    private static String ddlAddConstraint(String tableName, DefinableMetadata c) {
        return String.format("ALTER TABLE %s ADD CONSTRAINT %s %s", tableName, c.getName(), c.getDefinition());
    }

    private static String ddlAddView(DefinableMetadata view) {
        return String.format("CREATE VIEW %s AS %s", view.getName(), view.getDefinition());
    }

    private static Stream<String> ddlAlterColumn(String tableName, ColumnMetadata c) {
        ArrayList<String> result = new ArrayList<String>();
        if (c.getNullable() != null) {
            result.add(String.format("ALTER TABLE %s ALTER COLUMN %s %s NOT NULL", tableName, c.getName(), c.getNullable() != false ? "DROP" : "SET"));
        }
        if (c.getType() != null) {
            result.add(String.format("ALTER TABLE %s ALTER COLUMN %s TYPE %s", tableName, c.getName(), c.getType()));
        }
        if (c.getDefaultValue() != null) {
            result.add(String.format("ALTER TABLE %s ALTER COLUMN %s SET DEFAULT %s", tableName, c.getName(), c.getDefaultValue()));
        } else if (c.isDefaultValueDropped()) {
            result.add(String.format("ALTER TABLE %s ALTER COLUMN %s DROP DEFAULT", tableName, c.getName()));
        }
        return result.stream();
    }

    private static String ddlAlterSequence(DefinableMetadata sequence) {
        return sequence.getDefinition().replace("CREATE", "ALTER").replace("NOT", "");
    }

    private static List<String> ddlAlterTable(int dbServerVersion, TableChanges table) {
        ArrayList<String> result = new ArrayList<String>();
        String name = table.getName();
        result.addAll(table.getColumns().getAdded().values().stream().map(c -> PostgreSQLMetadataHandler.ddlDropColumn(name, c)).collect(Collectors.toList()));
        result.addAll(table.getColumns().getRemoved().values().stream().map(c -> PostgreSQLMetadataHandler.ddlAddColumn(name, c)).collect(Collectors.toList()));
        result.addAll(table.getColumns().getChanged().values().stream().flatMap(c -> PostgreSQLMetadataHandler.ddlAlterColumn(name, c)).collect(Collectors.toList()));
        if (table.getPkConstraint().getRemoved() != null) {
            result.add(PostgreSQLMetadataHandler.ddlAddConstraint(name, table.getPkConstraint().getRemoved()));
        }
        if (table.getPkConstraint().getAdded() != null) {
            result.add(PostgreSQLMetadataHandler.ddlDropConstraint(name, table.getPkConstraint().getAdded()));
        }
        if (table.getPkConstraint().getChanged() != null) {
            result.add(PostgreSQLMetadataHandler.ddlDropConstraint(name, table.getPkConstraint().getChanged()));
            result.add(PostgreSQLMetadataHandler.ddlAddConstraint(name, table.getPkConstraint().getChanged()));
        }
        result.addAll(table.getfKConstraints().getAdded().values().stream().map(c -> PostgreSQLMetadataHandler.ddlDropConstraint(name, c)).collect(Collectors.toList()));
        result.addAll(table.getfKConstraints().getRemoved().values().stream().map(c -> PostgreSQLMetadataHandler.ddlAddConstraint(name, c)).collect(Collectors.toList()));
        result.addAll(table.getfKConstraints().getChanged().values().stream().flatMap(c -> Stream.of(PostgreSQLMetadataHandler.ddlDropConstraint(name, c), PostgreSQLMetadataHandler.ddlAddConstraint(name, c))).collect(Collectors.toList()));
        result.addAll(table.getUniqueConstraints().getAdded().values().stream().map(c -> PostgreSQLMetadataHandler.ddlDropConstraint(name, c)).collect(Collectors.toList()));
        result.addAll(table.getUniqueConstraints().getRemoved().values().stream().map(c -> PostgreSQLMetadataHandler.ddlAddConstraint(name, c)).collect(Collectors.toList()));
        result.addAll(table.getUniqueConstraints().getChanged().values().stream().flatMap(c -> Stream.of(PostgreSQLMetadataHandler.ddlDropConstraint(name, c), PostgreSQLMetadataHandler.ddlAddConstraint(name, c))).collect(Collectors.toList()));
        result.addAll(table.getIndexes().getAdded().values().stream().map(PostgreSQLMetadataHandler::ddlDropIndex).collect(Collectors.toList()));
        result.addAll(table.getIndexes().getRemoved().values().stream().map(DefinableMetadata::getDefinition).collect(Collectors.toList()));
        result.addAll(table.getIndexes().getChanged().values().stream().flatMap(i -> Stream.of(PostgreSQLMetadataHandler.ddlDropIndex(i), i.getDefinition())).collect(Collectors.toList()));
        result.addAll(table.getTriggers().getAdded().values().stream().map(t -> PostgreSQLMetadataHandler.ddlDropTrigger(name, t)).collect(Collectors.toList()));
        result.addAll(table.getTriggers().getRemoved().values().stream().map(t -> PostgreSQLMetadataHandler.ddlCreateTrigger(dbServerVersion, t)).collect(Collectors.toList()));
        result.addAll(table.getTriggers().getChanged().values().stream().flatMap(t -> Stream.of(PostgreSQLMetadataHandler.ddlDropTrigger(name, t), PostgreSQLMetadataHandler.ddlCreateTrigger(dbServerVersion, t))).collect(Collectors.toList()));
        return result;
    }

    private static String ddlAlterView(DefinableMetadata view) {
        return String.format("CREATE OR REPLACE VIEW %s AS %s", view.getName(), view.getDefinition());
    }

    private static List<String> ddlCreateTable(int dbServerVersion, TableMetadata table) {
        ArrayList<String> result = new ArrayList<String>();
        String name = table.getName();
        String cols = table.getColumns().values().stream().map(c -> PostgreSQLMetadataHandler.columnDDLPart(name, c)).collect(Collectors.joining(", " + System.lineSeparator()));
        result.add(String.format("CREATE TABLE %s (%n%s%n)", name, cols));
        Stream pkStream = table.getpKConstraint() == null ? Stream.empty() : Stream.of(table.getpKConstraint());
        Stream.concat(Stream.concat(pkStream, table.getUniqueConstraints().values().stream()), table.getfKConstraints().values().stream()).forEach(c -> result.add(String.format("ALTER TABLE %s ADD CONSTRAINT %s %s", name, c.getName(), c.getDefinition())));
        table.getIndexes().values().forEach(i -> result.add(i.getDefinition()));
        table.getTriggers().values().stream().map(m -> PostgreSQLMetadataHandler.ddlCreateTrigger(dbServerVersion, m)).forEach(ddl -> result.add((String)ddl));
        return result;
    }

    private static String ddlCreateTrigger(int dbServerVersion, DefinableMetadata trigger) {
        if (dbServerVersion >= 110000) {
            return trigger.getDefinition();
        }
        return trigger.getDefinition().replace(TRIGGER_EXECUTE, TRIGGER_EXECUTE_LEGACY);
    }

    private static String ddlDropColumn(String tableName, ColumnMetadata c) {
        return String.format("ALTER TABLE %s DROP COLUMN %s", tableName, c.getName());
    }

    private static String ddlDropConstraint(String tableName, DefinableMetadata c) {
        return String.format("ALTER TABLE %s DROP CONSTRAINT IF EXISTS %s", tableName, c.getName());
    }

    private static String ddlDropFunction(DefinableMetadata function) {
        return String.format("DROP FUNCTION IF EXISTS %s", function.getName());
    }

    private static String ddlDropIndex(DefinableMetadata index) {
        return String.format("DROP INDEX IF EXISTS %s", index.getName());
    }

    private static String ddlDropSequence(DefinableMetadata sequence) {
        return String.format("DROP SEQUENCE IF EXISTS %s", sequence.getName());
    }

    private static String ddlDropTable(TableMetadata table) {
        return String.format("DROP TABLE IF EXISTS %s", table.getName());
    }

    private static String ddlDropTrigger(String tableName, DefinableMetadata trigger) {
        return String.format("DROP TRIGGER IF EXISTS %s ON %s", trigger.getName(), tableName);
    }

    private static String ddlDropView(DefinableMetadata view) {
        return String.format("DROP VIEW IF EXISTS %s", view.getName());
    }

    private static List<String> getDDLToAddRemovedObjects(DatabaseDiffResult diff) {
        DatabaseMetadata removed = diff.getRemoved();
        ArrayList<String> toAdd = new ArrayList<String>();
        if (removed == null) {
            return toAdd;
        }
        toAdd.addAll(removed.getFunctions().values().stream().map(DefinableMetadata::getDefinition).collect(Collectors.toList()));
        toAdd.addAll(removed.getSequences().values().stream().map(DefinableMetadata::getDefinition).collect(Collectors.toList()));
        toAdd.addAll(removed.getViews().values().stream().map(PostgreSQLMetadataHandler::ddlAddView).collect(Collectors.toList()));
        toAdd.addAll(removed.getTables().values().stream().flatMap(t -> PostgreSQLMetadataHandler.ddlCreateTable(PostgreSQLMetadataHandler.getProductVersionCode(diff.getActual()), t).stream()).collect(Collectors.toList()));
        return toAdd;
    }

    private static List<String> getDDLToRemoveAddedObjects(DatabaseDiffResult diff) {
        DatabaseMetadata added = diff.getAdded();
        ArrayList<String> toRemove = new ArrayList<String>();
        if (added == null) {
            return toRemove;
        }
        toRemove.addAll(added.getSequences().values().stream().map(PostgreSQLMetadataHandler::ddlDropSequence).collect(Collectors.toList()));
        toRemove.addAll(added.getViews().values().stream().map(PostgreSQLMetadataHandler::ddlDropView).collect(Collectors.toList()));
        toRemove.addAll(added.getTables().values().stream().map(PostgreSQLMetadataHandler::ddlDropTable).collect(Collectors.toList()));
        toRemove.addAll(added.getFunctions().values().stream().map(PostgreSQLMetadataHandler::ddlDropFunction).collect(Collectors.toList()));
        return toRemove;
    }

    private static List<String> getDDLToRevertChangedObjects(DatabaseDiffResult diff) {
        DatabaseChanges changed = diff.getChanged();
        ArrayList<String> toRevert = new ArrayList<String>();
        if (changed == null) {
            return toRevert;
        }
        toRevert.addAll(changed.getFunctions().values().stream().map(DefinableMetadata::getDefinition).collect(Collectors.toList()));
        toRevert.addAll(changed.getSequences().values().stream().map(PostgreSQLMetadataHandler::ddlAlterSequence).collect(Collectors.toList()));
        toRevert.addAll(changed.getViews().values().stream().map(PostgreSQLMetadataHandler::ddlAlterView).collect(Collectors.toList()));
        toRevert.addAll(changed.getTables().values().stream().flatMap(t -> PostgreSQLMetadataHandler.ddlAlterTable(PostgreSQLMetadataHandler.getProductVersionCode(diff.getActual()), t).stream()).collect(Collectors.toList()));
        return toRevert;
    }

    private static int getProductVersionCode(DatabaseMetadata actual) {
        return actual == null ? 0 : actual.getProductVersionCode();
    }

    private static boolean isBigSerial(String tableName, ColumnMetadata c) {
        String token = String.format("nextval('%s_%s_seq'", tableName, c.getName());
        return c.getDefaultValue() != null && c.getDefaultValue().contains(token);
    }

    private static String toSerialType(String type) {
        if ("bigint".equals(type)) {
            return "bigserial";
        }
        if ("integer".equals(type)) {
            return "serial";
        }
        return "smallserial";
    }

    @Override
    public DDLGenerator ddlGenerator(DatabaseDiffResult diff) {
        return new AbstractDDLGenerator(diff){

            @Override
            public List<String> generate() {
                return PostgreSQLMetadataHandler.getDDL(this.diff, this.includeToAdd, this.includeToRemove, this.includeToRevert).stream().map(stmt -> StringUtils.appendIfMissing((String)stmt, (CharSequence)";", (CharSequence[])new CharSequence[0])).collect(Collectors.toList());
            }
        };
    }

    @Override
    protected Map<String, DefinableMetadata> extractFunctions() throws SQLException {
        String query = this.dbServerVersion >= 120000 ? FUNCTIONS_QUERY : FUNCTIONS_QUERY_LEGACY;
        List functionsAsList = this.jdbcTemplate.query(con -> {
            PreparedStatement pStmt = con.prepareStatement(query);
            pStmt.setString(1, this.options.getSchema());
            pStmt.setString(2, this.options.getIncludeFunctions());
            pStmt.setString(3, this.options.getExcludeFunctions());
            return pStmt;
        }, (RowMapper)new BeanPropertyRowMapper(DefinableMetadata.class));
        return functionsAsList.stream().collect(Collectors.toMap(NamedMetadata::getName, f -> f));
    }

    @Override
    protected int extractProductVersionCode() throws SQLException {
        return (Integer)this.jdbcTemplate.queryForObject(SERVER_VERSION_QUERY, Integer.class);
    }

    @Override
    protected Map<String, DefinableMetadata> extractSequences() throws SQLException {
        List sequencesAsList = this.jdbcTemplate.query(con -> {
            PreparedStatement pStmt = con.prepareStatement(SEQUENCES_QUERY);
            pStmt.setString(1, this.options.getSchema());
            pStmt.setString(2, this.options.getIncludeSequences());
            pStmt.setString(3, this.options.getExcludeSequences());
            return pStmt;
        }, (RowMapper)new ColumnMapRowMapper());
        return sequencesAsList.stream().map(this::toSequenceMetadata).collect(Collectors.toMap(NamedMetadata::getName, s -> s));
    }

    @Override
    protected Map<String, TableMetadata> extractTables() throws SQLException {
        List tablesAsList = this.jdbcTemplate.query(con -> {
            PreparedStatement pStmt = con.prepareStatement(TABLES_QUERY);
            pStmt.setString(1, this.options.getSchema());
            pStmt.setString(2, this.options.getIncludeTables());
            pStmt.setString(3, this.options.getExcludeTables());
            return pStmt;
        }, (RowMapper)new BeanPropertyRowMapper(TableMetadata.class));
        tablesAsList.forEach(t -> {
            List columns = this.jdbcTemplate.query(con -> {
                PreparedStatement pStmt = con.prepareStatement(TABLE_COLUMNS_QUERY);
                pStmt.setString(1, t.getName());
                return pStmt;
            }, (RowMapper)new BeanPropertyRowMapper(ColumnMetadata.class));
            t.setColumns(columns.stream().collect(Collectors.toMap(NamedMetadata::getName, c -> {
                if (c.getType().equals(DECIMAL_TYPE)) {
                    c.setType(NUMERIC_TYPE);
                }
                return c;
            })));
            try {
                PKConstraintMetadata pkConstraint = (PKConstraintMetadata)this.jdbcTemplate.queryForObject(TABLE_PK_CONSTRAINT_QUERY, (RowMapper)new BeanPropertyRowMapper(PKConstraintMetadata.class), new Object[]{t.getName()});
                t.setpKConstraint(pkConstraint);
            }
            catch (EmptyResultDataAccessException pkConstraint) {
                // empty catch block
            }
            List fkConstraints = this.jdbcTemplate.query(con -> {
                PreparedStatement pStmt = con.prepareStatement(TABLE_FK_CONSTRAINTS_QUERY);
                pStmt.setString(1, t.getName());
                return pStmt;
            }, (RowMapper)new BeanPropertyRowMapper(DefinableMetadata.class));
            t.setfKConstraints(fkConstraints.stream().collect(Collectors.toMap(NamedMetadata::getName, fk -> fk)));
            List uniqueConstraints = this.jdbcTemplate.query(con -> {
                PreparedStatement pStmt = con.prepareStatement(TABLE_UNIQUE_CONSTRAINTS_QUERY);
                pStmt.setString(1, t.getName());
                return pStmt;
            }, (RowMapper)new BeanPropertyRowMapper(DefinableMetadata.class));
            t.setUniqueConstraints(uniqueConstraints.stream().collect(Collectors.toMap(NamedMetadata::getName, u -> u)));
            List indexes = this.jdbcTemplate.query(con -> {
                PreparedStatement pStmt = con.prepareStatement(TABLE_INDEXES_QUERY);
                pStmt.setString(1, t.getName());
                return pStmt;
            }, (RowMapper)new BeanPropertyRowMapper(DefinableMetadata.class));
            t.setIndexes(indexes.stream().filter(i -> !t.getUniqueConstraints().containsKey(i.getName()) && (t.getpKConstraint() == null || !t.getpKConstraint().getName().equals(i.getName()))).collect(Collectors.toMap(NamedMetadata::getName, i -> i)));
            List triggersAsList = this.jdbcTemplate.query(con -> {
                PreparedStatement pStmt = con.prepareStatement(TABLE_TRIGGERS_QUERY);
                pStmt.setString(1, t.getName());
                return pStmt;
            }, (RowMapper)new BeanPropertyRowMapper(DefinableMetadata.class));
            t.setTriggers(triggersAsList.stream().collect(Collectors.toMap(NamedMetadata::getName, v -> {
                v.setDefinition(v.getDefinition().replace(TRIGGER_EXECUTE_LEGACY, TRIGGER_EXECUTE));
                v.setDefinition(v.getDefinition().replace(this.options.getSchema() + ".", ""));
                return v;
            })));
        });
        return tablesAsList.stream().collect(Collectors.toMap(NamedMetadata::getName, t -> t));
    }

    @Override
    protected Map<String, DefinableMetadata> extractViews() throws SQLException {
        List viewsAsList = this.jdbcTemplate.query(con -> {
            PreparedStatement pStmt = con.prepareStatement(VIEWS_QUERY);
            pStmt.setString(1, this.options.getSchema());
            pStmt.setString(2, this.options.getIncludeViews());
            pStmt.setString(3, this.options.getExcludeViews());
            return pStmt;
        }, (RowMapper)new BeanPropertyRowMapper(DefinableMetadata.class));
        return viewsAsList.stream().collect(Collectors.toMap(NamedMetadata::getName, v -> v));
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected LoadFromDatabaseOptions preprocessOptions(LoadFromDatabaseOptions options) {
        if (options.getSchema() == null) {
            options = options.schema(DEFAULT_SCHEMA);
        }
        if (options.getIncludeTables() == null) {
            options = options.includeTables("%");
        }
        if (options.getExcludeTables() == null) {
            options = options.excludeTables("");
        }
        if (options.getIncludeViews() == null) {
            options = options.includeViews("%");
        }
        if (options.getExcludeViews() == null) {
            options = options.excludeViews("");
        }
        if (options.getIncludeSequences() == null) {
            options = options.includeSequences("%");
        }
        if (options.getExcludeSequences() == null) {
            options = options.excludeSequences("");
        }
        if (options.getIncludeFunctions() == null) {
            options = options.includeFunctions("%");
        }
        if (options.getExcludeFunctions() == null) {
            options = options.excludeFunctions("");
        }
        return options;
    }

    private DefinableMetadata toSequenceMetadata(Map<String, Object> map) {
        String name = (String)map.get("name");
        int start = Integer.parseInt((String)map.get("start"));
        int minimum = Integer.parseInt((String)map.get("minimum"));
        long maximum = Long.parseLong((String)map.get("maximum"));
        int increment = Integer.parseInt((String)map.get("increment"));
        String cycle = (String)map.get("cycle");
        StringBuilder defBuilder = new StringBuilder("CREATE SEQUENCE IF NOT EXISTS " + name);
        if (increment != 1) {
            defBuilder.append(" INCREMENT BY " + increment);
        }
        if (minimum != 1) {
            defBuilder.append(" MINVALUE " + minimum);
        }
        if (maximum != Long.MAX_VALUE) {
            defBuilder.append(" MAXVALUE " + maximum);
        }
        if (start != 1) {
            defBuilder.append(" START WITH " + start);
        }
        if (!"NO".equals(cycle)) {
            defBuilder.append(" CYCLE");
        }
        DefinableMetadata metadata = new DefinableMetadata();
        metadata.setName(name);
        metadata.setDefinition(defBuilder.toString());
        return metadata;
    }
}

