/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor.impl;

import com.hazelcast.internal.tpcengine.Eventloop;
import com.hazelcast.internal.tpcengine.Scheduler;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationQueue;
import com.hazelcast.spi.impl.operationexecutor.impl.TpcPartitionOperationThread;

public class TpcOperationScheduler
implements Scheduler {
    private final int batchSize;
    private TpcPartitionOperationThread operationThread;
    private OperationQueue queue;

    public TpcOperationScheduler(int batchSize) {
        this.batchSize = Preconditions.checkPositive("batchSize", batchSize);
    }

    @Override
    public void init(Eventloop eventloop) {
        this.operationThread = (TpcPartitionOperationThread)Thread.currentThread();
        this.queue = this.operationThread.queue;
    }

    @Override
    public boolean tick() {
        TpcPartitionOperationThread operationThread0 = this.operationThread;
        OperationQueue queue0 = this.queue;
        int batchSize0 = this.batchSize;
        for (int k = 0; k < batchSize0; ++k) {
            if (operationThread0.isShutdown()) {
                return false;
            }
            Object task = queue0.poll();
            if (task == null) {
                return false;
            }
            operationThread0.process(task);
        }
        return !queue0.isEmpty();
    }

    @Override
    public void schedule(Object task) {
        throw new UnsupportedOperationException();
    }
}

