/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.locksupport.LockSupportService;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.partition.impl.NameSpaceUtil;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapKeyLoaderUtil;
import com.hazelcast.map.impl.MapMigrationAwareService;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class PartitionContainer {
    private final int partitionId;
    private final MapService mapService;
    private final ContextMutexFactory contextMutexFactory = new ContextMutexFactory();
    private final ConcurrentMap<String, RecordStore> maps;
    private final ConcurrentMap<String, Indexes> indexes = new ConcurrentHashMap<String, Indexes>();
    private final ConstructorFunction<String, RecordStore> recordStoreConstructor = name -> {
        RecordStore recordStore = this.createRecordStore((String)name);
        recordStore.startLoading();
        return recordStore;
    };
    private final ConstructorFunction<String, RecordStore> recordStoreConstructorSkipLoading = this::createRecordStore;
    private final ConstructorFunction<String, RecordStore> recordStoreConstructorForHotRestart = this::createRecordStore;
    private volatile boolean hasRunningCleanup;
    private volatile long lastCleanupTime;
    private long lastCleanupTimeCopy;

    public PartitionContainer(MapService mapService, int partitionId) {
        this.mapService = mapService;
        this.partitionId = partitionId;
        int approxMapCount = mapService.mapServiceContext.getNodeEngine().getConfig().getMapConfigs().size();
        this.maps = MapUtil.createConcurrentHashMap(approxMapCount);
    }

    private RecordStore createRecordStore(String name) {
        MapServiceContext serviceContext = this.mapService.getMapServiceContext();
        MapContainer mapContainer = serviceContext.getMapContainer(name);
        MapConfig mapConfig = mapContainer.getMapConfig();
        NodeEngine nodeEngine = serviceContext.getNodeEngine();
        IPartitionService ps = nodeEngine.getPartitionService();
        OperationService opService = nodeEngine.getOperationService();
        ExecutionService execService = nodeEngine.getExecutionService();
        HazelcastProperties hazelcastProperties = nodeEngine.getProperties();
        MapKeyLoader keyLoader = new MapKeyLoader(name, opService, ps, nodeEngine.getClusterService(), execService, mapContainer.toData(), serviceContext.getNodeWideLoadedKeyLimiter());
        keyLoader.setMaxBatch(hazelcastProperties.getInteger(ClusterProperty.MAP_LOAD_CHUNK_SIZE));
        keyLoader.setMaxSize(MapKeyLoaderUtil.getMaxSizePerNode(mapConfig.getEvictionConfig()));
        keyLoader.setHasBackup(mapConfig.getTotalBackupCount() > 0);
        keyLoader.setMapOperationProvider(serviceContext.getMapOperationProvider(name));
        if (!mapContainer.isGlobalIndexEnabled()) {
            Indexes indexesForMap = mapContainer.createIndexes(false);
            this.indexes.putIfAbsent(name, indexesForMap);
        }
        RecordStore recordStore = serviceContext.createRecordStore(mapContainer, this.partitionId, keyLoader);
        recordStore.init();
        return recordStore;
    }

    public ConcurrentMap<String, RecordStore> getMaps() {
        return this.maps;
    }

    public ConcurrentMap<String, Indexes> getIndexes() {
        return this.indexes;
    }

    public Collection<RecordStore> getAllRecordStores() {
        return this.maps.isEmpty() ? Collections.emptyList() : this.maps.values();
    }

    public Collection<ServiceNamespace> getAllNamespaces(int replicaIndex) {
        return this.getNamespaces(ignored -> true, replicaIndex);
    }

    public Collection<ServiceNamespace> getNamespaces(Predicate<MapConfig> predicate, int replicaIndex) {
        return NameSpaceUtil.getAllNamespaces(this.maps, recordStore -> {
            MapContainer mapContainer = recordStore.getMapContainer();
            MapConfig mapConfig = mapContainer.getMapConfig();
            return mapConfig.getTotalBackupCount() >= replicaIndex && predicate.test(mapConfig);
        }, recordStore -> recordStore.getMapContainer().getObjectNamespace());
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public MapService getMapService() {
        return this.mapService;
    }

    public RecordStore getRecordStore(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.maps, name, this.contextMutexFactory, this.recordStoreConstructor);
    }

    public RecordStore getRecordStore(String name, boolean skipLoadingOnCreate) {
        return ConcurrencyUtil.getOrPutSynchronized(this.maps, name, this, skipLoadingOnCreate ? this.recordStoreConstructorSkipLoading : this.recordStoreConstructor);
    }

    public RecordStore getRecordStoreForHotRestart(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.maps, name, this.contextMutexFactory, this.recordStoreConstructorForHotRestart);
    }

    @Nullable
    public RecordStore getExistingRecordStore(String mapName) {
        return (RecordStore)this.maps.get(mapName);
    }

    public void destroyMap(MapContainer mapContainer) {
        mapContainer.onBeforeDestroy();
        String name = mapContainer.getName();
        RecordStore recordStore = (RecordStore)this.maps.remove(name);
        if (recordStore != null) {
            recordStore.destroy();
        } else {
            this.clearLockStore(name);
        }
        this.indexes.remove(name);
        this.destroyMapContainer(mapContainer);
        this.mapService.mapServiceContext.removePartitioningStrategyFromCache(mapContainer.getName());
    }

    public boolean destroyMapContainer(MapContainer mapContainer) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        if (mapServiceContext.removeMapContainer(mapContainer)) {
            mapContainer.onDestroy();
            return true;
        }
        return false;
    }

    private void clearLockStore(String name) {
        NodeEngine nodeEngine = this.mapService.getMapServiceContext().getNodeEngine();
        LockSupportService lockService = (LockSupportService)nodeEngine.getServiceOrNull("hz:impl:lockService");
        if (lockService != null) {
            ObjectNamespace namespace = MapService.getObjectNamespace(name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
    }

    public boolean hasRunningCleanup() {
        return this.hasRunningCleanup;
    }

    public void setHasRunningCleanup(boolean hasRunningCleanup) {
        this.hasRunningCleanup = hasRunningCleanup;
    }

    public long getLastCleanupTime() {
        return this.lastCleanupTime;
    }

    public void setLastCleanupTime(long lastCleanupTime) {
        this.lastCleanupTime = lastCleanupTime;
    }

    public long getLastCleanupTimeCopy() {
        return this.lastCleanupTimeCopy;
    }

    public void setLastCleanupTimeCopy(long lastCleanupTimeCopy) {
        this.lastCleanupTimeCopy = lastCleanupTimeCopy;
    }

    final void cleanUpOnMigration(int replicaIndex) {
        this.mapService.getMapServiceContext().getMapContainers().entrySet().stream().filter(entry -> replicaIndex == -1 || MapMigrationAwareService.lesserBackupMapsThenWithContainer(replicaIndex).test((MapContainer)entry.getValue())).forEach(entry -> this.cleanUpMap((String)entry.getKey()));
    }

    protected void cleanUpMap(String mapName) {
    }

    Indexes getIndexes(String name) {
        Indexes ixs = (Indexes)this.indexes.get(name);
        if (ixs == null) {
            MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
            MapContainer mapContainer = mapServiceContext.getMapContainer(name);
            if (mapContainer.isGlobalIndexEnabled()) {
                throw new IllegalStateException("Can't use a partitioned-index in the context of a global-index.");
            }
            Indexes indexesForMap = mapContainer.createIndexes(false);
            ixs = this.indexes.putIfAbsent(name, indexesForMap);
            if (ixs == null) {
                ixs = indexesForMap;
            }
        }
        return ixs;
    }
}

