/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.ClientBwListConfigHandler;
import com.hazelcast.internal.management.ConsoleCommandHandler;
import com.hazelcast.internal.management.ManagementCenterEventListener;
import com.hazelcast.internal.management.TimedMemberState;
import com.hazelcast.internal.management.TimedMemberStateFactory;
import com.hazelcast.internal.management.dto.ClientBwListDTO;
import com.hazelcast.internal.management.dto.MCEventDTO;
import com.hazelcast.internal.management.events.Event;
import com.hazelcast.internal.metrics.managementcenter.ConcurrentArrayRingbuffer;
import com.hazelcast.internal.util.executor.ExecutorType;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;

public class ManagementCenterService {
    public static final String SERVICE_NAME = "hz:core:managementCenterService";
    private static final int MIN_EVENT_QUEUE_CAPACITY = 1000;
    private static final int EXECUTOR_QUEUE_CAPACITY_PER_THREAD = 1000;
    private static final long TMS_CACHE_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private final HazelcastInstanceImpl instance;
    private final ILogger logger;
    private final AtomicReference<String> tmsJson = new AtomicReference();
    private final TimedMemberStateFactory tmsFactory;
    private final AtomicBoolean tmsFactoryInitialized = new AtomicBoolean(false);
    private final ConsoleCommandHandler commandHandler;
    private final ClientBwListConfigHandler bwListConfigHandler;
    private final MCEventStore eventStore;
    private volatile ManagementCenterEventListener eventListener;
    private volatile String lastMCConfigETag;
    private volatile long lastTMSUpdateNanos;

    public ManagementCenterService(HazelcastInstanceImpl instance) {
        this(instance, System::nanoTime);
    }

    public ManagementCenterService(HazelcastInstanceImpl instance, LongSupplier clock) {
        this.instance = instance;
        this.logger = instance.node.getLogger(ManagementCenterService.class);
        this.tmsFactory = instance.node.getNodeExtension().createTimedMemberStateFactory(instance);
        int partitionCount = instance.node.getPartitionService().getPartitionCount();
        this.commandHandler = new ConsoleCommandHandler(instance);
        this.bwListConfigHandler = new ClientBwListConfigHandler(instance.node.clientEngine);
        this.eventStore = new MCEventStore(clock, new ConcurrentArrayRingbuffer<MCEventDTO>(Math.max(1000, partitionCount)), this.logger);
        this.registerExecutor();
    }

    private void registerExecutor() {
        ExecutionService executionService = this.instance.node.nodeEngine.getExecutionService();
        int threadCount = this.instance.node.getProperties().getInteger(ClusterProperty.MC_EXECUTOR_THREAD_COUNT);
        this.logger.finest("Creating new executor for Management Center service tasks with threadCount=" + threadCount);
        executionService.register("hz:mc", threadCount, threadCount * 1000, ExecutorType.CACHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Optional<String> getTimedMemberStateJson() {
        if (this.tmsFactoryInitialized.compareAndSet(false, true)) {
            this.tmsFactory.init();
        }
        if (System.nanoTime() - this.lastTMSUpdateNanos <= TMS_CACHE_TIMEOUT_NANOS) {
            return Optional.ofNullable(this.tmsJson.get());
        }
        try {
            TimedMemberState tms;
            TimedMemberStateFactory timedMemberStateFactory = this.tmsFactory;
            synchronized (timedMemberStateFactory) {
                tms = this.tmsFactory.createTimedMemberState();
                this.lastTMSUpdateNanos = System.nanoTime();
            }
            JsonObject json = new JsonObject();
            json.add("timedMemberState", tms.toJson());
            this.tmsJson.set(json.toString());
        }
        catch (Throwable e) {
            if (e instanceof RetryableException) {
                this.logger.warning("Failed to create TimedMemberState. Will try again on next request from Management Center.");
            }
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(e);
        }
        return Optional.ofNullable(this.tmsJson.get());
    }

    public void log(Event event) {
        this.eventStore.log(event);
        if (this.eventListener != null) {
            this.eventListener.onEventLogged(event);
        }
    }

    void onMCEventWindowExceeded() {
        this.eventStore.onMCEventWindowExceeded();
    }

    public void setEventListener(ManagementCenterEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Nonnull
    public List<MCEventDTO> pollMCEvents(UUID clientUuid) {
        return this.eventStore.pollMCEvents(clientUuid);
    }

    void clear() {
        this.eventStore.onMCEventWindowExceeded();
    }

    public String runConsoleCommand(String command) throws InterruptedException {
        return this.commandHandler.handleCommand(command);
    }

    public String getLastMCConfigETag() {
        return this.lastMCConfigETag;
    }

    public void applyMCConfig(String eTag, ClientBwListDTO bwListConfig) {
        if (eTag.equals(this.lastMCConfigETag)) {
            this.logger.warning("Client B/W list filtering config with the same ETag is already applied.");
            return;
        }
        try {
            this.bwListConfigHandler.applyConfig(bwListConfig);
            this.lastMCConfigETag = eTag;
        }
        catch (Exception e) {
            this.logger.warning("Could not apply client B/W list filtering config.", e);
            throw new HazelcastException("Error while applying MC config", e);
        }
    }

    static class MCEventStore {
        static final long MC_EVENTS_WINDOW_NANOS = TimeUnit.SECONDS.toNanos(30L);
        static final long MC_DISAPPEARED_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(120L);
        private final LongSupplier nanoClock;
        private volatile long lastMCEventsPollTimestamp;
        private volatile long lastCleanupTimestamp;
        private final ConcurrentMap<UUID, LastPollRecord> lastPollRecordPerMC = new ConcurrentHashMap<UUID, LastPollRecord>();
        private final ConcurrentArrayRingbuffer<MCEventDTO> mcEvents;
        private final ILogger logger;

        MCEventStore(LongSupplier nanoClock, ConcurrentArrayRingbuffer<MCEventDTO> mcEvents, ILogger logger) {
            this.nanoClock = nanoClock;
            this.lastCleanupTimestamp = this.lastMCEventsPollTimestamp = nanoClock.getAsLong();
            this.mcEvents = mcEvents;
            this.logger = logger;
        }

        void log(Event event) {
            if (this.nanoClock.getAsLong() - this.lastMCEventsPollTimestamp > MC_EVENTS_WINDOW_NANOS) {
                this.onMCEventWindowExceeded();
            } else {
                this.mcEvents.add(MCEventDTO.fromEvent(event));
                this.cleanUpLastAccessRecords();
            }
        }

        private static boolean isOutOfTimeWindow(long nowInMillis, long subjectTimestampInMillis, long timeWindowLength) {
            return nowInMillis - subjectTimestampInMillis > timeWindowLength;
        }

        private void cleanUpLastAccessRecords() {
            long now = this.nanoClock.getAsLong();
            if (!MCEventStore.isOutOfTimeWindow(now, this.lastCleanupTimestamp, MC_EVENTS_WINDOW_NANOS)) {
                return;
            }
            this.lastPollRecordPerMC.entrySet().removeIf(entry -> MCEventStore.isOutOfTimeWindow(now, ((LastPollRecord)entry.getValue()).lastAccessTime, MC_DISAPPEARED_INTERVAL_NANOS));
            this.lastCleanupTimestamp = now;
        }

        void onMCEventWindowExceeded() {
            this.mcEvents.clear();
            this.lastPollRecordPerMC.clear();
        }

        public List<MCEventDTO> pollMCEvents(UUID mcClientUuid) {
            this.lastMCEventsPollTimestamp = this.nanoClock.getAsLong();
            LastPollRecord lastPollRecord = (LastPollRecord)this.lastPollRecordPerMC.get(mcClientUuid);
            long sequence = lastPollRecord == null ? 0L : lastPollRecord.nextSequence;
            try {
                ConcurrentArrayRingbuffer.RingbufferSlice<MCEventDTO> slice = this.mcEvents.copyFrom(sequence);
                this.lastPollRecordPerMC.put(mcClientUuid, new LastPollRecord(this.lastMCEventsPollTimestamp, slice.nextSequence()));
                return slice.elements();
            }
            catch (IllegalArgumentException e) {
                this.logger.severe("failed to read events for MC " + mcClientUuid + " from sequence " + sequence, e);
                return Collections.emptyList();
            }
        }

        static class LastPollRecord {
            final long lastAccessTime;
            final long nextSequence;

            LastPollRecord(long lastAccessTime, long nextSequence) {
                this.lastAccessTime = lastAccessTime;
                this.nextSequence = nextSequence;
            }
        }
    }
}

