/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.utils.queryextensions;

import com.querydsl.core.annotations.QueryDelegate;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.DateTimePath;
import java.util.Date;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.model.banking.vouchers.VoucherPackVO;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.MethodHelper;

public class VoucherQueryExtensions {
    @QueryDelegate(value=Voucher.class)
    public static DateTimeExpression<Date> currentExpiration(EntityPath<Voucher> entityPath) {
        DateTimePath dateTimePath = (DateTimePath)FieldHelper.get(entityPath, (String)VoucherVO.EXPIRATION_DATE.getName());
        EntityPath entityPath2 = (EntityPath)MethodHelper.invoke(entityPath, (String)VoucherVO.PACK.getName(), (Object[])new Object[0]);
        DateTimePath dateTimePath2 = (DateTimePath)FieldHelper.get((Object)entityPath2, (String)VoucherPackVO.EXPIRATION_DATE.getName());
        return dateTimePath.coalesce(new Expression[]{dateTimePath2}).asDateTime();
    }

    @QueryDelegate(value=Voucher.class)
    public static Predicate currentExpirationInPeriod(EntityPath<Voucher> entityPath, DatePeriod datePeriod) {
        return VoucherQueryExtensions.currentExpiration(entityPath).between((Comparable)datePeriod.getBegin(), (Comparable)datePeriod.getEnd());
    }
}

