/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.DirectWizard;
import org.cyclos.entities.users.PrivacyControl;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductUserAccessClient;
import org.cyclos.entities.users.ProductUserAdField;
import org.cyclos.entities.users.ProductUserContactField;
import org.cyclos.entities.users.ProductUserRecordType;
import org.cyclos.entities.users.ProductUserTokenType;
import org.cyclos.entities.users.UserProductPasswordAction;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
public abstract class UserManagementProduct
extends Product
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<UserProductPasswordAction> userPasswordActions = new HashSet<UserProductPasswordAction>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductUserRecordType> userRecordTypes = new HashSet<ProductUserRecordType>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ProductUserContactField> userContactFields = new HashSet<ProductUserContactField>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductUserTokenType> userTokenTypes = new HashSet<ProductUserTokenType>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductUserAdField> userAdFields = new HashSet<ProductUserAdField>();
    @ManyToMany
    @JoinTable(name="products_payment_types_as_user", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> paymentsAsUser = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_request_payment_types_as_user", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> requestPaymentsAsUser = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_external_payment_types_as_user", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> externalPaymentsAsUser = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_ticket_types_as_user", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> createTicketsAsUser = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_account_access", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="account_type_id")})
    private Set<UserAccountType> userAccountsAccess = new HashSet<UserAccountType>();
    @ManyToMany
    @JoinTable(name="products_document_categories_manage", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="document_category_id")})
    private Set<DocumentCategory> documentCategoryManage = new HashSet<DocumentCategory>();
    @ManyToMany
    @JoinTable(name="products_user_chargebacks", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_type_id")})
    private Set<TransferType> chargebackPaymentsToUser = new HashSet<TransferType>();
    @ManyToMany
    @JoinTable(name="products_user_transfer_filters", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_filter_id")})
    private Set<TransferFilter> userTransferFilters = new HashSet<TransferFilter>();
    @ManyToMany
    @JoinTable(name="products_user_custom_operations", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="custom_operation_id")})
    private Set<CustomOperation> userCustomOperationsRun = new HashSet<CustomOperation>();
    @ManyToMany
    @JoinTable(name="products_user_custom_wizards", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="wizard_id")})
    private Set<DirectWizard> userWizards = new HashSet<DirectWizard>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductUserAccessClient> userAccessClients = new HashSet<ProductUserAccessClient>();
    @ManyToMany
    @JoinTable(name="products_privacy_controls", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="privacy_control_id")})
    private Set<PrivacyControl> privacyControls = new HashSet<PrivacyControl>();
    @Basic
    @Column(name="include_balances_in_export_users_csv")
    private Boolean includeBalancesInExportUsersCSV;
    static final long serialVersionUID = -1483966367468954063L;

    public Set<TransferType> getChargebackPaymentsToUser() {
        return this._persistence_get_chargebackPaymentsToUser();
    }

    public Set<PaymentTransferType> getCreateTicketsAsUser() {
        return this._persistence_get_createTicketsAsUser();
    }

    public Set<DocumentCategory> getDocumentCategoryManage() {
        return this._persistence_get_documentCategoryManage();
    }

    public Set<PaymentTransferType> getExternalPaymentsAsUser() {
        return this._persistence_get_externalPaymentsAsUser();
    }

    public Set<PaymentTransferType> getPaymentsAsUser() {
        return this._persistence_get_paymentsAsUser();
    }

    public Set<PrivacyControl> getPrivacyControls() {
        return this._persistence_get_privacyControls();
    }

    public Set<PaymentTransferType> getRequestPaymentsAsUser() {
        return this._persistence_get_requestPaymentsAsUser();
    }

    public Set<PaymentTransferType> getSelfPaymentsAsUser() {
        return this.filterPaymentTypes(this._persistence_get_paymentsAsUser(), TransferTypeDirection.USER_TO_SELF);
    }

    public Set<PaymentTransferType> getSystemPaymentsAsUser() {
        return this.filterPaymentTypes(this._persistence_get_paymentsAsUser(), TransferTypeDirection.USER_TO_SYSTEM);
    }

    public Set<ProductUserAccessClient> getUserAccessClients() {
        return this._persistence_get_userAccessClients();
    }

    public Set<UserAccountType> getUserAccountsAccess() {
        return this._persistence_get_userAccountsAccess();
    }

    public Set<ProductUserAdField> getUserAdFields() {
        return this._persistence_get_userAdFields();
    }

    public Set<ProductUserContactField> getUserContactFields() {
        return this._persistence_get_userContactFields();
    }

    public Set<CustomOperation> getUserCustomOperationsRun() {
        return this._persistence_get_userCustomOperationsRun();
    }

    public Set<UserProductPasswordAction> getUserPasswordActions() {
        return this._persistence_get_userPasswordActions();
    }

    public Set<PaymentTransferType> getUserPaymentRequestsSendToSystem() {
        return this.filterPaymentTypes(this._persistence_get_requestPaymentsAsUser(), TransferTypeDirection.SYSTEM_TO_USER);
    }

    public Set<PaymentTransferType> getUserPaymentRequestsSendToUser() {
        return this.filterPaymentTypes(this._persistence_get_requestPaymentsAsUser(), TransferTypeDirection.USER_TO_USER);
    }

    public Set<PaymentTransferType> getUserPaymentsAsUser() {
        return this.filterPaymentTypes(this._persistence_get_paymentsAsUser(), TransferTypeDirection.USER_TO_USER);
    }

    public Set<ProductUserRecordType> getUserRecordTypes() {
        return this._persistence_get_userRecordTypes();
    }

    public Set<ProductUserTokenType> getUserTokenTypes() {
        return this._persistence_get_userTokenTypes();
    }

    public Set<TransferFilter> getUserTransferFilters() {
        return this._persistence_get_userTransferFilters();
    }

    public Set<DirectWizard> getUserWizards() {
        return this._persistence_get_userWizards();
    }

    public boolean isIncludeBalancesInExportUsersCSV() {
        return this._persistence_get_includeBalancesInExportUsersCSV() == null ? false : this._persistence_get_includeBalancesInExportUsersCSV();
    }

    public void setChargebackPaymentsToUser(Set<TransferType> set) {
        this._persistence_set_chargebackPaymentsToUser(set);
    }

    public void setCreateTicketsAsUser(Set<PaymentTransferType> set) {
        this._persistence_set_createTicketsAsUser(set);
    }

    public void setDocumentCategoryManage(Set<DocumentCategory> set) {
        this._persistence_set_documentCategoryManage(set);
    }

    public void setExternalPaymentsAsUser(Set<PaymentTransferType> set) {
        this._persistence_set_externalPaymentsAsUser(set);
    }

    public void setIncludeBalancesInExportUsersCSV(boolean bl) {
        this._persistence_set_includeBalancesInExportUsersCSV(bl);
    }

    public void setPaymentsAsUser(Set<PaymentTransferType> set) {
        this._persistence_set_paymentsAsUser(set);
    }

    public void setPrivacyControls(Set<PrivacyControl> set) {
        this._persistence_set_privacyControls(set);
    }

    public void setRequestPaymentsAsUser(Set<PaymentTransferType> set) {
        this._persistence_set_requestPaymentsAsUser(set);
    }

    public void setUserAccessClients(Set<ProductUserAccessClient> set) {
        this._persistence_set_userAccessClients(set);
    }

    public void setUserAccountsAccess(Set<UserAccountType> set) {
        this._persistence_set_userAccountsAccess(set);
    }

    public void setUserAdFields(Set<ProductUserAdField> set) {
        this._persistence_set_userAdFields(set);
    }

    public void setUserContactFields(Set<ProductUserContactField> set) {
        this._persistence_set_userContactFields(set);
    }

    public void setUserCustomOperationsRun(Set<CustomOperation> set) {
        this._persistence_set_userCustomOperationsRun(set);
    }

    public void setUserPasswordActions(Set<UserProductPasswordAction> set) {
        this._persistence_set_userPasswordActions(set);
    }

    public void setUserRecordTypes(Set<ProductUserRecordType> set) {
        this._persistence_set_userRecordTypes(set);
    }

    public void setUserTokenTypes(Set<ProductUserTokenType> set) {
        this._persistence_set_userTokenTypes(set);
    }

    public void setUserTransferFilters(Set<TransferFilter> set) {
        this._persistence_set_userTransferFilters(set);
    }

    public void setUserWizards(Set<DirectWizard> set) {
        this._persistence_set_userWizards(set);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new UserManagementProduct();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "requestPaymentsAsUser") {
            return this.requestPaymentsAsUser;
        }
        if (string == "externalPaymentsAsUser") {
            return this.externalPaymentsAsUser;
        }
        if (string == "userAdFields") {
            return this.userAdFields;
        }
        if (string == "createTicketsAsUser") {
            return this.createTicketsAsUser;
        }
        if (string == "userWizards") {
            return this.userWizards;
        }
        if (string == "userPasswordActions") {
            return this.userPasswordActions;
        }
        if (string == "privacyControls") {
            return this.privacyControls;
        }
        if (string == "userTokenTypes") {
            return this.userTokenTypes;
        }
        if (string == "paymentsAsUser") {
            return this.paymentsAsUser;
        }
        if (string == "userTransferFilters") {
            return this.userTransferFilters;
        }
        if (string == "userCustomOperationsRun") {
            return this.userCustomOperationsRun;
        }
        if (string == "userAccessClients") {
            return this.userAccessClients;
        }
        if (string == "userRecordTypes") {
            return this.userRecordTypes;
        }
        if (string == "documentCategoryManage") {
            return this.documentCategoryManage;
        }
        if (string == "userContactFields") {
            return this.userContactFields;
        }
        if (string == "includeBalancesInExportUsersCSV") {
            return this.includeBalancesInExportUsersCSV;
        }
        if (string == "userAccountsAccess") {
            return this.userAccountsAccess;
        }
        if (string == "chargebackPaymentsToUser") {
            return this.chargebackPaymentsToUser;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "requestPaymentsAsUser") {
            this.requestPaymentsAsUser = (Set)object;
            return;
        }
        if (string == "externalPaymentsAsUser") {
            this.externalPaymentsAsUser = (Set)object;
            return;
        }
        if (string == "userAdFields") {
            this.userAdFields = (Set)object;
            return;
        }
        if (string == "createTicketsAsUser") {
            this.createTicketsAsUser = (Set)object;
            return;
        }
        if (string == "userWizards") {
            this.userWizards = (Set)object;
            return;
        }
        if (string == "userPasswordActions") {
            this.userPasswordActions = (Set)object;
            return;
        }
        if (string == "privacyControls") {
            this.privacyControls = (Set)object;
            return;
        }
        if (string == "userTokenTypes") {
            this.userTokenTypes = (Set)object;
            return;
        }
        if (string == "paymentsAsUser") {
            this.paymentsAsUser = (Set)object;
            return;
        }
        if (string == "userTransferFilters") {
            this.userTransferFilters = (Set)object;
            return;
        }
        if (string == "userCustomOperationsRun") {
            this.userCustomOperationsRun = (Set)object;
            return;
        }
        if (string == "userAccessClients") {
            this.userAccessClients = (Set)object;
            return;
        }
        if (string == "userRecordTypes") {
            this.userRecordTypes = (Set)object;
            return;
        }
        if (string == "documentCategoryManage") {
            this.documentCategoryManage = (Set)object;
            return;
        }
        if (string == "userContactFields") {
            this.userContactFields = (Set)object;
            return;
        }
        if (string == "includeBalancesInExportUsersCSV") {
            this.includeBalancesInExportUsersCSV = (Boolean)object;
            return;
        }
        if (string == "userAccountsAccess") {
            this.userAccountsAccess = (Set)object;
            return;
        }
        if (string == "chargebackPaymentsToUser") {
            this.chargebackPaymentsToUser = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_requestPaymentsAsUser() {
        this._persistence_checkFetched("requestPaymentsAsUser");
        return this.requestPaymentsAsUser;
    }

    public void _persistence_set_requestPaymentsAsUser(Set set) {
        this._persistence_checkFetchedForSet("requestPaymentsAsUser");
        this._persistence_propertyChange("requestPaymentsAsUser", this.requestPaymentsAsUser, set);
        this.requestPaymentsAsUser = set;
    }

    public Set _persistence_get_externalPaymentsAsUser() {
        this._persistence_checkFetched("externalPaymentsAsUser");
        return this.externalPaymentsAsUser;
    }

    public void _persistence_set_externalPaymentsAsUser(Set set) {
        this._persistence_checkFetchedForSet("externalPaymentsAsUser");
        this._persistence_propertyChange("externalPaymentsAsUser", this.externalPaymentsAsUser, set);
        this.externalPaymentsAsUser = set;
    }

    public Set _persistence_get_userAdFields() {
        this._persistence_checkFetched("userAdFields");
        return this.userAdFields;
    }

    public void _persistence_set_userAdFields(Set set) {
        this._persistence_checkFetchedForSet("userAdFields");
        this._persistence_propertyChange("userAdFields", this.userAdFields, set);
        this.userAdFields = set;
    }

    public Set _persistence_get_createTicketsAsUser() {
        this._persistence_checkFetched("createTicketsAsUser");
        return this.createTicketsAsUser;
    }

    public void _persistence_set_createTicketsAsUser(Set set) {
        this._persistence_checkFetchedForSet("createTicketsAsUser");
        this._persistence_propertyChange("createTicketsAsUser", this.createTicketsAsUser, set);
        this.createTicketsAsUser = set;
    }

    public Set _persistence_get_userWizards() {
        this._persistence_checkFetched("userWizards");
        return this.userWizards;
    }

    public void _persistence_set_userWizards(Set set) {
        this._persistence_checkFetchedForSet("userWizards");
        this._persistence_propertyChange("userWizards", this.userWizards, set);
        this.userWizards = set;
    }

    public Set _persistence_get_userPasswordActions() {
        this._persistence_checkFetched("userPasswordActions");
        return this.userPasswordActions;
    }

    public void _persistence_set_userPasswordActions(Set set) {
        this._persistence_checkFetchedForSet("userPasswordActions");
        this._persistence_propertyChange("userPasswordActions", this.userPasswordActions, set);
        this.userPasswordActions = set;
    }

    public Set _persistence_get_privacyControls() {
        this._persistence_checkFetched("privacyControls");
        return this.privacyControls;
    }

    public void _persistence_set_privacyControls(Set set) {
        this._persistence_checkFetchedForSet("privacyControls");
        this._persistence_propertyChange("privacyControls", this.privacyControls, set);
        this.privacyControls = set;
    }

    public Set _persistence_get_userTokenTypes() {
        this._persistence_checkFetched("userTokenTypes");
        return this.userTokenTypes;
    }

    public void _persistence_set_userTokenTypes(Set set) {
        this._persistence_checkFetchedForSet("userTokenTypes");
        this._persistence_propertyChange("userTokenTypes", this.userTokenTypes, set);
        this.userTokenTypes = set;
    }

    public Set _persistence_get_paymentsAsUser() {
        this._persistence_checkFetched("paymentsAsUser");
        return this.paymentsAsUser;
    }

    public void _persistence_set_paymentsAsUser(Set set) {
        this._persistence_checkFetchedForSet("paymentsAsUser");
        this._persistence_propertyChange("paymentsAsUser", this.paymentsAsUser, set);
        this.paymentsAsUser = set;
    }

    public Set _persistence_get_userTransferFilters() {
        this._persistence_checkFetched("userTransferFilters");
        return this.userTransferFilters;
    }

    public void _persistence_set_userTransferFilters(Set set) {
        this._persistence_checkFetchedForSet("userTransferFilters");
        this._persistence_propertyChange("userTransferFilters", this.userTransferFilters, set);
        this.userTransferFilters = set;
    }

    public Set _persistence_get_userCustomOperationsRun() {
        this._persistence_checkFetched("userCustomOperationsRun");
        return this.userCustomOperationsRun;
    }

    public void _persistence_set_userCustomOperationsRun(Set set) {
        this._persistence_checkFetchedForSet("userCustomOperationsRun");
        this._persistence_propertyChange("userCustomOperationsRun", this.userCustomOperationsRun, set);
        this.userCustomOperationsRun = set;
    }

    public Set _persistence_get_userAccessClients() {
        this._persistence_checkFetched("userAccessClients");
        return this.userAccessClients;
    }

    public void _persistence_set_userAccessClients(Set set) {
        this._persistence_checkFetchedForSet("userAccessClients");
        this._persistence_propertyChange("userAccessClients", this.userAccessClients, set);
        this.userAccessClients = set;
    }

    public Set _persistence_get_userRecordTypes() {
        this._persistence_checkFetched("userRecordTypes");
        return this.userRecordTypes;
    }

    public void _persistence_set_userRecordTypes(Set set) {
        this._persistence_checkFetchedForSet("userRecordTypes");
        this._persistence_propertyChange("userRecordTypes", this.userRecordTypes, set);
        this.userRecordTypes = set;
    }

    public Set _persistence_get_documentCategoryManage() {
        this._persistence_checkFetched("documentCategoryManage");
        return this.documentCategoryManage;
    }

    public void _persistence_set_documentCategoryManage(Set set) {
        this._persistence_checkFetchedForSet("documentCategoryManage");
        this._persistence_propertyChange("documentCategoryManage", this.documentCategoryManage, set);
        this.documentCategoryManage = set;
    }

    public Set _persistence_get_userContactFields() {
        this._persistence_checkFetched("userContactFields");
        return this.userContactFields;
    }

    public void _persistence_set_userContactFields(Set set) {
        this._persistence_checkFetchedForSet("userContactFields");
        this._persistence_propertyChange("userContactFields", this.userContactFields, set);
        this.userContactFields = set;
    }

    public Boolean _persistence_get_includeBalancesInExportUsersCSV() {
        this._persistence_checkFetched("includeBalancesInExportUsersCSV");
        return this.includeBalancesInExportUsersCSV;
    }

    public void _persistence_set_includeBalancesInExportUsersCSV(Boolean bl) {
        this._persistence_checkFetchedForSet("includeBalancesInExportUsersCSV");
        this._persistence_propertyChange("includeBalancesInExportUsersCSV", this.includeBalancesInExportUsersCSV, bl);
        this.includeBalancesInExportUsersCSV = bl;
    }

    public Set _persistence_get_userAccountsAccess() {
        this._persistence_checkFetched("userAccountsAccess");
        return this.userAccountsAccess;
    }

    public void _persistence_set_userAccountsAccess(Set set) {
        this._persistence_checkFetchedForSet("userAccountsAccess");
        this._persistence_propertyChange("userAccountsAccess", this.userAccountsAccess, set);
        this.userAccountsAccess = set;
    }

    public Set _persistence_get_chargebackPaymentsToUser() {
        this._persistence_checkFetched("chargebackPaymentsToUser");
        return this.chargebackPaymentsToUser;
    }

    public void _persistence_set_chargebackPaymentsToUser(Set set) {
        this._persistence_checkFetchedForSet("chargebackPaymentsToUser");
        this._persistence_propertyChange("chargebackPaymentsToUser", this.chargebackPaymentsToUser, set);
        this.chargebackPaymentsToUser = set;
    }
}

