/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.system.CustomFieldValueFile;
import org.cyclos.entities.system.CustomFieldValueImage;
import org.cyclos.entities.system.DynamicFieldValue;
import org.cyclos.entities.system.ExternalRedirectExecution;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldPossibleValue;
import org.cyclos.entities.users.UserCustomFieldPossibleValueCategory;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="user_custom_field_values", uniqueConstraints={@UniqueConstraint(columnNames={"owner_id", "field_id"})}, indexes={@Index(name="ix_user_custom_field_values_string", columnList="lower(string_value)"), @Index(name="ix_user_custom_field_values_linked_entity_id", columnList="linked_entity_id")})
public class UserCustomFieldValue
extends CustomFieldValue<UserCustomField, UserCustomFieldPossibleValueCategory, UserCustomFieldPossibleValue, BasicUser>
implements UserPrincipal,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="field_id", nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private UserCustomField field;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="owner_id", nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private BasicUser owner;
    @Basic
    @Column(name="hidden", nullable=false)
    private boolean hidden;
    @ManyToMany
    @JoinTable(name="user_enum_values", joinColumns={@JoinColumn(name="owner_id")}, inverseJoinColumns={@JoinColumn(name="possible_value_id")})
    private Set<UserCustomFieldPossibleValue> enumeratedValues = new TreeSet<UserCustomFieldPossibleValue>();
    @ElementCollection
    @Embedded
    @CollectionTable(name="user_dyna_values", joinColumns={@JoinColumn(name="owner_id")}, indexes={@Index(name="ix_user_dyna_values_value", columnList="lower(value)")}, uniqueConstraints={@UniqueConstraint(columnNames={"owner_id", "value"})})
    private Set<DynamicFieldValue> dynamicValues = new HashSet<DynamicFieldValue>();
    @ManyToOne
    @JoinColumn(name="enum_value_id")
    private UserCustomFieldPossibleValue enumeratedValue;
    @OneToMany(mappedBy="customFieldValue", cascade={CascadeType.REMOVE})
    private Set<Session> sessions;
    @OneToMany(mappedBy="customFieldValue", cascade={CascadeType.REMOVE})
    private Set<OidcAuthorization> oidcAuthorization;
    @OneToMany(mappedBy="userCustomFieldvalue", cascade={CascadeType.REMOVE})
    private Set<Pin> pins;
    @OneToMany(mappedBy="customFieldValue", cascade={CascadeType.REMOVE})
    private Set<UserIdentityProvider> userIdentityProviders;
    @OneToMany(mappedBy="customFieldValue", cascade={CascadeType.REMOVE})
    private Set<ExternalRedirectExecution> externalRedirectExecutions;
    @OneToMany(mappedBy="userValue")
    @OrderBy(value="order, lastModified")
    private List<CustomFieldValueFile> fileValues = new ArrayList<CustomFieldValueFile>();
    @OneToMany(mappedBy="userValue")
    @OrderBy(value="order, lastModified")
    private List<CustomFieldValueImage> imageValues = new ArrayList<CustomFieldValueImage>();
    static final long serialVersionUID = -7440582400474281691L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_owner_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_field_vh;

    public UserCustomFieldValue() {
    }

    public UserCustomFieldValue(BasicUser basicUser, UserCustomField userCustomField) {
        this.owner = basicUser;
        this.field = userCustomField;
    }

    @Override
    public AccessClient getAccessClient() {
        return null;
    }

    @Override
    public UserAccountType getAccountType() {
        return null;
    }

    @Override
    public BasicUser getBasicUser() {
        return this._persistence_get_owner();
    }

    @Override
    public Class<UserCustomField> getCustomFieldClass() {
        return UserCustomField.class;
    }

    @Override
    public UserCustomFieldValue getCustomFieldValue() {
        return this;
    }

    public Set<DynamicFieldValue> getDynamicValues() {
        return this._persistence_get_dynamicValues();
    }

    @Override
    public UserCustomFieldPossibleValue getEnumeratedValue() {
        return this._persistence_get_enumeratedValue();
    }

    @Override
    public Set<UserCustomFieldPossibleValue> getEnumeratedValues() {
        return this._persistence_get_enumeratedValues();
    }

    @Override
    public UserCustomField getField() {
        return this._persistence_get_field();
    }

    @Override
    public List<CustomFieldValueFile> getFileValues() {
        return this._persistence_get_fileValues();
    }

    @Override
    public List<CustomFieldValueImage> getImageValues() {
        return this._persistence_get_imageValues();
    }

    @Override
    public MobilePhone getMobilePhone() {
        return null;
    }

    @Override
    public BasicUser getOwner() {
        return this._persistence_get_owner();
    }

    @Override
    public Class<UserCustomFieldPossibleValue> getPossibleValueClass() {
        return UserCustomFieldPossibleValue.class;
    }

    @Override
    public String getPrincipal() {
        String string = this._persistence_get_field().getPattern();
        if (StringHelper.isNotBlank((Object)string)) {
            return MaskHelper.applyMask((String)string, (String)this.getStringValue());
        }
        return (String)ObjectHelper.defaultValue((Object)this.getStringValue(), (Object)StringHelper.trimToNull((Object)this.getIntegerValue()));
    }

    @Override
    public PrincipalType getPrincipalType() {
        return this._persistence_get_field().getPrincipalType();
    }

    @Override
    public Token getToken() {
        return null;
    }

    @Override
    public TrustedDevice getTrustedDevice() {
        return null;
    }

    public boolean isHidden() {
        return this._persistence_get_hidden();
    }

    public void setDynamicValues(Set<DynamicFieldValue> set) {
        this._persistence_set_dynamicValues(set);
    }

    @Override
    public void setEnumeratedValue(UserCustomFieldPossibleValue userCustomFieldPossibleValue) {
        this._persistence_set_enumeratedValue(userCustomFieldPossibleValue);
    }

    @Override
    public void setEnumeratedValues(Set<UserCustomFieldPossibleValue> set) {
        this._persistence_set_enumeratedValues(set);
    }

    @Override
    public void setField(UserCustomField userCustomField) {
        this._persistence_set_field(userCustomField);
    }

    @Override
    public void setFileValues(List<CustomFieldValueFile> list) {
        this._persistence_set_fileValues(list);
    }

    public void setHidden(boolean bl) {
        this._persistence_set_hidden(bl);
    }

    @Override
    public void setImageValues(List<CustomFieldValueImage> list) {
        this._persistence_set_imageValues(list);
    }

    @Override
    public void setOwner(BasicUser basicUser) {
        this._persistence_set_owner(basicUser);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_owner_vh != null) {
            this._persistence_owner_vh = (WeavedAttributeValueHolderInterface)this._persistence_owner_vh.clone();
        }
        if (this._persistence_field_vh != null) {
            this._persistence_field_vh = (WeavedAttributeValueHolderInterface)this._persistence_field_vh.clone();
        }
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new UserCustomFieldValue();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "owner") {
            return this.owner;
        }
        if (string == "sessions") {
            return this.sessions;
        }
        if (string == "hidden") {
            return this.hidden;
        }
        if (string == "imageValues") {
            return this.imageValues;
        }
        if (string == "pins") {
            return this.pins;
        }
        if (string == "userIdentityProviders") {
            return this.userIdentityProviders;
        }
        if (string == "enumeratedValues") {
            return this.enumeratedValues;
        }
        if (string == "fileValues") {
            return this.fileValues;
        }
        if (string == "dynamicValues") {
            return this.dynamicValues;
        }
        if (string == "field") {
            return this.field;
        }
        if (string == "enumeratedValue") {
            return this.enumeratedValue;
        }
        if (string == "oidcAuthorization") {
            return this.oidcAuthorization;
        }
        if (string == "externalRedirectExecutions") {
            return this.externalRedirectExecutions;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "owner") {
            this.owner = (BasicUser)object;
            return;
        }
        if (string == "sessions") {
            this.sessions = (Set)object;
            return;
        }
        if (string == "hidden") {
            this.hidden = (Boolean)object;
            return;
        }
        if (string == "imageValues") {
            this.imageValues = (List)object;
            return;
        }
        if (string == "pins") {
            this.pins = (Set)object;
            return;
        }
        if (string == "userIdentityProviders") {
            this.userIdentityProviders = (Set)object;
            return;
        }
        if (string == "enumeratedValues") {
            this.enumeratedValues = (Set)object;
            return;
        }
        if (string == "fileValues") {
            this.fileValues = (List)object;
            return;
        }
        if (string == "dynamicValues") {
            this.dynamicValues = (Set)object;
            return;
        }
        if (string == "field") {
            this.field = (UserCustomField)object;
            return;
        }
        if (string == "enumeratedValue") {
            this.enumeratedValue = (UserCustomFieldPossibleValue)object;
            return;
        }
        if (string == "oidcAuthorization") {
            this.oidcAuthorization = (Set)object;
            return;
        }
        if (string == "externalRedirectExecutions") {
            this.externalRedirectExecutions = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_owner_vh() {
        if (this._persistence_owner_vh == null) {
            this._persistence_owner_vh = new ValueHolder((Object)this.owner);
            this._persistence_owner_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_owner_vh() {
        BasicUser basicUser;
        this._persistence_initialize_owner_vh();
        if ((this._persistence_owner_vh.isCoordinatedWithProperty() || this._persistence_owner_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_owner()) != this._persistence_owner_vh.getValue()) {
            this._persistence_set_owner(basicUser);
        }
        return this._persistence_owner_vh;
    }

    public void _persistence_set_owner_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_owner_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_owner();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_owner((BasicUser)object);
            }
        } else {
            this.owner = null;
        }
    }

    public BasicUser _persistence_get_owner() {
        this._persistence_checkFetched("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (BasicUser)this._persistence_owner_vh.getValue();
        return this.owner;
    }

    public void _persistence_set_owner(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (BasicUser)this._persistence_owner_vh.getValue();
        this.owner = basicUser;
        this._persistence_owner_vh.setValue((Object)basicUser);
    }

    public Set _persistence_get_sessions() {
        this._persistence_checkFetched("sessions");
        return this.sessions;
    }

    public void _persistence_set_sessions(Set set) {
        this._persistence_checkFetchedForSet("sessions");
        this.sessions = set;
    }

    public boolean _persistence_get_hidden() {
        this._persistence_checkFetched("hidden");
        return this.hidden;
    }

    public void _persistence_set_hidden(boolean bl) {
        this._persistence_checkFetchedForSet("hidden");
        this.hidden = bl;
    }

    public List _persistence_get_imageValues() {
        this._persistence_checkFetched("imageValues");
        return this.imageValues;
    }

    public void _persistence_set_imageValues(List list) {
        this._persistence_checkFetchedForSet("imageValues");
        this.imageValues = list;
    }

    public Set _persistence_get_pins() {
        this._persistence_checkFetched("pins");
        return this.pins;
    }

    public void _persistence_set_pins(Set set) {
        this._persistence_checkFetchedForSet("pins");
        this.pins = set;
    }

    public Set _persistence_get_userIdentityProviders() {
        this._persistence_checkFetched("userIdentityProviders");
        return this.userIdentityProviders;
    }

    public void _persistence_set_userIdentityProviders(Set set) {
        this._persistence_checkFetchedForSet("userIdentityProviders");
        this.userIdentityProviders = set;
    }

    public Set _persistence_get_enumeratedValues() {
        this._persistence_checkFetched("enumeratedValues");
        return this.enumeratedValues;
    }

    public void _persistence_set_enumeratedValues(Set set) {
        this._persistence_checkFetchedForSet("enumeratedValues");
        this.enumeratedValues = set;
    }

    public List _persistence_get_fileValues() {
        this._persistence_checkFetched("fileValues");
        return this.fileValues;
    }

    public void _persistence_set_fileValues(List list) {
        this._persistence_checkFetchedForSet("fileValues");
        this.fileValues = list;
    }

    public Set _persistence_get_dynamicValues() {
        this._persistence_checkFetched("dynamicValues");
        return this.dynamicValues;
    }

    public void _persistence_set_dynamicValues(Set set) {
        this._persistence_checkFetchedForSet("dynamicValues");
        this.dynamicValues = set;
    }

    protected void _persistence_initialize_field_vh() {
        if (this._persistence_field_vh == null) {
            this._persistence_field_vh = new ValueHolder((Object)this.field);
            this._persistence_field_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_field_vh() {
        UserCustomField userCustomField;
        this._persistence_initialize_field_vh();
        if ((this._persistence_field_vh.isCoordinatedWithProperty() || this._persistence_field_vh.isNewlyWeavedValueHolder()) && (userCustomField = this._persistence_get_field()) != this._persistence_field_vh.getValue()) {
            this._persistence_set_field(userCustomField);
        }
        return this._persistence_field_vh;
    }

    public void _persistence_set_field_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_field_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserCustomField userCustomField = this._persistence_get_field();
            if (userCustomField != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_field((UserCustomField)object);
            }
        } else {
            this.field = null;
        }
    }

    public UserCustomField _persistence_get_field() {
        this._persistence_checkFetched("field");
        this._persistence_initialize_field_vh();
        this.field = (UserCustomField)this._persistence_field_vh.getValue();
        return this.field;
    }

    public void _persistence_set_field(UserCustomField userCustomField) {
        this._persistence_checkFetchedForSet("field");
        this._persistence_initialize_field_vh();
        this.field = (UserCustomField)this._persistence_field_vh.getValue();
        this.field = userCustomField;
        this._persistence_field_vh.setValue((Object)userCustomField);
    }

    public UserCustomFieldPossibleValue _persistence_get_enumeratedValue() {
        this._persistence_checkFetched("enumeratedValue");
        return this.enumeratedValue;
    }

    public void _persistence_set_enumeratedValue(UserCustomFieldPossibleValue userCustomFieldPossibleValue) {
        this._persistence_checkFetchedForSet("enumeratedValue");
        this.enumeratedValue = userCustomFieldPossibleValue;
    }

    public Set _persistence_get_oidcAuthorization() {
        this._persistence_checkFetched("oidcAuthorization");
        return this.oidcAuthorization;
    }

    public void _persistence_set_oidcAuthorization(Set set) {
        this._persistence_checkFetchedForSet("oidcAuthorization");
        this.oidcAuthorization = set;
    }

    public Set _persistence_get_externalRedirectExecutions() {
        this._persistence_checkFetched("externalRedirectExecutions");
        return this.externalRedirectExecutions;
    }

    public void _persistence_set_externalRedirectExecutions(Set set) {
        this._persistence_checkFetchedForSet("externalRedirectExecutions");
        this.externalRedirectExecutions = set;
    }
}

