/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationOrderableEntity;
import org.cyclos.entities.MaxScale;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.model.IUnqualifiedInternalNamedEntity;
import org.cyclos.model.system.fields.CustomFieldControl;
import org.cyclos.model.system.fields.CustomFieldNature;
import org.cyclos.model.system.fields.CustomFieldSize;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.HasValueMatch;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.LinkedEntityType;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.system.scripts.UsesScript;
import org.cyclos.model.utils.FileMimeType;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@MappedSuperclass
public abstract class CustomField<CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>>
extends ConfigurationOrderableEntity
implements ICustomField,
HasValueMatch,
IUnqualifiedInternalNamedEntity,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="all_selected_label")
    private String allSelectedLabel;
    @Basic
    @Lob
    @Column(name="information_text")
    private String informationText;
    @Basic
    @Column(name="storage_directory")
    private String storageDirectory;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", updatable=false, nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private CustomFieldType type = CustomFieldType.STRING;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="control", nullable=false)
    private CustomFieldControl control = CustomFieldControl.TEXT;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="size")
    private CustomFieldSize size = CustomFieldSize.LARGE;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="linked_entity_type")
    @ReadOnlyFromDTO(onInsert=false)
    private LinkedEntityType linkedEntityType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="linked_entity_record_type_id")
    private RecordType linkedEntityRecordType;
    @Basic
    @Column(name="pattern")
    private String pattern;
    @Basic
    @Column(name="val_required", nullable=false)
    private boolean required;
    @Basic
    @Column(name="val_unique", nullable=false)
    private boolean unique;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="value_match")
    private ValueMatch valueMatch = ValueMatch.TEXT;
    @Basic
    @Column(name="decimal_digits")
    private Integer decimalDigits;
    @Basic
    @Column(name="expanded_categories", nullable=false)
    private boolean expandedCategories = true;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="load_values_script_id")
    private CustomScript loadValuesScript;
    @Basic
    @Lob
    @Column(name="load_values_script_parameters")
    private String loadValuesScriptParameters;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="validation_script_id")
    private CustomScript validationScript;
    @Basic
    @Lob
    @Column(name="validation_script_parameters")
    private String validationScriptParameters;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="val_min_length")), @AttributeOverride(name="max", column=@Column(name="val_max_length"))})
    private IntegerRange lengthConstraint;
    @Basic
    @Column(name="ignore_sanitizer", nullable=false)
    private boolean ignoreSanitizer;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="min_integer_value")), @AttributeOverride(name="max", column=@Column(name="max_integer_value"))})
    private IntegerRange integerValueRange;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="min_decimal_value")), @AttributeOverride(name="max", column=@Column(name="max_decimal_value"))})
    @MaxScale
    private DecimalRange decimalValueRange;
    @Basic
    @Column(name="max_word_size")
    private Integer maxWordSize = 100;
    @Basic
    @Column(name="default_boolean_value")
    private Boolean defaultBooleanValue;
    @Basic
    @Column(name="default_date_value")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date defaultDateValue;
    @Basic
    @Column(name="default_date_today")
    private Boolean defaultDateToday;
    @Basic
    @Column(name="default_decimal_value")
    @MaxScale
    private BigDecimal defaultDecimalValue;
    @Basic
    @Column(name="default_integer_value")
    private Integer defaultIntegerValue;
    @Basic
    @Column(name="default_string_value", length=4000)
    private String defaultStringValue;
    @Basic
    @Lob
    @Column(name="default_text_value")
    private String defaultTextValue;
    @Basic
    @Lob
    @Column(name="default_rich_text_value")
    private String defaultRichTextValue;
    @Basic
    @Column(name="max_files")
    private Integer maxFiles;
    @Transient
    private Set<FileMimeType> cachedAllowedMimeTypes;
    @Basic
    @Lob
    @Column(name="allowed_mime_types")
    private String allowedMimeTypes;
    @Basic
    @Lob
    @Column(name="other_mime_types")
    private String otherMimeTypes;
    @Basic
    @Column(name="show_qr_code_scan")
    private Boolean showQrCodeScan;
    static final long serialVersionUID = 5757474601643103989L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_validationScript_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_loadValuesScript_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_linkedEntityRecordType_vh;

    public Set<FileMimeType> getAllowedMimeTypes() {
        if (this.cachedAllowedMimeTypes == null) {
            this.cachedAllowedMimeTypes = EnumSet.noneOf(FileMimeType.class);
            StringHelper.splitTrimming((String)this._persistence_get_allowedMimeTypes(), (String)",").stream().map(FileMimeType::valueOf).forEach(this.cachedAllowedMimeTypes::add);
        }
        return this.cachedAllowedMimeTypes;
    }

    public String getAllSelectedLabel() {
        return this._persistence_get_allSelectedLabel();
    }

    public CustomFieldControl getControl() {
        return this._persistence_get_control();
    }

    public Integer getDecimalDigits() {
        return this._persistence_get_decimalDigits();
    }

    public DecimalRange getDecimalValueRange() {
        return this._persistence_get_decimalValueRange();
    }

    public Boolean getDefaultBooleanValue() {
        return this._persistence_get_defaultBooleanValue();
    }

    public Date getDefaultDateValue() {
        return this._persistence_get_defaultDateValue();
    }

    public BigDecimal getDefaultDecimalValue() {
        return this._persistence_get_defaultDecimalValue();
    }

    public Integer getDefaultIntegerValue() {
        return this._persistence_get_defaultIntegerValue();
    }

    public String getDefaultRichTextValue() {
        return this._persistence_get_defaultRichTextValue();
    }

    public String getDefaultStringValue() {
        return this._persistence_get_defaultStringValue();
    }

    public String getDefaultTextValue() {
        return this._persistence_get_defaultTextValue();
    }

    public String getInformationText() {
        return this._persistence_get_informationText();
    }

    public IntegerRange getIntegerValueRange() {
        return this._persistence_get_integerValueRange();
    }

    public IntegerRange getLengthConstraint() {
        return this._persistence_get_lengthConstraint();
    }

    public RecordType getLinkedEntityRecordType() {
        return this._persistence_get_linkedEntityRecordType();
    }

    public LinkedEntityType getLinkedEntityType() {
        return this._persistence_get_linkedEntityType();
    }

    public CustomScript getLoadValuesScript() {
        return this._persistence_get_loadValuesScript();
    }

    public String getLoadValuesScriptParameters() {
        return this._persistence_get_loadValuesScriptParameters();
    }

    public Integer getMaxFiles() {
        return this._persistence_get_maxFiles();
    }

    public Integer getMaxWordSize() {
        return this._persistence_get_maxWordSize();
    }

    public abstract CustomFieldNature getNature();

    public String getOtherMimeTypes() {
        return this._persistence_get_otherMimeTypes();
    }

    public String getPattern() {
        return this._persistence_get_pattern();
    }

    public abstract List<C> getPossibleValueCategories();

    public abstract Class<C> getPossibleValueCategoryClass();

    public abstract Class<PV> getPossibleValueClass();

    public abstract List<PV> getPossibleValues();

    public Boolean getShowQrCodeScan() {
        return this._persistence_get_showQrCodeScan();
    }

    public CustomFieldSize getSize() {
        return this._persistence_get_size();
    }

    public String getStorageDirectory() {
        return this._persistence_get_storageDirectory();
    }

    public CustomFieldType getType() {
        return this._persistence_get_type();
    }

    public CustomScript getValidationScript() {
        return this._persistence_get_validationScript();
    }

    public String getValidationScriptParameters() {
        return this._persistence_get_validationScriptParameters();
    }

    public ValueMatch getValueMatch() {
        return this._persistence_get_valueMatch();
    }

    public boolean isAllowedAsSearchFilter() {
        return this._persistence_get_type().isAllowedToBeOnSearchFilters();
    }

    public boolean isDefaultDateToday() {
        return Boolean.TRUE.equals(this._persistence_get_defaultDateToday());
    }

    public boolean isExactMatch() {
        return this._persistence_get_type() == CustomFieldType.URL || this._persistence_get_valueMatch() == null || this._persistence_get_valueMatch() == ValueMatch.EXACT;
    }

    public boolean isExpandedCategories() {
        return this._persistence_get_expandedCategories();
    }

    public boolean isIgnoreSanitizer() {
        return this._persistence_get_ignoreSanitizer();
    }

    public boolean isRequired() {
        return this._persistence_get_required();
    }

    public boolean isUnique() {
        return this._persistence_get_unique();
    }

    public void setAllowedMimeTypes(Set<FileMimeType> set) {
        this.cachedAllowedMimeTypes = EnumSet.noneOf(FileMimeType.class);
        this.cachedAllowedMimeTypes.addAll(CollectionHelper.orEmpty(set));
        this._persistence_set_allowedMimeTypes(StringHelper.join(this.cachedAllowedMimeTypes, (String)","));
    }

    public void setAllSelectedLabel(String string) {
        this._persistence_set_allSelectedLabel(string);
    }

    public void setControl(CustomFieldControl customFieldControl) {
        this._persistence_set_control(customFieldControl);
    }

    public void setDecimalDigits(Integer n) {
        this._persistence_set_decimalDigits(n);
    }

    public void setDecimalValueRange(DecimalRange decimalRange) {
        this._persistence_set_decimalValueRange(decimalRange);
    }

    public void setDefaultBooleanValue(Boolean bl) {
        this._persistence_set_defaultBooleanValue(bl);
    }

    public void setDefaultDateToday(boolean bl) {
        this._persistence_set_defaultDateToday(bl);
    }

    public void setDefaultDateValue(Date date) {
        this._persistence_set_defaultDateValue(date);
    }

    public void setDefaultDecimalValue(BigDecimal bigDecimal) {
        this._persistence_set_defaultDecimalValue(bigDecimal);
    }

    public void setDefaultIntegerValue(Integer n) {
        this._persistence_set_defaultIntegerValue(n);
    }

    public void setDefaultRichTextValue(String string) {
        this._persistence_set_defaultRichTextValue(string);
    }

    public void setDefaultStringValue(String string) {
        this._persistence_set_defaultStringValue(string);
    }

    public void setDefaultTextValue(String string) {
        this._persistence_set_defaultTextValue(string);
    }

    public void setExpandedCategories(boolean bl) {
        this._persistence_set_expandedCategories(bl);
    }

    public void setIgnoreSanitizer(boolean bl) {
        this._persistence_set_ignoreSanitizer(bl);
    }

    public void setInformationText(String string) {
        this._persistence_set_informationText(string);
    }

    public void setIntegerValueRange(IntegerRange integerRange) {
        this._persistence_set_integerValueRange(integerRange);
    }

    public void setLengthConstraint(IntegerRange integerRange) {
        this._persistence_set_lengthConstraint(integerRange);
    }

    public void setLinkedEntityRecordType(RecordType recordType) {
        this._persistence_set_linkedEntityRecordType(recordType);
    }

    public void setLinkedEntityType(LinkedEntityType linkedEntityType) {
        this._persistence_set_linkedEntityType(linkedEntityType);
    }

    public void setLoadValuesScript(CustomScript customScript) {
        this._persistence_set_loadValuesScript(customScript);
    }

    public void setLoadValuesScriptParameters(String string) {
        this._persistence_set_loadValuesScriptParameters(string);
    }

    public void setMaxFiles(Integer n) {
        this._persistence_set_maxFiles(n);
    }

    public void setMaxWordSize(Integer n) {
        this._persistence_set_maxWordSize(n);
    }

    public void setOtherMimeTypes(String string) {
        this._persistence_set_otherMimeTypes(string);
    }

    public void setPattern(String string) {
        this._persistence_set_pattern(string);
    }

    public void setRequired(boolean bl) {
        this._persistence_set_required(bl);
    }

    public void setShowQrCodeScan(Boolean bl) {
        this._persistence_set_showQrCodeScan(bl);
    }

    public void setSize(CustomFieldSize customFieldSize) {
        this._persistence_set_size(customFieldSize);
    }

    public void setStorageDirectory(String string) {
        this._persistence_set_storageDirectory(string);
    }

    public void setType(CustomFieldType customFieldType) {
        this._persistence_set_type(customFieldType);
    }

    public void setUnique(boolean bl) {
        this._persistence_set_unique(bl);
    }

    public void setValidationScript(CustomScript customScript) {
        this._persistence_set_validationScript(customScript);
    }

    public void setValidationScriptParameters(String string) {
        this._persistence_set_validationScriptParameters(string);
    }

    public void setValueMatch(ValueMatch valueMatch) {
        this._persistence_set_valueMatch(valueMatch);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_validationScript_vh != null) {
            this._persistence_validationScript_vh = (WeavedAttributeValueHolderInterface)this._persistence_validationScript_vh.clone();
        }
        if (this._persistence_loadValuesScript_vh != null) {
            this._persistence_loadValuesScript_vh = (WeavedAttributeValueHolderInterface)this._persistence_loadValuesScript_vh.clone();
        }
        if (this._persistence_linkedEntityRecordType_vh != null) {
            this._persistence_linkedEntityRecordType_vh = (WeavedAttributeValueHolderInterface)this._persistence_linkedEntityRecordType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomField<CF, C, PV>();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "allowedMimeTypes") {
            return this.allowedMimeTypes;
        }
        if (string == "linkedEntityType") {
            return this.linkedEntityType;
        }
        if (string == "pattern") {
            return this.pattern;
        }
        if (string == "validationScript") {
            return this.validationScript;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "required") {
            return this.required;
        }
        if (string == "valueMatch") {
            return this.valueMatch;
        }
        if (string == "defaultRichTextValue") {
            return this.defaultRichTextValue;
        }
        if (string == "defaultTextValue") {
            return this.defaultTextValue;
        }
        if (string == "expandedCategories") {
            return this.expandedCategories;
        }
        if (string == "decimalValueRange") {
            return this.decimalValueRange;
        }
        if (string == "loadValuesScript") {
            return this.loadValuesScript;
        }
        if (string == "lengthConstraint") {
            return this.lengthConstraint;
        }
        if (string == "informationText") {
            return this.informationText;
        }
        if (string == "defaultStringValue") {
            return this.defaultStringValue;
        }
        if (string == "maxFiles") {
            return this.maxFiles;
        }
        if (string == "integerValueRange") {
            return this.integerValueRange;
        }
        if (string == "validationScriptParameters") {
            return this.validationScriptParameters;
        }
        if (string == "storageDirectory") {
            return this.storageDirectory;
        }
        if (string == "defaultIntegerValue") {
            return this.defaultIntegerValue;
        }
        if (string == "control") {
            return this.control;
        }
        if (string == "defaultBooleanValue") {
            return this.defaultBooleanValue;
        }
        if (string == "showQrCodeScan") {
            return this.showQrCodeScan;
        }
        if (string == "defaultDateToday") {
            return this.defaultDateToday;
        }
        if (string == "size") {
            return this.size;
        }
        if (string == "unique") {
            return this.unique;
        }
        if (string == "ignoreSanitizer") {
            return this.ignoreSanitizer;
        }
        if (string == "otherMimeTypes") {
            return this.otherMimeTypes;
        }
        if (string == "loadValuesScriptParameters") {
            return this.loadValuesScriptParameters;
        }
        if (string == "decimalDigits") {
            return this.decimalDigits;
        }
        if (string == "defaultDateValue") {
            return this.defaultDateValue;
        }
        if (string == "defaultDecimalValue") {
            return this.defaultDecimalValue;
        }
        if (string == "linkedEntityRecordType") {
            return this.linkedEntityRecordType;
        }
        if (string == "allSelectedLabel") {
            return this.allSelectedLabel;
        }
        if (string == "maxWordSize") {
            return this.maxWordSize;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "allowedMimeTypes") {
            this.allowedMimeTypes = (String)object;
            return;
        }
        if (string == "linkedEntityType") {
            this.linkedEntityType = (LinkedEntityType)object;
            return;
        }
        if (string == "pattern") {
            this.pattern = (String)object;
            return;
        }
        if (string == "validationScript") {
            this.validationScript = (CustomScript)object;
            return;
        }
        if (string == "type") {
            this.type = (CustomFieldType)object;
            return;
        }
        if (string == "required") {
            this.required = (Boolean)object;
            return;
        }
        if (string == "valueMatch") {
            this.valueMatch = (ValueMatch)object;
            return;
        }
        if (string == "defaultRichTextValue") {
            this.defaultRichTextValue = (String)object;
            return;
        }
        if (string == "defaultTextValue") {
            this.defaultTextValue = (String)object;
            return;
        }
        if (string == "expandedCategories") {
            this.expandedCategories = (Boolean)object;
            return;
        }
        if (string == "decimalValueRange") {
            this.decimalValueRange = (DecimalRange)object;
            return;
        }
        if (string == "loadValuesScript") {
            this.loadValuesScript = (CustomScript)object;
            return;
        }
        if (string == "lengthConstraint") {
            this.lengthConstraint = (IntegerRange)object;
            return;
        }
        if (string == "informationText") {
            this.informationText = (String)object;
            return;
        }
        if (string == "defaultStringValue") {
            this.defaultStringValue = (String)object;
            return;
        }
        if (string == "maxFiles") {
            this.maxFiles = (Integer)object;
            return;
        }
        if (string == "integerValueRange") {
            this.integerValueRange = (IntegerRange)object;
            return;
        }
        if (string == "validationScriptParameters") {
            this.validationScriptParameters = (String)object;
            return;
        }
        if (string == "storageDirectory") {
            this.storageDirectory = (String)object;
            return;
        }
        if (string == "defaultIntegerValue") {
            this.defaultIntegerValue = (Integer)object;
            return;
        }
        if (string == "control") {
            this.control = (CustomFieldControl)object;
            return;
        }
        if (string == "defaultBooleanValue") {
            this.defaultBooleanValue = (Boolean)object;
            return;
        }
        if (string == "showQrCodeScan") {
            this.showQrCodeScan = (Boolean)object;
            return;
        }
        if (string == "defaultDateToday") {
            this.defaultDateToday = (Boolean)object;
            return;
        }
        if (string == "size") {
            this.size = (CustomFieldSize)object;
            return;
        }
        if (string == "unique") {
            this.unique = (Boolean)object;
            return;
        }
        if (string == "ignoreSanitizer") {
            this.ignoreSanitizer = (Boolean)object;
            return;
        }
        if (string == "otherMimeTypes") {
            this.otherMimeTypes = (String)object;
            return;
        }
        if (string == "loadValuesScriptParameters") {
            this.loadValuesScriptParameters = (String)object;
            return;
        }
        if (string == "decimalDigits") {
            this.decimalDigits = (Integer)object;
            return;
        }
        if (string == "defaultDateValue") {
            this.defaultDateValue = (Date)object;
            return;
        }
        if (string == "defaultDecimalValue") {
            this.defaultDecimalValue = (BigDecimal)object;
            return;
        }
        if (string == "linkedEntityRecordType") {
            this.linkedEntityRecordType = (RecordType)object;
            return;
        }
        if (string == "allSelectedLabel") {
            this.allSelectedLabel = (String)object;
            return;
        }
        if (string == "maxWordSize") {
            this.maxWordSize = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_allowedMimeTypes() {
        this._persistence_checkFetched("allowedMimeTypes");
        return this.allowedMimeTypes;
    }

    public void _persistence_set_allowedMimeTypes(String string) {
        this._persistence_checkFetchedForSet("allowedMimeTypes");
        this._persistence_propertyChange("allowedMimeTypes", this.allowedMimeTypes, string);
        this.allowedMimeTypes = string;
    }

    public LinkedEntityType _persistence_get_linkedEntityType() {
        this._persistence_checkFetched("linkedEntityType");
        return this.linkedEntityType;
    }

    public void _persistence_set_linkedEntityType(LinkedEntityType linkedEntityType) {
        this._persistence_checkFetchedForSet("linkedEntityType");
        this._persistence_propertyChange("linkedEntityType", this.linkedEntityType, linkedEntityType);
        this.linkedEntityType = linkedEntityType;
    }

    public String _persistence_get_pattern() {
        this._persistence_checkFetched("pattern");
        return this.pattern;
    }

    public void _persistence_set_pattern(String string) {
        this._persistence_checkFetchedForSet("pattern");
        this._persistence_propertyChange("pattern", this.pattern, string);
        this.pattern = string;
    }

    protected void _persistence_initialize_validationScript_vh() {
        if (this._persistence_validationScript_vh == null) {
            this._persistence_validationScript_vh = new ValueHolder((Object)this.validationScript);
            this._persistence_validationScript_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_validationScript_vh() {
        CustomScript customScript;
        this._persistence_initialize_validationScript_vh();
        if ((this._persistence_validationScript_vh.isCoordinatedWithProperty() || this._persistence_validationScript_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_validationScript()) != this._persistence_validationScript_vh.getValue()) {
            this._persistence_set_validationScript(customScript);
        }
        return this._persistence_validationScript_vh;
    }

    public void _persistence_set_validationScript_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_validationScript_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_validationScript();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_validationScript((CustomScript)object);
            }
        } else {
            this.validationScript = null;
        }
    }

    public CustomScript _persistence_get_validationScript() {
        this._persistence_checkFetched("validationScript");
        this._persistence_initialize_validationScript_vh();
        this.validationScript = (CustomScript)this._persistence_validationScript_vh.getValue();
        return this.validationScript;
    }

    public void _persistence_set_validationScript(CustomScript customScript) {
        this._persistence_checkFetchedForSet("validationScript");
        this._persistence_initialize_validationScript_vh();
        this.validationScript = (CustomScript)this._persistence_validationScript_vh.getValue();
        this._persistence_propertyChange("validationScript", this.validationScript, customScript);
        this.validationScript = customScript;
        this._persistence_validationScript_vh.setValue((Object)customScript);
    }

    public CustomFieldType _persistence_get_type() {
        this._persistence_checkFetched("type");
        return this.type;
    }

    public void _persistence_set_type(CustomFieldType customFieldType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_propertyChange("type", this.type, customFieldType);
        this.type = customFieldType;
    }

    public boolean _persistence_get_required() {
        this._persistence_checkFetched("required");
        return this.required;
    }

    public void _persistence_set_required(boolean bl) {
        this._persistence_checkFetchedForSet("required");
        this._persistence_propertyChange("required", new Boolean(this.required), new Boolean(bl));
        this.required = bl;
    }

    public ValueMatch _persistence_get_valueMatch() {
        this._persistence_checkFetched("valueMatch");
        return this.valueMatch;
    }

    public void _persistence_set_valueMatch(ValueMatch valueMatch) {
        this._persistence_checkFetchedForSet("valueMatch");
        this._persistence_propertyChange("valueMatch", this.valueMatch, valueMatch);
        this.valueMatch = valueMatch;
    }

    public String _persistence_get_defaultRichTextValue() {
        this._persistence_checkFetched("defaultRichTextValue");
        return this.defaultRichTextValue;
    }

    public void _persistence_set_defaultRichTextValue(String string) {
        this._persistence_checkFetchedForSet("defaultRichTextValue");
        this._persistence_propertyChange("defaultRichTextValue", this.defaultRichTextValue, string);
        this.defaultRichTextValue = string;
    }

    public String _persistence_get_defaultTextValue() {
        this._persistence_checkFetched("defaultTextValue");
        return this.defaultTextValue;
    }

    public void _persistence_set_defaultTextValue(String string) {
        this._persistence_checkFetchedForSet("defaultTextValue");
        this._persistence_propertyChange("defaultTextValue", this.defaultTextValue, string);
        this.defaultTextValue = string;
    }

    public boolean _persistence_get_expandedCategories() {
        this._persistence_checkFetched("expandedCategories");
        return this.expandedCategories;
    }

    public void _persistence_set_expandedCategories(boolean bl) {
        this._persistence_checkFetchedForSet("expandedCategories");
        this._persistence_propertyChange("expandedCategories", new Boolean(this.expandedCategories), new Boolean(bl));
        this.expandedCategories = bl;
    }

    public DecimalRange _persistence_get_decimalValueRange() {
        this._persistence_checkFetched("decimalValueRange");
        return this.decimalValueRange;
    }

    public void _persistence_set_decimalValueRange(DecimalRange decimalRange) {
        this._persistence_checkFetchedForSet("decimalValueRange");
        this._persistence_propertyChange("decimalValueRange", this.decimalValueRange, decimalRange);
        this.decimalValueRange = decimalRange;
    }

    protected void _persistence_initialize_loadValuesScript_vh() {
        if (this._persistence_loadValuesScript_vh == null) {
            this._persistence_loadValuesScript_vh = new ValueHolder((Object)this.loadValuesScript);
            this._persistence_loadValuesScript_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_loadValuesScript_vh() {
        CustomScript customScript;
        this._persistence_initialize_loadValuesScript_vh();
        if ((this._persistence_loadValuesScript_vh.isCoordinatedWithProperty() || this._persistence_loadValuesScript_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_loadValuesScript()) != this._persistence_loadValuesScript_vh.getValue()) {
            this._persistence_set_loadValuesScript(customScript);
        }
        return this._persistence_loadValuesScript_vh;
    }

    public void _persistence_set_loadValuesScript_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_loadValuesScript_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_loadValuesScript();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_loadValuesScript((CustomScript)object);
            }
        } else {
            this.loadValuesScript = null;
        }
    }

    public CustomScript _persistence_get_loadValuesScript() {
        this._persistence_checkFetched("loadValuesScript");
        this._persistence_initialize_loadValuesScript_vh();
        this.loadValuesScript = (CustomScript)this._persistence_loadValuesScript_vh.getValue();
        return this.loadValuesScript;
    }

    public void _persistence_set_loadValuesScript(CustomScript customScript) {
        this._persistence_checkFetchedForSet("loadValuesScript");
        this._persistence_initialize_loadValuesScript_vh();
        this.loadValuesScript = (CustomScript)this._persistence_loadValuesScript_vh.getValue();
        this._persistence_propertyChange("loadValuesScript", this.loadValuesScript, customScript);
        this.loadValuesScript = customScript;
        this._persistence_loadValuesScript_vh.setValue((Object)customScript);
    }

    public IntegerRange _persistence_get_lengthConstraint() {
        this._persistence_checkFetched("lengthConstraint");
        return this.lengthConstraint;
    }

    public void _persistence_set_lengthConstraint(IntegerRange integerRange) {
        this._persistence_checkFetchedForSet("lengthConstraint");
        this._persistence_propertyChange("lengthConstraint", this.lengthConstraint, integerRange);
        this.lengthConstraint = integerRange;
    }

    public String _persistence_get_informationText() {
        this._persistence_checkFetched("informationText");
        return this.informationText;
    }

    public void _persistence_set_informationText(String string) {
        this._persistence_checkFetchedForSet("informationText");
        this._persistence_propertyChange("informationText", this.informationText, string);
        this.informationText = string;
    }

    public String _persistence_get_defaultStringValue() {
        this._persistence_checkFetched("defaultStringValue");
        return this.defaultStringValue;
    }

    public void _persistence_set_defaultStringValue(String string) {
        this._persistence_checkFetchedForSet("defaultStringValue");
        this._persistence_propertyChange("defaultStringValue", this.defaultStringValue, string);
        this.defaultStringValue = string;
    }

    public Integer _persistence_get_maxFiles() {
        this._persistence_checkFetched("maxFiles");
        return this.maxFiles;
    }

    public void _persistence_set_maxFiles(Integer n) {
        this._persistence_checkFetchedForSet("maxFiles");
        this._persistence_propertyChange("maxFiles", this.maxFiles, n);
        this.maxFiles = n;
    }

    public IntegerRange _persistence_get_integerValueRange() {
        this._persistence_checkFetched("integerValueRange");
        return this.integerValueRange;
    }

    public void _persistence_set_integerValueRange(IntegerRange integerRange) {
        this._persistence_checkFetchedForSet("integerValueRange");
        this._persistence_propertyChange("integerValueRange", this.integerValueRange, integerRange);
        this.integerValueRange = integerRange;
    }

    public String _persistence_get_validationScriptParameters() {
        this._persistence_checkFetched("validationScriptParameters");
        return this.validationScriptParameters;
    }

    public void _persistence_set_validationScriptParameters(String string) {
        this._persistence_checkFetchedForSet("validationScriptParameters");
        this._persistence_propertyChange("validationScriptParameters", this.validationScriptParameters, string);
        this.validationScriptParameters = string;
    }

    public String _persistence_get_storageDirectory() {
        this._persistence_checkFetched("storageDirectory");
        return this.storageDirectory;
    }

    public void _persistence_set_storageDirectory(String string) {
        this._persistence_checkFetchedForSet("storageDirectory");
        this._persistence_propertyChange("storageDirectory", this.storageDirectory, string);
        this.storageDirectory = string;
    }

    public Integer _persistence_get_defaultIntegerValue() {
        this._persistence_checkFetched("defaultIntegerValue");
        return this.defaultIntegerValue;
    }

    public void _persistence_set_defaultIntegerValue(Integer n) {
        this._persistence_checkFetchedForSet("defaultIntegerValue");
        this._persistence_propertyChange("defaultIntegerValue", this.defaultIntegerValue, n);
        this.defaultIntegerValue = n;
    }

    public CustomFieldControl _persistence_get_control() {
        this._persistence_checkFetched("control");
        return this.control;
    }

    public void _persistence_set_control(CustomFieldControl customFieldControl) {
        this._persistence_checkFetchedForSet("control");
        this._persistence_propertyChange("control", this.control, customFieldControl);
        this.control = customFieldControl;
    }

    public Boolean _persistence_get_defaultBooleanValue() {
        this._persistence_checkFetched("defaultBooleanValue");
        return this.defaultBooleanValue;
    }

    public void _persistence_set_defaultBooleanValue(Boolean bl) {
        this._persistence_checkFetchedForSet("defaultBooleanValue");
        this._persistence_propertyChange("defaultBooleanValue", this.defaultBooleanValue, bl);
        this.defaultBooleanValue = bl;
    }

    public Boolean _persistence_get_showQrCodeScan() {
        this._persistence_checkFetched("showQrCodeScan");
        return this.showQrCodeScan;
    }

    public void _persistence_set_showQrCodeScan(Boolean bl) {
        this._persistence_checkFetchedForSet("showQrCodeScan");
        this._persistence_propertyChange("showQrCodeScan", this.showQrCodeScan, bl);
        this.showQrCodeScan = bl;
    }

    public Boolean _persistence_get_defaultDateToday() {
        this._persistence_checkFetched("defaultDateToday");
        return this.defaultDateToday;
    }

    public void _persistence_set_defaultDateToday(Boolean bl) {
        this._persistence_checkFetchedForSet("defaultDateToday");
        this._persistence_propertyChange("defaultDateToday", this.defaultDateToday, bl);
        this.defaultDateToday = bl;
    }

    public CustomFieldSize _persistence_get_size() {
        this._persistence_checkFetched("size");
        return this.size;
    }

    public void _persistence_set_size(CustomFieldSize customFieldSize) {
        this._persistence_checkFetchedForSet("size");
        this._persistence_propertyChange("size", this.size, customFieldSize);
        this.size = customFieldSize;
    }

    public boolean _persistence_get_unique() {
        this._persistence_checkFetched("unique");
        return this.unique;
    }

    public void _persistence_set_unique(boolean bl) {
        this._persistence_checkFetchedForSet("unique");
        this._persistence_propertyChange("unique", new Boolean(this.unique), new Boolean(bl));
        this.unique = bl;
    }

    public boolean _persistence_get_ignoreSanitizer() {
        this._persistence_checkFetched("ignoreSanitizer");
        return this.ignoreSanitizer;
    }

    public void _persistence_set_ignoreSanitizer(boolean bl) {
        this._persistence_checkFetchedForSet("ignoreSanitizer");
        this._persistence_propertyChange("ignoreSanitizer", new Boolean(this.ignoreSanitizer), new Boolean(bl));
        this.ignoreSanitizer = bl;
    }

    public String _persistence_get_otherMimeTypes() {
        this._persistence_checkFetched("otherMimeTypes");
        return this.otherMimeTypes;
    }

    public void _persistence_set_otherMimeTypes(String string) {
        this._persistence_checkFetchedForSet("otherMimeTypes");
        this._persistence_propertyChange("otherMimeTypes", this.otherMimeTypes, string);
        this.otherMimeTypes = string;
    }

    public String _persistence_get_loadValuesScriptParameters() {
        this._persistence_checkFetched("loadValuesScriptParameters");
        return this.loadValuesScriptParameters;
    }

    public void _persistence_set_loadValuesScriptParameters(String string) {
        this._persistence_checkFetchedForSet("loadValuesScriptParameters");
        this._persistence_propertyChange("loadValuesScriptParameters", this.loadValuesScriptParameters, string);
        this.loadValuesScriptParameters = string;
    }

    public Integer _persistence_get_decimalDigits() {
        this._persistence_checkFetched("decimalDigits");
        return this.decimalDigits;
    }

    public void _persistence_set_decimalDigits(Integer n) {
        this._persistence_checkFetchedForSet("decimalDigits");
        this._persistence_propertyChange("decimalDigits", this.decimalDigits, n);
        this.decimalDigits = n;
    }

    public Date _persistence_get_defaultDateValue() {
        this._persistence_checkFetched("defaultDateValue");
        return this.defaultDateValue;
    }

    public void _persistence_set_defaultDateValue(Date date) {
        this._persistence_checkFetchedForSet("defaultDateValue");
        this._persistence_propertyChange("defaultDateValue", this.defaultDateValue, date);
        this.defaultDateValue = date;
    }

    public BigDecimal _persistence_get_defaultDecimalValue() {
        this._persistence_checkFetched("defaultDecimalValue");
        return this.defaultDecimalValue;
    }

    public void _persistence_set_defaultDecimalValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("defaultDecimalValue");
        this._persistence_propertyChange("defaultDecimalValue", this.defaultDecimalValue, bigDecimal);
        this.defaultDecimalValue = bigDecimal;
    }

    protected void _persistence_initialize_linkedEntityRecordType_vh() {
        if (this._persistence_linkedEntityRecordType_vh == null) {
            this._persistence_linkedEntityRecordType_vh = new ValueHolder((Object)this.linkedEntityRecordType);
            this._persistence_linkedEntityRecordType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_linkedEntityRecordType_vh() {
        RecordType recordType;
        this._persistence_initialize_linkedEntityRecordType_vh();
        if ((this._persistence_linkedEntityRecordType_vh.isCoordinatedWithProperty() || this._persistence_linkedEntityRecordType_vh.isNewlyWeavedValueHolder()) && (recordType = this._persistence_get_linkedEntityRecordType()) != this._persistence_linkedEntityRecordType_vh.getValue()) {
            this._persistence_set_linkedEntityRecordType(recordType);
        }
        return this._persistence_linkedEntityRecordType_vh;
    }

    public void _persistence_set_linkedEntityRecordType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_linkedEntityRecordType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            RecordType recordType = this._persistence_get_linkedEntityRecordType();
            if (recordType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_linkedEntityRecordType((RecordType)object);
            }
        } else {
            this.linkedEntityRecordType = null;
        }
    }

    public RecordType _persistence_get_linkedEntityRecordType() {
        this._persistence_checkFetched("linkedEntityRecordType");
        this._persistence_initialize_linkedEntityRecordType_vh();
        this.linkedEntityRecordType = (RecordType)this._persistence_linkedEntityRecordType_vh.getValue();
        return this.linkedEntityRecordType;
    }

    public void _persistence_set_linkedEntityRecordType(RecordType recordType) {
        this._persistence_checkFetchedForSet("linkedEntityRecordType");
        this._persistence_initialize_linkedEntityRecordType_vh();
        this.linkedEntityRecordType = (RecordType)this._persistence_linkedEntityRecordType_vh.getValue();
        this._persistence_propertyChange("linkedEntityRecordType", this.linkedEntityRecordType, recordType);
        this.linkedEntityRecordType = recordType;
        this._persistence_linkedEntityRecordType_vh.setValue((Object)recordType);
    }

    public String _persistence_get_allSelectedLabel() {
        this._persistence_checkFetched("allSelectedLabel");
        return this.allSelectedLabel;
    }

    public void _persistence_set_allSelectedLabel(String string) {
        this._persistence_checkFetchedForSet("allSelectedLabel");
        this._persistence_propertyChange("allSelectedLabel", this.allSelectedLabel, string);
        this.allSelectedLabel = string;
    }

    public Integer _persistence_get_maxWordSize() {
        this._persistence_checkFetched("maxWordSize");
        return this.maxWordSize;
    }

    public void _persistence_set_maxWordSize(Integer n) {
        this._persistence_checkFetchedForSet("maxWordSize");
        this._persistence_propertyChange("maxWordSize", this.maxWordSize, n);
        this.maxWordSize = n;
    }
}

